# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PostgresflexInstanceArgs', 'PostgresflexInstance']

@pulumi.input_type
class PostgresflexInstanceArgs:
    def __init__(__self__, *,
                 acls: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 backup_schedule: pulumi.Input[_builtins.str],
                 flavor: pulumi.Input['PostgresflexInstanceFlavorArgs'],
                 project_id: pulumi.Input[_builtins.str],
                 replicas: pulumi.Input[_builtins.int],
                 storage: pulumi.Input['PostgresflexInstanceStorageArgs'],
                 version: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PostgresflexInstance resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acls: The Access Control List (ACL) for the PostgresFlex instance.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the instance is associated.
        :param pulumi.Input[_builtins.str] name: Instance name.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        """
        pulumi.set(__self__, "acls", acls)
        pulumi.set(__self__, "backup_schedule", backup_schedule)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "replicas", replicas)
        pulumi.set(__self__, "storage", storage)
        pulumi.set(__self__, "version", version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def acls(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The Access Control List (ACL) for the PostgresFlex instance.
        """
        return pulumi.get(self, "acls")

    @acls.setter
    def acls(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "acls", value)

    @_builtins.property
    @pulumi.getter(name="backupSchedule")
    def backup_schedule(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "backup_schedule")

    @backup_schedule.setter
    def backup_schedule(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backup_schedule", value)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> pulumi.Input['PostgresflexInstanceFlavorArgs']:
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input['PostgresflexInstanceFlavorArgs']):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT project ID to which the instance is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> pulumi.Input[_builtins.int]:
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "replicas", value)

    @_builtins.property
    @pulumi.getter
    def storage(self) -> pulumi.Input['PostgresflexInstanceStorageArgs']:
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: pulumi.Input['PostgresflexInstanceStorageArgs']):
        pulumi.set(self, "storage", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _PostgresflexInstanceState:
    def __init__(__self__, *,
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input['PostgresflexInstanceFlavorArgs']] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replicas: Optional[pulumi.Input[_builtins.int]] = None,
                 storage: Optional[pulumi.Input['PostgresflexInstanceStorageArgs']] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PostgresflexInstance resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acls: The Access Control List (ACL) for the PostgresFlex instance.
        :param pulumi.Input[_builtins.str] instance_id: ID of the PostgresFlex instance.
        :param pulumi.Input[_builtins.str] name: Instance name.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the instance is associated.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        """
        if acls is not None:
            pulumi.set(__self__, "acls", acls)
        if backup_schedule is not None:
            pulumi.set(__self__, "backup_schedule", backup_schedule)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def acls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The Access Control List (ACL) for the PostgresFlex instance.
        """
        return pulumi.get(self, "acls")

    @acls.setter
    def acls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "acls", value)

    @_builtins.property
    @pulumi.getter(name="backupSchedule")
    def backup_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "backup_schedule")

    @backup_schedule.setter
    def backup_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_schedule", value)

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input['PostgresflexInstanceFlavorArgs']]:
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input['PostgresflexInstanceFlavorArgs']]):
        pulumi.set(self, "flavor", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the PostgresFlex instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT project ID to which the instance is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replicas", value)

    @_builtins.property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input['PostgresflexInstanceStorageArgs']]:
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input['PostgresflexInstanceStorageArgs']]):
        pulumi.set(self, "storage", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("stackit:index/postgresflexInstance:PostgresflexInstance")
class PostgresflexInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input[Union['PostgresflexInstanceFlavorArgs', 'PostgresflexInstanceFlavorArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replicas: Optional[pulumi.Input[_builtins.int]] = None,
                 storage: Optional[pulumi.Input[Union['PostgresflexInstanceStorageArgs', 'PostgresflexInstanceStorageArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Postgres Flex instance resource schema. Must have a `region` specified in the provider configuration.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acls: The Access Control List (ACL) for the PostgresFlex instance.
        :param pulumi.Input[_builtins.str] name: Instance name.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the instance is associated.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PostgresflexInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Postgres Flex instance resource schema. Must have a `region` specified in the provider configuration.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param PostgresflexInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PostgresflexInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 backup_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor: Optional[pulumi.Input[Union['PostgresflexInstanceFlavorArgs', 'PostgresflexInstanceFlavorArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replicas: Optional[pulumi.Input[_builtins.int]] = None,
                 storage: Optional[pulumi.Input[Union['PostgresflexInstanceStorageArgs', 'PostgresflexInstanceStorageArgsDict']]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PostgresflexInstanceArgs.__new__(PostgresflexInstanceArgs)

            if acls is None and not opts.urn:
                raise TypeError("Missing required property 'acls'")
            __props__.__dict__["acls"] = acls
            if backup_schedule is None and not opts.urn:
                raise TypeError("Missing required property 'backup_schedule'")
            __props__.__dict__["backup_schedule"] = backup_schedule
            if flavor is None and not opts.urn:
                raise TypeError("Missing required property 'flavor'")
            __props__.__dict__["flavor"] = flavor
            __props__.__dict__["name"] = name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            if replicas is None and not opts.urn:
                raise TypeError("Missing required property 'replicas'")
            __props__.__dict__["replicas"] = replicas
            if storage is None and not opts.urn:
                raise TypeError("Missing required property 'storage'")
            __props__.__dict__["storage"] = storage
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["instance_id"] = None
        super(PostgresflexInstance, __self__).__init__(
            'stackit:index/postgresflexInstance:PostgresflexInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acls: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            backup_schedule: Optional[pulumi.Input[_builtins.str]] = None,
            flavor: Optional[pulumi.Input[Union['PostgresflexInstanceFlavorArgs', 'PostgresflexInstanceFlavorArgsDict']]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            replicas: Optional[pulumi.Input[_builtins.int]] = None,
            storage: Optional[pulumi.Input[Union['PostgresflexInstanceStorageArgs', 'PostgresflexInstanceStorageArgsDict']]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'PostgresflexInstance':
        """
        Get an existing PostgresflexInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] acls: The Access Control List (ACL) for the PostgresFlex instance.
        :param pulumi.Input[_builtins.str] instance_id: ID of the PostgresFlex instance.
        :param pulumi.Input[_builtins.str] name: Instance name.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the instance is associated.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PostgresflexInstanceState.__new__(_PostgresflexInstanceState)

        __props__.__dict__["acls"] = acls
        __props__.__dict__["backup_schedule"] = backup_schedule
        __props__.__dict__["flavor"] = flavor
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["replicas"] = replicas
        __props__.__dict__["storage"] = storage
        __props__.__dict__["version"] = version
        return PostgresflexInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def acls(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The Access Control List (ACL) for the PostgresFlex instance.
        """
        return pulumi.get(self, "acls")

    @_builtins.property
    @pulumi.getter(name="backupSchedule")
    def backup_schedule(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "backup_schedule")

    @_builtins.property
    @pulumi.getter
    def flavor(self) -> pulumi.Output['outputs.PostgresflexInstanceFlavor']:
        return pulumi.get(self, "flavor")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the PostgresFlex instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Instance name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT project ID to which the instance is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter
    def storage(self) -> pulumi.Output['outputs.PostgresflexInstanceStorage']:
        return pulumi.get(self, "storage")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "version")

