# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 authorization_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 cdn_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials_path: Optional[pulumi.Input[_builtins.str]] = None,
                 default_region: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_beta_resources: Optional[pulumi.Input[_builtins.bool]] = None,
                 experiments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 git_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 iaas_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 loadbalancer_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 logme_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 mariadb_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 modelserving_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 mongodbflex_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 objectstorage_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 observability_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 opensearch_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 postgresflex_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_path: Optional[pulumi.Input[_builtins.str]] = None,
                 rabbitmq_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 redis_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resourcemanager_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 secretsmanager_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 server_backup_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 server_update_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_key: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_key_path: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_token: Optional[pulumi.Input[_builtins.str]] = None,
                 service_enablement_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 ske_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 sqlserverflex_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 token_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[_builtins.str] authorization_custom_endpoint: Custom endpoint for the Membership service
        :param pulumi.Input[_builtins.str] cdn_custom_endpoint: Custom endpoint for the CDN service
        :param pulumi.Input[_builtins.str] credentials_path: Path of JSON from where the credentials are read. Takes precedence over the env var `STACKIT_CREDENTIALS_PATH`. Default
               value is `~/.stackit/credentials.json`.
        :param pulumi.Input[_builtins.str] default_region: Region will be used as the default location for regional services. Not all services require a region, some are global
        :param pulumi.Input[_builtins.str] dns_custom_endpoint: Custom endpoint for the DNS service
        :param pulumi.Input[_builtins.bool] enable_beta_resources: Enable beta resources. Default is false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] experiments: Enables experiments. These are unstable features without official support. More information can be found in the README.
               Available Experiments: iam, routing-tables, network
        :param pulumi.Input[_builtins.str] git_custom_endpoint: Custom endpoint for the Git service
        :param pulumi.Input[_builtins.str] iaas_custom_endpoint: Custom endpoint for the IaaS service
        :param pulumi.Input[_builtins.str] loadbalancer_custom_endpoint: Custom endpoint for the Load Balancer service
        :param pulumi.Input[_builtins.str] logme_custom_endpoint: Custom endpoint for the LogMe service
        :param pulumi.Input[_builtins.str] mariadb_custom_endpoint: Custom endpoint for the MariaDB service
        :param pulumi.Input[_builtins.str] modelserving_custom_endpoint: Custom endpoint for the AI Model Serving service
        :param pulumi.Input[_builtins.str] mongodbflex_custom_endpoint: Custom endpoint for the MongoDB Flex service
        :param pulumi.Input[_builtins.str] objectstorage_custom_endpoint: Custom endpoint for the Object Storage service
        :param pulumi.Input[_builtins.str] observability_custom_endpoint: Custom endpoint for the Observability service
        :param pulumi.Input[_builtins.str] opensearch_custom_endpoint: Custom endpoint for the OpenSearch service
        :param pulumi.Input[_builtins.str] postgresflex_custom_endpoint: Custom endpoint for the PostgresFlex service
        :param pulumi.Input[_builtins.str] private_key: Private RSA key used for authentication, relevant for the key flow. It takes precedence over the private key that is
               included in the service account key.
        :param pulumi.Input[_builtins.str] private_key_path: Path for the private RSA key used for authentication, relevant for the key flow. It takes precedence over the private
               key that is included in the service account key.
        :param pulumi.Input[_builtins.str] rabbitmq_custom_endpoint: Custom endpoint for the RabbitMQ service
        :param pulumi.Input[_builtins.str] redis_custom_endpoint: Custom endpoint for the Redis service
        :param pulumi.Input[_builtins.str] region: Region will be used as the default location for regional services. Not all services require a region, some are global
        :param pulumi.Input[_builtins.str] resourcemanager_custom_endpoint: Custom endpoint for the Resource Manager service
        :param pulumi.Input[_builtins.str] secretsmanager_custom_endpoint: Custom endpoint for the Secrets Manager service
        :param pulumi.Input[_builtins.str] server_backup_custom_endpoint: Custom endpoint for the Server Backup service
        :param pulumi.Input[_builtins.str] server_update_custom_endpoint: Custom endpoint for the Server Update service
        :param pulumi.Input[_builtins.str] service_account_custom_endpoint: Custom endpoint for the Service Account service
        :param pulumi.Input[_builtins.str] service_account_email: Service account email. It can also be set using the environment variable STACKIT_SERVICE_ACCOUNT_EMAIL. It is required
               if you want to use the resource manager project resource.
        :param pulumi.Input[_builtins.str] service_account_key: Service account key used for authentication. If set, the key flow will be used to authenticate all operations.
        :param pulumi.Input[_builtins.str] service_account_key_path: Path for the service account key used for authentication. If set, the key flow will be used to authenticate all
               operations.
        :param pulumi.Input[_builtins.str] service_account_token: Token used for authentication. If set, the token flow will be used to authenticate all operations.
        :param pulumi.Input[_builtins.str] service_enablement_custom_endpoint: Custom endpoint for the Service Enablement API
        :param pulumi.Input[_builtins.str] ske_custom_endpoint: Custom endpoint for the Kubernetes Engine (SKE) service
        :param pulumi.Input[_builtins.str] sqlserverflex_custom_endpoint: Custom endpoint for the SQL Server Flex service
        :param pulumi.Input[_builtins.str] token_custom_endpoint: Custom endpoint for the token API, which is used to request access tokens when using the key flow
        """
        if authorization_custom_endpoint is not None:
            pulumi.set(__self__, "authorization_custom_endpoint", authorization_custom_endpoint)
        if cdn_custom_endpoint is not None:
            pulumi.set(__self__, "cdn_custom_endpoint", cdn_custom_endpoint)
        if credentials_path is not None:
            pulumi.set(__self__, "credentials_path", credentials_path)
        if default_region is not None:
            pulumi.set(__self__, "default_region", default_region)
        if dns_custom_endpoint is not None:
            pulumi.set(__self__, "dns_custom_endpoint", dns_custom_endpoint)
        if enable_beta_resources is not None:
            pulumi.set(__self__, "enable_beta_resources", enable_beta_resources)
        if experiments is not None:
            pulumi.set(__self__, "experiments", experiments)
        if git_custom_endpoint is not None:
            pulumi.set(__self__, "git_custom_endpoint", git_custom_endpoint)
        if iaas_custom_endpoint is not None:
            pulumi.set(__self__, "iaas_custom_endpoint", iaas_custom_endpoint)
        if loadbalancer_custom_endpoint is not None:
            pulumi.set(__self__, "loadbalancer_custom_endpoint", loadbalancer_custom_endpoint)
        if logme_custom_endpoint is not None:
            pulumi.set(__self__, "logme_custom_endpoint", logme_custom_endpoint)
        if mariadb_custom_endpoint is not None:
            pulumi.set(__self__, "mariadb_custom_endpoint", mariadb_custom_endpoint)
        if modelserving_custom_endpoint is not None:
            pulumi.set(__self__, "modelserving_custom_endpoint", modelserving_custom_endpoint)
        if mongodbflex_custom_endpoint is not None:
            pulumi.set(__self__, "mongodbflex_custom_endpoint", mongodbflex_custom_endpoint)
        if objectstorage_custom_endpoint is not None:
            pulumi.set(__self__, "objectstorage_custom_endpoint", objectstorage_custom_endpoint)
        if observability_custom_endpoint is not None:
            pulumi.set(__self__, "observability_custom_endpoint", observability_custom_endpoint)
        if opensearch_custom_endpoint is not None:
            pulumi.set(__self__, "opensearch_custom_endpoint", opensearch_custom_endpoint)
        if postgresflex_custom_endpoint is not None:
            pulumi.set(__self__, "postgresflex_custom_endpoint", postgresflex_custom_endpoint)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_path is not None:
            pulumi.set(__self__, "private_key_path", private_key_path)
        if rabbitmq_custom_endpoint is not None:
            pulumi.set(__self__, "rabbitmq_custom_endpoint", rabbitmq_custom_endpoint)
        if redis_custom_endpoint is not None:
            pulumi.set(__self__, "redis_custom_endpoint", redis_custom_endpoint)
        if region is not None:
            warnings.warn("""This attribute is deprecated. Use 'default_region' instead""", DeprecationWarning)
            pulumi.log.warn("""region is deprecated: This attribute is deprecated. Use 'default_region' instead""")
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resourcemanager_custom_endpoint is not None:
            pulumi.set(__self__, "resourcemanager_custom_endpoint", resourcemanager_custom_endpoint)
        if secretsmanager_custom_endpoint is not None:
            pulumi.set(__self__, "secretsmanager_custom_endpoint", secretsmanager_custom_endpoint)
        if server_backup_custom_endpoint is not None:
            pulumi.set(__self__, "server_backup_custom_endpoint", server_backup_custom_endpoint)
        if server_update_custom_endpoint is not None:
            pulumi.set(__self__, "server_update_custom_endpoint", server_update_custom_endpoint)
        if service_account_custom_endpoint is not None:
            pulumi.set(__self__, "service_account_custom_endpoint", service_account_custom_endpoint)
        if service_account_email is not None:
            warnings.warn("""The `service_account_email` field has been deprecated because it is not required. Will be removed after June 12th 2025.""", DeprecationWarning)
            pulumi.log.warn("""service_account_email is deprecated: The `service_account_email` field has been deprecated because it is not required. Will be removed after June 12th 2025.""")
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if service_account_key is not None:
            pulumi.set(__self__, "service_account_key", service_account_key)
        if service_account_key_path is not None:
            pulumi.set(__self__, "service_account_key_path", service_account_key_path)
        if service_account_token is not None:
            pulumi.set(__self__, "service_account_token", service_account_token)
        if service_enablement_custom_endpoint is not None:
            pulumi.set(__self__, "service_enablement_custom_endpoint", service_enablement_custom_endpoint)
        if ske_custom_endpoint is not None:
            pulumi.set(__self__, "ske_custom_endpoint", ske_custom_endpoint)
        if sqlserverflex_custom_endpoint is not None:
            pulumi.set(__self__, "sqlserverflex_custom_endpoint", sqlserverflex_custom_endpoint)
        if token_custom_endpoint is not None:
            pulumi.set(__self__, "token_custom_endpoint", token_custom_endpoint)

    @_builtins.property
    @pulumi.getter(name="authorizationCustomEndpoint")
    def authorization_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the Membership service
        """
        return pulumi.get(self, "authorization_custom_endpoint")

    @authorization_custom_endpoint.setter
    def authorization_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorization_custom_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="cdnCustomEndpoint")
    def cdn_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the CDN service
        """
        return pulumi.get(self, "cdn_custom_endpoint")

    @cdn_custom_endpoint.setter
    def cdn_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cdn_custom_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="credentialsPath")
    def credentials_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path of JSON from where the credentials are read. Takes precedence over the env var `STACKIT_CREDENTIALS_PATH`. Default
        value is `~/.stackit/credentials.json`.
        """
        return pulumi.get(self, "credentials_path")

    @credentials_path.setter
    def credentials_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credentials_path", value)

    @_builtins.property
    @pulumi.getter(name="defaultRegion")
    def default_region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region will be used as the default location for regional services. Not all services require a region, some are global
        """
        return pulumi.get(self, "default_region")

    @default_region.setter
    def default_region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_region", value)

    @_builtins.property
    @pulumi.getter(name="dnsCustomEndpoint")
    def dns_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the DNS service
        """
        return pulumi.get(self, "dns_custom_endpoint")

    @dns_custom_endpoint.setter
    def dns_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dns_custom_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="enableBetaResources")
    def enable_beta_resources(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable beta resources. Default is false.
        """
        return pulumi.get(self, "enable_beta_resources")

    @enable_beta_resources.setter
    def enable_beta_resources(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_beta_resources", value)

    @_builtins.property
    @pulumi.getter
    def experiments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Enables experiments. These are unstable features without official support. More information can be found in the README.
        Available Experiments: iam, routing-tables, network
        """
        return pulumi.get(self, "experiments")

    @experiments.setter
    def experiments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "experiments", value)

    @_builtins.property
    @pulumi.getter(name="gitCustomEndpoint")
    def git_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the Git service
        """
        return pulumi.get(self, "git_custom_endpoint")

    @git_custom_endpoint.setter
    def git_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "git_custom_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="iaasCustomEndpoint")
    def iaas_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the IaaS service
        """
        return pulumi.get(self, "iaas_custom_endpoint")

    @iaas_custom_endpoint.setter
    def iaas_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iaas_custom_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="loadbalancerCustomEndpoint")
    def loadbalancer_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the Load Balancer service
        """
        return pulumi.get(self, "loadbalancer_custom_endpoint")

    @loadbalancer_custom_endpoint.setter
    def loadbalancer_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "loadbalancer_custom_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="logmeCustomEndpoint")
    def logme_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the LogMe service
        """
        return pulumi.get(self, "logme_custom_endpoint")

    @logme_custom_endpoint.setter
    def logme_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logme_custom_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="mariadbCustomEndpoint")
    def mariadb_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the MariaDB service
        """
        return pulumi.get(self, "mariadb_custom_endpoint")

    @mariadb_custom_endpoint.setter
    def mariadb_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mariadb_custom_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="modelservingCustomEndpoint")
    def modelserving_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the AI Model Serving service
        """
        return pulumi.get(self, "modelserving_custom_endpoint")

    @modelserving_custom_endpoint.setter
    def modelserving_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modelserving_custom_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="mongodbflexCustomEndpoint")
    def mongodbflex_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the MongoDB Flex service
        """
        return pulumi.get(self, "mongodbflex_custom_endpoint")

    @mongodbflex_custom_endpoint.setter
    def mongodbflex_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mongodbflex_custom_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="objectstorageCustomEndpoint")
    def objectstorage_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the Object Storage service
        """
        return pulumi.get(self, "objectstorage_custom_endpoint")

    @objectstorage_custom_endpoint.setter
    def objectstorage_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "objectstorage_custom_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="observabilityCustomEndpoint")
    def observability_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the Observability service
        """
        return pulumi.get(self, "observability_custom_endpoint")

    @observability_custom_endpoint.setter
    def observability_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "observability_custom_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="opensearchCustomEndpoint")
    def opensearch_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the OpenSearch service
        """
        return pulumi.get(self, "opensearch_custom_endpoint")

    @opensearch_custom_endpoint.setter
    def opensearch_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "opensearch_custom_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="postgresflexCustomEndpoint")
    def postgresflex_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the PostgresFlex service
        """
        return pulumi.get(self, "postgresflex_custom_endpoint")

    @postgresflex_custom_endpoint.setter
    def postgresflex_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "postgresflex_custom_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private RSA key used for authentication, relevant for the key flow. It takes precedence over the private key that is
        included in the service account key.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="privateKeyPath")
    def private_key_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path for the private RSA key used for authentication, relevant for the key flow. It takes precedence over the private
        key that is included in the service account key.
        """
        return pulumi.get(self, "private_key_path")

    @private_key_path.setter
    def private_key_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key_path", value)

    @_builtins.property
    @pulumi.getter(name="rabbitmqCustomEndpoint")
    def rabbitmq_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the RabbitMQ service
        """
        return pulumi.get(self, "rabbitmq_custom_endpoint")

    @rabbitmq_custom_endpoint.setter
    def rabbitmq_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rabbitmq_custom_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="redisCustomEndpoint")
    def redis_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the Redis service
        """
        return pulumi.get(self, "redis_custom_endpoint")

    @redis_custom_endpoint.setter
    def redis_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redis_custom_endpoint", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated. Use 'default_region' instead""")
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region will be used as the default location for regional services. Not all services require a region, some are global
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourcemanagerCustomEndpoint")
    def resourcemanager_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the Resource Manager service
        """
        return pulumi.get(self, "resourcemanager_custom_endpoint")

    @resourcemanager_custom_endpoint.setter
    def resourcemanager_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resourcemanager_custom_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="secretsmanagerCustomEndpoint")
    def secretsmanager_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the Secrets Manager service
        """
        return pulumi.get(self, "secretsmanager_custom_endpoint")

    @secretsmanager_custom_endpoint.setter
    def secretsmanager_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secretsmanager_custom_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="serverBackupCustomEndpoint")
    def server_backup_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the Server Backup service
        """
        return pulumi.get(self, "server_backup_custom_endpoint")

    @server_backup_custom_endpoint.setter
    def server_backup_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_backup_custom_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="serverUpdateCustomEndpoint")
    def server_update_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the Server Update service
        """
        return pulumi.get(self, "server_update_custom_endpoint")

    @server_update_custom_endpoint.setter
    def server_update_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_update_custom_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountCustomEndpoint")
    def service_account_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the Service Account service
        """
        return pulumi.get(self, "service_account_custom_endpoint")

    @service_account_custom_endpoint.setter
    def service_account_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_custom_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    @_utilities.deprecated("""The `service_account_email` field has been deprecated because it is not required. Will be removed after June 12th 2025.""")
    def service_account_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service account email. It can also be set using the environment variable STACKIT_SERVICE_ACCOUNT_EMAIL. It is required
        if you want to use the resource manager project resource.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_email", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountKey")
    def service_account_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Service account key used for authentication. If set, the key flow will be used to authenticate all operations.
        """
        return pulumi.get(self, "service_account_key")

    @service_account_key.setter
    def service_account_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_key", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountKeyPath")
    def service_account_key_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path for the service account key used for authentication. If set, the key flow will be used to authenticate all
        operations.
        """
        return pulumi.get(self, "service_account_key_path")

    @service_account_key_path.setter
    def service_account_key_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_key_path", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountToken")
    def service_account_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Token used for authentication. If set, the token flow will be used to authenticate all operations.
        """
        return pulumi.get(self, "service_account_token")

    @service_account_token.setter
    def service_account_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_token", value)

    @_builtins.property
    @pulumi.getter(name="serviceEnablementCustomEndpoint")
    def service_enablement_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the Service Enablement API
        """
        return pulumi.get(self, "service_enablement_custom_endpoint")

    @service_enablement_custom_endpoint.setter
    def service_enablement_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_enablement_custom_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="skeCustomEndpoint")
    def ske_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the Kubernetes Engine (SKE) service
        """
        return pulumi.get(self, "ske_custom_endpoint")

    @ske_custom_endpoint.setter
    def ske_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ske_custom_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="sqlserverflexCustomEndpoint")
    def sqlserverflex_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the SQL Server Flex service
        """
        return pulumi.get(self, "sqlserverflex_custom_endpoint")

    @sqlserverflex_custom_endpoint.setter
    def sqlserverflex_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sqlserverflex_custom_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="tokenCustomEndpoint")
    def token_custom_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom endpoint for the token API, which is used to request access tokens when using the key flow
        """
        return pulumi.get(self, "token_custom_endpoint")

    @token_custom_endpoint.setter
    def token_custom_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_custom_endpoint", value)


@pulumi.type_token("pulumi:providers:stackit")
class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 cdn_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials_path: Optional[pulumi.Input[_builtins.str]] = None,
                 default_region: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_beta_resources: Optional[pulumi.Input[_builtins.bool]] = None,
                 experiments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 git_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 iaas_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 loadbalancer_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 logme_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 mariadb_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 modelserving_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 mongodbflex_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 objectstorage_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 observability_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 opensearch_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 postgresflex_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_path: Optional[pulumi.Input[_builtins.str]] = None,
                 rabbitmq_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 redis_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resourcemanager_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 secretsmanager_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 server_backup_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 server_update_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_key: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_key_path: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_token: Optional[pulumi.Input[_builtins.str]] = None,
                 service_enablement_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 ske_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 sqlserverflex_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 token_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        The provider type for the stackit package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authorization_custom_endpoint: Custom endpoint for the Membership service
        :param pulumi.Input[_builtins.str] cdn_custom_endpoint: Custom endpoint for the CDN service
        :param pulumi.Input[_builtins.str] credentials_path: Path of JSON from where the credentials are read. Takes precedence over the env var `STACKIT_CREDENTIALS_PATH`. Default
               value is `~/.stackit/credentials.json`.
        :param pulumi.Input[_builtins.str] default_region: Region will be used as the default location for regional services. Not all services require a region, some are global
        :param pulumi.Input[_builtins.str] dns_custom_endpoint: Custom endpoint for the DNS service
        :param pulumi.Input[_builtins.bool] enable_beta_resources: Enable beta resources. Default is false.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] experiments: Enables experiments. These are unstable features without official support. More information can be found in the README.
               Available Experiments: iam, routing-tables, network
        :param pulumi.Input[_builtins.str] git_custom_endpoint: Custom endpoint for the Git service
        :param pulumi.Input[_builtins.str] iaas_custom_endpoint: Custom endpoint for the IaaS service
        :param pulumi.Input[_builtins.str] loadbalancer_custom_endpoint: Custom endpoint for the Load Balancer service
        :param pulumi.Input[_builtins.str] logme_custom_endpoint: Custom endpoint for the LogMe service
        :param pulumi.Input[_builtins.str] mariadb_custom_endpoint: Custom endpoint for the MariaDB service
        :param pulumi.Input[_builtins.str] modelserving_custom_endpoint: Custom endpoint for the AI Model Serving service
        :param pulumi.Input[_builtins.str] mongodbflex_custom_endpoint: Custom endpoint for the MongoDB Flex service
        :param pulumi.Input[_builtins.str] objectstorage_custom_endpoint: Custom endpoint for the Object Storage service
        :param pulumi.Input[_builtins.str] observability_custom_endpoint: Custom endpoint for the Observability service
        :param pulumi.Input[_builtins.str] opensearch_custom_endpoint: Custom endpoint for the OpenSearch service
        :param pulumi.Input[_builtins.str] postgresflex_custom_endpoint: Custom endpoint for the PostgresFlex service
        :param pulumi.Input[_builtins.str] private_key: Private RSA key used for authentication, relevant for the key flow. It takes precedence over the private key that is
               included in the service account key.
        :param pulumi.Input[_builtins.str] private_key_path: Path for the private RSA key used for authentication, relevant for the key flow. It takes precedence over the private
               key that is included in the service account key.
        :param pulumi.Input[_builtins.str] rabbitmq_custom_endpoint: Custom endpoint for the RabbitMQ service
        :param pulumi.Input[_builtins.str] redis_custom_endpoint: Custom endpoint for the Redis service
        :param pulumi.Input[_builtins.str] region: Region will be used as the default location for regional services. Not all services require a region, some are global
        :param pulumi.Input[_builtins.str] resourcemanager_custom_endpoint: Custom endpoint for the Resource Manager service
        :param pulumi.Input[_builtins.str] secretsmanager_custom_endpoint: Custom endpoint for the Secrets Manager service
        :param pulumi.Input[_builtins.str] server_backup_custom_endpoint: Custom endpoint for the Server Backup service
        :param pulumi.Input[_builtins.str] server_update_custom_endpoint: Custom endpoint for the Server Update service
        :param pulumi.Input[_builtins.str] service_account_custom_endpoint: Custom endpoint for the Service Account service
        :param pulumi.Input[_builtins.str] service_account_email: Service account email. It can also be set using the environment variable STACKIT_SERVICE_ACCOUNT_EMAIL. It is required
               if you want to use the resource manager project resource.
        :param pulumi.Input[_builtins.str] service_account_key: Service account key used for authentication. If set, the key flow will be used to authenticate all operations.
        :param pulumi.Input[_builtins.str] service_account_key_path: Path for the service account key used for authentication. If set, the key flow will be used to authenticate all
               operations.
        :param pulumi.Input[_builtins.str] service_account_token: Token used for authentication. If set, the token flow will be used to authenticate all operations.
        :param pulumi.Input[_builtins.str] service_enablement_custom_endpoint: Custom endpoint for the Service Enablement API
        :param pulumi.Input[_builtins.str] ske_custom_endpoint: Custom endpoint for the Kubernetes Engine (SKE) service
        :param pulumi.Input[_builtins.str] sqlserverflex_custom_endpoint: Custom endpoint for the SQL Server Flex service
        :param pulumi.Input[_builtins.str] token_custom_endpoint: Custom endpoint for the token API, which is used to request access tokens when using the key flow
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the stackit package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 cdn_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials_path: Optional[pulumi.Input[_builtins.str]] = None,
                 default_region: Optional[pulumi.Input[_builtins.str]] = None,
                 dns_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_beta_resources: Optional[pulumi.Input[_builtins.bool]] = None,
                 experiments: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 git_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 iaas_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 loadbalancer_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 logme_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 mariadb_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 modelserving_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 mongodbflex_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 objectstorage_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 observability_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 opensearch_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 postgresflex_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key_path: Optional[pulumi.Input[_builtins.str]] = None,
                 rabbitmq_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 redis_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resourcemanager_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 secretsmanager_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 server_backup_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 server_update_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_key: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_key_path: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_token: Optional[pulumi.Input[_builtins.str]] = None,
                 service_enablement_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 ske_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 sqlserverflex_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 token_custom_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["authorization_custom_endpoint"] = authorization_custom_endpoint
            __props__.__dict__["cdn_custom_endpoint"] = cdn_custom_endpoint
            __props__.__dict__["credentials_path"] = credentials_path
            __props__.__dict__["default_region"] = default_region
            __props__.__dict__["dns_custom_endpoint"] = dns_custom_endpoint
            __props__.__dict__["enable_beta_resources"] = pulumi.Output.from_input(enable_beta_resources).apply(pulumi.runtime.to_json) if enable_beta_resources is not None else None
            __props__.__dict__["experiments"] = pulumi.Output.from_input(experiments).apply(pulumi.runtime.to_json) if experiments is not None else None
            __props__.__dict__["git_custom_endpoint"] = git_custom_endpoint
            __props__.__dict__["iaas_custom_endpoint"] = iaas_custom_endpoint
            __props__.__dict__["loadbalancer_custom_endpoint"] = loadbalancer_custom_endpoint
            __props__.__dict__["logme_custom_endpoint"] = logme_custom_endpoint
            __props__.__dict__["mariadb_custom_endpoint"] = mariadb_custom_endpoint
            __props__.__dict__["modelserving_custom_endpoint"] = modelserving_custom_endpoint
            __props__.__dict__["mongodbflex_custom_endpoint"] = mongodbflex_custom_endpoint
            __props__.__dict__["objectstorage_custom_endpoint"] = objectstorage_custom_endpoint
            __props__.__dict__["observability_custom_endpoint"] = observability_custom_endpoint
            __props__.__dict__["opensearch_custom_endpoint"] = opensearch_custom_endpoint
            __props__.__dict__["postgresflex_custom_endpoint"] = postgresflex_custom_endpoint
            __props__.__dict__["private_key"] = private_key
            __props__.__dict__["private_key_path"] = private_key_path
            __props__.__dict__["rabbitmq_custom_endpoint"] = rabbitmq_custom_endpoint
            __props__.__dict__["redis_custom_endpoint"] = redis_custom_endpoint
            __props__.__dict__["region"] = region
            __props__.__dict__["resourcemanager_custom_endpoint"] = resourcemanager_custom_endpoint
            __props__.__dict__["secretsmanager_custom_endpoint"] = secretsmanager_custom_endpoint
            __props__.__dict__["server_backup_custom_endpoint"] = server_backup_custom_endpoint
            __props__.__dict__["server_update_custom_endpoint"] = server_update_custom_endpoint
            __props__.__dict__["service_account_custom_endpoint"] = service_account_custom_endpoint
            __props__.__dict__["service_account_email"] = service_account_email
            __props__.__dict__["service_account_key"] = service_account_key
            __props__.__dict__["service_account_key_path"] = service_account_key_path
            __props__.__dict__["service_account_token"] = service_account_token
            __props__.__dict__["service_enablement_custom_endpoint"] = service_enablement_custom_endpoint
            __props__.__dict__["ske_custom_endpoint"] = ske_custom_endpoint
            __props__.__dict__["sqlserverflex_custom_endpoint"] = sqlserverflex_custom_endpoint
            __props__.__dict__["token_custom_endpoint"] = token_custom_endpoint
        super(Provider, __self__).__init__(
            'stackit',
            resource_name,
            __props__,
            opts)

    @_builtins.property
    @pulumi.getter(name="authorizationCustomEndpoint")
    def authorization_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the Membership service
        """
        return pulumi.get(self, "authorization_custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="cdnCustomEndpoint")
    def cdn_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the CDN service
        """
        return pulumi.get(self, "cdn_custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="credentialsPath")
    def credentials_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Path of JSON from where the credentials are read. Takes precedence over the env var `STACKIT_CREDENTIALS_PATH`. Default
        value is `~/.stackit/credentials.json`.
        """
        return pulumi.get(self, "credentials_path")

    @_builtins.property
    @pulumi.getter(name="defaultRegion")
    def default_region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Region will be used as the default location for regional services. Not all services require a region, some are global
        """
        return pulumi.get(self, "default_region")

    @_builtins.property
    @pulumi.getter(name="dnsCustomEndpoint")
    def dns_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the DNS service
        """
        return pulumi.get(self, "dns_custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="gitCustomEndpoint")
    def git_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the Git service
        """
        return pulumi.get(self, "git_custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="iaasCustomEndpoint")
    def iaas_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the IaaS service
        """
        return pulumi.get(self, "iaas_custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="loadbalancerCustomEndpoint")
    def loadbalancer_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the Load Balancer service
        """
        return pulumi.get(self, "loadbalancer_custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="logmeCustomEndpoint")
    def logme_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the LogMe service
        """
        return pulumi.get(self, "logme_custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="mariadbCustomEndpoint")
    def mariadb_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the MariaDB service
        """
        return pulumi.get(self, "mariadb_custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="modelservingCustomEndpoint")
    def modelserving_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the AI Model Serving service
        """
        return pulumi.get(self, "modelserving_custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="mongodbflexCustomEndpoint")
    def mongodbflex_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the MongoDB Flex service
        """
        return pulumi.get(self, "mongodbflex_custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="objectstorageCustomEndpoint")
    def objectstorage_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the Object Storage service
        """
        return pulumi.get(self, "objectstorage_custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="observabilityCustomEndpoint")
    def observability_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the Observability service
        """
        return pulumi.get(self, "observability_custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="opensearchCustomEndpoint")
    def opensearch_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the OpenSearch service
        """
        return pulumi.get(self, "opensearch_custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="postgresflexCustomEndpoint")
    def postgresflex_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the PostgresFlex service
        """
        return pulumi.get(self, "postgresflex_custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Private RSA key used for authentication, relevant for the key flow. It takes precedence over the private key that is
        included in the service account key.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="privateKeyPath")
    def private_key_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Path for the private RSA key used for authentication, relevant for the key flow. It takes precedence over the private
        key that is included in the service account key.
        """
        return pulumi.get(self, "private_key_path")

    @_builtins.property
    @pulumi.getter(name="rabbitmqCustomEndpoint")
    def rabbitmq_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the RabbitMQ service
        """
        return pulumi.get(self, "rabbitmq_custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="redisCustomEndpoint")
    def redis_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the Redis service
        """
        return pulumi.get(self, "redis_custom_endpoint")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""This attribute is deprecated. Use 'default_region' instead""")
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Region will be used as the default location for regional services. Not all services require a region, some are global
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourcemanagerCustomEndpoint")
    def resourcemanager_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the Resource Manager service
        """
        return pulumi.get(self, "resourcemanager_custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="secretsmanagerCustomEndpoint")
    def secretsmanager_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the Secrets Manager service
        """
        return pulumi.get(self, "secretsmanager_custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="serverBackupCustomEndpoint")
    def server_backup_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the Server Backup service
        """
        return pulumi.get(self, "server_backup_custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="serverUpdateCustomEndpoint")
    def server_update_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the Server Update service
        """
        return pulumi.get(self, "server_update_custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="serviceAccountCustomEndpoint")
    def service_account_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the Service Account service
        """
        return pulumi.get(self, "service_account_custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    @_utilities.deprecated("""The `service_account_email` field has been deprecated because it is not required. Will be removed after June 12th 2025.""")
    def service_account_email(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Service account email. It can also be set using the environment variable STACKIT_SERVICE_ACCOUNT_EMAIL. It is required
        if you want to use the resource manager project resource.
        """
        return pulumi.get(self, "service_account_email")

    @_builtins.property
    @pulumi.getter(name="serviceAccountKey")
    def service_account_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Service account key used for authentication. If set, the key flow will be used to authenticate all operations.
        """
        return pulumi.get(self, "service_account_key")

    @_builtins.property
    @pulumi.getter(name="serviceAccountKeyPath")
    def service_account_key_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Path for the service account key used for authentication. If set, the key flow will be used to authenticate all
        operations.
        """
        return pulumi.get(self, "service_account_key_path")

    @_builtins.property
    @pulumi.getter(name="serviceAccountToken")
    def service_account_token(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Token used for authentication. If set, the token flow will be used to authenticate all operations.
        """
        return pulumi.get(self, "service_account_token")

    @_builtins.property
    @pulumi.getter(name="serviceEnablementCustomEndpoint")
    def service_enablement_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the Service Enablement API
        """
        return pulumi.get(self, "service_enablement_custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="skeCustomEndpoint")
    def ske_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the Kubernetes Engine (SKE) service
        """
        return pulumi.get(self, "ske_custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="sqlserverflexCustomEndpoint")
    def sqlserverflex_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the SQL Server Flex service
        """
        return pulumi.get(self, "sqlserverflex_custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="tokenCustomEndpoint")
    def token_custom_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Custom endpoint for the token API, which is used to request access tokens when using the key flow
        """
        return pulumi.get(self, "token_custom_endpoint")

    @pulumi.output_type
    class TerraformConfigResult:
        def __init__(__self__, result=None):
            if result and not isinstance(result, dict):
                raise TypeError("Expected argument 'result' to be a dict")
            pulumi.set(__self__, "result", result)

        @_builtins.property
        @pulumi.getter
        def result(self) -> Mapping[str, Any]:
            return pulumi.get(self, "result")

    def terraform_config(__self__) -> pulumi.Output['Provider.TerraformConfigResult']:
        """
        This function returns a Terraform config object with terraform-namecased keys,to be used with the Terraform Module Provider.
        """
        __args__ = dict()
        __args__['__self__'] = __self__
        return pulumi.runtime.call('pulumi:providers:stackit/terraformConfig', __args__, res=__self__, typ=Provider.TerraformConfigResult)

