# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PublicIpAssociateArgs', 'PublicIpAssociate']

@pulumi.input_type
class PublicIpAssociateArgs:
    def __init__(__self__, *,
                 network_interface_id: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 public_ip_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a PublicIpAssociate resource.
        :param pulumi.Input[_builtins.str] network_interface_id: The ID of the network interface (or virtual IP) to which the public IP should be attached to.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the public IP is associated.
        :param pulumi.Input[_builtins.str] public_ip_id: The public IP ID.
        """
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "public_ip_id", public_ip_id)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the network interface (or virtual IP) to which the public IP should be attached to.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_interface_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT project ID to which the public IP is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="publicIpId")
    def public_ip_id(self) -> pulumi.Input[_builtins.str]:
        """
        The public IP ID.
        """
        return pulumi.get(self, "public_ip_id")

    @public_ip_id.setter
    def public_ip_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "public_ip_id", value)


@pulumi.input_type
class _PublicIpAssociateState:
    def __init__(__self__, *,
                 ip: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PublicIpAssociate resources.
        :param pulumi.Input[_builtins.str] ip: The IP address.
        :param pulumi.Input[_builtins.str] network_interface_id: The ID of the network interface (or virtual IP) to which the public IP should be attached to.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the public IP is associated.
        :param pulumi.Input[_builtins.str] public_ip_id: The public IP ID.
        """
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if network_interface_id is not None:
            pulumi.set(__self__, "network_interface_id", network_interface_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if public_ip_id is not None:
            pulumi.set(__self__, "public_ip_id", public_ip_id)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IP address.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the network interface (or virtual IP) to which the public IP should be attached to.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_interface_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT project ID to which the public IP is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="publicIpId")
    def public_ip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The public IP ID.
        """
        return pulumi.get(self, "public_ip_id")

    @public_ip_id.setter
    def public_ip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip_id", value)


@pulumi.type_token("stackit:index/publicIpAssociate:PublicIpAssociate")
class PublicIpAssociate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Associates an existing public IP to a network interface. This is useful for situations where you have a pre-allocated public IP or unable to use the `PublicIp` resource to create a new public IP. Must have a `region` specified in the provider configuration.

        !> The `PublicIpAssociate` resource should not be used together with the `PublicIp` resource for the same public IP or for the same network interface.
        Using both resources together for the same public IP or network interface WILL lead to conflicts, as they both have control of the public IP and network interface association.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] network_interface_id: The ID of the network interface (or virtual IP) to which the public IP should be attached to.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the public IP is associated.
        :param pulumi.Input[_builtins.str] public_ip_id: The public IP ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PublicIpAssociateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Associates an existing public IP to a network interface. This is useful for situations where you have a pre-allocated public IP or unable to use the `PublicIp` resource to create a new public IP. Must have a `region` specified in the provider configuration.

        !> The `PublicIpAssociate` resource should not be used together with the `PublicIp` resource for the same public IP or for the same network interface.
        Using both resources together for the same public IP or network interface WILL lead to conflicts, as they both have control of the public IP and network interface association.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param PublicIpAssociateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PublicIpAssociateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PublicIpAssociateArgs.__new__(PublicIpAssociateArgs)

            if network_interface_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_interface_id'")
            __props__.__dict__["network_interface_id"] = network_interface_id
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if public_ip_id is None and not opts.urn:
                raise TypeError("Missing required property 'public_ip_id'")
            __props__.__dict__["public_ip_id"] = public_ip_id
            __props__.__dict__["ip"] = None
        super(PublicIpAssociate, __self__).__init__(
            'stackit:index/publicIpAssociate:PublicIpAssociate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ip: Optional[pulumi.Input[_builtins.str]] = None,
            network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'PublicIpAssociate':
        """
        Get an existing PublicIpAssociate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ip: The IP address.
        :param pulumi.Input[_builtins.str] network_interface_id: The ID of the network interface (or virtual IP) to which the public IP should be attached to.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the public IP is associated.
        :param pulumi.Input[_builtins.str] public_ip_id: The public IP ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PublicIpAssociateState.__new__(_PublicIpAssociateState)

        __props__.__dict__["ip"] = ip
        __props__.__dict__["network_interface_id"] = network_interface_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["public_ip_id"] = public_ip_id
        return PublicIpAssociate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> pulumi.Output[_builtins.str]:
        """
        The IP address.
        """
        return pulumi.get(self, "ip")

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the network interface (or virtual IP) to which the public IP should be attached to.
        """
        return pulumi.get(self, "network_interface_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT project ID to which the public IP is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="publicIpId")
    def public_ip_id(self) -> pulumi.Output[_builtins.str]:
        """
        The public IP ID.
        """
        return pulumi.get(self, "public_ip_id")

