# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RedisInstanceArgs', 'RedisInstance']

@pulumi.input_type
class RedisInstanceArgs:
    def __init__(__self__, *,
                 plan_name: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 version: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input['RedisInstanceParametersArgs']] = None):
        """
        The set of arguments for constructing a RedisInstance resource.
        :param pulumi.Input[_builtins.str] plan_name: The selected plan name.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the instance is associated.
        :param pulumi.Input[_builtins.str] version: The service version.
        :param pulumi.Input[_builtins.str] name: Instance name.
        """
        pulumi.set(__self__, "plan_name", plan_name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "version", version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @_builtins.property
    @pulumi.getter(name="planName")
    def plan_name(self) -> pulumi.Input[_builtins.str]:
        """
        The selected plan name.
        """
        return pulumi.get(self, "plan_name")

    @plan_name.setter
    def plan_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "plan_name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT project ID to which the instance is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        The service version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input['RedisInstanceParametersArgs']]:
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input['RedisInstanceParametersArgs']]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class _RedisInstanceState:
    def __init__(__self__, *,
                 cf_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 cf_organization_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 cf_space_guid: Optional[pulumi.Input[_builtins.str]] = None,
                 dashboard_url: Optional[pulumi.Input[_builtins.str]] = None,
                 image_url: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input['RedisInstanceParametersArgs']] = None,
                 plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RedisInstance resources.
        :param pulumi.Input[_builtins.str] instance_id: ID of the Redis instance.
        :param pulumi.Input[_builtins.str] name: Instance name.
        :param pulumi.Input[_builtins.str] plan_id: The selected plan ID.
        :param pulumi.Input[_builtins.str] plan_name: The selected plan name.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the instance is associated.
        :param pulumi.Input[_builtins.str] version: The service version.
        """
        if cf_guid is not None:
            pulumi.set(__self__, "cf_guid", cf_guid)
        if cf_organization_guid is not None:
            pulumi.set(__self__, "cf_organization_guid", cf_organization_guid)
        if cf_space_guid is not None:
            pulumi.set(__self__, "cf_space_guid", cf_space_guid)
        if dashboard_url is not None:
            pulumi.set(__self__, "dashboard_url", dashboard_url)
        if image_url is not None:
            pulumi.set(__self__, "image_url", image_url)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if plan_id is not None:
            pulumi.set(__self__, "plan_id", plan_id)
        if plan_name is not None:
            pulumi.set(__self__, "plan_name", plan_name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="cfGuid")
    def cf_guid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cf_guid")

    @cf_guid.setter
    def cf_guid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cf_guid", value)

    @_builtins.property
    @pulumi.getter(name="cfOrganizationGuid")
    def cf_organization_guid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cf_organization_guid")

    @cf_organization_guid.setter
    def cf_organization_guid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cf_organization_guid", value)

    @_builtins.property
    @pulumi.getter(name="cfSpaceGuid")
    def cf_space_guid(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cf_space_guid")

    @cf_space_guid.setter
    def cf_space_guid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cf_space_guid", value)

    @_builtins.property
    @pulumi.getter(name="dashboardUrl")
    def dashboard_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "dashboard_url")

    @dashboard_url.setter
    def dashboard_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dashboard_url", value)

    @_builtins.property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "image_url")

    @image_url.setter
    def image_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_url", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the Redis instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instance name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input['RedisInstanceParametersArgs']]:
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input['RedisInstanceParametersArgs']]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="planId")
    def plan_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The selected plan ID.
        """
        return pulumi.get(self, "plan_id")

    @plan_id.setter
    def plan_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan_id", value)

    @_builtins.property
    @pulumi.getter(name="planName")
    def plan_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The selected plan name.
        """
        return pulumi.get(self, "plan_name")

    @plan_name.setter
    def plan_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan_name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT project ID to which the instance is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("stackit:index/redisInstance:RedisInstance")
class RedisInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Union['RedisInstanceParametersArgs', 'RedisInstanceParametersArgsDict']]] = None,
                 plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Redis instance resource schema. Must have a `region` specified in the provider configuration.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Instance name.
        :param pulumi.Input[_builtins.str] plan_name: The selected plan name.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the instance is associated.
        :param pulumi.Input[_builtins.str] version: The service version.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RedisInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Redis instance resource schema. Must have a `region` specified in the provider configuration.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param RedisInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RedisInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Union['RedisInstanceParametersArgs', 'RedisInstanceParametersArgsDict']]] = None,
                 plan_name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RedisInstanceArgs.__new__(RedisInstanceArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["parameters"] = parameters
            if plan_name is None and not opts.urn:
                raise TypeError("Missing required property 'plan_name'")
            __props__.__dict__["plan_name"] = plan_name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["cf_guid"] = None
            __props__.__dict__["cf_organization_guid"] = None
            __props__.__dict__["cf_space_guid"] = None
            __props__.__dict__["dashboard_url"] = None
            __props__.__dict__["image_url"] = None
            __props__.__dict__["instance_id"] = None
            __props__.__dict__["plan_id"] = None
        super(RedisInstance, __self__).__init__(
            'stackit:index/redisInstance:RedisInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cf_guid: Optional[pulumi.Input[_builtins.str]] = None,
            cf_organization_guid: Optional[pulumi.Input[_builtins.str]] = None,
            cf_space_guid: Optional[pulumi.Input[_builtins.str]] = None,
            dashboard_url: Optional[pulumi.Input[_builtins.str]] = None,
            image_url: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Union['RedisInstanceParametersArgs', 'RedisInstanceParametersArgsDict']]] = None,
            plan_id: Optional[pulumi.Input[_builtins.str]] = None,
            plan_name: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'RedisInstance':
        """
        Get an existing RedisInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: ID of the Redis instance.
        :param pulumi.Input[_builtins.str] name: Instance name.
        :param pulumi.Input[_builtins.str] plan_id: The selected plan ID.
        :param pulumi.Input[_builtins.str] plan_name: The selected plan name.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the instance is associated.
        :param pulumi.Input[_builtins.str] version: The service version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RedisInstanceState.__new__(_RedisInstanceState)

        __props__.__dict__["cf_guid"] = cf_guid
        __props__.__dict__["cf_organization_guid"] = cf_organization_guid
        __props__.__dict__["cf_space_guid"] = cf_space_guid
        __props__.__dict__["dashboard_url"] = dashboard_url
        __props__.__dict__["image_url"] = image_url
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["plan_id"] = plan_id
        __props__.__dict__["plan_name"] = plan_name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["version"] = version
        return RedisInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cfGuid")
    def cf_guid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "cf_guid")

    @_builtins.property
    @pulumi.getter(name="cfOrganizationGuid")
    def cf_organization_guid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "cf_organization_guid")

    @_builtins.property
    @pulumi.getter(name="cfSpaceGuid")
    def cf_space_guid(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "cf_space_guid")

    @_builtins.property
    @pulumi.getter(name="dashboardUrl")
    def dashboard_url(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "dashboard_url")

    @_builtins.property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "image_url")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the Redis instance.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Instance name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output['outputs.RedisInstanceParameters']:
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="planId")
    def plan_id(self) -> pulumi.Output[_builtins.str]:
        """
        The selected plan ID.
        """
        return pulumi.get(self, "plan_id")

    @_builtins.property
    @pulumi.getter(name="planName")
    def plan_name(self) -> pulumi.Output[_builtins.str]:
        """
        The selected plan name.
        """
        return pulumi.get(self, "plan_name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT project ID to which the instance is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The service version.
        """
        return pulumi.get(self, "version")

