# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RoutingTableRouteArgs', 'RoutingTableRoute']

@pulumi.input_type
class RoutingTableRouteArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input['RoutingTableRouteDestinationArgs'],
                 network_area_id: pulumi.Input[_builtins.str],
                 next_hop: pulumi.Input['RoutingTableRouteNextHopArgs'],
                 organization_id: pulumi.Input[_builtins.str],
                 routing_table_id: pulumi.Input[_builtins.str],
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RoutingTableRoute resource.
        :param pulumi.Input['RoutingTableRouteDestinationArgs'] destination: Destination of the route.
        :param pulumi.Input[_builtins.str] network_area_id: The network area ID to which the routing table is associated.
        :param pulumi.Input['RoutingTableRouteNextHopArgs'] next_hop: Next hop destination.
        :param pulumi.Input[_builtins.str] organization_id: STACKIT organization ID to which the routing table is associated.
        :param pulumi.Input[_builtins.str] routing_table_id: The routing tables ID.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key-value string pairs which can be attached to a resource container
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "network_area_id", network_area_id)
        pulumi.set(__self__, "next_hop", next_hop)
        pulumi.set(__self__, "organization_id", organization_id)
        pulumi.set(__self__, "routing_table_id", routing_table_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Input['RoutingTableRouteDestinationArgs']:
        """
        Destination of the route.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input['RoutingTableRouteDestinationArgs']):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter(name="networkAreaId")
    def network_area_id(self) -> pulumi.Input[_builtins.str]:
        """
        The network area ID to which the routing table is associated.
        """
        return pulumi.get(self, "network_area_id")

    @network_area_id.setter
    def network_area_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_area_id", value)

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> pulumi.Input['RoutingTableRouteNextHopArgs']:
        """
        Next hop destination.
        """
        return pulumi.get(self, "next_hop")

    @next_hop.setter
    def next_hop(self, value: pulumi.Input['RoutingTableRouteNextHopArgs']):
        pulumi.set(self, "next_hop", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT organization ID to which the routing table is associated.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="routingTableId")
    def routing_table_id(self) -> pulumi.Input[_builtins.str]:
        """
        The routing tables ID.
        """
        return pulumi.get(self, "routing_table_id")

    @routing_table_id.setter
    def routing_table_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "routing_table_id", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _RoutingTableRouteState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 destination: Optional[pulumi.Input['RoutingTableRouteDestinationArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 network_area_id: Optional[pulumi.Input[_builtins.str]] = None,
                 next_hop: Optional[pulumi.Input['RoutingTableRouteNextHopArgs']] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 route_id: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RoutingTableRoute resources.
        :param pulumi.Input[_builtins.str] created_at: Date-time when the route was created.
        :param pulumi.Input['RoutingTableRouteDestinationArgs'] destination: Destination of the route.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key-value string pairs which can be attached to a resource container
        :param pulumi.Input[_builtins.str] network_area_id: The network area ID to which the routing table is associated.
        :param pulumi.Input['RoutingTableRouteNextHopArgs'] next_hop: Next hop destination.
        :param pulumi.Input[_builtins.str] organization_id: STACKIT organization ID to which the routing table is associated.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        :param pulumi.Input[_builtins.str] route_id: The ID of the route.
        :param pulumi.Input[_builtins.str] routing_table_id: The routing tables ID.
        :param pulumi.Input[_builtins.str] updated_at: Date-time when the route was updated.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if network_area_id is not None:
            pulumi.set(__self__, "network_area_id", network_area_id)
        if next_hop is not None:
            pulumi.set(__self__, "next_hop", next_hop)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if route_id is not None:
            pulumi.set(__self__, "route_id", route_id)
        if routing_table_id is not None:
            pulumi.set(__self__, "routing_table_id", routing_table_id)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date-time when the route was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input['RoutingTableRouteDestinationArgs']]:
        """
        Destination of the route.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input['RoutingTableRouteDestinationArgs']]):
        pulumi.set(self, "destination", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="networkAreaId")
    def network_area_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The network area ID to which the routing table is associated.
        """
        return pulumi.get(self, "network_area_id")

    @network_area_id.setter
    def network_area_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_area_id", value)

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> Optional[pulumi.Input['RoutingTableRouteNextHopArgs']]:
        """
        Next hop destination.
        """
        return pulumi.get(self, "next_hop")

    @next_hop.setter
    def next_hop(self, value: Optional[pulumi.Input['RoutingTableRouteNextHopArgs']]):
        pulumi.set(self, "next_hop", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT organization ID to which the routing table is associated.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="routeId")
    def route_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the route.
        """
        return pulumi.get(self, "route_id")

    @route_id.setter
    def route_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_id", value)

    @_builtins.property
    @pulumi.getter(name="routingTableId")
    def routing_table_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The routing tables ID.
        """
        return pulumi.get(self, "routing_table_id")

    @routing_table_id.setter
    def routing_table_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_table_id", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date-time when the route was updated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("stackit:index/routingTableRoute:RoutingTableRoute")
class RoutingTableRoute(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination: Optional[pulumi.Input[Union['RoutingTableRouteDestinationArgs', 'RoutingTableRouteDestinationArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 network_area_id: Optional[pulumi.Input[_builtins.str]] = None,
                 next_hop: Optional[pulumi.Input[Union['RoutingTableRouteNextHopArgs', 'RoutingTableRouteNextHopArgsDict']]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Routing table route resource schema. Must have a `region` specified in the provider configuration.

        > This resource is part of the routing-tables experiment and is likely going to undergo significant changes or be removed in the future. Use it at your own discretion.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RoutingTableRouteDestinationArgs', 'RoutingTableRouteDestinationArgsDict']] destination: Destination of the route.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key-value string pairs which can be attached to a resource container
        :param pulumi.Input[_builtins.str] network_area_id: The network area ID to which the routing table is associated.
        :param pulumi.Input[Union['RoutingTableRouteNextHopArgs', 'RoutingTableRouteNextHopArgsDict']] next_hop: Next hop destination.
        :param pulumi.Input[_builtins.str] organization_id: STACKIT organization ID to which the routing table is associated.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        :param pulumi.Input[_builtins.str] routing_table_id: The routing tables ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RoutingTableRouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Routing table route resource schema. Must have a `region` specified in the provider configuration.

        > This resource is part of the routing-tables experiment and is likely going to undergo significant changes or be removed in the future. Use it at your own discretion.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param RoutingTableRouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoutingTableRouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination: Optional[pulumi.Input[Union['RoutingTableRouteDestinationArgs', 'RoutingTableRouteDestinationArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 network_area_id: Optional[pulumi.Input[_builtins.str]] = None,
                 next_hop: Optional[pulumi.Input[Union['RoutingTableRouteNextHopArgs', 'RoutingTableRouteNextHopArgsDict']]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoutingTableRouteArgs.__new__(RoutingTableRouteArgs)

            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            __props__.__dict__["labels"] = labels
            if network_area_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_area_id'")
            __props__.__dict__["network_area_id"] = network_area_id
            if next_hop is None and not opts.urn:
                raise TypeError("Missing required property 'next_hop'")
            __props__.__dict__["next_hop"] = next_hop
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["region"] = region
            if routing_table_id is None and not opts.urn:
                raise TypeError("Missing required property 'routing_table_id'")
            __props__.__dict__["routing_table_id"] = routing_table_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["route_id"] = None
            __props__.__dict__["updated_at"] = None
        super(RoutingTableRoute, __self__).__init__(
            'stackit:index/routingTableRoute:RoutingTableRoute',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            destination: Optional[pulumi.Input[Union['RoutingTableRouteDestinationArgs', 'RoutingTableRouteDestinationArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            network_area_id: Optional[pulumi.Input[_builtins.str]] = None,
            next_hop: Optional[pulumi.Input[Union['RoutingTableRouteNextHopArgs', 'RoutingTableRouteNextHopArgsDict']]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            route_id: Optional[pulumi.Input[_builtins.str]] = None,
            routing_table_id: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'RoutingTableRoute':
        """
        Get an existing RoutingTableRoute resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: Date-time when the route was created.
        :param pulumi.Input[Union['RoutingTableRouteDestinationArgs', 'RoutingTableRouteDestinationArgsDict']] destination: Destination of the route.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key-value string pairs which can be attached to a resource container
        :param pulumi.Input[_builtins.str] network_area_id: The network area ID to which the routing table is associated.
        :param pulumi.Input[Union['RoutingTableRouteNextHopArgs', 'RoutingTableRouteNextHopArgsDict']] next_hop: Next hop destination.
        :param pulumi.Input[_builtins.str] organization_id: STACKIT organization ID to which the routing table is associated.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        :param pulumi.Input[_builtins.str] route_id: The ID of the route.
        :param pulumi.Input[_builtins.str] routing_table_id: The routing tables ID.
        :param pulumi.Input[_builtins.str] updated_at: Date-time when the route was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RoutingTableRouteState.__new__(_RoutingTableRouteState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["destination"] = destination
        __props__.__dict__["labels"] = labels
        __props__.__dict__["network_area_id"] = network_area_id
        __props__.__dict__["next_hop"] = next_hop
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["region"] = region
        __props__.__dict__["route_id"] = route_id
        __props__.__dict__["routing_table_id"] = routing_table_id
        __props__.__dict__["updated_at"] = updated_at
        return RoutingTableRoute(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date-time when the route was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def destination(self) -> pulumi.Output['outputs.RoutingTableRouteDestination']:
        """
        Destination of the route.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="networkAreaId")
    def network_area_id(self) -> pulumi.Output[_builtins.str]:
        """
        The network area ID to which the routing table is associated.
        """
        return pulumi.get(self, "network_area_id")

    @_builtins.property
    @pulumi.getter(name="nextHop")
    def next_hop(self) -> pulumi.Output['outputs.RoutingTableRouteNextHop']:
        """
        Next hop destination.
        """
        return pulumi.get(self, "next_hop")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT organization ID to which the routing table is associated.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="routeId")
    def route_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the route.
        """
        return pulumi.get(self, "route_id")

    @_builtins.property
    @pulumi.getter(name="routingTableId")
    def routing_table_id(self) -> pulumi.Output[_builtins.str]:
        """
        The routing tables ID.
        """
        return pulumi.get(self, "routing_table_id")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date-time when the route was updated.
        """
        return pulumi.get(self, "updated_at")

