# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityGroupRuleArgs', 'SecurityGroupRule']

@pulumi.input_type
class SecurityGroupRuleArgs:
    def __init__(__self__, *,
                 direction: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 security_group_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 ether_type: Optional[pulumi.Input[_builtins.str]] = None,
                 icmp_parameters: Optional[pulumi.Input['SecurityGroupRuleIcmpParametersArgs']] = None,
                 ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 port_range: Optional[pulumi.Input['SecurityGroupRulePortRangeArgs']] = None,
                 protocol: Optional[pulumi.Input['SecurityGroupRuleProtocolArgs']] = None,
                 remote_security_group_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SecurityGroupRule resource.
        :param pulumi.Input[_builtins.str] direction: The direction of the traffic which the rule should match. Some of the possible values are: Supported values are: `ingress`, `egress`.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the security group rule is associated.
        :param pulumi.Input[_builtins.str] security_group_id: The security group ID.
        :param pulumi.Input[_builtins.str] description: The rule description.
        :param pulumi.Input[_builtins.str] ether_type: The ethertype which the rule should match.
        :param pulumi.Input['SecurityGroupRuleIcmpParametersArgs'] icmp_parameters: ICMP Parameters. These parameters should only be provided if the protocol is ICMP.
        :param pulumi.Input[_builtins.str] ip_range: The remote IP range which the rule should match.
        :param pulumi.Input['SecurityGroupRulePortRangeArgs'] port_range: The range of ports. This should only be provided if the protocol is not ICMP.
        :param pulumi.Input['SecurityGroupRuleProtocolArgs'] protocol: The internet protocol which the rule should match.
        :param pulumi.Input[_builtins.str] remote_security_group_id: The remote security group which the rule should match.
        """
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "security_group_id", security_group_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ether_type is not None:
            pulumi.set(__self__, "ether_type", ether_type)
        if icmp_parameters is not None:
            pulumi.set(__self__, "icmp_parameters", icmp_parameters)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if remote_security_group_id is not None:
            pulumi.set(__self__, "remote_security_group_id", remote_security_group_id)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> pulumi.Input[_builtins.str]:
        """
        The direction of the traffic which the rule should match. Some of the possible values are: Supported values are: `ingress`, `egress`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT project ID to which the security group rule is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="etherType")
    def ether_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ethertype which the rule should match.
        """
        return pulumi.get(self, "ether_type")

    @ether_type.setter
    def ether_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ether_type", value)

    @_builtins.property
    @pulumi.getter(name="icmpParameters")
    def icmp_parameters(self) -> Optional[pulumi.Input['SecurityGroupRuleIcmpParametersArgs']]:
        """
        ICMP Parameters. These parameters should only be provided if the protocol is ICMP.
        """
        return pulumi.get(self, "icmp_parameters")

    @icmp_parameters.setter
    def icmp_parameters(self, value: Optional[pulumi.Input['SecurityGroupRuleIcmpParametersArgs']]):
        pulumi.set(self, "icmp_parameters", value)

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The remote IP range which the rule should match.
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_range", value)

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input['SecurityGroupRulePortRangeArgs']]:
        """
        The range of ports. This should only be provided if the protocol is not ICMP.
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input['SecurityGroupRulePortRangeArgs']]):
        pulumi.set(self, "port_range", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input['SecurityGroupRuleProtocolArgs']]:
        """
        The internet protocol which the rule should match.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input['SecurityGroupRuleProtocolArgs']]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="remoteSecurityGroupId")
    def remote_security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The remote security group which the rule should match.
        """
        return pulumi.get(self, "remote_security_group_id")

    @remote_security_group_id.setter
    def remote_security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remote_security_group_id", value)


@pulumi.input_type
class _SecurityGroupRuleState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 ether_type: Optional[pulumi.Input[_builtins.str]] = None,
                 icmp_parameters: Optional[pulumi.Input['SecurityGroupRuleIcmpParametersArgs']] = None,
                 ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 port_range: Optional[pulumi.Input['SecurityGroupRulePortRangeArgs']] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input['SecurityGroupRuleProtocolArgs']] = None,
                 remote_security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_rule_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SecurityGroupRule resources.
        :param pulumi.Input[_builtins.str] description: The rule description.
        :param pulumi.Input[_builtins.str] direction: The direction of the traffic which the rule should match. Some of the possible values are: Supported values are: `ingress`, `egress`.
        :param pulumi.Input[_builtins.str] ether_type: The ethertype which the rule should match.
        :param pulumi.Input['SecurityGroupRuleIcmpParametersArgs'] icmp_parameters: ICMP Parameters. These parameters should only be provided if the protocol is ICMP.
        :param pulumi.Input[_builtins.str] ip_range: The remote IP range which the rule should match.
        :param pulumi.Input['SecurityGroupRulePortRangeArgs'] port_range: The range of ports. This should only be provided if the protocol is not ICMP.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the security group rule is associated.
        :param pulumi.Input['SecurityGroupRuleProtocolArgs'] protocol: The internet protocol which the rule should match.
        :param pulumi.Input[_builtins.str] remote_security_group_id: The remote security group which the rule should match.
        :param pulumi.Input[_builtins.str] security_group_id: The security group ID.
        :param pulumi.Input[_builtins.str] security_group_rule_id: The security group rule ID.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if ether_type is not None:
            pulumi.set(__self__, "ether_type", ether_type)
        if icmp_parameters is not None:
            pulumi.set(__self__, "icmp_parameters", icmp_parameters)
        if ip_range is not None:
            pulumi.set(__self__, "ip_range", ip_range)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if remote_security_group_id is not None:
            pulumi.set(__self__, "remote_security_group_id", remote_security_group_id)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_group_rule_id is not None:
            pulumi.set(__self__, "security_group_rule_id", security_group_rule_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The rule description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The direction of the traffic which the rule should match. Some of the possible values are: Supported values are: `ingress`, `egress`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter(name="etherType")
    def ether_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ethertype which the rule should match.
        """
        return pulumi.get(self, "ether_type")

    @ether_type.setter
    def ether_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ether_type", value)

    @_builtins.property
    @pulumi.getter(name="icmpParameters")
    def icmp_parameters(self) -> Optional[pulumi.Input['SecurityGroupRuleIcmpParametersArgs']]:
        """
        ICMP Parameters. These parameters should only be provided if the protocol is ICMP.
        """
        return pulumi.get(self, "icmp_parameters")

    @icmp_parameters.setter
    def icmp_parameters(self, value: Optional[pulumi.Input['SecurityGroupRuleIcmpParametersArgs']]):
        pulumi.set(self, "icmp_parameters", value)

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The remote IP range which the rule should match.
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_range", value)

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input['SecurityGroupRulePortRangeArgs']]:
        """
        The range of ports. This should only be provided if the protocol is not ICMP.
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input['SecurityGroupRulePortRangeArgs']]):
        pulumi.set(self, "port_range", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT project ID to which the security group rule is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input['SecurityGroupRuleProtocolArgs']]:
        """
        The internet protocol which the rule should match.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input['SecurityGroupRuleProtocolArgs']]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="remoteSecurityGroupId")
    def remote_security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The remote security group which the rule should match.
        """
        return pulumi.get(self, "remote_security_group_id")

    @remote_security_group_id.setter
    def remote_security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "remote_security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupRuleId")
    def security_group_rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security group rule ID.
        """
        return pulumi.get(self, "security_group_rule_id")

    @security_group_rule_id.setter
    def security_group_rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_rule_id", value)


@pulumi.type_token("stackit:index/securityGroupRule:SecurityGroupRule")
class SecurityGroupRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 ether_type: Optional[pulumi.Input[_builtins.str]] = None,
                 icmp_parameters: Optional[pulumi.Input[Union['SecurityGroupRuleIcmpParametersArgs', 'SecurityGroupRuleIcmpParametersArgsDict']]] = None,
                 ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 port_range: Optional[pulumi.Input[Union['SecurityGroupRulePortRangeArgs', 'SecurityGroupRulePortRangeArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[Union['SecurityGroupRuleProtocolArgs', 'SecurityGroupRuleProtocolArgsDict']]] = None,
                 remote_security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Security group rule resource schema. Must have a `region` specified in the provider configuration.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The rule description.
        :param pulumi.Input[_builtins.str] direction: The direction of the traffic which the rule should match. Some of the possible values are: Supported values are: `ingress`, `egress`.
        :param pulumi.Input[_builtins.str] ether_type: The ethertype which the rule should match.
        :param pulumi.Input[Union['SecurityGroupRuleIcmpParametersArgs', 'SecurityGroupRuleIcmpParametersArgsDict']] icmp_parameters: ICMP Parameters. These parameters should only be provided if the protocol is ICMP.
        :param pulumi.Input[_builtins.str] ip_range: The remote IP range which the rule should match.
        :param pulumi.Input[Union['SecurityGroupRulePortRangeArgs', 'SecurityGroupRulePortRangeArgsDict']] port_range: The range of ports. This should only be provided if the protocol is not ICMP.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the security group rule is associated.
        :param pulumi.Input[Union['SecurityGroupRuleProtocolArgs', 'SecurityGroupRuleProtocolArgsDict']] protocol: The internet protocol which the rule should match.
        :param pulumi.Input[_builtins.str] remote_security_group_id: The remote security group which the rule should match.
        :param pulumi.Input[_builtins.str] security_group_id: The security group ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityGroupRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Security group rule resource schema. Must have a `region` specified in the provider configuration.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param SecurityGroupRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityGroupRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 ether_type: Optional[pulumi.Input[_builtins.str]] = None,
                 icmp_parameters: Optional[pulumi.Input[Union['SecurityGroupRuleIcmpParametersArgs', 'SecurityGroupRuleIcmpParametersArgsDict']]] = None,
                 ip_range: Optional[pulumi.Input[_builtins.str]] = None,
                 port_range: Optional[pulumi.Input[Union['SecurityGroupRulePortRangeArgs', 'SecurityGroupRulePortRangeArgsDict']]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[Union['SecurityGroupRuleProtocolArgs', 'SecurityGroupRuleProtocolArgsDict']]] = None,
                 remote_security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityGroupRuleArgs.__new__(SecurityGroupRuleArgs)

            __props__.__dict__["description"] = description
            if direction is None and not opts.urn:
                raise TypeError("Missing required property 'direction'")
            __props__.__dict__["direction"] = direction
            __props__.__dict__["ether_type"] = ether_type
            __props__.__dict__["icmp_parameters"] = icmp_parameters
            __props__.__dict__["ip_range"] = ip_range
            __props__.__dict__["port_range"] = port_range
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["remote_security_group_id"] = remote_security_group_id
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["security_group_rule_id"] = None
        super(SecurityGroupRule, __self__).__init__(
            'stackit:index/securityGroupRule:SecurityGroupRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            direction: Optional[pulumi.Input[_builtins.str]] = None,
            ether_type: Optional[pulumi.Input[_builtins.str]] = None,
            icmp_parameters: Optional[pulumi.Input[Union['SecurityGroupRuleIcmpParametersArgs', 'SecurityGroupRuleIcmpParametersArgsDict']]] = None,
            ip_range: Optional[pulumi.Input[_builtins.str]] = None,
            port_range: Optional[pulumi.Input[Union['SecurityGroupRulePortRangeArgs', 'SecurityGroupRulePortRangeArgsDict']]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            protocol: Optional[pulumi.Input[Union['SecurityGroupRuleProtocolArgs', 'SecurityGroupRuleProtocolArgsDict']]] = None,
            remote_security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_rule_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'SecurityGroupRule':
        """
        Get an existing SecurityGroupRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The rule description.
        :param pulumi.Input[_builtins.str] direction: The direction of the traffic which the rule should match. Some of the possible values are: Supported values are: `ingress`, `egress`.
        :param pulumi.Input[_builtins.str] ether_type: The ethertype which the rule should match.
        :param pulumi.Input[Union['SecurityGroupRuleIcmpParametersArgs', 'SecurityGroupRuleIcmpParametersArgsDict']] icmp_parameters: ICMP Parameters. These parameters should only be provided if the protocol is ICMP.
        :param pulumi.Input[_builtins.str] ip_range: The remote IP range which the rule should match.
        :param pulumi.Input[Union['SecurityGroupRulePortRangeArgs', 'SecurityGroupRulePortRangeArgsDict']] port_range: The range of ports. This should only be provided if the protocol is not ICMP.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the security group rule is associated.
        :param pulumi.Input[Union['SecurityGroupRuleProtocolArgs', 'SecurityGroupRuleProtocolArgsDict']] protocol: The internet protocol which the rule should match.
        :param pulumi.Input[_builtins.str] remote_security_group_id: The remote security group which the rule should match.
        :param pulumi.Input[_builtins.str] security_group_id: The security group ID.
        :param pulumi.Input[_builtins.str] security_group_rule_id: The security group rule ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityGroupRuleState.__new__(_SecurityGroupRuleState)

        __props__.__dict__["description"] = description
        __props__.__dict__["direction"] = direction
        __props__.__dict__["ether_type"] = ether_type
        __props__.__dict__["icmp_parameters"] = icmp_parameters
        __props__.__dict__["ip_range"] = ip_range
        __props__.__dict__["port_range"] = port_range
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["remote_security_group_id"] = remote_security_group_id
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["security_group_rule_id"] = security_group_rule_id
        return SecurityGroupRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The rule description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> pulumi.Output[_builtins.str]:
        """
        The direction of the traffic which the rule should match. Some of the possible values are: Supported values are: `ingress`, `egress`.
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter(name="etherType")
    def ether_type(self) -> pulumi.Output[_builtins.str]:
        """
        The ethertype which the rule should match.
        """
        return pulumi.get(self, "ether_type")

    @_builtins.property
    @pulumi.getter(name="icmpParameters")
    def icmp_parameters(self) -> pulumi.Output['outputs.SecurityGroupRuleIcmpParameters']:
        """
        ICMP Parameters. These parameters should only be provided if the protocol is ICMP.
        """
        return pulumi.get(self, "icmp_parameters")

    @_builtins.property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The remote IP range which the rule should match.
        """
        return pulumi.get(self, "ip_range")

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> pulumi.Output['outputs.SecurityGroupRulePortRange']:
        """
        The range of ports. This should only be provided if the protocol is not ICMP.
        """
        return pulumi.get(self, "port_range")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT project ID to which the security group rule is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output['outputs.SecurityGroupRuleProtocol']:
        """
        The internet protocol which the rule should match.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="remoteSecurityGroupId")
    def remote_security_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The remote security group which the rule should match.
        """
        return pulumi.get(self, "remote_security_group_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="securityGroupRuleId")
    def security_group_rule_id(self) -> pulumi.Output[_builtins.str]:
        """
        The security group rule ID.
        """
        return pulumi.get(self, "security_group_rule_id")

