# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerArgs', 'Server']

@pulumi.input_type
class ServerArgs:
    def __init__(__self__, *,
                 machine_type: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 affinity_group: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_volume: Optional[pulumi.Input['ServerBootVolumeArgs']] = None,
                 desired_status: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 keypair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Server resource.
        :param pulumi.Input[_builtins.str] machine_type: Name of the type of the machine for the server. Possible values are documented in [Virtual machine flavors](https://docs.stackit.cloud/stackit/en/virtual-machine-flavors-75137231.html)
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the server is associated.
        :param pulumi.Input[_builtins.str] affinity_group: The affinity group the server is assigned to.
        :param pulumi.Input[_builtins.str] availability_zone: The availability zone of the server.
        :param pulumi.Input['ServerBootVolumeArgs'] boot_volume: The boot volume for the server
        :param pulumi.Input[_builtins.str] desired_status: The desired status of the server resource. Supported values are: `active`, `inactive`, `deallocated`.
        :param pulumi.Input[_builtins.str] image_id: The image ID to be used for an ephemeral disk on the server.
        :param pulumi.Input[_builtins.str] keypair_name: The name of the keypair used during server creation.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key-value string pairs which can be attached to a resource container
        :param pulumi.Input[_builtins.str] name: The name of the server.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_interfaces: The IDs of network interfaces which should be attached to the server. Updating it will recreate the server.
        :param pulumi.Input[_builtins.str] user_data: User data that is passed via cloud-init to the server.
        """
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "project_id", project_id)
        if affinity_group is not None:
            pulumi.set(__self__, "affinity_group", affinity_group)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if boot_volume is not None:
            pulumi.set(__self__, "boot_volume", boot_volume)
        if desired_status is not None:
            pulumi.set(__self__, "desired_status", desired_status)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if keypair_name is not None:
            pulumi.set(__self__, "keypair_name", keypair_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the type of the machine for the server. Possible values are documented in [Virtual machine flavors](https://docs.stackit.cloud/stackit/en/virtual-machine-flavors-75137231.html)
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "machine_type", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT project ID to which the server is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="affinityGroup")
    def affinity_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The affinity group the server is assigned to.
        """
        return pulumi.get(self, "affinity_group")

    @affinity_group.setter
    def affinity_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "affinity_group", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The availability zone of the server.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="bootVolume")
    def boot_volume(self) -> Optional[pulumi.Input['ServerBootVolumeArgs']]:
        """
        The boot volume for the server
        """
        return pulumi.get(self, "boot_volume")

    @boot_volume.setter
    def boot_volume(self, value: Optional[pulumi.Input['ServerBootVolumeArgs']]):
        pulumi.set(self, "boot_volume", value)

    @_builtins.property
    @pulumi.getter(name="desiredStatus")
    def desired_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The desired status of the server resource. Supported values are: `active`, `inactive`, `deallocated`.
        """
        return pulumi.get(self, "desired_status")

    @desired_status.setter
    def desired_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_status", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The image ID to be used for an ephemeral disk on the server.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="keypairName")
    def keypair_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the keypair used during server creation.
        """
        return pulumi.get(self, "keypair_name")

    @keypair_name.setter
    def keypair_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "keypair_name", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IDs of network interfaces which should be attached to the server. Updating it will recreate the server.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User data that is passed via cloud-init to the server.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)


@pulumi.input_type
class _ServerState:
    def __init__(__self__, *,
                 affinity_group: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_volume: Optional[pulumi.Input['ServerBootVolumeArgs']] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 desired_status: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 keypair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 launched_at: Optional[pulumi.Input[_builtins.str]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Server resources.
        :param pulumi.Input[_builtins.str] affinity_group: The affinity group the server is assigned to.
        :param pulumi.Input[_builtins.str] availability_zone: The availability zone of the server.
        :param pulumi.Input['ServerBootVolumeArgs'] boot_volume: The boot volume for the server
        :param pulumi.Input[_builtins.str] created_at: Date-time when the server was created
        :param pulumi.Input[_builtins.str] desired_status: The desired status of the server resource. Supported values are: `active`, `inactive`, `deallocated`.
        :param pulumi.Input[_builtins.str] image_id: The image ID to be used for an ephemeral disk on the server.
        :param pulumi.Input[_builtins.str] keypair_name: The name of the keypair used during server creation.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key-value string pairs which can be attached to a resource container
        :param pulumi.Input[_builtins.str] launched_at: Date-time when the server was launched
        :param pulumi.Input[_builtins.str] machine_type: Name of the type of the machine for the server. Possible values are documented in [Virtual machine flavors](https://docs.stackit.cloud/stackit/en/virtual-machine-flavors-75137231.html)
        :param pulumi.Input[_builtins.str] name: The name of the server.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_interfaces: The IDs of network interfaces which should be attached to the server. Updating it will recreate the server.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the server is associated.
        :param pulumi.Input[_builtins.str] server_id: The server ID.
        :param pulumi.Input[_builtins.str] updated_at: Date-time when the server was updated
        :param pulumi.Input[_builtins.str] user_data: User data that is passed via cloud-init to the server.
        """
        if affinity_group is not None:
            pulumi.set(__self__, "affinity_group", affinity_group)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if boot_volume is not None:
            pulumi.set(__self__, "boot_volume", boot_volume)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if desired_status is not None:
            pulumi.set(__self__, "desired_status", desired_status)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if keypair_name is not None:
            pulumi.set(__self__, "keypair_name", keypair_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if launched_at is not None:
            pulumi.set(__self__, "launched_at", launched_at)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @_builtins.property
    @pulumi.getter(name="affinityGroup")
    def affinity_group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The affinity group the server is assigned to.
        """
        return pulumi.get(self, "affinity_group")

    @affinity_group.setter
    def affinity_group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "affinity_group", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The availability zone of the server.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="bootVolume")
    def boot_volume(self) -> Optional[pulumi.Input['ServerBootVolumeArgs']]:
        """
        The boot volume for the server
        """
        return pulumi.get(self, "boot_volume")

    @boot_volume.setter
    def boot_volume(self, value: Optional[pulumi.Input['ServerBootVolumeArgs']]):
        pulumi.set(self, "boot_volume", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date-time when the server was created
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="desiredStatus")
    def desired_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The desired status of the server resource. Supported values are: `active`, `inactive`, `deallocated`.
        """
        return pulumi.get(self, "desired_status")

    @desired_status.setter
    def desired_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "desired_status", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The image ID to be used for an ephemeral disk on the server.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="keypairName")
    def keypair_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the keypair used during server creation.
        """
        return pulumi.get(self, "keypair_name")

    @keypair_name.setter
    def keypair_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "keypair_name", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter(name="launchedAt")
    def launched_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date-time when the server was launched
        """
        return pulumi.get(self, "launched_at")

    @launched_at.setter
    def launched_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "launched_at", value)

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the type of the machine for the server. Possible values are documented in [Virtual machine flavors](https://docs.stackit.cloud/stackit/en/virtual-machine-flavors-75137231.html)
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "machine_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The IDs of network interfaces which should be attached to the server. Updating it will recreate the server.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "network_interfaces", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT project ID to which the server is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The server ID.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_id", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date-time when the server was updated
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User data that is passed via cloud-init to the server.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)


@pulumi.type_token("stackit:index/server:Server")
class Server(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 affinity_group: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_volume: Optional[pulumi.Input[Union['ServerBootVolumeArgs', 'ServerBootVolumeArgsDict']]] = None,
                 desired_status: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 keypair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Server resource schema. Must have a region specified in the provider configuration.

        ## Example Usage

        ### With key pair

        ### Boot from volume

        ### Boot from existing volume

        ### Network setup

        ### Server with attached volume

        ### Server with user data (cloud-init)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] affinity_group: The affinity group the server is assigned to.
        :param pulumi.Input[_builtins.str] availability_zone: The availability zone of the server.
        :param pulumi.Input[Union['ServerBootVolumeArgs', 'ServerBootVolumeArgsDict']] boot_volume: The boot volume for the server
        :param pulumi.Input[_builtins.str] desired_status: The desired status of the server resource. Supported values are: `active`, `inactive`, `deallocated`.
        :param pulumi.Input[_builtins.str] image_id: The image ID to be used for an ephemeral disk on the server.
        :param pulumi.Input[_builtins.str] keypair_name: The name of the keypair used during server creation.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key-value string pairs which can be attached to a resource container
        :param pulumi.Input[_builtins.str] machine_type: Name of the type of the machine for the server. Possible values are documented in [Virtual machine flavors](https://docs.stackit.cloud/stackit/en/virtual-machine-flavors-75137231.html)
        :param pulumi.Input[_builtins.str] name: The name of the server.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_interfaces: The IDs of network interfaces which should be attached to the server. Updating it will recreate the server.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the server is associated.
        :param pulumi.Input[_builtins.str] user_data: User data that is passed via cloud-init to the server.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Server resource schema. Must have a region specified in the provider configuration.

        ## Example Usage

        ### With key pair

        ### Boot from volume

        ### Boot from existing volume

        ### Network setup

        ### Server with attached volume

        ### Server with user data (cloud-init)

        :param str resource_name: The name of the resource.
        :param ServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 affinity_group: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 boot_volume: Optional[pulumi.Input[Union['ServerBootVolumeArgs', 'ServerBootVolumeArgsDict']]] = None,
                 desired_status: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 keypair_name: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 machine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerArgs.__new__(ServerArgs)

            __props__.__dict__["affinity_group"] = affinity_group
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["boot_volume"] = boot_volume
            __props__.__dict__["desired_status"] = desired_status
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["keypair_name"] = keypair_name
            __props__.__dict__["labels"] = labels
            if machine_type is None and not opts.urn:
                raise TypeError("Missing required property 'machine_type'")
            __props__.__dict__["machine_type"] = machine_type
            __props__.__dict__["name"] = name
            __props__.__dict__["network_interfaces"] = network_interfaces
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["created_at"] = None
            __props__.__dict__["launched_at"] = None
            __props__.__dict__["server_id"] = None
            __props__.__dict__["updated_at"] = None
        super(Server, __self__).__init__(
            'stackit:index/server:Server',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            affinity_group: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
            boot_volume: Optional[pulumi.Input[Union['ServerBootVolumeArgs', 'ServerBootVolumeArgsDict']]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            desired_status: Optional[pulumi.Input[_builtins.str]] = None,
            image_id: Optional[pulumi.Input[_builtins.str]] = None,
            keypair_name: Optional[pulumi.Input[_builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            launched_at: Optional[pulumi.Input[_builtins.str]] = None,
            machine_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            server_id: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            user_data: Optional[pulumi.Input[_builtins.str]] = None) -> 'Server':
        """
        Get an existing Server resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] affinity_group: The affinity group the server is assigned to.
        :param pulumi.Input[_builtins.str] availability_zone: The availability zone of the server.
        :param pulumi.Input[Union['ServerBootVolumeArgs', 'ServerBootVolumeArgsDict']] boot_volume: The boot volume for the server
        :param pulumi.Input[_builtins.str] created_at: Date-time when the server was created
        :param pulumi.Input[_builtins.str] desired_status: The desired status of the server resource. Supported values are: `active`, `inactive`, `deallocated`.
        :param pulumi.Input[_builtins.str] image_id: The image ID to be used for an ephemeral disk on the server.
        :param pulumi.Input[_builtins.str] keypair_name: The name of the keypair used during server creation.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Labels are key-value string pairs which can be attached to a resource container
        :param pulumi.Input[_builtins.str] launched_at: Date-time when the server was launched
        :param pulumi.Input[_builtins.str] machine_type: Name of the type of the machine for the server. Possible values are documented in [Virtual machine flavors](https://docs.stackit.cloud/stackit/en/virtual-machine-flavors-75137231.html)
        :param pulumi.Input[_builtins.str] name: The name of the server.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_interfaces: The IDs of network interfaces which should be attached to the server. Updating it will recreate the server.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the server is associated.
        :param pulumi.Input[_builtins.str] server_id: The server ID.
        :param pulumi.Input[_builtins.str] updated_at: Date-time when the server was updated
        :param pulumi.Input[_builtins.str] user_data: User data that is passed via cloud-init to the server.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerState.__new__(_ServerState)

        __props__.__dict__["affinity_group"] = affinity_group
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["boot_volume"] = boot_volume
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["desired_status"] = desired_status
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["keypair_name"] = keypair_name
        __props__.__dict__["labels"] = labels
        __props__.__dict__["launched_at"] = launched_at
        __props__.__dict__["machine_type"] = machine_type
        __props__.__dict__["name"] = name
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["server_id"] = server_id
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["user_data"] = user_data
        return Server(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="affinityGroup")
    def affinity_group(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The affinity group the server is assigned to.
        """
        return pulumi.get(self, "affinity_group")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[_builtins.str]:
        """
        The availability zone of the server.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="bootVolume")
    def boot_volume(self) -> pulumi.Output[Optional['outputs.ServerBootVolume']]:
        """
        The boot volume for the server
        """
        return pulumi.get(self, "boot_volume")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date-time when the server was created
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="desiredStatus")
    def desired_status(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The desired status of the server resource. Supported values are: `active`, `inactive`, `deallocated`.
        """
        return pulumi.get(self, "desired_status")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The image ID to be used for an ephemeral disk on the server.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="keypairName")
    def keypair_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the keypair used during server creation.
        """
        return pulumi.get(self, "keypair_name")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Labels are key-value string pairs which can be attached to a resource container
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter(name="launchedAt")
    def launched_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date-time when the server was launched
        """
        return pulumi.get(self, "launched_at")

    @_builtins.property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the type of the machine for the server. Possible values are documented in [Virtual machine flavors](https://docs.stackit.cloud/stackit/en/virtual-machine-flavors-75137231.html)
        """
        return pulumi.get(self, "machine_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The IDs of network interfaces which should be attached to the server. Updating it will recreate the server.
        """
        return pulumi.get(self, "network_interfaces")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT project ID to which the server is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Output[_builtins.str]:
        """
        The server ID.
        """
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        Date-time when the server was updated
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User data that is passed via cloud-init to the server.
        """
        return pulumi.get(self, "user_data")

