# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerBackupScheduleArgs', 'ServerBackupSchedule']

@pulumi.input_type
class ServerBackupScheduleArgs:
    def __init__(__self__, *,
                 backup_properties: pulumi.Input['ServerBackupScheduleBackupPropertiesArgs'],
                 enabled: pulumi.Input[_builtins.bool],
                 project_id: pulumi.Input[_builtins.str],
                 rrule: pulumi.Input[_builtins.str],
                 server_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ServerBackupSchedule resource.
        :param pulumi.Input['ServerBackupScheduleBackupPropertiesArgs'] backup_properties: Backup schedule details for the backups.
        :param pulumi.Input[_builtins.bool] enabled: Is the backup schedule enabled or disabled.
        :param pulumi.Input[_builtins.str] project_id: STACKIT Project ID to which the server is associated.
        :param pulumi.Input[_builtins.str] rrule: Backup schedule described in `rrule` (recurrence rule) format.
        :param pulumi.Input[_builtins.str] server_id: Server ID for the backup schedule.
        :param pulumi.Input[_builtins.str] name: The schedule name.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        """
        pulumi.set(__self__, "backup_properties", backup_properties)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "rrule", rrule)
        pulumi.set(__self__, "server_id", server_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="backupProperties")
    def backup_properties(self) -> pulumi.Input['ServerBackupScheduleBackupPropertiesArgs']:
        """
        Backup schedule details for the backups.
        """
        return pulumi.get(self, "backup_properties")

    @backup_properties.setter
    def backup_properties(self, value: pulumi.Input['ServerBackupScheduleBackupPropertiesArgs']):
        pulumi.set(self, "backup_properties", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Is the backup schedule enabled or disabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT Project ID to which the server is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def rrule(self) -> pulumi.Input[_builtins.str]:
        """
        Backup schedule described in `rrule` (recurrence rule) format.
        """
        return pulumi.get(self, "rrule")

    @rrule.setter
    def rrule(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rrule", value)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Input[_builtins.str]:
        """
        Server ID for the backup schedule.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schedule name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ServerBackupScheduleState:
    def __init__(__self__, *,
                 backup_properties: Optional[pulumi.Input['ServerBackupScheduleBackupPropertiesArgs']] = None,
                 backup_schedule_id: Optional[pulumi.Input[_builtins.int]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rrule: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServerBackupSchedule resources.
        :param pulumi.Input['ServerBackupScheduleBackupPropertiesArgs'] backup_properties: Backup schedule details for the backups.
        :param pulumi.Input[_builtins.int] backup_schedule_id: Backup schedule ID.
        :param pulumi.Input[_builtins.bool] enabled: Is the backup schedule enabled or disabled.
        :param pulumi.Input[_builtins.str] name: The schedule name.
        :param pulumi.Input[_builtins.str] project_id: STACKIT Project ID to which the server is associated.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        :param pulumi.Input[_builtins.str] rrule: Backup schedule described in `rrule` (recurrence rule) format.
        :param pulumi.Input[_builtins.str] server_id: Server ID for the backup schedule.
        """
        if backup_properties is not None:
            pulumi.set(__self__, "backup_properties", backup_properties)
        if backup_schedule_id is not None:
            pulumi.set(__self__, "backup_schedule_id", backup_schedule_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rrule is not None:
            pulumi.set(__self__, "rrule", rrule)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)

    @_builtins.property
    @pulumi.getter(name="backupProperties")
    def backup_properties(self) -> Optional[pulumi.Input['ServerBackupScheduleBackupPropertiesArgs']]:
        """
        Backup schedule details for the backups.
        """
        return pulumi.get(self, "backup_properties")

    @backup_properties.setter
    def backup_properties(self, value: Optional[pulumi.Input['ServerBackupScheduleBackupPropertiesArgs']]):
        pulumi.set(self, "backup_properties", value)

    @_builtins.property
    @pulumi.getter(name="backupScheduleId")
    def backup_schedule_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Backup schedule ID.
        """
        return pulumi.get(self, "backup_schedule_id")

    @backup_schedule_id.setter
    def backup_schedule_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_schedule_id", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the backup schedule enabled or disabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schedule name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT Project ID to which the server is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def rrule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Backup schedule described in `rrule` (recurrence rule) format.
        """
        return pulumi.get(self, "rrule")

    @rrule.setter
    def rrule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rrule", value)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Server ID for the backup schedule.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_id", value)


@pulumi.type_token("stackit:index/serverBackupSchedule:ServerBackupSchedule")
class ServerBackupSchedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_properties: Optional[pulumi.Input[Union['ServerBackupScheduleBackupPropertiesArgs', 'ServerBackupScheduleBackupPropertiesArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rrule: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Server backup schedule resource schema. Must have a `region` specified in the provider configuration.

        > This resource is in beta and may be subject to breaking changes in the future. Use with caution. See our guide for how to opt-in to use beta resources.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServerBackupScheduleBackupPropertiesArgs', 'ServerBackupScheduleBackupPropertiesArgsDict']] backup_properties: Backup schedule details for the backups.
        :param pulumi.Input[_builtins.bool] enabled: Is the backup schedule enabled or disabled.
        :param pulumi.Input[_builtins.str] name: The schedule name.
        :param pulumi.Input[_builtins.str] project_id: STACKIT Project ID to which the server is associated.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        :param pulumi.Input[_builtins.str] rrule: Backup schedule described in `rrule` (recurrence rule) format.
        :param pulumi.Input[_builtins.str] server_id: Server ID for the backup schedule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerBackupScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Server backup schedule resource schema. Must have a `region` specified in the provider configuration.

        > This resource is in beta and may be subject to breaking changes in the future. Use with caution. See our guide for how to opt-in to use beta resources.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param ServerBackupScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerBackupScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_properties: Optional[pulumi.Input[Union['ServerBackupScheduleBackupPropertiesArgs', 'ServerBackupScheduleBackupPropertiesArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rrule: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerBackupScheduleArgs.__new__(ServerBackupScheduleArgs)

            if backup_properties is None and not opts.urn:
                raise TypeError("Missing required property 'backup_properties'")
            __props__.__dict__["backup_properties"] = backup_properties
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["name"] = name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            if rrule is None and not opts.urn:
                raise TypeError("Missing required property 'rrule'")
            __props__.__dict__["rrule"] = rrule
            if server_id is None and not opts.urn:
                raise TypeError("Missing required property 'server_id'")
            __props__.__dict__["server_id"] = server_id
            __props__.__dict__["backup_schedule_id"] = None
        super(ServerBackupSchedule, __self__).__init__(
            'stackit:index/serverBackupSchedule:ServerBackupSchedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_properties: Optional[pulumi.Input[Union['ServerBackupScheduleBackupPropertiesArgs', 'ServerBackupScheduleBackupPropertiesArgsDict']]] = None,
            backup_schedule_id: Optional[pulumi.Input[_builtins.int]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            rrule: Optional[pulumi.Input[_builtins.str]] = None,
            server_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServerBackupSchedule':
        """
        Get an existing ServerBackupSchedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServerBackupScheduleBackupPropertiesArgs', 'ServerBackupScheduleBackupPropertiesArgsDict']] backup_properties: Backup schedule details for the backups.
        :param pulumi.Input[_builtins.int] backup_schedule_id: Backup schedule ID.
        :param pulumi.Input[_builtins.bool] enabled: Is the backup schedule enabled or disabled.
        :param pulumi.Input[_builtins.str] name: The schedule name.
        :param pulumi.Input[_builtins.str] project_id: STACKIT Project ID to which the server is associated.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        :param pulumi.Input[_builtins.str] rrule: Backup schedule described in `rrule` (recurrence rule) format.
        :param pulumi.Input[_builtins.str] server_id: Server ID for the backup schedule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerBackupScheduleState.__new__(_ServerBackupScheduleState)

        __props__.__dict__["backup_properties"] = backup_properties
        __props__.__dict__["backup_schedule_id"] = backup_schedule_id
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["rrule"] = rrule
        __props__.__dict__["server_id"] = server_id
        return ServerBackupSchedule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backupProperties")
    def backup_properties(self) -> pulumi.Output['outputs.ServerBackupScheduleBackupProperties']:
        """
        Backup schedule details for the backups.
        """
        return pulumi.get(self, "backup_properties")

    @_builtins.property
    @pulumi.getter(name="backupScheduleId")
    def backup_schedule_id(self) -> pulumi.Output[_builtins.int]:
        """
        Backup schedule ID.
        """
        return pulumi.get(self, "backup_schedule_id")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Is the backup schedule enabled or disabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The schedule name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT Project ID to which the server is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def rrule(self) -> pulumi.Output[_builtins.str]:
        """
        Backup schedule described in `rrule` (recurrence rule) format.
        """
        return pulumi.get(self, "rrule")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Output[_builtins.str]:
        """
        Server ID for the backup schedule.
        """
        return pulumi.get(self, "server_id")

