# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ServerServiceAccountAttachArgs', 'ServerServiceAccountAttach']

@pulumi.input_type
class ServerServiceAccountAttachArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[_builtins.str],
                 server_id: pulumi.Input[_builtins.str],
                 service_account_email: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a ServerServiceAccountAttach resource.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the service account attachment is associated.
        :param pulumi.Input[_builtins.str] server_id: The server ID.
        :param pulumi.Input[_builtins.str] service_account_email: The service account email.
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "server_id", server_id)
        pulumi.set(__self__, "service_account_email", service_account_email)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT project ID to which the service account attachment is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Input[_builtins.str]:
        """
        The server ID.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> pulumi.Input[_builtins.str]:
        """
        The service account email.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_account_email", value)


@pulumi.input_type
class _ServerServiceAccountAttachState:
    def __init__(__self__, *,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServerServiceAccountAttach resources.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the service account attachment is associated.
        :param pulumi.Input[_builtins.str] server_id: The server ID.
        :param pulumi.Input[_builtins.str] service_account_email: The service account email.
        """
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT project ID to which the service account attachment is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The server ID.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The service account email.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_email", value)


@pulumi.type_token("stackit:index/serverServiceAccountAttach:ServerServiceAccountAttach")
class ServerServiceAccountAttach(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Service account attachment resource schema. Attaches a service account to a server. Must have a `region` specified in the provider configuration.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the service account attachment is associated.
        :param pulumi.Input[_builtins.str] server_id: The server ID.
        :param pulumi.Input[_builtins.str] service_account_email: The service account email.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerServiceAccountAttachArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Service account attachment resource schema. Attaches a service account to a server. Must have a `region` specified in the provider configuration.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param ServerServiceAccountAttachArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerServiceAccountAttachArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerServiceAccountAttachArgs.__new__(ServerServiceAccountAttachArgs)

            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            if server_id is None and not opts.urn:
                raise TypeError("Missing required property 'server_id'")
            __props__.__dict__["server_id"] = server_id
            if service_account_email is None and not opts.urn:
                raise TypeError("Missing required property 'service_account_email'")
            __props__.__dict__["service_account_email"] = service_account_email
        super(ServerServiceAccountAttach, __self__).__init__(
            'stackit:index/serverServiceAccountAttach:ServerServiceAccountAttach',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            server_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_account_email: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServerServiceAccountAttach':
        """
        Get an existing ServerServiceAccountAttach resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the service account attachment is associated.
        :param pulumi.Input[_builtins.str] server_id: The server ID.
        :param pulumi.Input[_builtins.str] service_account_email: The service account email.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerServiceAccountAttachState.__new__(_ServerServiceAccountAttachState)

        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["server_id"] = server_id
        __props__.__dict__["service_account_email"] = service_account_email
        return ServerServiceAccountAttach(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT project ID to which the service account attachment is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Output[_builtins.str]:
        """
        The server ID.
        """
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> pulumi.Output[_builtins.str]:
        """
        The service account email.
        """
        return pulumi.get(self, "service_account_email")

