# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ServiceAccountAccessTokenArgs', 'ServiceAccountAccessToken']

@pulumi.input_type
class ServiceAccountAccessTokenArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[_builtins.str],
                 service_account_email: pulumi.Input[_builtins.str],
                 rotate_when_changed: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ttl_days: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a ServiceAccountAccessToken resource.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID associated with the service account token.
        :param pulumi.Input[_builtins.str] service_account_email: Email address linked to the service account.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] rotate_when_changed: A map of arbitrary key/value pairs that will force recreation of the token when they change, enabling token rotation based on external conditions such as a rotating timestamp. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] ttl_days: Specifies the token's validity duration in days. If unspecified, defaults to 90 days.
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "service_account_email", service_account_email)
        if rotate_when_changed is not None:
            pulumi.set(__self__, "rotate_when_changed", rotate_when_changed)
        if ttl_days is not None:
            pulumi.set(__self__, "ttl_days", ttl_days)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT project ID associated with the service account token.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> pulumi.Input[_builtins.str]:
        """
        Email address linked to the service account.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_account_email", value)

    @_builtins.property
    @pulumi.getter(name="rotateWhenChanged")
    def rotate_when_changed(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of arbitrary key/value pairs that will force recreation of the token when they change, enabling token rotation based on external conditions such as a rotating timestamp. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "rotate_when_changed")

    @rotate_when_changed.setter
    def rotate_when_changed(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rotate_when_changed", value)

    @_builtins.property
    @pulumi.getter(name="ttlDays")
    def ttl_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the token's validity duration in days. If unspecified, defaults to 90 days.
        """
        return pulumi.get(self, "ttl_days")

    @ttl_days.setter
    def ttl_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl_days", value)


@pulumi.input_type
class _ServiceAccountAccessTokenState:
    def __init__(__self__, *,
                 access_token_id: Optional[pulumi.Input[_builtins.str]] = None,
                 active: Optional[pulumi.Input[_builtins.bool]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rotate_when_changed: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 token: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl_days: Optional[pulumi.Input[_builtins.int]] = None,
                 valid_until: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceAccountAccessToken resources.
        :param pulumi.Input[_builtins.str] access_token_id: Identifier for the access token linked to the service account.
        :param pulumi.Input[_builtins.bool] active: Indicate whether the token is currently active or inactive
        :param pulumi.Input[_builtins.str] created_at: Timestamp indicating when the access token was created.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID associated with the service account token.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] rotate_when_changed: A map of arbitrary key/value pairs that will force recreation of the token when they change, enabling token rotation based on external conditions such as a rotating timestamp. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] service_account_email: Email address linked to the service account.
        :param pulumi.Input[_builtins.str] token: JWT access token for API authentication. Prefixed by 'Bearer' and should be stored securely as it is irretrievable once lost.
        :param pulumi.Input[_builtins.int] ttl_days: Specifies the token's validity duration in days. If unspecified, defaults to 90 days.
        :param pulumi.Input[_builtins.str] valid_until: Estimated expiration timestamp of the access token. For precise validity, check the JWT details.
        """
        if access_token_id is not None:
            pulumi.set(__self__, "access_token_id", access_token_id)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if rotate_when_changed is not None:
            pulumi.set(__self__, "rotate_when_changed", rotate_when_changed)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if ttl_days is not None:
            pulumi.set(__self__, "ttl_days", ttl_days)
        if valid_until is not None:
            pulumi.set(__self__, "valid_until", valid_until)

    @_builtins.property
    @pulumi.getter(name="accessTokenId")
    def access_token_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier for the access token linked to the service account.
        """
        return pulumi.get(self, "access_token_id")

    @access_token_id.setter
    def access_token_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_token_id", value)

    @_builtins.property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicate whether the token is currently active or inactive
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "active", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp indicating when the access token was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT project ID associated with the service account token.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="rotateWhenChanged")
    def rotate_when_changed(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of arbitrary key/value pairs that will force recreation of the token when they change, enabling token rotation based on external conditions such as a rotating timestamp. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "rotate_when_changed")

    @rotate_when_changed.setter
    def rotate_when_changed(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rotate_when_changed", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email address linked to the service account.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_email", value)

    @_builtins.property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        JWT access token for API authentication. Prefixed by 'Bearer' and should be stored securely as it is irretrievable once lost.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token", value)

    @_builtins.property
    @pulumi.getter(name="ttlDays")
    def ttl_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the token's validity duration in days. If unspecified, defaults to 90 days.
        """
        return pulumi.get(self, "ttl_days")

    @ttl_days.setter
    def ttl_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl_days", value)

    @_builtins.property
    @pulumi.getter(name="validUntil")
    def valid_until(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Estimated expiration timestamp of the access token. For precise validity, check the JWT details.
        """
        return pulumi.get(self, "valid_until")

    @valid_until.setter
    def valid_until(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "valid_until", value)


@pulumi.type_token("stackit:index/serviceAccountAccessToken:ServiceAccountAccessToken")
class ServiceAccountAccessToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rotate_when_changed: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl_days: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Service account access token schema.
        ## Example Usage

        ### Automatically rotate access tokens

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID associated with the service account token.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] rotate_when_changed: A map of arbitrary key/value pairs that will force recreation of the token when they change, enabling token rotation based on external conditions such as a rotating timestamp. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] service_account_email: Email address linked to the service account.
        :param pulumi.Input[_builtins.int] ttl_days: Specifies the token's validity duration in days. If unspecified, defaults to 90 days.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceAccountAccessTokenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Service account access token schema.
        ## Example Usage

        ### Automatically rotate access tokens

        :param str resource_name: The name of the resource.
        :param ServiceAccountAccessTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceAccountAccessTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rotate_when_changed: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl_days: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceAccountAccessTokenArgs.__new__(ServiceAccountAccessTokenArgs)

            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["rotate_when_changed"] = rotate_when_changed
            if service_account_email is None and not opts.urn:
                raise TypeError("Missing required property 'service_account_email'")
            __props__.__dict__["service_account_email"] = service_account_email
            __props__.__dict__["ttl_days"] = ttl_days
            __props__.__dict__["access_token_id"] = None
            __props__.__dict__["active"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["token"] = None
            __props__.__dict__["valid_until"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ServiceAccountAccessToken, __self__).__init__(
            'stackit:index/serviceAccountAccessToken:ServiceAccountAccessToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_token_id: Optional[pulumi.Input[_builtins.str]] = None,
            active: Optional[pulumi.Input[_builtins.bool]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            rotate_when_changed: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
            token: Optional[pulumi.Input[_builtins.str]] = None,
            ttl_days: Optional[pulumi.Input[_builtins.int]] = None,
            valid_until: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServiceAccountAccessToken':
        """
        Get an existing ServiceAccountAccessToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_token_id: Identifier for the access token linked to the service account.
        :param pulumi.Input[_builtins.bool] active: Indicate whether the token is currently active or inactive
        :param pulumi.Input[_builtins.str] created_at: Timestamp indicating when the access token was created.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID associated with the service account token.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] rotate_when_changed: A map of arbitrary key/value pairs that will force recreation of the token when they change, enabling token rotation based on external conditions such as a rotating timestamp. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] service_account_email: Email address linked to the service account.
        :param pulumi.Input[_builtins.str] token: JWT access token for API authentication. Prefixed by 'Bearer' and should be stored securely as it is irretrievable once lost.
        :param pulumi.Input[_builtins.int] ttl_days: Specifies the token's validity duration in days. If unspecified, defaults to 90 days.
        :param pulumi.Input[_builtins.str] valid_until: Estimated expiration timestamp of the access token. For precise validity, check the JWT details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceAccountAccessTokenState.__new__(_ServiceAccountAccessTokenState)

        __props__.__dict__["access_token_id"] = access_token_id
        __props__.__dict__["active"] = active
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["rotate_when_changed"] = rotate_when_changed
        __props__.__dict__["service_account_email"] = service_account_email
        __props__.__dict__["token"] = token
        __props__.__dict__["ttl_days"] = ttl_days
        __props__.__dict__["valid_until"] = valid_until
        return ServiceAccountAccessToken(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessTokenId")
    def access_token_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier for the access token linked to the service account.
        """
        return pulumi.get(self, "access_token_id")

    @_builtins.property
    @pulumi.getter
    def active(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicate whether the token is currently active or inactive
        """
        return pulumi.get(self, "active")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp indicating when the access token was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT project ID associated with the service account token.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="rotateWhenChanged")
    def rotate_when_changed(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of arbitrary key/value pairs that will force recreation of the token when they change, enabling token rotation based on external conditions such as a rotating timestamp. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "rotate_when_changed")

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> pulumi.Output[_builtins.str]:
        """
        Email address linked to the service account.
        """
        return pulumi.get(self, "service_account_email")

    @_builtins.property
    @pulumi.getter
    def token(self) -> pulumi.Output[_builtins.str]:
        """
        JWT access token for API authentication. Prefixed by 'Bearer' and should be stored securely as it is irretrievable once lost.
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter(name="ttlDays")
    def ttl_days(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the token's validity duration in days. If unspecified, defaults to 90 days.
        """
        return pulumi.get(self, "ttl_days")

    @_builtins.property
    @pulumi.getter(name="validUntil")
    def valid_until(self) -> pulumi.Output[_builtins.str]:
        """
        Estimated expiration timestamp of the access token. For precise validity, check the JWT details.
        """
        return pulumi.get(self, "valid_until")

