# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ServiceAccountKeyArgs', 'ServiceAccountKey']

@pulumi.input_type
class ServiceAccountKeyArgs:
    def __init__(__self__, *,
                 project_id: pulumi.Input[_builtins.str],
                 service_account_email: pulumi.Input[_builtins.str],
                 public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 rotate_when_changed: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ttl_days: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a ServiceAccountKey resource.
        :param pulumi.Input[_builtins.str] project_id: The STACKIT project ID associated with the service account key.
        :param pulumi.Input[_builtins.str] service_account_email: The email address associated with the service account, used for account identification and communication.
        :param pulumi.Input[_builtins.str] public_key: Specifies the public*key (RSA2048 key-pair). If not provided, a certificate from STACKIT will be used to generate a private*key.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] rotate_when_changed: A map of arbitrary key/value pairs designed to force key recreation when they change, facilitating key rotation based on external factors such as a changing timestamp. Modifying this map triggers the creation of a new resource.
        :param pulumi.Input[_builtins.int] ttl_days: Specifies the key's validity duration in days. If left unspecified, the key is considered valid until it is deleted
        """
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "service_account_email", service_account_email)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if rotate_when_changed is not None:
            pulumi.set(__self__, "rotate_when_changed", rotate_when_changed)
        if ttl_days is not None:
            pulumi.set(__self__, "ttl_days", ttl_days)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        The STACKIT project ID associated with the service account key.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> pulumi.Input[_builtins.str]:
        """
        The email address associated with the service account, used for account identification and communication.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_account_email", value)

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the public*key (RSA2048 key-pair). If not provided, a certificate from STACKIT will be used to generate a private*key.
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_key", value)

    @_builtins.property
    @pulumi.getter(name="rotateWhenChanged")
    def rotate_when_changed(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of arbitrary key/value pairs designed to force key recreation when they change, facilitating key rotation based on external factors such as a changing timestamp. Modifying this map triggers the creation of a new resource.
        """
        return pulumi.get(self, "rotate_when_changed")

    @rotate_when_changed.setter
    def rotate_when_changed(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rotate_when_changed", value)

    @_builtins.property
    @pulumi.getter(name="ttlDays")
    def ttl_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the key's validity duration in days. If left unspecified, the key is considered valid until it is deleted
        """
        return pulumi.get(self, "ttl_days")

    @ttl_days.setter
    def ttl_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl_days", value)


@pulumi.input_type
class _ServiceAccountKeyState:
    def __init__(__self__, *,
                 json: Optional[pulumi.Input[_builtins.str]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 rotate_when_changed: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl_days: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering ServiceAccountKey resources.
        :param pulumi.Input[_builtins.str] json: The raw JSON representation of the service account key json, available for direct use.
        :param pulumi.Input[_builtins.str] key_id: The unique identifier for the key associated with the service account.
        :param pulumi.Input[_builtins.str] project_id: The STACKIT project ID associated with the service account key.
        :param pulumi.Input[_builtins.str] public_key: Specifies the public*key (RSA2048 key-pair). If not provided, a certificate from STACKIT will be used to generate a private*key.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] rotate_when_changed: A map of arbitrary key/value pairs designed to force key recreation when they change, facilitating key rotation based on external factors such as a changing timestamp. Modifying this map triggers the creation of a new resource.
        :param pulumi.Input[_builtins.str] service_account_email: The email address associated with the service account, used for account identification and communication.
        :param pulumi.Input[_builtins.int] ttl_days: Specifies the key's validity duration in days. If left unspecified, the key is considered valid until it is deleted
        """
        if json is not None:
            pulumi.set(__self__, "json", json)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if rotate_when_changed is not None:
            pulumi.set(__self__, "rotate_when_changed", rotate_when_changed)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if ttl_days is not None:
            pulumi.set(__self__, "ttl_days", ttl_days)

    @_builtins.property
    @pulumi.getter
    def json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The raw JSON representation of the service account key json, available for direct use.
        """
        return pulumi.get(self, "json")

    @json.setter
    def json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "json", value)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier for the key associated with the service account.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The STACKIT project ID associated with the service account key.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the public*key (RSA2048 key-pair). If not provided, a certificate from STACKIT will be used to generate a private*key.
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_key", value)

    @_builtins.property
    @pulumi.getter(name="rotateWhenChanged")
    def rotate_when_changed(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of arbitrary key/value pairs designed to force key recreation when they change, facilitating key rotation based on external factors such as a changing timestamp. Modifying this map triggers the creation of a new resource.
        """
        return pulumi.get(self, "rotate_when_changed")

    @rotate_when_changed.setter
    def rotate_when_changed(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "rotate_when_changed", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email address associated with the service account, used for account identification and communication.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account_email", value)

    @_builtins.property
    @pulumi.getter(name="ttlDays")
    def ttl_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the key's validity duration in days. If left unspecified, the key is considered valid until it is deleted
        """
        return pulumi.get(self, "ttl_days")

    @ttl_days.setter
    def ttl_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl_days", value)


@pulumi.type_token("stackit:index/serviceAccountKey:ServiceAccountKey")
class ServiceAccountKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 rotate_when_changed: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl_days: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Service account key schema.
        ## Example Usage

        ### Automatically rotate service account keys

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] project_id: The STACKIT project ID associated with the service account key.
        :param pulumi.Input[_builtins.str] public_key: Specifies the public*key (RSA2048 key-pair). If not provided, a certificate from STACKIT will be used to generate a private*key.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] rotate_when_changed: A map of arbitrary key/value pairs designed to force key recreation when they change, facilitating key rotation based on external factors such as a changing timestamp. Modifying this map triggers the creation of a new resource.
        :param pulumi.Input[_builtins.str] service_account_email: The email address associated with the service account, used for account identification and communication.
        :param pulumi.Input[_builtins.int] ttl_days: Specifies the key's validity duration in days. If left unspecified, the key is considered valid until it is deleted
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceAccountKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Service account key schema.
        ## Example Usage

        ### Automatically rotate service account keys

        :param str resource_name: The name of the resource.
        :param ServiceAccountKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceAccountKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 rotate_when_changed: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
                 ttl_days: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceAccountKeyArgs.__new__(ServiceAccountKeyArgs)

            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["public_key"] = public_key
            __props__.__dict__["rotate_when_changed"] = rotate_when_changed
            if service_account_email is None and not opts.urn:
                raise TypeError("Missing required property 'service_account_email'")
            __props__.__dict__["service_account_email"] = service_account_email
            __props__.__dict__["ttl_days"] = ttl_days
            __props__.__dict__["json"] = None
            __props__.__dict__["key_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["json"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ServiceAccountKey, __self__).__init__(
            'stackit:index/serviceAccountKey:ServiceAccountKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            json: Optional[pulumi.Input[_builtins.str]] = None,
            key_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            public_key: Optional[pulumi.Input[_builtins.str]] = None,
            rotate_when_changed: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            service_account_email: Optional[pulumi.Input[_builtins.str]] = None,
            ttl_days: Optional[pulumi.Input[_builtins.int]] = None) -> 'ServiceAccountKey':
        """
        Get an existing ServiceAccountKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] json: The raw JSON representation of the service account key json, available for direct use.
        :param pulumi.Input[_builtins.str] key_id: The unique identifier for the key associated with the service account.
        :param pulumi.Input[_builtins.str] project_id: The STACKIT project ID associated with the service account key.
        :param pulumi.Input[_builtins.str] public_key: Specifies the public*key (RSA2048 key-pair). If not provided, a certificate from STACKIT will be used to generate a private*key.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] rotate_when_changed: A map of arbitrary key/value pairs designed to force key recreation when they change, facilitating key rotation based on external factors such as a changing timestamp. Modifying this map triggers the creation of a new resource.
        :param pulumi.Input[_builtins.str] service_account_email: The email address associated with the service account, used for account identification and communication.
        :param pulumi.Input[_builtins.int] ttl_days: Specifies the key's validity duration in days. If left unspecified, the key is considered valid until it is deleted
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceAccountKeyState.__new__(_ServiceAccountKeyState)

        __props__.__dict__["json"] = json
        __props__.__dict__["key_id"] = key_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["public_key"] = public_key
        __props__.__dict__["rotate_when_changed"] = rotate_when_changed
        __props__.__dict__["service_account_email"] = service_account_email
        __props__.__dict__["ttl_days"] = ttl_days
        return ServiceAccountKey(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def json(self) -> pulumi.Output[_builtins.str]:
        """
        The raw JSON representation of the service account key json, available for direct use.
        """
        return pulumi.get(self, "json")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique identifier for the key associated with the service account.
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The STACKIT project ID associated with the service account key.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the public*key (RSA2048 key-pair). If not provided, a certificate from STACKIT will be used to generate a private*key.
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter(name="rotateWhenChanged")
    def rotate_when_changed(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of arbitrary key/value pairs designed to force key recreation when they change, facilitating key rotation based on external factors such as a changing timestamp. Modifying this map triggers the creation of a new resource.
        """
        return pulumi.get(self, "rotate_when_changed")

    @_builtins.property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> pulumi.Output[_builtins.str]:
        """
        The email address associated with the service account, used for account identification and communication.
        """
        return pulumi.get(self, "service_account_email")

    @_builtins.property
    @pulumi.getter(name="ttlDays")
    def ttl_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the key's validity duration in days. If left unspecified, the key is considered valid until it is deleted
        """
        return pulumi.get(self, "ttl_days")

