# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SkeClusterArgs', 'SkeCluster']

@pulumi.input_type
class SkeClusterArgs:
    def __init__(__self__, *,
                 node_pools: pulumi.Input[Sequence[pulumi.Input['SkeClusterNodePoolArgs']]],
                 project_id: pulumi.Input[_builtins.str],
                 extensions: Optional[pulumi.Input['SkeClusterExtensionsArgs']] = None,
                 hibernations: Optional[pulumi.Input[Sequence[pulumi.Input['SkeClusterHibernationArgs']]]] = None,
                 kubernetes_version_min: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance: Optional[pulumi.Input['SkeClusterMaintenanceArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input['SkeClusterNetworkArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SkeCluster resource.
        :param pulumi.Input[Sequence[pulumi.Input['SkeClusterNodePoolArgs']]] node_pools: One or more `node_pool` block as defined below.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the cluster is associated.
        :param pulumi.Input['SkeClusterExtensionsArgs'] extensions: A single extensions block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['SkeClusterHibernationArgs']]] hibernations: One or more hibernation block as defined below.
        :param pulumi.Input[_builtins.str] kubernetes_version_min: The minimum Kubernetes version. This field will be used to set the minimum kubernetes version on creation/update of the cluster. If unset, the latest supported Kubernetes version will be used. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html). To get the current kubernetes version being used for your cluster, use the read-only `kubernetes_version_used` field.
        :param pulumi.Input['SkeClusterMaintenanceArgs'] maintenance: A single maintenance block as defined below.
        :param pulumi.Input[_builtins.str] name: The cluster name.
        :param pulumi.Input['SkeClusterNetworkArgs'] network: Network block as defined below.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        """
        pulumi.set(__self__, "node_pools", node_pools)
        pulumi.set(__self__, "project_id", project_id)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if hibernations is not None:
            pulumi.set(__self__, "hibernations", hibernations)
        if kubernetes_version_min is not None:
            pulumi.set(__self__, "kubernetes_version_min", kubernetes_version_min)
        if maintenance is not None:
            pulumi.set(__self__, "maintenance", maintenance)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> pulumi.Input[Sequence[pulumi.Input['SkeClusterNodePoolArgs']]]:
        """
        One or more `node_pool` block as defined below.
        """
        return pulumi.get(self, "node_pools")

    @node_pools.setter
    def node_pools(self, value: pulumi.Input[Sequence[pulumi.Input['SkeClusterNodePoolArgs']]]):
        pulumi.set(self, "node_pools", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT project ID to which the cluster is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input['SkeClusterExtensionsArgs']]:
        """
        A single extensions block as defined below.
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input['SkeClusterExtensionsArgs']]):
        pulumi.set(self, "extensions", value)

    @_builtins.property
    @pulumi.getter
    def hibernations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SkeClusterHibernationArgs']]]]:
        """
        One or more hibernation block as defined below.
        """
        return pulumi.get(self, "hibernations")

    @hibernations.setter
    def hibernations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SkeClusterHibernationArgs']]]]):
        pulumi.set(self, "hibernations", value)

    @_builtins.property
    @pulumi.getter(name="kubernetesVersionMin")
    def kubernetes_version_min(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimum Kubernetes version. This field will be used to set the minimum kubernetes version on creation/update of the cluster. If unset, the latest supported Kubernetes version will be used. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html). To get the current kubernetes version being used for your cluster, use the read-only `kubernetes_version_used` field.
        """
        return pulumi.get(self, "kubernetes_version_min")

    @kubernetes_version_min.setter
    def kubernetes_version_min(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kubernetes_version_min", value)

    @_builtins.property
    @pulumi.getter
    def maintenance(self) -> Optional[pulumi.Input['SkeClusterMaintenanceArgs']]:
        """
        A single maintenance block as defined below.
        """
        return pulumi.get(self, "maintenance")

    @maintenance.setter
    def maintenance(self, value: Optional[pulumi.Input['SkeClusterMaintenanceArgs']]):
        pulumi.set(self, "maintenance", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['SkeClusterNetworkArgs']]:
        """
        Network block as defined below.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['SkeClusterNetworkArgs']]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _SkeClusterState:
    def __init__(__self__, *,
                 egress_address_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 extensions: Optional[pulumi.Input['SkeClusterExtensionsArgs']] = None,
                 hibernations: Optional[pulumi.Input[Sequence[pulumi.Input['SkeClusterHibernationArgs']]]] = None,
                 kubernetes_version_min: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_version_used: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance: Optional[pulumi.Input['SkeClusterMaintenanceArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input['SkeClusterNetworkArgs']] = None,
                 node_pools: Optional[pulumi.Input[Sequence[pulumi.Input['SkeClusterNodePoolArgs']]]] = None,
                 pod_address_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SkeCluster resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] egress_address_ranges: The outgoing network ranges (in CIDR notation) of traffic originating from workload on the cluster.
        :param pulumi.Input['SkeClusterExtensionsArgs'] extensions: A single extensions block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['SkeClusterHibernationArgs']]] hibernations: One or more hibernation block as defined below.
        :param pulumi.Input[_builtins.str] kubernetes_version_min: The minimum Kubernetes version. This field will be used to set the minimum kubernetes version on creation/update of the cluster. If unset, the latest supported Kubernetes version will be used. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html). To get the current kubernetes version being used for your cluster, use the read-only `kubernetes_version_used` field.
        :param pulumi.Input[_builtins.str] kubernetes_version_used: Full Kubernetes version used. For example, if 1.22 was set in `kubernetes_version_min`, this value may result to 1.22.15. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html).
        :param pulumi.Input['SkeClusterMaintenanceArgs'] maintenance: A single maintenance block as defined below.
        :param pulumi.Input[_builtins.str] name: The cluster name.
        :param pulumi.Input['SkeClusterNetworkArgs'] network: Network block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['SkeClusterNodePoolArgs']]] node_pools: One or more `node_pool` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pod_address_ranges: The network ranges (in CIDR notation) used by pods of the cluster.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the cluster is associated.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        """
        if egress_address_ranges is not None:
            pulumi.set(__self__, "egress_address_ranges", egress_address_ranges)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if hibernations is not None:
            pulumi.set(__self__, "hibernations", hibernations)
        if kubernetes_version_min is not None:
            pulumi.set(__self__, "kubernetes_version_min", kubernetes_version_min)
        if kubernetes_version_used is not None:
            pulumi.set(__self__, "kubernetes_version_used", kubernetes_version_used)
        if maintenance is not None:
            pulumi.set(__self__, "maintenance", maintenance)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if node_pools is not None:
            pulumi.set(__self__, "node_pools", node_pools)
        if pod_address_ranges is not None:
            pulumi.set(__self__, "pod_address_ranges", pod_address_ranges)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="egressAddressRanges")
    def egress_address_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The outgoing network ranges (in CIDR notation) of traffic originating from workload on the cluster.
        """
        return pulumi.get(self, "egress_address_ranges")

    @egress_address_ranges.setter
    def egress_address_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "egress_address_ranges", value)

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input['SkeClusterExtensionsArgs']]:
        """
        A single extensions block as defined below.
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input['SkeClusterExtensionsArgs']]):
        pulumi.set(self, "extensions", value)

    @_builtins.property
    @pulumi.getter
    def hibernations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SkeClusterHibernationArgs']]]]:
        """
        One or more hibernation block as defined below.
        """
        return pulumi.get(self, "hibernations")

    @hibernations.setter
    def hibernations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SkeClusterHibernationArgs']]]]):
        pulumi.set(self, "hibernations", value)

    @_builtins.property
    @pulumi.getter(name="kubernetesVersionMin")
    def kubernetes_version_min(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The minimum Kubernetes version. This field will be used to set the minimum kubernetes version on creation/update of the cluster. If unset, the latest supported Kubernetes version will be used. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html). To get the current kubernetes version being used for your cluster, use the read-only `kubernetes_version_used` field.
        """
        return pulumi.get(self, "kubernetes_version_min")

    @kubernetes_version_min.setter
    def kubernetes_version_min(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kubernetes_version_min", value)

    @_builtins.property
    @pulumi.getter(name="kubernetesVersionUsed")
    def kubernetes_version_used(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full Kubernetes version used. For example, if 1.22 was set in `kubernetes_version_min`, this value may result to 1.22.15. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html).
        """
        return pulumi.get(self, "kubernetes_version_used")

    @kubernetes_version_used.setter
    def kubernetes_version_used(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kubernetes_version_used", value)

    @_builtins.property
    @pulumi.getter
    def maintenance(self) -> Optional[pulumi.Input['SkeClusterMaintenanceArgs']]:
        """
        A single maintenance block as defined below.
        """
        return pulumi.get(self, "maintenance")

    @maintenance.setter
    def maintenance(self, value: Optional[pulumi.Input['SkeClusterMaintenanceArgs']]):
        pulumi.set(self, "maintenance", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input['SkeClusterNetworkArgs']]:
        """
        Network block as defined below.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input['SkeClusterNetworkArgs']]):
        pulumi.set(self, "network", value)

    @_builtins.property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SkeClusterNodePoolArgs']]]]:
        """
        One or more `node_pool` block as defined below.
        """
        return pulumi.get(self, "node_pools")

    @node_pools.setter
    def node_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SkeClusterNodePoolArgs']]]]):
        pulumi.set(self, "node_pools", value)

    @_builtins.property
    @pulumi.getter(name="podAddressRanges")
    def pod_address_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The network ranges (in CIDR notation) used by pods of the cluster.
        """
        return pulumi.get(self, "pod_address_ranges")

    @pod_address_ranges.setter
    def pod_address_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pod_address_ranges", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT project ID to which the cluster is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("stackit:index/skeCluster:SkeCluster")
class SkeCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 extensions: Optional[pulumi.Input[Union['SkeClusterExtensionsArgs', 'SkeClusterExtensionsArgsDict']]] = None,
                 hibernations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SkeClusterHibernationArgs', 'SkeClusterHibernationArgsDict']]]]] = None,
                 kubernetes_version_min: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance: Optional[pulumi.Input[Union['SkeClusterMaintenanceArgs', 'SkeClusterMaintenanceArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[Union['SkeClusterNetworkArgs', 'SkeClusterNetworkArgsDict']]] = None,
                 node_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SkeClusterNodePoolArgs', 'SkeClusterNodePoolArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        SKE Cluster Resource schema. Must have a `region` specified in the provider configuration.

        > When updating `node_pools` of a `SkeCluster`, the pulumi preview might appear incorrect as it matches the node pools by index rather than by name. However, the SKE API correctly identifies node pools by name and applies the intended changes. Please review your changes carefully to ensure the correct configuration will be applied.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SkeClusterExtensionsArgs', 'SkeClusterExtensionsArgsDict']] extensions: A single extensions block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SkeClusterHibernationArgs', 'SkeClusterHibernationArgsDict']]]] hibernations: One or more hibernation block as defined below.
        :param pulumi.Input[_builtins.str] kubernetes_version_min: The minimum Kubernetes version. This field will be used to set the minimum kubernetes version on creation/update of the cluster. If unset, the latest supported Kubernetes version will be used. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html). To get the current kubernetes version being used for your cluster, use the read-only `kubernetes_version_used` field.
        :param pulumi.Input[Union['SkeClusterMaintenanceArgs', 'SkeClusterMaintenanceArgsDict']] maintenance: A single maintenance block as defined below.
        :param pulumi.Input[_builtins.str] name: The cluster name.
        :param pulumi.Input[Union['SkeClusterNetworkArgs', 'SkeClusterNetworkArgsDict']] network: Network block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SkeClusterNodePoolArgs', 'SkeClusterNodePoolArgsDict']]]] node_pools: One or more `node_pool` block as defined below.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the cluster is associated.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SkeClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        SKE Cluster Resource schema. Must have a `region` specified in the provider configuration.

        > When updating `node_pools` of a `SkeCluster`, the pulumi preview might appear incorrect as it matches the node pools by index rather than by name. However, the SKE API correctly identifies node pools by name and applies the intended changes. Please review your changes carefully to ensure the correct configuration will be applied.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param SkeClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SkeClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 extensions: Optional[pulumi.Input[Union['SkeClusterExtensionsArgs', 'SkeClusterExtensionsArgsDict']]] = None,
                 hibernations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SkeClusterHibernationArgs', 'SkeClusterHibernationArgsDict']]]]] = None,
                 kubernetes_version_min: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance: Optional[pulumi.Input[Union['SkeClusterMaintenanceArgs', 'SkeClusterMaintenanceArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network: Optional[pulumi.Input[Union['SkeClusterNetworkArgs', 'SkeClusterNetworkArgsDict']]] = None,
                 node_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SkeClusterNodePoolArgs', 'SkeClusterNodePoolArgsDict']]]]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SkeClusterArgs.__new__(SkeClusterArgs)

            __props__.__dict__["extensions"] = extensions
            __props__.__dict__["hibernations"] = hibernations
            __props__.__dict__["kubernetes_version_min"] = kubernetes_version_min
            __props__.__dict__["maintenance"] = maintenance
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            if node_pools is None and not opts.urn:
                raise TypeError("Missing required property 'node_pools'")
            __props__.__dict__["node_pools"] = node_pools
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["egress_address_ranges"] = None
            __props__.__dict__["kubernetes_version_used"] = None
            __props__.__dict__["pod_address_ranges"] = None
        super(SkeCluster, __self__).__init__(
            'stackit:index/skeCluster:SkeCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            egress_address_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            extensions: Optional[pulumi.Input[Union['SkeClusterExtensionsArgs', 'SkeClusterExtensionsArgsDict']]] = None,
            hibernations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SkeClusterHibernationArgs', 'SkeClusterHibernationArgsDict']]]]] = None,
            kubernetes_version_min: Optional[pulumi.Input[_builtins.str]] = None,
            kubernetes_version_used: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance: Optional[pulumi.Input[Union['SkeClusterMaintenanceArgs', 'SkeClusterMaintenanceArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network: Optional[pulumi.Input[Union['SkeClusterNetworkArgs', 'SkeClusterNetworkArgsDict']]] = None,
            node_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SkeClusterNodePoolArgs', 'SkeClusterNodePoolArgsDict']]]]] = None,
            pod_address_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'SkeCluster':
        """
        Get an existing SkeCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] egress_address_ranges: The outgoing network ranges (in CIDR notation) of traffic originating from workload on the cluster.
        :param pulumi.Input[Union['SkeClusterExtensionsArgs', 'SkeClusterExtensionsArgsDict']] extensions: A single extensions block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SkeClusterHibernationArgs', 'SkeClusterHibernationArgsDict']]]] hibernations: One or more hibernation block as defined below.
        :param pulumi.Input[_builtins.str] kubernetes_version_min: The minimum Kubernetes version. This field will be used to set the minimum kubernetes version on creation/update of the cluster. If unset, the latest supported Kubernetes version will be used. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html). To get the current kubernetes version being used for your cluster, use the read-only `kubernetes_version_used` field.
        :param pulumi.Input[_builtins.str] kubernetes_version_used: Full Kubernetes version used. For example, if 1.22 was set in `kubernetes_version_min`, this value may result to 1.22.15. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html).
        :param pulumi.Input[Union['SkeClusterMaintenanceArgs', 'SkeClusterMaintenanceArgsDict']] maintenance: A single maintenance block as defined below.
        :param pulumi.Input[_builtins.str] name: The cluster name.
        :param pulumi.Input[Union['SkeClusterNetworkArgs', 'SkeClusterNetworkArgsDict']] network: Network block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SkeClusterNodePoolArgs', 'SkeClusterNodePoolArgsDict']]]] node_pools: One or more `node_pool` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pod_address_ranges: The network ranges (in CIDR notation) used by pods of the cluster.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the cluster is associated.
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SkeClusterState.__new__(_SkeClusterState)

        __props__.__dict__["egress_address_ranges"] = egress_address_ranges
        __props__.__dict__["extensions"] = extensions
        __props__.__dict__["hibernations"] = hibernations
        __props__.__dict__["kubernetes_version_min"] = kubernetes_version_min
        __props__.__dict__["kubernetes_version_used"] = kubernetes_version_used
        __props__.__dict__["maintenance"] = maintenance
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["node_pools"] = node_pools
        __props__.__dict__["pod_address_ranges"] = pod_address_ranges
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        return SkeCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="egressAddressRanges")
    def egress_address_ranges(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The outgoing network ranges (in CIDR notation) of traffic originating from workload on the cluster.
        """
        return pulumi.get(self, "egress_address_ranges")

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> pulumi.Output[Optional['outputs.SkeClusterExtensions']]:
        """
        A single extensions block as defined below.
        """
        return pulumi.get(self, "extensions")

    @_builtins.property
    @pulumi.getter
    def hibernations(self) -> pulumi.Output[Optional[Sequence['outputs.SkeClusterHibernation']]]:
        """
        One or more hibernation block as defined below.
        """
        return pulumi.get(self, "hibernations")

    @_builtins.property
    @pulumi.getter(name="kubernetesVersionMin")
    def kubernetes_version_min(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The minimum Kubernetes version. This field will be used to set the minimum kubernetes version on creation/update of the cluster. If unset, the latest supported Kubernetes version will be used. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html). To get the current kubernetes version being used for your cluster, use the read-only `kubernetes_version_used` field.
        """
        return pulumi.get(self, "kubernetes_version_min")

    @_builtins.property
    @pulumi.getter(name="kubernetesVersionUsed")
    def kubernetes_version_used(self) -> pulumi.Output[_builtins.str]:
        """
        Full Kubernetes version used. For example, if 1.22 was set in `kubernetes_version_min`, this value may result to 1.22.15. SKE automatically updates the cluster Kubernetes version if you have set `maintenance.enable_kubernetes_version_updates` to true or if there is a mandatory update, as described in [Updates for Kubernetes versions and Operating System versions in SKE](https://docs.stackit.cloud/stackit/en/version-updates-in-ske-10125631.html).
        """
        return pulumi.get(self, "kubernetes_version_used")

    @_builtins.property
    @pulumi.getter
    def maintenance(self) -> pulumi.Output['outputs.SkeClusterMaintenance']:
        """
        A single maintenance block as defined below.
        """
        return pulumi.get(self, "maintenance")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def network(self) -> pulumi.Output[Optional['outputs.SkeClusterNetwork']]:
        """
        Network block as defined below.
        """
        return pulumi.get(self, "network")

    @_builtins.property
    @pulumi.getter(name="nodePools")
    def node_pools(self) -> pulumi.Output[Sequence['outputs.SkeClusterNodePool']]:
        """
        One or more `node_pool` block as defined below.
        """
        return pulumi.get(self, "node_pools")

    @_builtins.property
    @pulumi.getter(name="podAddressRanges")
    def pod_address_ranges(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The network ranges (in CIDR notation) used by pods of the cluster.
        """
        return pulumi.get(self, "pod_address_ranges")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT project ID to which the cluster is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

