# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['SkeKubeconfigArgs', 'SkeKubeconfig']

@pulumi.input_type
class SkeKubeconfigArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[_builtins.str],
                 project_id: pulumi.Input[_builtins.str],
                 expiration: Optional[pulumi.Input[_builtins.int]] = None,
                 refresh: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SkeKubeconfig resource.
        :param pulumi.Input[_builtins.str] cluster_name: Name of the SKE cluster.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the cluster is associated.
        :param pulumi.Input[_builtins.int] expiration: Expiration time of the kubeconfig, in seconds. Defaults to `3600`
        :param pulumi.Input[_builtins.bool] refresh: If set to true, the provider will check if the kubeconfig has expired and will generated a new valid one in-place
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "project_id", project_id)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if refresh is not None:
            pulumi.set(__self__, "refresh", refresh)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the SKE cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[_builtins.str]:
        """
        STACKIT project ID to which the cluster is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Expiration time of the kubeconfig, in seconds. Defaults to `3600`
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expiration", value)

    @_builtins.property
    @pulumi.getter
    def refresh(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, the provider will check if the kubeconfig has expired and will generated a new valid one in-place
        """
        return pulumi.get(self, "refresh")

    @refresh.setter
    def refresh(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "refresh", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _SkeKubeconfigState:
    def __init__(__self__, *,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 creation_time: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration: Optional[pulumi.Input[_builtins.int]] = None,
                 expires_at: Optional[pulumi.Input[_builtins.str]] = None,
                 kube_config: Optional[pulumi.Input[_builtins.str]] = None,
                 kube_config_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SkeKubeconfig resources.
        :param pulumi.Input[_builtins.str] cluster_name: Name of the SKE cluster.
        :param pulumi.Input[_builtins.str] creation_time: Date-time when the kubeconfig was created
        :param pulumi.Input[_builtins.int] expiration: Expiration time of the kubeconfig, in seconds. Defaults to `3600`
        :param pulumi.Input[_builtins.str] expires_at: Timestamp when the kubeconfig expires
        :param pulumi.Input[_builtins.str] kube_config: Raw short-lived admin kubeconfig.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the cluster is associated.
        :param pulumi.Input[_builtins.bool] refresh: If set to true, the provider will check if the kubeconfig has expired and will generated a new valid one in-place
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        """
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if kube_config is not None:
            pulumi.set(__self__, "kube_config", kube_config)
        if kube_config_id is not None:
            pulumi.set(__self__, "kube_config_id", kube_config_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if refresh is not None:
            pulumi.set(__self__, "refresh", refresh)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the SKE cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Date-time when the kubeconfig was created
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_time", value)

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Expiration time of the kubeconfig, in seconds. Defaults to `3600`
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expiration", value)

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the kubeconfig expires
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expires_at", value)

    @_builtins.property
    @pulumi.getter(name="kubeConfig")
    def kube_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Raw short-lived admin kubeconfig.
        """
        return pulumi.get(self, "kube_config")

    @kube_config.setter
    def kube_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kube_config", value)

    @_builtins.property
    @pulumi.getter(name="kubeConfigId")
    def kube_config_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "kube_config_id")

    @kube_config_id.setter
    def kube_config_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kube_config_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        STACKIT project ID to which the cluster is associated.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def refresh(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set to true, the provider will check if the kubeconfig has expired and will generated a new valid one in-place
        """
        return pulumi.get(self, "refresh")

    @refresh.setter
    def refresh(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "refresh", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("stackit:index/skeKubeconfig:SkeKubeconfig")
class SkeKubeconfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration: Optional[pulumi.Input[_builtins.int]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        SKE kubeconfig resource schema. Must have a `region` specified in the provider configuration.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_name: Name of the SKE cluster.
        :param pulumi.Input[_builtins.int] expiration: Expiration time of the kubeconfig, in seconds. Defaults to `3600`
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the cluster is associated.
        :param pulumi.Input[_builtins.bool] refresh: If set to true, the provider will check if the kubeconfig has expired and will generated a new valid one in-place
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SkeKubeconfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        SKE kubeconfig resource schema. Must have a `region` specified in the provider configuration.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param SkeKubeconfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SkeKubeconfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration: Optional[pulumi.Input[_builtins.int]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 refresh: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SkeKubeconfigArgs.__new__(SkeKubeconfigArgs)

            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["expiration"] = expiration
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["refresh"] = refresh
            __props__.__dict__["region"] = region
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["expires_at"] = None
            __props__.__dict__["kube_config"] = None
            __props__.__dict__["kube_config_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["kubeConfig"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SkeKubeconfig, __self__).__init__(
            'stackit:index/skeKubeconfig:SkeKubeconfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            creation_time: Optional[pulumi.Input[_builtins.str]] = None,
            expiration: Optional[pulumi.Input[_builtins.int]] = None,
            expires_at: Optional[pulumi.Input[_builtins.str]] = None,
            kube_config: Optional[pulumi.Input[_builtins.str]] = None,
            kube_config_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            refresh: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'SkeKubeconfig':
        """
        Get an existing SkeKubeconfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_name: Name of the SKE cluster.
        :param pulumi.Input[_builtins.str] creation_time: Date-time when the kubeconfig was created
        :param pulumi.Input[_builtins.int] expiration: Expiration time of the kubeconfig, in seconds. Defaults to `3600`
        :param pulumi.Input[_builtins.str] expires_at: Timestamp when the kubeconfig expires
        :param pulumi.Input[_builtins.str] kube_config: Raw short-lived admin kubeconfig.
        :param pulumi.Input[_builtins.str] project_id: STACKIT project ID to which the cluster is associated.
        :param pulumi.Input[_builtins.bool] refresh: If set to true, the provider will check if the kubeconfig has expired and will generated a new valid one in-place
        :param pulumi.Input[_builtins.str] region: The resource region. If not defined, the provider region is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SkeKubeconfigState.__new__(_SkeKubeconfigState)

        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["expiration"] = expiration
        __props__.__dict__["expires_at"] = expires_at
        __props__.__dict__["kube_config"] = kube_config
        __props__.__dict__["kube_config_id"] = kube_config_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["refresh"] = refresh
        __props__.__dict__["region"] = region
        return SkeKubeconfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the SKE cluster.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[_builtins.str]:
        """
        Date-time when the kubeconfig was created
        """
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> pulumi.Output[_builtins.int]:
        """
        Expiration time of the kubeconfig, in seconds. Defaults to `3600`
        """
        return pulumi.get(self, "expiration")

    @_builtins.property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the kubeconfig expires
        """
        return pulumi.get(self, "expires_at")

    @_builtins.property
    @pulumi.getter(name="kubeConfig")
    def kube_config(self) -> pulumi.Output[_builtins.str]:
        """
        Raw short-lived admin kubeconfig.
        """
        return pulumi.get(self, "kube_config")

    @_builtins.property
    @pulumi.getter(name="kubeConfigId")
    def kube_config_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "kube_config_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        STACKIT project ID to which the cluster is associated.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def refresh(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set to true, the provider will check if the kubeconfig has expired and will generated a new valid one in-place
        """
        return pulumi.get(self, "refresh")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The resource region. If not defined, the provider region is used.
        """
        return pulumi.get(self, "region")

