import os

import click

LICENSE = """The MIT License (MIT)

Copyright © 2025 birds smith

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the “Software”), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
"""

GITIGNORE = """.venv
*.pyc
*.pyo
*.pyd
__pycache__
dist
build
*.egg-info
*.egg
tests
*.log
.python-version
.vscode
"""
MAIN = """import os
import click
from %s import %s

@click.command(
    name="%s",
    context_settings={"help_option_names": ["--help", "-h"]},
)
@click.argument("path", required=True)
def cli(task):
    %s(task)

if __name__ == "__main__":
    cli()
"""
@click.command(
    name="init-git",
    context_settings={"help_option_names": ["--help", "-h"]},
)
@click.argument("path", required=True)
def init_git(path):
    url = f"https://gitee.com/{path}.git"
    basename = os.path.basename(path)
    pathname = str(basename).replace("-", "_")
    commands = [
        "git init",
        "touch README.md",
        "git add README.md",
        "git commit -m 'init'",
        f"git remote add origin {url}",
        "mkdir -p tests",
        f"mkdir -p {pathname}",
    ]
    for command in commands:
        os.system(command)
    with open(".gitignore", "w") as f:
        f.write(GITIGNORE)
    with open("LICENSE", "w") as f:
        f.write(LICENSE)
    if os.path.exists("main.py"):
        os.unlink("main.py")
    with open(f"{pathname}/main.py", "w") as f:
        f.write(MAIN % (pathname, pathname, basename, pathname))
    with open(f"{pathname}/__init__.py", "w") as f:
        pass
