"""Pipeline control utilities."""

from .loop import mainloop
from .messages import handle_messages
from .state import (
    get_state,
    is_paused,
    is_playing,
    pause,
    play,
    stop,
    wait_for_state,
    wait_for_state_change,
)
from .sync import measure_latency, seek, wait_for_eos

__all__ = [
    # State management
    "play",
    "pause",
    "stop",
    "get_state",
    "wait_for_state",
    "is_playing",
    "is_paused",
    "get_pipeline_state_name",
    "wait_for_state_change",
    # Synchronous operations
    "seek",
    "wait_for_eos",
    "measure_latency",
    # Message handling
    "handle_messages",
    # Main loop utilities
    "mainloop",
]
