"""GStreamer element factory functions organized by category."""

# Core functionality
# Application interface elements
from .app import AppSink, AppSrc, appsink, appsrc
from .base import create

# Encoding/decoding elements
from .encoding import (
    AACDec,
    AACEnc,
    AVDecH264,
    AVDecH265,
    AVDecVP8,
    AVDecVP9,
    DecodeBin,
    OpusDec,
    OpusEnc,
    VorbisDec,
    VorbisEnc,
    VP8Enc,
    VP9Enc,
    X264Enc,
    X265Enc,
    aacdec,
    aacenc,
    avdec_h264,
    avdec_h265,
    avdec_vp8,
    avdec_vp9,
    decodebin,
    opusdec,
    opusenc,
    vorbisdec,
    vorbisenc,
    vp8enc,
    vp9enc,
    x264enc,
    x265enc,
)

# File I/O elements
from .file import FileSink, FileSource, filesink, filesrc

# Muxing and payload elements
from .muxing import (
    AVIMux,
    FLVMux,
    MatroskaMux,
    MP4Mux,
    MPEGTSMux,
    OggMux,
    RTPH264Depay,
    RTPH264Pay,
    RTPH265Depay,
    RTPH265Pay,
    RTPVP8Depay,
    RTPVP8Pay,
    RTPVP9Depay,
    RTPVP9Pay,
    SplitMuxSink,
    WebMMux,
    avimux,
    flvmux,
    matroskamux,
    mp4mux,
    mpegtsmux,
    oggmux,
    payloader,
    rtph264depay,
    rtph265depay,
    rtph265pay,
    rtpvp8depay,
    rtpvp8pay,
    rtpvp9depay,
    rtpvp9pay,
    splitmuxsink,
    webmmux,
)

# Network streaming elements
from .network import (
    RTMPSink,
    RTPSource,
    SHMSink,
    SHMSource,
    UDPSink,
    UDPSource,
    rtmpsink,
    rtmpsrc,
    shmsink,
    shmsrc,
    udpsink,
    udpsrc,
)

# Parser elements
from .parsing import (
    AACParse,
    AC3Parse,
    H264Parse,
    H265Parse,
    MPEGAudioParse,
    RawAudioParse,
    RawVideoParse,
    VP8Parse,
    VP9Parse,
    aacparse,
    ac3parse,
    h264parse,
    h265parse,
    mpegaudioparse,
    rawaudioparse,
    rawvideoparse,
    vp8parse,
    vp9parse,
)

# Video processing elements
from .processing import (
    AudioConvert,
    AudioMixer,
    AudioPanorama,
    AudioResample,
    CapsFilter,
    Compositor,
    Identity,
    Level,
    Queue,
    Tee,
    Valve,
    VideoBox,
    VideoConvert,
    VideoCrop,
    VideoFlip,
    VideoRate,
    VideoScale,
    Volume,
    audioconvert,
    audiomixer,
    audiopanorama,
    audioresample,
    capsfilter,
    compositor,
    identity,
    level,
    queue,
    tee,
    valve,
    videobox,
    videoconvert,
    videocrop,
    videoflip,
    videorate,
    videoscale,
    volume,
)

# Test elements
from .test import VideoTestSource, videotestsrc

__all__ = [
    # Core
    "create",
    # App elements
    "appsrc",
    "appsink",
    "AppSrc",
    "AppSink",
    # Network elements
    "shmsink",
    "shmsrc",
    "udpsink",
    "udpsrc",
    "rtmpsink",
    "rtmpsrc",
    "SHMSink",
    "SHMSource",
    "UDPSink",
    "UDPSource",
    "RTMPSink",
    "RTPSource",
    # Encoding/decoding elements
    "x264enc",
    "x265enc",
    "vp8enc",
    "vp9enc",
    "decodebin",
    "avdec_h264",
    "avdec_h265",
    "avdec_vp8",
    "avdec_vp9",
    "aacenc",
    "opusenc",
    "vorbisenc",
    "aacdec",
    "opusdec",
    "vorbisdec",
    "X264Enc",
    "X265Enc",
    "VP8Enc",
    "VP9Enc",
    "DecodeBin",
    "AVDecH264",
    "AVDecH265",
    "AVDecVP8",
    "AVDecVP9",
    "AACEnc",
    "OpusEnc",
    "VorbisEnc",
    "AACDec",
    "OpusDec",
    "VorbisDec",
    # Parser elements
    "h264parse",
    "h265parse",
    "aacparse",
    "vp8parse",
    "vp9parse",
    "ac3parse",
    "mpegaudioparse",
    "rawaudioparse",
    "rawvideoparse",
    "H264Parse",
    "H265Parse",
    "AACParse",
    "VP8Parse",
    "VP9Parse",
    "AC3Parse",
    "MPEGAudioParse",
    "RawAudioParse",
    "RawVideoParse",
    # Processing elements
    "queue",
    "capsfilter",
    "videoconvert",
    "videoscale",
    "videorate",
    "tee",
    "audioconvert",
    "audioresample",
    "audiopanorama",
    "audiomixer",
    "identity",
    "valve",
    "videoflip",
    "videocrop",
    "videobox",
    "compositor",
    "volume",
    "level",
    "Queue",
    "CapsFilter",
    "VideoConvert",
    "VideoScale",
    "VideoRate",
    "Tee",
    "AudioConvert",
    "AudioResample",
    "AudioPanorama",
    "AudioMixer",
    "Identity",
    "Valve",
    "VideoFlip",
    "VideoCrop",
    "VideoBox",
    "Compositor",
    "Volume",
    "Level",
    # Muxing elements
    "flvmux",
    "mp4mux",
    "qtmux",
    "matroskamux",
    "mpegtsmux",
    "avimux",
    "webmmux",
    "oggmux",
    "payloader",
    "rtph264depay",
    "rtph265pay",
    "rtph265depay",
    "rtpvp8pay",
    "rtpvp8depay",
    "rtpvp9pay",
    "rtpvp9depay",
    "splitmuxsink",
    "FLVMux",
    "MP4Mux",
    "QtMux",
    "MatroskaMux",
    "MPEGTSMux",
    "AVIMux",
    "WebMMux",
    "OggMux",
    "RTPH264Pay",
    "RTPH264Depay",
    "RTPH265Pay",
    "RTPH265Depay",
    "RTPVP8Pay",
    "RTPVP8Depay",
    "RTPVP9Pay",
    "RTPVP9Depay",
    "SplitMuxSink",
    # File elements
    "filesrc",
    "filesink",
    "FileSource",
    "FileSink",
    # Test elements
    "videotestsrc",
    "VideoTestSource",
]
