CREATE TABLE calaccess_processed_campaignfinancefiling AS
SELECT 
   CVR."FILING_ID" AS filing_id,
   CVR."AMEND_ID" AS amend_id,
   CVR."FILER_ID" AS cvr_filer_id,
   XCVR."FILER_ID" AS cvr_xref_filer_id,
   FF."FILER_ID" AS ff_filer_id,
   XFF1."XREF_ID" AS ff_xref_id,
   XFF2."FILER_ID" AS ff_xref_filer_id,
   FN1."FILER_ID",
   FN2."XREF_FILER_ID",
   FN3."FILER_ID",
   FN4."XREF_FILER_ID"
FROM "CVR_CAMPAIGN_DISCLOSURE_CD" CVR
-- join to FILER_FILINGS_CD
JOIN "FILER_FILINGS_CD" FF
ON CVR."FILING_ID" = FF."FILING_ID"
AND CVR."AMEND_ID" = FF."FILING_SEQUENCE"
-- left join to FILER_XREF_CD
LEFT JOIN "FILER_XREF_CD" XCVR
ON CVR."FILER_ID" = XCVR."XREF_ID"
-- left join to FILER_XREF_CD again
LEFT JOIN "FILER_XREF_CD" XFF1
ON FF."FILER_ID" = XFF1."FILER_ID"
-- left join to FILER_XREF_CD again
LEFT JOIN "FILER_XREF_CD" XFF2
ON FF."FILER_ID"::VARCHAR = XFF2."XREF_ID"
--
LEFT JOIN (
    SELECT DISTINCT "FILER_ID"
    FROM "FILERNAME_CD"
) FN1
ON XCVR."FILER_ID" = FN1."FILER_ID"
LEFT JOIN (
    SELECT DISTINCT "XREF_FILER_ID"
    FROM "FILERNAME_CD"
) FN2
ON CVR."FILER_ID" = FN2."XREF_FILER_ID"
--
LEFT JOIN (
    SELECT DISTINCT "FILER_ID"
    FROM "FILERNAME_CD"
) FN3
ON FF."FILER_ID" = FN3."FILER_ID"
LEFT JOIN (
    SELECT DISTINCT "XREF_FILER_ID"
    FROM "FILERNAME_CD"
) FN4
ON XFF1."XREF_ID" = FN4."XREF_FILER_ID"

WHERE XCVR."FILER_ID" <> FF."FILER_ID";