# Copyright (c) Meta Platforms, Inc. and affiliates.
# All rights reserved.
#
# This source code is licensed under the BSD-style license found in the
# LICENSE file in the root directory of this source tree.

from typing import List

supported_langs: List[str] = [
    "aae_Latn",
    "aal_Latn",
    "abb_Latn",
    "abi_Latn",
    "abk_Cyrl",
    "abn_Latn",
    "abp_Latn",
    "abr_Latn",
    "abs_Latn",
    "aca_Latn",
    "acd_Latn",
    "ace_Latn",
    "acf_Latn",
    "ach_Latn",
    "acm_Arab",
    "acn_Latn",
    "acr_Latn",
    "acu_Latn",
    "acw_Arab",
    "ade_Latn",
    "adh_Latn",
    "adj_Latn",
    "adx_Tibt",
    "ady_Cyrl",
    "aeb_Arab",
    "aec_Arab",
    "aeu_Latn",
    "afb_Arab",
    "afo_Latn",
    "afr_Latn",
    "agd_Latn",
    "agg_Latn",
    "agn_Latn",
    "agr_Latn",
    "agu_Latn",
    "agx_Cyrl",
    "aha_Latn",
    "ahk_Latn",
    "ahl_Latn",
    "ahs_Latn",
    "aia_Latn",
    "ajg_Latn",
    "aka_Latn",
    "akb_Latn",
    "ake_Latn",
    "akp_Latn",
    "ala_Latn",
    "alj_Latn",
    "aln_Latn",
    "alo_Latn",
    "alp_Latn",
    "als_Latn",
    "alt_Cyrl",
    "alz_Latn",
    "ame_Latn",
    "amf_Latn",
    "amh_Ethi",
    "ami_Latn",
    "amk_Latn",
    "amu_Latn",
    "anc_Latn",
    "ank_Latn",
    "ann_Latn",
    "anp_Deva",
    "anw_Latn",
    "any_Latn",
    "aom_Latn",
    "aoz_Latn",
    "apb_Latn",
    "apc_Arab",
    "apd_Arab",
    "apr_Latn",
    "arb_Arab",
    "arg_Latn",
    "arl_Latn",
    "arq_Arab",
    "ars_Arab",
    "ary_Arab",
    "arz_Arab",
    "asa_Latn",
    "asg_Latn",
    "asm_Beng",
    "ast_Latn",
    "ata_Latn",
    "atb_Latn",
    "atg_Latn",
    "ati_Latn",
    "atq_Latn",
    "ava_Cyrl",
    "avn_Latn",
    "avu_Latn",
    "awa_Deva",
    "awb_Latn",
    "awo_Latn",
    "ayl_Arab",
    "ayo_Latn",
    "ayp_Arab",
    "ayr_Latn",
    "ayz_Latn",
    "aze_Arab",
    "aze_Cyrl",
    "aze_Latn",
    "azg_Latn",
    "azz_Latn",
    "bag_Latn",
    "bak_Cyrl",
    "bam_Latn",
    "ban_Latn",
    "bao_Latn",
    "bas_Latn",
    "bav_Latn",
    "bax_Latn",
    "bba_Latn",
    "bbb_Latn",
    "bbc_Latn",
    "bbj_Latn",
    "bbl_Geor",
    "bbo_Latn",
    "bbu_Latn",
    "bcc_Arab",
    "bcc_Latn",
    "bce_Latn",
    "bci_Latn",
    "bcl_Latn",
    "bcs_Latn",
    "bcw_Latn",
    "bcy_Latn",
    "bcz_Latn",
    "bda_Latn",
    "bde_Latn",
    "bdg_Latn",
    "bdh_Latn",
    "bdm_Latn",
    "bdq_Latn",
    "bdu_Latn",
    "beb_Latn",
    "beh_Latn",
    "bel_Cyrl",
    "bem_Latn",
    "ben_Beng",
    "bep_Latn",
    "bew_Latn",
    "bex_Latn",
    "bfa_Latn",
    "bfd_Latn",
    "bfo_Latn",
    "bft_Arab",
    "bfy_Deva",
    "bfz_Deva",
    "bgc_Deva",
    "bgp_Arab",
    "bgq_Deva",
    "bgr_Latn",
    "bgt_Latn",
    "bgw_Deva",
    "bha_Deva",
    "bhb_Deva",
    "bhh_Cyrl",
    "bho_Deva",
    "bhp_Latn",
    "bht_Deva",
    "bhz_Latn",
    "bib_Latn",
    "bim_Latn",
    "bis_Latn",
    "biv_Latn",
    "bjj_Deva",
    "bjk_Latn",
    "bjn_Latn",
    "bjr_Latn",
    "bjt_Latn",
    "bjv_Latn",
    "bjw_Latn",
    "bjz_Latn",
    "bkd_Latn",
    "bkh_Latn",
    "bkm_Latn",
    "bkv_Latn",
    "bky_Latn",
    "ble_Latn",
    "blh_Latn",
    "blt_Latn",
    "blx_Latn",
    "blz_Latn",
    "bmm_Latn",
    "bmq_Latn",
    "bmr_Latn",
    "bmu_Latn",
    "bmv_Latn",
    "bng_Beng",
    "bnm_Latn",
    "bnn_Latn",
    "bno_Latn",
    "bnp_Latn",
    "bns_Deva",
    "boa_Latn",
    "bod_Tibt",
    "boj_Latn",
    "bom_Latn",
    "bor_Latn",
    "bos_Latn",
    "bou_Latn",
    "bov_Latn",
    "box_Latn",
    "bpr_Latn",
    "bps_Latn",
    "bqc_Latn",
    "bqg_Latn",
    "bqi_Arab",
    "bqj_Latn",
    "bqp_Latn",
    "bra_Deva",
    "bre_Latn",
    "brh_Arab",
    "bri_Latn",
    "bru_Latn",
    "brx_Deva",
    "bsc_Latn",
    "bsh_Arab",
    "bsj_Latn",
    "bsk_Latn",
    "bsq_Latn",
    "bss_Latn",
    "bsy_Latn",
    "btd_Latn",
    "btm_Latn",
    "bts_Latn",
    "btt_Latn",
    "btv_Arab",
    "btx_Latn",
    "bud_Latn",
    "bug_Latn",
    "bul_Cyrl",
    "bum_Latn",
    "buo_Latn",
    "bus_Latn",
    "bux_Latn",
    "bvb_Latn",
    "bvc_Latn",
    "bvz_Latn",
    "bwq_Latn",
    "bwr_Latn",
    "bwu_Latn",
    "bxf_Latn",
    "bxk_Latn",
    "byc_Latn",
    "byr_Latn",
    "bys_Latn",
    "byv_Latn",
    "byx_Latn",
    "bzh_Latn",
    "bzi_Thai",
    "bzj_Latn",
    "bzw_Latn",
    "caa_Latn",
    "cab_Latn",
    "cac_Latn",
    "cak_Latn",
    "cap_Latn",
    "car_Latn",
    "cas_Latn",
    "cat_Latn",
    "cax_Latn",
    "cbc_Latn",
    "cbi_Latn",
    "cbr_Latn",
    "cbs_Latn",
    "cbt_Latn",
    "cbu_Latn",
    "cbv_Latn",
    "cce_Latn",
    "ccg_Latn",
    "cco_Latn",
    "cdj_Deva",
    "cdo_Hans",
    "ceb_Latn",
    "ceg_Latn",
    "cek_Latn",
    "cen_Latn",
    "ces_Latn",
    "cfa_Latn",
    "cfm_Latn",
    "cgc_Latn",
    "cgg_Latn",
    "che_Cyrl",
    "chf_Latn",
    "chq_Latn",
    "chv_Cyrl",
    "chz_Latn",
    "cjk_Latn",
    "cjo_Latn",
    "cjp_Latn",
    "cjs_Cyrl",
    "ckb_Arab",
    "ckl_Latn",
    "cko_Latn",
    "ckr_Latn",
    "ckt_Cyrl",
    "cky_Latn",
    "cla_Latn",
    "cle_Latn",
    "cly_Latn",
    "cme_Latn",
    "cmn_Hans",
    "cmn_Hant",
    "cmo_Khmr",
    "cmo_Latn",
    "cmr_Latn",
    "cnh_Latn",
    "cni_Latn",
    "cnl_Latn",
    "cnt_Latn",
    "coe_Latn",
    "cof_Latn",
    "cok_Latn",
    "con_Latn",
    "cor_Latn",
    "cot_Latn",
    "cou_Latn",
    "cpa_Latn",
    "cpb_Latn",
    "cpu_Latn",
    "cpx_Hans",
    "cpy_Latn",
    "crh_Cyrl",
    "crk_Cans",
    "crk_Latn",
    "crn_Latn",
    "crq_Latn",
    "crs_Latn",
    "crt_Latn",
    "csk_Latn",
    "cso_Latn",
    "ctd_Latn",
    "cte_Latn",
    "ctg_Beng",
    "ctl_Latn",
    "cto_Latn",
    "ctu_Latn",
    "cuc_Latn",
    "cui_Latn",
    "cuk_Latn",
    "cul_Latn",
    "cut_Latn",
    "cux_Latn",
    "cwa_Latn",
    "cwe_Latn",
    "cwt_Latn",
    "cya_Latn",
    "cym_Latn",
    "daa_Latn",
    "dag_Latn",
    "dah_Latn",
    "dan_Latn",
    "dar_Cyrl",
    "dav_Latn",
    "dbd_Latn",
    "dbj_Latn",
    "dbq_Latn",
    "dcc_Arab",
    "ddn_Latn",
    "ded_Latn",
    "deg_Latn",
    "des_Latn",
    "deu_Latn",
    "dga_Latn",
    "dgh_Latn",
    "dgi_Latn",
    "dgk_Latn",
    "dgo_Deva",
    "dgr_Latn",
    "dhi_Deva",
    "did_Latn",
    "dig_Latn",
    "dik_Latn",
    "dip_Latn",
    "div_Thaa",
    "dje_Latn",
    "djk_Latn",
    "dmk_Arab",
    "dml_Arab",
    "dnj_Latn",
    "dnt_Latn",
    "dnw_Latn",
    "dop_Latn",
    "dos_Latn",
    "dru_Latn",
    "dsb_Latn",
    "dsh_Latn",
    "dtp_Latn",
    "dts_Latn",
    "dty_Deva",
    "dua_Latn",
    "dug_Latn",
    "dwr_Latn",
    "dyi_Latn",
    "dyo_Latn",
    "dyu_Latn",
    "dzg_Latn",
    "dzo_Tibt",
    "ebu_Latn",
    "ego_Latn",
    "eip_Latn",
    "eiv_Latn",
    "eka_Latn",
    "ekk_Latn",
    "eko_Latn",
    "ekr_Latn",
    "ell_Grek",
    "ell_Grek_cypr1249",
    "elm_Latn",
    "emp_Latn",
    "enb_Latn",
    "eng_Latn",
    "enx_Latn",
    "epo_Latn",
    "ese_Latn",
    "ess_Latn",
    "esu_Latn",
    "eto_Latn",
    "ets_Latn",
    "etu_Latn",
    "eus_Latn",
    "evn_Cyrl",
    "ewe_Latn",
    "ewo_Latn",
    "eyo_Latn",
    "eza_Latn",
    "fal_Latn",
    "fan_Latn",
    "fao_Latn",
    "far_Latn",
    "fas_Arab",
    "fat_Latn",
    "fia_Latn",
    "fij_Latn",
    "fil_Latn",
    "fin_Latn",
    "fip_Latn",
    "fkk_Latn",
    "flr_Latn",
    "fmp_Latn",
    "fmu_Deva",
    "fon_Latn",
    "fra_Latn",
    "frd_Latn",
    "fry_Latn",
    "fub_Latn",
    "fuc_Latn",
    "fue_Latn",
    "ful_Latn",
    "fuq_Latn",
    "fuv_Latn",
    "gag_Cyrl",
    "gag_Latn",
    "gai_Latn",
    "gam_Latn",
    "gau_Telu",
    "gbi_Latn",
    "gbk_Deva",
    "gbm_Deva",
    "gbo_Latn",
    "gbr_Latn",
    "gby_Latn",
    "gcc_Latn",
    "gde_Latn",
    "gdf_Latn",
    "geb_Latn",
    "gej_Latn",
    "ges_Latn",
    "ggg_Arab",
    "gid_Latn",
    "gig_Arab",
    "gil_Latn",
    "giz_Latn",
    "gjk_Arab",
    "gjn_Latn",
    "gju_Arab",
    "gkn_Latn",
    "gld_Cyrl",
    "gle_Latn",
    "glg_Latn",
    "glk_Arab",
    "glv_Latn",
    "glw_Latn",
    "gmv_Latn",
    "gna_Latn",
    "gnd_Latn",
    "gng_Latn",
    "gof_Latn",
    "gog_Latn",
    "gol_Latn",
    "gom_Deva",
    "gor_Latn",
    "gqr_Latn",
    "grc_Grek",
    "gri_Latn",
    "grn_Latn",
    "grt_Beng",
    "gsl_Latn",
    "gso_Latn",
    "gub_Latn",
    "guc_Latn",
    "gud_Latn",
    "gug_Latn",
    "guh_Latn",
    "gui_Latn",
    "guj_Gujr",
    "guk_Ethi",
    "gum_Latn",
    "guo_Latn",
    "guq_Latn",
    "gur_Latn",
    "guu_Latn",
    "gux_Latn",
    "guz_Latn",
    "gvc_Latn",
    "gvl_Latn",
    "gwc_Arab",
    "gwe_Latn",
    "gwi_Latn",
    "gwr_Latn",
    "gwt_Arab",
    "gym_Latn",
    "gyr_Latn",
    "gyz_Latn",
    "had_Latn",
    "hag_Latn",
    "hah_Latn",
    "hak_Latn",
    "hao_Latn",
    "hap_Latn",
    "hat_Latn",
    "hau_Latn",
    "haw_Latn",
    "hay_Latn",
    "hbb_Latn",
    "hch_Latn",
    "heb_Hebr",
    "heh_Latn",
    "her_Latn",
    "hia_Latn",
    "hif_Latn",
    "hig_Latn",
    "hil_Latn",
    "hin_Deva",
    "hkk_Latn",
    "hla_Latn",
    "hlb_Deva",
    "hlt_Latn",
    "hne_Deva",
    "hnn_Latn",
    "hno_Arab",
    "hns_Latn",
    "hoc_Orya",
    "hrv_Latn",
    "hsb_Latn",
    "hto_Latn",
    "hub_Latn",
    "hue_Latn",
    "hui_Latn",
    "hul_Latn",
    "hun_Latn",
    "hus_Latn",
    "huu_Latn",
    "huv_Latn",
    "hux_Latn",
    "hvn_Latn",
    "hwc_Latn",
    "hwo_Latn",
    "hye_Armn",
    "hyw_Armn",
    "iba_Latn",
    "ibb_Latn",
    "ibo_Latn",
    "icr_Latn",
    "ida_Latn",
    "idd_Latn",
    "idu_Latn",
    "ifa_Latn",
    "ifb_Latn",
    "ife_Latn",
    "ifk_Latn",
    "ifu_Latn",
    "ify_Latn",
    "igl_Latn",
    "ign_Latn",
    "ijc_Latn",
    "ijn_Latn",
    "ikk_Latn",
    "ikw_Latn",
    "ilb_Latn",
    "ilo_Latn",
    "imo_Latn",
    "ina_Latn",
    "inb_Latn",
    "ind_Latn",
    "iou_Latn",
    "ipi_Latn",
    "ipk_Latn",
    "iqw_Latn",
    "iri_Latn",
    "irk_Latn",
    "ish_Latn",
    "isl_Latn",
    "iso_Latn",
    "ita_Latn",
    "itl_Cyrl",
    "its_Latn",
    "itv_Latn",
    "itw_Latn",
    "itz_Latn",
    "ixl_Latn",
    "izr_Latn",
    "izz_Latn",
    "jac_Latn",
    "jal_Latn",
    "jam_Latn",
    "jav_Latn",
    "jax_Latn",
    "jbu_Latn",
    "jen_Latn",
    "jic_Latn",
    "jiv_Latn",
    "jmc_Latn",
    "jmd_Latn",
    "jmx_Latn",
    "jpn_Jpan",
    "jqr_Latn",
    "juk_Latn",
    "jun_Orya",
    "juo_Latn",
    "jvn_Latn",
    "kaa_Cyrl",
    "kab_Latn",
    "kac_Latn",
    "kai_Latn",
    "kaj_Latn",
    "kak_Latn",
    "kam_Latn",
    "kan_Knda",
    "kao_Latn",
    "kaq_Latn",
    "kas_Arab",
    "kat_Geor",
    "kay_Latn",
    "kaz_Cyrl",
    "kbd_Cyrl",
    "kbl_Latn",
    "kbo_Latn",
    "kbp_Latn",
    "kbq_Latn",
    "kbr_Latn",
    "kbt_Latn",
    "kby_Latn",
    "kca_Cyrl",
    "kcg_Latn",
    "kcn_Latn",
    "kcq_Latn",
    "kdc_Latn",
    "kde_Latn",
    "kdh_Latn",
    "kdi_Latn",
    "kdj_Latn",
    "kdl_Latn",
    "kdn_Latn",
    "kdt_Khmr",
    "kea_Latn",
    "kek_Latn",
    "ken_Latn",
    "keo_Latn",
    "ker_Latn",
    "keu_Latn",
    "key_Telu",
    "kez_Latn",
    "kfb_Deva",
    "kff_Telu",
    "kfk_Deva",
    "kfq_Deva",
    "kfr_Gujr",
    "kfw_Latn",
    "kfx_Deva",
    "kha_Latn",
    "khg_Tibt",
    "khk_Cyrl",
    "khm_Khmr",
    "khq_Latn",
    "khw_Arab",
    "kia_Latn",
    "kij_Latn",
    "kik_Latn",
    "kin_Latn",
    "kir_Cyrl",
    "kix_Latn",
    "kjb_Latn",
    "kjc_Latn",
    "kje_Latn",
    "kjg_Latn",
    "kjh_Cyrl",
    "kjk_Latn",
    "kki_Latn",
    "kkj_Latn",
    "kle_Deva",
    "kln_Latn",
    "kls_Latn",
    "klu_Latn",
    "klv_Latn",
    "klw_Latn",
    "kma_Latn",
    "kmd_Latn",
    "kml_Latn",
    "kmr_Arab",
    "kmr_Cyrl",
    "kmr_Latn",
    "kmu_Latn",
    "kmy_Latn",
    "kna_Latn",
    "knb_Latn",
    "knc_Latn",
    "kne_Latn",
    "knf_Latn",
    "knj_Latn",
    "knk_Latn",
    "knn_Deva",
    "kno_Latn",
    "kog_Latn",
    "kol_Latn",
    "koo_Latn",
    "kor_Hang",
    "kpo_Latn",
    "kpq_Latn",
    "kps_Latn",
    "kpv_Cyrl",
    "kpy_Cyrl",
    "kpz_Latn",
    "kqe_Latn",
    "kqo_Latn",
    "kqp_Latn",
    "kqr_Latn",
    "kqy_Ethi",
    "krc_Cyrl",
    "kri_Latn",
    "krj_Latn",
    "krl_Latn",
    "krr_Khmr",
    "krs_Latn",
    "kru_Deva",
    "krx_Latn",
    "ksb_Latn",
    "ksd_Latn",
    "ksf_Latn",
    "ksr_Latn",
    "kss_Latn",
    "ksz_Deva",
    "ktb_Ethi",
    "ktj_Latn",
    "kto_Latn",
    "kua_Latn",
    "kub_Latn",
    "kue_Latn",
    "kuh_Latn",
    "kum_Cyrl",
    "kur_Arab",
    "kus_Latn",
    "kvn_Latn",
    "kvw_Latn",
    "kvx_Arab",
    "kwd_Latn",
    "kwf_Latn",
    "kwi_Latn",
    "kwm_Latn",
    "kxc_Ethi",
    "kxf_Latn",
    "kxm_Thai",
    "kxp_Arab",
    "kyb_Latn",
    "kyc_Latn",
    "kyf_Latn",
    "kyg_Latn",
    "kyo_Latn",
    "kyq_Latn",
    "kyu_Kali",
    "kyx_Latn",
    "kyz_Latn",
    "kzf_Latn",
    "kzi_Latn",
    "lac_Latn",
    "lag_Latn",
    "laj_Latn",
    "lam_Latn",
    "lao_Laoo",
    "las_Latn",
    "lat_Latn",
    "lav_Latn",
    "law_Latn",
    "lbj_Tibt",
    "lbw_Latn",
    "lcm_Latn",
    "lcp_Thai",
    "ldb_Latn",
    "led_Latn",
    "lee_Latn",
    "lef_Latn",
    "lem_Latn",
    "lew_Latn",
    "lex_Latn",
    "lgg_Latn",
    "lgl_Latn",
    "lhu_Latn",
    "lia_Latn",
    "lid_Latn",
    "lif_Deva",
    "lij_Latn",
    "lin_Latn",
    "lip_Latn",
    "lir_Latn",
    "lis_Lisu",
    "lit_Latn",
    "lje_Latn",
    "ljp_Latn",
    "lkb_Latn",
    "lke_Latn",
    "lla_Latn",
    "lld_Latn_gherd",
    "lld_Latn_valbadia",
    "llg_Latn",
    "lln_Latn",
    "lme_Latn",
    "lnd_Latn",
    "lns_Latn",
    "lnu_Latn",
    "loa_Latn",
    "lob_Latn",
    "lok_Latn",
    "lom_Latn",
    "lon_Latn",
    "loq_Latn",
    "lrk_Arab",
    "lsi_Latn",
    "lsm_Latn",
    "lss_Arab",
    "ltg_Latn",
    "lth_Latn",
    "lto_Latn",
    "ltz_Latn",
    "lua_Latn",
    "luc_Latn",
    "lug_Latn",
    "luo_Latn",
    "lus_Latn",
    "lwg_Latn",
    "lwo_Latn",
    "lww_Latn",
    "lzz_Latn",
    "maa_Latn",
    "mab_Latn",
    "mad_Latn",
    "maf_Latn",
    "mag_Deva",
    "mah_Latn",
    "mai_Deva",
    "maj_Latn",
    "mak_Latn",
    "mal_Mlym",
    "mam_Latn",
    "maq_Latn",
    "mar_Deva",
    "mau_Latn",
    "maw_Latn",
    "max_Latn",
    "maz_Latn",
    "mbb_Latn",
    "mbc_Latn",
    "mbh_Latn",
    "mbj_Latn",
    "mbt_Latn",
    "mbu_Latn",
    "mca_Latn",
    "mcb_Latn",
    "mcd_Latn",
    "mcf_Latn",
    "mco_Latn",
    "mcp_Latn",
    "mcq_Latn",
    "mcu_Latn",
    "mcx_Latn",
    "mda_Latn",
    "mdd_Latn",
    "mdv_Latn",
    "mdy_Ethi",
    "med_Latn",
    "mee_Latn",
    "meh_Latn",
    "mej_Latn",
    "mek_Latn",
    "mel_Latn",
    "men_Latn",
    "meq_Latn",
    "mer_Latn",
    "met_Latn",
    "meu_Latn",
    "mev_Latn",
    "mfe_Latn",
    "mfh_Latn",
    "mfi_Latn",
    "mfk_Latn",
    "mfm_Latn",
    "mfn_Latn",
    "mfo_Latn",
    "mfq_Latn",
    "mfv_Latn",
    "mfy_Latn",
    "mfz_Latn",
    "mgd_Latn",
    "mge_Latn",
    "mgg_Latn",
    "mgh_Latn",
    "mgi_Latn",
    "mgo_Latn",
    "mhi_Latn",
    "mhk_Latn",
    "mhr_Cyrl",
    "mhu_Latn",
    "mhx_Latn",
    "mhy_Latn",
    "mib_Latn",
    "mie_Latn",
    "mif_Latn",
    "mig_Latn",
    "mih_Latn",
    "mil_Latn",
    "mim_Latn",
    "min_Latn",
    "mio_Latn",
    "mip_Latn",
    "miq_Latn",
    "mit_Latn",
    "miu_Latn",
    "miy_Latn",
    "miz_Latn",
    "mjl_Deva",
    "mjv_Mlym",
    "mkd_Cyrl",
    "mkf_Latn",
    "mki_Arab",
    "mkl_Latn",
    "mkn_Latn",
    "mlg_Latn",
    "mlq_Latn",
    "mlt_Latn",
    "mmc_Latn",
    "mmg_Latn",
    "mnb_Latn",
    "mne_Latn",
    "mnf_Latn",
    "mni_Beng",
    "mnk_Latn",
    "mnw_Mymr",
    "mnx_Latn",
    "moa_Latn",
    "mog_Latn",
    "mon_Cyrl",
    "mop_Latn",
    "mor_Latn",
    "mos_Latn",
    "mox_Latn",
    "moz_Latn",
    "mpg_Latn",
    "mpm_Latn",
    "mpp_Latn",
    "mpx_Latn",
    "mqb_Latn",
    "mqf_Latn",
    "mqj_Latn",
    "mqn_Latn",
    "mqy_Latn",
    "mri_Latn",
    "mrj_Cyrl",
    "mrr_Deva",
    "mrt_Latn",
    "mrw_Latn",
    "msh_Latn",
    "msi_Latn",
    "msw_Latn",
    "msy_Latn",
    "mtd_Latn",
    "mtj_Latn",
    "mto_Latn",
    "mtr_Deva",
    "mtu_Latn",
    "mtx_Latn",
    "mua_Latn",
    "mug_Latn",
    "muh_Latn",
    "mui_Latn",
    "mup_Deva",
    "mur_Latn",
    "muv_Mlym",
    "muy_Latn",
    "mve_Arab",
    "mvp_Latn",
    "mvy_Arab",
    "mwq_Latn",
    "mwv_Latn",
    "mxb_Latn",
    "mxq_Latn",
    "mxs_Latn",
    "mxt_Latn",
    "mxu_Latn",
    "mxv_Latn",
    "mxy_Latn",
    "mya_Mymr",
    "myb_Latn",
    "myk_Latn",
    "myv_Cyrl",
    "myx_Latn",
    "myy_Latn",
    "mza_Latn",
    "mzi_Latn",
    "mzj_Latn",
    "mzk_Latn",
    "mzl_Latn",
    "mzm_Latn",
    "mzw_Latn",
    "nab_Latn",
    "nag_Latn",
    "nal_Latn",
    "nan_Latn",
    "nap_Latn",
    "nas_Latn",
    "naw_Latn",
    "nbh_Latn",
    "nca_Latn",
    "ncf_Latn",
    "nch_Latn",
    "ncj_Latn",
    "ncl_Latn",
    "nco_Latn",
    "ncu_Latn",
    "ncx_Latn",
    "ndi_Latn",
    "ndj_Latn",
    "ndo_Latn",
    "ndp_Latn",
    "ndv_Latn",
    "ndy_Latn",
    "ndz_Latn",
    "neb_Latn",
    "nep_Deva",
    "new_Deva",
    "nfa_Latn",
    "nfr_Latn",
    "nga_Latn",
    "ngi_Latn",
    "ngl_Latn",
    "ngp_Latn",
    "ngu_Latn",
    "nhe_Latn",
    "nhg_Latn",
    "nhi_Latn",
    "nhn_Latn",
    "nhq_Latn",
    "nhu_Latn",
    "nhw_Latn",
    "nhx_Latn",
    "nhy_Latn",
    "nia_Latn",
    "nij_Latn",
    "nim_Latn",
    "nin_Latn",
    "nja_Latn",
    "nko_Latn",
    "nla_Latn",
    "nlc_Latn",
    "nld_Latn",
    "nlg_Latn",
    "nlk_Latn",
    "nlv_Latn",
    "nmg_Latn",
    "nmz_Latn",
    "nnb_Latn",
    "nnh_Latn",
    "nnq_Latn",
    "nnw_Latn",
    "noa_Latn",
    "nob_Latn",
    "nod_Thai",
    "noe_Deva",
    "nog_Cyrl",
    "not_Latn",
    "npl_Latn",
    "npy_Latn",
    "nso_Latn",
    "nst_Latn",
    "nsu_Latn",
    "ntm_Latn",
    "ntr_Latn",
    "nuj_Latn",
    "nup_Latn",
    "nus_Latn",
    "nuz_Latn",
    "nwb_Latn",
    "nxq_Latn",
    "nya_Latn",
    "nyf_Latn",
    "nyn_Latn",
    "nyo_Latn",
    "nyu_Latn",
    "nyy_Latn",
    "nzi_Latn",
    "obo_Latn",
    "oci_Latn",
    "odk_Arab",
    "odu_Latn",
    "ogo_Latn",
    "ojb_Cans",
    "ojb_Latn",
    "oku_Latn",
    "old_Latn",
    "omw_Latn",
    "onb_Latn",
    "ood_Latn",
    "orc_Latn",
    "orm_Latn",
    "oru_Arab",
    "ory_Orya",
    "oss_Cyrl",
    "ote_Latn",
    "otq_Latn",
    "ozm_Latn",
    "pab_Latn",
    "pad_Latn",
    "pag_Latn",
    "pam_Latn",
    "pan_Guru",
    "pao_Latn",
    "pap_Latn",
    "pau_Latn",
    "pbb_Latn",
    "pbc_Latn",
    "pbi_Latn",
    "pbs_Latn",
    "pbt_Arab",
    "pbu_Arab",
    "pce_Thai",
    "pcm_Latn",
    "pex_Latn",
    "pez_Latn",
    "phl_Arab",
    "phr_Arab",
    "pib_Latn",
    "pil_Latn",
    "pip_Latn",
    "pir_Latn",
    "pis_Latn",
    "piy_Latn",
    "pjt_Latn",
    "pkb_Latn",
    "pko_Latn",
    "plk_Arab",
    "pls_Latn",
    "plt_Latn",
    "plw_Latn",
    "pmf_Latn",
    "pmq_Latn",
    "pms_Latn",
    "pmy_Latn",
    "pnb_Arab",
    "pne_Latn",
    "pny_Latn",
    "poc_Latn",
    "poe_Latn",
    "poh_Latn",
    "poi_Latn",
    "pol_Latn",
    "por_Latn",
    "pov_Latn",
    "pow_Latn",
    "poy_Latn",
    "ppk_Latn",
    "pps_Latn",
    "prf_Latn",
    "prk_Latn",
    "prq_Latn",
    "prt_Thai",
    "pse_Latn",
    "pss_Latn",
    "pst_Arab",
    "ptu_Latn",
    "pua_Latn",
    "pui_Latn",
    "pus_Arab",
    "pwg_Latn",
    "pwn_Latn",
    "pww_Thai",
    "pxm_Latn",
    "qub_Latn",
    "quc_Latn",
    "quf_Latn",
    "qug_Latn",
    "quh_Latn",
    "qul_Latn",
    "qum_Latn",
    "qup_Latn",
    "qur_Latn",
    "qus_Latn",
    "quv_Latn",
    "quw_Latn",
    "qux_Latn",
    "quy_Latn",
    "quz_Latn",
    "qva_Latn",
    "qvc_Latn",
    "qve_Latn",
    "qvh_Latn",
    "qvi_Latn",
    "qvj_Latn",
    "qvl_Latn",
    "qvm_Latn",
    "qvn_Latn",
    "qvo_Latn",
    "qvs_Latn",
    "qvw_Latn",
    "qvz_Latn",
    "qwa_Latn",
    "qwh_Latn",
    "qws_Latn",
    "qxa_Latn",
    "qxh_Latn",
    "qxl_Latn",
    "qxn_Latn",
    "qxo_Latn",
    "qxp_Latn",
    "qxr_Latn",
    "qxt_Latn",
    "qxu_Latn",
    "qxw_Latn",
    "rag_Latn",
    "rah_Beng",
    "rai_Latn",
    "rap_Latn",
    "rav_Deva",
    "raw_Latn",
    "rej_Latn",
    "rel_Latn",
    "rgu_Latn",
    "rhg_Latn",
    "rif_Arab",
    "rif_Latn",
    "rim_Latn",
    "rjs_Deva",
    "rkt_Beng",
    "rmc_Cyrl",
    "rmc_Latn",
    "rmo_Latn",
    "rmy_Cyrl",
    "rmy_Latn",
    "rng_Latn",
    "rnl_Latn",
    "rob_Latn",
    "rof_Latn",
    "roh_Latn_surs1244",
    "rol_Latn",
    "ron_Latn",
    "roo_Latn",
    "rop_Latn",
    "rro_Latn",
    "rth_Latn",
    "rub_Latn",
    "ruc_Latn",
    "ruf_Latn",
    "rug_Latn",
    "run_Latn",
    "rus_Cyrl",
    "rwm_Latn",
    "rwr_Deva",
    "sab_Latn",
    "sag_Latn",
    "sah_Cyrl",
    "saj_Latn",
    "saq_Latn",
    "sas_Latn",
    "sau_Latn",
    "say_Latn",
    "sba_Latn",
    "sbd_Latn",
    "sbl_Latn",
    "sbn_Arab",
    "sbp_Latn",
    "sch_Latn",
    "sck_Deva",
    "scl_Arab",
    "scn_Latn",
    "sco_Latn",
    "sda_Latn",
    "sdo_Latn",
    "sea_Latn",
    "seh_Latn",
    "sei_Latn",
    "ses_Latn",
    "sey_Latn",
    "sgb_Latn",
    "sgj_Deva",
    "sgw_Ethi",
    "shi_Latn",
    "shk_Latn",
    "shn_Mymr",
    "sho_Latn",
    "shp_Latn",
    "sid_Latn",
    "sig_Latn",
    "sil_Latn",
    "sin_Sinh",
    "sip_Tibt",
    "siw_Latn",
    "sja_Latn",
    "sjm_Latn",
    "sjp_Deva",
    "sjr_Latn",
    "skg_Latn",
    "skr_Arab",
    "sld_Latn",
    "slk_Latn",
    "slu_Latn",
    "slv_Latn",
    "sml_Latn",
    "smo_Latn",
    "sna_Latn",
    "snc_Latn",
    "snd_Arab",
    "sne_Latn",
    "snk_Latn",
    "snn_Latn",
    "snp_Latn",
    "snv_Latn",
    "snw_Latn",
    "sol_Latn",
    "som_Latn",
    "soy_Latn",
    "spa_Latn",
    "spp_Latn",
    "sps_Latn",
    "spy_Latn",
    "src_Latn",
    "srd_Latn",
    "sri_Latn",
    "srm_Latn",
    "srn_Latn",
    "sro_Latn",
    "srp_Cyrl",
    "srr_Latn",
    "srx_Deva",
    "ssi_Arab",
    "ste_Latn",
    "stn_Latn",
    "stp_Latn",
    "sua_Latn",
    "suc_Latn",
    "suk_Latn",
    "sun_Latn",
    "sur_Latn",
    "sus_Latn",
    "suv_Latn",
    "suz_Deva",
    "sva_Geor",
    "swe_Latn",
    "swh_Latn",
    "swv_Deva",
    "sxb_Latn",
    "sxn_Latn",
    "sya_Latn",
    "syl_Latn",
    "sza_Latn",
    "szy_Latn",
    "tac_Latn",
    "taj_Deva",
    "tam_Taml",
    "tan_Latn",
    "tao_Latn",
    "tap_Latn",
    "taq_Latn",
    "tar_Latn",
    "tat_Cyrl",
    "tav_Latn",
    "tay_Latn",
    "tbc_Latn",
    "tbf_Latn",
    "tbg_Latn",
    "tbk_Latn",
    "tbl_Latn",
    "tby_Latn",
    "tbz_Latn",
    "tca_Latn",
    "tcc_Latn",
    "tcf_Latn",
    "tcy_Mlym",
    "tcz_Latn",
    "tdj_Latn",
    "tdn_Latn",
    "tdx_Latn",
    "ted_Latn",
    "tee_Latn",
    "tel_Telu",
    "tem_Latn",
    "teo_Latn",
    "ter_Latn",
    "tew_Latn",
    "tex_Latn",
    "tfr_Latn",
    "tgc_Latn",
    "tgj_Latn",
    "tgk_Cyrl",
    "tgl_Latn",
    "tgo_Latn",
    "tgp_Latn",
    "tha_Thai",
    "the_Deva",
    "thk_Latn",
    "thl_Deva",
    "thq_Deva",
    "thr_Deva",
    "thv_Tfng",
    "tig_Ethi",
    "tih_Latn",
    "tik_Latn",
    "tio_Latn",
    "tir_Ethi",
    "tkg_Latn",
    "tkr_Latn",
    "tkt_Deva",
    "tlb_Latn",
    "tli_Latn",
    "tlj_Latn",
    "tlp_Latn",
    "tly_Latn",
    "tmc_Latn",
    "tmf_Latn",
    "tna_Latn",
    "tng_Latn",
    "tnk_Latn",
    "tnn_Latn",
    "tnp_Latn",
    "tnr_Latn",
    "tnt_Latn",
    "tob_Latn",
    "toc_Latn",
    "toh_Latn",
    "tok_Latn",
    "tom_Latn",
    "top_Latn",
    "tos_Latn",
    "tpi_Latn",
    "tpl_Latn",
    "tpm_Latn",
    "tpp_Latn",
    "tpt_Latn",
    "tpz_Latn",
    "tqp_Latn",
    "trc_Latn",
    "tri_Latn",
    "trn_Latn",
    "trp_Latn",
    "trq_Latn",
    "trs_Latn",
    "trv_Latn",
    "trw_Arab",
    "tsn_Latn",
    "tso_Latn",
    "tsz_Latn",
    "ttc_Latn",
    "tte_Latn",
    "ttj_Latn",
    "ttq_Tfng",
    "ttr_Latn",
    "ttu_Latn",
    "tue_Latn",
    "tuf_Latn",
    "tui_Latn",
    "tuk_Arab",
    "tuk_Latn",
    "tul_Latn",
    "tuo_Latn",
    "tuq_Latn",
    "tur_Latn",
    "tuv_Latn",
    "tuy_Latn",
    "tvo_Latn",
    "tvu_Latn",
    "tvw_Latn",
    "twb_Latn",
    "twe_Latn",
    "twu_Latn",
    "txa_Latn",
    "txq_Latn",
    "txs_Latn",
    "txu_Latn",
    "txy_Latn",
    "tye_Latn",
    "tzh_Latn",
    "tzj_Latn",
    "tzo_Latn",
    "ubl_Latn",
    "ubu_Latn",
    "udl_Latn",
    "udm_Cyrl",
    "udu_Latn",
    "uig_Arab",
    "uig_Cyrl",
    "uki_Orya",
    "ukr_Cyrl",
    "ukv_Latn",
    "umb_Latn",
    "upv_Latn",
    "ura_Latn",
    "urb_Latn",
    "urd_Arab",
    "urd_Deva",
    "urd_Latn",
    "urh_Latn",
    "urk_Thai",
    "urt_Latn",
    "ury_Latn",
    "ush_Arab",
    "usp_Latn",
    "uzb_Cyrl",
    "uzb_Latn",
    "uzn_Latn",
    "vag_Latn",
    "vah_Deva",
    "vai_Latn",
    "var_Latn",
    "ver_Latn",
    "vid_Latn",
    "vie_Latn",
    "vif_Latn",
    "vmc_Latn",
    "vmj_Latn",
    "vmm_Latn",
    "vmp_Latn",
    "vmw_Latn",
    "vmy_Latn",
    "vmz_Latn",
    "vro_Latn",
    "vun_Latn",
    "vut_Latn",
    "wal_Ethi",
    "wal_Latn",
    "wap_Latn",
    "war_Latn",
    "waw_Latn",
    "way_Latn",
    "wba_Latn",
    "wbl_Latn",
    "wbr_Deva",
    "wci_Latn",
    "weo_Latn",
    "wes_Latn",
    "wja_Latn",
    "wji_Latn",
    "wlo_Latn",
    "wlx_Latn",
    "wmw_Latn",
    "wob_Latn",
    "wof_Latn",
    "wol_Latn",
    "wsg_Telu",
    "wwa_Latn",
    "xal_Cyrl",
    "xdy_Latn",
    "xed_Latn",
    "xer_Latn",
    "xhe_Arab",
    "xho_Latn",
    "xka_Arab",
    "xkl_Latn",
    "xmf_Geor",
    "xmm_Latn",
    "xmv_Latn",
    "xnj_Latn",
    "xnr_Deva",
    "xog_Latn",
    "xon_Latn",
    "xpe_Latn",
    "xrb_Latn",
    "xsb_Latn",
    "xsm_Latn",
    "xsr_Deva",
    "xsu_Latn",
    "xta_Latn",
    "xtd_Latn",
    "xte_Latn",
    "xti_Latn",
    "xtm_Latn",
    "xtn_Latn",
    "xtu_Latn",
    "xua_Taml",
    "xuo_Latn",
    "yaa_Latn",
    "yad_Latn",
    "yal_Latn",
    "yam_Latn",
    "yao_Latn",
    "yaq_Latn",
    "yas_Latn",
    "yat_Latn",
    "yav_Latn",
    "yay_Latn",
    "yaz_Latn",
    "yba_Latn",
    "ybb_Latn",
    "ycl_Latn",
    "ycn_Latn",
    "ydd_Hebr",
    "ydg_Arab",
    "yea_Mlym",
    "yer_Latn",
    "yes_Latn",
    "yka_Latn",
    "yli_Latn",
    "yor_Latn",
    "yre_Latn",
    "yua_Latn",
    "yue_Hans",
    "yue_Hant",
    "yuz_Latn",
    "yva_Latn",
    "zaa_Latn",
    "zab_Latn",
    "zac_Latn",
    "zad_Latn",
    "zae_Latn",
    "zai_Latn",
    "zam_Latn",
    "zao_Latn",
    "zaq_Latn",
    "zar_Latn",
    "zas_Latn",
    "zav_Latn",
    "zaw_Latn",
    "zca_Latn",
    "zga_Latn",
    "zim_Latn",
    "ziw_Latn",
    "zmz_Latn",
    "zne_Latn",
    "zoc_Latn",
    "zoh_Latn",
    "zor_Latn",
    "zos_Latn",
    "zpc_Latn",
    "zpg_Latn",
    "zpi_Latn",
    "zpl_Latn",
    "zpm_Latn",
    "zpo_Latn",
    "zpt_Latn",
    "zpu_Latn",
    "zpv_Latn",
    "zpy_Latn",
    "zpz_Latn",
    "zsm_Latn",
    "ztg_Latn",
    "ztn_Latn",
    "ztp_Latn",
    "ztq_Latn",
    "zts_Latn",
    "ztu_Latn",
    "zty_Latn",
    "zul_Latn",
    "zyb_Latn",
    "zyp_Latn",
    "zza_Latn",
]
