# zdbg

A (nearly) zero-cost library for printing debugging and error messages from Python programs that is trivial to use, while also giving you the following.

- Per-stream output selection (errors and debugging messages).
- Color-tagged labels.
- Optional timestamps and file context information.
- Zero-cost disable path (via rebinding debug to a no-op).
- Atomic thread-safe reconfiguration.
- Optional stream flush behavior.
- No handler objects, logger objects, format strings, or logger factories.
- A single `configure()` function determining all output behavior.
- NO additional dependencies beyond the standard Python libraries.

How simple is **zdbg** to use? The following is an example.

```python
import zdbg

if __name__ == "__main__":
    zdbg.debug("Starting")
    zdbg.error("Nothing to do")
    zdbg.debug("Stopping")
```

Put the above in `ztest.py` and then try the following.

```bash
$ python3 ./ztest.py
Error: Nothing to do

$ DEBUG=debug python3 ./ztest.py
DEBUG: Starting
Error: Nothing to do
DEBUG: Stopping

$ DEBUG=debug,context python3 ./ztest.py
DEBUG: ./ztest.py:8: Starting
Error: ./ztest.py:9: Nothing to do
DEBUG: ./ztest.py:10: Stopping
```

![Screenshot of shell interaction](https://gitlab.com/sprowell/zdbg/-/raw/main/etc/bash1.png?ref_type=heads)

The format of the error context string makes it clickable in many tools, including Visual Studio Code.

## Why zdbg

I wanted something simple with zero overhead when debugging is disabled, without other dependencies, and with configurability without having to do a lot of work up front to get things working.

If that sounds good, then Welcome!

**zdbg** uses [Semantic Versioning][].

## Performance

"Zero cost?" Well... of course not. But as close to that as I think we can get while still having runtime configurability. See the `perftest.py` script in `examples` for a simple performance test that shows the relative overhead of different debugging strategies.

## Documentation

See the full documentation of **zdbg** in the docstring for the module, or `USAGE.md`

## Bugs?

Have you found a bug? Submit it through the [zdbg Issues][] tracker, and be sure to include (1) what happens, (2) what you _expect_ to happen, (3) how to _reproduce_ the bug, and (4) what _version_ of **zdbg** you are using.

## Minimum Supported Python Version

See `pyproject.toml`.

## Security

Please submit sensitive security issues using the "This issue is confidential..." button below the issue description field in the issue tracker.

## Contribute

See `CONTRIBUTING.md` for information about contributing to this project.

## Copyright

**zdbg** is Copyright (c) by Stacy Prowell <mailto:sprowell+zdbg@gmail.com>. All rights reserved. See the `LICENSE` file for more information.

[zdbg Issues]: https://gitlab.com/sprowell/zdbg/-/issues
[Semantic Versioning]: https://semver.org/
