# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 publisher_email: pulumi.Input[_builtins.str],
                 publisher_name: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku_name: pulumi.Input[_builtins.str],
                 additional_locations: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAdditionalLocationArgs']]]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCertificateArgs']]]] = None,
                 client_certificate_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 delegation: Optional[pulumi.Input['ServiceDelegationArgs']] = None,
                 gateway_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hostname_configuration: Optional[pulumi.Input['ServiceHostnameConfigurationArgs']] = None,
                 identity: Optional[pulumi.Input['ServiceIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 min_api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_sender_email: Optional[pulumi.Input[_builtins.str]] = None,
                 protocols: Optional[pulumi.Input['ServiceProtocolsArgs']] = None,
                 public_ip_address_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 security: Optional[pulumi.Input['ServiceSecurityArgs']] = None,
                 sign_in: Optional[pulumi.Input['ServiceSignInArgs']] = None,
                 sign_up: Optional[pulumi.Input['ServiceSignUpArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_access: Optional[pulumi.Input['ServiceTenantAccessArgs']] = None,
                 virtual_network_configuration: Optional[pulumi.Input['ServiceVirtualNetworkConfigurationArgs']] = None,
                 virtual_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input[_builtins.str] publisher_email: The email of publisher/company.
        :param pulumi.Input[_builtins.str] publisher_name: The name of publisher/company.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the API Management Service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: `sku_name` is a string consisting of two parts separated by an underscore(\\_). The first part is the `name`, valid values include: `Consumption`, `Developer`, `Basic`, `BasicV2`, `Standard`, `StandardV2`, `Premium` and `PremiumV2`. The second part is the `capacity` (e.g. the number of deployed units of the `sku`), which must be a positive `integer` (e.g. `Developer_1`).
               
               > **Note:** Premium SKUs are limited to a default maximum of 12 (i.e. `Premium_12`), this can, however, be increased via support request.
               
               > **Note:** Consumption SKU capacity should be 0 (e.g. `Consumption_0`) as this tier includes automatic scaling.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceAdditionalLocationArgs']]] additional_locations: One or more `additional_location` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceCertificateArgs']]] certificates: One or more `certificate` blocks (up to 10) as defined below.
        :param pulumi.Input[_builtins.bool] client_certificate_enabled: Enforce a client certificate to be presented on each request to the gateway? This is only supported when SKU type is `Consumption`.
        :param pulumi.Input['ServiceDelegationArgs'] delegation: A `delegation` block as defined below.
        :param pulumi.Input[_builtins.bool] gateway_disabled: Disable the gateway in main region? This is only supported when `additional_location` is set.
        :param pulumi.Input['ServiceHostnameConfigurationArgs'] hostname_configuration: A `hostname_configuration` block as defined below.
        :param pulumi.Input['ServiceIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure location where the API Management Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] min_api_version: The version which the control plane API calls to API Management service are limited with version equal to or newer than.
        :param pulumi.Input[_builtins.str] name: The name of the API Management Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] notification_sender_email: Email address from which the notification will be sent.
        :param pulumi.Input['ServiceProtocolsArgs'] protocols: A `protocols` block as defined below.
        :param pulumi.Input[_builtins.str] public_ip_address_id: ID of a standard SKU IPv4 Public IP.
               
               > **Note:** Custom public IPs are only supported on the `Premium` and `Developer` tiers when deployed in a virtual network.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Is public access to the service allowed? Defaults to `true`.
               
               > **Note:** This option is applicable only to the Management plane, not the API gateway or Developer portal. It is required to be `true` on the creation.
        :param pulumi.Input['ServiceSecurityArgs'] security: A `security` block as defined below.
        :param pulumi.Input['ServiceSignInArgs'] sign_in: A `sign_in` block as defined below.
        :param pulumi.Input['ServiceSignUpArgs'] sign_up: A `sign_up` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags assigned to the resource.
        :param pulumi.Input['ServiceTenantAccessArgs'] tenant_access: A `tenant_access` block as defined below.
        :param pulumi.Input['ServiceVirtualNetworkConfigurationArgs'] virtual_network_configuration: A `virtual_network_configuration` block as defined below. Required when `virtual_network_type` is `External` or `Internal`.
        :param pulumi.Input[_builtins.str] virtual_network_type: The type of virtual network you want to use, valid values include: `None`, `External`, `Internal`. Defaults to `None`.
               
               > **Note:** Please ensure that in the subnet, inbound port 3443 is open when `virtual_network_type` is `Internal` or `External`. Additionally, please ensure other necessary ports are open according to [api management network configuration](https://learn.microsoft.com/azure/api-management/virtual-network-reference).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this API Management service should be located.
               
               > **Note:** Availability zones are only supported in the Premium tier.
        """
        pulumi.set(__self__, "publisher_email", publisher_email)
        pulumi.set(__self__, "publisher_name", publisher_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku_name", sku_name)
        if additional_locations is not None:
            pulumi.set(__self__, "additional_locations", additional_locations)
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if client_certificate_enabled is not None:
            pulumi.set(__self__, "client_certificate_enabled", client_certificate_enabled)
        if delegation is not None:
            pulumi.set(__self__, "delegation", delegation)
        if gateway_disabled is not None:
            pulumi.set(__self__, "gateway_disabled", gateway_disabled)
        if hostname_configuration is not None:
            pulumi.set(__self__, "hostname_configuration", hostname_configuration)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if min_api_version is not None:
            pulumi.set(__self__, "min_api_version", min_api_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_sender_email is not None:
            pulumi.set(__self__, "notification_sender_email", notification_sender_email)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if public_ip_address_id is not None:
            pulumi.set(__self__, "public_ip_address_id", public_ip_address_id)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if security is not None:
            pulumi.set(__self__, "security", security)
        if sign_in is not None:
            pulumi.set(__self__, "sign_in", sign_in)
        if sign_up is not None:
            pulumi.set(__self__, "sign_up", sign_up)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_access is not None:
            pulumi.set(__self__, "tenant_access", tenant_access)
        if virtual_network_configuration is not None:
            pulumi.set(__self__, "virtual_network_configuration", virtual_network_configuration)
        if virtual_network_type is not None:
            pulumi.set(__self__, "virtual_network_type", virtual_network_type)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="publisherEmail")
    def publisher_email(self) -> pulumi.Input[_builtins.str]:
        """
        The email of publisher/company.
        """
        return pulumi.get(self, "publisher_email")

    @publisher_email.setter
    def publisher_email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "publisher_email", value)

    @_builtins.property
    @pulumi.getter(name="publisherName")
    def publisher_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of publisher/company.
        """
        return pulumi.get(self, "publisher_name")

    @publisher_name.setter
    def publisher_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "publisher_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group in which the API Management Service should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Input[_builtins.str]:
        """
        `sku_name` is a string consisting of two parts separated by an underscore(\\_). The first part is the `name`, valid values include: `Consumption`, `Developer`, `Basic`, `BasicV2`, `Standard`, `StandardV2`, `Premium` and `PremiumV2`. The second part is the `capacity` (e.g. the number of deployed units of the `sku`), which must be a positive `integer` (e.g. `Developer_1`).

        > **Note:** Premium SKUs are limited to a default maximum of 12 (i.e. `Premium_12`), this can, however, be increased via support request.

        > **Note:** Consumption SKU capacity should be 0 (e.g. `Consumption_0`) as this tier includes automatic scaling.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="additionalLocations")
    def additional_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAdditionalLocationArgs']]]]:
        """
        One or more `additional_location` blocks as defined below.
        """
        return pulumi.get(self, "additional_locations")

    @additional_locations.setter
    def additional_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAdditionalLocationArgs']]]]):
        pulumi.set(self, "additional_locations", value)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCertificateArgs']]]]:
        """
        One or more `certificate` blocks (up to 10) as defined below.
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCertificateArgs']]]]):
        pulumi.set(self, "certificates", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificateEnabled")
    def client_certificate_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enforce a client certificate to be presented on each request to the gateway? This is only supported when SKU type is `Consumption`.
        """
        return pulumi.get(self, "client_certificate_enabled")

    @client_certificate_enabled.setter
    def client_certificate_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "client_certificate_enabled", value)

    @_builtins.property
    @pulumi.getter
    def delegation(self) -> Optional[pulumi.Input['ServiceDelegationArgs']]:
        """
        A `delegation` block as defined below.
        """
        return pulumi.get(self, "delegation")

    @delegation.setter
    def delegation(self, value: Optional[pulumi.Input['ServiceDelegationArgs']]):
        pulumi.set(self, "delegation", value)

    @_builtins.property
    @pulumi.getter(name="gatewayDisabled")
    def gateway_disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disable the gateway in main region? This is only supported when `additional_location` is set.
        """
        return pulumi.get(self, "gateway_disabled")

    @gateway_disabled.setter
    def gateway_disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "gateway_disabled", value)

    @_builtins.property
    @pulumi.getter(name="hostnameConfiguration")
    def hostname_configuration(self) -> Optional[pulumi.Input['ServiceHostnameConfigurationArgs']]:
        """
        A `hostname_configuration` block as defined below.
        """
        return pulumi.get(self, "hostname_configuration")

    @hostname_configuration.setter
    def hostname_configuration(self, value: Optional[pulumi.Input['ServiceHostnameConfigurationArgs']]):
        pulumi.set(self, "hostname_configuration", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ServiceIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ServiceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure location where the API Management Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="minApiVersion")
    def min_api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version which the control plane API calls to API Management service are limited with version equal to or newer than.
        """
        return pulumi.get(self, "min_api_version")

    @min_api_version.setter
    def min_api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "min_api_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the API Management Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notificationSenderEmail")
    def notification_sender_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email address from which the notification will be sent.
        """
        return pulumi.get(self, "notification_sender_email")

    @notification_sender_email.setter
    def notification_sender_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notification_sender_email", value)

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input['ServiceProtocolsArgs']]:
        """
        A `protocols` block as defined below.
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input['ServiceProtocolsArgs']]):
        pulumi.set(self, "protocols", value)

    @_builtins.property
    @pulumi.getter(name="publicIpAddressId")
    def public_ip_address_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of a standard SKU IPv4 Public IP.

        > **Note:** Custom public IPs are only supported on the `Premium` and `Developer` tiers when deployed in a virtual network.
        """
        return pulumi.get(self, "public_ip_address_id")

    @public_ip_address_id.setter
    def public_ip_address_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip_address_id", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is public access to the service allowed? Defaults to `true`.

        > **Note:** This option is applicable only to the Management plane, not the API gateway or Developer portal. It is required to be `true` on the creation.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter
    def security(self) -> Optional[pulumi.Input['ServiceSecurityArgs']]:
        """
        A `security` block as defined below.
        """
        return pulumi.get(self, "security")

    @security.setter
    def security(self, value: Optional[pulumi.Input['ServiceSecurityArgs']]):
        pulumi.set(self, "security", value)

    @_builtins.property
    @pulumi.getter(name="signIn")
    def sign_in(self) -> Optional[pulumi.Input['ServiceSignInArgs']]:
        """
        A `sign_in` block as defined below.
        """
        return pulumi.get(self, "sign_in")

    @sign_in.setter
    def sign_in(self, value: Optional[pulumi.Input['ServiceSignInArgs']]):
        pulumi.set(self, "sign_in", value)

    @_builtins.property
    @pulumi.getter(name="signUp")
    def sign_up(self) -> Optional[pulumi.Input['ServiceSignUpArgs']]:
        """
        A `sign_up` block as defined below.
        """
        return pulumi.get(self, "sign_up")

    @sign_up.setter
    def sign_up(self, value: Optional[pulumi.Input['ServiceSignUpArgs']]):
        pulumi.set(self, "sign_up", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tenantAccess")
    def tenant_access(self) -> Optional[pulumi.Input['ServiceTenantAccessArgs']]:
        """
        A `tenant_access` block as defined below.
        """
        return pulumi.get(self, "tenant_access")

    @tenant_access.setter
    def tenant_access(self, value: Optional[pulumi.Input['ServiceTenantAccessArgs']]):
        pulumi.set(self, "tenant_access", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkConfiguration")
    def virtual_network_configuration(self) -> Optional[pulumi.Input['ServiceVirtualNetworkConfigurationArgs']]:
        """
        A `virtual_network_configuration` block as defined below. Required when `virtual_network_type` is `External` or `Internal`.
        """
        return pulumi.get(self, "virtual_network_configuration")

    @virtual_network_configuration.setter
    def virtual_network_configuration(self, value: Optional[pulumi.Input['ServiceVirtualNetworkConfigurationArgs']]):
        pulumi.set(self, "virtual_network_configuration", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkType")
    def virtual_network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of virtual network you want to use, valid values include: `None`, `External`, `Internal`. Defaults to `None`.

        > **Note:** Please ensure that in the subnet, inbound port 3443 is open when `virtual_network_type` is `Internal` or `External`. Additionally, please ensure other necessary ports are open according to [api management network configuration](https://learn.microsoft.com/azure/api-management/virtual-network-reference).
        """
        return pulumi.get(self, "virtual_network_type")

    @virtual_network_type.setter
    def virtual_network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_type", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Availability Zones in which this API Management service should be located.

        > **Note:** Availability zones are only supported in the Premium tier.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class _ServiceState:
    def __init__(__self__, *,
                 additional_locations: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAdditionalLocationArgs']]]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCertificateArgs']]]] = None,
                 client_certificate_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 delegation: Optional[pulumi.Input['ServiceDelegationArgs']] = None,
                 developer_portal_url: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 gateway_regional_url: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_url: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname_configuration: Optional[pulumi.Input['ServiceHostnameConfigurationArgs']] = None,
                 identity: Optional[pulumi.Input['ServiceIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 management_api_url: Optional[pulumi.Input[_builtins.str]] = None,
                 min_api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_sender_email: Optional[pulumi.Input[_builtins.str]] = None,
                 portal_url: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 protocols: Optional[pulumi.Input['ServiceProtocolsArgs']] = None,
                 public_ip_address_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 publisher_email: Optional[pulumi.Input[_builtins.str]] = None,
                 publisher_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scm_url: Optional[pulumi.Input[_builtins.str]] = None,
                 security: Optional[pulumi.Input['ServiceSecurityArgs']] = None,
                 sign_in: Optional[pulumi.Input['ServiceSignInArgs']] = None,
                 sign_up: Optional[pulumi.Input['ServiceSignUpArgs']] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_access: Optional[pulumi.Input['ServiceTenantAccessArgs']] = None,
                 virtual_network_configuration: Optional[pulumi.Input['ServiceVirtualNetworkConfigurationArgs']] = None,
                 virtual_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Service resources.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceAdditionalLocationArgs']]] additional_locations: One or more `additional_location` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceCertificateArgs']]] certificates: One or more `certificate` blocks (up to 10) as defined below.
        :param pulumi.Input[_builtins.bool] client_certificate_enabled: Enforce a client certificate to be presented on each request to the gateway? This is only supported when SKU type is `Consumption`.
        :param pulumi.Input['ServiceDelegationArgs'] delegation: A `delegation` block as defined below.
        :param pulumi.Input[_builtins.str] developer_portal_url: The URL for the Developer Portal associated with this API Management service.
        :param pulumi.Input[_builtins.bool] gateway_disabled: Disable the gateway in main region? This is only supported when `additional_location` is set.
        :param pulumi.Input[_builtins.str] gateway_regional_url: The URL of the Regional Gateway for the API Management Service in the specified region.
        :param pulumi.Input[_builtins.str] gateway_url: The URL of the Gateway for the API Management Service.
        :param pulumi.Input['ServiceHostnameConfigurationArgs'] hostname_configuration: A `hostname_configuration` block as defined below.
        :param pulumi.Input['ServiceIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure location where the API Management Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] management_api_url: The URL for the Management API associated with this API Management service.
        :param pulumi.Input[_builtins.str] min_api_version: The version which the control plane API calls to API Management service are limited with version equal to or newer than.
        :param pulumi.Input[_builtins.str] name: The name of the API Management Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] notification_sender_email: Email address from which the notification will be sent.
        :param pulumi.Input[_builtins.str] portal_url: The URL for the Publisher Portal associated with this API Management service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ip_addresses: The Private IP addresses of the API Management Service. Available only when the API Manager instance is using Virtual Network mode.
        :param pulumi.Input['ServiceProtocolsArgs'] protocols: A `protocols` block as defined below.
        :param pulumi.Input[_builtins.str] public_ip_address_id: ID of a standard SKU IPv4 Public IP.
               
               > **Note:** Custom public IPs are only supported on the `Premium` and `Developer` tiers when deployed in a virtual network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] public_ip_addresses: Public Static Load Balanced IP addresses of the API Management service in the additional location. Available only for Basic, Standard and Premium SKU.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Is public access to the service allowed? Defaults to `true`.
               
               > **Note:** This option is applicable only to the Management plane, not the API gateway or Developer portal. It is required to be `true` on the creation.
        :param pulumi.Input[_builtins.str] publisher_email: The email of publisher/company.
        :param pulumi.Input[_builtins.str] publisher_name: The name of publisher/company.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the API Management Service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scm_url: The URL for the SCM (Source Code Management) Endpoint associated with this API Management service.
        :param pulumi.Input['ServiceSecurityArgs'] security: A `security` block as defined below.
        :param pulumi.Input['ServiceSignInArgs'] sign_in: A `sign_in` block as defined below.
        :param pulumi.Input['ServiceSignUpArgs'] sign_up: A `sign_up` block as defined below.
        :param pulumi.Input[_builtins.str] sku_name: `sku_name` is a string consisting of two parts separated by an underscore(\\_). The first part is the `name`, valid values include: `Consumption`, `Developer`, `Basic`, `BasicV2`, `Standard`, `StandardV2`, `Premium` and `PremiumV2`. The second part is the `capacity` (e.g. the number of deployed units of the `sku`), which must be a positive `integer` (e.g. `Developer_1`).
               
               > **Note:** Premium SKUs are limited to a default maximum of 12 (i.e. `Premium_12`), this can, however, be increased via support request.
               
               > **Note:** Consumption SKU capacity should be 0 (e.g. `Consumption_0`) as this tier includes automatic scaling.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags assigned to the resource.
        :param pulumi.Input['ServiceTenantAccessArgs'] tenant_access: A `tenant_access` block as defined below.
        :param pulumi.Input['ServiceVirtualNetworkConfigurationArgs'] virtual_network_configuration: A `virtual_network_configuration` block as defined below. Required when `virtual_network_type` is `External` or `Internal`.
        :param pulumi.Input[_builtins.str] virtual_network_type: The type of virtual network you want to use, valid values include: `None`, `External`, `Internal`. Defaults to `None`.
               
               > **Note:** Please ensure that in the subnet, inbound port 3443 is open when `virtual_network_type` is `Internal` or `External`. Additionally, please ensure other necessary ports are open according to [api management network configuration](https://learn.microsoft.com/azure/api-management/virtual-network-reference).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this API Management service should be located.
               
               > **Note:** Availability zones are only supported in the Premium tier.
        """
        if additional_locations is not None:
            pulumi.set(__self__, "additional_locations", additional_locations)
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if client_certificate_enabled is not None:
            pulumi.set(__self__, "client_certificate_enabled", client_certificate_enabled)
        if delegation is not None:
            pulumi.set(__self__, "delegation", delegation)
        if developer_portal_url is not None:
            pulumi.set(__self__, "developer_portal_url", developer_portal_url)
        if gateway_disabled is not None:
            pulumi.set(__self__, "gateway_disabled", gateway_disabled)
        if gateway_regional_url is not None:
            pulumi.set(__self__, "gateway_regional_url", gateway_regional_url)
        if gateway_url is not None:
            pulumi.set(__self__, "gateway_url", gateway_url)
        if hostname_configuration is not None:
            pulumi.set(__self__, "hostname_configuration", hostname_configuration)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if management_api_url is not None:
            pulumi.set(__self__, "management_api_url", management_api_url)
        if min_api_version is not None:
            pulumi.set(__self__, "min_api_version", min_api_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_sender_email is not None:
            pulumi.set(__self__, "notification_sender_email", notification_sender_email)
        if portal_url is not None:
            pulumi.set(__self__, "portal_url", portal_url)
        if private_ip_addresses is not None:
            pulumi.set(__self__, "private_ip_addresses", private_ip_addresses)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if public_ip_address_id is not None:
            pulumi.set(__self__, "public_ip_address_id", public_ip_address_id)
        if public_ip_addresses is not None:
            pulumi.set(__self__, "public_ip_addresses", public_ip_addresses)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if publisher_email is not None:
            pulumi.set(__self__, "publisher_email", publisher_email)
        if publisher_name is not None:
            pulumi.set(__self__, "publisher_name", publisher_name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if scm_url is not None:
            pulumi.set(__self__, "scm_url", scm_url)
        if security is not None:
            pulumi.set(__self__, "security", security)
        if sign_in is not None:
            pulumi.set(__self__, "sign_in", sign_in)
        if sign_up is not None:
            pulumi.set(__self__, "sign_up", sign_up)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_access is not None:
            pulumi.set(__self__, "tenant_access", tenant_access)
        if virtual_network_configuration is not None:
            pulumi.set(__self__, "virtual_network_configuration", virtual_network_configuration)
        if virtual_network_type is not None:
            pulumi.set(__self__, "virtual_network_type", virtual_network_type)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="additionalLocations")
    def additional_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAdditionalLocationArgs']]]]:
        """
        One or more `additional_location` blocks as defined below.
        """
        return pulumi.get(self, "additional_locations")

    @additional_locations.setter
    def additional_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAdditionalLocationArgs']]]]):
        pulumi.set(self, "additional_locations", value)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCertificateArgs']]]]:
        """
        One or more `certificate` blocks (up to 10) as defined below.
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCertificateArgs']]]]):
        pulumi.set(self, "certificates", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificateEnabled")
    def client_certificate_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enforce a client certificate to be presented on each request to the gateway? This is only supported when SKU type is `Consumption`.
        """
        return pulumi.get(self, "client_certificate_enabled")

    @client_certificate_enabled.setter
    def client_certificate_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "client_certificate_enabled", value)

    @_builtins.property
    @pulumi.getter
    def delegation(self) -> Optional[pulumi.Input['ServiceDelegationArgs']]:
        """
        A `delegation` block as defined below.
        """
        return pulumi.get(self, "delegation")

    @delegation.setter
    def delegation(self, value: Optional[pulumi.Input['ServiceDelegationArgs']]):
        pulumi.set(self, "delegation", value)

    @_builtins.property
    @pulumi.getter(name="developerPortalUrl")
    def developer_portal_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL for the Developer Portal associated with this API Management service.
        """
        return pulumi.get(self, "developer_portal_url")

    @developer_portal_url.setter
    def developer_portal_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "developer_portal_url", value)

    @_builtins.property
    @pulumi.getter(name="gatewayDisabled")
    def gateway_disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Disable the gateway in main region? This is only supported when `additional_location` is set.
        """
        return pulumi.get(self, "gateway_disabled")

    @gateway_disabled.setter
    def gateway_disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "gateway_disabled", value)

    @_builtins.property
    @pulumi.getter(name="gatewayRegionalUrl")
    def gateway_regional_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the Regional Gateway for the API Management Service in the specified region.
        """
        return pulumi.get(self, "gateway_regional_url")

    @gateway_regional_url.setter
    def gateway_regional_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_regional_url", value)

    @_builtins.property
    @pulumi.getter(name="gatewayUrl")
    def gateway_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL of the Gateway for the API Management Service.
        """
        return pulumi.get(self, "gateway_url")

    @gateway_url.setter
    def gateway_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_url", value)

    @_builtins.property
    @pulumi.getter(name="hostnameConfiguration")
    def hostname_configuration(self) -> Optional[pulumi.Input['ServiceHostnameConfigurationArgs']]:
        """
        A `hostname_configuration` block as defined below.
        """
        return pulumi.get(self, "hostname_configuration")

    @hostname_configuration.setter
    def hostname_configuration(self, value: Optional[pulumi.Input['ServiceHostnameConfigurationArgs']]):
        pulumi.set(self, "hostname_configuration", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ServiceIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ServiceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure location where the API Management Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managementApiUrl")
    def management_api_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL for the Management API associated with this API Management service.
        """
        return pulumi.get(self, "management_api_url")

    @management_api_url.setter
    def management_api_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_api_url", value)

    @_builtins.property
    @pulumi.getter(name="minApiVersion")
    def min_api_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version which the control plane API calls to API Management service are limited with version equal to or newer than.
        """
        return pulumi.get(self, "min_api_version")

    @min_api_version.setter
    def min_api_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "min_api_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the API Management Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="notificationSenderEmail")
    def notification_sender_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Email address from which the notification will be sent.
        """
        return pulumi.get(self, "notification_sender_email")

    @notification_sender_email.setter
    def notification_sender_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notification_sender_email", value)

    @_builtins.property
    @pulumi.getter(name="portalUrl")
    def portal_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL for the Publisher Portal associated with this API Management service.
        """
        return pulumi.get(self, "portal_url")

    @portal_url.setter
    def portal_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "portal_url", value)

    @_builtins.property
    @pulumi.getter(name="privateIpAddresses")
    def private_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The Private IP addresses of the API Management Service. Available only when the API Manager instance is using Virtual Network mode.
        """
        return pulumi.get(self, "private_ip_addresses")

    @private_ip_addresses.setter
    def private_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "private_ip_addresses", value)

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input['ServiceProtocolsArgs']]:
        """
        A `protocols` block as defined below.
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input['ServiceProtocolsArgs']]):
        pulumi.set(self, "protocols", value)

    @_builtins.property
    @pulumi.getter(name="publicIpAddressId")
    def public_ip_address_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of a standard SKU IPv4 Public IP.

        > **Note:** Custom public IPs are only supported on the `Premium` and `Developer` tiers when deployed in a virtual network.
        """
        return pulumi.get(self, "public_ip_address_id")

    @public_ip_address_id.setter
    def public_ip_address_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip_address_id", value)

    @_builtins.property
    @pulumi.getter(name="publicIpAddresses")
    def public_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Public Static Load Balanced IP addresses of the API Management service in the additional location. Available only for Basic, Standard and Premium SKU.
        """
        return pulumi.get(self, "public_ip_addresses")

    @public_ip_addresses.setter
    def public_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "public_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is public access to the service allowed? Defaults to `true`.

        > **Note:** This option is applicable only to the Management plane, not the API gateway or Developer portal. It is required to be `true` on the creation.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="publisherEmail")
    def publisher_email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email of publisher/company.
        """
        return pulumi.get(self, "publisher_email")

    @publisher_email.setter
    def publisher_email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "publisher_email", value)

    @_builtins.property
    @pulumi.getter(name="publisherName")
    def publisher_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of publisher/company.
        """
        return pulumi.get(self, "publisher_name")

    @publisher_name.setter
    def publisher_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "publisher_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group in which the API Management Service should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="scmUrl")
    def scm_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL for the SCM (Source Code Management) Endpoint associated with this API Management service.
        """
        return pulumi.get(self, "scm_url")

    @scm_url.setter
    def scm_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scm_url", value)

    @_builtins.property
    @pulumi.getter
    def security(self) -> Optional[pulumi.Input['ServiceSecurityArgs']]:
        """
        A `security` block as defined below.
        """
        return pulumi.get(self, "security")

    @security.setter
    def security(self, value: Optional[pulumi.Input['ServiceSecurityArgs']]):
        pulumi.set(self, "security", value)

    @_builtins.property
    @pulumi.getter(name="signIn")
    def sign_in(self) -> Optional[pulumi.Input['ServiceSignInArgs']]:
        """
        A `sign_in` block as defined below.
        """
        return pulumi.get(self, "sign_in")

    @sign_in.setter
    def sign_in(self, value: Optional[pulumi.Input['ServiceSignInArgs']]):
        pulumi.set(self, "sign_in", value)

    @_builtins.property
    @pulumi.getter(name="signUp")
    def sign_up(self) -> Optional[pulumi.Input['ServiceSignUpArgs']]:
        """
        A `sign_up` block as defined below.
        """
        return pulumi.get(self, "sign_up")

    @sign_up.setter
    def sign_up(self, value: Optional[pulumi.Input['ServiceSignUpArgs']]):
        pulumi.set(self, "sign_up", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `sku_name` is a string consisting of two parts separated by an underscore(\\_). The first part is the `name`, valid values include: `Consumption`, `Developer`, `Basic`, `BasicV2`, `Standard`, `StandardV2`, `Premium` and `PremiumV2`. The second part is the `capacity` (e.g. the number of deployed units of the `sku`), which must be a positive `integer` (e.g. `Developer_1`).

        > **Note:** Premium SKUs are limited to a default maximum of 12 (i.e. `Premium_12`), this can, however, be increased via support request.

        > **Note:** Consumption SKU capacity should be 0 (e.g. `Consumption_0`) as this tier includes automatic scaling.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tenantAccess")
    def tenant_access(self) -> Optional[pulumi.Input['ServiceTenantAccessArgs']]:
        """
        A `tenant_access` block as defined below.
        """
        return pulumi.get(self, "tenant_access")

    @tenant_access.setter
    def tenant_access(self, value: Optional[pulumi.Input['ServiceTenantAccessArgs']]):
        pulumi.set(self, "tenant_access", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkConfiguration")
    def virtual_network_configuration(self) -> Optional[pulumi.Input['ServiceVirtualNetworkConfigurationArgs']]:
        """
        A `virtual_network_configuration` block as defined below. Required when `virtual_network_type` is `External` or `Internal`.
        """
        return pulumi.get(self, "virtual_network_configuration")

    @virtual_network_configuration.setter
    def virtual_network_configuration(self, value: Optional[pulumi.Input['ServiceVirtualNetworkConfigurationArgs']]):
        pulumi.set(self, "virtual_network_configuration", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkType")
    def virtual_network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of virtual network you want to use, valid values include: `None`, `External`, `Internal`. Defaults to `None`.

        > **Note:** Please ensure that in the subnet, inbound port 3443 is open when `virtual_network_type` is `Internal` or `External`. Additionally, please ensure other necessary ports are open according to [api management network configuration](https://learn.microsoft.com/azure/api-management/virtual-network-reference).
        """
        return pulumi.get(self, "virtual_network_type")

    @virtual_network_type.setter
    def virtual_network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_type", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Availability Zones in which this API Management service should be located.

        > **Note:** Availability zones are only supported in the Premium tier.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.type_token("azure:apimanagement/service:Service")
class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceAdditionalLocationArgs', 'ServiceAdditionalLocationArgsDict']]]]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceCertificateArgs', 'ServiceCertificateArgsDict']]]]] = None,
                 client_certificate_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 delegation: Optional[pulumi.Input[Union['ServiceDelegationArgs', 'ServiceDelegationArgsDict']]] = None,
                 gateway_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hostname_configuration: Optional[pulumi.Input[Union['ServiceHostnameConfigurationArgs', 'ServiceHostnameConfigurationArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['ServiceIdentityArgs', 'ServiceIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 min_api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_sender_email: Optional[pulumi.Input[_builtins.str]] = None,
                 protocols: Optional[pulumi.Input[Union['ServiceProtocolsArgs', 'ServiceProtocolsArgsDict']]] = None,
                 public_ip_address_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 publisher_email: Optional[pulumi.Input[_builtins.str]] = None,
                 publisher_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security: Optional[pulumi.Input[Union['ServiceSecurityArgs', 'ServiceSecurityArgsDict']]] = None,
                 sign_in: Optional[pulumi.Input[Union['ServiceSignInArgs', 'ServiceSignInArgsDict']]] = None,
                 sign_up: Optional[pulumi.Input[Union['ServiceSignUpArgs', 'ServiceSignUpArgsDict']]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_access: Optional[pulumi.Input[Union['ServiceTenantAccessArgs', 'ServiceTenantAccessArgsDict']]] = None,
                 virtual_network_configuration: Optional[pulumi.Input[Union['ServiceVirtualNetworkConfigurationArgs', 'ServiceVirtualNetworkConfigurationArgsDict']]] = None,
                 virtual_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@exmaple.com",
            sku_name="Developer_1")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement` - 2024-05-01, 2022-08-01

        ## Import

        API Management Services can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/service:Service example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ApiManagement/service/instance1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceAdditionalLocationArgs', 'ServiceAdditionalLocationArgsDict']]]] additional_locations: One or more `additional_location` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceCertificateArgs', 'ServiceCertificateArgsDict']]]] certificates: One or more `certificate` blocks (up to 10) as defined below.
        :param pulumi.Input[_builtins.bool] client_certificate_enabled: Enforce a client certificate to be presented on each request to the gateway? This is only supported when SKU type is `Consumption`.
        :param pulumi.Input[Union['ServiceDelegationArgs', 'ServiceDelegationArgsDict']] delegation: A `delegation` block as defined below.
        :param pulumi.Input[_builtins.bool] gateway_disabled: Disable the gateway in main region? This is only supported when `additional_location` is set.
        :param pulumi.Input[Union['ServiceHostnameConfigurationArgs', 'ServiceHostnameConfigurationArgsDict']] hostname_configuration: A `hostname_configuration` block as defined below.
        :param pulumi.Input[Union['ServiceIdentityArgs', 'ServiceIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure location where the API Management Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] min_api_version: The version which the control plane API calls to API Management service are limited with version equal to or newer than.
        :param pulumi.Input[_builtins.str] name: The name of the API Management Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] notification_sender_email: Email address from which the notification will be sent.
        :param pulumi.Input[Union['ServiceProtocolsArgs', 'ServiceProtocolsArgsDict']] protocols: A `protocols` block as defined below.
        :param pulumi.Input[_builtins.str] public_ip_address_id: ID of a standard SKU IPv4 Public IP.
               
               > **Note:** Custom public IPs are only supported on the `Premium` and `Developer` tiers when deployed in a virtual network.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Is public access to the service allowed? Defaults to `true`.
               
               > **Note:** This option is applicable only to the Management plane, not the API gateway or Developer portal. It is required to be `true` on the creation.
        :param pulumi.Input[_builtins.str] publisher_email: The email of publisher/company.
        :param pulumi.Input[_builtins.str] publisher_name: The name of publisher/company.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the API Management Service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ServiceSecurityArgs', 'ServiceSecurityArgsDict']] security: A `security` block as defined below.
        :param pulumi.Input[Union['ServiceSignInArgs', 'ServiceSignInArgsDict']] sign_in: A `sign_in` block as defined below.
        :param pulumi.Input[Union['ServiceSignUpArgs', 'ServiceSignUpArgsDict']] sign_up: A `sign_up` block as defined below.
        :param pulumi.Input[_builtins.str] sku_name: `sku_name` is a string consisting of two parts separated by an underscore(\\_). The first part is the `name`, valid values include: `Consumption`, `Developer`, `Basic`, `BasicV2`, `Standard`, `StandardV2`, `Premium` and `PremiumV2`. The second part is the `capacity` (e.g. the number of deployed units of the `sku`), which must be a positive `integer` (e.g. `Developer_1`).
               
               > **Note:** Premium SKUs are limited to a default maximum of 12 (i.e. `Premium_12`), this can, however, be increased via support request.
               
               > **Note:** Consumption SKU capacity should be 0 (e.g. `Consumption_0`) as this tier includes automatic scaling.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags assigned to the resource.
        :param pulumi.Input[Union['ServiceTenantAccessArgs', 'ServiceTenantAccessArgsDict']] tenant_access: A `tenant_access` block as defined below.
        :param pulumi.Input[Union['ServiceVirtualNetworkConfigurationArgs', 'ServiceVirtualNetworkConfigurationArgsDict']] virtual_network_configuration: A `virtual_network_configuration` block as defined below. Required when `virtual_network_type` is `External` or `Internal`.
        :param pulumi.Input[_builtins.str] virtual_network_type: The type of virtual network you want to use, valid values include: `None`, `External`, `Internal`. Defaults to `None`.
               
               > **Note:** Please ensure that in the subnet, inbound port 3443 is open when `virtual_network_type` is `Internal` or `External`. Additionally, please ensure other necessary ports are open according to [api management network configuration](https://learn.microsoft.com/azure/api-management/virtual-network-reference).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this API Management service should be located.
               
               > **Note:** Availability zones are only supported in the Premium tier.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@exmaple.com",
            sku_name="Developer_1")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement` - 2024-05-01, 2022-08-01

        ## Import

        API Management Services can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/service:Service example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ApiManagement/service/instance1
        ```

        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceAdditionalLocationArgs', 'ServiceAdditionalLocationArgsDict']]]]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceCertificateArgs', 'ServiceCertificateArgsDict']]]]] = None,
                 client_certificate_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 delegation: Optional[pulumi.Input[Union['ServiceDelegationArgs', 'ServiceDelegationArgsDict']]] = None,
                 gateway_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hostname_configuration: Optional[pulumi.Input[Union['ServiceHostnameConfigurationArgs', 'ServiceHostnameConfigurationArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['ServiceIdentityArgs', 'ServiceIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 min_api_version: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notification_sender_email: Optional[pulumi.Input[_builtins.str]] = None,
                 protocols: Optional[pulumi.Input[Union['ServiceProtocolsArgs', 'ServiceProtocolsArgsDict']]] = None,
                 public_ip_address_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 publisher_email: Optional[pulumi.Input[_builtins.str]] = None,
                 publisher_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security: Optional[pulumi.Input[Union['ServiceSecurityArgs', 'ServiceSecurityArgsDict']]] = None,
                 sign_in: Optional[pulumi.Input[Union['ServiceSignInArgs', 'ServiceSignInArgsDict']]] = None,
                 sign_up: Optional[pulumi.Input[Union['ServiceSignUpArgs', 'ServiceSignUpArgsDict']]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_access: Optional[pulumi.Input[Union['ServiceTenantAccessArgs', 'ServiceTenantAccessArgsDict']]] = None,
                 virtual_network_configuration: Optional[pulumi.Input[Union['ServiceVirtualNetworkConfigurationArgs', 'ServiceVirtualNetworkConfigurationArgsDict']]] = None,
                 virtual_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            __props__.__dict__["additional_locations"] = additional_locations
            __props__.__dict__["certificates"] = certificates
            __props__.__dict__["client_certificate_enabled"] = client_certificate_enabled
            __props__.__dict__["delegation"] = delegation
            __props__.__dict__["gateway_disabled"] = gateway_disabled
            __props__.__dict__["hostname_configuration"] = hostname_configuration
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["min_api_version"] = min_api_version
            __props__.__dict__["name"] = name
            __props__.__dict__["notification_sender_email"] = notification_sender_email
            __props__.__dict__["protocols"] = protocols
            __props__.__dict__["public_ip_address_id"] = public_ip_address_id
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            if publisher_email is None and not opts.urn:
                raise TypeError("Missing required property 'publisher_email'")
            __props__.__dict__["publisher_email"] = publisher_email
            if publisher_name is None and not opts.urn:
                raise TypeError("Missing required property 'publisher_name'")
            __props__.__dict__["publisher_name"] = publisher_name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["security"] = security
            __props__.__dict__["sign_in"] = sign_in
            __props__.__dict__["sign_up"] = sign_up
            if sku_name is None and not opts.urn:
                raise TypeError("Missing required property 'sku_name'")
            __props__.__dict__["sku_name"] = sku_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tenant_access"] = tenant_access
            __props__.__dict__["virtual_network_configuration"] = virtual_network_configuration
            __props__.__dict__["virtual_network_type"] = virtual_network_type
            __props__.__dict__["zones"] = zones
            __props__.__dict__["developer_portal_url"] = None
            __props__.__dict__["gateway_regional_url"] = None
            __props__.__dict__["gateway_url"] = None
            __props__.__dict__["management_api_url"] = None
            __props__.__dict__["portal_url"] = None
            __props__.__dict__["private_ip_addresses"] = None
            __props__.__dict__["public_ip_addresses"] = None
            __props__.__dict__["scm_url"] = None
        super(Service, __self__).__init__(
            'azure:apimanagement/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceAdditionalLocationArgs', 'ServiceAdditionalLocationArgsDict']]]]] = None,
            certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceCertificateArgs', 'ServiceCertificateArgsDict']]]]] = None,
            client_certificate_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            delegation: Optional[pulumi.Input[Union['ServiceDelegationArgs', 'ServiceDelegationArgsDict']]] = None,
            developer_portal_url: Optional[pulumi.Input[_builtins.str]] = None,
            gateway_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            gateway_regional_url: Optional[pulumi.Input[_builtins.str]] = None,
            gateway_url: Optional[pulumi.Input[_builtins.str]] = None,
            hostname_configuration: Optional[pulumi.Input[Union['ServiceHostnameConfigurationArgs', 'ServiceHostnameConfigurationArgsDict']]] = None,
            identity: Optional[pulumi.Input[Union['ServiceIdentityArgs', 'ServiceIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            management_api_url: Optional[pulumi.Input[_builtins.str]] = None,
            min_api_version: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            notification_sender_email: Optional[pulumi.Input[_builtins.str]] = None,
            portal_url: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            protocols: Optional[pulumi.Input[Union['ServiceProtocolsArgs', 'ServiceProtocolsArgsDict']]] = None,
            public_ip_address_id: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            publisher_email: Optional[pulumi.Input[_builtins.str]] = None,
            publisher_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            scm_url: Optional[pulumi.Input[_builtins.str]] = None,
            security: Optional[pulumi.Input[Union['ServiceSecurityArgs', 'ServiceSecurityArgsDict']]] = None,
            sign_in: Optional[pulumi.Input[Union['ServiceSignInArgs', 'ServiceSignInArgsDict']]] = None,
            sign_up: Optional[pulumi.Input[Union['ServiceSignUpArgs', 'ServiceSignUpArgsDict']]] = None,
            sku_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tenant_access: Optional[pulumi.Input[Union['ServiceTenantAccessArgs', 'ServiceTenantAccessArgsDict']]] = None,
            virtual_network_configuration: Optional[pulumi.Input[Union['ServiceVirtualNetworkConfigurationArgs', 'ServiceVirtualNetworkConfigurationArgsDict']]] = None,
            virtual_network_type: Optional[pulumi.Input[_builtins.str]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceAdditionalLocationArgs', 'ServiceAdditionalLocationArgsDict']]]] additional_locations: One or more `additional_location` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceCertificateArgs', 'ServiceCertificateArgsDict']]]] certificates: One or more `certificate` blocks (up to 10) as defined below.
        :param pulumi.Input[_builtins.bool] client_certificate_enabled: Enforce a client certificate to be presented on each request to the gateway? This is only supported when SKU type is `Consumption`.
        :param pulumi.Input[Union['ServiceDelegationArgs', 'ServiceDelegationArgsDict']] delegation: A `delegation` block as defined below.
        :param pulumi.Input[_builtins.str] developer_portal_url: The URL for the Developer Portal associated with this API Management service.
        :param pulumi.Input[_builtins.bool] gateway_disabled: Disable the gateway in main region? This is only supported when `additional_location` is set.
        :param pulumi.Input[_builtins.str] gateway_regional_url: The URL of the Regional Gateway for the API Management Service in the specified region.
        :param pulumi.Input[_builtins.str] gateway_url: The URL of the Gateway for the API Management Service.
        :param pulumi.Input[Union['ServiceHostnameConfigurationArgs', 'ServiceHostnameConfigurationArgsDict']] hostname_configuration: A `hostname_configuration` block as defined below.
        :param pulumi.Input[Union['ServiceIdentityArgs', 'ServiceIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure location where the API Management Service exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] management_api_url: The URL for the Management API associated with this API Management service.
        :param pulumi.Input[_builtins.str] min_api_version: The version which the control plane API calls to API Management service are limited with version equal to or newer than.
        :param pulumi.Input[_builtins.str] name: The name of the API Management Service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] notification_sender_email: Email address from which the notification will be sent.
        :param pulumi.Input[_builtins.str] portal_url: The URL for the Publisher Portal associated with this API Management service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ip_addresses: The Private IP addresses of the API Management Service. Available only when the API Manager instance is using Virtual Network mode.
        :param pulumi.Input[Union['ServiceProtocolsArgs', 'ServiceProtocolsArgsDict']] protocols: A `protocols` block as defined below.
        :param pulumi.Input[_builtins.str] public_ip_address_id: ID of a standard SKU IPv4 Public IP.
               
               > **Note:** Custom public IPs are only supported on the `Premium` and `Developer` tiers when deployed in a virtual network.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] public_ip_addresses: Public Static Load Balanced IP addresses of the API Management service in the additional location. Available only for Basic, Standard and Premium SKU.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Is public access to the service allowed? Defaults to `true`.
               
               > **Note:** This option is applicable only to the Management plane, not the API gateway or Developer portal. It is required to be `true` on the creation.
        :param pulumi.Input[_builtins.str] publisher_email: The email of publisher/company.
        :param pulumi.Input[_builtins.str] publisher_name: The name of publisher/company.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the API Management Service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scm_url: The URL for the SCM (Source Code Management) Endpoint associated with this API Management service.
        :param pulumi.Input[Union['ServiceSecurityArgs', 'ServiceSecurityArgsDict']] security: A `security` block as defined below.
        :param pulumi.Input[Union['ServiceSignInArgs', 'ServiceSignInArgsDict']] sign_in: A `sign_in` block as defined below.
        :param pulumi.Input[Union['ServiceSignUpArgs', 'ServiceSignUpArgsDict']] sign_up: A `sign_up` block as defined below.
        :param pulumi.Input[_builtins.str] sku_name: `sku_name` is a string consisting of two parts separated by an underscore(\\_). The first part is the `name`, valid values include: `Consumption`, `Developer`, `Basic`, `BasicV2`, `Standard`, `StandardV2`, `Premium` and `PremiumV2`. The second part is the `capacity` (e.g. the number of deployed units of the `sku`), which must be a positive `integer` (e.g. `Developer_1`).
               
               > **Note:** Premium SKUs are limited to a default maximum of 12 (i.e. `Premium_12`), this can, however, be increased via support request.
               
               > **Note:** Consumption SKU capacity should be 0 (e.g. `Consumption_0`) as this tier includes automatic scaling.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags assigned to the resource.
        :param pulumi.Input[Union['ServiceTenantAccessArgs', 'ServiceTenantAccessArgsDict']] tenant_access: A `tenant_access` block as defined below.
        :param pulumi.Input[Union['ServiceVirtualNetworkConfigurationArgs', 'ServiceVirtualNetworkConfigurationArgsDict']] virtual_network_configuration: A `virtual_network_configuration` block as defined below. Required when `virtual_network_type` is `External` or `Internal`.
        :param pulumi.Input[_builtins.str] virtual_network_type: The type of virtual network you want to use, valid values include: `None`, `External`, `Internal`. Defaults to `None`.
               
               > **Note:** Please ensure that in the subnet, inbound port 3443 is open when `virtual_network_type` is `Internal` or `External`. Additionally, please ensure other necessary ports are open according to [api management network configuration](https://learn.microsoft.com/azure/api-management/virtual-network-reference).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this API Management service should be located.
               
               > **Note:** Availability zones are only supported in the Premium tier.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceState.__new__(_ServiceState)

        __props__.__dict__["additional_locations"] = additional_locations
        __props__.__dict__["certificates"] = certificates
        __props__.__dict__["client_certificate_enabled"] = client_certificate_enabled
        __props__.__dict__["delegation"] = delegation
        __props__.__dict__["developer_portal_url"] = developer_portal_url
        __props__.__dict__["gateway_disabled"] = gateway_disabled
        __props__.__dict__["gateway_regional_url"] = gateway_regional_url
        __props__.__dict__["gateway_url"] = gateway_url
        __props__.__dict__["hostname_configuration"] = hostname_configuration
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["management_api_url"] = management_api_url
        __props__.__dict__["min_api_version"] = min_api_version
        __props__.__dict__["name"] = name
        __props__.__dict__["notification_sender_email"] = notification_sender_email
        __props__.__dict__["portal_url"] = portal_url
        __props__.__dict__["private_ip_addresses"] = private_ip_addresses
        __props__.__dict__["protocols"] = protocols
        __props__.__dict__["public_ip_address_id"] = public_ip_address_id
        __props__.__dict__["public_ip_addresses"] = public_ip_addresses
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["publisher_email"] = publisher_email
        __props__.__dict__["publisher_name"] = publisher_name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["scm_url"] = scm_url
        __props__.__dict__["security"] = security
        __props__.__dict__["sign_in"] = sign_in
        __props__.__dict__["sign_up"] = sign_up
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_access"] = tenant_access
        __props__.__dict__["virtual_network_configuration"] = virtual_network_configuration
        __props__.__dict__["virtual_network_type"] = virtual_network_type
        __props__.__dict__["zones"] = zones
        return Service(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalLocations")
    def additional_locations(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceAdditionalLocation']]]:
        """
        One or more `additional_location` blocks as defined below.
        """
        return pulumi.get(self, "additional_locations")

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceCertificate']]]:
        """
        One or more `certificate` blocks (up to 10) as defined below.
        """
        return pulumi.get(self, "certificates")

    @_builtins.property
    @pulumi.getter(name="clientCertificateEnabled")
    def client_certificate_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enforce a client certificate to be presented on each request to the gateway? This is only supported when SKU type is `Consumption`.
        """
        return pulumi.get(self, "client_certificate_enabled")

    @_builtins.property
    @pulumi.getter
    def delegation(self) -> pulumi.Output['outputs.ServiceDelegation']:
        """
        A `delegation` block as defined below.
        """
        return pulumi.get(self, "delegation")

    @_builtins.property
    @pulumi.getter(name="developerPortalUrl")
    def developer_portal_url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL for the Developer Portal associated with this API Management service.
        """
        return pulumi.get(self, "developer_portal_url")

    @_builtins.property
    @pulumi.getter(name="gatewayDisabled")
    def gateway_disabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Disable the gateway in main region? This is only supported when `additional_location` is set.
        """
        return pulumi.get(self, "gateway_disabled")

    @_builtins.property
    @pulumi.getter(name="gatewayRegionalUrl")
    def gateway_regional_url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the Regional Gateway for the API Management Service in the specified region.
        """
        return pulumi.get(self, "gateway_regional_url")

    @_builtins.property
    @pulumi.getter(name="gatewayUrl")
    def gateway_url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL of the Gateway for the API Management Service.
        """
        return pulumi.get(self, "gateway_url")

    @_builtins.property
    @pulumi.getter(name="hostnameConfiguration")
    def hostname_configuration(self) -> pulumi.Output['outputs.ServiceHostnameConfiguration']:
        """
        A `hostname_configuration` block as defined below.
        """
        return pulumi.get(self, "hostname_configuration")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.ServiceIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure location where the API Management Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="managementApiUrl")
    def management_api_url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL for the Management API associated with this API Management service.
        """
        return pulumi.get(self, "management_api_url")

    @_builtins.property
    @pulumi.getter(name="minApiVersion")
    def min_api_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The version which the control plane API calls to API Management service are limited with version equal to or newer than.
        """
        return pulumi.get(self, "min_api_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the API Management Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="notificationSenderEmail")
    def notification_sender_email(self) -> pulumi.Output[_builtins.str]:
        """
        Email address from which the notification will be sent.
        """
        return pulumi.get(self, "notification_sender_email")

    @_builtins.property
    @pulumi.getter(name="portalUrl")
    def portal_url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL for the Publisher Portal associated with this API Management service.
        """
        return pulumi.get(self, "portal_url")

    @_builtins.property
    @pulumi.getter(name="privateIpAddresses")
    def private_ip_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The Private IP addresses of the API Management Service. Available only when the API Manager instance is using Virtual Network mode.
        """
        return pulumi.get(self, "private_ip_addresses")

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> pulumi.Output['outputs.ServiceProtocols']:
        """
        A `protocols` block as defined below.
        """
        return pulumi.get(self, "protocols")

    @_builtins.property
    @pulumi.getter(name="publicIpAddressId")
    def public_ip_address_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of a standard SKU IPv4 Public IP.

        > **Note:** Custom public IPs are only supported on the `Premium` and `Developer` tiers when deployed in a virtual network.
        """
        return pulumi.get(self, "public_ip_address_id")

    @_builtins.property
    @pulumi.getter(name="publicIpAddresses")
    def public_ip_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Public Static Load Balanced IP addresses of the API Management service in the additional location. Available only for Basic, Standard and Premium SKU.
        """
        return pulumi.get(self, "public_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is public access to the service allowed? Defaults to `true`.

        > **Note:** This option is applicable only to the Management plane, not the API gateway or Developer portal. It is required to be `true` on the creation.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="publisherEmail")
    def publisher_email(self) -> pulumi.Output[_builtins.str]:
        """
        The email of publisher/company.
        """
        return pulumi.get(self, "publisher_email")

    @_builtins.property
    @pulumi.getter(name="publisherName")
    def publisher_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of publisher/company.
        """
        return pulumi.get(self, "publisher_name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group in which the API Management Service should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="scmUrl")
    def scm_url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL for the SCM (Source Code Management) Endpoint associated with this API Management service.
        """
        return pulumi.get(self, "scm_url")

    @_builtins.property
    @pulumi.getter
    def security(self) -> pulumi.Output['outputs.ServiceSecurity']:
        """
        A `security` block as defined below.
        """
        return pulumi.get(self, "security")

    @_builtins.property
    @pulumi.getter(name="signIn")
    def sign_in(self) -> pulumi.Output['outputs.ServiceSignIn']:
        """
        A `sign_in` block as defined below.
        """
        return pulumi.get(self, "sign_in")

    @_builtins.property
    @pulumi.getter(name="signUp")
    def sign_up(self) -> pulumi.Output['outputs.ServiceSignUp']:
        """
        A `sign_up` block as defined below.
        """
        return pulumi.get(self, "sign_up")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[_builtins.str]:
        """
        `sku_name` is a string consisting of two parts separated by an underscore(\\_). The first part is the `name`, valid values include: `Consumption`, `Developer`, `Basic`, `BasicV2`, `Standard`, `StandardV2`, `Premium` and `PremiumV2`. The second part is the `capacity` (e.g. the number of deployed units of the `sku`), which must be a positive `integer` (e.g. `Developer_1`).

        > **Note:** Premium SKUs are limited to a default maximum of 12 (i.e. `Premium_12`), this can, however, be increased via support request.

        > **Note:** Consumption SKU capacity should be 0 (e.g. `Consumption_0`) as this tier includes automatic scaling.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tenantAccess")
    def tenant_access(self) -> pulumi.Output['outputs.ServiceTenantAccess']:
        """
        A `tenant_access` block as defined below.
        """
        return pulumi.get(self, "tenant_access")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkConfiguration")
    def virtual_network_configuration(self) -> pulumi.Output[Optional['outputs.ServiceVirtualNetworkConfiguration']]:
        """
        A `virtual_network_configuration` block as defined below. Required when `virtual_network_type` is `External` or `Internal`.
        """
        return pulumi.get(self, "virtual_network_configuration")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkType")
    def virtual_network_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of virtual network you want to use, valid values include: `None`, `External`, `Internal`. Defaults to `None`.

        > **Note:** Please ensure that in the subnet, inbound port 3443 is open when `virtual_network_type` is `Internal` or `External`. Additionally, please ensure other necessary ports are open according to [api management network configuration](https://learn.microsoft.com/azure/api-management/virtual-network-reference).
        """
        return pulumi.get(self, "virtual_network_type")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of Availability Zones in which this API Management service should be located.

        > **Note:** Availability zones are only supported in the Premium tier.
        """
        return pulumi.get(self, "zones")

