# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkbookArgs', 'Workbook']

@pulumi.input_type
class WorkbookArgs:
    def __init__(__self__, *,
                 data_json: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['WorkbookIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Workbook resource.
        :param pulumi.Input[_builtins.str] data_json: Configuration of this particular workbook. Configuration data is a string containing valid JSON.
        :param pulumi.Input[_builtins.str] display_name: Specifies the user-defined name (display name) of the workbook.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Workbook should exist. Changing this forces a new Workbook to be created.
        :param pulumi.Input[_builtins.str] category: Workbook category, as defined by the user at creation time. There may be additional category types beyond the following: `workbook`, `sentinel`. Defaults to `workbook`.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the workbook.
        :param pulumi.Input['WorkbookIdentityArgs'] identity: An `identity` block as defined below. Changing this forces a new Workbook to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Workbook should exist. Changing this forces a new Workbook to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Workbook as a UUID/GUID. It should not contain any uppercase letters. Changing this forces a new Workbook to be created.
        :param pulumi.Input[_builtins.str] source_id: Resource ID for a source resource. It should not contain any uppercase letters. Defaults to `azure monitor`.
        :param pulumi.Input[_builtins.str] storage_container_id: Specifies the Resource Manager ID of the Storage Container when bring your own storage is used. Changing this forces a new Workbook to be created.
               
               > **Note:** This is the Resource Manager ID of the Storage Container, rather than the regular ID - and can be accessed on the `storage.Container` Data Source/Resource as `resource_manager_id`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Workbook.
        """
        pulumi.set(__self__, "data_json", data_json)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)
        if storage_container_id is not None:
            pulumi.set(__self__, "storage_container_id", storage_container_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="dataJson")
    def data_json(self) -> pulumi.Input[_builtins.str]:
        """
        Configuration of this particular workbook. Configuration data is a string containing valid JSON.
        """
        return pulumi.get(self, "data_json")

    @data_json.setter
    def data_json(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_json", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the user-defined name (display name) of the workbook.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Resource Group where the Workbook should exist. Changing this forces a new Workbook to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workbook category, as defined by the user at creation time. There may be additional category types beyond the following: `workbook`, `sentinel`. Defaults to `workbook`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the workbook.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['WorkbookIdentityArgs']]:
        """
        An `identity` block as defined below. Changing this forces a new Workbook to be created.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['WorkbookIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Workbook should exist. Changing this forces a new Workbook to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Workbook as a UUID/GUID. It should not contain any uppercase letters. Changing this forces a new Workbook to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID for a source resource. It should not contain any uppercase letters. Defaults to `azure monitor`.
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_id", value)

    @_builtins.property
    @pulumi.getter(name="storageContainerId")
    def storage_container_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Resource Manager ID of the Storage Container when bring your own storage is used. Changing this forces a new Workbook to be created.

        > **Note:** This is the Resource Manager ID of the Storage Container, rather than the regular ID - and can be accessed on the `storage.Container` Data Source/Resource as `resource_manager_id`.
        """
        return pulumi.get(self, "storage_container_id")

    @storage_container_id.setter
    def storage_container_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_container_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Workbook.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _WorkbookState:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 data_json: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['WorkbookIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Workbook resources.
        :param pulumi.Input[_builtins.str] category: Workbook category, as defined by the user at creation time. There may be additional category types beyond the following: `workbook`, `sentinel`. Defaults to `workbook`.
        :param pulumi.Input[_builtins.str] data_json: Configuration of this particular workbook. Configuration data is a string containing valid JSON.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the workbook.
        :param pulumi.Input[_builtins.str] display_name: Specifies the user-defined name (display name) of the workbook.
        :param pulumi.Input['WorkbookIdentityArgs'] identity: An `identity` block as defined below. Changing this forces a new Workbook to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Workbook should exist. Changing this forces a new Workbook to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Workbook as a UUID/GUID. It should not contain any uppercase letters. Changing this forces a new Workbook to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Workbook should exist. Changing this forces a new Workbook to be created.
        :param pulumi.Input[_builtins.str] source_id: Resource ID for a source resource. It should not contain any uppercase letters. Defaults to `azure monitor`.
        :param pulumi.Input[_builtins.str] storage_container_id: Specifies the Resource Manager ID of the Storage Container when bring your own storage is used. Changing this forces a new Workbook to be created.
               
               > **Note:** This is the Resource Manager ID of the Storage Container, rather than the regular ID - and can be accessed on the `storage.Container` Data Source/Resource as `resource_manager_id`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Workbook.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if data_json is not None:
            pulumi.set(__self__, "data_json", data_json)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)
        if storage_container_id is not None:
            pulumi.set(__self__, "storage_container_id", storage_container_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workbook category, as defined by the user at creation time. There may be additional category types beyond the following: `workbook`, `sentinel`. Defaults to `workbook`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="dataJson")
    def data_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Configuration of this particular workbook. Configuration data is a string containing valid JSON.
        """
        return pulumi.get(self, "data_json")

    @data_json.setter
    def data_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_json", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the workbook.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the user-defined name (display name) of the workbook.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['WorkbookIdentityArgs']]:
        """
        An `identity` block as defined below. Changing this forces a new Workbook to be created.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['WorkbookIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Workbook should exist. Changing this forces a new Workbook to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Workbook as a UUID/GUID. It should not contain any uppercase letters. Changing this forces a new Workbook to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Resource Group where the Workbook should exist. Changing this forces a new Workbook to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource ID for a source resource. It should not contain any uppercase letters. Defaults to `azure monitor`.
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_id", value)

    @_builtins.property
    @pulumi.getter(name="storageContainerId")
    def storage_container_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Resource Manager ID of the Storage Container when bring your own storage is used. Changing this forces a new Workbook to be created.

        > **Note:** This is the Resource Manager ID of the Storage Container, rather than the regular ID - and can be accessed on the `storage.Container` Data Source/Resource as `resource_manager_id`.
        """
        return pulumi.get(self, "storage_container_id")

    @storage_container_id.setter
    def storage_container_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_container_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Workbook.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:appinsights/workbook:Workbook")
class Workbook(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 data_json: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['WorkbookIdentityArgs', 'WorkbookIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Azure Workbook.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_workbook = azure.appinsights.Workbook("example",
            name="85b3e8bb-fc93-40be-83f2-98f6bec18ba0",
            resource_group_name=example.name,
            location=example.location,
            display_name="workbook1",
            data_json=json.dumps({
                "version": "Notebook/1.0",
                "items": [{
                    "type": 1,
                    "content": {
                        "json": "Test2022",
                    },
                    "name": "text - 0",
                }],
                "isLocked": False,
                "fallbackResourceIds": ["Azure Monitor"],
            }),
            tags={
                "ENV": "Test",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights` - 2022-04-01

        ## Import

        Workbooks can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appinsights/workbook:Workbook example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Insights/workbooks/resource1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] category: Workbook category, as defined by the user at creation time. There may be additional category types beyond the following: `workbook`, `sentinel`. Defaults to `workbook`.
        :param pulumi.Input[_builtins.str] data_json: Configuration of this particular workbook. Configuration data is a string containing valid JSON.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the workbook.
        :param pulumi.Input[_builtins.str] display_name: Specifies the user-defined name (display name) of the workbook.
        :param pulumi.Input[Union['WorkbookIdentityArgs', 'WorkbookIdentityArgsDict']] identity: An `identity` block as defined below. Changing this forces a new Workbook to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Workbook should exist. Changing this forces a new Workbook to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Workbook as a UUID/GUID. It should not contain any uppercase letters. Changing this forces a new Workbook to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Workbook should exist. Changing this forces a new Workbook to be created.
        :param pulumi.Input[_builtins.str] source_id: Resource ID for a source resource. It should not contain any uppercase letters. Defaults to `azure monitor`.
        :param pulumi.Input[_builtins.str] storage_container_id: Specifies the Resource Manager ID of the Storage Container when bring your own storage is used. Changing this forces a new Workbook to be created.
               
               > **Note:** This is the Resource Manager ID of the Storage Container, rather than the regular ID - and can be accessed on the `storage.Container` Data Source/Resource as `resource_manager_id`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Workbook.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkbookArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Workbook.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_workbook = azure.appinsights.Workbook("example",
            name="85b3e8bb-fc93-40be-83f2-98f6bec18ba0",
            resource_group_name=example.name,
            location=example.location,
            display_name="workbook1",
            data_json=json.dumps({
                "version": "Notebook/1.0",
                "items": [{
                    "type": 1,
                    "content": {
                        "json": "Test2022",
                    },
                    "name": "text - 0",
                }],
                "isLocked": False,
                "fallbackResourceIds": ["Azure Monitor"],
            }),
            tags={
                "ENV": "Test",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights` - 2022-04-01

        ## Import

        Workbooks can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appinsights/workbook:Workbook example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Insights/workbooks/resource1
        ```

        :param str resource_name: The name of the resource.
        :param WorkbookArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkbookArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 data_json: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['WorkbookIdentityArgs', 'WorkbookIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkbookArgs.__new__(WorkbookArgs)

            __props__.__dict__["category"] = category
            if data_json is None and not opts.urn:
                raise TypeError("Missing required property 'data_json'")
            __props__.__dict__["data_json"] = data_json
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["source_id"] = source_id
            __props__.__dict__["storage_container_id"] = storage_container_id
            __props__.__dict__["tags"] = tags
        super(Workbook, __self__).__init__(
            'azure:appinsights/workbook:Workbook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            category: Optional[pulumi.Input[_builtins.str]] = None,
            data_json: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['WorkbookIdentityArgs', 'WorkbookIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            source_id: Optional[pulumi.Input[_builtins.str]] = None,
            storage_container_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Workbook':
        """
        Get an existing Workbook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] category: Workbook category, as defined by the user at creation time. There may be additional category types beyond the following: `workbook`, `sentinel`. Defaults to `workbook`.
        :param pulumi.Input[_builtins.str] data_json: Configuration of this particular workbook. Configuration data is a string containing valid JSON.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the workbook.
        :param pulumi.Input[_builtins.str] display_name: Specifies the user-defined name (display name) of the workbook.
        :param pulumi.Input[Union['WorkbookIdentityArgs', 'WorkbookIdentityArgsDict']] identity: An `identity` block as defined below. Changing this forces a new Workbook to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Workbook should exist. Changing this forces a new Workbook to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Workbook as a UUID/GUID. It should not contain any uppercase letters. Changing this forces a new Workbook to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Workbook should exist. Changing this forces a new Workbook to be created.
        :param pulumi.Input[_builtins.str] source_id: Resource ID for a source resource. It should not contain any uppercase letters. Defaults to `azure monitor`.
        :param pulumi.Input[_builtins.str] storage_container_id: Specifies the Resource Manager ID of the Storage Container when bring your own storage is used. Changing this forces a new Workbook to be created.
               
               > **Note:** This is the Resource Manager ID of the Storage Container, rather than the regular ID - and can be accessed on the `storage.Container` Data Source/Resource as `resource_manager_id`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Workbook.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkbookState.__new__(_WorkbookState)

        __props__.__dict__["category"] = category
        __props__.__dict__["data_json"] = data_json
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["source_id"] = source_id
        __props__.__dict__["storage_container_id"] = storage_container_id
        __props__.__dict__["tags"] = tags
        return Workbook(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Workbook category, as defined by the user at creation time. There may be additional category types beyond the following: `workbook`, `sentinel`. Defaults to `workbook`.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="dataJson")
    def data_json(self) -> pulumi.Output[_builtins.str]:
        """
        Configuration of this particular workbook. Configuration data is a string containing valid JSON.
        """
        return pulumi.get(self, "data_json")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the workbook.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the user-defined name (display name) of the workbook.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.WorkbookIdentity']]:
        """
        An `identity` block as defined below. Changing this forces a new Workbook to be created.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Azure Region where the Workbook should exist. Changing this forces a new Workbook to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of this Workbook as a UUID/GUID. It should not contain any uppercase letters. Changing this forces a new Workbook to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Resource Group where the Workbook should exist. Changing this forces a new Workbook to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Resource ID for a source resource. It should not contain any uppercase letters. Defaults to `azure monitor`.
        """
        return pulumi.get(self, "source_id")

    @_builtins.property
    @pulumi.getter(name="storageContainerId")
    def storage_container_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Resource Manager ID of the Storage Container when bring your own storage is used. Changing this forces a new Workbook to be created.

        > **Note:** This is the Resource Manager ID of the Storage Container, rather than the regular ID - and can be accessed on the `storage.Container` Data Source/Resource as `resource_manager_id`.
        """
        return pulumi.get(self, "storage_container_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Workbook.
        """
        return pulumi.get(self, "tags")

