# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SpringCloudGatewayArgs', 'SpringCloudGateway']

@pulumi.input_type
class SpringCloudGatewayArgs:
    def __init__(__self__, *,
                 spring_cloud_service_id: pulumi.Input[_builtins.str],
                 api_metadata: Optional[pulumi.Input['SpringCloudGatewayApiMetadataArgs']] = None,
                 application_performance_monitoring_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 application_performance_monitoring_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_authorization: Optional[pulumi.Input['SpringCloudGatewayClientAuthorizationArgs']] = None,
                 cors: Optional[pulumi.Input['SpringCloudGatewayCorsArgs']] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 https_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_count: Optional[pulumi.Input[_builtins.int]] = None,
                 local_response_cache_per_instance: Optional[pulumi.Input['SpringCloudGatewayLocalResponseCachePerInstanceArgs']] = None,
                 local_response_cache_per_route: Optional[pulumi.Input['SpringCloudGatewayLocalResponseCachePerRouteArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 quota: Optional[pulumi.Input['SpringCloudGatewayQuotaArgs']] = None,
                 sensitive_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 sso: Optional[pulumi.Input['SpringCloudGatewaySsoArgs']] = None):
        """
        The set of arguments for constructing a SpringCloudGateway resource.
        :param pulumi.Input[_builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Gateway to be created.
        :param pulumi.Input['SpringCloudGatewayApiMetadataArgs'] api_metadata: A `api_metadata` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] application_performance_monitoring_ids: Specifies a list of Spring Cloud Application Performance Monitoring IDs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] application_performance_monitoring_types: Specifies a list of application performance monitoring types used in the Spring Cloud Gateway. The allowed values are `AppDynamics`, `ApplicationInsights`, `Dynatrace`, `ElasticAPM` and `NewRelic`.
        :param pulumi.Input['SpringCloudGatewayClientAuthorizationArgs'] client_authorization: A `client_authorization` block as defined below.
        :param pulumi.Input['SpringCloudGatewayCorsArgs'] cors: A `cors` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: Specifies the environment variables of the Spring Cloud Gateway as a map of key-value pairs.
        :param pulumi.Input[_builtins.bool] https_only: is only https is allowed?
        :param pulumi.Input[_builtins.int] instance_count: Specifies the required instance count of the Spring Cloud Gateway. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        :param pulumi.Input['SpringCloudGatewayLocalResponseCachePerInstanceArgs'] local_response_cache_per_instance: A `local_response_cache_per_instance` block as defined below. Only one of `local_response_cache_per_instance` or `local_response_cache_per_route` can be specified.
        :param pulumi.Input['SpringCloudGatewayLocalResponseCachePerRouteArgs'] local_response_cache_per_route: A `local_response_cache_per_route` block as defined below. Only one of `local_response_cache_per_instance` or `local_response_cache_per_route` can be specified.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Spring Cloud Gateway. Changing this forces a new Spring Cloud Gateway to be created. The only possible value is `default`.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Indicates whether the Spring Cloud Gateway exposes endpoint.
        :param pulumi.Input['SpringCloudGatewayQuotaArgs'] quota: A `quota` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] sensitive_environment_variables: Specifies the sensitive environment variables of the Spring Cloud Gateway as a map of key-value pairs.
        :param pulumi.Input['SpringCloudGatewaySsoArgs'] sso: A `sso` block as defined below.
        """
        pulumi.set(__self__, "spring_cloud_service_id", spring_cloud_service_id)
        if api_metadata is not None:
            pulumi.set(__self__, "api_metadata", api_metadata)
        if application_performance_monitoring_ids is not None:
            pulumi.set(__self__, "application_performance_monitoring_ids", application_performance_monitoring_ids)
        if application_performance_monitoring_types is not None:
            pulumi.set(__self__, "application_performance_monitoring_types", application_performance_monitoring_types)
        if client_authorization is not None:
            pulumi.set(__self__, "client_authorization", client_authorization)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if https_only is not None:
            pulumi.set(__self__, "https_only", https_only)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if local_response_cache_per_instance is not None:
            pulumi.set(__self__, "local_response_cache_per_instance", local_response_cache_per_instance)
        if local_response_cache_per_route is not None:
            pulumi.set(__self__, "local_response_cache_per_route", local_response_cache_per_route)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if quota is not None:
            pulumi.set(__self__, "quota", quota)
        if sensitive_environment_variables is not None:
            pulumi.set(__self__, "sensitive_environment_variables", sensitive_environment_variables)
        if sso is not None:
            pulumi.set(__self__, "sso", sso)

    @_builtins.property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Gateway to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @spring_cloud_service_id.setter
    def spring_cloud_service_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "spring_cloud_service_id", value)

    @_builtins.property
    @pulumi.getter(name="apiMetadata")
    def api_metadata(self) -> Optional[pulumi.Input['SpringCloudGatewayApiMetadataArgs']]:
        """
        A `api_metadata` block as defined below.
        """
        return pulumi.get(self, "api_metadata")

    @api_metadata.setter
    def api_metadata(self, value: Optional[pulumi.Input['SpringCloudGatewayApiMetadataArgs']]):
        pulumi.set(self, "api_metadata", value)

    @_builtins.property
    @pulumi.getter(name="applicationPerformanceMonitoringIds")
    def application_performance_monitoring_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Spring Cloud Application Performance Monitoring IDs.
        """
        return pulumi.get(self, "application_performance_monitoring_ids")

    @application_performance_monitoring_ids.setter
    def application_performance_monitoring_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "application_performance_monitoring_ids", value)

    @_builtins.property
    @pulumi.getter(name="applicationPerformanceMonitoringTypes")
    def application_performance_monitoring_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of application performance monitoring types used in the Spring Cloud Gateway. The allowed values are `AppDynamics`, `ApplicationInsights`, `Dynatrace`, `ElasticAPM` and `NewRelic`.
        """
        return pulumi.get(self, "application_performance_monitoring_types")

    @application_performance_monitoring_types.setter
    def application_performance_monitoring_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "application_performance_monitoring_types", value)

    @_builtins.property
    @pulumi.getter(name="clientAuthorization")
    def client_authorization(self) -> Optional[pulumi.Input['SpringCloudGatewayClientAuthorizationArgs']]:
        """
        A `client_authorization` block as defined below.
        """
        return pulumi.get(self, "client_authorization")

    @client_authorization.setter
    def client_authorization(self, value: Optional[pulumi.Input['SpringCloudGatewayClientAuthorizationArgs']]):
        pulumi.set(self, "client_authorization", value)

    @_builtins.property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input['SpringCloudGatewayCorsArgs']]:
        """
        A `cors` block as defined below.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input['SpringCloudGatewayCorsArgs']]):
        pulumi.set(self, "cors", value)

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the environment variables of the Spring Cloud Gateway as a map of key-value pairs.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "environment_variables", value)

    @_builtins.property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        is only https is allowed?
        """
        return pulumi.get(self, "https_only")

    @https_only.setter
    def https_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "https_only", value)

    @_builtins.property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the required instance count of the Spring Cloud Gateway. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_count", value)

    @_builtins.property
    @pulumi.getter(name="localResponseCachePerInstance")
    def local_response_cache_per_instance(self) -> Optional[pulumi.Input['SpringCloudGatewayLocalResponseCachePerInstanceArgs']]:
        """
        A `local_response_cache_per_instance` block as defined below. Only one of `local_response_cache_per_instance` or `local_response_cache_per_route` can be specified.
        """
        return pulumi.get(self, "local_response_cache_per_instance")

    @local_response_cache_per_instance.setter
    def local_response_cache_per_instance(self, value: Optional[pulumi.Input['SpringCloudGatewayLocalResponseCachePerInstanceArgs']]):
        pulumi.set(self, "local_response_cache_per_instance", value)

    @_builtins.property
    @pulumi.getter(name="localResponseCachePerRoute")
    def local_response_cache_per_route(self) -> Optional[pulumi.Input['SpringCloudGatewayLocalResponseCachePerRouteArgs']]:
        """
        A `local_response_cache_per_route` block as defined below. Only one of `local_response_cache_per_instance` or `local_response_cache_per_route` can be specified.
        """
        return pulumi.get(self, "local_response_cache_per_route")

    @local_response_cache_per_route.setter
    def local_response_cache_per_route(self, value: Optional[pulumi.Input['SpringCloudGatewayLocalResponseCachePerRouteArgs']]):
        pulumi.set(self, "local_response_cache_per_route", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Spring Cloud Gateway. Changing this forces a new Spring Cloud Gateway to be created. The only possible value is `default`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the Spring Cloud Gateway exposes endpoint.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input['SpringCloudGatewayQuotaArgs']]:
        """
        A `quota` block as defined below.
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input['SpringCloudGatewayQuotaArgs']]):
        pulumi.set(self, "quota", value)

    @_builtins.property
    @pulumi.getter(name="sensitiveEnvironmentVariables")
    def sensitive_environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the sensitive environment variables of the Spring Cloud Gateway as a map of key-value pairs.
        """
        return pulumi.get(self, "sensitive_environment_variables")

    @sensitive_environment_variables.setter
    def sensitive_environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sensitive_environment_variables", value)

    @_builtins.property
    @pulumi.getter
    def sso(self) -> Optional[pulumi.Input['SpringCloudGatewaySsoArgs']]:
        """
        A `sso` block as defined below.
        """
        return pulumi.get(self, "sso")

    @sso.setter
    def sso(self, value: Optional[pulumi.Input['SpringCloudGatewaySsoArgs']]):
        pulumi.set(self, "sso", value)


@pulumi.input_type
class _SpringCloudGatewayState:
    def __init__(__self__, *,
                 api_metadata: Optional[pulumi.Input['SpringCloudGatewayApiMetadataArgs']] = None,
                 application_performance_monitoring_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 application_performance_monitoring_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_authorization: Optional[pulumi.Input['SpringCloudGatewayClientAuthorizationArgs']] = None,
                 cors: Optional[pulumi.Input['SpringCloudGatewayCorsArgs']] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 https_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_count: Optional[pulumi.Input[_builtins.int]] = None,
                 local_response_cache_per_instance: Optional[pulumi.Input['SpringCloudGatewayLocalResponseCachePerInstanceArgs']] = None,
                 local_response_cache_per_route: Optional[pulumi.Input['SpringCloudGatewayLocalResponseCachePerRouteArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 quota: Optional[pulumi.Input['SpringCloudGatewayQuotaArgs']] = None,
                 sensitive_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sso: Optional[pulumi.Input['SpringCloudGatewaySsoArgs']] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SpringCloudGateway resources.
        :param pulumi.Input['SpringCloudGatewayApiMetadataArgs'] api_metadata: A `api_metadata` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] application_performance_monitoring_ids: Specifies a list of Spring Cloud Application Performance Monitoring IDs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] application_performance_monitoring_types: Specifies a list of application performance monitoring types used in the Spring Cloud Gateway. The allowed values are `AppDynamics`, `ApplicationInsights`, `Dynatrace`, `ElasticAPM` and `NewRelic`.
        :param pulumi.Input['SpringCloudGatewayClientAuthorizationArgs'] client_authorization: A `client_authorization` block as defined below.
        :param pulumi.Input['SpringCloudGatewayCorsArgs'] cors: A `cors` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: Specifies the environment variables of the Spring Cloud Gateway as a map of key-value pairs.
        :param pulumi.Input[_builtins.bool] https_only: is only https is allowed?
        :param pulumi.Input[_builtins.int] instance_count: Specifies the required instance count of the Spring Cloud Gateway. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        :param pulumi.Input['SpringCloudGatewayLocalResponseCachePerInstanceArgs'] local_response_cache_per_instance: A `local_response_cache_per_instance` block as defined below. Only one of `local_response_cache_per_instance` or `local_response_cache_per_route` can be specified.
        :param pulumi.Input['SpringCloudGatewayLocalResponseCachePerRouteArgs'] local_response_cache_per_route: A `local_response_cache_per_route` block as defined below. Only one of `local_response_cache_per_instance` or `local_response_cache_per_route` can be specified.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Spring Cloud Gateway. Changing this forces a new Spring Cloud Gateway to be created. The only possible value is `default`.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Indicates whether the Spring Cloud Gateway exposes endpoint.
        :param pulumi.Input['SpringCloudGatewayQuotaArgs'] quota: A `quota` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] sensitive_environment_variables: Specifies the sensitive environment variables of the Spring Cloud Gateway as a map of key-value pairs.
        :param pulumi.Input[_builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Gateway to be created.
        :param pulumi.Input['SpringCloudGatewaySsoArgs'] sso: A `sso` block as defined below.
        :param pulumi.Input[_builtins.str] url: URL of the Spring Cloud Gateway, exposed when 'public_network_access_enabled' is true.
        """
        if api_metadata is not None:
            pulumi.set(__self__, "api_metadata", api_metadata)
        if application_performance_monitoring_ids is not None:
            pulumi.set(__self__, "application_performance_monitoring_ids", application_performance_monitoring_ids)
        if application_performance_monitoring_types is not None:
            pulumi.set(__self__, "application_performance_monitoring_types", application_performance_monitoring_types)
        if client_authorization is not None:
            pulumi.set(__self__, "client_authorization", client_authorization)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if https_only is not None:
            pulumi.set(__self__, "https_only", https_only)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if local_response_cache_per_instance is not None:
            pulumi.set(__self__, "local_response_cache_per_instance", local_response_cache_per_instance)
        if local_response_cache_per_route is not None:
            pulumi.set(__self__, "local_response_cache_per_route", local_response_cache_per_route)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if quota is not None:
            pulumi.set(__self__, "quota", quota)
        if sensitive_environment_variables is not None:
            pulumi.set(__self__, "sensitive_environment_variables", sensitive_environment_variables)
        if spring_cloud_service_id is not None:
            pulumi.set(__self__, "spring_cloud_service_id", spring_cloud_service_id)
        if sso is not None:
            pulumi.set(__self__, "sso", sso)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter(name="apiMetadata")
    def api_metadata(self) -> Optional[pulumi.Input['SpringCloudGatewayApiMetadataArgs']]:
        """
        A `api_metadata` block as defined below.
        """
        return pulumi.get(self, "api_metadata")

    @api_metadata.setter
    def api_metadata(self, value: Optional[pulumi.Input['SpringCloudGatewayApiMetadataArgs']]):
        pulumi.set(self, "api_metadata", value)

    @_builtins.property
    @pulumi.getter(name="applicationPerformanceMonitoringIds")
    def application_performance_monitoring_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Spring Cloud Application Performance Monitoring IDs.
        """
        return pulumi.get(self, "application_performance_monitoring_ids")

    @application_performance_monitoring_ids.setter
    def application_performance_monitoring_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "application_performance_monitoring_ids", value)

    @_builtins.property
    @pulumi.getter(name="applicationPerformanceMonitoringTypes")
    def application_performance_monitoring_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of application performance monitoring types used in the Spring Cloud Gateway. The allowed values are `AppDynamics`, `ApplicationInsights`, `Dynatrace`, `ElasticAPM` and `NewRelic`.
        """
        return pulumi.get(self, "application_performance_monitoring_types")

    @application_performance_monitoring_types.setter
    def application_performance_monitoring_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "application_performance_monitoring_types", value)

    @_builtins.property
    @pulumi.getter(name="clientAuthorization")
    def client_authorization(self) -> Optional[pulumi.Input['SpringCloudGatewayClientAuthorizationArgs']]:
        """
        A `client_authorization` block as defined below.
        """
        return pulumi.get(self, "client_authorization")

    @client_authorization.setter
    def client_authorization(self, value: Optional[pulumi.Input['SpringCloudGatewayClientAuthorizationArgs']]):
        pulumi.set(self, "client_authorization", value)

    @_builtins.property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input['SpringCloudGatewayCorsArgs']]:
        """
        A `cors` block as defined below.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input['SpringCloudGatewayCorsArgs']]):
        pulumi.set(self, "cors", value)

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the environment variables of the Spring Cloud Gateway as a map of key-value pairs.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "environment_variables", value)

    @_builtins.property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        is only https is allowed?
        """
        return pulumi.get(self, "https_only")

    @https_only.setter
    def https_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "https_only", value)

    @_builtins.property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the required instance count of the Spring Cloud Gateway. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        """
        return pulumi.get(self, "instance_count")

    @instance_count.setter
    def instance_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "instance_count", value)

    @_builtins.property
    @pulumi.getter(name="localResponseCachePerInstance")
    def local_response_cache_per_instance(self) -> Optional[pulumi.Input['SpringCloudGatewayLocalResponseCachePerInstanceArgs']]:
        """
        A `local_response_cache_per_instance` block as defined below. Only one of `local_response_cache_per_instance` or `local_response_cache_per_route` can be specified.
        """
        return pulumi.get(self, "local_response_cache_per_instance")

    @local_response_cache_per_instance.setter
    def local_response_cache_per_instance(self, value: Optional[pulumi.Input['SpringCloudGatewayLocalResponseCachePerInstanceArgs']]):
        pulumi.set(self, "local_response_cache_per_instance", value)

    @_builtins.property
    @pulumi.getter(name="localResponseCachePerRoute")
    def local_response_cache_per_route(self) -> Optional[pulumi.Input['SpringCloudGatewayLocalResponseCachePerRouteArgs']]:
        """
        A `local_response_cache_per_route` block as defined below. Only one of `local_response_cache_per_instance` or `local_response_cache_per_route` can be specified.
        """
        return pulumi.get(self, "local_response_cache_per_route")

    @local_response_cache_per_route.setter
    def local_response_cache_per_route(self, value: Optional[pulumi.Input['SpringCloudGatewayLocalResponseCachePerRouteArgs']]):
        pulumi.set(self, "local_response_cache_per_route", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Spring Cloud Gateway. Changing this forces a new Spring Cloud Gateway to be created. The only possible value is `default`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the Spring Cloud Gateway exposes endpoint.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input['SpringCloudGatewayQuotaArgs']]:
        """
        A `quota` block as defined below.
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input['SpringCloudGatewayQuotaArgs']]):
        pulumi.set(self, "quota", value)

    @_builtins.property
    @pulumi.getter(name="sensitiveEnvironmentVariables")
    def sensitive_environment_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the sensitive environment variables of the Spring Cloud Gateway as a map of key-value pairs.
        """
        return pulumi.get(self, "sensitive_environment_variables")

    @sensitive_environment_variables.setter
    def sensitive_environment_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "sensitive_environment_variables", value)

    @_builtins.property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Gateway to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @spring_cloud_service_id.setter
    def spring_cloud_service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spring_cloud_service_id", value)

    @_builtins.property
    @pulumi.getter
    def sso(self) -> Optional[pulumi.Input['SpringCloudGatewaySsoArgs']]:
        """
        A `sso` block as defined below.
        """
        return pulumi.get(self, "sso")

    @sso.setter
    def sso(self, value: Optional[pulumi.Input['SpringCloudGatewaySsoArgs']]):
        pulumi.set(self, "sso", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL of the Spring Cloud Gateway, exposed when 'public_network_access_enabled' is true.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)


@pulumi.type_token("azure:appplatform/springCloudGateway:SpringCloudGateway")
class SpringCloudGateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_metadata: Optional[pulumi.Input[Union['SpringCloudGatewayApiMetadataArgs', 'SpringCloudGatewayApiMetadataArgsDict']]] = None,
                 application_performance_monitoring_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 application_performance_monitoring_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_authorization: Optional[pulumi.Input[Union['SpringCloudGatewayClientAuthorizationArgs', 'SpringCloudGatewayClientAuthorizationArgsDict']]] = None,
                 cors: Optional[pulumi.Input[Union['SpringCloudGatewayCorsArgs', 'SpringCloudGatewayCorsArgsDict']]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 https_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_count: Optional[pulumi.Input[_builtins.int]] = None,
                 local_response_cache_per_instance: Optional[pulumi.Input[Union['SpringCloudGatewayLocalResponseCachePerInstanceArgs', 'SpringCloudGatewayLocalResponseCachePerInstanceArgsDict']]] = None,
                 local_response_cache_per_route: Optional[pulumi.Input[Union['SpringCloudGatewayLocalResponseCachePerRouteArgs', 'SpringCloudGatewayLocalResponseCachePerRouteArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 quota: Optional[pulumi.Input[Union['SpringCloudGatewayQuotaArgs', 'SpringCloudGatewayQuotaArgsDict']]] = None,
                 sensitive_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sso: Optional[pulumi.Input[Union['SpringCloudGatewaySsoArgs', 'SpringCloudGatewaySsoArgsDict']]] = None,
                 __props__=None):
        """
        > **Note:** This resource is applicable only for Spring Cloud Service with enterprise tier.

        Manages a Spring Cloud Gateway.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudGateway` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="E0")
        example_spring_cloud_gateway = azure.appplatform.SpringCloudGateway("example",
            name="default",
            spring_cloud_service_id=example_spring_cloud_service.id,
            https_only=False,
            public_network_access_enabled=True,
            instance_count=2,
            api_metadata={
                "description": "example description",
                "documentation_url": "https://www.example.com/docs",
                "server_url": "https://wwww.example.com",
                "title": "example title",
                "version": "1.0",
            },
            cors={
                "credentials_allowed": False,
                "allowed_headers": ["*"],
                "allowed_methods": ["PUT"],
                "allowed_origins": ["example.com"],
                "exposed_headers": ["x-example-header"],
                "max_age_seconds": 86400,
            },
            quota={
                "cpu": "1",
                "memory": "2Gi",
            },
            sso={
                "client_id": "example id",
                "client_secret": "example secret",
                "issuer_uri": "https://www.test.com/issueToken",
                "scopes": ["read"],
            },
            local_response_cache_per_instance={
                "size": "100MB",
                "time_to_live": "30s",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AppPlatform` - 2024-01-01-preview

        ## Import

        Spring Cloud Gateways can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudGateway:SpringCloudGateway example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resourceGroup1/providers/Microsoft.AppPlatform/spring/service1/gateways/gateway1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SpringCloudGatewayApiMetadataArgs', 'SpringCloudGatewayApiMetadataArgsDict']] api_metadata: A `api_metadata` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] application_performance_monitoring_ids: Specifies a list of Spring Cloud Application Performance Monitoring IDs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] application_performance_monitoring_types: Specifies a list of application performance monitoring types used in the Spring Cloud Gateway. The allowed values are `AppDynamics`, `ApplicationInsights`, `Dynatrace`, `ElasticAPM` and `NewRelic`.
        :param pulumi.Input[Union['SpringCloudGatewayClientAuthorizationArgs', 'SpringCloudGatewayClientAuthorizationArgsDict']] client_authorization: A `client_authorization` block as defined below.
        :param pulumi.Input[Union['SpringCloudGatewayCorsArgs', 'SpringCloudGatewayCorsArgsDict']] cors: A `cors` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: Specifies the environment variables of the Spring Cloud Gateway as a map of key-value pairs.
        :param pulumi.Input[_builtins.bool] https_only: is only https is allowed?
        :param pulumi.Input[_builtins.int] instance_count: Specifies the required instance count of the Spring Cloud Gateway. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        :param pulumi.Input[Union['SpringCloudGatewayLocalResponseCachePerInstanceArgs', 'SpringCloudGatewayLocalResponseCachePerInstanceArgsDict']] local_response_cache_per_instance: A `local_response_cache_per_instance` block as defined below. Only one of `local_response_cache_per_instance` or `local_response_cache_per_route` can be specified.
        :param pulumi.Input[Union['SpringCloudGatewayLocalResponseCachePerRouteArgs', 'SpringCloudGatewayLocalResponseCachePerRouteArgsDict']] local_response_cache_per_route: A `local_response_cache_per_route` block as defined below. Only one of `local_response_cache_per_instance` or `local_response_cache_per_route` can be specified.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Spring Cloud Gateway. Changing this forces a new Spring Cloud Gateway to be created. The only possible value is `default`.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Indicates whether the Spring Cloud Gateway exposes endpoint.
        :param pulumi.Input[Union['SpringCloudGatewayQuotaArgs', 'SpringCloudGatewayQuotaArgsDict']] quota: A `quota` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] sensitive_environment_variables: Specifies the sensitive environment variables of the Spring Cloud Gateway as a map of key-value pairs.
        :param pulumi.Input[_builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Gateway to be created.
        :param pulumi.Input[Union['SpringCloudGatewaySsoArgs', 'SpringCloudGatewaySsoArgsDict']] sso: A `sso` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpringCloudGatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **Note:** This resource is applicable only for Spring Cloud Service with enterprise tier.

        Manages a Spring Cloud Gateway.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudGateway` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku_name="E0")
        example_spring_cloud_gateway = azure.appplatform.SpringCloudGateway("example",
            name="default",
            spring_cloud_service_id=example_spring_cloud_service.id,
            https_only=False,
            public_network_access_enabled=True,
            instance_count=2,
            api_metadata={
                "description": "example description",
                "documentation_url": "https://www.example.com/docs",
                "server_url": "https://wwww.example.com",
                "title": "example title",
                "version": "1.0",
            },
            cors={
                "credentials_allowed": False,
                "allowed_headers": ["*"],
                "allowed_methods": ["PUT"],
                "allowed_origins": ["example.com"],
                "exposed_headers": ["x-example-header"],
                "max_age_seconds": 86400,
            },
            quota={
                "cpu": "1",
                "memory": "2Gi",
            },
            sso={
                "client_id": "example id",
                "client_secret": "example secret",
                "issuer_uri": "https://www.test.com/issueToken",
                "scopes": ["read"],
            },
            local_response_cache_per_instance={
                "size": "100MB",
                "time_to_live": "30s",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AppPlatform` - 2024-01-01-preview

        ## Import

        Spring Cloud Gateways can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudGateway:SpringCloudGateway example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/resourceGroup1/providers/Microsoft.AppPlatform/spring/service1/gateways/gateway1
        ```

        :param str resource_name: The name of the resource.
        :param SpringCloudGatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpringCloudGatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_metadata: Optional[pulumi.Input[Union['SpringCloudGatewayApiMetadataArgs', 'SpringCloudGatewayApiMetadataArgsDict']]] = None,
                 application_performance_monitoring_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 application_performance_monitoring_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 client_authorization: Optional[pulumi.Input[Union['SpringCloudGatewayClientAuthorizationArgs', 'SpringCloudGatewayClientAuthorizationArgsDict']]] = None,
                 cors: Optional[pulumi.Input[Union['SpringCloudGatewayCorsArgs', 'SpringCloudGatewayCorsArgsDict']]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 https_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_count: Optional[pulumi.Input[_builtins.int]] = None,
                 local_response_cache_per_instance: Optional[pulumi.Input[Union['SpringCloudGatewayLocalResponseCachePerInstanceArgs', 'SpringCloudGatewayLocalResponseCachePerInstanceArgsDict']]] = None,
                 local_response_cache_per_route: Optional[pulumi.Input[Union['SpringCloudGatewayLocalResponseCachePerRouteArgs', 'SpringCloudGatewayLocalResponseCachePerRouteArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 quota: Optional[pulumi.Input[Union['SpringCloudGatewayQuotaArgs', 'SpringCloudGatewayQuotaArgsDict']]] = None,
                 sensitive_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 spring_cloud_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sso: Optional[pulumi.Input[Union['SpringCloudGatewaySsoArgs', 'SpringCloudGatewaySsoArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpringCloudGatewayArgs.__new__(SpringCloudGatewayArgs)

            __props__.__dict__["api_metadata"] = api_metadata
            __props__.__dict__["application_performance_monitoring_ids"] = application_performance_monitoring_ids
            __props__.__dict__["application_performance_monitoring_types"] = application_performance_monitoring_types
            __props__.__dict__["client_authorization"] = client_authorization
            __props__.__dict__["cors"] = cors
            __props__.__dict__["environment_variables"] = environment_variables
            __props__.__dict__["https_only"] = https_only
            __props__.__dict__["instance_count"] = instance_count
            __props__.__dict__["local_response_cache_per_instance"] = local_response_cache_per_instance
            __props__.__dict__["local_response_cache_per_route"] = local_response_cache_per_route
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            __props__.__dict__["quota"] = quota
            __props__.__dict__["sensitive_environment_variables"] = None if sensitive_environment_variables is None else pulumi.Output.secret(sensitive_environment_variables)
            if spring_cloud_service_id is None and not opts.urn:
                raise TypeError("Missing required property 'spring_cloud_service_id'")
            __props__.__dict__["spring_cloud_service_id"] = spring_cloud_service_id
            __props__.__dict__["sso"] = sso
            __props__.__dict__["url"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["sensitiveEnvironmentVariables"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(SpringCloudGateway, __self__).__init__(
            'azure:appplatform/springCloudGateway:SpringCloudGateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_metadata: Optional[pulumi.Input[Union['SpringCloudGatewayApiMetadataArgs', 'SpringCloudGatewayApiMetadataArgsDict']]] = None,
            application_performance_monitoring_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            application_performance_monitoring_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            client_authorization: Optional[pulumi.Input[Union['SpringCloudGatewayClientAuthorizationArgs', 'SpringCloudGatewayClientAuthorizationArgsDict']]] = None,
            cors: Optional[pulumi.Input[Union['SpringCloudGatewayCorsArgs', 'SpringCloudGatewayCorsArgsDict']]] = None,
            environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            https_only: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_count: Optional[pulumi.Input[_builtins.int]] = None,
            local_response_cache_per_instance: Optional[pulumi.Input[Union['SpringCloudGatewayLocalResponseCachePerInstanceArgs', 'SpringCloudGatewayLocalResponseCachePerInstanceArgsDict']]] = None,
            local_response_cache_per_route: Optional[pulumi.Input[Union['SpringCloudGatewayLocalResponseCachePerRouteArgs', 'SpringCloudGatewayLocalResponseCachePerRouteArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            quota: Optional[pulumi.Input[Union['SpringCloudGatewayQuotaArgs', 'SpringCloudGatewayQuotaArgsDict']]] = None,
            sensitive_environment_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            spring_cloud_service_id: Optional[pulumi.Input[_builtins.str]] = None,
            sso: Optional[pulumi.Input[Union['SpringCloudGatewaySsoArgs', 'SpringCloudGatewaySsoArgsDict']]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None) -> 'SpringCloudGateway':
        """
        Get an existing SpringCloudGateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SpringCloudGatewayApiMetadataArgs', 'SpringCloudGatewayApiMetadataArgsDict']] api_metadata: A `api_metadata` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] application_performance_monitoring_ids: Specifies a list of Spring Cloud Application Performance Monitoring IDs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] application_performance_monitoring_types: Specifies a list of application performance monitoring types used in the Spring Cloud Gateway. The allowed values are `AppDynamics`, `ApplicationInsights`, `Dynatrace`, `ElasticAPM` and `NewRelic`.
        :param pulumi.Input[Union['SpringCloudGatewayClientAuthorizationArgs', 'SpringCloudGatewayClientAuthorizationArgsDict']] client_authorization: A `client_authorization` block as defined below.
        :param pulumi.Input[Union['SpringCloudGatewayCorsArgs', 'SpringCloudGatewayCorsArgsDict']] cors: A `cors` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] environment_variables: Specifies the environment variables of the Spring Cloud Gateway as a map of key-value pairs.
        :param pulumi.Input[_builtins.bool] https_only: is only https is allowed?
        :param pulumi.Input[_builtins.int] instance_count: Specifies the required instance count of the Spring Cloud Gateway. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        :param pulumi.Input[Union['SpringCloudGatewayLocalResponseCachePerInstanceArgs', 'SpringCloudGatewayLocalResponseCachePerInstanceArgsDict']] local_response_cache_per_instance: A `local_response_cache_per_instance` block as defined below. Only one of `local_response_cache_per_instance` or `local_response_cache_per_route` can be specified.
        :param pulumi.Input[Union['SpringCloudGatewayLocalResponseCachePerRouteArgs', 'SpringCloudGatewayLocalResponseCachePerRouteArgsDict']] local_response_cache_per_route: A `local_response_cache_per_route` block as defined below. Only one of `local_response_cache_per_instance` or `local_response_cache_per_route` can be specified.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Spring Cloud Gateway. Changing this forces a new Spring Cloud Gateway to be created. The only possible value is `default`.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Indicates whether the Spring Cloud Gateway exposes endpoint.
        :param pulumi.Input[Union['SpringCloudGatewayQuotaArgs', 'SpringCloudGatewayQuotaArgsDict']] quota: A `quota` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] sensitive_environment_variables: Specifies the sensitive environment variables of the Spring Cloud Gateway as a map of key-value pairs.
        :param pulumi.Input[_builtins.str] spring_cloud_service_id: The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Gateway to be created.
        :param pulumi.Input[Union['SpringCloudGatewaySsoArgs', 'SpringCloudGatewaySsoArgsDict']] sso: A `sso` block as defined below.
        :param pulumi.Input[_builtins.str] url: URL of the Spring Cloud Gateway, exposed when 'public_network_access_enabled' is true.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpringCloudGatewayState.__new__(_SpringCloudGatewayState)

        __props__.__dict__["api_metadata"] = api_metadata
        __props__.__dict__["application_performance_monitoring_ids"] = application_performance_monitoring_ids
        __props__.__dict__["application_performance_monitoring_types"] = application_performance_monitoring_types
        __props__.__dict__["client_authorization"] = client_authorization
        __props__.__dict__["cors"] = cors
        __props__.__dict__["environment_variables"] = environment_variables
        __props__.__dict__["https_only"] = https_only
        __props__.__dict__["instance_count"] = instance_count
        __props__.__dict__["local_response_cache_per_instance"] = local_response_cache_per_instance
        __props__.__dict__["local_response_cache_per_route"] = local_response_cache_per_route
        __props__.__dict__["name"] = name
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["quota"] = quota
        __props__.__dict__["sensitive_environment_variables"] = sensitive_environment_variables
        __props__.__dict__["spring_cloud_service_id"] = spring_cloud_service_id
        __props__.__dict__["sso"] = sso
        __props__.__dict__["url"] = url
        return SpringCloudGateway(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiMetadata")
    def api_metadata(self) -> pulumi.Output[Optional['outputs.SpringCloudGatewayApiMetadata']]:
        """
        A `api_metadata` block as defined below.
        """
        return pulumi.get(self, "api_metadata")

    @_builtins.property
    @pulumi.getter(name="applicationPerformanceMonitoringIds")
    def application_performance_monitoring_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of Spring Cloud Application Performance Monitoring IDs.
        """
        return pulumi.get(self, "application_performance_monitoring_ids")

    @_builtins.property
    @pulumi.getter(name="applicationPerformanceMonitoringTypes")
    def application_performance_monitoring_types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of application performance monitoring types used in the Spring Cloud Gateway. The allowed values are `AppDynamics`, `ApplicationInsights`, `Dynatrace`, `ElasticAPM` and `NewRelic`.
        """
        return pulumi.get(self, "application_performance_monitoring_types")

    @_builtins.property
    @pulumi.getter(name="clientAuthorization")
    def client_authorization(self) -> pulumi.Output[Optional['outputs.SpringCloudGatewayClientAuthorization']]:
        """
        A `client_authorization` block as defined below.
        """
        return pulumi.get(self, "client_authorization")

    @_builtins.property
    @pulumi.getter
    def cors(self) -> pulumi.Output[Optional['outputs.SpringCloudGatewayCors']]:
        """
        A `cors` block as defined below.
        """
        return pulumi.get(self, "cors")

    @_builtins.property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the environment variables of the Spring Cloud Gateway as a map of key-value pairs.
        """
        return pulumi.get(self, "environment_variables")

    @_builtins.property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        is only https is allowed?
        """
        return pulumi.get(self, "https_only")

    @_builtins.property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the required instance count of the Spring Cloud Gateway. Possible Values are between `1` and `500`. Defaults to `1` if not specified.
        """
        return pulumi.get(self, "instance_count")

    @_builtins.property
    @pulumi.getter(name="localResponseCachePerInstance")
    def local_response_cache_per_instance(self) -> pulumi.Output[Optional['outputs.SpringCloudGatewayLocalResponseCachePerInstance']]:
        """
        A `local_response_cache_per_instance` block as defined below. Only one of `local_response_cache_per_instance` or `local_response_cache_per_route` can be specified.
        """
        return pulumi.get(self, "local_response_cache_per_instance")

    @_builtins.property
    @pulumi.getter(name="localResponseCachePerRoute")
    def local_response_cache_per_route(self) -> pulumi.Output[Optional['outputs.SpringCloudGatewayLocalResponseCachePerRoute']]:
        """
        A `local_response_cache_per_route` block as defined below. Only one of `local_response_cache_per_instance` or `local_response_cache_per_route` can be specified.
        """
        return pulumi.get(self, "local_response_cache_per_route")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Spring Cloud Gateway. Changing this forces a new Spring Cloud Gateway to be created. The only possible value is `default`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether the Spring Cloud Gateway exposes endpoint.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter
    def quota(self) -> pulumi.Output['outputs.SpringCloudGatewayQuota']:
        """
        A `quota` block as defined below.
        """
        return pulumi.get(self, "quota")

    @_builtins.property
    @pulumi.getter(name="sensitiveEnvironmentVariables")
    def sensitive_environment_variables(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the sensitive environment variables of the Spring Cloud Gateway as a map of key-value pairs.
        """
        return pulumi.get(self, "sensitive_environment_variables")

    @_builtins.property
    @pulumi.getter(name="springCloudServiceId")
    def spring_cloud_service_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Spring Cloud Service. Changing this forces a new Spring Cloud Gateway to be created.
        """
        return pulumi.get(self, "spring_cloud_service_id")

    @_builtins.property
    @pulumi.getter
    def sso(self) -> pulumi.Output[Optional['outputs.SpringCloudGatewaySso']]:
        """
        A `sso` block as defined below.
        """
        return pulumi.get(self, "sso")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[_builtins.str]:
        """
        URL of the Spring Cloud Gateway, exposed when 'public_network_access_enabled' is true.
        """
        return pulumi.get(self, "url")

