# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetServicePlanResult',
    'AwaitableGetServicePlanResult',
    'get_service_plan',
    'get_service_plan_output',
]

@pulumi.output_type
class GetServicePlanResult:
    """
    A collection of values returned by getServicePlan.
    """
    def __init__(__self__, app_service_environment_id=None, id=None, kind=None, location=None, maximum_elastic_worker_count=None, name=None, os_type=None, per_site_scaling_enabled=None, reserved=None, resource_group_name=None, sku_name=None, tags=None, worker_count=None, zone_balancing_enabled=None):
        if app_service_environment_id and not isinstance(app_service_environment_id, str):
            raise TypeError("Expected argument 'app_service_environment_id' to be a str")
        pulumi.set(__self__, "app_service_environment_id", app_service_environment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if maximum_elastic_worker_count and not isinstance(maximum_elastic_worker_count, int):
            raise TypeError("Expected argument 'maximum_elastic_worker_count' to be a int")
        pulumi.set(__self__, "maximum_elastic_worker_count", maximum_elastic_worker_count)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if os_type and not isinstance(os_type, str):
            raise TypeError("Expected argument 'os_type' to be a str")
        pulumi.set(__self__, "os_type", os_type)
        if per_site_scaling_enabled and not isinstance(per_site_scaling_enabled, bool):
            raise TypeError("Expected argument 'per_site_scaling_enabled' to be a bool")
        pulumi.set(__self__, "per_site_scaling_enabled", per_site_scaling_enabled)
        if reserved and not isinstance(reserved, bool):
            raise TypeError("Expected argument 'reserved' to be a bool")
        pulumi.set(__self__, "reserved", reserved)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku_name and not isinstance(sku_name, str):
            raise TypeError("Expected argument 'sku_name' to be a str")
        pulumi.set(__self__, "sku_name", sku_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if worker_count and not isinstance(worker_count, int):
            raise TypeError("Expected argument 'worker_count' to be a int")
        pulumi.set(__self__, "worker_count", worker_count)
        if zone_balancing_enabled and not isinstance(zone_balancing_enabled, bool):
            raise TypeError("Expected argument 'zone_balancing_enabled' to be a bool")
        pulumi.set(__self__, "zone_balancing_enabled", zone_balancing_enabled)

    @_builtins.property
    @pulumi.getter(name="appServiceEnvironmentId")
    def app_service_environment_id(self) -> _builtins.str:
        """
        The ID of the App Service Environment this Service Plan is part of.
        """
        return pulumi.get(self, "app_service_environment_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        A string representing the Kind of Service Plan.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Service Plan exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="maximumElasticWorkerCount")
    def maximum_elastic_worker_count(self) -> _builtins.int:
        """
        The maximum number of workers in use in an Elastic SKU Plan.
        """
        return pulumi.get(self, "maximum_elastic_worker_count")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> _builtins.str:
        """
        The O/S type for the App Services hosted in this plan.
        """
        return pulumi.get(self, "os_type")

    @_builtins.property
    @pulumi.getter(name="perSiteScalingEnabled")
    def per_site_scaling_enabled(self) -> _builtins.bool:
        """
        Is Per Site Scaling be enabled?
        """
        return pulumi.get(self, "per_site_scaling_enabled")

    @_builtins.property
    @pulumi.getter
    def reserved(self) -> _builtins.bool:
        """
        Whether this is a reserved Service Plan Type. `true` if `os_type` is `Linux`, otherwise `false`.
        """
        return pulumi.get(self, "reserved")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> _builtins.str:
        """
        The SKU for the Service Plan.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the Service Plan.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="workerCount")
    def worker_count(self) -> _builtins.int:
        """
        The number of Workers (instances) allocated.
        """
        return pulumi.get(self, "worker_count")

    @_builtins.property
    @pulumi.getter(name="zoneBalancingEnabled")
    def zone_balancing_enabled(self) -> _builtins.bool:
        """
        Is the Service Plan balance across Availability Zones in the region?
        """
        return pulumi.get(self, "zone_balancing_enabled")


class AwaitableGetServicePlanResult(GetServicePlanResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServicePlanResult(
            app_service_environment_id=self.app_service_environment_id,
            id=self.id,
            kind=self.kind,
            location=self.location,
            maximum_elastic_worker_count=self.maximum_elastic_worker_count,
            name=self.name,
            os_type=self.os_type,
            per_site_scaling_enabled=self.per_site_scaling_enabled,
            reserved=self.reserved,
            resource_group_name=self.resource_group_name,
            sku_name=self.sku_name,
            tags=self.tags,
            worker_count=self.worker_count,
            zone_balancing_enabled=self.zone_balancing_enabled)


def get_service_plan(name: Optional[_builtins.str] = None,
                     resource_group_name: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServicePlanResult:
    """
    Use this data source to access information about an existing Service Plan.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.appservice.get_service_plan(name="existing",
        resource_group_name="existing")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Web` - 2023-12-01


    :param _builtins.str name: The name of this Service Plan.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Service Plan exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:appservice/getServicePlan:getServicePlan', __args__, opts=opts, typ=GetServicePlanResult).value

    return AwaitableGetServicePlanResult(
        app_service_environment_id=pulumi.get(__ret__, 'app_service_environment_id'),
        id=pulumi.get(__ret__, 'id'),
        kind=pulumi.get(__ret__, 'kind'),
        location=pulumi.get(__ret__, 'location'),
        maximum_elastic_worker_count=pulumi.get(__ret__, 'maximum_elastic_worker_count'),
        name=pulumi.get(__ret__, 'name'),
        os_type=pulumi.get(__ret__, 'os_type'),
        per_site_scaling_enabled=pulumi.get(__ret__, 'per_site_scaling_enabled'),
        reserved=pulumi.get(__ret__, 'reserved'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        sku_name=pulumi.get(__ret__, 'sku_name'),
        tags=pulumi.get(__ret__, 'tags'),
        worker_count=pulumi.get(__ret__, 'worker_count'),
        zone_balancing_enabled=pulumi.get(__ret__, 'zone_balancing_enabled'))
def get_service_plan_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServicePlanResult]:
    """
    Use this data source to access information about an existing Service Plan.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.appservice.get_service_plan(name="existing",
        resource_group_name="existing")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Web` - 2023-12-01


    :param _builtins.str name: The name of this Service Plan.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Service Plan exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:appservice/getServicePlan:getServicePlan', __args__, opts=opts, typ=GetServicePlanResult)
    return __ret__.apply(lambda __response__: GetServicePlanResult(
        app_service_environment_id=pulumi.get(__response__, 'app_service_environment_id'),
        id=pulumi.get(__response__, 'id'),
        kind=pulumi.get(__response__, 'kind'),
        location=pulumi.get(__response__, 'location'),
        maximum_elastic_worker_count=pulumi.get(__response__, 'maximum_elastic_worker_count'),
        name=pulumi.get(__response__, 'name'),
        os_type=pulumi.get(__response__, 'os_type'),
        per_site_scaling_enabled=pulumi.get(__response__, 'per_site_scaling_enabled'),
        reserved=pulumi.get(__response__, 'reserved'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        sku_name=pulumi.get(__response__, 'sku_name'),
        tags=pulumi.get(__response__, 'tags'),
        worker_count=pulumi.get(__response__, 'worker_count'),
        zone_balancing_enabled=pulumi.get(__response__, 'zone_balancing_enabled')))
