# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ResourceBridgeApplianceArgs', 'ResourceBridgeAppliance']

@pulumi.input_type
class ResourceBridgeApplianceArgs:
    def __init__(__self__, *,
                 distro: pulumi.Input[_builtins.str],
                 identity: pulumi.Input['ResourceBridgeApplianceIdentityArgs'],
                 infrastructure_provider: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ResourceBridgeAppliance resource.
        :param pulumi.Input[_builtins.str] distro: Specifies a supported Fabric/Infrastructure for this Arc Resource Bridge Appliance. The possible value is `AKSEdge`.
        :param pulumi.Input['ResourceBridgeApplianceIdentityArgs'] identity: An `identity` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] infrastructure_provider: The infrastructure provider about the connected Arc Resource Bridge Appliance. Possible values are `HCI`,`SCVMM` and `VMWare`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the resource group where the Arc Resource Bridge Appliance exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Arc Resource Bridge Appliance should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The Name which should be used for this Arc Resource Bridge Appliance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] public_key_base64: The `public_key_base64` is an RSA public key in PKCS1 format encoded in base64. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Arc Resource Bridge Appliance.
        """
        pulumi.set(__self__, "distro", distro)
        pulumi.set(__self__, "identity", identity)
        pulumi.set(__self__, "infrastructure_provider", infrastructure_provider)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_key_base64 is not None:
            pulumi.set(__self__, "public_key_base64", public_key_base64)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def distro(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies a supported Fabric/Infrastructure for this Arc Resource Bridge Appliance. The possible value is `AKSEdge`.
        """
        return pulumi.get(self, "distro")

    @distro.setter
    def distro(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "distro", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Input['ResourceBridgeApplianceIdentityArgs']:
        """
        An `identity` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: pulumi.Input['ResourceBridgeApplianceIdentityArgs']):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="infrastructureProvider")
    def infrastructure_provider(self) -> pulumi.Input[_builtins.str]:
        """
        The infrastructure provider about the connected Arc Resource Bridge Appliance. Possible values are `HCI`,`SCVMM` and `VMWare`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "infrastructure_provider")

    @infrastructure_provider.setter
    def infrastructure_provider(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "infrastructure_provider", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the resource group where the Arc Resource Bridge Appliance exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Arc Resource Bridge Appliance should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name which should be used for this Arc Resource Bridge Appliance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicKeyBase64")
    def public_key_base64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `public_key_base64` is an RSA public key in PKCS1 format encoded in base64. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "public_key_base64")

    @public_key_base64.setter
    def public_key_base64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_key_base64", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Arc Resource Bridge Appliance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ResourceBridgeApplianceState:
    def __init__(__self__, *,
                 distro: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['ResourceBridgeApplianceIdentityArgs']] = None,
                 infrastructure_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ResourceBridgeAppliance resources.
        :param pulumi.Input[_builtins.str] distro: Specifies a supported Fabric/Infrastructure for this Arc Resource Bridge Appliance. The possible value is `AKSEdge`.
        :param pulumi.Input['ResourceBridgeApplianceIdentityArgs'] identity: An `identity` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] infrastructure_provider: The infrastructure provider about the connected Arc Resource Bridge Appliance. Possible values are `HCI`,`SCVMM` and `VMWare`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Arc Resource Bridge Appliance should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The Name which should be used for this Arc Resource Bridge Appliance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] public_key_base64: The `public_key_base64` is an RSA public key in PKCS1 format encoded in base64. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the resource group where the Arc Resource Bridge Appliance exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Arc Resource Bridge Appliance.
        """
        if distro is not None:
            pulumi.set(__self__, "distro", distro)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if infrastructure_provider is not None:
            pulumi.set(__self__, "infrastructure_provider", infrastructure_provider)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_key_base64 is not None:
            pulumi.set(__self__, "public_key_base64", public_key_base64)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def distro(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a supported Fabric/Infrastructure for this Arc Resource Bridge Appliance. The possible value is `AKSEdge`.
        """
        return pulumi.get(self, "distro")

    @distro.setter
    def distro(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "distro", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ResourceBridgeApplianceIdentityArgs']]:
        """
        An `identity` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ResourceBridgeApplianceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="infrastructureProvider")
    def infrastructure_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The infrastructure provider about the connected Arc Resource Bridge Appliance. Possible values are `HCI`,`SCVMM` and `VMWare`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "infrastructure_provider")

    @infrastructure_provider.setter
    def infrastructure_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "infrastructure_provider", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Arc Resource Bridge Appliance should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name which should be used for this Arc Resource Bridge Appliance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicKeyBase64")
    def public_key_base64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `public_key_base64` is an RSA public key in PKCS1 format encoded in base64. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "public_key_base64")

    @public_key_base64.setter
    def public_key_base64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_key_base64", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the resource group where the Arc Resource Bridge Appliance exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Arc Resource Bridge Appliance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:arc/resourceBridgeAppliance:ResourceBridgeAppliance")
class ResourceBridgeAppliance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 distro: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ResourceBridgeApplianceIdentityArgs', 'ResourceBridgeApplianceIdentityArgsDict']]] = None,
                 infrastructure_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Arc Resource Bridge Appliance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_resource_bridge_appliance = azure.arc.ResourceBridgeAppliance("example",
            name="example-appliance",
            location=example.location,
            resource_group_name=example.name,
            distro="AKSEdge",
            infrastructure_provider="VMWare",
            identity={
                "type": "SystemAssigned",
            },
            tags={
                "hello": "world",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ResourceConnector` - 2022-10-27

        ## Import

        Arc Resource Bridge Appliance can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:arc/resourceBridgeAppliance:ResourceBridgeAppliance example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ResourceConnector/appliances/appliancesExample
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] distro: Specifies a supported Fabric/Infrastructure for this Arc Resource Bridge Appliance. The possible value is `AKSEdge`.
        :param pulumi.Input[Union['ResourceBridgeApplianceIdentityArgs', 'ResourceBridgeApplianceIdentityArgsDict']] identity: An `identity` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] infrastructure_provider: The infrastructure provider about the connected Arc Resource Bridge Appliance. Possible values are `HCI`,`SCVMM` and `VMWare`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Arc Resource Bridge Appliance should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The Name which should be used for this Arc Resource Bridge Appliance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] public_key_base64: The `public_key_base64` is an RSA public key in PKCS1 format encoded in base64. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the resource group where the Arc Resource Bridge Appliance exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Arc Resource Bridge Appliance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResourceBridgeApplianceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Arc Resource Bridge Appliance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_resource_bridge_appliance = azure.arc.ResourceBridgeAppliance("example",
            name="example-appliance",
            location=example.location,
            resource_group_name=example.name,
            distro="AKSEdge",
            infrastructure_provider="VMWare",
            identity={
                "type": "SystemAssigned",
            },
            tags={
                "hello": "world",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ResourceConnector` - 2022-10-27

        ## Import

        Arc Resource Bridge Appliance can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:arc/resourceBridgeAppliance:ResourceBridgeAppliance example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ResourceConnector/appliances/appliancesExample
        ```

        :param str resource_name: The name of the resource.
        :param ResourceBridgeApplianceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourceBridgeApplianceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 distro: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ResourceBridgeApplianceIdentityArgs', 'ResourceBridgeApplianceIdentityArgsDict']]] = None,
                 infrastructure_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key_base64: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourceBridgeApplianceArgs.__new__(ResourceBridgeApplianceArgs)

            if distro is None and not opts.urn:
                raise TypeError("Missing required property 'distro'")
            __props__.__dict__["distro"] = distro
            if identity is None and not opts.urn:
                raise TypeError("Missing required property 'identity'")
            __props__.__dict__["identity"] = identity
            if infrastructure_provider is None and not opts.urn:
                raise TypeError("Missing required property 'infrastructure_provider'")
            __props__.__dict__["infrastructure_provider"] = infrastructure_provider
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["public_key_base64"] = public_key_base64
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
        super(ResourceBridgeAppliance, __self__).__init__(
            'azure:arc/resourceBridgeAppliance:ResourceBridgeAppliance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            distro: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['ResourceBridgeApplianceIdentityArgs', 'ResourceBridgeApplianceIdentityArgsDict']]] = None,
            infrastructure_provider: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            public_key_base64: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'ResourceBridgeAppliance':
        """
        Get an existing ResourceBridgeAppliance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] distro: Specifies a supported Fabric/Infrastructure for this Arc Resource Bridge Appliance. The possible value is `AKSEdge`.
        :param pulumi.Input[Union['ResourceBridgeApplianceIdentityArgs', 'ResourceBridgeApplianceIdentityArgsDict']] identity: An `identity` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] infrastructure_provider: The infrastructure provider about the connected Arc Resource Bridge Appliance. Possible values are `HCI`,`SCVMM` and `VMWare`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Arc Resource Bridge Appliance should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The Name which should be used for this Arc Resource Bridge Appliance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] public_key_base64: The `public_key_base64` is an RSA public key in PKCS1 format encoded in base64. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the resource group where the Arc Resource Bridge Appliance exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Arc Resource Bridge Appliance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResourceBridgeApplianceState.__new__(_ResourceBridgeApplianceState)

        __props__.__dict__["distro"] = distro
        __props__.__dict__["identity"] = identity
        __props__.__dict__["infrastructure_provider"] = infrastructure_provider
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["public_key_base64"] = public_key_base64
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        return ResourceBridgeAppliance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def distro(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies a supported Fabric/Infrastructure for this Arc Resource Bridge Appliance. The possible value is `AKSEdge`.
        """
        return pulumi.get(self, "distro")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output['outputs.ResourceBridgeApplianceIdentity']:
        """
        An `identity` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="infrastructureProvider")
    def infrastructure_provider(self) -> pulumi.Output[_builtins.str]:
        """
        The infrastructure provider about the connected Arc Resource Bridge Appliance. Possible values are `HCI`,`SCVMM` and `VMWare`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "infrastructure_provider")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Arc Resource Bridge Appliance should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The Name which should be used for this Arc Resource Bridge Appliance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicKeyBase64")
    def public_key_base64(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The `public_key_base64` is an RSA public key in PKCS1 format encoded in base64. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "public_key_base64")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the resource group where the Arc Resource Bridge Appliance exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Arc Resource Bridge Appliance.
        """
        return pulumi.get(self, "tags")

