# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ArcMachineIdentity',
    'GetAgentResult',
    'GetAgentExtensionsAllowListResult',
    'GetAgentExtensionsBlockListResult',
    'GetCloudMetadataResult',
    'GetIdentityResult',
    'GetLocationDataResult',
    'GetOsProfileResult',
    'GetOsProfileLinuxResult',
    'GetOsProfileLinuxPatchResult',
    'GetOsProfileWindowResult',
    'GetOsProfileWindowPatchResult',
    'GetServiceStatusResult',
    'GetServiceStatusExtensionServiceResult',
    'GetServiceStatusGuestConfigurationServiceResult',
]

@pulumi.output_type
class ArcMachineIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ArcMachineIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ArcMachineIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ArcMachineIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity assigned to this Arc Machine. At this time the only possible value is `SystemAssigned`. Changing this forces a new resource to be created.
        :param _builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param _builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity assigned to this Arc Machine. At this time the only possible value is `SystemAssigned`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class GetAgentResult(dict):
    def __init__(__self__, *,
                 extensions_allow_lists: Sequence['outputs.GetAgentExtensionsAllowListResult'],
                 extensions_block_lists: Sequence['outputs.GetAgentExtensionsBlockListResult'],
                 extensions_enabled: _builtins.bool,
                 guest_configuration_enabled: _builtins.bool,
                 incoming_connections_ports: Sequence[_builtins.str],
                 proxy_bypasses: Sequence[_builtins.str],
                 proxy_url: _builtins.str):
        """
        :param Sequence['GetAgentExtensionsAllowListArgs'] extensions_allow_lists: A `extensions_allow_list` block as defined below.
        :param Sequence['GetAgentExtensionsBlockListArgs'] extensions_block_lists: A `extensions_block_list` block as defined below.
        :param _builtins.bool extensions_enabled: Specifies whether the extension service is enabled or disabled.
        :param _builtins.bool guest_configuration_enabled: Specified whether the guest configuration service is enabled or disabled.
        :param Sequence[_builtins.str] incoming_connections_ports: Specifies the list of ports that the agent will be able to listen on.
        :param Sequence[_builtins.str] proxy_bypasses: List of service names which should not use the specified proxy server.
        :param _builtins.str proxy_url: Specifies the URL of the proxy to be used.
        """
        pulumi.set(__self__, "extensions_allow_lists", extensions_allow_lists)
        pulumi.set(__self__, "extensions_block_lists", extensions_block_lists)
        pulumi.set(__self__, "extensions_enabled", extensions_enabled)
        pulumi.set(__self__, "guest_configuration_enabled", guest_configuration_enabled)
        pulumi.set(__self__, "incoming_connections_ports", incoming_connections_ports)
        pulumi.set(__self__, "proxy_bypasses", proxy_bypasses)
        pulumi.set(__self__, "proxy_url", proxy_url)

    @_builtins.property
    @pulumi.getter(name="extensionsAllowLists")
    def extensions_allow_lists(self) -> Sequence['outputs.GetAgentExtensionsAllowListResult']:
        """
        A `extensions_allow_list` block as defined below.
        """
        return pulumi.get(self, "extensions_allow_lists")

    @_builtins.property
    @pulumi.getter(name="extensionsBlockLists")
    def extensions_block_lists(self) -> Sequence['outputs.GetAgentExtensionsBlockListResult']:
        """
        A `extensions_block_list` block as defined below.
        """
        return pulumi.get(self, "extensions_block_lists")

    @_builtins.property
    @pulumi.getter(name="extensionsEnabled")
    def extensions_enabled(self) -> _builtins.bool:
        """
        Specifies whether the extension service is enabled or disabled.
        """
        return pulumi.get(self, "extensions_enabled")

    @_builtins.property
    @pulumi.getter(name="guestConfigurationEnabled")
    def guest_configuration_enabled(self) -> _builtins.bool:
        """
        Specified whether the guest configuration service is enabled or disabled.
        """
        return pulumi.get(self, "guest_configuration_enabled")

    @_builtins.property
    @pulumi.getter(name="incomingConnectionsPorts")
    def incoming_connections_ports(self) -> Sequence[_builtins.str]:
        """
        Specifies the list of ports that the agent will be able to listen on.
        """
        return pulumi.get(self, "incoming_connections_ports")

    @_builtins.property
    @pulumi.getter(name="proxyBypasses")
    def proxy_bypasses(self) -> Sequence[_builtins.str]:
        """
        List of service names which should not use the specified proxy server.
        """
        return pulumi.get(self, "proxy_bypasses")

    @_builtins.property
    @pulumi.getter(name="proxyUrl")
    def proxy_url(self) -> _builtins.str:
        """
        Specifies the URL of the proxy to be used.
        """
        return pulumi.get(self, "proxy_url")


@pulumi.output_type
class GetAgentExtensionsAllowListResult(dict):
    def __init__(__self__, *,
                 publisher: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str publisher: Publisher of the extension.
        :param _builtins.str type: The identity type.
        """
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        Publisher of the extension.
        """
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The identity type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAgentExtensionsBlockListResult(dict):
    def __init__(__self__, *,
                 publisher: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str publisher: Publisher of the extension.
        :param _builtins.str type: The identity type.
        """
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        Publisher of the extension.
        """
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The identity type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetCloudMetadataResult(dict):
    def __init__(__self__, *,
                 provider: _builtins.str):
        """
        :param _builtins.str provider: Specifies the cloud provider. For example `Azure`, `AWS` and `GCP`.
        """
        pulumi.set(__self__, "provider", provider)

    @_builtins.property
    @pulumi.getter
    def provider(self) -> _builtins.str:
        """
        Specifies the cloud provider. For example `Azure`, `AWS` and `GCP`.
        """
        return pulumi.get(self, "provider")


@pulumi.output_type
class GetIdentityResult(dict):
    def __init__(__self__, *,
                 principal_id: _builtins.str,
                 tenant_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str principal_id: The principal ID of resource identity.
        :param _builtins.str tenant_id: The tenant ID of resource.
        :param _builtins.str type: The identity type.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        The principal ID of resource identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The tenant ID of resource.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The identity type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetLocationDataResult(dict):
    def __init__(__self__, *,
                 city: _builtins.str,
                 country_or_region: _builtins.str,
                 district: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str city: The city or locality where the resource is located.
        :param _builtins.str country_or_region: The country or region where the resource is located.
        :param _builtins.str district: The district, state, or province where the resource is located.
        :param _builtins.str name: The name of this Azure Arc machine.
        """
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "country_or_region", country_or_region)
        pulumi.set(__self__, "district", district)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def city(self) -> _builtins.str:
        """
        The city or locality where the resource is located.
        """
        return pulumi.get(self, "city")

    @_builtins.property
    @pulumi.getter(name="countryOrRegion")
    def country_or_region(self) -> _builtins.str:
        """
        The country or region where the resource is located.
        """
        return pulumi.get(self, "country_or_region")

    @_builtins.property
    @pulumi.getter
    def district(self) -> _builtins.str:
        """
        The district, state, or province where the resource is located.
        """
        return pulumi.get(self, "district")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of this Azure Arc machine.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetOsProfileResult(dict):
    def __init__(__self__, *,
                 computer_name: _builtins.str,
                 linuxes: Sequence['outputs.GetOsProfileLinuxResult'],
                 windows: Sequence['outputs.GetOsProfileWindowResult']):
        """
        :param _builtins.str computer_name: Specifies the host OS name of the Azure Arc machine.
        :param Sequence['GetOsProfileLinuxArgs'] linuxes: A `linux` block as defined above.
        :param Sequence['GetOsProfileWindowArgs'] windows: A `windows` block as defined below.
        """
        pulumi.set(__self__, "computer_name", computer_name)
        pulumi.set(__self__, "linuxes", linuxes)
        pulumi.set(__self__, "windows", windows)

    @_builtins.property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> _builtins.str:
        """
        Specifies the host OS name of the Azure Arc machine.
        """
        return pulumi.get(self, "computer_name")

    @_builtins.property
    @pulumi.getter
    def linuxes(self) -> Sequence['outputs.GetOsProfileLinuxResult']:
        """
        A `linux` block as defined above.
        """
        return pulumi.get(self, "linuxes")

    @_builtins.property
    @pulumi.getter
    def windows(self) -> Sequence['outputs.GetOsProfileWindowResult']:
        """
        A `windows` block as defined below.
        """
        return pulumi.get(self, "windows")


@pulumi.output_type
class GetOsProfileLinuxResult(dict):
    def __init__(__self__, *,
                 patches: Sequence['outputs.GetOsProfileLinuxPatchResult']):
        """
        :param Sequence['GetOsProfileLinuxPatchArgs'] patches: A `patch` block as defined above.
        """
        pulumi.set(__self__, "patches", patches)

    @_builtins.property
    @pulumi.getter
    def patches(self) -> Sequence['outputs.GetOsProfileLinuxPatchResult']:
        """
        A `patch` block as defined above.
        """
        return pulumi.get(self, "patches")


@pulumi.output_type
class GetOsProfileLinuxPatchResult(dict):
    def __init__(__self__, *,
                 assessment_mode: _builtins.str,
                 patch_mode: _builtins.str):
        """
        :param _builtins.str assessment_mode: Specifies the assessment mode.
        :param _builtins.str patch_mode: Specifies the patch mode.
        """
        pulumi.set(__self__, "assessment_mode", assessment_mode)
        pulumi.set(__self__, "patch_mode", patch_mode)

    @_builtins.property
    @pulumi.getter(name="assessmentMode")
    def assessment_mode(self) -> _builtins.str:
        """
        Specifies the assessment mode.
        """
        return pulumi.get(self, "assessment_mode")

    @_builtins.property
    @pulumi.getter(name="patchMode")
    def patch_mode(self) -> _builtins.str:
        """
        Specifies the patch mode.
        """
        return pulumi.get(self, "patch_mode")


@pulumi.output_type
class GetOsProfileWindowResult(dict):
    def __init__(__self__, *,
                 patches: Sequence['outputs.GetOsProfileWindowPatchResult']):
        """
        :param Sequence['GetOsProfileWindowPatchArgs'] patches: A `patch` block as defined above.
        """
        pulumi.set(__self__, "patches", patches)

    @_builtins.property
    @pulumi.getter
    def patches(self) -> Sequence['outputs.GetOsProfileWindowPatchResult']:
        """
        A `patch` block as defined above.
        """
        return pulumi.get(self, "patches")


@pulumi.output_type
class GetOsProfileWindowPatchResult(dict):
    def __init__(__self__, *,
                 assessment_mode: _builtins.str,
                 patch_mode: _builtins.str):
        """
        :param _builtins.str assessment_mode: Specifies the assessment mode.
        :param _builtins.str patch_mode: Specifies the patch mode.
        """
        pulumi.set(__self__, "assessment_mode", assessment_mode)
        pulumi.set(__self__, "patch_mode", patch_mode)

    @_builtins.property
    @pulumi.getter(name="assessmentMode")
    def assessment_mode(self) -> _builtins.str:
        """
        Specifies the assessment mode.
        """
        return pulumi.get(self, "assessment_mode")

    @_builtins.property
    @pulumi.getter(name="patchMode")
    def patch_mode(self) -> _builtins.str:
        """
        Specifies the patch mode.
        """
        return pulumi.get(self, "patch_mode")


@pulumi.output_type
class GetServiceStatusResult(dict):
    def __init__(__self__, *,
                 extension_services: Sequence['outputs.GetServiceStatusExtensionServiceResult'],
                 guest_configuration_services: Sequence['outputs.GetServiceStatusGuestConfigurationServiceResult']):
        """
        :param Sequence['GetServiceStatusExtensionServiceArgs'] extension_services: A `extension_service` block as defined above.
        :param Sequence['GetServiceStatusGuestConfigurationServiceArgs'] guest_configuration_services: A `guest_configuration_service` block as defined above.
        """
        pulumi.set(__self__, "extension_services", extension_services)
        pulumi.set(__self__, "guest_configuration_services", guest_configuration_services)

    @_builtins.property
    @pulumi.getter(name="extensionServices")
    def extension_services(self) -> Sequence['outputs.GetServiceStatusExtensionServiceResult']:
        """
        A `extension_service` block as defined above.
        """
        return pulumi.get(self, "extension_services")

    @_builtins.property
    @pulumi.getter(name="guestConfigurationServices")
    def guest_configuration_services(self) -> Sequence['outputs.GetServiceStatusGuestConfigurationServiceResult']:
        """
        A `guest_configuration_service` block as defined above.
        """
        return pulumi.get(self, "guest_configuration_services")


@pulumi.output_type
class GetServiceStatusExtensionServiceResult(dict):
    def __init__(__self__, *,
                 startup_type: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str startup_type: The behavior of the service when the Arc-enabled machine starts up.
        :param _builtins.str status: The current status of the service.
        """
        pulumi.set(__self__, "startup_type", startup_type)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="startupType")
    def startup_type(self) -> _builtins.str:
        """
        The behavior of the service when the Arc-enabled machine starts up.
        """
        return pulumi.get(self, "startup_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The current status of the service.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetServiceStatusGuestConfigurationServiceResult(dict):
    def __init__(__self__, *,
                 startup_type: _builtins.str,
                 status: _builtins.str):
        """
        :param _builtins.str startup_type: The behavior of the service when the Arc-enabled machine starts up.
        :param _builtins.str status: The current status of the service.
        """
        pulumi.set(__self__, "startup_type", startup_type)
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="startupType")
    def startup_type(self) -> _builtins.str:
        """
        The behavior of the service when the Arc-enabled machine starts up.
        """
        return pulumi.get(self, "startup_type")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The current status of the service.
        """
        return pulumi.get(self, "status")


