# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AccountEncryption',
    'AccountIdentity',
    'AccountPrivateEndpointConnection',
    'ConnectionTypeField',
    'ModuleModuleLink',
    'ModuleModuleLinkHash',
    'Powershell72ModuleModuleLink',
    'Powershell72ModuleModuleLinkHash',
    'RunBookDraft',
    'RunBookDraftContentLink',
    'RunBookDraftContentLinkHash',
    'RunBookDraftParameter',
    'RunBookJobSchedule',
    'RunBookPublishContentLink',
    'RunBookPublishContentLinkHash',
    'ScheduleMonthlyOccurrence',
    'SoftwareUpdateConfigurationLinux',
    'SoftwareUpdateConfigurationPostTask',
    'SoftwareUpdateConfigurationPreTask',
    'SoftwareUpdateConfigurationSchedule',
    'SoftwareUpdateConfigurationScheduleMonthlyOccurrence',
    'SoftwareUpdateConfigurationTarget',
    'SoftwareUpdateConfigurationTargetAzureQuery',
    'SoftwareUpdateConfigurationTargetAzureQueryTag',
    'SoftwareUpdateConfigurationTargetNonAzureQuery',
    'SoftwareUpdateConfigurationWindows',
    'SourceControlSecurity',
    'GetAccountIdentityResult',
    'GetAccountPrivateEndpointConnectionResult',
    'GetVariablesBoolResult',
    'GetVariablesDatetimeResult',
    'GetVariablesEncryptedResult',
    'GetVariablesIntResult',
    'GetVariablesNullResult',
    'GetVariablesObjectResult',
    'GetVariablesStringResult',
]

@pulumi.output_type
class AccountEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultKeyId":
            suggest = "key_vault_key_id"
        elif key == "keySource":
            suggest = "key_source"
        elif key == "userAssignedIdentityId":
            suggest = "user_assigned_identity_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_vault_key_id: _builtins.str,
                 key_source: Optional[_builtins.str] = None,
                 user_assigned_identity_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str key_vault_key_id: The ID of the Key Vault Key which should be used to Encrypt the data in this Automation Account.
        :param _builtins.str user_assigned_identity_id: The User Assigned Managed Identity ID to be used for accessing the Customer Managed Key for encryption.
        """
        pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if key_source is not None:
            pulumi.set(__self__, "key_source", key_source)
        if user_assigned_identity_id is not None:
            pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> _builtins.str:
        """
        The ID of the Key Vault Key which should be used to Encrypt the data in this Automation Account.
        """
        return pulumi.get(self, "key_vault_key_id")

    @_builtins.property
    @pulumi.getter(name="keySource")
    @_utilities.deprecated("""`encryption.key_source` has been deprecated and will be removed in v5.0 of the AzureRM Provider. To disable encryption, omit the `encryption` block""")
    def key_source(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "key_source")

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> Optional[_builtins.str]:
        """
        The User Assigned Managed Identity ID to be used for accessing the Customer Managed Key for encryption.
        """
        return pulumi.get(self, "user_assigned_identity_id")


@pulumi.output_type
class AccountIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The type of identity used for this Automation Account. Possible values are `SystemAssigned`, `UserAssigned` and `SystemAssigned, UserAssigned`.
        :param Sequence[_builtins.str] identity_ids: The ID of the User Assigned Identity which should be assigned to this Automation Account.
               
               > **Note:** `identity_ids` is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param _builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param _builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of identity used for this Automation Account. Possible values are `SystemAssigned`, `UserAssigned` and `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        The ID of the User Assigned Identity which should be assigned to this Automation Account.

        > **Note:** `identity_ids` is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class AccountPrivateEndpointConnection(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The ID of the Automation Account.
        :param _builtins.str name: Specifies the name of the Automation Account. Changing this forces a new resource to be created.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the Automation Account.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the Automation Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ConnectionTypeField(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEncrypted":
            suggest = "is_encrypted"
        elif key == "isOptional":
            suggest = "is_optional"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionTypeField. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionTypeField.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionTypeField.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str,
                 is_encrypted: Optional[_builtins.bool] = None,
                 is_optional: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The name which should be used for this connection field definition.
        :param _builtins.str type: The type of the connection field definition.
        :param _builtins.bool is_encrypted: Whether to set the isEncrypted flag of the connection field definition.
        :param _builtins.bool is_optional: Whether to set the isOptional flag of the connection field definition.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if is_encrypted is not None:
            pulumi.set(__self__, "is_encrypted", is_encrypted)
        if is_optional is not None:
            pulumi.set(__self__, "is_optional", is_optional)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name which should be used for this connection field definition.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the connection field definition.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="isEncrypted")
    def is_encrypted(self) -> Optional[_builtins.bool]:
        """
        Whether to set the isEncrypted flag of the connection field definition.
        """
        return pulumi.get(self, "is_encrypted")

    @_builtins.property
    @pulumi.getter(name="isOptional")
    def is_optional(self) -> Optional[_builtins.bool]:
        """
        Whether to set the isOptional flag of the connection field definition.
        """
        return pulumi.get(self, "is_optional")


@pulumi.output_type
class ModuleModuleLink(dict):
    def __init__(__self__, *,
                 uri: _builtins.str,
                 hash: Optional['outputs.ModuleModuleLinkHash'] = None):
        """
        :param _builtins.str uri: The URI of the module content (zip or nupkg).
        :param 'ModuleModuleLinkHashArgs' hash: A `hash` block as defined below.
        """
        pulumi.set(__self__, "uri", uri)
        if hash is not None:
            pulumi.set(__self__, "hash", hash)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        The URI of the module content (zip or nupkg).
        """
        return pulumi.get(self, "uri")

    @_builtins.property
    @pulumi.getter
    def hash(self) -> Optional['outputs.ModuleModuleLinkHash']:
        """
        A `hash` block as defined below.
        """
        return pulumi.get(self, "hash")


@pulumi.output_type
class ModuleModuleLinkHash(dict):
    def __init__(__self__, *,
                 algorithm: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str algorithm: Specifies the algorithm used for the hash content.
        :param _builtins.str value: The hash value of the content.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> _builtins.str:
        """
        Specifies the algorithm used for the hash content.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The hash value of the content.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class Powershell72ModuleModuleLink(dict):
    def __init__(__self__, *,
                 uri: _builtins.str,
                 hash: Optional['outputs.Powershell72ModuleModuleLinkHash'] = None):
        """
        :param _builtins.str uri: The URI of the module content (zip or nupkg).
        :param 'Powershell72ModuleModuleLinkHashArgs' hash: A `hash` block as defined below.
        """
        pulumi.set(__self__, "uri", uri)
        if hash is not None:
            pulumi.set(__self__, "hash", hash)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        The URI of the module content (zip or nupkg).
        """
        return pulumi.get(self, "uri")

    @_builtins.property
    @pulumi.getter
    def hash(self) -> Optional['outputs.Powershell72ModuleModuleLinkHash']:
        """
        A `hash` block as defined below.
        """
        return pulumi.get(self, "hash")


@pulumi.output_type
class Powershell72ModuleModuleLinkHash(dict):
    def __init__(__self__, *,
                 algorithm: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str algorithm: Specifies the algorithm used for the hash content.
        :param _builtins.str value: The hash value of the content.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> _builtins.str:
        """
        Specifies the algorithm used for the hash content.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The hash value of the content.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RunBookDraft(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentLink":
            suggest = "content_link"
        elif key == "creationTime":
            suggest = "creation_time"
        elif key == "editModeEnabled":
            suggest = "edit_mode_enabled"
        elif key == "lastModifiedTime":
            suggest = "last_modified_time"
        elif key == "outputTypes":
            suggest = "output_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RunBookDraft. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RunBookDraft.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RunBookDraft.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_link: Optional['outputs.RunBookDraftContentLink'] = None,
                 creation_time: Optional[_builtins.str] = None,
                 edit_mode_enabled: Optional[_builtins.bool] = None,
                 last_modified_time: Optional[_builtins.str] = None,
                 output_types: Optional[Sequence[_builtins.str]] = None,
                 parameters: Optional[Sequence['outputs.RunBookDraftParameter']] = None):
        """
        :param 'RunBookDraftContentLinkArgs' content_link: A `publish_content_link` block as defined above.
        :param _builtins.bool edit_mode_enabled: Whether the draft in edit mode.
        :param Sequence[_builtins.str] output_types: Specifies the output types of the runbook.
        :param Sequence['RunBookDraftParameterArgs'] parameters: A list of `parameters` block as defined below.
        """
        if content_link is not None:
            pulumi.set(__self__, "content_link", content_link)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if edit_mode_enabled is not None:
            pulumi.set(__self__, "edit_mode_enabled", edit_mode_enabled)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if output_types is not None:
            pulumi.set(__self__, "output_types", output_types)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @_builtins.property
    @pulumi.getter(name="contentLink")
    def content_link(self) -> Optional['outputs.RunBookDraftContentLink']:
        """
        A `publish_content_link` block as defined above.
        """
        return pulumi.get(self, "content_link")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter(name="editModeEnabled")
    def edit_mode_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether the draft in edit mode.
        """
        return pulumi.get(self, "edit_mode_enabled")

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "last_modified_time")

    @_builtins.property
    @pulumi.getter(name="outputTypes")
    def output_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the output types of the runbook.
        """
        return pulumi.get(self, "output_types")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[Sequence['outputs.RunBookDraftParameter']]:
        """
        A list of `parameters` block as defined below.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class RunBookDraftContentLink(dict):
    def __init__(__self__, *,
                 uri: _builtins.str,
                 hash: Optional['outputs.RunBookDraftContentLinkHash'] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str uri: The URI of the runbook content.
        :param 'RunBookDraftContentLinkHashArgs' hash: A `hash` block as defined below.
        :param _builtins.str version: Specifies the version of the content
        """
        pulumi.set(__self__, "uri", uri)
        if hash is not None:
            pulumi.set(__self__, "hash", hash)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        The URI of the runbook content.
        """
        return pulumi.get(self, "uri")

    @_builtins.property
    @pulumi.getter
    def hash(self) -> Optional['outputs.RunBookDraftContentLinkHash']:
        """
        A `hash` block as defined below.
        """
        return pulumi.get(self, "hash")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        Specifies the version of the content
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class RunBookDraftContentLinkHash(dict):
    def __init__(__self__, *,
                 algorithm: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str algorithm: Specifies the hash algorithm used to hash the content.
        :param _builtins.str value: Specifies the expected hash value of the content.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> _builtins.str:
        """
        Specifies the hash algorithm used to hash the content.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Specifies the expected hash value of the content.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RunBookDraftParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultValue":
            suggest = "default_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RunBookDraftParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RunBookDraftParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RunBookDraftParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: _builtins.str,
                 type: _builtins.str,
                 default_value: Optional[_builtins.str] = None,
                 mandatory: Optional[_builtins.bool] = None,
                 position: Optional[_builtins.int] = None):
        """
        :param _builtins.str key: The name of the parameter.
        :param _builtins.str type: Specifies the type of this parameter.
        :param _builtins.str default_value: Specifies the default value of the parameter.
        :param _builtins.bool mandatory: Whether this parameter is mandatory.
        :param _builtins.int position: Specifies the position of the parameter.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "type", type)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if mandatory is not None:
            pulumi.set(__self__, "mandatory", mandatory)
        if position is not None:
            pulumi.set(__self__, "position", position)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The name of the parameter.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of this parameter.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[_builtins.str]:
        """
        Specifies the default value of the parameter.
        """
        return pulumi.get(self, "default_value")

    @_builtins.property
    @pulumi.getter
    def mandatory(self) -> Optional[_builtins.bool]:
        """
        Whether this parameter is mandatory.
        """
        return pulumi.get(self, "mandatory")

    @_builtins.property
    @pulumi.getter
    def position(self) -> Optional[_builtins.int]:
        """
        Specifies the position of the parameter.
        """
        return pulumi.get(self, "position")


@pulumi.output_type
class RunBookJobSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scheduleName":
            suggest = "schedule_name"
        elif key == "jobScheduleId":
            suggest = "job_schedule_id"
        elif key == "runOn":
            suggest = "run_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RunBookJobSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RunBookJobSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RunBookJobSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule_name: _builtins.str,
                 job_schedule_id: Optional[_builtins.str] = None,
                 parameters: Optional[Mapping[str, _builtins.str]] = None,
                 run_on: Optional[_builtins.str] = None):
        """
        :param _builtins.str schedule_name: The name of the Schedule.
        :param _builtins.str job_schedule_id: The UUID of automation runbook job schedule ID.
        :param Mapping[str, _builtins.str] parameters: A map of key/value pairs corresponding to the arguments that can be passed to the Runbook.
               
               > **Note:** The parameter keys/names must strictly be in lowercase, even if this is not the case in the runbook. This is due to a limitation in Azure Automation where the parameter names are normalized. The values specified don't have this limitation.
        :param _builtins.str run_on: Name of a Hybrid Worker Group the Runbook will be executed on.
        """
        pulumi.set(__self__, "schedule_name", schedule_name)
        if job_schedule_id is not None:
            pulumi.set(__self__, "job_schedule_id", job_schedule_id)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if run_on is not None:
            pulumi.set(__self__, "run_on", run_on)

    @_builtins.property
    @pulumi.getter(name="scheduleName")
    def schedule_name(self) -> _builtins.str:
        """
        The name of the Schedule.
        """
        return pulumi.get(self, "schedule_name")

    @_builtins.property
    @pulumi.getter(name="jobScheduleId")
    def job_schedule_id(self) -> Optional[_builtins.str]:
        """
        The UUID of automation runbook job schedule ID.
        """
        return pulumi.get(self, "job_schedule_id")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        A map of key/value pairs corresponding to the arguments that can be passed to the Runbook.

        > **Note:** The parameter keys/names must strictly be in lowercase, even if this is not the case in the runbook. This is due to a limitation in Azure Automation where the parameter names are normalized. The values specified don't have this limitation.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="runOn")
    def run_on(self) -> Optional[_builtins.str]:
        """
        Name of a Hybrid Worker Group the Runbook will be executed on.
        """
        return pulumi.get(self, "run_on")


@pulumi.output_type
class RunBookPublishContentLink(dict):
    def __init__(__self__, *,
                 uri: _builtins.str,
                 hash: Optional['outputs.RunBookPublishContentLinkHash'] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str uri: The URI of the runbook content.
        :param 'RunBookPublishContentLinkHashArgs' hash: A `hash` block as defined below.
        :param _builtins.str version: Specifies the version of the content
        """
        pulumi.set(__self__, "uri", uri)
        if hash is not None:
            pulumi.set(__self__, "hash", hash)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> _builtins.str:
        """
        The URI of the runbook content.
        """
        return pulumi.get(self, "uri")

    @_builtins.property
    @pulumi.getter
    def hash(self) -> Optional['outputs.RunBookPublishContentLinkHash']:
        """
        A `hash` block as defined below.
        """
        return pulumi.get(self, "hash")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        Specifies the version of the content
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class RunBookPublishContentLinkHash(dict):
    def __init__(__self__, *,
                 algorithm: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str algorithm: Specifies the hash algorithm used to hash the content.
        :param _builtins.str value: Specifies the expected hash value of the content.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def algorithm(self) -> _builtins.str:
        """
        Specifies the hash algorithm used to hash the content.
        """
        return pulumi.get(self, "algorithm")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        Specifies the expected hash value of the content.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ScheduleMonthlyOccurrence(dict):
    def __init__(__self__, *,
                 day: _builtins.str,
                 occurrence: _builtins.int):
        """
        :param _builtins.str day: Day of the occurrence. Must be one of `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, `Sunday`.
        :param _builtins.int occurrence: Occurrence of the week within the month. Must be between `1` and `5`. `-1` for last week within the month.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "occurrence", occurrence)

    @_builtins.property
    @pulumi.getter
    def day(self) -> _builtins.str:
        """
        Day of the occurrence. Must be one of `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, `Sunday`.
        """
        return pulumi.get(self, "day")

    @_builtins.property
    @pulumi.getter
    def occurrence(self) -> _builtins.int:
        """
        Occurrence of the week within the month. Must be between `1` and `5`. `-1` for last week within the month.
        """
        return pulumi.get(self, "occurrence")


@pulumi.output_type
class SoftwareUpdateConfigurationLinux(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "classificationsIncludeds":
            suggest = "classifications_includeds"
        elif key == "excludedPackages":
            suggest = "excluded_packages"
        elif key == "includedPackages":
            suggest = "included_packages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SoftwareUpdateConfigurationLinux. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SoftwareUpdateConfigurationLinux.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SoftwareUpdateConfigurationLinux.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 classifications_includeds: Sequence[_builtins.str],
                 excluded_packages: Optional[Sequence[_builtins.str]] = None,
                 included_packages: Optional[Sequence[_builtins.str]] = None,
                 reboot: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] classifications_includeds: Specifies the list of update classifications included in the Software Update Configuration. Possible values are `Unclassified`, `Critical`, `Security` and `Other`.
        :param Sequence[_builtins.str] excluded_packages: Specifies a list of packages to excluded from the Software Update Configuration.
        :param Sequence[_builtins.str] included_packages: Specifies a list of packages to included from the Software Update Configuration.
        :param _builtins.str reboot: Specifies the reboot settings after software update, possible values are `IfRequired`, `Never`, `RebootOnly` and `Always`. Defaults to `IfRequired`.
        """
        pulumi.set(__self__, "classifications_includeds", classifications_includeds)
        if excluded_packages is not None:
            pulumi.set(__self__, "excluded_packages", excluded_packages)
        if included_packages is not None:
            pulumi.set(__self__, "included_packages", included_packages)
        if reboot is not None:
            pulumi.set(__self__, "reboot", reboot)

    @_builtins.property
    @pulumi.getter(name="classificationsIncludeds")
    def classifications_includeds(self) -> Sequence[_builtins.str]:
        """
        Specifies the list of update classifications included in the Software Update Configuration. Possible values are `Unclassified`, `Critical`, `Security` and `Other`.
        """
        return pulumi.get(self, "classifications_includeds")

    @_builtins.property
    @pulumi.getter(name="excludedPackages")
    def excluded_packages(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of packages to excluded from the Software Update Configuration.
        """
        return pulumi.get(self, "excluded_packages")

    @_builtins.property
    @pulumi.getter(name="includedPackages")
    def included_packages(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of packages to included from the Software Update Configuration.
        """
        return pulumi.get(self, "included_packages")

    @_builtins.property
    @pulumi.getter
    def reboot(self) -> Optional[_builtins.str]:
        """
        Specifies the reboot settings after software update, possible values are `IfRequired`, `Never`, `RebootOnly` and `Always`. Defaults to `IfRequired`.
        """
        return pulumi.get(self, "reboot")


@pulumi.output_type
class SoftwareUpdateConfigurationPostTask(dict):
    def __init__(__self__, *,
                 parameters: Optional[Mapping[str, _builtins.str]] = None,
                 source: Optional[_builtins.str] = None):
        """
        :param Mapping[str, _builtins.str] parameters: Specifies a map of parameters for the task.
        :param _builtins.str source: The name of the runbook for the post task.
        """
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Specifies a map of parameters for the task.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[_builtins.str]:
        """
        The name of the runbook for the post task.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class SoftwareUpdateConfigurationPreTask(dict):
    def __init__(__self__, *,
                 parameters: Optional[Mapping[str, _builtins.str]] = None,
                 source: Optional[_builtins.str] = None):
        """
        :param Mapping[str, _builtins.str] parameters: Specifies a map of parameters for the task.
        :param _builtins.str source: The name of the runbook for the pre task.
        """
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Specifies a map of parameters for the task.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[_builtins.str]:
        """
        The name of the runbook for the pre task.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class SoftwareUpdateConfigurationSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "advancedMonthDays":
            suggest = "advanced_month_days"
        elif key == "advancedWeekDays":
            suggest = "advanced_week_days"
        elif key == "creationTime":
            suggest = "creation_time"
        elif key == "expiryTime":
            suggest = "expiry_time"
        elif key == "expiryTimeOffsetMinutes":
            suggest = "expiry_time_offset_minutes"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "lastModifiedTime":
            suggest = "last_modified_time"
        elif key == "monthlyOccurrence":
            suggest = "monthly_occurrence"
        elif key == "nextRun":
            suggest = "next_run"
        elif key == "nextRunOffsetMinutes":
            suggest = "next_run_offset_minutes"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "startTimeOffsetMinutes":
            suggest = "start_time_offset_minutes"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SoftwareUpdateConfigurationSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SoftwareUpdateConfigurationSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SoftwareUpdateConfigurationSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 frequency: _builtins.str,
                 advanced_month_days: Optional[Sequence[_builtins.int]] = None,
                 advanced_week_days: Optional[Sequence[_builtins.str]] = None,
                 creation_time: Optional[_builtins.str] = None,
                 description: Optional[_builtins.str] = None,
                 expiry_time: Optional[_builtins.str] = None,
                 expiry_time_offset_minutes: Optional[_builtins.float] = None,
                 interval: Optional[_builtins.int] = None,
                 is_enabled: Optional[_builtins.bool] = None,
                 last_modified_time: Optional[_builtins.str] = None,
                 monthly_occurrence: Optional['outputs.SoftwareUpdateConfigurationScheduleMonthlyOccurrence'] = None,
                 next_run: Optional[_builtins.str] = None,
                 next_run_offset_minutes: Optional[_builtins.float] = None,
                 start_time: Optional[_builtins.str] = None,
                 start_time_offset_minutes: Optional[_builtins.float] = None,
                 time_zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str frequency: The frequency of the schedule. - can be either `OneTime`, `Day`, `Hour`, `Week`, or `Month`.
        :param Sequence[_builtins.int] advanced_month_days: List of days of the month that the job should execute on. Must be between `1` and `31`. `-1` for last day of the month. Only valid when frequency is `Month`.
        :param Sequence[_builtins.str] advanced_week_days: List of days of the week that the job should execute on. Only valid when frequency is `Week`. Possible values include `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, and `Sunday`.
        :param _builtins.str description: A description for this Schedule.
        :param _builtins.str expiry_time: The end time of the schedule.
        :param _builtins.int interval: The number of `frequency`s between runs. Only valid when frequency is `Day`, `Hour`, `Week`, or `Month`.
        :param _builtins.bool is_enabled: Whether the schedule is enabled. Defaults to `true`.
        :param 'SoftwareUpdateConfigurationScheduleMonthlyOccurrenceArgs' monthly_occurrence: List of `monthly_occurrence` blocks as defined below to specifies occurrences of days within a month. Only valid when frequency is `Month`. The `monthly_occurrence` block supports fields as defined below.
        :param _builtins.str start_time: Start time of the schedule. Must be at least five minutes in the future. Defaults to seven minutes in the future from the time the resource is created.
        :param _builtins.str time_zone: The timezone of the start time. Defaults to `Etc/UTC`. For possible values see: <https://docs.microsoft.com/en-us/rest/api/maps/timezone/gettimezoneenumwindows>
        """
        pulumi.set(__self__, "frequency", frequency)
        if advanced_month_days is not None:
            pulumi.set(__self__, "advanced_month_days", advanced_month_days)
        if advanced_week_days is not None:
            pulumi.set(__self__, "advanced_week_days", advanced_week_days)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expiry_time is not None:
            pulumi.set(__self__, "expiry_time", expiry_time)
        if expiry_time_offset_minutes is not None:
            pulumi.set(__self__, "expiry_time_offset_minutes", expiry_time_offset_minutes)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if last_modified_time is not None:
            pulumi.set(__self__, "last_modified_time", last_modified_time)
        if monthly_occurrence is not None:
            pulumi.set(__self__, "monthly_occurrence", monthly_occurrence)
        if next_run is not None:
            pulumi.set(__self__, "next_run", next_run)
        if next_run_offset_minutes is not None:
            pulumi.set(__self__, "next_run_offset_minutes", next_run_offset_minutes)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if start_time_offset_minutes is not None:
            pulumi.set(__self__, "start_time_offset_minutes", start_time_offset_minutes)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> _builtins.str:
        """
        The frequency of the schedule. - can be either `OneTime`, `Day`, `Hour`, `Week`, or `Month`.
        """
        return pulumi.get(self, "frequency")

    @_builtins.property
    @pulumi.getter(name="advancedMonthDays")
    def advanced_month_days(self) -> Optional[Sequence[_builtins.int]]:
        """
        List of days of the month that the job should execute on. Must be between `1` and `31`. `-1` for last day of the month. Only valid when frequency is `Month`.
        """
        return pulumi.get(self, "advanced_month_days")

    @_builtins.property
    @pulumi.getter(name="advancedWeekDays")
    def advanced_week_days(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of days of the week that the job should execute on. Only valid when frequency is `Week`. Possible values include `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, and `Sunday`.
        """
        return pulumi.get(self, "advanced_week_days")

    @_builtins.property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "creation_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        A description for this Schedule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="expiryTime")
    def expiry_time(self) -> Optional[_builtins.str]:
        """
        The end time of the schedule.
        """
        return pulumi.get(self, "expiry_time")

    @_builtins.property
    @pulumi.getter(name="expiryTimeOffsetMinutes")
    def expiry_time_offset_minutes(self) -> Optional[_builtins.float]:
        return pulumi.get(self, "expiry_time_offset_minutes")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[_builtins.int]:
        """
        The number of `frequency`s between runs. Only valid when frequency is `Day`, `Hour`, `Week`, or `Month`.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether the schedule is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "last_modified_time")

    @_builtins.property
    @pulumi.getter(name="monthlyOccurrence")
    def monthly_occurrence(self) -> Optional['outputs.SoftwareUpdateConfigurationScheduleMonthlyOccurrence']:
        """
        List of `monthly_occurrence` blocks as defined below to specifies occurrences of days within a month. Only valid when frequency is `Month`. The `monthly_occurrence` block supports fields as defined below.
        """
        return pulumi.get(self, "monthly_occurrence")

    @_builtins.property
    @pulumi.getter(name="nextRun")
    def next_run(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "next_run")

    @_builtins.property
    @pulumi.getter(name="nextRunOffsetMinutes")
    def next_run_offset_minutes(self) -> Optional[_builtins.float]:
        return pulumi.get(self, "next_run_offset_minutes")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[_builtins.str]:
        """
        Start time of the schedule. Must be at least five minutes in the future. Defaults to seven minutes in the future from the time the resource is created.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter(name="startTimeOffsetMinutes")
    def start_time_offset_minutes(self) -> Optional[_builtins.float]:
        return pulumi.get(self, "start_time_offset_minutes")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[_builtins.str]:
        """
        The timezone of the start time. Defaults to `Etc/UTC`. For possible values see: <https://docs.microsoft.com/en-us/rest/api/maps/timezone/gettimezoneenumwindows>
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class SoftwareUpdateConfigurationScheduleMonthlyOccurrence(dict):
    def __init__(__self__, *,
                 day: _builtins.str,
                 occurrence: _builtins.int):
        """
        :param _builtins.str day: Day of the occurrence. Must be one of `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, `Sunday`.
        :param _builtins.int occurrence: Occurrence of the week within the month. Must be between `1` and `4`. `-1` for last week within the month.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "occurrence", occurrence)

    @_builtins.property
    @pulumi.getter
    def day(self) -> _builtins.str:
        """
        Day of the occurrence. Must be one of `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, `Sunday`.
        """
        return pulumi.get(self, "day")

    @_builtins.property
    @pulumi.getter
    def occurrence(self) -> _builtins.int:
        """
        Occurrence of the week within the month. Must be between `1` and `4`. `-1` for last week within the month.
        """
        return pulumi.get(self, "occurrence")


@pulumi.output_type
class SoftwareUpdateConfigurationTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureQueries":
            suggest = "azure_queries"
        elif key == "nonAzureQueries":
            suggest = "non_azure_queries"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SoftwareUpdateConfigurationTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SoftwareUpdateConfigurationTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SoftwareUpdateConfigurationTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_queries: Optional[Sequence['outputs.SoftwareUpdateConfigurationTargetAzureQuery']] = None,
                 non_azure_queries: Optional[Sequence['outputs.SoftwareUpdateConfigurationTargetNonAzureQuery']] = None):
        """
        :param Sequence['SoftwareUpdateConfigurationTargetAzureQueryArgs'] azure_queries: One or more `azure_query` blocks as defined above.
        :param Sequence['SoftwareUpdateConfigurationTargetNonAzureQueryArgs'] non_azure_queries: One or more `non_azure_query` blocks as defined above.
        """
        if azure_queries is not None:
            pulumi.set(__self__, "azure_queries", azure_queries)
        if non_azure_queries is not None:
            pulumi.set(__self__, "non_azure_queries", non_azure_queries)

    @_builtins.property
    @pulumi.getter(name="azureQueries")
    def azure_queries(self) -> Optional[Sequence['outputs.SoftwareUpdateConfigurationTargetAzureQuery']]:
        """
        One or more `azure_query` blocks as defined above.
        """
        return pulumi.get(self, "azure_queries")

    @_builtins.property
    @pulumi.getter(name="nonAzureQueries")
    def non_azure_queries(self) -> Optional[Sequence['outputs.SoftwareUpdateConfigurationTargetNonAzureQuery']]:
        """
        One or more `non_azure_query` blocks as defined above.
        """
        return pulumi.get(self, "non_azure_queries")


@pulumi.output_type
class SoftwareUpdateConfigurationTargetAzureQuery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tagFilter":
            suggest = "tag_filter"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SoftwareUpdateConfigurationTargetAzureQuery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SoftwareUpdateConfigurationTargetAzureQuery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SoftwareUpdateConfigurationTargetAzureQuery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 locations: Optional[Sequence[_builtins.str]] = None,
                 scopes: Optional[Sequence[_builtins.str]] = None,
                 tag_filter: Optional[_builtins.str] = None,
                 tags: Optional[Sequence['outputs.SoftwareUpdateConfigurationTargetAzureQueryTag']] = None):
        """
        :param Sequence[_builtins.str] locations: Specifies a list of locations to scope the query to.
        :param Sequence[_builtins.str] scopes: Specifies a list of Subscription or Resource Group ARM Ids to query.
        :param _builtins.str tag_filter: Specifies how the specified tags to filter VMs. Possible values are `Any` and `All`.
        :param Sequence['SoftwareUpdateConfigurationTargetAzureQueryTagArgs'] tags: A mapping of tags used for query filter. One or more `tags` block as defined below.
        """
        if locations is not None:
            pulumi.set(__self__, "locations", locations)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if tag_filter is not None:
            pulumi.set(__self__, "tag_filter", tag_filter)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def locations(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of locations to scope the query to.
        """
        return pulumi.get(self, "locations")

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of Subscription or Resource Group ARM Ids to query.
        """
        return pulumi.get(self, "scopes")

    @_builtins.property
    @pulumi.getter(name="tagFilter")
    def tag_filter(self) -> Optional[_builtins.str]:
        """
        Specifies how the specified tags to filter VMs. Possible values are `Any` and `All`.
        """
        return pulumi.get(self, "tag_filter")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.SoftwareUpdateConfigurationTargetAzureQueryTag']]:
        """
        A mapping of tags used for query filter. One or more `tags` block as defined below.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class SoftwareUpdateConfigurationTargetAzureQueryTag(dict):
    def __init__(__self__, *,
                 tag: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str tag: Specifies the name of the tag to filter.
        :param Sequence[_builtins.str] values: Specifies a list of values for this tag key.
        """
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def tag(self) -> _builtins.str:
        """
        Specifies the name of the tag to filter.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        Specifies a list of values for this tag key.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class SoftwareUpdateConfigurationTargetNonAzureQuery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionAlias":
            suggest = "function_alias"
        elif key == "workspaceId":
            suggest = "workspace_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SoftwareUpdateConfigurationTargetNonAzureQuery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SoftwareUpdateConfigurationTargetNonAzureQuery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SoftwareUpdateConfigurationTargetNonAzureQuery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_alias: Optional[_builtins.str] = None,
                 workspace_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str function_alias: Specifies the Log Analytics save search name.
        :param _builtins.str workspace_id: The workspace id for Log Analytics in which the saved search in.
        """
        if function_alias is not None:
            pulumi.set(__self__, "function_alias", function_alias)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="functionAlias")
    def function_alias(self) -> Optional[_builtins.str]:
        """
        Specifies the Log Analytics save search name.
        """
        return pulumi.get(self, "function_alias")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[_builtins.str]:
        """
        The workspace id for Log Analytics in which the saved search in.
        """
        return pulumi.get(self, "workspace_id")


@pulumi.output_type
class SoftwareUpdateConfigurationWindows(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "classificationsIncludeds":
            suggest = "classifications_includeds"
        elif key == "excludedKnowledgeBaseNumbers":
            suggest = "excluded_knowledge_base_numbers"
        elif key == "includedKnowledgeBaseNumbers":
            suggest = "included_knowledge_base_numbers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SoftwareUpdateConfigurationWindows. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SoftwareUpdateConfigurationWindows.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SoftwareUpdateConfigurationWindows.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 classifications_includeds: Sequence[_builtins.str],
                 excluded_knowledge_base_numbers: Optional[Sequence[_builtins.str]] = None,
                 included_knowledge_base_numbers: Optional[Sequence[_builtins.str]] = None,
                 reboot: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] classifications_includeds: Specifies the list of update classification. Possible values are `Unclassified`, `Critical`, `Security`, `UpdateRollup`, `FeaturePack`, `ServicePack`, `Definition`, `Tools` and `Updates`.
        :param Sequence[_builtins.str] excluded_knowledge_base_numbers: Specifies a list of knowledge base numbers excluded.
        :param Sequence[_builtins.str] included_knowledge_base_numbers: Specifies a list of knowledge base numbers included.
        :param _builtins.str reboot: Specifies the reboot settings after software update, possible values are `IfRequired`, `Never`, `RebootOnly` and `Always`. Defaults to `IfRequired`.
        """
        pulumi.set(__self__, "classifications_includeds", classifications_includeds)
        if excluded_knowledge_base_numbers is not None:
            pulumi.set(__self__, "excluded_knowledge_base_numbers", excluded_knowledge_base_numbers)
        if included_knowledge_base_numbers is not None:
            pulumi.set(__self__, "included_knowledge_base_numbers", included_knowledge_base_numbers)
        if reboot is not None:
            pulumi.set(__self__, "reboot", reboot)

    @_builtins.property
    @pulumi.getter(name="classificationsIncludeds")
    def classifications_includeds(self) -> Sequence[_builtins.str]:
        """
        Specifies the list of update classification. Possible values are `Unclassified`, `Critical`, `Security`, `UpdateRollup`, `FeaturePack`, `ServicePack`, `Definition`, `Tools` and `Updates`.
        """
        return pulumi.get(self, "classifications_includeds")

    @_builtins.property
    @pulumi.getter(name="excludedKnowledgeBaseNumbers")
    def excluded_knowledge_base_numbers(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of knowledge base numbers excluded.
        """
        return pulumi.get(self, "excluded_knowledge_base_numbers")

    @_builtins.property
    @pulumi.getter(name="includedKnowledgeBaseNumbers")
    def included_knowledge_base_numbers(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of knowledge base numbers included.
        """
        return pulumi.get(self, "included_knowledge_base_numbers")

    @_builtins.property
    @pulumi.getter
    def reboot(self) -> Optional[_builtins.str]:
        """
        Specifies the reboot settings after software update, possible values are `IfRequired`, `Never`, `RebootOnly` and `Always`. Defaults to `IfRequired`.
        """
        return pulumi.get(self, "reboot")


@pulumi.output_type
class SourceControlSecurity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tokenType":
            suggest = "token_type"
        elif key == "refreshToken":
            suggest = "refresh_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceControlSecurity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceControlSecurity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceControlSecurity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 token: _builtins.str,
                 token_type: _builtins.str,
                 refresh_token: Optional[_builtins.str] = None):
        """
        :param _builtins.str token: The access token of specified repo.
        :param _builtins.str token_type: Specify the token type, possible values are `PersonalAccessToken` and `Oauth`.
        :param _builtins.str refresh_token: The refresh token of specified rpeo.
        """
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "token_type", token_type)
        if refresh_token is not None:
            pulumi.set(__self__, "refresh_token", refresh_token)

    @_builtins.property
    @pulumi.getter
    def token(self) -> _builtins.str:
        """
        The access token of specified repo.
        """
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> _builtins.str:
        """
        Specify the token type, possible values are `PersonalAccessToken` and `Oauth`.
        """
        return pulumi.get(self, "token_type")

    @_builtins.property
    @pulumi.getter(name="refreshToken")
    def refresh_token(self) -> Optional[_builtins.str]:
        """
        The refresh token of specified rpeo.
        """
        return pulumi.get(self, "refresh_token")


@pulumi.output_type
class GetAccountIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[_builtins.str],
                 principal_id: _builtins.str,
                 tenant_id: _builtins.str,
                 type: _builtins.str):
        """
        :param Sequence[_builtins.str] identity_ids: The list of User Assigned Managed Identity IDs assigned to this Automation Account.
        :param _builtins.str principal_id: The Principal ID of the System Assigned Managed Service Identity that is configured on this Automation Account.
        :param _builtins.str tenant_id: The Tenant ID of the System Assigned Managed Service Identity that is configured on this Automation Account.
        :param _builtins.str type: The type of Managed Service Identity that is configured on this Automation Account.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[_builtins.str]:
        """
        The list of User Assigned Managed Identity IDs assigned to this Automation Account.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        The Principal ID of the System Assigned Managed Service Identity that is configured on this Automation Account.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The Tenant ID of the System Assigned Managed Service Identity that is configured on this Automation Account.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of Managed Service Identity that is configured on this Automation Account.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAccountPrivateEndpointConnectionResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 name: _builtins.str):
        """
        :param _builtins.str id: The ID of the Automation Account
        :param _builtins.str name: The name of the Automation Account.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Automation Account
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Automation Account.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetVariablesBoolResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 encrypted: _builtins.bool,
                 id: _builtins.str,
                 name: _builtins.str,
                 value: _builtins.bool):
        """
        :param _builtins.str description: The description of the Automation Variable.
        :param _builtins.bool encrypted: Specifies if the Automation Variable is encrypted.
        :param _builtins.str name: The name of the Automation Variable.
        :param _builtins.bool value: The value of the Automation Variable.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "encrypted", encrypted)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Automation Variable.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> _builtins.bool:
        """
        Specifies if the Automation Variable is encrypted.
        """
        return pulumi.get(self, "encrypted")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Automation Variable.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.bool:
        """
        The value of the Automation Variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetVariablesDatetimeResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 encrypted: _builtins.bool,
                 id: _builtins.str,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str description: The description of the Automation Variable.
        :param _builtins.bool encrypted: Specifies if the Automation Variable is encrypted.
        :param _builtins.str name: The name of the Automation Variable.
        :param _builtins.str value: The value of the Automation Variable.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "encrypted", encrypted)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Automation Variable.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> _builtins.bool:
        """
        Specifies if the Automation Variable is encrypted.
        """
        return pulumi.get(self, "encrypted")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Automation Variable.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the Automation Variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetVariablesEncryptedResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 encrypted: _builtins.bool,
                 id: _builtins.str,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str description: The description of the Automation Variable.
        :param _builtins.bool encrypted: Specifies if the Automation Variable is encrypted.
        :param _builtins.str name: The name of the Automation Variable.
        :param _builtins.str value: The value of the Automation Variable.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "encrypted", encrypted)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Automation Variable.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> _builtins.bool:
        """
        Specifies if the Automation Variable is encrypted.
        """
        return pulumi.get(self, "encrypted")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Automation Variable.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the Automation Variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetVariablesIntResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 encrypted: _builtins.bool,
                 id: _builtins.str,
                 name: _builtins.str,
                 value: _builtins.int):
        """
        :param _builtins.str description: The description of the Automation Variable.
        :param _builtins.bool encrypted: Specifies if the Automation Variable is encrypted.
        :param _builtins.str name: The name of the Automation Variable.
        :param _builtins.int value: The value of the Automation Variable.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "encrypted", encrypted)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Automation Variable.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> _builtins.bool:
        """
        Specifies if the Automation Variable is encrypted.
        """
        return pulumi.get(self, "encrypted")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Automation Variable.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.int:
        """
        The value of the Automation Variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetVariablesNullResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 encrypted: _builtins.bool,
                 id: _builtins.str,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str description: The description of the Automation Variable.
        :param _builtins.bool encrypted: Specifies if the Automation Variable is encrypted.
        :param _builtins.str name: The name of the Automation Variable.
        :param _builtins.str value: The value of the Automation Variable.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "encrypted", encrypted)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Automation Variable.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> _builtins.bool:
        """
        Specifies if the Automation Variable is encrypted.
        """
        return pulumi.get(self, "encrypted")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Automation Variable.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the Automation Variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetVariablesObjectResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 encrypted: _builtins.bool,
                 id: _builtins.str,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str description: The description of the Automation Variable.
        :param _builtins.bool encrypted: Specifies if the Automation Variable is encrypted.
        :param _builtins.str name: The name of the Automation Variable.
        :param _builtins.str value: The value of the Automation Variable.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "encrypted", encrypted)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Automation Variable.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> _builtins.bool:
        """
        Specifies if the Automation Variable is encrypted.
        """
        return pulumi.get(self, "encrypted")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Automation Variable.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the Automation Variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetVariablesStringResult(dict):
    def __init__(__self__, *,
                 description: _builtins.str,
                 encrypted: _builtins.bool,
                 id: _builtins.str,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str description: The description of the Automation Variable.
        :param _builtins.bool encrypted: Specifies if the Automation Variable is encrypted.
        :param _builtins.str name: The name of the Automation Variable.
        :param _builtins.str value: The value of the Automation Variable.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "encrypted", encrypted)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Automation Variable.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def encrypted(self) -> _builtins.bool:
        """
        Specifies if the Automation Variable is encrypted.
        """
        return pulumi.get(self, "encrypted")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Automation Variable.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the Automation Variable.
        """
        return pulumi.get(self, "value")


