# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FrontdoorRuleArgs', 'FrontdoorRule']

@pulumi.input_type
class FrontdoorRuleArgs:
    def __init__(__self__, *,
                 actions: pulumi.Input['FrontdoorRuleActionsArgs'],
                 cdn_frontdoor_rule_set_id: pulumi.Input[_builtins.str],
                 order: pulumi.Input[_builtins.int],
                 behavior_on_match: Optional[pulumi.Input[_builtins.str]] = None,
                 conditions: Optional[pulumi.Input['FrontdoorRuleConditionsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FrontdoorRule resource.
        :param pulumi.Input['FrontdoorRuleActionsArgs'] actions: An `actions` block as defined below.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_rule_set_id: The resource ID of the Front Door Rule Set for this Front Door Rule. Changing this forces a new Front Door Rule to be created.
        :param pulumi.Input[_builtins.int] order: The order in which the rules will be applied for the Front Door Endpoint. The order value should be sequential and begin at `1`(e.g. `1`, `2`, `3`...). A Front Door Rule with a lesser order value will be applied before a rule with a greater order value.
               
               > **Note:** If the Front Door Rule has an order value of `0` they do not require any conditions and the actions will always be applied.
        :param pulumi.Input[_builtins.str] behavior_on_match: If this rule is a match should the rules engine continue processing the remaining rules or stop? Possible values are `Continue` and `Stop`. Defaults to `Continue`.
        :param pulumi.Input['FrontdoorRuleConditionsArgs'] conditions: A `conditions` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Front Door Rule. Possible values must be between 1 and 260 characters in length, begin with a letter and may contain only letters and numbers. Changing this forces a new Front Door Rule to be created.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "cdn_frontdoor_rule_set_id", cdn_frontdoor_rule_set_id)
        pulumi.set(__self__, "order", order)
        if behavior_on_match is not None:
            pulumi.set(__self__, "behavior_on_match", behavior_on_match)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> pulumi.Input['FrontdoorRuleActionsArgs']:
        """
        An `actions` block as defined below.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: pulumi.Input['FrontdoorRuleActionsArgs']):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorRuleSetId")
    def cdn_frontdoor_rule_set_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource ID of the Front Door Rule Set for this Front Door Rule. Changing this forces a new Front Door Rule to be created.
        """
        return pulumi.get(self, "cdn_frontdoor_rule_set_id")

    @cdn_frontdoor_rule_set_id.setter
    def cdn_frontdoor_rule_set_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cdn_frontdoor_rule_set_id", value)

    @_builtins.property
    @pulumi.getter
    def order(self) -> pulumi.Input[_builtins.int]:
        """
        The order in which the rules will be applied for the Front Door Endpoint. The order value should be sequential and begin at `1`(e.g. `1`, `2`, `3`...). A Front Door Rule with a lesser order value will be applied before a rule with a greater order value.

        > **Note:** If the Front Door Rule has an order value of `0` they do not require any conditions and the actions will always be applied.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "order", value)

    @_builtins.property
    @pulumi.getter(name="behaviorOnMatch")
    def behavior_on_match(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If this rule is a match should the rules engine continue processing the remaining rules or stop? Possible values are `Continue` and `Stop`. Defaults to `Continue`.
        """
        return pulumi.get(self, "behavior_on_match")

    @behavior_on_match.setter
    def behavior_on_match(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "behavior_on_match", value)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input['FrontdoorRuleConditionsArgs']]:
        """
        A `conditions` block as defined below.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input['FrontdoorRuleConditionsArgs']]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Front Door Rule. Possible values must be between 1 and 260 characters in length, begin with a letter and may contain only letters and numbers. Changing this forces a new Front Door Rule to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _FrontdoorRuleState:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input['FrontdoorRuleActionsArgs']] = None,
                 behavior_on_match: Optional[pulumi.Input[_builtins.str]] = None,
                 cdn_frontdoor_rule_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cdn_frontdoor_rule_set_name: Optional[pulumi.Input[_builtins.str]] = None,
                 conditions: Optional[pulumi.Input['FrontdoorRuleConditionsArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 order: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering FrontdoorRule resources.
        :param pulumi.Input['FrontdoorRuleActionsArgs'] actions: An `actions` block as defined below.
        :param pulumi.Input[_builtins.str] behavior_on_match: If this rule is a match should the rules engine continue processing the remaining rules or stop? Possible values are `Continue` and `Stop`. Defaults to `Continue`.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_rule_set_id: The resource ID of the Front Door Rule Set for this Front Door Rule. Changing this forces a new Front Door Rule to be created.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_rule_set_name: The name of the Front Door Rule Set containing this Front Door Rule.
        :param pulumi.Input['FrontdoorRuleConditionsArgs'] conditions: A `conditions` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Front Door Rule. Possible values must be between 1 and 260 characters in length, begin with a letter and may contain only letters and numbers. Changing this forces a new Front Door Rule to be created.
        :param pulumi.Input[_builtins.int] order: The order in which the rules will be applied for the Front Door Endpoint. The order value should be sequential and begin at `1`(e.g. `1`, `2`, `3`...). A Front Door Rule with a lesser order value will be applied before a rule with a greater order value.
               
               > **Note:** If the Front Door Rule has an order value of `0` they do not require any conditions and the actions will always be applied.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if behavior_on_match is not None:
            pulumi.set(__self__, "behavior_on_match", behavior_on_match)
        if cdn_frontdoor_rule_set_id is not None:
            pulumi.set(__self__, "cdn_frontdoor_rule_set_id", cdn_frontdoor_rule_set_id)
        if cdn_frontdoor_rule_set_name is not None:
            pulumi.set(__self__, "cdn_frontdoor_rule_set_name", cdn_frontdoor_rule_set_name)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if order is not None:
            pulumi.set(__self__, "order", order)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input['FrontdoorRuleActionsArgs']]:
        """
        An `actions` block as defined below.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input['FrontdoorRuleActionsArgs']]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter(name="behaviorOnMatch")
    def behavior_on_match(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If this rule is a match should the rules engine continue processing the remaining rules or stop? Possible values are `Continue` and `Stop`. Defaults to `Continue`.
        """
        return pulumi.get(self, "behavior_on_match")

    @behavior_on_match.setter
    def behavior_on_match(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "behavior_on_match", value)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorRuleSetId")
    def cdn_frontdoor_rule_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the Front Door Rule Set for this Front Door Rule. Changing this forces a new Front Door Rule to be created.
        """
        return pulumi.get(self, "cdn_frontdoor_rule_set_id")

    @cdn_frontdoor_rule_set_id.setter
    def cdn_frontdoor_rule_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cdn_frontdoor_rule_set_id", value)

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorRuleSetName")
    def cdn_frontdoor_rule_set_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Front Door Rule Set containing this Front Door Rule.
        """
        return pulumi.get(self, "cdn_frontdoor_rule_set_name")

    @cdn_frontdoor_rule_set_name.setter
    def cdn_frontdoor_rule_set_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cdn_frontdoor_rule_set_name", value)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input['FrontdoorRuleConditionsArgs']]:
        """
        A `conditions` block as defined below.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input['FrontdoorRuleConditionsArgs']]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Front Door Rule. Possible values must be between 1 and 260 characters in length, begin with a letter and may contain only letters and numbers. Changing this forces a new Front Door Rule to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The order in which the rules will be applied for the Front Door Endpoint. The order value should be sequential and begin at `1`(e.g. `1`, `2`, `3`...). A Front Door Rule with a lesser order value will be applied before a rule with a greater order value.

        > **Note:** If the Front Door Rule has an order value of `0` they do not require any conditions and the actions will always be applied.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "order", value)


@pulumi.type_token("azure:cdn/frontdoorRule:FrontdoorRule")
class FrontdoorRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Union['FrontdoorRuleActionsArgs', 'FrontdoorRuleActionsArgsDict']]] = None,
                 behavior_on_match: Optional[pulumi.Input[_builtins.str]] = None,
                 cdn_frontdoor_rule_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Union['FrontdoorRuleConditionsArgs', 'FrontdoorRuleConditionsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 order: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages a Front Door (standard/premium) Rule.

        !> **Note:** The Rules resource **must** include a `depends_on` meta-argument which references the `cdn.FrontdoorOrigin` and the `cdn.FrontdoorOriginGroup`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-cdn-frontdoor",
            location="West Europe")
        example_frontdoor_profile = azure.cdn.FrontdoorProfile("example",
            name="example-profile",
            resource_group_name=example.name,
            sku_name="Premium_AzureFrontDoor")
        example_frontdoor_endpoint = azure.cdn.FrontdoorEndpoint("example",
            name="example-endpoint",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            tags={
                "endpoint": "contoso.com",
            })
        example_frontdoor_origin_group = azure.cdn.FrontdoorOriginGroup("example",
            name="example-originGroup",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            session_affinity_enabled=True,
            restore_traffic_time_to_healed_or_new_endpoint_in_minutes=10,
            health_probe={
                "interval_in_seconds": 240,
                "path": "/healthProbe",
                "protocol": "Https",
                "request_type": "GET",
            },
            load_balancing={
                "additional_latency_in_milliseconds": 0,
                "sample_size": 16,
                "successful_samples_required": 3,
            })
        example_frontdoor_origin = azure.cdn.FrontdoorOrigin("example",
            name="example-origin",
            cdn_frontdoor_origin_group_id=example_frontdoor_origin_group.id,
            enabled=True,
            certificate_name_check_enabled=False,
            host_name=example_frontdoor_endpoint.host_name,
            http_port=80,
            https_port=443,
            origin_host_header="contoso.com",
            priority=1,
            weight=500)
        example_frontdoor_rule_set = azure.cdn.FrontdoorRuleSet("example",
            name="exampleruleset",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id)
        example_frontdoor_rule = azure.cdn.FrontdoorRule("example",
            name="examplerule",
            cdn_frontdoor_rule_set_id=example_frontdoor_rule_set.id,
            order=1,
            behavior_on_match="Continue",
            actions={
                "route_configuration_override_action": {
                    "cdn_frontdoor_origin_group_id": example_frontdoor_origin_group.id,
                    "forwarding_protocol": "HttpsOnly",
                    "query_string_caching_behavior": "IncludeSpecifiedQueryStrings",
                    "query_string_parameters": [
                        "foo",
                        "clientIp={client_ip}",
                    ],
                    "compression_enabled": True,
                    "cache_behavior": "OverrideIfOriginMissing",
                    "cache_duration": "365.23:59:59",
                },
                "url_redirect_action": {
                    "redirect_type": "PermanentRedirect",
                    "redirect_protocol": "MatchRequest",
                    "query_string": "clientIp={client_ip}",
                    "destination_path": "/exampleredirection",
                    "destination_hostname": "contoso.com",
                    "destination_fragment": "UrlRedirect",
                },
            },
            conditions={
                "host_name_conditions": [{
                    "operator": "Equal",
                    "negate_condition": False,
                    "match_values": [
                        "www.contoso.com",
                        "images.contoso.com",
                        "video.contoso.com",
                    ],
                    "transforms": [
                        "Lowercase",
                        "Trim",
                    ],
                }],
                "is_device_conditions": [{
                    "operator": "Equal",
                    "negate_condition": False,
                    "match_values": "Mobile",
                }],
                "post_args_conditions": [{
                    "post_args_name": "customerName",
                    "operator": "BeginsWith",
                    "match_values": [
                        "J",
                        "K",
                    ],
                    "transforms": ["Uppercase"],
                }],
                "request_method_conditions": [{
                    "operator": "Equal",
                    "negate_condition": False,
                    "match_values": ["DELETE"],
                }],
                "url_filename_conditions": [{
                    "operator": "Equal",
                    "negate_condition": False,
                    "match_values": ["media.mp4"],
                    "transforms": [
                        "Lowercase",
                        "RemoveNulls",
                        "Trim",
                    ],
                }],
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    example_frontdoor_origin_group,
                    example_frontdoor_origin,
                ]))
        ```

        ## Specifying IP Address Ranges

        When specifying IP address ranges in the `socket_address_condition` and the `remote_address_condition` `match_values` use the following format:

        Use `CIDR` notation when specifying IP address blocks. This means that the syntax for an IP address block is the base IP address followed by a forward slash and the prefix size For example:

        * `IPv4` example: `5.5.5.64/26` matches any requests that arrive from addresses `5.5.5.64` through `5.5.5.127`.
        * `IPv6` example: `1:2:3:/48` matches any requests that arrive from addresses `1:2:3:0:0:0:0:0` through `1:2:3:ffff:ffff:ffff:ffff:ffff`.

        When you specify multiple IP addresses and IP address blocks, `OR` logic is applied.

        * `IPv4` example: if you add two IP addresses `1.2.3.4` and `10.20.30.40`, the condition is matched for any requests that arrive from either address `1.2.3.4` or `10.20.30.40`.
        * `IPv6` example: if you add two IP addresses `1:2:3:4:5:6:7:8` and `10:20:30:40:50:60:70:80`, the condition is matched for any requests that arrive from either address `1:2:3:4:5:6:7:8` or `10:20:30:40:50:60:70:80`.

        ***

        ## Action Server Variables

        Rule Set server variables provide access to structured information about the request. You can use server variables to dynamically change the request/response headers or URL rewrite paths/query strings, for example, when a new page load or when a form is posted.

        ### Supported Action Server Variables

        | Variable name | Description |
        |---------------|-------------|
        | `socket_ip`      | The IP address of the direct connection to Front Door Profiles edge. If the client used an HTTP proxy or a load balancer to send the request, the value of `socket_ip` is the IP address of the proxy or load balancer. |
        | `client_ip`      | The IP address of the client that made the original request. If there was an `X-Forwarded-For` header in the request, then the client IP address is picked from the header. |
        | `client_port`    | The IP port of the client that made the request. |
        | `hostname`       | The host name in the request from the client. |
        | `geo_country`    | Indicates the requester's country/region of origin through its country/region code. |
        | `http_method`    | The method used to make the URL request, such as `GET` or `POST`. |
        | `http_version`   | The request protocol. Usually `HTTP/1.0`, `HTTP/1.1`, or `HTTP/2.0`. |
        | `query_string`   | The list of variable/value pairs that follows the "?" in the requested URL. For example, in the request `http://contoso.com:8080/article.aspx?id=123&title=fabrikam`, the `query_string` value will be `id=123&title=fabrikam`. |
        | `request_scheme` | The request scheme: `http` or `https`. |
        | `request_uri`    | The full original request URI (with arguments). For example, in the request `http://contoso.com:8080/article.aspx?id=123&title=fabrikam`, the `request_uri` value will be `/article.aspx?id=123&title=fabrikam`. |
        | `ssl_protocol`   | The protocol of an established TLS connection. |
        | `server_port`    | The port of the server that accepted a request. |
        | `url_path`       | Identifies the specific resource in the host that the web client wants to access. This is the part of the request URI without the arguments. For example, in the request `http://contoso.com:8080/article.aspx?id=123&title=fabrikam`, the `uri_path` value will be `/article.aspx`. |

        ### Action Server Variable Format

        Server variables can be specified using the following formats:

        * `{variable}` - Include the entire server variable. For example, if the client IP address is `111.222.333.444` then the `{client_ip}` token would evaluate to `111.222.333.444`.

        * `{variable:offset}` - Include the server variable after a specific offset, until the end of the variable. The offset is zero-based. For example, if the client IP address is `111.222.333.444` then the `{client_ip:3}` token would evaluate to `.222.333.444`.

        * `{variable:offset:length}` - Include the server variable after a specific offset, up to the specified length. The offset is zero-based. For example, if the client IP address is `111.222.333.444` then the `{client_ip:4:3}` token would evaluate to `222`.

        ### Action Server Variables Support

        Action Server variables are supported on the following actions:

        * `route_configuration_override_action`
        * `request_header_action`
        * `response_header_action`
        * `url_redirect_action`
        * `url_rewrite_action`

        ***

        ## Condition Operator list

        For rules that accept values from the standard operator list, the following operators are valid:

        | Operator                   | Description | Condition Value |
        |----------------------------|-------------|-----------------|
        | Any                        |Matches when there is any value, regardless of what it is. | Any |
        | Equal                      | Matches when the value exactly matches the specified string. | Equal |
        | Contains                   | Matches when the value contains the specified string. | Contains |
        | Less Than                  | Matches when the length of the value is less than the specified integer. | LessThan |
        | Greater Than               | Matches when the length of the value is greater than the specified integer. | GreaterThan |
        | Less Than or Equal         | Matches when the length of the value is less than or equal to the specified integer. | LessThanOrEqual |
        | Greater Than or Equal      | Matches when the length of the value is greater than or equal to the specified integer. | GreaterThanOrEqual |
        | Begins With                | Matches when the value begins with the specified string. | BeginsWith |
        | Ends With                  | Matches when the value ends with the specified string. | EndsWith |
        | RegEx                      | Matches when the value matches the specified regular expression. See `Condition Regular Expressions` below for more details. | RegEx |
        | Wildcard                   | Matches when the request path matches a wildcard expression. See `Condition Wildcard Expression` below for more details. | Wildcard |
        | Not Any                    | Matches when there is no value. | Any and negateCondition = true |
        | Not Equal                  | Matches when the value does not match the specified string. | Equal and negateCondition : true |
        | Not Contains               | Matches when the value does not contain the specified string. | Contains and negateCondition = true |
        | Not Less Than              | Matches when the length of the value is not less than the specified integer. | LessThan and negateCondition = true |
        | Not Greater Than           | Matches when the length of the value is not greater than the specified integer. | GreaterThan and negateCondition = true |
        | Not Less Than or Equal     | Matches when the length of the value is not less than or equal to the specified integer. | LessThanOrEqual and negateCondition = true |
        | Not Greater Than or Equals | Matches when the length of the value is not greater than or equal to the specified integer. | GreaterThanOrEqual and negateCondition = true |
        | Not Begins With            | Matches when the value does not begin with the specified string. | BeginsWith and negateCondition = true |
        | Not Ends With              | Matches when the value does not end with the specified string. | EndsWith and negateCondition = true |
        | Not RegEx                  | Matches when the value does not match the specified regular expression. See `Condition Regular Expressions` for more details. | RegEx and negateCondition = true |
        | Not Wildcard               | Matches when the request path does not match a wildcard expression. See `Condition Wildcard Expression` below for more details. | Wildcard and negateCondition = true |

        ***

        ## Condition Regular Expressions

        Regular expressions **don't** support the following operations:

        * Backreferences and capturing subexpressions.
        * Arbitrary zero-width assertions.
        * Subroutine references and recursive patterns.
        * Conditional patterns.
        * Backtracking control verbs.
        * The `\\C` single-byte directive.
        * The `\\R` newline match directive.
        * The `\\K` start of match reset directive.
        * Callouts and embedded code.
        * Atomic grouping and possessive quantifiers.

        ## Condition Wildcard Expression

        A wildcard expression can include the * character to match zero or more characters within the path. For example, the wildcard expression `files/customer*/file.pdf` matches the paths `files/customer1/file.pdf`, `files/customer109/file.pdf`, and `files/customer/file.pdf`, but doesn't match `files/customer2/anotherfile.pdf`.

        ***

        ## Condition Transform List

        For rules that can transform strings, the following transforms are valid:

        | Transform   | Description |
        |-------------|-------------|
        | Lowercase   | Converts the string to the lowercase representation. |
        | Uppercase   | Converts the string to the uppercase representation. |
        | Trim        | Trims leading and trailing whitespace from the string. |
        | RemoveNulls | Removes null values from the string. |
        | URLEncode   | URL-encodes the string. |
        | URLDecode   | URL-decodes the string. |

        ***

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Cdn` - 2024-09-01

        ## Import

        Front Door Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cdn/frontdoorRule:FrontdoorRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Cdn/profiles/profile1/ruleSets/ruleSet1/rules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FrontdoorRuleActionsArgs', 'FrontdoorRuleActionsArgsDict']] actions: An `actions` block as defined below.
        :param pulumi.Input[_builtins.str] behavior_on_match: If this rule is a match should the rules engine continue processing the remaining rules or stop? Possible values are `Continue` and `Stop`. Defaults to `Continue`.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_rule_set_id: The resource ID of the Front Door Rule Set for this Front Door Rule. Changing this forces a new Front Door Rule to be created.
        :param pulumi.Input[Union['FrontdoorRuleConditionsArgs', 'FrontdoorRuleConditionsArgsDict']] conditions: A `conditions` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Front Door Rule. Possible values must be between 1 and 260 characters in length, begin with a letter and may contain only letters and numbers. Changing this forces a new Front Door Rule to be created.
        :param pulumi.Input[_builtins.int] order: The order in which the rules will be applied for the Front Door Endpoint. The order value should be sequential and begin at `1`(e.g. `1`, `2`, `3`...). A Front Door Rule with a lesser order value will be applied before a rule with a greater order value.
               
               > **Note:** If the Front Door Rule has an order value of `0` they do not require any conditions and the actions will always be applied.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FrontdoorRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Front Door (standard/premium) Rule.

        !> **Note:** The Rules resource **must** include a `depends_on` meta-argument which references the `cdn.FrontdoorOrigin` and the `cdn.FrontdoorOriginGroup`.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-cdn-frontdoor",
            location="West Europe")
        example_frontdoor_profile = azure.cdn.FrontdoorProfile("example",
            name="example-profile",
            resource_group_name=example.name,
            sku_name="Premium_AzureFrontDoor")
        example_frontdoor_endpoint = azure.cdn.FrontdoorEndpoint("example",
            name="example-endpoint",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            tags={
                "endpoint": "contoso.com",
            })
        example_frontdoor_origin_group = azure.cdn.FrontdoorOriginGroup("example",
            name="example-originGroup",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id,
            session_affinity_enabled=True,
            restore_traffic_time_to_healed_or_new_endpoint_in_minutes=10,
            health_probe={
                "interval_in_seconds": 240,
                "path": "/healthProbe",
                "protocol": "Https",
                "request_type": "GET",
            },
            load_balancing={
                "additional_latency_in_milliseconds": 0,
                "sample_size": 16,
                "successful_samples_required": 3,
            })
        example_frontdoor_origin = azure.cdn.FrontdoorOrigin("example",
            name="example-origin",
            cdn_frontdoor_origin_group_id=example_frontdoor_origin_group.id,
            enabled=True,
            certificate_name_check_enabled=False,
            host_name=example_frontdoor_endpoint.host_name,
            http_port=80,
            https_port=443,
            origin_host_header="contoso.com",
            priority=1,
            weight=500)
        example_frontdoor_rule_set = azure.cdn.FrontdoorRuleSet("example",
            name="exampleruleset",
            cdn_frontdoor_profile_id=example_frontdoor_profile.id)
        example_frontdoor_rule = azure.cdn.FrontdoorRule("example",
            name="examplerule",
            cdn_frontdoor_rule_set_id=example_frontdoor_rule_set.id,
            order=1,
            behavior_on_match="Continue",
            actions={
                "route_configuration_override_action": {
                    "cdn_frontdoor_origin_group_id": example_frontdoor_origin_group.id,
                    "forwarding_protocol": "HttpsOnly",
                    "query_string_caching_behavior": "IncludeSpecifiedQueryStrings",
                    "query_string_parameters": [
                        "foo",
                        "clientIp={client_ip}",
                    ],
                    "compression_enabled": True,
                    "cache_behavior": "OverrideIfOriginMissing",
                    "cache_duration": "365.23:59:59",
                },
                "url_redirect_action": {
                    "redirect_type": "PermanentRedirect",
                    "redirect_protocol": "MatchRequest",
                    "query_string": "clientIp={client_ip}",
                    "destination_path": "/exampleredirection",
                    "destination_hostname": "contoso.com",
                    "destination_fragment": "UrlRedirect",
                },
            },
            conditions={
                "host_name_conditions": [{
                    "operator": "Equal",
                    "negate_condition": False,
                    "match_values": [
                        "www.contoso.com",
                        "images.contoso.com",
                        "video.contoso.com",
                    ],
                    "transforms": [
                        "Lowercase",
                        "Trim",
                    ],
                }],
                "is_device_conditions": [{
                    "operator": "Equal",
                    "negate_condition": False,
                    "match_values": "Mobile",
                }],
                "post_args_conditions": [{
                    "post_args_name": "customerName",
                    "operator": "BeginsWith",
                    "match_values": [
                        "J",
                        "K",
                    ],
                    "transforms": ["Uppercase"],
                }],
                "request_method_conditions": [{
                    "operator": "Equal",
                    "negate_condition": False,
                    "match_values": ["DELETE"],
                }],
                "url_filename_conditions": [{
                    "operator": "Equal",
                    "negate_condition": False,
                    "match_values": ["media.mp4"],
                    "transforms": [
                        "Lowercase",
                        "RemoveNulls",
                        "Trim",
                    ],
                }],
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    example_frontdoor_origin_group,
                    example_frontdoor_origin,
                ]))
        ```

        ## Specifying IP Address Ranges

        When specifying IP address ranges in the `socket_address_condition` and the `remote_address_condition` `match_values` use the following format:

        Use `CIDR` notation when specifying IP address blocks. This means that the syntax for an IP address block is the base IP address followed by a forward slash and the prefix size For example:

        * `IPv4` example: `5.5.5.64/26` matches any requests that arrive from addresses `5.5.5.64` through `5.5.5.127`.
        * `IPv6` example: `1:2:3:/48` matches any requests that arrive from addresses `1:2:3:0:0:0:0:0` through `1:2:3:ffff:ffff:ffff:ffff:ffff`.

        When you specify multiple IP addresses and IP address blocks, `OR` logic is applied.

        * `IPv4` example: if you add two IP addresses `1.2.3.4` and `10.20.30.40`, the condition is matched for any requests that arrive from either address `1.2.3.4` or `10.20.30.40`.
        * `IPv6` example: if you add two IP addresses `1:2:3:4:5:6:7:8` and `10:20:30:40:50:60:70:80`, the condition is matched for any requests that arrive from either address `1:2:3:4:5:6:7:8` or `10:20:30:40:50:60:70:80`.

        ***

        ## Action Server Variables

        Rule Set server variables provide access to structured information about the request. You can use server variables to dynamically change the request/response headers or URL rewrite paths/query strings, for example, when a new page load or when a form is posted.

        ### Supported Action Server Variables

        | Variable name | Description |
        |---------------|-------------|
        | `socket_ip`      | The IP address of the direct connection to Front Door Profiles edge. If the client used an HTTP proxy or a load balancer to send the request, the value of `socket_ip` is the IP address of the proxy or load balancer. |
        | `client_ip`      | The IP address of the client that made the original request. If there was an `X-Forwarded-For` header in the request, then the client IP address is picked from the header. |
        | `client_port`    | The IP port of the client that made the request. |
        | `hostname`       | The host name in the request from the client. |
        | `geo_country`    | Indicates the requester's country/region of origin through its country/region code. |
        | `http_method`    | The method used to make the URL request, such as `GET` or `POST`. |
        | `http_version`   | The request protocol. Usually `HTTP/1.0`, `HTTP/1.1`, or `HTTP/2.0`. |
        | `query_string`   | The list of variable/value pairs that follows the "?" in the requested URL. For example, in the request `http://contoso.com:8080/article.aspx?id=123&title=fabrikam`, the `query_string` value will be `id=123&title=fabrikam`. |
        | `request_scheme` | The request scheme: `http` or `https`. |
        | `request_uri`    | The full original request URI (with arguments). For example, in the request `http://contoso.com:8080/article.aspx?id=123&title=fabrikam`, the `request_uri` value will be `/article.aspx?id=123&title=fabrikam`. |
        | `ssl_protocol`   | The protocol of an established TLS connection. |
        | `server_port`    | The port of the server that accepted a request. |
        | `url_path`       | Identifies the specific resource in the host that the web client wants to access. This is the part of the request URI without the arguments. For example, in the request `http://contoso.com:8080/article.aspx?id=123&title=fabrikam`, the `uri_path` value will be `/article.aspx`. |

        ### Action Server Variable Format

        Server variables can be specified using the following formats:

        * `{variable}` - Include the entire server variable. For example, if the client IP address is `111.222.333.444` then the `{client_ip}` token would evaluate to `111.222.333.444`.

        * `{variable:offset}` - Include the server variable after a specific offset, until the end of the variable. The offset is zero-based. For example, if the client IP address is `111.222.333.444` then the `{client_ip:3}` token would evaluate to `.222.333.444`.

        * `{variable:offset:length}` - Include the server variable after a specific offset, up to the specified length. The offset is zero-based. For example, if the client IP address is `111.222.333.444` then the `{client_ip:4:3}` token would evaluate to `222`.

        ### Action Server Variables Support

        Action Server variables are supported on the following actions:

        * `route_configuration_override_action`
        * `request_header_action`
        * `response_header_action`
        * `url_redirect_action`
        * `url_rewrite_action`

        ***

        ## Condition Operator list

        For rules that accept values from the standard operator list, the following operators are valid:

        | Operator                   | Description | Condition Value |
        |----------------------------|-------------|-----------------|
        | Any                        |Matches when there is any value, regardless of what it is. | Any |
        | Equal                      | Matches when the value exactly matches the specified string. | Equal |
        | Contains                   | Matches when the value contains the specified string. | Contains |
        | Less Than                  | Matches when the length of the value is less than the specified integer. | LessThan |
        | Greater Than               | Matches when the length of the value is greater than the specified integer. | GreaterThan |
        | Less Than or Equal         | Matches when the length of the value is less than or equal to the specified integer. | LessThanOrEqual |
        | Greater Than or Equal      | Matches when the length of the value is greater than or equal to the specified integer. | GreaterThanOrEqual |
        | Begins With                | Matches when the value begins with the specified string. | BeginsWith |
        | Ends With                  | Matches when the value ends with the specified string. | EndsWith |
        | RegEx                      | Matches when the value matches the specified regular expression. See `Condition Regular Expressions` below for more details. | RegEx |
        | Wildcard                   | Matches when the request path matches a wildcard expression. See `Condition Wildcard Expression` below for more details. | Wildcard |
        | Not Any                    | Matches when there is no value. | Any and negateCondition = true |
        | Not Equal                  | Matches when the value does not match the specified string. | Equal and negateCondition : true |
        | Not Contains               | Matches when the value does not contain the specified string. | Contains and negateCondition = true |
        | Not Less Than              | Matches when the length of the value is not less than the specified integer. | LessThan and negateCondition = true |
        | Not Greater Than           | Matches when the length of the value is not greater than the specified integer. | GreaterThan and negateCondition = true |
        | Not Less Than or Equal     | Matches when the length of the value is not less than or equal to the specified integer. | LessThanOrEqual and negateCondition = true |
        | Not Greater Than or Equals | Matches when the length of the value is not greater than or equal to the specified integer. | GreaterThanOrEqual and negateCondition = true |
        | Not Begins With            | Matches when the value does not begin with the specified string. | BeginsWith and negateCondition = true |
        | Not Ends With              | Matches when the value does not end with the specified string. | EndsWith and negateCondition = true |
        | Not RegEx                  | Matches when the value does not match the specified regular expression. See `Condition Regular Expressions` for more details. | RegEx and negateCondition = true |
        | Not Wildcard               | Matches when the request path does not match a wildcard expression. See `Condition Wildcard Expression` below for more details. | Wildcard and negateCondition = true |

        ***

        ## Condition Regular Expressions

        Regular expressions **don't** support the following operations:

        * Backreferences and capturing subexpressions.
        * Arbitrary zero-width assertions.
        * Subroutine references and recursive patterns.
        * Conditional patterns.
        * Backtracking control verbs.
        * The `\\C` single-byte directive.
        * The `\\R` newline match directive.
        * The `\\K` start of match reset directive.
        * Callouts and embedded code.
        * Atomic grouping and possessive quantifiers.

        ## Condition Wildcard Expression

        A wildcard expression can include the * character to match zero or more characters within the path. For example, the wildcard expression `files/customer*/file.pdf` matches the paths `files/customer1/file.pdf`, `files/customer109/file.pdf`, and `files/customer/file.pdf`, but doesn't match `files/customer2/anotherfile.pdf`.

        ***

        ## Condition Transform List

        For rules that can transform strings, the following transforms are valid:

        | Transform   | Description |
        |-------------|-------------|
        | Lowercase   | Converts the string to the lowercase representation. |
        | Uppercase   | Converts the string to the uppercase representation. |
        | Trim        | Trims leading and trailing whitespace from the string. |
        | RemoveNulls | Removes null values from the string. |
        | URLEncode   | URL-encodes the string. |
        | URLDecode   | URL-decodes the string. |

        ***

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Cdn` - 2024-09-01

        ## Import

        Front Door Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cdn/frontdoorRule:FrontdoorRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Cdn/profiles/profile1/ruleSets/ruleSet1/rules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param FrontdoorRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FrontdoorRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Union['FrontdoorRuleActionsArgs', 'FrontdoorRuleActionsArgsDict']]] = None,
                 behavior_on_match: Optional[pulumi.Input[_builtins.str]] = None,
                 cdn_frontdoor_rule_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 conditions: Optional[pulumi.Input[Union['FrontdoorRuleConditionsArgs', 'FrontdoorRuleConditionsArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 order: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FrontdoorRuleArgs.__new__(FrontdoorRuleArgs)

            if actions is None and not opts.urn:
                raise TypeError("Missing required property 'actions'")
            __props__.__dict__["actions"] = actions
            __props__.__dict__["behavior_on_match"] = behavior_on_match
            if cdn_frontdoor_rule_set_id is None and not opts.urn:
                raise TypeError("Missing required property 'cdn_frontdoor_rule_set_id'")
            __props__.__dict__["cdn_frontdoor_rule_set_id"] = cdn_frontdoor_rule_set_id
            __props__.__dict__["conditions"] = conditions
            __props__.__dict__["name"] = name
            if order is None and not opts.urn:
                raise TypeError("Missing required property 'order'")
            __props__.__dict__["order"] = order
            __props__.__dict__["cdn_frontdoor_rule_set_name"] = None
        super(FrontdoorRule, __self__).__init__(
            'azure:cdn/frontdoorRule:FrontdoorRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions: Optional[pulumi.Input[Union['FrontdoorRuleActionsArgs', 'FrontdoorRuleActionsArgsDict']]] = None,
            behavior_on_match: Optional[pulumi.Input[_builtins.str]] = None,
            cdn_frontdoor_rule_set_id: Optional[pulumi.Input[_builtins.str]] = None,
            cdn_frontdoor_rule_set_name: Optional[pulumi.Input[_builtins.str]] = None,
            conditions: Optional[pulumi.Input[Union['FrontdoorRuleConditionsArgs', 'FrontdoorRuleConditionsArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            order: Optional[pulumi.Input[_builtins.int]] = None) -> 'FrontdoorRule':
        """
        Get an existing FrontdoorRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['FrontdoorRuleActionsArgs', 'FrontdoorRuleActionsArgsDict']] actions: An `actions` block as defined below.
        :param pulumi.Input[_builtins.str] behavior_on_match: If this rule is a match should the rules engine continue processing the remaining rules or stop? Possible values are `Continue` and `Stop`. Defaults to `Continue`.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_rule_set_id: The resource ID of the Front Door Rule Set for this Front Door Rule. Changing this forces a new Front Door Rule to be created.
        :param pulumi.Input[_builtins.str] cdn_frontdoor_rule_set_name: The name of the Front Door Rule Set containing this Front Door Rule.
        :param pulumi.Input[Union['FrontdoorRuleConditionsArgs', 'FrontdoorRuleConditionsArgsDict']] conditions: A `conditions` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Front Door Rule. Possible values must be between 1 and 260 characters in length, begin with a letter and may contain only letters and numbers. Changing this forces a new Front Door Rule to be created.
        :param pulumi.Input[_builtins.int] order: The order in which the rules will be applied for the Front Door Endpoint. The order value should be sequential and begin at `1`(e.g. `1`, `2`, `3`...). A Front Door Rule with a lesser order value will be applied before a rule with a greater order value.
               
               > **Note:** If the Front Door Rule has an order value of `0` they do not require any conditions and the actions will always be applied.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FrontdoorRuleState.__new__(_FrontdoorRuleState)

        __props__.__dict__["actions"] = actions
        __props__.__dict__["behavior_on_match"] = behavior_on_match
        __props__.__dict__["cdn_frontdoor_rule_set_id"] = cdn_frontdoor_rule_set_id
        __props__.__dict__["cdn_frontdoor_rule_set_name"] = cdn_frontdoor_rule_set_name
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["name"] = name
        __props__.__dict__["order"] = order
        return FrontdoorRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> pulumi.Output['outputs.FrontdoorRuleActions']:
        """
        An `actions` block as defined below.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter(name="behaviorOnMatch")
    def behavior_on_match(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If this rule is a match should the rules engine continue processing the remaining rules or stop? Possible values are `Continue` and `Stop`. Defaults to `Continue`.
        """
        return pulumi.get(self, "behavior_on_match")

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorRuleSetId")
    def cdn_frontdoor_rule_set_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource ID of the Front Door Rule Set for this Front Door Rule. Changing this forces a new Front Door Rule to be created.
        """
        return pulumi.get(self, "cdn_frontdoor_rule_set_id")

    @_builtins.property
    @pulumi.getter(name="cdnFrontdoorRuleSetName")
    def cdn_frontdoor_rule_set_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Front Door Rule Set containing this Front Door Rule.
        """
        return pulumi.get(self, "cdn_frontdoor_rule_set_name")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Optional['outputs.FrontdoorRuleConditions']]:
        """
        A `conditions` block as defined below.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Front Door Rule. Possible values must be between 1 and 260 characters in length, begin with a letter and may contain only letters and numbers. Changing this forces a new Front Door Rule to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def order(self) -> pulumi.Output[_builtins.int]:
        """
        The order in which the rules will be applied for the Front Door Endpoint. The order value should be sequential and begin at `1`(e.g. `1`, `2`, `3`...). A Front Door Rule with a lesser order value will be applied before a rule with a greater order value.

        > **Note:** If the Front Door Rule has an order value of `0` they do not require any conditions and the actions will always be applied.
        """
        return pulumi.get(self, "order")

