# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectedRegistryArgs', 'ConnectedRegistry']

@pulumi.input_type
class ConnectedRegistryArgs:
    def __init__(__self__, *,
                 container_registry_id: pulumi.Input[_builtins.str],
                 sync_token_id: pulumi.Input[_builtins.str],
                 audit_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_token_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_level: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectedRegistryNotificationArgs']]]] = None,
                 parent_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_message_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_window: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ConnectedRegistry resource.
        :param pulumi.Input[_builtins.str] container_registry_id: The ID of the Container Registry that this Connected Registry will reside in. Changing this forces a new Container Connected Registry to be created.
               
               > **Note:** If `parent_registry_id` is not specified, the Connected Registry will be connected to the Container Registry identified by `container_registry_id`.
        :param pulumi.Input[_builtins.str] sync_token_id: The ID of the Container Registry Token which is used for synchronizing the Connected Registry. Changing this forces a new Container Connected Registry to be created.
        :param pulumi.Input[_builtins.bool] audit_log_enabled: Should the log auditing be enabled?
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] client_token_ids: Specifies a list of IDs of Container Registry Tokens, which are meant to be used by the clients to connect to the Connected Registry.
        :param pulumi.Input[_builtins.str] log_level: The verbosity of the logs. Possible values are `None`, `Debug`, `Information`, `Warning` and `Error`. Defaults to `None`.
        :param pulumi.Input[_builtins.str] mode: The mode of the Connected Registry. Possible values are `Mirror`, `ReadOnly`, `ReadWrite` and `Registry`. Changing this forces a new Container Connected Registry to be created. Defaults to `ReadWrite`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Container Connected Registry. Changing this forces a new Container Connected Registry to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectedRegistryNotificationArgs']]] notifications: One or more `notification` blocks as defined below.
        :param pulumi.Input[_builtins.str] parent_registry_id: The ID of the parent registry. This can be either a Container Registry ID or a Connected Registry ID. Changing this forces a new Container Connected Registry to be created.
        :param pulumi.Input[_builtins.str] sync_message_ttl: The period of time (in form of ISO8601) for which a message is available to sync before it is expired. Allowed range is from `P1D` to `P90D`. Defaults to `P1D`.
        :param pulumi.Input[_builtins.str] sync_schedule: The cron expression indicating the schedule that the Connected Registry will sync with its parent. Defaults to `* * * * *`.
        :param pulumi.Input[_builtins.str] sync_window: The time window (in form of ISO8601) during which sync is enabled for each schedule occurrence. Allowed range is from `PT3H` to `P7D`.
        """
        pulumi.set(__self__, "container_registry_id", container_registry_id)
        pulumi.set(__self__, "sync_token_id", sync_token_id)
        if audit_log_enabled is not None:
            pulumi.set(__self__, "audit_log_enabled", audit_log_enabled)
        if client_token_ids is not None:
            pulumi.set(__self__, "client_token_ids", client_token_ids)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if parent_registry_id is not None:
            pulumi.set(__self__, "parent_registry_id", parent_registry_id)
        if sync_message_ttl is not None:
            pulumi.set(__self__, "sync_message_ttl", sync_message_ttl)
        if sync_schedule is not None:
            pulumi.set(__self__, "sync_schedule", sync_schedule)
        if sync_window is not None:
            pulumi.set(__self__, "sync_window", sync_window)

    @_builtins.property
    @pulumi.getter(name="containerRegistryId")
    def container_registry_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Container Registry that this Connected Registry will reside in. Changing this forces a new Container Connected Registry to be created.

        > **Note:** If `parent_registry_id` is not specified, the Connected Registry will be connected to the Container Registry identified by `container_registry_id`.
        """
        return pulumi.get(self, "container_registry_id")

    @container_registry_id.setter
    def container_registry_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "container_registry_id", value)

    @_builtins.property
    @pulumi.getter(name="syncTokenId")
    def sync_token_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Container Registry Token which is used for synchronizing the Connected Registry. Changing this forces a new Container Connected Registry to be created.
        """
        return pulumi.get(self, "sync_token_id")

    @sync_token_id.setter
    def sync_token_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sync_token_id", value)

    @_builtins.property
    @pulumi.getter(name="auditLogEnabled")
    def audit_log_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the log auditing be enabled?
        """
        return pulumi.get(self, "audit_log_enabled")

    @audit_log_enabled.setter
    def audit_log_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "audit_log_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clientTokenIds")
    def client_token_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of IDs of Container Registry Tokens, which are meant to be used by the clients to connect to the Connected Registry.
        """
        return pulumi.get(self, "client_token_ids")

    @client_token_ids.setter
    def client_token_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "client_token_ids", value)

    @_builtins.property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The verbosity of the logs. Possible values are `None`, `Debug`, `Information`, `Warning` and `Error`. Defaults to `None`.
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_level", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode of the Connected Registry. Possible values are `Mirror`, `ReadOnly`, `ReadWrite` and `Registry`. Changing this forces a new Container Connected Registry to be created. Defaults to `ReadWrite`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Container Connected Registry. Changing this forces a new Container Connected Registry to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectedRegistryNotificationArgs']]]]:
        """
        One or more `notification` blocks as defined below.
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectedRegistryNotificationArgs']]]]):
        pulumi.set(self, "notifications", value)

    @_builtins.property
    @pulumi.getter(name="parentRegistryId")
    def parent_registry_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the parent registry. This can be either a Container Registry ID or a Connected Registry ID. Changing this forces a new Container Connected Registry to be created.
        """
        return pulumi.get(self, "parent_registry_id")

    @parent_registry_id.setter
    def parent_registry_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_registry_id", value)

    @_builtins.property
    @pulumi.getter(name="syncMessageTtl")
    def sync_message_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The period of time (in form of ISO8601) for which a message is available to sync before it is expired. Allowed range is from `P1D` to `P90D`. Defaults to `P1D`.
        """
        return pulumi.get(self, "sync_message_ttl")

    @sync_message_ttl.setter
    def sync_message_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_message_ttl", value)

    @_builtins.property
    @pulumi.getter(name="syncSchedule")
    def sync_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cron expression indicating the schedule that the Connected Registry will sync with its parent. Defaults to `* * * * *`.
        """
        return pulumi.get(self, "sync_schedule")

    @sync_schedule.setter
    def sync_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_schedule", value)

    @_builtins.property
    @pulumi.getter(name="syncWindow")
    def sync_window(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time window (in form of ISO8601) during which sync is enabled for each schedule occurrence. Allowed range is from `PT3H` to `P7D`.
        """
        return pulumi.get(self, "sync_window")

    @sync_window.setter
    def sync_window(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_window", value)


@pulumi.input_type
class _ConnectedRegistryState:
    def __init__(__self__, *,
                 audit_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_token_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 container_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_level: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectedRegistryNotificationArgs']]]] = None,
                 parent_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_message_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_token_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_window: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ConnectedRegistry resources.
        :param pulumi.Input[_builtins.bool] audit_log_enabled: Should the log auditing be enabled?
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] client_token_ids: Specifies a list of IDs of Container Registry Tokens, which are meant to be used by the clients to connect to the Connected Registry.
        :param pulumi.Input[_builtins.str] container_registry_id: The ID of the Container Registry that this Connected Registry will reside in. Changing this forces a new Container Connected Registry to be created.
               
               > **Note:** If `parent_registry_id` is not specified, the Connected Registry will be connected to the Container Registry identified by `container_registry_id`.
        :param pulumi.Input[_builtins.str] log_level: The verbosity of the logs. Possible values are `None`, `Debug`, `Information`, `Warning` and `Error`. Defaults to `None`.
        :param pulumi.Input[_builtins.str] mode: The mode of the Connected Registry. Possible values are `Mirror`, `ReadOnly`, `ReadWrite` and `Registry`. Changing this forces a new Container Connected Registry to be created. Defaults to `ReadWrite`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Container Connected Registry. Changing this forces a new Container Connected Registry to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectedRegistryNotificationArgs']]] notifications: One or more `notification` blocks as defined below.
        :param pulumi.Input[_builtins.str] parent_registry_id: The ID of the parent registry. This can be either a Container Registry ID or a Connected Registry ID. Changing this forces a new Container Connected Registry to be created.
        :param pulumi.Input[_builtins.str] sync_message_ttl: The period of time (in form of ISO8601) for which a message is available to sync before it is expired. Allowed range is from `P1D` to `P90D`. Defaults to `P1D`.
        :param pulumi.Input[_builtins.str] sync_schedule: The cron expression indicating the schedule that the Connected Registry will sync with its parent. Defaults to `* * * * *`.
        :param pulumi.Input[_builtins.str] sync_token_id: The ID of the Container Registry Token which is used for synchronizing the Connected Registry. Changing this forces a new Container Connected Registry to be created.
        :param pulumi.Input[_builtins.str] sync_window: The time window (in form of ISO8601) during which sync is enabled for each schedule occurrence. Allowed range is from `PT3H` to `P7D`.
        """
        if audit_log_enabled is not None:
            pulumi.set(__self__, "audit_log_enabled", audit_log_enabled)
        if client_token_ids is not None:
            pulumi.set(__self__, "client_token_ids", client_token_ids)
        if container_registry_id is not None:
            pulumi.set(__self__, "container_registry_id", container_registry_id)
        if log_level is not None:
            pulumi.set(__self__, "log_level", log_level)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if parent_registry_id is not None:
            pulumi.set(__self__, "parent_registry_id", parent_registry_id)
        if sync_message_ttl is not None:
            pulumi.set(__self__, "sync_message_ttl", sync_message_ttl)
        if sync_schedule is not None:
            pulumi.set(__self__, "sync_schedule", sync_schedule)
        if sync_token_id is not None:
            pulumi.set(__self__, "sync_token_id", sync_token_id)
        if sync_window is not None:
            pulumi.set(__self__, "sync_window", sync_window)

    @_builtins.property
    @pulumi.getter(name="auditLogEnabled")
    def audit_log_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the log auditing be enabled?
        """
        return pulumi.get(self, "audit_log_enabled")

    @audit_log_enabled.setter
    def audit_log_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "audit_log_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clientTokenIds")
    def client_token_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of IDs of Container Registry Tokens, which are meant to be used by the clients to connect to the Connected Registry.
        """
        return pulumi.get(self, "client_token_ids")

    @client_token_ids.setter
    def client_token_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "client_token_ids", value)

    @_builtins.property
    @pulumi.getter(name="containerRegistryId")
    def container_registry_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Container Registry that this Connected Registry will reside in. Changing this forces a new Container Connected Registry to be created.

        > **Note:** If `parent_registry_id` is not specified, the Connected Registry will be connected to the Container Registry identified by `container_registry_id`.
        """
        return pulumi.get(self, "container_registry_id")

    @container_registry_id.setter
    def container_registry_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_registry_id", value)

    @_builtins.property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The verbosity of the logs. Possible values are `None`, `Debug`, `Information`, `Warning` and `Error`. Defaults to `None`.
        """
        return pulumi.get(self, "log_level")

    @log_level.setter
    def log_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_level", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode of the Connected Registry. Possible values are `Mirror`, `ReadOnly`, `ReadWrite` and `Registry`. Changing this forces a new Container Connected Registry to be created. Defaults to `ReadWrite`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Container Connected Registry. Changing this forces a new Container Connected Registry to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectedRegistryNotificationArgs']]]]:
        """
        One or more `notification` blocks as defined below.
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectedRegistryNotificationArgs']]]]):
        pulumi.set(self, "notifications", value)

    @_builtins.property
    @pulumi.getter(name="parentRegistryId")
    def parent_registry_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the parent registry. This can be either a Container Registry ID or a Connected Registry ID. Changing this forces a new Container Connected Registry to be created.
        """
        return pulumi.get(self, "parent_registry_id")

    @parent_registry_id.setter
    def parent_registry_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_registry_id", value)

    @_builtins.property
    @pulumi.getter(name="syncMessageTtl")
    def sync_message_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The period of time (in form of ISO8601) for which a message is available to sync before it is expired. Allowed range is from `P1D` to `P90D`. Defaults to `P1D`.
        """
        return pulumi.get(self, "sync_message_ttl")

    @sync_message_ttl.setter
    def sync_message_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_message_ttl", value)

    @_builtins.property
    @pulumi.getter(name="syncSchedule")
    def sync_schedule(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cron expression indicating the schedule that the Connected Registry will sync with its parent. Defaults to `* * * * *`.
        """
        return pulumi.get(self, "sync_schedule")

    @sync_schedule.setter
    def sync_schedule(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_schedule", value)

    @_builtins.property
    @pulumi.getter(name="syncTokenId")
    def sync_token_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Container Registry Token which is used for synchronizing the Connected Registry. Changing this forces a new Container Connected Registry to be created.
        """
        return pulumi.get(self, "sync_token_id")

    @sync_token_id.setter
    def sync_token_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_token_id", value)

    @_builtins.property
    @pulumi.getter(name="syncWindow")
    def sync_window(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time window (in form of ISO8601) during which sync is enabled for each schedule occurrence. Allowed range is from `PT3H` to `P7D`.
        """
        return pulumi.get(self, "sync_window")

    @sync_window.setter
    def sync_window(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sync_window", value)


@pulumi.type_token("azure:containerservice/connectedRegistry:ConnectedRegistry")
class ConnectedRegistry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_token_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 container_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_level: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectedRegistryNotificationArgs', 'ConnectedRegistryNotificationArgsDict']]]]] = None,
                 parent_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_message_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_token_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_window: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Container Connected Registry.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_registry = azure.containerservice.Registry("example",
            name="exampleacr",
            resource_group_name=example.name,
            location=example.location,
            sku="Premium",
            data_endpoint_enabled=True)
        example_registry_scope_map = azure.containerservice.RegistryScopeMap("example",
            name="examplescopemap",
            container_registry_name=example_registry.name,
            resource_group_name=example_registry.resource_group_name,
            actions=[
                "repositories/hello-world/content/delete",
                "repositories/hello-world/content/read",
                "repositories/hello-world/content/write",
                "repositories/hello-world/metadata/read",
                "repositories/hello-world/metadata/write",
                "gateway/examplecr/config/read",
                "gateway/examplecr/config/write",
                "gateway/examplecr/message/read",
                "gateway/examplecr/message/write",
            ])
        example_registry_token = azure.containerservice.RegistryToken("example",
            name="exampletoken",
            container_registry_name=example_registry.name,
            resource_group_name=example_registry.resource_group_name,
            scope_map_id=example_registry_scope_map.id)
        example_connected_registry = azure.containerservice.ConnectedRegistry("example",
            name="examplecr",
            container_registry_id=example_registry.id,
            sync_token_id=example_registry_token.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerRegistry` - 2023-11-01-preview

        ## Import

        Container Connected Registries can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/connectedRegistry:ConnectedRegistry example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.ContainerRegistry/registries/registry1/connectedRegistries/registry1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] audit_log_enabled: Should the log auditing be enabled?
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] client_token_ids: Specifies a list of IDs of Container Registry Tokens, which are meant to be used by the clients to connect to the Connected Registry.
        :param pulumi.Input[_builtins.str] container_registry_id: The ID of the Container Registry that this Connected Registry will reside in. Changing this forces a new Container Connected Registry to be created.
               
               > **Note:** If `parent_registry_id` is not specified, the Connected Registry will be connected to the Container Registry identified by `container_registry_id`.
        :param pulumi.Input[_builtins.str] log_level: The verbosity of the logs. Possible values are `None`, `Debug`, `Information`, `Warning` and `Error`. Defaults to `None`.
        :param pulumi.Input[_builtins.str] mode: The mode of the Connected Registry. Possible values are `Mirror`, `ReadOnly`, `ReadWrite` and `Registry`. Changing this forces a new Container Connected Registry to be created. Defaults to `ReadWrite`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Container Connected Registry. Changing this forces a new Container Connected Registry to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectedRegistryNotificationArgs', 'ConnectedRegistryNotificationArgsDict']]]] notifications: One or more `notification` blocks as defined below.
        :param pulumi.Input[_builtins.str] parent_registry_id: The ID of the parent registry. This can be either a Container Registry ID or a Connected Registry ID. Changing this forces a new Container Connected Registry to be created.
        :param pulumi.Input[_builtins.str] sync_message_ttl: The period of time (in form of ISO8601) for which a message is available to sync before it is expired. Allowed range is from `P1D` to `P90D`. Defaults to `P1D`.
        :param pulumi.Input[_builtins.str] sync_schedule: The cron expression indicating the schedule that the Connected Registry will sync with its parent. Defaults to `* * * * *`.
        :param pulumi.Input[_builtins.str] sync_token_id: The ID of the Container Registry Token which is used for synchronizing the Connected Registry. Changing this forces a new Container Connected Registry to be created.
        :param pulumi.Input[_builtins.str] sync_window: The time window (in form of ISO8601) during which sync is enabled for each schedule occurrence. Allowed range is from `PT3H` to `P7D`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectedRegistryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Container Connected Registry.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_registry = azure.containerservice.Registry("example",
            name="exampleacr",
            resource_group_name=example.name,
            location=example.location,
            sku="Premium",
            data_endpoint_enabled=True)
        example_registry_scope_map = azure.containerservice.RegistryScopeMap("example",
            name="examplescopemap",
            container_registry_name=example_registry.name,
            resource_group_name=example_registry.resource_group_name,
            actions=[
                "repositories/hello-world/content/delete",
                "repositories/hello-world/content/read",
                "repositories/hello-world/content/write",
                "repositories/hello-world/metadata/read",
                "repositories/hello-world/metadata/write",
                "gateway/examplecr/config/read",
                "gateway/examplecr/config/write",
                "gateway/examplecr/message/read",
                "gateway/examplecr/message/write",
            ])
        example_registry_token = azure.containerservice.RegistryToken("example",
            name="exampletoken",
            container_registry_name=example_registry.name,
            resource_group_name=example_registry.resource_group_name,
            scope_map_id=example_registry_scope_map.id)
        example_connected_registry = azure.containerservice.ConnectedRegistry("example",
            name="examplecr",
            container_registry_id=example_registry.id,
            sync_token_id=example_registry_token.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerRegistry` - 2023-11-01-preview

        ## Import

        Container Connected Registries can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/connectedRegistry:ConnectedRegistry example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.ContainerRegistry/registries/registry1/connectedRegistries/registry1
        ```

        :param str resource_name: The name of the resource.
        :param ConnectedRegistryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectedRegistryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_token_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 container_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 log_level: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectedRegistryNotificationArgs', 'ConnectedRegistryNotificationArgsDict']]]]] = None,
                 parent_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_message_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_schedule: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_token_id: Optional[pulumi.Input[_builtins.str]] = None,
                 sync_window: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectedRegistryArgs.__new__(ConnectedRegistryArgs)

            __props__.__dict__["audit_log_enabled"] = audit_log_enabled
            __props__.__dict__["client_token_ids"] = client_token_ids
            if container_registry_id is None and not opts.urn:
                raise TypeError("Missing required property 'container_registry_id'")
            __props__.__dict__["container_registry_id"] = container_registry_id
            __props__.__dict__["log_level"] = log_level
            __props__.__dict__["mode"] = mode
            __props__.__dict__["name"] = name
            __props__.__dict__["notifications"] = notifications
            __props__.__dict__["parent_registry_id"] = parent_registry_id
            __props__.__dict__["sync_message_ttl"] = sync_message_ttl
            __props__.__dict__["sync_schedule"] = sync_schedule
            if sync_token_id is None and not opts.urn:
                raise TypeError("Missing required property 'sync_token_id'")
            __props__.__dict__["sync_token_id"] = sync_token_id
            __props__.__dict__["sync_window"] = sync_window
        super(ConnectedRegistry, __self__).__init__(
            'azure:containerservice/connectedRegistry:ConnectedRegistry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audit_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            client_token_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            container_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
            log_level: Optional[pulumi.Input[_builtins.str]] = None,
            mode: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            notifications: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectedRegistryNotificationArgs', 'ConnectedRegistryNotificationArgsDict']]]]] = None,
            parent_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
            sync_message_ttl: Optional[pulumi.Input[_builtins.str]] = None,
            sync_schedule: Optional[pulumi.Input[_builtins.str]] = None,
            sync_token_id: Optional[pulumi.Input[_builtins.str]] = None,
            sync_window: Optional[pulumi.Input[_builtins.str]] = None) -> 'ConnectedRegistry':
        """
        Get an existing ConnectedRegistry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] audit_log_enabled: Should the log auditing be enabled?
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] client_token_ids: Specifies a list of IDs of Container Registry Tokens, which are meant to be used by the clients to connect to the Connected Registry.
        :param pulumi.Input[_builtins.str] container_registry_id: The ID of the Container Registry that this Connected Registry will reside in. Changing this forces a new Container Connected Registry to be created.
               
               > **Note:** If `parent_registry_id` is not specified, the Connected Registry will be connected to the Container Registry identified by `container_registry_id`.
        :param pulumi.Input[_builtins.str] log_level: The verbosity of the logs. Possible values are `None`, `Debug`, `Information`, `Warning` and `Error`. Defaults to `None`.
        :param pulumi.Input[_builtins.str] mode: The mode of the Connected Registry. Possible values are `Mirror`, `ReadOnly`, `ReadWrite` and `Registry`. Changing this forces a new Container Connected Registry to be created. Defaults to `ReadWrite`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Container Connected Registry. Changing this forces a new Container Connected Registry to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectedRegistryNotificationArgs', 'ConnectedRegistryNotificationArgsDict']]]] notifications: One or more `notification` blocks as defined below.
        :param pulumi.Input[_builtins.str] parent_registry_id: The ID of the parent registry. This can be either a Container Registry ID or a Connected Registry ID. Changing this forces a new Container Connected Registry to be created.
        :param pulumi.Input[_builtins.str] sync_message_ttl: The period of time (in form of ISO8601) for which a message is available to sync before it is expired. Allowed range is from `P1D` to `P90D`. Defaults to `P1D`.
        :param pulumi.Input[_builtins.str] sync_schedule: The cron expression indicating the schedule that the Connected Registry will sync with its parent. Defaults to `* * * * *`.
        :param pulumi.Input[_builtins.str] sync_token_id: The ID of the Container Registry Token which is used for synchronizing the Connected Registry. Changing this forces a new Container Connected Registry to be created.
        :param pulumi.Input[_builtins.str] sync_window: The time window (in form of ISO8601) during which sync is enabled for each schedule occurrence. Allowed range is from `PT3H` to `P7D`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectedRegistryState.__new__(_ConnectedRegistryState)

        __props__.__dict__["audit_log_enabled"] = audit_log_enabled
        __props__.__dict__["client_token_ids"] = client_token_ids
        __props__.__dict__["container_registry_id"] = container_registry_id
        __props__.__dict__["log_level"] = log_level
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["notifications"] = notifications
        __props__.__dict__["parent_registry_id"] = parent_registry_id
        __props__.__dict__["sync_message_ttl"] = sync_message_ttl
        __props__.__dict__["sync_schedule"] = sync_schedule
        __props__.__dict__["sync_token_id"] = sync_token_id
        __props__.__dict__["sync_window"] = sync_window
        return ConnectedRegistry(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="auditLogEnabled")
    def audit_log_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the log auditing be enabled?
        """
        return pulumi.get(self, "audit_log_enabled")

    @_builtins.property
    @pulumi.getter(name="clientTokenIds")
    def client_token_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of IDs of Container Registry Tokens, which are meant to be used by the clients to connect to the Connected Registry.
        """
        return pulumi.get(self, "client_token_ids")

    @_builtins.property
    @pulumi.getter(name="containerRegistryId")
    def container_registry_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Container Registry that this Connected Registry will reside in. Changing this forces a new Container Connected Registry to be created.

        > **Note:** If `parent_registry_id` is not specified, the Connected Registry will be connected to the Container Registry identified by `container_registry_id`.
        """
        return pulumi.get(self, "container_registry_id")

    @_builtins.property
    @pulumi.getter(name="logLevel")
    def log_level(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The verbosity of the logs. Possible values are `None`, `Debug`, `Information`, `Warning` and `Error`. Defaults to `None`.
        """
        return pulumi.get(self, "log_level")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The mode of the Connected Registry. Possible values are `Mirror`, `ReadOnly`, `ReadWrite` and `Registry`. Changing this forces a new Container Connected Registry to be created. Defaults to `ReadWrite`.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Container Connected Registry. Changing this forces a new Container Connected Registry to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> pulumi.Output[Optional[Sequence['outputs.ConnectedRegistryNotification']]]:
        """
        One or more `notification` blocks as defined below.
        """
        return pulumi.get(self, "notifications")

    @_builtins.property
    @pulumi.getter(name="parentRegistryId")
    def parent_registry_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the parent registry. This can be either a Container Registry ID or a Connected Registry ID. Changing this forces a new Container Connected Registry to be created.
        """
        return pulumi.get(self, "parent_registry_id")

    @_builtins.property
    @pulumi.getter(name="syncMessageTtl")
    def sync_message_ttl(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The period of time (in form of ISO8601) for which a message is available to sync before it is expired. Allowed range is from `P1D` to `P90D`. Defaults to `P1D`.
        """
        return pulumi.get(self, "sync_message_ttl")

    @_builtins.property
    @pulumi.getter(name="syncSchedule")
    def sync_schedule(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The cron expression indicating the schedule that the Connected Registry will sync with its parent. Defaults to `* * * * *`.
        """
        return pulumi.get(self, "sync_schedule")

    @_builtins.property
    @pulumi.getter(name="syncTokenId")
    def sync_token_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Container Registry Token which is used for synchronizing the Connected Registry. Changing this forces a new Container Connected Registry to be created.
        """
        return pulumi.get(self, "sync_token_id")

    @_builtins.property
    @pulumi.getter(name="syncWindow")
    def sync_window(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The time window (in form of ISO8601) during which sync is enabled for each schedule occurrence. Allowed range is from `PT3H` to `P7D`.
        """
        return pulumi.get(self, "sync_window")

