# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ResourceGroupPolicyAssignmentArgs', 'ResourceGroupPolicyAssignment']

@pulumi.input_type
class ResourceGroupPolicyAssignmentArgs:
    def __init__(__self__, *,
                 policy_definition_id: pulumi.Input[_builtins.str],
                 resource_group_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enforce: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['ResourceGroupPolicyAssignmentIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 non_compliance_messages: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceGroupPolicyAssignmentNonComplianceMessageArgs']]]] = None,
                 not_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 overrides: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceGroupPolicyAssignmentOverrideArgs']]]] = None,
                 parameters: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_selectors: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceGroupPolicyAssignmentResourceSelectorArgs']]]] = None):
        """
        The set of arguments for constructing a ResourceGroupPolicyAssignment resource.
        :param pulumi.Input[_builtins.str] policy_definition_id: The ID of the Policy Definition or Policy Definition Set. Changing this forces a new Policy Assignment to be created.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the Resource Group where this Policy Assignment should be created. Changing this forces a new Policy Assignment to be created.
        :param pulumi.Input[_builtins.str] description: A description which should be used for this Policy Assignment.
        :param pulumi.Input[_builtins.str] display_name: The Display Name for this Policy Assignment.
        :param pulumi.Input[_builtins.bool] enforce: Specifies if this Policy should be enforced or not? Defaults to `true`.
        :param pulumi.Input['ResourceGroupPolicyAssignmentIdentityArgs'] identity: An `identity` block as defined below.
               
               > **Note:** The `location` field must also be specified when `identity` is specified.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Policy Assignment should exist. Changing this forces a new Policy Assignment to be created.
        :param pulumi.Input[_builtins.str] metadata: A JSON mapping of any Metadata for this Policy.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Policy Assignment. Changing this forces a new Policy Assignment to be created. Cannot exceed 64 characters in length.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceGroupPolicyAssignmentNonComplianceMessageArgs']]] non_compliance_messages: One or more `non_compliance_message` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] not_scopes: Specifies a list of Resource Scopes (for example a Subscription, or a Resource Group) within this Management Group which are excluded from this Policy.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceGroupPolicyAssignmentOverrideArgs']]] overrides: One or more `overrides` blocks as defined below. More detail about `overrides` and `resource_selectors` see [policy assignment structure](https://learn.microsoft.com/en-us/azure/governance/policy/concepts/assignment-structure#resource-selectors-preview)
        :param pulumi.Input[_builtins.str] parameters: A JSON mapping of any Parameters for this Policy.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceGroupPolicyAssignmentResourceSelectorArgs']]] resource_selectors: One or more `resource_selectors` blocks as defined below to filter polices by resource properties.
        """
        pulumi.set(__self__, "policy_definition_id", policy_definition_id)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enforce is not None:
            pulumi.set(__self__, "enforce", enforce)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if non_compliance_messages is not None:
            pulumi.set(__self__, "non_compliance_messages", non_compliance_messages)
        if not_scopes is not None:
            pulumi.set(__self__, "not_scopes", not_scopes)
        if overrides is not None:
            pulumi.set(__self__, "overrides", overrides)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if resource_selectors is not None:
            pulumi.set(__self__, "resource_selectors", resource_selectors)

    @_builtins.property
    @pulumi.getter(name="policyDefinitionId")
    def policy_definition_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Policy Definition or Policy Definition Set. Changing this forces a new Policy Assignment to be created.
        """
        return pulumi.get(self, "policy_definition_id")

    @policy_definition_id.setter
    def policy_definition_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_definition_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Resource Group where this Policy Assignment should be created. Changing this forces a new Policy Assignment to be created.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description which should be used for this Policy Assignment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Display Name for this Policy Assignment.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def enforce(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if this Policy should be enforced or not? Defaults to `true`.
        """
        return pulumi.get(self, "enforce")

    @enforce.setter
    def enforce(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enforce", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ResourceGroupPolicyAssignmentIdentityArgs']]:
        """
        An `identity` block as defined below.

        > **Note:** The `location` field must also be specified when `identity` is specified.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ResourceGroupPolicyAssignmentIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Policy Assignment should exist. Changing this forces a new Policy Assignment to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A JSON mapping of any Metadata for this Policy.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Policy Assignment. Changing this forces a new Policy Assignment to be created. Cannot exceed 64 characters in length.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nonComplianceMessages")
    def non_compliance_messages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceGroupPolicyAssignmentNonComplianceMessageArgs']]]]:
        """
        One or more `non_compliance_message` blocks as defined below.
        """
        return pulumi.get(self, "non_compliance_messages")

    @non_compliance_messages.setter
    def non_compliance_messages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceGroupPolicyAssignmentNonComplianceMessageArgs']]]]):
        pulumi.set(self, "non_compliance_messages", value)

    @_builtins.property
    @pulumi.getter(name="notScopes")
    def not_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Resource Scopes (for example a Subscription, or a Resource Group) within this Management Group which are excluded from this Policy.
        """
        return pulumi.get(self, "not_scopes")

    @not_scopes.setter
    def not_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "not_scopes", value)

    @_builtins.property
    @pulumi.getter
    def overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceGroupPolicyAssignmentOverrideArgs']]]]:
        """
        One or more `overrides` blocks as defined below. More detail about `overrides` and `resource_selectors` see [policy assignment structure](https://learn.microsoft.com/en-us/azure/governance/policy/concepts/assignment-structure#resource-selectors-preview)
        """
        return pulumi.get(self, "overrides")

    @overrides.setter
    def overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceGroupPolicyAssignmentOverrideArgs']]]]):
        pulumi.set(self, "overrides", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A JSON mapping of any Parameters for this Policy.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="resourceSelectors")
    def resource_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceGroupPolicyAssignmentResourceSelectorArgs']]]]:
        """
        One or more `resource_selectors` blocks as defined below to filter polices by resource properties.
        """
        return pulumi.get(self, "resource_selectors")

    @resource_selectors.setter
    def resource_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceGroupPolicyAssignmentResourceSelectorArgs']]]]):
        pulumi.set(self, "resource_selectors", value)


@pulumi.input_type
class _ResourceGroupPolicyAssignmentState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enforce: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['ResourceGroupPolicyAssignmentIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 non_compliance_messages: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceGroupPolicyAssignmentNonComplianceMessageArgs']]]] = None,
                 not_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 overrides: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceGroupPolicyAssignmentOverrideArgs']]]] = None,
                 parameters: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_selectors: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceGroupPolicyAssignmentResourceSelectorArgs']]]] = None):
        """
        Input properties used for looking up and filtering ResourceGroupPolicyAssignment resources.
        :param pulumi.Input[_builtins.str] description: A description which should be used for this Policy Assignment.
        :param pulumi.Input[_builtins.str] display_name: The Display Name for this Policy Assignment.
        :param pulumi.Input[_builtins.bool] enforce: Specifies if this Policy should be enforced or not? Defaults to `true`.
        :param pulumi.Input['ResourceGroupPolicyAssignmentIdentityArgs'] identity: An `identity` block as defined below.
               
               > **Note:** The `location` field must also be specified when `identity` is specified.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Policy Assignment should exist. Changing this forces a new Policy Assignment to be created.
        :param pulumi.Input[_builtins.str] metadata: A JSON mapping of any Metadata for this Policy.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Policy Assignment. Changing this forces a new Policy Assignment to be created. Cannot exceed 64 characters in length.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceGroupPolicyAssignmentNonComplianceMessageArgs']]] non_compliance_messages: One or more `non_compliance_message` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] not_scopes: Specifies a list of Resource Scopes (for example a Subscription, or a Resource Group) within this Management Group which are excluded from this Policy.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceGroupPolicyAssignmentOverrideArgs']]] overrides: One or more `overrides` blocks as defined below. More detail about `overrides` and `resource_selectors` see [policy assignment structure](https://learn.microsoft.com/en-us/azure/governance/policy/concepts/assignment-structure#resource-selectors-preview)
        :param pulumi.Input[_builtins.str] parameters: A JSON mapping of any Parameters for this Policy.
        :param pulumi.Input[_builtins.str] policy_definition_id: The ID of the Policy Definition or Policy Definition Set. Changing this forces a new Policy Assignment to be created.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the Resource Group where this Policy Assignment should be created. Changing this forces a new Policy Assignment to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ResourceGroupPolicyAssignmentResourceSelectorArgs']]] resource_selectors: One or more `resource_selectors` blocks as defined below to filter polices by resource properties.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enforce is not None:
            pulumi.set(__self__, "enforce", enforce)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if non_compliance_messages is not None:
            pulumi.set(__self__, "non_compliance_messages", non_compliance_messages)
        if not_scopes is not None:
            pulumi.set(__self__, "not_scopes", not_scopes)
        if overrides is not None:
            pulumi.set(__self__, "overrides", overrides)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if policy_definition_id is not None:
            pulumi.set(__self__, "policy_definition_id", policy_definition_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if resource_selectors is not None:
            pulumi.set(__self__, "resource_selectors", resource_selectors)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description which should be used for this Policy Assignment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Display Name for this Policy Assignment.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter
    def enforce(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if this Policy should be enforced or not? Defaults to `true`.
        """
        return pulumi.get(self, "enforce")

    @enforce.setter
    def enforce(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enforce", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ResourceGroupPolicyAssignmentIdentityArgs']]:
        """
        An `identity` block as defined below.

        > **Note:** The `location` field must also be specified when `identity` is specified.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ResourceGroupPolicyAssignmentIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Policy Assignment should exist. Changing this forces a new Policy Assignment to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A JSON mapping of any Metadata for this Policy.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Policy Assignment. Changing this forces a new Policy Assignment to be created. Cannot exceed 64 characters in length.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nonComplianceMessages")
    def non_compliance_messages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceGroupPolicyAssignmentNonComplianceMessageArgs']]]]:
        """
        One or more `non_compliance_message` blocks as defined below.
        """
        return pulumi.get(self, "non_compliance_messages")

    @non_compliance_messages.setter
    def non_compliance_messages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceGroupPolicyAssignmentNonComplianceMessageArgs']]]]):
        pulumi.set(self, "non_compliance_messages", value)

    @_builtins.property
    @pulumi.getter(name="notScopes")
    def not_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Resource Scopes (for example a Subscription, or a Resource Group) within this Management Group which are excluded from this Policy.
        """
        return pulumi.get(self, "not_scopes")

    @not_scopes.setter
    def not_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "not_scopes", value)

    @_builtins.property
    @pulumi.getter
    def overrides(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceGroupPolicyAssignmentOverrideArgs']]]]:
        """
        One or more `overrides` blocks as defined below. More detail about `overrides` and `resource_selectors` see [policy assignment structure](https://learn.microsoft.com/en-us/azure/governance/policy/concepts/assignment-structure#resource-selectors-preview)
        """
        return pulumi.get(self, "overrides")

    @overrides.setter
    def overrides(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceGroupPolicyAssignmentOverrideArgs']]]]):
        pulumi.set(self, "overrides", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A JSON mapping of any Parameters for this Policy.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="policyDefinitionId")
    def policy_definition_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Policy Definition or Policy Definition Set. Changing this forces a new Policy Assignment to be created.
        """
        return pulumi.get(self, "policy_definition_id")

    @policy_definition_id.setter
    def policy_definition_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_definition_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Resource Group where this Policy Assignment should be created. Changing this forces a new Policy Assignment to be created.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceSelectors")
    def resource_selectors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ResourceGroupPolicyAssignmentResourceSelectorArgs']]]]:
        """
        One or more `resource_selectors` blocks as defined below to filter polices by resource properties.
        """
        return pulumi.get(self, "resource_selectors")

    @resource_selectors.setter
    def resource_selectors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ResourceGroupPolicyAssignmentResourceSelectorArgs']]]]):
        pulumi.set(self, "resource_selectors", value)


@pulumi.type_token("azure:core/resourceGroupPolicyAssignment:ResourceGroupPolicyAssignment")
class ResourceGroupPolicyAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enforce: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['ResourceGroupPolicyAssignmentIdentityArgs', 'ResourceGroupPolicyAssignmentIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 non_compliance_messages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResourceGroupPolicyAssignmentNonComplianceMessageArgs', 'ResourceGroupPolicyAssignmentNonComplianceMessageArgsDict']]]]] = None,
                 not_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResourceGroupPolicyAssignmentOverrideArgs', 'ResourceGroupPolicyAssignmentOverrideArgsDict']]]]] = None,
                 parameters: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResourceGroupPolicyAssignmentResourceSelectorArgs', 'ResourceGroupPolicyAssignmentResourceSelectorArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a Resource Group Policy Assignment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_definition = azure.policy.Definition("example",
            name="only-deploy-in-westeurope",
            policy_type="Custom",
            mode="All",
            display_name="my-policy-definition",
            policy_rule=\"\"\" {
            "if": {
              "not": {
                "field": "location",
                "equals": "westeurope"
              }
            },
            "then": {
              "effect": "Deny"
            }
          }
        \"\"\")
        example_resource_group_policy_assignment = azure.core.ResourceGroupPolicyAssignment("example",
            name="example",
            resource_group_id=example.id,
            policy_definition_id=example_definition.id,
            parameters=\"\"\"    {
              "tagName": {
                "value": "Business Unit"
              },
              "tagValue": {
                "value": "BU"
              }
            }
        \"\"\")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Authorization` - 2022-06-01

        ## Import

        Resource Group Policy Assignments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:core/resourceGroupPolicyAssignment:ResourceGroupPolicyAssignment example /subscriptions/00000000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Authorization/policyAssignments/assignment1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description which should be used for this Policy Assignment.
        :param pulumi.Input[_builtins.str] display_name: The Display Name for this Policy Assignment.
        :param pulumi.Input[_builtins.bool] enforce: Specifies if this Policy should be enforced or not? Defaults to `true`.
        :param pulumi.Input[Union['ResourceGroupPolicyAssignmentIdentityArgs', 'ResourceGroupPolicyAssignmentIdentityArgsDict']] identity: An `identity` block as defined below.
               
               > **Note:** The `location` field must also be specified when `identity` is specified.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Policy Assignment should exist. Changing this forces a new Policy Assignment to be created.
        :param pulumi.Input[_builtins.str] metadata: A JSON mapping of any Metadata for this Policy.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Policy Assignment. Changing this forces a new Policy Assignment to be created. Cannot exceed 64 characters in length.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ResourceGroupPolicyAssignmentNonComplianceMessageArgs', 'ResourceGroupPolicyAssignmentNonComplianceMessageArgsDict']]]] non_compliance_messages: One or more `non_compliance_message` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] not_scopes: Specifies a list of Resource Scopes (for example a Subscription, or a Resource Group) within this Management Group which are excluded from this Policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ResourceGroupPolicyAssignmentOverrideArgs', 'ResourceGroupPolicyAssignmentOverrideArgsDict']]]] overrides: One or more `overrides` blocks as defined below. More detail about `overrides` and `resource_selectors` see [policy assignment structure](https://learn.microsoft.com/en-us/azure/governance/policy/concepts/assignment-structure#resource-selectors-preview)
        :param pulumi.Input[_builtins.str] parameters: A JSON mapping of any Parameters for this Policy.
        :param pulumi.Input[_builtins.str] policy_definition_id: The ID of the Policy Definition or Policy Definition Set. Changing this forces a new Policy Assignment to be created.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the Resource Group where this Policy Assignment should be created. Changing this forces a new Policy Assignment to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ResourceGroupPolicyAssignmentResourceSelectorArgs', 'ResourceGroupPolicyAssignmentResourceSelectorArgsDict']]]] resource_selectors: One or more `resource_selectors` blocks as defined below to filter polices by resource properties.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResourceGroupPolicyAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Resource Group Policy Assignment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_definition = azure.policy.Definition("example",
            name="only-deploy-in-westeurope",
            policy_type="Custom",
            mode="All",
            display_name="my-policy-definition",
            policy_rule=\"\"\" {
            "if": {
              "not": {
                "field": "location",
                "equals": "westeurope"
              }
            },
            "then": {
              "effect": "Deny"
            }
          }
        \"\"\")
        example_resource_group_policy_assignment = azure.core.ResourceGroupPolicyAssignment("example",
            name="example",
            resource_group_id=example.id,
            policy_definition_id=example_definition.id,
            parameters=\"\"\"    {
              "tagName": {
                "value": "Business Unit"
              },
              "tagValue": {
                "value": "BU"
              }
            }
        \"\"\")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Authorization` - 2022-06-01

        ## Import

        Resource Group Policy Assignments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:core/resourceGroupPolicyAssignment:ResourceGroupPolicyAssignment example /subscriptions/00000000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Authorization/policyAssignments/assignment1
        ```

        :param str resource_name: The name of the resource.
        :param ResourceGroupPolicyAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourceGroupPolicyAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enforce: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['ResourceGroupPolicyAssignmentIdentityArgs', 'ResourceGroupPolicyAssignmentIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 non_compliance_messages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResourceGroupPolicyAssignmentNonComplianceMessageArgs', 'ResourceGroupPolicyAssignmentNonComplianceMessageArgsDict']]]]] = None,
                 not_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResourceGroupPolicyAssignmentOverrideArgs', 'ResourceGroupPolicyAssignmentOverrideArgsDict']]]]] = None,
                 parameters: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResourceGroupPolicyAssignmentResourceSelectorArgs', 'ResourceGroupPolicyAssignmentResourceSelectorArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourceGroupPolicyAssignmentArgs.__new__(ResourceGroupPolicyAssignmentArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enforce"] = enforce
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            __props__.__dict__["non_compliance_messages"] = non_compliance_messages
            __props__.__dict__["not_scopes"] = not_scopes
            __props__.__dict__["overrides"] = overrides
            __props__.__dict__["parameters"] = parameters
            if policy_definition_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_definition_id'")
            __props__.__dict__["policy_definition_id"] = policy_definition_id
            if resource_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_id'")
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["resource_selectors"] = resource_selectors
        super(ResourceGroupPolicyAssignment, __self__).__init__(
            'azure:core/resourceGroupPolicyAssignment:ResourceGroupPolicyAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            enforce: Optional[pulumi.Input[_builtins.bool]] = None,
            identity: Optional[pulumi.Input[Union['ResourceGroupPolicyAssignmentIdentityArgs', 'ResourceGroupPolicyAssignmentIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            metadata: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            non_compliance_messages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResourceGroupPolicyAssignmentNonComplianceMessageArgs', 'ResourceGroupPolicyAssignmentNonComplianceMessageArgsDict']]]]] = None,
            not_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            overrides: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResourceGroupPolicyAssignmentOverrideArgs', 'ResourceGroupPolicyAssignmentOverrideArgsDict']]]]] = None,
            parameters: Optional[pulumi.Input[_builtins.str]] = None,
            policy_definition_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_selectors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ResourceGroupPolicyAssignmentResourceSelectorArgs', 'ResourceGroupPolicyAssignmentResourceSelectorArgsDict']]]]] = None) -> 'ResourceGroupPolicyAssignment':
        """
        Get an existing ResourceGroupPolicyAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description which should be used for this Policy Assignment.
        :param pulumi.Input[_builtins.str] display_name: The Display Name for this Policy Assignment.
        :param pulumi.Input[_builtins.bool] enforce: Specifies if this Policy should be enforced or not? Defaults to `true`.
        :param pulumi.Input[Union['ResourceGroupPolicyAssignmentIdentityArgs', 'ResourceGroupPolicyAssignmentIdentityArgsDict']] identity: An `identity` block as defined below.
               
               > **Note:** The `location` field must also be specified when `identity` is specified.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Policy Assignment should exist. Changing this forces a new Policy Assignment to be created.
        :param pulumi.Input[_builtins.str] metadata: A JSON mapping of any Metadata for this Policy.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Policy Assignment. Changing this forces a new Policy Assignment to be created. Cannot exceed 64 characters in length.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ResourceGroupPolicyAssignmentNonComplianceMessageArgs', 'ResourceGroupPolicyAssignmentNonComplianceMessageArgsDict']]]] non_compliance_messages: One or more `non_compliance_message` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] not_scopes: Specifies a list of Resource Scopes (for example a Subscription, or a Resource Group) within this Management Group which are excluded from this Policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ResourceGroupPolicyAssignmentOverrideArgs', 'ResourceGroupPolicyAssignmentOverrideArgsDict']]]] overrides: One or more `overrides` blocks as defined below. More detail about `overrides` and `resource_selectors` see [policy assignment structure](https://learn.microsoft.com/en-us/azure/governance/policy/concepts/assignment-structure#resource-selectors-preview)
        :param pulumi.Input[_builtins.str] parameters: A JSON mapping of any Parameters for this Policy.
        :param pulumi.Input[_builtins.str] policy_definition_id: The ID of the Policy Definition or Policy Definition Set. Changing this forces a new Policy Assignment to be created.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the Resource Group where this Policy Assignment should be created. Changing this forces a new Policy Assignment to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ResourceGroupPolicyAssignmentResourceSelectorArgs', 'ResourceGroupPolicyAssignmentResourceSelectorArgsDict']]]] resource_selectors: One or more `resource_selectors` blocks as defined below to filter polices by resource properties.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResourceGroupPolicyAssignmentState.__new__(_ResourceGroupPolicyAssignmentState)

        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enforce"] = enforce
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["non_compliance_messages"] = non_compliance_messages
        __props__.__dict__["not_scopes"] = not_scopes
        __props__.__dict__["overrides"] = overrides
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["policy_definition_id"] = policy_definition_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["resource_selectors"] = resource_selectors
        return ResourceGroupPolicyAssignment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description which should be used for this Policy Assignment.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Display Name for this Policy Assignment.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def enforce(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if this Policy should be enforced or not? Defaults to `true`.
        """
        return pulumi.get(self, "enforce")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.ResourceGroupPolicyAssignmentIdentity']]:
        """
        An `identity` block as defined below.

        > **Note:** The `location` field must also be specified when `identity` is specified.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Policy Assignment should exist. Changing this forces a new Policy Assignment to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[_builtins.str]:
        """
        A JSON mapping of any Metadata for this Policy.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Policy Assignment. Changing this forces a new Policy Assignment to be created. Cannot exceed 64 characters in length.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nonComplianceMessages")
    def non_compliance_messages(self) -> pulumi.Output[Optional[Sequence['outputs.ResourceGroupPolicyAssignmentNonComplianceMessage']]]:
        """
        One or more `non_compliance_message` blocks as defined below.
        """
        return pulumi.get(self, "non_compliance_messages")

    @_builtins.property
    @pulumi.getter(name="notScopes")
    def not_scopes(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of Resource Scopes (for example a Subscription, or a Resource Group) within this Management Group which are excluded from this Policy.
        """
        return pulumi.get(self, "not_scopes")

    @_builtins.property
    @pulumi.getter
    def overrides(self) -> pulumi.Output[Optional[Sequence['outputs.ResourceGroupPolicyAssignmentOverride']]]:
        """
        One or more `overrides` blocks as defined below. More detail about `overrides` and `resource_selectors` see [policy assignment structure](https://learn.microsoft.com/en-us/azure/governance/policy/concepts/assignment-structure#resource-selectors-preview)
        """
        return pulumi.get(self, "overrides")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A JSON mapping of any Parameters for this Policy.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="policyDefinitionId")
    def policy_definition_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Policy Definition or Policy Definition Set. Changing this forces a new Policy Assignment to be created.
        """
        return pulumi.get(self, "policy_definition_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Resource Group where this Policy Assignment should be created. Changing this forces a new Policy Assignment to be created.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter(name="resourceSelectors")
    def resource_selectors(self) -> pulumi.Output[Optional[Sequence['outputs.ResourceGroupPolicyAssignmentResourceSelector']]]:
        """
        One or more `resource_selectors` blocks as defined below to filter polices by resource properties.
        """
        return pulumi.get(self, "resource_selectors")

