# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SubscriptionPolicyRemediationArgs', 'SubscriptionPolicyRemediation']

@pulumi.input_type
class SubscriptionPolicyRemediationArgs:
    def __init__(__self__, *,
                 policy_assignment_id: pulumi.Input[_builtins.str],
                 subscription_id: pulumi.Input[_builtins.str],
                 failure_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 location_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parallel_deployments: Optional[pulumi.Input[_builtins.int]] = None,
                 policy_definition_reference_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_count: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_discovery_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SubscriptionPolicyRemediation resource.
        :param pulumi.Input[_builtins.str] policy_assignment_id: The ID of the Policy Assignment that should be remediated.
        :param pulumi.Input[_builtins.str] subscription_id: The Subscription ID at which the Policy Remediation should be applied. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.float] failure_percentage: A number between 0.0 to 1.0 representing the percentage failure threshold. The remediation will fail if the percentage of failed remediation operations (i.e. failed deployments) exceeds this threshold.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] location_filters: A list of the resource locations that will be remediated.
        :param pulumi.Input[_builtins.str] name: The name of the Policy Remediation. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] parallel_deployments: Determines how many resources to remediate at any given time. Can be used to increase or reduce the pace of the remediation. If not provided, the default parallel deployments value is used.
        :param pulumi.Input[_builtins.str] policy_definition_reference_id: The unique ID for the policy definition reference within the policy set definition that should be remediated. Required when the policy assignment being remediated assigns a policy set definition.
        :param pulumi.Input[_builtins.int] resource_count: Determines the max number of resources that can be remediated by the remediation job. If not provided, the default resource count is used.
        :param pulumi.Input[_builtins.str] resource_discovery_mode: The way that resources to remediate are discovered. Possible values are `ExistingNonCompliant`, `ReEvaluateCompliance`. Defaults to `ExistingNonCompliant`.
        """
        pulumi.set(__self__, "policy_assignment_id", policy_assignment_id)
        pulumi.set(__self__, "subscription_id", subscription_id)
        if failure_percentage is not None:
            pulumi.set(__self__, "failure_percentage", failure_percentage)
        if location_filters is not None:
            pulumi.set(__self__, "location_filters", location_filters)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parallel_deployments is not None:
            pulumi.set(__self__, "parallel_deployments", parallel_deployments)
        if policy_definition_reference_id is not None:
            pulumi.set(__self__, "policy_definition_reference_id", policy_definition_reference_id)
        if resource_count is not None:
            pulumi.set(__self__, "resource_count", resource_count)
        if resource_discovery_mode is not None:
            pulumi.set(__self__, "resource_discovery_mode", resource_discovery_mode)

    @_builtins.property
    @pulumi.getter(name="policyAssignmentId")
    def policy_assignment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Policy Assignment that should be remediated.
        """
        return pulumi.get(self, "policy_assignment_id")

    @policy_assignment_id.setter
    def policy_assignment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_assignment_id", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Subscription ID at which the Policy Remediation should be applied. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subscription_id", value)

    @_builtins.property
    @pulumi.getter(name="failurePercentage")
    def failure_percentage(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        A number between 0.0 to 1.0 representing the percentage failure threshold. The remediation will fail if the percentage of failed remediation operations (i.e. failed deployments) exceeds this threshold.
        """
        return pulumi.get(self, "failure_percentage")

    @failure_percentage.setter
    def failure_percentage(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "failure_percentage", value)

    @_builtins.property
    @pulumi.getter(name="locationFilters")
    def location_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the resource locations that will be remediated.
        """
        return pulumi.get(self, "location_filters")

    @location_filters.setter
    def location_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "location_filters", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Policy Remediation. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parallelDeployments")
    def parallel_deployments(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Determines how many resources to remediate at any given time. Can be used to increase or reduce the pace of the remediation. If not provided, the default parallel deployments value is used.
        """
        return pulumi.get(self, "parallel_deployments")

    @parallel_deployments.setter
    def parallel_deployments(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "parallel_deployments", value)

    @_builtins.property
    @pulumi.getter(name="policyDefinitionReferenceId")
    def policy_definition_reference_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique ID for the policy definition reference within the policy set definition that should be remediated. Required when the policy assignment being remediated assigns a policy set definition.
        """
        return pulumi.get(self, "policy_definition_reference_id")

    @policy_definition_reference_id.setter
    def policy_definition_reference_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_definition_reference_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceCount")
    def resource_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Determines the max number of resources that can be remediated by the remediation job. If not provided, the default resource count is used.
        """
        return pulumi.get(self, "resource_count")

    @resource_count.setter
    def resource_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "resource_count", value)

    @_builtins.property
    @pulumi.getter(name="resourceDiscoveryMode")
    def resource_discovery_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The way that resources to remediate are discovered. Possible values are `ExistingNonCompliant`, `ReEvaluateCompliance`. Defaults to `ExistingNonCompliant`.
        """
        return pulumi.get(self, "resource_discovery_mode")

    @resource_discovery_mode.setter
    def resource_discovery_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_discovery_mode", value)


@pulumi.input_type
class _SubscriptionPolicyRemediationState:
    def __init__(__self__, *,
                 failure_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 location_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parallel_deployments: Optional[pulumi.Input[_builtins.int]] = None,
                 policy_assignment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_definition_reference_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_count: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_discovery_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SubscriptionPolicyRemediation resources.
        :param pulumi.Input[_builtins.float] failure_percentage: A number between 0.0 to 1.0 representing the percentage failure threshold. The remediation will fail if the percentage of failed remediation operations (i.e. failed deployments) exceeds this threshold.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] location_filters: A list of the resource locations that will be remediated.
        :param pulumi.Input[_builtins.str] name: The name of the Policy Remediation. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] parallel_deployments: Determines how many resources to remediate at any given time. Can be used to increase or reduce the pace of the remediation. If not provided, the default parallel deployments value is used.
        :param pulumi.Input[_builtins.str] policy_assignment_id: The ID of the Policy Assignment that should be remediated.
        :param pulumi.Input[_builtins.str] policy_definition_reference_id: The unique ID for the policy definition reference within the policy set definition that should be remediated. Required when the policy assignment being remediated assigns a policy set definition.
        :param pulumi.Input[_builtins.int] resource_count: Determines the max number of resources that can be remediated by the remediation job. If not provided, the default resource count is used.
        :param pulumi.Input[_builtins.str] resource_discovery_mode: The way that resources to remediate are discovered. Possible values are `ExistingNonCompliant`, `ReEvaluateCompliance`. Defaults to `ExistingNonCompliant`.
        :param pulumi.Input[_builtins.str] subscription_id: The Subscription ID at which the Policy Remediation should be applied. Changing this forces a new resource to be created.
        """
        if failure_percentage is not None:
            pulumi.set(__self__, "failure_percentage", failure_percentage)
        if location_filters is not None:
            pulumi.set(__self__, "location_filters", location_filters)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parallel_deployments is not None:
            pulumi.set(__self__, "parallel_deployments", parallel_deployments)
        if policy_assignment_id is not None:
            pulumi.set(__self__, "policy_assignment_id", policy_assignment_id)
        if policy_definition_reference_id is not None:
            pulumi.set(__self__, "policy_definition_reference_id", policy_definition_reference_id)
        if resource_count is not None:
            pulumi.set(__self__, "resource_count", resource_count)
        if resource_discovery_mode is not None:
            pulumi.set(__self__, "resource_discovery_mode", resource_discovery_mode)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)

    @_builtins.property
    @pulumi.getter(name="failurePercentage")
    def failure_percentage(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        A number between 0.0 to 1.0 representing the percentage failure threshold. The remediation will fail if the percentage of failed remediation operations (i.e. failed deployments) exceeds this threshold.
        """
        return pulumi.get(self, "failure_percentage")

    @failure_percentage.setter
    def failure_percentage(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "failure_percentage", value)

    @_builtins.property
    @pulumi.getter(name="locationFilters")
    def location_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the resource locations that will be remediated.
        """
        return pulumi.get(self, "location_filters")

    @location_filters.setter
    def location_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "location_filters", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Policy Remediation. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parallelDeployments")
    def parallel_deployments(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Determines how many resources to remediate at any given time. Can be used to increase or reduce the pace of the remediation. If not provided, the default parallel deployments value is used.
        """
        return pulumi.get(self, "parallel_deployments")

    @parallel_deployments.setter
    def parallel_deployments(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "parallel_deployments", value)

    @_builtins.property
    @pulumi.getter(name="policyAssignmentId")
    def policy_assignment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Policy Assignment that should be remediated.
        """
        return pulumi.get(self, "policy_assignment_id")

    @policy_assignment_id.setter
    def policy_assignment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_assignment_id", value)

    @_builtins.property
    @pulumi.getter(name="policyDefinitionReferenceId")
    def policy_definition_reference_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique ID for the policy definition reference within the policy set definition that should be remediated. Required when the policy assignment being remediated assigns a policy set definition.
        """
        return pulumi.get(self, "policy_definition_reference_id")

    @policy_definition_reference_id.setter
    def policy_definition_reference_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_definition_reference_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceCount")
    def resource_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Determines the max number of resources that can be remediated by the remediation job. If not provided, the default resource count is used.
        """
        return pulumi.get(self, "resource_count")

    @resource_count.setter
    def resource_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "resource_count", value)

    @_builtins.property
    @pulumi.getter(name="resourceDiscoveryMode")
    def resource_discovery_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The way that resources to remediate are discovered. Possible values are `ExistingNonCompliant`, `ReEvaluateCompliance`. Defaults to `ExistingNonCompliant`.
        """
        return pulumi.get(self, "resource_discovery_mode")

    @resource_discovery_mode.setter
    def resource_discovery_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_discovery_mode", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Subscription ID at which the Policy Remediation should be applied. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subscription_id", value)


@pulumi.type_token("azure:core/subscriptionPolicyRemediation:SubscriptionPolicyRemediation")
class SubscriptionPolicyRemediation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 failure_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 location_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parallel_deployments: Optional[pulumi.Input[_builtins.int]] = None,
                 policy_assignment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_definition_reference_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_count: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_discovery_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure Subscription Policy Remediation.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_azure as azure

        example = azure.core.get_subscription()
        example_get_policy_defintion = azure.policy.get_policy_defintion(display_name="Allowed resource types")
        example_subscription_policy_assignment = azure.core.SubscriptionPolicyAssignment("example",
            name="exampleAssignment",
            subscription_id=example.id,
            policy_definition_id=example_get_policy_defintion.id,
            parameters=json.dumps({
                "listOfAllowedLocations": {
                    "value": [
                        "West Europe",
                        "East US",
                    ],
                },
            }))
        example_subscription_policy_remediation = azure.core.SubscriptionPolicyRemediation("example",
            name="example",
            subscription_id=example.id,
            policy_assignment_id=example_subscription_policy_assignment.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.PolicyInsights` - 2021-10-01

        ## Import

        Policy Remediations can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:core/subscriptionPolicyRemediation:SubscriptionPolicyRemediation example /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.PolicyInsights/remediations/remediation1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.float] failure_percentage: A number between 0.0 to 1.0 representing the percentage failure threshold. The remediation will fail if the percentage of failed remediation operations (i.e. failed deployments) exceeds this threshold.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] location_filters: A list of the resource locations that will be remediated.
        :param pulumi.Input[_builtins.str] name: The name of the Policy Remediation. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] parallel_deployments: Determines how many resources to remediate at any given time. Can be used to increase or reduce the pace of the remediation. If not provided, the default parallel deployments value is used.
        :param pulumi.Input[_builtins.str] policy_assignment_id: The ID of the Policy Assignment that should be remediated.
        :param pulumi.Input[_builtins.str] policy_definition_reference_id: The unique ID for the policy definition reference within the policy set definition that should be remediated. Required when the policy assignment being remediated assigns a policy set definition.
        :param pulumi.Input[_builtins.int] resource_count: Determines the max number of resources that can be remediated by the remediation job. If not provided, the default resource count is used.
        :param pulumi.Input[_builtins.str] resource_discovery_mode: The way that resources to remediate are discovered. Possible values are `ExistingNonCompliant`, `ReEvaluateCompliance`. Defaults to `ExistingNonCompliant`.
        :param pulumi.Input[_builtins.str] subscription_id: The Subscription ID at which the Policy Remediation should be applied. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubscriptionPolicyRemediationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Subscription Policy Remediation.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_azure as azure

        example = azure.core.get_subscription()
        example_get_policy_defintion = azure.policy.get_policy_defintion(display_name="Allowed resource types")
        example_subscription_policy_assignment = azure.core.SubscriptionPolicyAssignment("example",
            name="exampleAssignment",
            subscription_id=example.id,
            policy_definition_id=example_get_policy_defintion.id,
            parameters=json.dumps({
                "listOfAllowedLocations": {
                    "value": [
                        "West Europe",
                        "East US",
                    ],
                },
            }))
        example_subscription_policy_remediation = azure.core.SubscriptionPolicyRemediation("example",
            name="example",
            subscription_id=example.id,
            policy_assignment_id=example_subscription_policy_assignment.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.PolicyInsights` - 2021-10-01

        ## Import

        Policy Remediations can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:core/subscriptionPolicyRemediation:SubscriptionPolicyRemediation example /subscriptions/00000000-0000-0000-0000-000000000000/providers/Microsoft.PolicyInsights/remediations/remediation1
        ```

        :param str resource_name: The name of the resource.
        :param SubscriptionPolicyRemediationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubscriptionPolicyRemediationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 failure_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 location_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parallel_deployments: Optional[pulumi.Input[_builtins.int]] = None,
                 policy_assignment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_definition_reference_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_count: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_discovery_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubscriptionPolicyRemediationArgs.__new__(SubscriptionPolicyRemediationArgs)

            __props__.__dict__["failure_percentage"] = failure_percentage
            __props__.__dict__["location_filters"] = location_filters
            __props__.__dict__["name"] = name
            __props__.__dict__["parallel_deployments"] = parallel_deployments
            if policy_assignment_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_assignment_id'")
            __props__.__dict__["policy_assignment_id"] = policy_assignment_id
            __props__.__dict__["policy_definition_reference_id"] = policy_definition_reference_id
            __props__.__dict__["resource_count"] = resource_count
            __props__.__dict__["resource_discovery_mode"] = resource_discovery_mode
            if subscription_id is None and not opts.urn:
                raise TypeError("Missing required property 'subscription_id'")
            __props__.__dict__["subscription_id"] = subscription_id
        super(SubscriptionPolicyRemediation, __self__).__init__(
            'azure:core/subscriptionPolicyRemediation:SubscriptionPolicyRemediation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            failure_percentage: Optional[pulumi.Input[_builtins.float]] = None,
            location_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parallel_deployments: Optional[pulumi.Input[_builtins.int]] = None,
            policy_assignment_id: Optional[pulumi.Input[_builtins.str]] = None,
            policy_definition_reference_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_count: Optional[pulumi.Input[_builtins.int]] = None,
            resource_discovery_mode: Optional[pulumi.Input[_builtins.str]] = None,
            subscription_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'SubscriptionPolicyRemediation':
        """
        Get an existing SubscriptionPolicyRemediation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.float] failure_percentage: A number between 0.0 to 1.0 representing the percentage failure threshold. The remediation will fail if the percentage of failed remediation operations (i.e. failed deployments) exceeds this threshold.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] location_filters: A list of the resource locations that will be remediated.
        :param pulumi.Input[_builtins.str] name: The name of the Policy Remediation. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] parallel_deployments: Determines how many resources to remediate at any given time. Can be used to increase or reduce the pace of the remediation. If not provided, the default parallel deployments value is used.
        :param pulumi.Input[_builtins.str] policy_assignment_id: The ID of the Policy Assignment that should be remediated.
        :param pulumi.Input[_builtins.str] policy_definition_reference_id: The unique ID for the policy definition reference within the policy set definition that should be remediated. Required when the policy assignment being remediated assigns a policy set definition.
        :param pulumi.Input[_builtins.int] resource_count: Determines the max number of resources that can be remediated by the remediation job. If not provided, the default resource count is used.
        :param pulumi.Input[_builtins.str] resource_discovery_mode: The way that resources to remediate are discovered. Possible values are `ExistingNonCompliant`, `ReEvaluateCompliance`. Defaults to `ExistingNonCompliant`.
        :param pulumi.Input[_builtins.str] subscription_id: The Subscription ID at which the Policy Remediation should be applied. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubscriptionPolicyRemediationState.__new__(_SubscriptionPolicyRemediationState)

        __props__.__dict__["failure_percentage"] = failure_percentage
        __props__.__dict__["location_filters"] = location_filters
        __props__.__dict__["name"] = name
        __props__.__dict__["parallel_deployments"] = parallel_deployments
        __props__.__dict__["policy_assignment_id"] = policy_assignment_id
        __props__.__dict__["policy_definition_reference_id"] = policy_definition_reference_id
        __props__.__dict__["resource_count"] = resource_count
        __props__.__dict__["resource_discovery_mode"] = resource_discovery_mode
        __props__.__dict__["subscription_id"] = subscription_id
        return SubscriptionPolicyRemediation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="failurePercentage")
    def failure_percentage(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        A number between 0.0 to 1.0 representing the percentage failure threshold. The remediation will fail if the percentage of failed remediation operations (i.e. failed deployments) exceeds this threshold.
        """
        return pulumi.get(self, "failure_percentage")

    @_builtins.property
    @pulumi.getter(name="locationFilters")
    def location_filters(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of the resource locations that will be remediated.
        """
        return pulumi.get(self, "location_filters")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Policy Remediation. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="parallelDeployments")
    def parallel_deployments(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Determines how many resources to remediate at any given time. Can be used to increase or reduce the pace of the remediation. If not provided, the default parallel deployments value is used.
        """
        return pulumi.get(self, "parallel_deployments")

    @_builtins.property
    @pulumi.getter(name="policyAssignmentId")
    def policy_assignment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Policy Assignment that should be remediated.
        """
        return pulumi.get(self, "policy_assignment_id")

    @_builtins.property
    @pulumi.getter(name="policyDefinitionReferenceId")
    def policy_definition_reference_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unique ID for the policy definition reference within the policy set definition that should be remediated. Required when the policy assignment being remediated assigns a policy set definition.
        """
        return pulumi.get(self, "policy_definition_reference_id")

    @_builtins.property
    @pulumi.getter(name="resourceCount")
    def resource_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Determines the max number of resources that can be remediated by the remediation job. If not provided, the default resource count is used.
        """
        return pulumi.get(self, "resource_count")

    @_builtins.property
    @pulumi.getter(name="resourceDiscoveryMode")
    def resource_discovery_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The way that resources to remediate are discovered. Possible values are `ExistingNonCompliant`, `ReEvaluateCompliance`. Defaults to `ExistingNonCompliant`.
        """
        return pulumi.get(self, "resource_discovery_mode")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Subscription ID at which the Policy Remediation should be applied. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subscription_id")

