# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GrafanaArgs', 'Grafana']

@pulumi.input_type
class GrafanaArgs:
    def __init__(__self__, *,
                 grafana_major_version: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 api_key_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_generated_domain_name_label_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_monitor_workspace_integrations: Optional[pulumi.Input[Sequence[pulumi.Input['GrafanaAzureMonitorWorkspaceIntegrationArgs']]]] = None,
                 deterministic_outbound_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['GrafanaIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 smtp: Optional[pulumi.Input['GrafanaSmtpArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone_redundancy_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Grafana resource.
        :param pulumi.Input[_builtins.str] grafana_major_version: Which major version of Grafana to deploy. Possible values are `10`, `11`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Dashboard Grafana should exist. Changing this forces a new Dashboard Grafana to be created.
        :param pulumi.Input[_builtins.bool] api_key_enabled: Whether to enable the api key setting of the Grafana instance. Defaults to `false`.
        :param pulumi.Input[_builtins.str] auto_generated_domain_name_label_scope: Scope for dns deterministic name hash calculation. The only possible value is `TenantReuse`. Defaults to `TenantReuse`.
        :param pulumi.Input[Sequence[pulumi.Input['GrafanaAzureMonitorWorkspaceIntegrationArgs']]] azure_monitor_workspace_integrations: A `azure_monitor_workspace_integrations` block as defined below.
        :param pulumi.Input[_builtins.bool] deterministic_outbound_ip_enabled: Whether to enable the Grafana instance to use deterministic outbound IPs. Defaults to `false`.
        :param pulumi.Input['GrafanaIdentityArgs'] identity: An `identity` block as defined below. Changing this forces a new Dashboard Grafana to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Dashboard Grafana should exist. Changing this forces a new Dashboard Grafana to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Dashboard Grafana. Changing this forces a new Dashboard Grafana to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether to enable traffic over the public interface. Defaults to `true`.
        :param pulumi.Input[_builtins.str] sku: The name of the SKU used for the Grafana instance. Possible values are `Standard` and `Essential`. Defaults to `Standard`. Changing this forces a new Dashboard Grafana to be created.
        :param pulumi.Input['GrafanaSmtpArgs'] smtp: A `smtp` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dashboard Grafana.
        :param pulumi.Input[_builtins.bool] zone_redundancy_enabled: Whether to enable the zone redundancy setting of the Grafana instance. Defaults to `false`. Changing this forces a new Dashboard Grafana to be created.
        """
        pulumi.set(__self__, "grafana_major_version", grafana_major_version)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if api_key_enabled is not None:
            pulumi.set(__self__, "api_key_enabled", api_key_enabled)
        if auto_generated_domain_name_label_scope is not None:
            pulumi.set(__self__, "auto_generated_domain_name_label_scope", auto_generated_domain_name_label_scope)
        if azure_monitor_workspace_integrations is not None:
            pulumi.set(__self__, "azure_monitor_workspace_integrations", azure_monitor_workspace_integrations)
        if deterministic_outbound_ip_enabled is not None:
            pulumi.set(__self__, "deterministic_outbound_ip_enabled", deterministic_outbound_ip_enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if smtp is not None:
            pulumi.set(__self__, "smtp", smtp)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone_redundancy_enabled is not None:
            pulumi.set(__self__, "zone_redundancy_enabled", zone_redundancy_enabled)

    @_builtins.property
    @pulumi.getter(name="grafanaMajorVersion")
    def grafana_major_version(self) -> pulumi.Input[_builtins.str]:
        """
        Which major version of Grafana to deploy. Possible values are `10`, `11`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "grafana_major_version")

    @grafana_major_version.setter
    def grafana_major_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "grafana_major_version", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Resource Group where the Dashboard Grafana should exist. Changing this forces a new Dashboard Grafana to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="apiKeyEnabled")
    def api_key_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the api key setting of the Grafana instance. Defaults to `false`.
        """
        return pulumi.get(self, "api_key_enabled")

    @api_key_enabled.setter
    def api_key_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "api_key_enabled", value)

    @_builtins.property
    @pulumi.getter(name="autoGeneratedDomainNameLabelScope")
    def auto_generated_domain_name_label_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scope for dns deterministic name hash calculation. The only possible value is `TenantReuse`. Defaults to `TenantReuse`.
        """
        return pulumi.get(self, "auto_generated_domain_name_label_scope")

    @auto_generated_domain_name_label_scope.setter
    def auto_generated_domain_name_label_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_generated_domain_name_label_scope", value)

    @_builtins.property
    @pulumi.getter(name="azureMonitorWorkspaceIntegrations")
    def azure_monitor_workspace_integrations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GrafanaAzureMonitorWorkspaceIntegrationArgs']]]]:
        """
        A `azure_monitor_workspace_integrations` block as defined below.
        """
        return pulumi.get(self, "azure_monitor_workspace_integrations")

    @azure_monitor_workspace_integrations.setter
    def azure_monitor_workspace_integrations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GrafanaAzureMonitorWorkspaceIntegrationArgs']]]]):
        pulumi.set(self, "azure_monitor_workspace_integrations", value)

    @_builtins.property
    @pulumi.getter(name="deterministicOutboundIpEnabled")
    def deterministic_outbound_ip_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the Grafana instance to use deterministic outbound IPs. Defaults to `false`.
        """
        return pulumi.get(self, "deterministic_outbound_ip_enabled")

    @deterministic_outbound_ip_enabled.setter
    def deterministic_outbound_ip_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deterministic_outbound_ip_enabled", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['GrafanaIdentityArgs']]:
        """
        An `identity` block as defined below. Changing this forces a new Dashboard Grafana to be created.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['GrafanaIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Dashboard Grafana should exist. Changing this forces a new Dashboard Grafana to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Dashboard Grafana. Changing this forces a new Dashboard Grafana to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable traffic over the public interface. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the SKU used for the Grafana instance. Possible values are `Standard` and `Essential`. Defaults to `Standard`. Changing this forces a new Dashboard Grafana to be created.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter
    def smtp(self) -> Optional[pulumi.Input['GrafanaSmtpArgs']]:
        """
        A `smtp` block as defined below.
        """
        return pulumi.get(self, "smtp")

    @smtp.setter
    def smtp(self, value: Optional[pulumi.Input['GrafanaSmtpArgs']]):
        pulumi.set(self, "smtp", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Dashboard Grafana.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="zoneRedundancyEnabled")
    def zone_redundancy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the zone redundancy setting of the Grafana instance. Defaults to `false`. Changing this forces a new Dashboard Grafana to be created.
        """
        return pulumi.get(self, "zone_redundancy_enabled")

    @zone_redundancy_enabled.setter
    def zone_redundancy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "zone_redundancy_enabled", value)


@pulumi.input_type
class _GrafanaState:
    def __init__(__self__, *,
                 api_key_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_generated_domain_name_label_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_monitor_workspace_integrations: Optional[pulumi.Input[Sequence[pulumi.Input['GrafanaAzureMonitorWorkspaceIntegrationArgs']]]] = None,
                 deterministic_outbound_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_major_version: Optional[pulumi.Input[_builtins.str]] = None,
                 grafana_version: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['GrafanaIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 outbound_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 smtp: Optional[pulumi.Input['GrafanaSmtpArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone_redundancy_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Grafana resources.
        :param pulumi.Input[_builtins.bool] api_key_enabled: Whether to enable the api key setting of the Grafana instance. Defaults to `false`.
        :param pulumi.Input[_builtins.str] auto_generated_domain_name_label_scope: Scope for dns deterministic name hash calculation. The only possible value is `TenantReuse`. Defaults to `TenantReuse`.
        :param pulumi.Input[Sequence[pulumi.Input['GrafanaAzureMonitorWorkspaceIntegrationArgs']]] azure_monitor_workspace_integrations: A `azure_monitor_workspace_integrations` block as defined below.
        :param pulumi.Input[_builtins.bool] deterministic_outbound_ip_enabled: Whether to enable the Grafana instance to use deterministic outbound IPs. Defaults to `false`.
        :param pulumi.Input[_builtins.str] endpoint: The endpoint of the Grafana instance.
        :param pulumi.Input[_builtins.str] grafana_major_version: Which major version of Grafana to deploy. Possible values are `10`, `11`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] grafana_version: The full Grafana software semantic version deployed.
        :param pulumi.Input['GrafanaIdentityArgs'] identity: An `identity` block as defined below. Changing this forces a new Dashboard Grafana to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Dashboard Grafana should exist. Changing this forces a new Dashboard Grafana to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Dashboard Grafana. Changing this forces a new Dashboard Grafana to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] outbound_ips: List of outbound IPs if deterministicOutboundIP is enabled.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether to enable traffic over the public interface. Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Dashboard Grafana should exist. Changing this forces a new Dashboard Grafana to be created.
        :param pulumi.Input[_builtins.str] sku: The name of the SKU used for the Grafana instance. Possible values are `Standard` and `Essential`. Defaults to `Standard`. Changing this forces a new Dashboard Grafana to be created.
        :param pulumi.Input['GrafanaSmtpArgs'] smtp: A `smtp` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dashboard Grafana.
        :param pulumi.Input[_builtins.bool] zone_redundancy_enabled: Whether to enable the zone redundancy setting of the Grafana instance. Defaults to `false`. Changing this forces a new Dashboard Grafana to be created.
        """
        if api_key_enabled is not None:
            pulumi.set(__self__, "api_key_enabled", api_key_enabled)
        if auto_generated_domain_name_label_scope is not None:
            pulumi.set(__self__, "auto_generated_domain_name_label_scope", auto_generated_domain_name_label_scope)
        if azure_monitor_workspace_integrations is not None:
            pulumi.set(__self__, "azure_monitor_workspace_integrations", azure_monitor_workspace_integrations)
        if deterministic_outbound_ip_enabled is not None:
            pulumi.set(__self__, "deterministic_outbound_ip_enabled", deterministic_outbound_ip_enabled)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if grafana_major_version is not None:
            pulumi.set(__self__, "grafana_major_version", grafana_major_version)
        if grafana_version is not None:
            pulumi.set(__self__, "grafana_version", grafana_version)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outbound_ips is not None:
            pulumi.set(__self__, "outbound_ips", outbound_ips)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if smtp is not None:
            pulumi.set(__self__, "smtp", smtp)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone_redundancy_enabled is not None:
            pulumi.set(__self__, "zone_redundancy_enabled", zone_redundancy_enabled)

    @_builtins.property
    @pulumi.getter(name="apiKeyEnabled")
    def api_key_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the api key setting of the Grafana instance. Defaults to `false`.
        """
        return pulumi.get(self, "api_key_enabled")

    @api_key_enabled.setter
    def api_key_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "api_key_enabled", value)

    @_builtins.property
    @pulumi.getter(name="autoGeneratedDomainNameLabelScope")
    def auto_generated_domain_name_label_scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scope for dns deterministic name hash calculation. The only possible value is `TenantReuse`. Defaults to `TenantReuse`.
        """
        return pulumi.get(self, "auto_generated_domain_name_label_scope")

    @auto_generated_domain_name_label_scope.setter
    def auto_generated_domain_name_label_scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_generated_domain_name_label_scope", value)

    @_builtins.property
    @pulumi.getter(name="azureMonitorWorkspaceIntegrations")
    def azure_monitor_workspace_integrations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GrafanaAzureMonitorWorkspaceIntegrationArgs']]]]:
        """
        A `azure_monitor_workspace_integrations` block as defined below.
        """
        return pulumi.get(self, "azure_monitor_workspace_integrations")

    @azure_monitor_workspace_integrations.setter
    def azure_monitor_workspace_integrations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GrafanaAzureMonitorWorkspaceIntegrationArgs']]]]):
        pulumi.set(self, "azure_monitor_workspace_integrations", value)

    @_builtins.property
    @pulumi.getter(name="deterministicOutboundIpEnabled")
    def deterministic_outbound_ip_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the Grafana instance to use deterministic outbound IPs. Defaults to `false`.
        """
        return pulumi.get(self, "deterministic_outbound_ip_enabled")

    @deterministic_outbound_ip_enabled.setter
    def deterministic_outbound_ip_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deterministic_outbound_ip_enabled", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint of the Grafana instance.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter(name="grafanaMajorVersion")
    def grafana_major_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Which major version of Grafana to deploy. Possible values are `10`, `11`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "grafana_major_version")

    @grafana_major_version.setter
    def grafana_major_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "grafana_major_version", value)

    @_builtins.property
    @pulumi.getter(name="grafanaVersion")
    def grafana_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full Grafana software semantic version deployed.
        """
        return pulumi.get(self, "grafana_version")

    @grafana_version.setter
    def grafana_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "grafana_version", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['GrafanaIdentityArgs']]:
        """
        An `identity` block as defined below. Changing this forces a new Dashboard Grafana to be created.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['GrafanaIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Dashboard Grafana should exist. Changing this forces a new Dashboard Grafana to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Dashboard Grafana. Changing this forces a new Dashboard Grafana to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="outboundIps")
    def outbound_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of outbound IPs if deterministicOutboundIP is enabled.
        """
        return pulumi.get(self, "outbound_ips")

    @outbound_ips.setter
    def outbound_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "outbound_ips", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable traffic over the public interface. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Resource Group where the Dashboard Grafana should exist. Changing this forces a new Dashboard Grafana to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the SKU used for the Grafana instance. Possible values are `Standard` and `Essential`. Defaults to `Standard`. Changing this forces a new Dashboard Grafana to be created.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter
    def smtp(self) -> Optional[pulumi.Input['GrafanaSmtpArgs']]:
        """
        A `smtp` block as defined below.
        """
        return pulumi.get(self, "smtp")

    @smtp.setter
    def smtp(self, value: Optional[pulumi.Input['GrafanaSmtpArgs']]):
        pulumi.set(self, "smtp", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Dashboard Grafana.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="zoneRedundancyEnabled")
    def zone_redundancy_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the zone redundancy setting of the Grafana instance. Defaults to `false`. Changing this forces a new Dashboard Grafana to be created.
        """
        return pulumi.get(self, "zone_redundancy_enabled")

    @zone_redundancy_enabled.setter
    def zone_redundancy_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "zone_redundancy_enabled", value)


@pulumi.type_token("azure:dashboard/grafana:Grafana")
class Grafana(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_generated_domain_name_label_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_monitor_workspace_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GrafanaAzureMonitorWorkspaceIntegrationArgs', 'GrafanaAzureMonitorWorkspaceIntegrationArgsDict']]]]] = None,
                 deterministic_outbound_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 grafana_major_version: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['GrafanaIdentityArgs', 'GrafanaIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 smtp: Optional[pulumi.Input[Union['GrafanaSmtpArgs', 'GrafanaSmtpArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone_redundancy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages a Dashboard Grafana.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_grafana = azure.dashboard.Grafana("example",
            name="example-dg",
            resource_group_name=example.name,
            location="West Europe",
            grafana_major_version="11",
            api_key_enabled=True,
            deterministic_outbound_ip_enabled=True,
            public_network_access_enabled=False,
            identity={
                "type": "SystemAssigned",
            },
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Dashboard` - 2023-09-01

        ## Import

        Dashboard Grafana can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:dashboard/grafana:Grafana example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Dashboard/grafana/workspace1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] api_key_enabled: Whether to enable the api key setting of the Grafana instance. Defaults to `false`.
        :param pulumi.Input[_builtins.str] auto_generated_domain_name_label_scope: Scope for dns deterministic name hash calculation. The only possible value is `TenantReuse`. Defaults to `TenantReuse`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GrafanaAzureMonitorWorkspaceIntegrationArgs', 'GrafanaAzureMonitorWorkspaceIntegrationArgsDict']]]] azure_monitor_workspace_integrations: A `azure_monitor_workspace_integrations` block as defined below.
        :param pulumi.Input[_builtins.bool] deterministic_outbound_ip_enabled: Whether to enable the Grafana instance to use deterministic outbound IPs. Defaults to `false`.
        :param pulumi.Input[_builtins.str] grafana_major_version: Which major version of Grafana to deploy. Possible values are `10`, `11`. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['GrafanaIdentityArgs', 'GrafanaIdentityArgsDict']] identity: An `identity` block as defined below. Changing this forces a new Dashboard Grafana to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Dashboard Grafana should exist. Changing this forces a new Dashboard Grafana to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Dashboard Grafana. Changing this forces a new Dashboard Grafana to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether to enable traffic over the public interface. Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Dashboard Grafana should exist. Changing this forces a new Dashboard Grafana to be created.
        :param pulumi.Input[_builtins.str] sku: The name of the SKU used for the Grafana instance. Possible values are `Standard` and `Essential`. Defaults to `Standard`. Changing this forces a new Dashboard Grafana to be created.
        :param pulumi.Input[Union['GrafanaSmtpArgs', 'GrafanaSmtpArgsDict']] smtp: A `smtp` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dashboard Grafana.
        :param pulumi.Input[_builtins.bool] zone_redundancy_enabled: Whether to enable the zone redundancy setting of the Grafana instance. Defaults to `false`. Changing this forces a new Dashboard Grafana to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GrafanaArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Dashboard Grafana.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_grafana = azure.dashboard.Grafana("example",
            name="example-dg",
            resource_group_name=example.name,
            location="West Europe",
            grafana_major_version="11",
            api_key_enabled=True,
            deterministic_outbound_ip_enabled=True,
            public_network_access_enabled=False,
            identity={
                "type": "SystemAssigned",
            },
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Dashboard` - 2023-09-01

        ## Import

        Dashboard Grafana can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:dashboard/grafana:Grafana example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Dashboard/grafana/workspace1
        ```

        :param str resource_name: The name of the resource.
        :param GrafanaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GrafanaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_key_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_generated_domain_name_label_scope: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_monitor_workspace_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GrafanaAzureMonitorWorkspaceIntegrationArgs', 'GrafanaAzureMonitorWorkspaceIntegrationArgsDict']]]]] = None,
                 deterministic_outbound_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 grafana_major_version: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['GrafanaIdentityArgs', 'GrafanaIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 smtp: Optional[pulumi.Input[Union['GrafanaSmtpArgs', 'GrafanaSmtpArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zone_redundancy_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GrafanaArgs.__new__(GrafanaArgs)

            __props__.__dict__["api_key_enabled"] = api_key_enabled
            __props__.__dict__["auto_generated_domain_name_label_scope"] = auto_generated_domain_name_label_scope
            __props__.__dict__["azure_monitor_workspace_integrations"] = azure_monitor_workspace_integrations
            __props__.__dict__["deterministic_outbound_ip_enabled"] = deterministic_outbound_ip_enabled
            if grafana_major_version is None and not opts.urn:
                raise TypeError("Missing required property 'grafana_major_version'")
            __props__.__dict__["grafana_major_version"] = grafana_major_version
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["sku"] = sku
            __props__.__dict__["smtp"] = smtp
            __props__.__dict__["tags"] = tags
            __props__.__dict__["zone_redundancy_enabled"] = zone_redundancy_enabled
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["grafana_version"] = None
            __props__.__dict__["outbound_ips"] = None
        super(Grafana, __self__).__init__(
            'azure:dashboard/grafana:Grafana',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_key_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_generated_domain_name_label_scope: Optional[pulumi.Input[_builtins.str]] = None,
            azure_monitor_workspace_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['GrafanaAzureMonitorWorkspaceIntegrationArgs', 'GrafanaAzureMonitorWorkspaceIntegrationArgsDict']]]]] = None,
            deterministic_outbound_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            grafana_major_version: Optional[pulumi.Input[_builtins.str]] = None,
            grafana_version: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['GrafanaIdentityArgs', 'GrafanaIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            outbound_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku: Optional[pulumi.Input[_builtins.str]] = None,
            smtp: Optional[pulumi.Input[Union['GrafanaSmtpArgs', 'GrafanaSmtpArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            zone_redundancy_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Grafana':
        """
        Get an existing Grafana resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] api_key_enabled: Whether to enable the api key setting of the Grafana instance. Defaults to `false`.
        :param pulumi.Input[_builtins.str] auto_generated_domain_name_label_scope: Scope for dns deterministic name hash calculation. The only possible value is `TenantReuse`. Defaults to `TenantReuse`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['GrafanaAzureMonitorWorkspaceIntegrationArgs', 'GrafanaAzureMonitorWorkspaceIntegrationArgsDict']]]] azure_monitor_workspace_integrations: A `azure_monitor_workspace_integrations` block as defined below.
        :param pulumi.Input[_builtins.bool] deterministic_outbound_ip_enabled: Whether to enable the Grafana instance to use deterministic outbound IPs. Defaults to `false`.
        :param pulumi.Input[_builtins.str] endpoint: The endpoint of the Grafana instance.
        :param pulumi.Input[_builtins.str] grafana_major_version: Which major version of Grafana to deploy. Possible values are `10`, `11`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] grafana_version: The full Grafana software semantic version deployed.
        :param pulumi.Input[Union['GrafanaIdentityArgs', 'GrafanaIdentityArgsDict']] identity: An `identity` block as defined below. Changing this forces a new Dashboard Grafana to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Dashboard Grafana should exist. Changing this forces a new Dashboard Grafana to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Dashboard Grafana. Changing this forces a new Dashboard Grafana to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] outbound_ips: List of outbound IPs if deterministicOutboundIP is enabled.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether to enable traffic over the public interface. Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Dashboard Grafana should exist. Changing this forces a new Dashboard Grafana to be created.
        :param pulumi.Input[_builtins.str] sku: The name of the SKU used for the Grafana instance. Possible values are `Standard` and `Essential`. Defaults to `Standard`. Changing this forces a new Dashboard Grafana to be created.
        :param pulumi.Input[Union['GrafanaSmtpArgs', 'GrafanaSmtpArgsDict']] smtp: A `smtp` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dashboard Grafana.
        :param pulumi.Input[_builtins.bool] zone_redundancy_enabled: Whether to enable the zone redundancy setting of the Grafana instance. Defaults to `false`. Changing this forces a new Dashboard Grafana to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GrafanaState.__new__(_GrafanaState)

        __props__.__dict__["api_key_enabled"] = api_key_enabled
        __props__.__dict__["auto_generated_domain_name_label_scope"] = auto_generated_domain_name_label_scope
        __props__.__dict__["azure_monitor_workspace_integrations"] = azure_monitor_workspace_integrations
        __props__.__dict__["deterministic_outbound_ip_enabled"] = deterministic_outbound_ip_enabled
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["grafana_major_version"] = grafana_major_version
        __props__.__dict__["grafana_version"] = grafana_version
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["outbound_ips"] = outbound_ips
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku"] = sku
        __props__.__dict__["smtp"] = smtp
        __props__.__dict__["tags"] = tags
        __props__.__dict__["zone_redundancy_enabled"] = zone_redundancy_enabled
        return Grafana(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiKeyEnabled")
    def api_key_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable the api key setting of the Grafana instance. Defaults to `false`.
        """
        return pulumi.get(self, "api_key_enabled")

    @_builtins.property
    @pulumi.getter(name="autoGeneratedDomainNameLabelScope")
    def auto_generated_domain_name_label_scope(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Scope for dns deterministic name hash calculation. The only possible value is `TenantReuse`. Defaults to `TenantReuse`.
        """
        return pulumi.get(self, "auto_generated_domain_name_label_scope")

    @_builtins.property
    @pulumi.getter(name="azureMonitorWorkspaceIntegrations")
    def azure_monitor_workspace_integrations(self) -> pulumi.Output[Optional[Sequence['outputs.GrafanaAzureMonitorWorkspaceIntegration']]]:
        """
        A `azure_monitor_workspace_integrations` block as defined below.
        """
        return pulumi.get(self, "azure_monitor_workspace_integrations")

    @_builtins.property
    @pulumi.getter(name="deterministicOutboundIpEnabled")
    def deterministic_outbound_ip_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable the Grafana instance to use deterministic outbound IPs. Defaults to `false`.
        """
        return pulumi.get(self, "deterministic_outbound_ip_enabled")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The endpoint of the Grafana instance.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter(name="grafanaMajorVersion")
    def grafana_major_version(self) -> pulumi.Output[_builtins.str]:
        """
        Which major version of Grafana to deploy. Possible values are `10`, `11`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "grafana_major_version")

    @_builtins.property
    @pulumi.getter(name="grafanaVersion")
    def grafana_version(self) -> pulumi.Output[_builtins.str]:
        """
        The full Grafana software semantic version deployed.
        """
        return pulumi.get(self, "grafana_version")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.GrafanaIdentity']]:
        """
        An `identity` block as defined below. Changing this forces a new Dashboard Grafana to be created.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Azure Region where the Dashboard Grafana should exist. Changing this forces a new Dashboard Grafana to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name which should be used for this Dashboard Grafana. Changing this forces a new Dashboard Grafana to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="outboundIps")
    def outbound_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of outbound IPs if deterministicOutboundIP is enabled.
        """
        return pulumi.get(self, "outbound_ips")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable traffic over the public interface. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Resource Group where the Dashboard Grafana should exist. Changing this forces a new Dashboard Grafana to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the SKU used for the Grafana instance. Possible values are `Standard` and `Essential`. Defaults to `Standard`. Changing this forces a new Dashboard Grafana to be created.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def smtp(self) -> pulumi.Output[Optional['outputs.GrafanaSmtp']]:
        """
        A `smtp` block as defined below.
        """
        return pulumi.get(self, "smtp")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Dashboard Grafana.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="zoneRedundancyEnabled")
    def zone_redundancy_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable the zone redundancy setting of the Grafana instance. Defaults to `false`. Changing this forces a new Dashboard Grafana to be created.
        """
        return pulumi.get(self, "zone_redundancy_enabled")

