# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetShareResult',
    'AwaitableGetShareResult',
    'get_share',
    'get_share_output',
]

@pulumi.output_type
class GetShareResult:
    """
    A collection of values returned by getShare.
    """
    def __init__(__self__, account_id=None, description=None, id=None, kind=None, name=None, snapshot_schedules=None, terms=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if snapshot_schedules and not isinstance(snapshot_schedules, list):
            raise TypeError("Expected argument 'snapshot_schedules' to be a list")
        pulumi.set(__self__, "snapshot_schedules", snapshot_schedules)
        if terms and not isinstance(terms, str):
            raise TypeError("Expected argument 'terms' to be a str")
        pulumi.set(__self__, "terms", terms)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the Data Share.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> _builtins.str:
        """
        The kind of the Data Share.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the snapshot schedule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="snapshotSchedules")
    def snapshot_schedules(self) -> Sequence['outputs.GetShareSnapshotScheduleResult']:
        """
        A `snapshot_schedule` block as defined below.
        """
        return pulumi.get(self, "snapshot_schedules")

    @_builtins.property
    @pulumi.getter
    def terms(self) -> _builtins.str:
        """
        The terms of the Data Share.
        """
        return pulumi.get(self, "terms")


class AwaitableGetShareResult(GetShareResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetShareResult(
            account_id=self.account_id,
            description=self.description,
            id=self.id,
            kind=self.kind,
            name=self.name,
            snapshot_schedules=self.snapshot_schedules,
            terms=self.terms)


def get_share(account_id: Optional[_builtins.str] = None,
              name: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetShareResult:
    """
    Use this data source to access information about an existing Data Share.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.datashare.get_account(name="example-account",
        resource_group_name="example-resource-group")
    example_get_share = azure.datashare.get_share(name="existing",
        account_id=example.id)
    pulumi.export("id", example_get_share.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DataShare` - 2019-11-01


    :param _builtins.str account_id: The ID of the Data Share account in which the Data Share is created.
    :param _builtins.str name: The name of this Data Share.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:datashare/getShare:getShare', __args__, opts=opts, typ=GetShareResult).value

    return AwaitableGetShareResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        kind=pulumi.get(__ret__, 'kind'),
        name=pulumi.get(__ret__, 'name'),
        snapshot_schedules=pulumi.get(__ret__, 'snapshot_schedules'),
        terms=pulumi.get(__ret__, 'terms'))
def get_share_output(account_id: Optional[pulumi.Input[_builtins.str]] = None,
                     name: Optional[pulumi.Input[_builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetShareResult]:
    """
    Use this data source to access information about an existing Data Share.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.datashare.get_account(name="example-account",
        resource_group_name="example-resource-group")
    example_get_share = azure.datashare.get_share(name="existing",
        account_id=example.id)
    pulumi.export("id", example_get_share.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DataShare` - 2019-11-01


    :param _builtins.str account_id: The ID of the Data Share account in which the Data Share is created.
    :param _builtins.str name: The name of this Data Share.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:datashare/getShare:getShare', __args__, opts=opts, typ=GetShareResult)
    return __ret__.apply(lambda __response__: GetShareResult(
        account_id=pulumi.get(__response__, 'account_id'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        kind=pulumi.get(__response__, 'kind'),
        name=pulumi.get(__response__, 'name'),
        snapshot_schedules=pulumi.get(__response__, 'snapshot_schedules'),
        terms=pulumi.get(__response__, 'terms')))
