# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DevCenterArgs', 'DevCenter']

@pulumi.input_type
class DevCenterArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 identity: Optional[pulumi.Input['DevCenterIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_catalog_item_sync_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a DevCenter resource.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group within which this Dev Center should exist. Changing this forces a new Dev Center to be created.
        :param pulumi.Input['DevCenterIdentityArgs'] identity: An `identity` block as defined below. Specifies the Managed Identity which should be assigned to this Dev Center.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dev Center should exist. Changing this forces a new Dev Center to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center. Changing this forces a new Dev Center to be created.
        :param pulumi.Input[_builtins.bool] project_catalog_item_sync_enabled: Whether the project catalogs associated with projects in this Dev Center are allowed to sync catalog items. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dev Center.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_catalog_item_sync_enabled is not None:
            pulumi.set(__self__, "project_catalog_item_sync_enabled", project_catalog_item_sync_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Resource Group within which this Dev Center should exist. Changing this forces a new Dev Center to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['DevCenterIdentityArgs']]:
        """
        An `identity` block as defined below. Specifies the Managed Identity which should be assigned to this Dev Center.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['DevCenterIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Dev Center should exist. Changing this forces a new Dev Center to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Dev Center. Changing this forces a new Dev Center to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectCatalogItemSyncEnabled")
    def project_catalog_item_sync_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the project catalogs associated with projects in this Dev Center are allowed to sync catalog items. Defaults to `false`.
        """
        return pulumi.get(self, "project_catalog_item_sync_enabled")

    @project_catalog_item_sync_enabled.setter
    def project_catalog_item_sync_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "project_catalog_item_sync_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Dev Center.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DevCenterState:
    def __init__(__self__, *,
                 dev_center_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['DevCenterIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_catalog_item_sync_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering DevCenter resources.
        :param pulumi.Input[_builtins.str] dev_center_uri: The URI of the Dev Center.
        :param pulumi.Input['DevCenterIdentityArgs'] identity: An `identity` block as defined below. Specifies the Managed Identity which should be assigned to this Dev Center.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dev Center should exist. Changing this forces a new Dev Center to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center. Changing this forces a new Dev Center to be created.
        :param pulumi.Input[_builtins.bool] project_catalog_item_sync_enabled: Whether the project catalogs associated with projects in this Dev Center are allowed to sync catalog items. Defaults to `false`.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group within which this Dev Center should exist. Changing this forces a new Dev Center to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dev Center.
        """
        if dev_center_uri is not None:
            pulumi.set(__self__, "dev_center_uri", dev_center_uri)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_catalog_item_sync_enabled is not None:
            pulumi.set(__self__, "project_catalog_item_sync_enabled", project_catalog_item_sync_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="devCenterUri")
    def dev_center_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the Dev Center.
        """
        return pulumi.get(self, "dev_center_uri")

    @dev_center_uri.setter
    def dev_center_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dev_center_uri", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['DevCenterIdentityArgs']]:
        """
        An `identity` block as defined below. Specifies the Managed Identity which should be assigned to this Dev Center.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['DevCenterIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Dev Center should exist. Changing this forces a new Dev Center to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Dev Center. Changing this forces a new Dev Center to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectCatalogItemSyncEnabled")
    def project_catalog_item_sync_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the project catalogs associated with projects in this Dev Center are allowed to sync catalog items. Defaults to `false`.
        """
        return pulumi.get(self, "project_catalog_item_sync_enabled")

    @project_catalog_item_sync_enabled.setter
    def project_catalog_item_sync_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "project_catalog_item_sync_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Resource Group within which this Dev Center should exist. Changing this forces a new Dev Center to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Dev Center.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:devcenter/devCenter:DevCenter")
class DevCenter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity: Optional[pulumi.Input[Union['DevCenterIdentityArgs', 'DevCenterIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_catalog_item_sync_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Dev Center.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="example",
            resource_group_name=example.name,
            location=example.location)
        example_dev_center = azure.devcenter.DevCenter("example",
            location=example.location,
            name="example",
            resource_group_name=example.name)
        ```

        ## Blocks Reference

        ### `identity` Block

        The `identity` block supports the following arguments:

        * `type` - (Required) Specifies the type of Managed Identity that should be assigned to this Dev Center. Possible values are `SystemAssigned`, `SystemAssigned, UserAssigned` and `UserAssigned`.
        * `identity_ids` - (Optional) A list of the User Assigned Identity IDs that should be assigned to this Dev Center.

        In addition to the arguments defined above, the `identity` block exports the following attributes:

        * `principal_id` - The Principal ID for the System-Assigned Managed Identity assigned to this Dev Center.
        * `tenant_id` - The Tenant ID for the System-Assigned Managed Identity assigned to this Dev Center.

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DevCenter` - 2025-02-01

        ## Import

        An existing Dev Center can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:devcenter/devCenter:DevCenter example /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/devCenters/{devCenterName}
        ```

        * Where `{subscriptionId}` is the ID of the Azure Subscription where the Dev Center exists. For example `12345678-1234-9876-4563-123456789012`.

        * Where `{resourceGroupName}` is the name of Resource Group where this Dev Center exists. For example `example-resource-group`.

        * Where `{devCenterName}` is the name of the Dev Center. For example `devCenterValue`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DevCenterIdentityArgs', 'DevCenterIdentityArgsDict']] identity: An `identity` block as defined below. Specifies the Managed Identity which should be assigned to this Dev Center.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dev Center should exist. Changing this forces a new Dev Center to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center. Changing this forces a new Dev Center to be created.
        :param pulumi.Input[_builtins.bool] project_catalog_item_sync_enabled: Whether the project catalogs associated with projects in this Dev Center are allowed to sync catalog items. Defaults to `false`.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group within which this Dev Center should exist. Changing this forces a new Dev Center to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dev Center.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DevCenterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Dev Center.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="example",
            resource_group_name=example.name,
            location=example.location)
        example_dev_center = azure.devcenter.DevCenter("example",
            location=example.location,
            name="example",
            resource_group_name=example.name)
        ```

        ## Blocks Reference

        ### `identity` Block

        The `identity` block supports the following arguments:

        * `type` - (Required) Specifies the type of Managed Identity that should be assigned to this Dev Center. Possible values are `SystemAssigned`, `SystemAssigned, UserAssigned` and `UserAssigned`.
        * `identity_ids` - (Optional) A list of the User Assigned Identity IDs that should be assigned to this Dev Center.

        In addition to the arguments defined above, the `identity` block exports the following attributes:

        * `principal_id` - The Principal ID for the System-Assigned Managed Identity assigned to this Dev Center.
        * `tenant_id` - The Tenant ID for the System-Assigned Managed Identity assigned to this Dev Center.

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DevCenter` - 2025-02-01

        ## Import

        An existing Dev Center can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:devcenter/devCenter:DevCenter example /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/devCenters/{devCenterName}
        ```

        * Where `{subscriptionId}` is the ID of the Azure Subscription where the Dev Center exists. For example `12345678-1234-9876-4563-123456789012`.

        * Where `{resourceGroupName}` is the name of Resource Group where this Dev Center exists. For example `example-resource-group`.

        * Where `{devCenterName}` is the name of the Dev Center. For example `devCenterValue`.

        :param str resource_name: The name of the resource.
        :param DevCenterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DevCenterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity: Optional[pulumi.Input[Union['DevCenterIdentityArgs', 'DevCenterIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_catalog_item_sync_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DevCenterArgs.__new__(DevCenterArgs)

            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project_catalog_item_sync_enabled"] = project_catalog_item_sync_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["dev_center_uri"] = None
        super(DevCenter, __self__).__init__(
            'azure:devcenter/devCenter:DevCenter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dev_center_uri: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['DevCenterIdentityArgs', 'DevCenterIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project_catalog_item_sync_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'DevCenter':
        """
        Get an existing DevCenter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] dev_center_uri: The URI of the Dev Center.
        :param pulumi.Input[Union['DevCenterIdentityArgs', 'DevCenterIdentityArgsDict']] identity: An `identity` block as defined below. Specifies the Managed Identity which should be assigned to this Dev Center.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dev Center should exist. Changing this forces a new Dev Center to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center. Changing this forces a new Dev Center to be created.
        :param pulumi.Input[_builtins.bool] project_catalog_item_sync_enabled: Whether the project catalogs associated with projects in this Dev Center are allowed to sync catalog items. Defaults to `false`.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group within which this Dev Center should exist. Changing this forces a new Dev Center to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dev Center.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DevCenterState.__new__(_DevCenterState)

        __props__.__dict__["dev_center_uri"] = dev_center_uri
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project_catalog_item_sync_enabled"] = project_catalog_item_sync_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        return DevCenter(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="devCenterUri")
    def dev_center_uri(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of the Dev Center.
        """
        return pulumi.get(self, "dev_center_uri")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.DevCenterIdentity']]:
        """
        An `identity` block as defined below. Specifies the Managed Identity which should be assigned to this Dev Center.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Dev Center should exist. Changing this forces a new Dev Center to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of this Dev Center. Changing this forces a new Dev Center to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectCatalogItemSyncEnabled")
    def project_catalog_item_sync_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the project catalogs associated with projects in this Dev Center are allowed to sync catalog items. Defaults to `false`.
        """
        return pulumi.get(self, "project_catalog_item_sync_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Resource Group within which this Dev Center should exist. Changing this forces a new Dev Center to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Dev Center.
        """
        return pulumi.get(self, "tags")

