# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 dev_center_id: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['ProjectIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_dev_boxes_per_user: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input[_builtins.str] dev_center_id: Resource Id of an associated DevCenter. Changing this forces a new Dev Center Project to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group within which this Dev Center Project should exist. Changing this forces a new Dev Center Project to be created.
        :param pulumi.Input[_builtins.str] description: Description of the project. Changing this forces a new Dev Center Project to be created.
        :param pulumi.Input['ProjectIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dev Center Project should exist. Changing this forces a new Dev Center Project to be created.
        :param pulumi.Input[_builtins.int] maximum_dev_boxes_per_user: When specified, limits the maximum number of Dev Boxes a single user can create across all pools in the project.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center Project. Changing this forces a new Dev Center Project to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dev Center Project.
        """
        pulumi.set(__self__, "dev_center_id", dev_center_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maximum_dev_boxes_per_user is not None:
            pulumi.set(__self__, "maximum_dev_boxes_per_user", maximum_dev_boxes_per_user)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="devCenterId")
    def dev_center_id(self) -> pulumi.Input[_builtins.str]:
        """
        Resource Id of an associated DevCenter. Changing this forces a new Dev Center Project to be created.
        """
        return pulumi.get(self, "dev_center_id")

    @dev_center_id.setter
    def dev_center_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "dev_center_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Resource Group within which this Dev Center Project should exist. Changing this forces a new Dev Center Project to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the project. Changing this forces a new Dev Center Project to be created.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ProjectIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ProjectIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Dev Center Project should exist. Changing this forces a new Dev Center Project to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maximumDevBoxesPerUser")
    def maximum_dev_boxes_per_user(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        When specified, limits the maximum number of Dev Boxes a single user can create across all pools in the project.
        """
        return pulumi.get(self, "maximum_dev_boxes_per_user")

    @maximum_dev_boxes_per_user.setter
    def maximum_dev_boxes_per_user(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_dev_boxes_per_user", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Dev Center Project. Changing this forces a new Dev Center Project to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Dev Center Project.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ProjectState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dev_center_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dev_center_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['ProjectIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_dev_boxes_per_user: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Project resources.
        :param pulumi.Input[_builtins.str] description: Description of the project. Changing this forces a new Dev Center Project to be created.
        :param pulumi.Input[_builtins.str] dev_center_id: Resource Id of an associated DevCenter. Changing this forces a new Dev Center Project to be created.
        :param pulumi.Input[_builtins.str] dev_center_uri: The URI of the Dev Center resource this project is associated with.
        :param pulumi.Input['ProjectIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dev Center Project should exist. Changing this forces a new Dev Center Project to be created.
        :param pulumi.Input[_builtins.int] maximum_dev_boxes_per_user: When specified, limits the maximum number of Dev Boxes a single user can create across all pools in the project.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center Project. Changing this forces a new Dev Center Project to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group within which this Dev Center Project should exist. Changing this forces a new Dev Center Project to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dev Center Project.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dev_center_id is not None:
            pulumi.set(__self__, "dev_center_id", dev_center_id)
        if dev_center_uri is not None:
            pulumi.set(__self__, "dev_center_uri", dev_center_uri)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maximum_dev_boxes_per_user is not None:
            pulumi.set(__self__, "maximum_dev_boxes_per_user", maximum_dev_boxes_per_user)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the project. Changing this forces a new Dev Center Project to be created.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="devCenterId")
    def dev_center_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource Id of an associated DevCenter. Changing this forces a new Dev Center Project to be created.
        """
        return pulumi.get(self, "dev_center_id")

    @dev_center_id.setter
    def dev_center_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dev_center_id", value)

    @_builtins.property
    @pulumi.getter(name="devCenterUri")
    def dev_center_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the Dev Center resource this project is associated with.
        """
        return pulumi.get(self, "dev_center_uri")

    @dev_center_uri.setter
    def dev_center_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dev_center_uri", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ProjectIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ProjectIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Dev Center Project should exist. Changing this forces a new Dev Center Project to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maximumDevBoxesPerUser")
    def maximum_dev_boxes_per_user(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        When specified, limits the maximum number of Dev Boxes a single user can create across all pools in the project.
        """
        return pulumi.get(self, "maximum_dev_boxes_per_user")

    @maximum_dev_boxes_per_user.setter
    def maximum_dev_boxes_per_user(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_dev_boxes_per_user", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Dev Center Project. Changing this forces a new Dev Center Project to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Resource Group within which this Dev Center Project should exist. Changing this forces a new Dev Center Project to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Dev Center Project.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:devcenter/project:Project")
class Project(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dev_center_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ProjectIdentityArgs', 'ProjectIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_dev_boxes_per_user: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Dev Center Project.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example = azure.devcenter.DevCenter("example",
            name="example",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            identity={
                "type": "example-value",
            })
        example_project = azure.devcenter.Project("example",
            dev_center_id=example.id,
            location=example_resource_group.location,
            name="example",
            resource_group_name=example_resource_group.name)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DevCenter` - 2025-02-01

        ## Import

        An existing Dev Center Project can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:devcenter/project:Project example /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/projects/{projectName}
        ```

        * Where `{subscriptionId}` is the ID of the Azure Subscription where the Dev Center Project exists. For example `12345678-1234-9876-4563-123456789012`.

        * Where `{resourceGroupName}` is the name of Resource Group where this Dev Center Project exists. For example `example-resource-group`.

        * Where `{projectName}` is the name of the Project. For example `projectValue`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the project. Changing this forces a new Dev Center Project to be created.
        :param pulumi.Input[_builtins.str] dev_center_id: Resource Id of an associated DevCenter. Changing this forces a new Dev Center Project to be created.
        :param pulumi.Input[Union['ProjectIdentityArgs', 'ProjectIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dev Center Project should exist. Changing this forces a new Dev Center Project to be created.
        :param pulumi.Input[_builtins.int] maximum_dev_boxes_per_user: When specified, limits the maximum number of Dev Boxes a single user can create across all pools in the project.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center Project. Changing this forces a new Dev Center Project to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group within which this Dev Center Project should exist. Changing this forces a new Dev Center Project to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dev Center Project.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Dev Center Project.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example = azure.devcenter.DevCenter("example",
            name="example",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            identity={
                "type": "example-value",
            })
        example_project = azure.devcenter.Project("example",
            dev_center_id=example.id,
            location=example_resource_group.location,
            name="example",
            resource_group_name=example_resource_group.name)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DevCenter` - 2025-02-01

        ## Import

        An existing Dev Center Project can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:devcenter/project:Project example /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/projects/{projectName}
        ```

        * Where `{subscriptionId}` is the ID of the Azure Subscription where the Dev Center Project exists. For example `12345678-1234-9876-4563-123456789012`.

        * Where `{resourceGroupName}` is the name of Resource Group where this Dev Center Project exists. For example `example-resource-group`.

        * Where `{projectName}` is the name of the Project. For example `projectValue`.

        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dev_center_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ProjectIdentityArgs', 'ProjectIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_dev_boxes_per_user: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            __props__.__dict__["description"] = description
            if dev_center_id is None and not opts.urn:
                raise TypeError("Missing required property 'dev_center_id'")
            __props__.__dict__["dev_center_id"] = dev_center_id
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["maximum_dev_boxes_per_user"] = maximum_dev_boxes_per_user
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["dev_center_uri"] = None
        super(Project, __self__).__init__(
            'azure:devcenter/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dev_center_id: Optional[pulumi.Input[_builtins.str]] = None,
            dev_center_uri: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['ProjectIdentityArgs', 'ProjectIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            maximum_dev_boxes_per_user: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description of the project. Changing this forces a new Dev Center Project to be created.
        :param pulumi.Input[_builtins.str] dev_center_id: Resource Id of an associated DevCenter. Changing this forces a new Dev Center Project to be created.
        :param pulumi.Input[_builtins.str] dev_center_uri: The URI of the Dev Center resource this project is associated with.
        :param pulumi.Input[Union['ProjectIdentityArgs', 'ProjectIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dev Center Project should exist. Changing this forces a new Dev Center Project to be created.
        :param pulumi.Input[_builtins.int] maximum_dev_boxes_per_user: When specified, limits the maximum number of Dev Boxes a single user can create across all pools in the project.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center Project. Changing this forces a new Dev Center Project to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group within which this Dev Center Project should exist. Changing this forces a new Dev Center Project to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dev Center Project.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectState.__new__(_ProjectState)

        __props__.__dict__["description"] = description
        __props__.__dict__["dev_center_id"] = dev_center_id
        __props__.__dict__["dev_center_uri"] = dev_center_uri
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["maximum_dev_boxes_per_user"] = maximum_dev_boxes_per_user
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        return Project(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the project. Changing this forces a new Dev Center Project to be created.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="devCenterId")
    def dev_center_id(self) -> pulumi.Output[_builtins.str]:
        """
        Resource Id of an associated DevCenter. Changing this forces a new Dev Center Project to be created.
        """
        return pulumi.get(self, "dev_center_id")

    @_builtins.property
    @pulumi.getter(name="devCenterUri")
    def dev_center_uri(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of the Dev Center resource this project is associated with.
        """
        return pulumi.get(self, "dev_center_uri")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.ProjectIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Dev Center Project should exist. Changing this forces a new Dev Center Project to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="maximumDevBoxesPerUser")
    def maximum_dev_boxes_per_user(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        When specified, limits the maximum number of Dev Boxes a single user can create across all pools in the project.
        """
        return pulumi.get(self, "maximum_dev_boxes_per_user")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of this Dev Center Project. Changing this forces a new Dev Center Project to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Resource Group within which this Dev Center Project should exist. Changing this forces a new Dev Center Project to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Dev Center Project.
        """
        return pulumi.get(self, "tags")

