# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVirtualNetworkResult',
    'AwaitableGetVirtualNetworkResult',
    'get_virtual_network',
    'get_virtual_network_output',
]

@pulumi.output_type
class GetVirtualNetworkResult:
    """
    A collection of values returned by getVirtualNetwork.
    """
    def __init__(__self__, allowed_subnets=None, id=None, lab_name=None, name=None, resource_group_name=None, subnet_overrides=None, unique_identifier=None):
        if allowed_subnets and not isinstance(allowed_subnets, list):
            raise TypeError("Expected argument 'allowed_subnets' to be a list")
        pulumi.set(__self__, "allowed_subnets", allowed_subnets)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lab_name and not isinstance(lab_name, str):
            raise TypeError("Expected argument 'lab_name' to be a str")
        pulumi.set(__self__, "lab_name", lab_name)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if subnet_overrides and not isinstance(subnet_overrides, list):
            raise TypeError("Expected argument 'subnet_overrides' to be a list")
        pulumi.set(__self__, "subnet_overrides", subnet_overrides)
        if unique_identifier and not isinstance(unique_identifier, str):
            raise TypeError("Expected argument 'unique_identifier' to be a str")
        pulumi.set(__self__, "unique_identifier", unique_identifier)

    @_builtins.property
    @pulumi.getter(name="allowedSubnets")
    def allowed_subnets(self) -> Sequence['outputs.GetVirtualNetworkAllowedSubnetResult']:
        """
        The list of subnets enabled for the virtual network as defined below.
        """
        return pulumi.get(self, "allowed_subnets")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="labName")
    def lab_name(self) -> _builtins.str:
        return pulumi.get(self, "lab_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="subnetOverrides")
    def subnet_overrides(self) -> Sequence['outputs.GetVirtualNetworkSubnetOverrideResult']:
        """
        The list of permission overrides for the subnets as defined below.
        """
        return pulumi.get(self, "subnet_overrides")

    @_builtins.property
    @pulumi.getter(name="uniqueIdentifier")
    def unique_identifier(self) -> _builtins.str:
        """
        The unique immutable identifier of the virtual network.
        """
        return pulumi.get(self, "unique_identifier")


class AwaitableGetVirtualNetworkResult(GetVirtualNetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVirtualNetworkResult(
            allowed_subnets=self.allowed_subnets,
            id=self.id,
            lab_name=self.lab_name,
            name=self.name,
            resource_group_name=self.resource_group_name,
            subnet_overrides=self.subnet_overrides,
            unique_identifier=self.unique_identifier)


def get_virtual_network(lab_name: Optional[_builtins.str] = None,
                        name: Optional[_builtins.str] = None,
                        resource_group_name: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVirtualNetworkResult:
    """
    Use this data source to access information about an existing Dev Test Lab Virtual Network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.devtest.get_virtual_network(name="example-network",
        lab_name="examplelab",
        resource_group_name="example-resource")
    pulumi.export("labSubnetName", example.allowed_subnets[0].lab_subnet_name)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DevTestLab` - 2018-09-15


    :param _builtins.str lab_name: Specifies the name of the Dev Test Lab.
    :param _builtins.str name: Specifies the name of the Virtual Network.
    :param _builtins.str resource_group_name: Specifies the name of the resource group that contains the Virtual Network.
    """
    __args__ = dict()
    __args__['labName'] = lab_name
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:devtest/getVirtualNetwork:getVirtualNetwork', __args__, opts=opts, typ=GetVirtualNetworkResult).value

    return AwaitableGetVirtualNetworkResult(
        allowed_subnets=pulumi.get(__ret__, 'allowed_subnets'),
        id=pulumi.get(__ret__, 'id'),
        lab_name=pulumi.get(__ret__, 'lab_name'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        subnet_overrides=pulumi.get(__ret__, 'subnet_overrides'),
        unique_identifier=pulumi.get(__ret__, 'unique_identifier'))
def get_virtual_network_output(lab_name: Optional[pulumi.Input[_builtins.str]] = None,
                               name: Optional[pulumi.Input[_builtins.str]] = None,
                               resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVirtualNetworkResult]:
    """
    Use this data source to access information about an existing Dev Test Lab Virtual Network.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.devtest.get_virtual_network(name="example-network",
        lab_name="examplelab",
        resource_group_name="example-resource")
    pulumi.export("labSubnetName", example.allowed_subnets[0].lab_subnet_name)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DevTestLab` - 2018-09-15


    :param _builtins.str lab_name: Specifies the name of the Dev Test Lab.
    :param _builtins.str name: Specifies the name of the Virtual Network.
    :param _builtins.str resource_group_name: Specifies the name of the resource group that contains the Virtual Network.
    """
    __args__ = dict()
    __args__['labName'] = lab_name
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:devtest/getVirtualNetwork:getVirtualNetwork', __args__, opts=opts, typ=GetVirtualNetworkResult)
    return __ret__.apply(lambda __response__: GetVirtualNetworkResult(
        allowed_subnets=pulumi.get(__response__, 'allowed_subnets'),
        id=pulumi.get(__response__, 'id'),
        lab_name=pulumi.get(__response__, 'lab_name'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        subnet_overrides=pulumi.get(__response__, 'subnet_overrides'),
        unique_identifier=pulumi.get(__response__, 'unique_identifier')))
