# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CertificateArgs', 'Certificate']

@pulumi.input_type
class CertificateArgs:
    def __init__(__self__, *,
                 certificate_content: pulumi.Input[_builtins.str],
                 iothub_name: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 is_verified: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Certificate resource.
        :param pulumi.Input[_builtins.str] certificate_content: The Base-64 representation of the X509 leaf certificate .cer file or just a .pem file content.
        :param pulumi.Input[_builtins.str] iothub_name: The name of the IoTHub that this certificate will be attached to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group under which the IotHub Certificate resource has to be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] is_verified: Is the certificate verified? Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the IotHub Certificate resource. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "certificate_content", certificate_content)
        pulumi.set(__self__, "iothub_name", iothub_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if is_verified is not None:
            pulumi.set(__self__, "is_verified", is_verified)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="certificateContent")
    def certificate_content(self) -> pulumi.Input[_builtins.str]:
        """
        The Base-64 representation of the X509 leaf certificate .cer file or just a .pem file content.
        """
        return pulumi.get(self, "certificate_content")

    @certificate_content.setter
    def certificate_content(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "certificate_content", value)

    @_builtins.property
    @pulumi.getter(name="iothubName")
    def iothub_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the IoTHub that this certificate will be attached to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iothub_name")

    @iothub_name.setter
    def iothub_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "iothub_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group under which the IotHub Certificate resource has to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="isVerified")
    def is_verified(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the certificate verified? Defaults to `false`.
        """
        return pulumi.get(self, "is_verified")

    @is_verified.setter
    def is_verified(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_verified", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the IotHub Certificate resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _CertificateState:
    def __init__(__self__, *,
                 certificate_content: Optional[pulumi.Input[_builtins.str]] = None,
                 iothub_name: Optional[pulumi.Input[_builtins.str]] = None,
                 is_verified: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Certificate resources.
        :param pulumi.Input[_builtins.str] certificate_content: The Base-64 representation of the X509 leaf certificate .cer file or just a .pem file content.
        :param pulumi.Input[_builtins.str] iothub_name: The name of the IoTHub that this certificate will be attached to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] is_verified: Is the certificate verified? Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the IotHub Certificate resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group under which the IotHub Certificate resource has to be created. Changing this forces a new resource to be created.
        """
        if certificate_content is not None:
            pulumi.set(__self__, "certificate_content", certificate_content)
        if iothub_name is not None:
            pulumi.set(__self__, "iothub_name", iothub_name)
        if is_verified is not None:
            pulumi.set(__self__, "is_verified", is_verified)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)

    @_builtins.property
    @pulumi.getter(name="certificateContent")
    def certificate_content(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Base-64 representation of the X509 leaf certificate .cer file or just a .pem file content.
        """
        return pulumi.get(self, "certificate_content")

    @certificate_content.setter
    def certificate_content(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_content", value)

    @_builtins.property
    @pulumi.getter(name="iothubName")
    def iothub_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IoTHub that this certificate will be attached to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iothub_name")

    @iothub_name.setter
    def iothub_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iothub_name", value)

    @_builtins.property
    @pulumi.getter(name="isVerified")
    def is_verified(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the certificate verified? Defaults to `false`.
        """
        return pulumi.get(self, "is_verified")

    @is_verified.setter
    def is_verified(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_verified", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the IotHub Certificate resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group under which the IotHub Certificate resource has to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)


@pulumi.type_token("azure:iot/certificate:Certificate")
class Certificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_content: Optional[pulumi.Input[_builtins.str]] = None,
                 iothub_name: Optional[pulumi.Input[_builtins.str]] = None,
                 is_verified: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an IotHub Certificate.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_io_t_hub = azure.iot.IoTHub("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            sku={
                "name": "B1",
                "capacity": 1,
            })
        example_certificate = azure.iot.Certificate("example",
            name="example",
            resource_group_name=example.name,
            iothub_name=example_io_t_hub.name,
            is_verified=True,
            certificate_content=std.filebase64(input="example.cer").result)
        ```

        ## Import

        IoTHub Certificates can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:iot/certificate:Certificate example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Devices/iotHubs/example/certificates/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_content: The Base-64 representation of the X509 leaf certificate .cer file or just a .pem file content.
        :param pulumi.Input[_builtins.str] iothub_name: The name of the IoTHub that this certificate will be attached to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] is_verified: Is the certificate verified? Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the IotHub Certificate resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group under which the IotHub Certificate resource has to be created. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an IotHub Certificate.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_io_t_hub = azure.iot.IoTHub("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            sku={
                "name": "B1",
                "capacity": 1,
            })
        example_certificate = azure.iot.Certificate("example",
            name="example",
            resource_group_name=example.name,
            iothub_name=example_io_t_hub.name,
            is_verified=True,
            certificate_content=std.filebase64(input="example.cer").result)
        ```

        ## Import

        IoTHub Certificates can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:iot/certificate:Certificate example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Devices/iotHubs/example/certificates/example
        ```

        :param str resource_name: The name of the resource.
        :param CertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_content: Optional[pulumi.Input[_builtins.str]] = None,
                 iothub_name: Optional[pulumi.Input[_builtins.str]] = None,
                 is_verified: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateArgs.__new__(CertificateArgs)

            if certificate_content is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_content'")
            __props__.__dict__["certificate_content"] = None if certificate_content is None else pulumi.Output.secret(certificate_content)
            if iothub_name is None and not opts.urn:
                raise TypeError("Missing required property 'iothub_name'")
            __props__.__dict__["iothub_name"] = iothub_name
            __props__.__dict__["is_verified"] = is_verified
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["certificateContent"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Certificate, __self__).__init__(
            'azure:iot/certificate:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_content: Optional[pulumi.Input[_builtins.str]] = None,
            iothub_name: Optional[pulumi.Input[_builtins.str]] = None,
            is_verified: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_content: The Base-64 representation of the X509 leaf certificate .cer file or just a .pem file content.
        :param pulumi.Input[_builtins.str] iothub_name: The name of the IoTHub that this certificate will be attached to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] is_verified: Is the certificate verified? Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the IotHub Certificate resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group under which the IotHub Certificate resource has to be created. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateState.__new__(_CertificateState)

        __props__.__dict__["certificate_content"] = certificate_content
        __props__.__dict__["iothub_name"] = iothub_name
        __props__.__dict__["is_verified"] = is_verified
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="certificateContent")
    def certificate_content(self) -> pulumi.Output[_builtins.str]:
        """
        The Base-64 representation of the X509 leaf certificate .cer file or just a .pem file content.
        """
        return pulumi.get(self, "certificate_content")

    @_builtins.property
    @pulumi.getter(name="iothubName")
    def iothub_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the IoTHub that this certificate will be attached to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iothub_name")

    @_builtins.property
    @pulumi.getter(name="isVerified")
    def is_verified(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is the certificate verified? Defaults to `false`.
        """
        return pulumi.get(self, "is_verified")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the IotHub Certificate resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group under which the IotHub Certificate resource has to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

