# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KeyVaultArgs', 'KeyVault']

@pulumi.input_type
class KeyVaultArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku_name: pulumi.Input[_builtins.str],
                 tenant_id: pulumi.Input[_builtins.str],
                 access_policies: Optional[pulumi.Input[Sequence[pulumi.Input['KeyVaultAccessPolicyArgs']]]] = None,
                 contacts: Optional[pulumi.Input[Sequence[pulumi.Input['KeyVaultContactArgs']]]] = None,
                 enable_rbac_authorization: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_for_deployment: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_for_disk_encryption: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_for_template_deployment: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_acls: Optional[pulumi.Input['KeyVaultNetworkAclsArgs']] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 purge_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 soft_delete_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a KeyVault resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Key Vault. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: The Name of the SKU used for this Key Vault. Possible values are `standard` and `premium`.
        :param pulumi.Input[_builtins.str] tenant_id: The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
        :param pulumi.Input[Sequence[pulumi.Input['KeyVaultAccessPolicyArgs']]] access_policies: A list of up to 1024 objects describing access policies, as described below.
               
               > **Note:** Since `access_policy` can be configured both inline and via the separate `keyvault.AccessPolicy` resource, we have to explicitly set it to empty slice (`[]`) to remove it.
        :param pulumi.Input[_builtins.bool] enable_rbac_authorization: Boolean flag to specify whether Azure Key Vault uses Role Based Access Control (RBAC) for authorization of data actions.
               
               > **Note:** Changing the permission model requires unrestricted (no conditions on the role assignment) `Microsoft.Authorization/roleAssignments/write` permission, which is part of the `Owner` and `User Access Administrator` roles. Classic subscription administrator roles like `Service Administrator` and `Co-Administrator`, or restricted `Key Vault Data Access Administrator` cannot be used to change the permission model. For more information, please see the [product documentation](https://learn.microsoft.com/azure/key-vault/general/rbac-guide?tabs=azure-cli#using-azure-rbac-secret-key-and-certificate-permissions-with-key-vault:~:text=Enable%20Azure%20RBAC,change%20permission%20model).
        :param pulumi.Input[_builtins.bool] enabled_for_deployment: Boolean flag to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key vault.
        :param pulumi.Input[_builtins.bool] enabled_for_disk_encryption: Boolean flag to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
        :param pulumi.Input[_builtins.bool] enabled_for_template_deployment: Boolean flag to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Key Vault. Changing this forces a new resource to be created. The name must be globally unique. If the vault is in a recoverable state then the vault will need to be purged before reusing the name.
        :param pulumi.Input['KeyVaultNetworkAclsArgs'] network_acls: A `network_acls` block as defined below.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is allowed for this Key Vault. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] purge_protection_enabled: Is Purge Protection enabled for this Key Vault? 
               
               !> **Note:** Once Purge Protection has been Enabled it's not possible to Disable it. Support for [disabling purge protection is being tracked in this Azure API issue](https://github.com/Azure/azure-rest-api-specs/issues/8075). Deleting the Key Vault with Purge Protection Enabled will schedule the Key Vault to be deleted (which will happen by Azure in the configured number of days, currently 90 days).
        :param pulumi.Input[_builtins.int] soft_delete_retention_days: The number of days that items should be retained for once soft-deleted. This value can be between `7` and `90` (the default) days.
               
               > **Note:** This field can only be configured one time and cannot be updated.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku_name", sku_name)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if access_policies is not None:
            pulumi.set(__self__, "access_policies", access_policies)
        if contacts is not None:
            warnings.warn("""As the `contact` property requires reaching out to the dataplane, to better support private endpoints and keyvaults with public network access disabled, new key vaults with the `contact` field defined in the configuration file will now be required to use the `keyvault.CertificateContacts` resource instead of the exposed `contact` field in the key vault resource itself.""", DeprecationWarning)
            pulumi.log.warn("""contacts is deprecated: As the `contact` property requires reaching out to the dataplane, to better support private endpoints and keyvaults with public network access disabled, new key vaults with the `contact` field defined in the configuration file will now be required to use the `keyvault.CertificateContacts` resource instead of the exposed `contact` field in the key vault resource itself.""")
        if contacts is not None:
            pulumi.set(__self__, "contacts", contacts)
        if enable_rbac_authorization is not None:
            pulumi.set(__self__, "enable_rbac_authorization", enable_rbac_authorization)
        if enabled_for_deployment is not None:
            pulumi.set(__self__, "enabled_for_deployment", enabled_for_deployment)
        if enabled_for_disk_encryption is not None:
            pulumi.set(__self__, "enabled_for_disk_encryption", enabled_for_disk_encryption)
        if enabled_for_template_deployment is not None:
            pulumi.set(__self__, "enabled_for_template_deployment", enabled_for_template_deployment)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_acls is not None:
            pulumi.set(__self__, "network_acls", network_acls)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if purge_protection_enabled is not None:
            pulumi.set(__self__, "purge_protection_enabled", purge_protection_enabled)
        if soft_delete_retention_days is not None:
            pulumi.set(__self__, "soft_delete_retention_days", soft_delete_retention_days)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the Key Vault. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Name of the SKU used for this Key Vault. Possible values are `standard` and `premium`.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="accessPolicies")
    def access_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeyVaultAccessPolicyArgs']]]]:
        """
        A list of up to 1024 objects describing access policies, as described below.

        > **Note:** Since `access_policy` can be configured both inline and via the separate `keyvault.AccessPolicy` resource, we have to explicitly set it to empty slice (`[]`) to remove it.
        """
        return pulumi.get(self, "access_policies")

    @access_policies.setter
    def access_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeyVaultAccessPolicyArgs']]]]):
        pulumi.set(self, "access_policies", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""As the `contact` property requires reaching out to the dataplane, to better support private endpoints and keyvaults with public network access disabled, new key vaults with the `contact` field defined in the configuration file will now be required to use the `keyvault.CertificateContacts` resource instead of the exposed `contact` field in the key vault resource itself.""")
    def contacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeyVaultContactArgs']]]]:
        return pulumi.get(self, "contacts")

    @contacts.setter
    def contacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeyVaultContactArgs']]]]):
        pulumi.set(self, "contacts", value)

    @_builtins.property
    @pulumi.getter(name="enableRbacAuthorization")
    def enable_rbac_authorization(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag to specify whether Azure Key Vault uses Role Based Access Control (RBAC) for authorization of data actions.

        > **Note:** Changing the permission model requires unrestricted (no conditions on the role assignment) `Microsoft.Authorization/roleAssignments/write` permission, which is part of the `Owner` and `User Access Administrator` roles. Classic subscription administrator roles like `Service Administrator` and `Co-Administrator`, or restricted `Key Vault Data Access Administrator` cannot be used to change the permission model. For more information, please see the [product documentation](https://learn.microsoft.com/azure/key-vault/general/rbac-guide?tabs=azure-cli#using-azure-rbac-secret-key-and-certificate-permissions-with-key-vault:~:text=Enable%20Azure%20RBAC,change%20permission%20model).
        """
        return pulumi.get(self, "enable_rbac_authorization")

    @enable_rbac_authorization.setter
    def enable_rbac_authorization(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_rbac_authorization", value)

    @_builtins.property
    @pulumi.getter(name="enabledForDeployment")
    def enabled_for_deployment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key vault.
        """
        return pulumi.get(self, "enabled_for_deployment")

    @enabled_for_deployment.setter
    def enabled_for_deployment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled_for_deployment", value)

    @_builtins.property
    @pulumi.getter(name="enabledForDiskEncryption")
    def enabled_for_disk_encryption(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
        """
        return pulumi.get(self, "enabled_for_disk_encryption")

    @enabled_for_disk_encryption.setter
    def enabled_for_disk_encryption(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled_for_disk_encryption", value)

    @_builtins.property
    @pulumi.getter(name="enabledForTemplateDeployment")
    def enabled_for_template_deployment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
        """
        return pulumi.get(self, "enabled_for_template_deployment")

    @enabled_for_template_deployment.setter
    def enabled_for_template_deployment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled_for_template_deployment", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Key Vault. Changing this forces a new resource to be created. The name must be globally unique. If the vault is in a recoverable state then the vault will need to be purged before reusing the name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkAcls")
    def network_acls(self) -> Optional[pulumi.Input['KeyVaultNetworkAclsArgs']]:
        """
        A `network_acls` block as defined below.
        """
        return pulumi.get(self, "network_acls")

    @network_acls.setter
    def network_acls(self, value: Optional[pulumi.Input['KeyVaultNetworkAclsArgs']]):
        pulumi.set(self, "network_acls", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether public network access is allowed for this Key Vault. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="purgeProtectionEnabled")
    def purge_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Purge Protection enabled for this Key Vault? 

        !> **Note:** Once Purge Protection has been Enabled it's not possible to Disable it. Support for [disabling purge protection is being tracked in this Azure API issue](https://github.com/Azure/azure-rest-api-specs/issues/8075). Deleting the Key Vault with Purge Protection Enabled will schedule the Key Vault to be deleted (which will happen by Azure in the configured number of days, currently 90 days).
        """
        return pulumi.get(self, "purge_protection_enabled")

    @purge_protection_enabled.setter
    def purge_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "purge_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="softDeleteRetentionDays")
    def soft_delete_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of days that items should be retained for once soft-deleted. This value can be between `7` and `90` (the default) days.

        > **Note:** This field can only be configured one time and cannot be updated.
        """
        return pulumi.get(self, "soft_delete_retention_days")

    @soft_delete_retention_days.setter
    def soft_delete_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "soft_delete_retention_days", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _KeyVaultState:
    def __init__(__self__, *,
                 access_policies: Optional[pulumi.Input[Sequence[pulumi.Input['KeyVaultAccessPolicyArgs']]]] = None,
                 contacts: Optional[pulumi.Input[Sequence[pulumi.Input['KeyVaultContactArgs']]]] = None,
                 enable_rbac_authorization: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_for_deployment: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_for_disk_encryption: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_for_template_deployment: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_acls: Optional[pulumi.Input['KeyVaultNetworkAclsArgs']] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 purge_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_delete_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vault_uri: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering KeyVault resources.
        :param pulumi.Input[Sequence[pulumi.Input['KeyVaultAccessPolicyArgs']]] access_policies: A list of up to 1024 objects describing access policies, as described below.
               
               > **Note:** Since `access_policy` can be configured both inline and via the separate `keyvault.AccessPolicy` resource, we have to explicitly set it to empty slice (`[]`) to remove it.
        :param pulumi.Input[_builtins.bool] enable_rbac_authorization: Boolean flag to specify whether Azure Key Vault uses Role Based Access Control (RBAC) for authorization of data actions.
               
               > **Note:** Changing the permission model requires unrestricted (no conditions on the role assignment) `Microsoft.Authorization/roleAssignments/write` permission, which is part of the `Owner` and `User Access Administrator` roles. Classic subscription administrator roles like `Service Administrator` and `Co-Administrator`, or restricted `Key Vault Data Access Administrator` cannot be used to change the permission model. For more information, please see the [product documentation](https://learn.microsoft.com/azure/key-vault/general/rbac-guide?tabs=azure-cli#using-azure-rbac-secret-key-and-certificate-permissions-with-key-vault:~:text=Enable%20Azure%20RBAC,change%20permission%20model).
        :param pulumi.Input[_builtins.bool] enabled_for_deployment: Boolean flag to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key vault.
        :param pulumi.Input[_builtins.bool] enabled_for_disk_encryption: Boolean flag to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
        :param pulumi.Input[_builtins.bool] enabled_for_template_deployment: Boolean flag to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Key Vault. Changing this forces a new resource to be created. The name must be globally unique. If the vault is in a recoverable state then the vault will need to be purged before reusing the name.
        :param pulumi.Input['KeyVaultNetworkAclsArgs'] network_acls: A `network_acls` block as defined below.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is allowed for this Key Vault. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] purge_protection_enabled: Is Purge Protection enabled for this Key Vault? 
               
               !> **Note:** Once Purge Protection has been Enabled it's not possible to Disable it. Support for [disabling purge protection is being tracked in this Azure API issue](https://github.com/Azure/azure-rest-api-specs/issues/8075). Deleting the Key Vault with Purge Protection Enabled will schedule the Key Vault to be deleted (which will happen by Azure in the configured number of days, currently 90 days).
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Key Vault. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: The Name of the SKU used for this Key Vault. Possible values are `standard` and `premium`.
        :param pulumi.Input[_builtins.int] soft_delete_retention_days: The number of days that items should be retained for once soft-deleted. This value can be between `7` and `90` (the default) days.
               
               > **Note:** This field can only be configured one time and cannot be updated.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] tenant_id: The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
        :param pulumi.Input[_builtins.str] vault_uri: The URI of the Key Vault, used for performing operations on keys and secrets.
        """
        if access_policies is not None:
            pulumi.set(__self__, "access_policies", access_policies)
        if contacts is not None:
            warnings.warn("""As the `contact` property requires reaching out to the dataplane, to better support private endpoints and keyvaults with public network access disabled, new key vaults with the `contact` field defined in the configuration file will now be required to use the `keyvault.CertificateContacts` resource instead of the exposed `contact` field in the key vault resource itself.""", DeprecationWarning)
            pulumi.log.warn("""contacts is deprecated: As the `contact` property requires reaching out to the dataplane, to better support private endpoints and keyvaults with public network access disabled, new key vaults with the `contact` field defined in the configuration file will now be required to use the `keyvault.CertificateContacts` resource instead of the exposed `contact` field in the key vault resource itself.""")
        if contacts is not None:
            pulumi.set(__self__, "contacts", contacts)
        if enable_rbac_authorization is not None:
            pulumi.set(__self__, "enable_rbac_authorization", enable_rbac_authorization)
        if enabled_for_deployment is not None:
            pulumi.set(__self__, "enabled_for_deployment", enabled_for_deployment)
        if enabled_for_disk_encryption is not None:
            pulumi.set(__self__, "enabled_for_disk_encryption", enabled_for_disk_encryption)
        if enabled_for_template_deployment is not None:
            pulumi.set(__self__, "enabled_for_template_deployment", enabled_for_template_deployment)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_acls is not None:
            pulumi.set(__self__, "network_acls", network_acls)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if purge_protection_enabled is not None:
            pulumi.set(__self__, "purge_protection_enabled", purge_protection_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if soft_delete_retention_days is not None:
            pulumi.set(__self__, "soft_delete_retention_days", soft_delete_retention_days)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if vault_uri is not None:
            pulumi.set(__self__, "vault_uri", vault_uri)

    @_builtins.property
    @pulumi.getter(name="accessPolicies")
    def access_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeyVaultAccessPolicyArgs']]]]:
        """
        A list of up to 1024 objects describing access policies, as described below.

        > **Note:** Since `access_policy` can be configured both inline and via the separate `keyvault.AccessPolicy` resource, we have to explicitly set it to empty slice (`[]`) to remove it.
        """
        return pulumi.get(self, "access_policies")

    @access_policies.setter
    def access_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeyVaultAccessPolicyArgs']]]]):
        pulumi.set(self, "access_policies", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""As the `contact` property requires reaching out to the dataplane, to better support private endpoints and keyvaults with public network access disabled, new key vaults with the `contact` field defined in the configuration file will now be required to use the `keyvault.CertificateContacts` resource instead of the exposed `contact` field in the key vault resource itself.""")
    def contacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeyVaultContactArgs']]]]:
        return pulumi.get(self, "contacts")

    @contacts.setter
    def contacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeyVaultContactArgs']]]]):
        pulumi.set(self, "contacts", value)

    @_builtins.property
    @pulumi.getter(name="enableRbacAuthorization")
    def enable_rbac_authorization(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag to specify whether Azure Key Vault uses Role Based Access Control (RBAC) for authorization of data actions.

        > **Note:** Changing the permission model requires unrestricted (no conditions on the role assignment) `Microsoft.Authorization/roleAssignments/write` permission, which is part of the `Owner` and `User Access Administrator` roles. Classic subscription administrator roles like `Service Administrator` and `Co-Administrator`, or restricted `Key Vault Data Access Administrator` cannot be used to change the permission model. For more information, please see the [product documentation](https://learn.microsoft.com/azure/key-vault/general/rbac-guide?tabs=azure-cli#using-azure-rbac-secret-key-and-certificate-permissions-with-key-vault:~:text=Enable%20Azure%20RBAC,change%20permission%20model).
        """
        return pulumi.get(self, "enable_rbac_authorization")

    @enable_rbac_authorization.setter
    def enable_rbac_authorization(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_rbac_authorization", value)

    @_builtins.property
    @pulumi.getter(name="enabledForDeployment")
    def enabled_for_deployment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key vault.
        """
        return pulumi.get(self, "enabled_for_deployment")

    @enabled_for_deployment.setter
    def enabled_for_deployment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled_for_deployment", value)

    @_builtins.property
    @pulumi.getter(name="enabledForDiskEncryption")
    def enabled_for_disk_encryption(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
        """
        return pulumi.get(self, "enabled_for_disk_encryption")

    @enabled_for_disk_encryption.setter
    def enabled_for_disk_encryption(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled_for_disk_encryption", value)

    @_builtins.property
    @pulumi.getter(name="enabledForTemplateDeployment")
    def enabled_for_template_deployment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Boolean flag to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
        """
        return pulumi.get(self, "enabled_for_template_deployment")

    @enabled_for_template_deployment.setter
    def enabled_for_template_deployment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled_for_template_deployment", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Key Vault. Changing this forces a new resource to be created. The name must be globally unique. If the vault is in a recoverable state then the vault will need to be purged before reusing the name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkAcls")
    def network_acls(self) -> Optional[pulumi.Input['KeyVaultNetworkAclsArgs']]:
        """
        A `network_acls` block as defined below.
        """
        return pulumi.get(self, "network_acls")

    @network_acls.setter
    def network_acls(self, value: Optional[pulumi.Input['KeyVaultNetworkAclsArgs']]):
        pulumi.set(self, "network_acls", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether public network access is allowed for this Key Vault. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="purgeProtectionEnabled")
    def purge_protection_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Purge Protection enabled for this Key Vault? 

        !> **Note:** Once Purge Protection has been Enabled it's not possible to Disable it. Support for [disabling purge protection is being tracked in this Azure API issue](https://github.com/Azure/azure-rest-api-specs/issues/8075). Deleting the Key Vault with Purge Protection Enabled will schedule the Key Vault to be deleted (which will happen by Azure in the configured number of days, currently 90 days).
        """
        return pulumi.get(self, "purge_protection_enabled")

    @purge_protection_enabled.setter
    def purge_protection_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "purge_protection_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the Key Vault. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name of the SKU used for this Key Vault. Possible values are `standard` and `premium`.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="softDeleteRetentionDays")
    def soft_delete_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of days that items should be retained for once soft-deleted. This value can be between `7` and `90` (the default) days.

        > **Note:** This field can only be configured one time and cannot be updated.
        """
        return pulumi.get(self, "soft_delete_retention_days")

    @soft_delete_retention_days.setter
    def soft_delete_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "soft_delete_retention_days", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="vaultUri")
    def vault_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI of the Key Vault, used for performing operations on keys and secrets.
        """
        return pulumi.get(self, "vault_uri")

    @vault_uri.setter
    def vault_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vault_uri", value)


@pulumi.type_token("azure:keyvault/keyVault:KeyVault")
class KeyVault(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KeyVaultAccessPolicyArgs', 'KeyVaultAccessPolicyArgsDict']]]]] = None,
                 contacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KeyVaultContactArgs', 'KeyVaultContactArgsDict']]]]] = None,
                 enable_rbac_authorization: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_for_deployment: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_for_disk_encryption: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_for_template_deployment: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_acls: Optional[pulumi.Input[Union['KeyVaultNetworkAclsArgs', 'KeyVaultNetworkAclsArgsDict']]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 purge_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_delete_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Key Vault.

        ## Disclaimers

        > **Note:** It's possible to define Key Vault Access Policies both within the `keyvault.KeyVault` resource via the `access_policy` block and by using the `keyvault.AccessPolicy` resource. However it's not possible to use both methods to manage Access Policies within a KeyVault, since there'll be conflicts.

        > **Note:** It's possible to define Key Vault Certificate Contacts both within the `keyvault.KeyVault` resource via the `contact` block and by using the `keyvault.CertificateContacts` resource. However it's not possible to use both methods to manage Certificate Contacts within a KeyVault, since there'll be conflicts.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            enabled_for_disk_encryption=True,
            tenant_id=current.tenant_id,
            soft_delete_retention_days=7,
            purge_protection_enabled=False,
            sku_name="standard",
            access_policies=[{
                "tenant_id": current.tenant_id,
                "object_id": current.object_id,
                "key_permissions": ["Get"],
                "secret_permissions": ["Get"],
                "storage_permissions": ["Get"],
            }])
        ```

        ## Import

        Key Vault's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:keyvault/keyVault:KeyVault example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.KeyVault/vaults/vault1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KeyVaultAccessPolicyArgs', 'KeyVaultAccessPolicyArgsDict']]]] access_policies: A list of up to 1024 objects describing access policies, as described below.
               
               > **Note:** Since `access_policy` can be configured both inline and via the separate `keyvault.AccessPolicy` resource, we have to explicitly set it to empty slice (`[]`) to remove it.
        :param pulumi.Input[_builtins.bool] enable_rbac_authorization: Boolean flag to specify whether Azure Key Vault uses Role Based Access Control (RBAC) for authorization of data actions.
               
               > **Note:** Changing the permission model requires unrestricted (no conditions on the role assignment) `Microsoft.Authorization/roleAssignments/write` permission, which is part of the `Owner` and `User Access Administrator` roles. Classic subscription administrator roles like `Service Administrator` and `Co-Administrator`, or restricted `Key Vault Data Access Administrator` cannot be used to change the permission model. For more information, please see the [product documentation](https://learn.microsoft.com/azure/key-vault/general/rbac-guide?tabs=azure-cli#using-azure-rbac-secret-key-and-certificate-permissions-with-key-vault:~:text=Enable%20Azure%20RBAC,change%20permission%20model).
        :param pulumi.Input[_builtins.bool] enabled_for_deployment: Boolean flag to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key vault.
        :param pulumi.Input[_builtins.bool] enabled_for_disk_encryption: Boolean flag to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
        :param pulumi.Input[_builtins.bool] enabled_for_template_deployment: Boolean flag to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Key Vault. Changing this forces a new resource to be created. The name must be globally unique. If the vault is in a recoverable state then the vault will need to be purged before reusing the name.
        :param pulumi.Input[Union['KeyVaultNetworkAclsArgs', 'KeyVaultNetworkAclsArgsDict']] network_acls: A `network_acls` block as defined below.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is allowed for this Key Vault. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] purge_protection_enabled: Is Purge Protection enabled for this Key Vault? 
               
               !> **Note:** Once Purge Protection has been Enabled it's not possible to Disable it. Support for [disabling purge protection is being tracked in this Azure API issue](https://github.com/Azure/azure-rest-api-specs/issues/8075). Deleting the Key Vault with Purge Protection Enabled will schedule the Key Vault to be deleted (which will happen by Azure in the configured number of days, currently 90 days).
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Key Vault. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: The Name of the SKU used for this Key Vault. Possible values are `standard` and `premium`.
        :param pulumi.Input[_builtins.int] soft_delete_retention_days: The number of days that items should be retained for once soft-deleted. This value can be between `7` and `90` (the default) days.
               
               > **Note:** This field can only be configured one time and cannot be updated.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] tenant_id: The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KeyVaultArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Key Vault.

        ## Disclaimers

        > **Note:** It's possible to define Key Vault Access Policies both within the `keyvault.KeyVault` resource via the `access_policy` block and by using the `keyvault.AccessPolicy` resource. However it's not possible to use both methods to manage Access Policies within a KeyVault, since there'll be conflicts.

        > **Note:** It's possible to define Key Vault Certificate Contacts both within the `keyvault.KeyVault` resource via the `contact` block and by using the `keyvault.CertificateContacts` resource. However it's not possible to use both methods to manage Certificate Contacts within a KeyVault, since there'll be conflicts.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            enabled_for_disk_encryption=True,
            tenant_id=current.tenant_id,
            soft_delete_retention_days=7,
            purge_protection_enabled=False,
            sku_name="standard",
            access_policies=[{
                "tenant_id": current.tenant_id,
                "object_id": current.object_id,
                "key_permissions": ["Get"],
                "secret_permissions": ["Get"],
                "storage_permissions": ["Get"],
            }])
        ```

        ## Import

        Key Vault's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:keyvault/keyVault:KeyVault example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.KeyVault/vaults/vault1
        ```

        :param str resource_name: The name of the resource.
        :param KeyVaultArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeyVaultArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KeyVaultAccessPolicyArgs', 'KeyVaultAccessPolicyArgsDict']]]]] = None,
                 contacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KeyVaultContactArgs', 'KeyVaultContactArgsDict']]]]] = None,
                 enable_rbac_authorization: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_for_deployment: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_for_disk_encryption: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_for_template_deployment: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_acls: Optional[pulumi.Input[Union['KeyVaultNetworkAclsArgs', 'KeyVaultNetworkAclsArgsDict']]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 purge_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_delete_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeyVaultArgs.__new__(KeyVaultArgs)

            __props__.__dict__["access_policies"] = access_policies
            __props__.__dict__["contacts"] = contacts
            __props__.__dict__["enable_rbac_authorization"] = enable_rbac_authorization
            __props__.__dict__["enabled_for_deployment"] = enabled_for_deployment
            __props__.__dict__["enabled_for_disk_encryption"] = enabled_for_disk_encryption
            __props__.__dict__["enabled_for_template_deployment"] = enabled_for_template_deployment
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["network_acls"] = network_acls
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            __props__.__dict__["purge_protection_enabled"] = purge_protection_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku_name is None and not opts.urn:
                raise TypeError("Missing required property 'sku_name'")
            __props__.__dict__["sku_name"] = sku_name
            __props__.__dict__["soft_delete_retention_days"] = soft_delete_retention_days
            __props__.__dict__["tags"] = tags
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["vault_uri"] = None
        super(KeyVault, __self__).__init__(
            'azure:keyvault/keyVault:KeyVault',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KeyVaultAccessPolicyArgs', 'KeyVaultAccessPolicyArgsDict']]]]] = None,
            contacts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KeyVaultContactArgs', 'KeyVaultContactArgsDict']]]]] = None,
            enable_rbac_authorization: Optional[pulumi.Input[_builtins.bool]] = None,
            enabled_for_deployment: Optional[pulumi.Input[_builtins.bool]] = None,
            enabled_for_disk_encryption: Optional[pulumi.Input[_builtins.bool]] = None,
            enabled_for_template_deployment: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_acls: Optional[pulumi.Input[Union['KeyVaultNetworkAclsArgs', 'KeyVaultNetworkAclsArgsDict']]] = None,
            public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            purge_protection_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku_name: Optional[pulumi.Input[_builtins.str]] = None,
            soft_delete_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            vault_uri: Optional[pulumi.Input[_builtins.str]] = None) -> 'KeyVault':
        """
        Get an existing KeyVault resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KeyVaultAccessPolicyArgs', 'KeyVaultAccessPolicyArgsDict']]]] access_policies: A list of up to 1024 objects describing access policies, as described below.
               
               > **Note:** Since `access_policy` can be configured both inline and via the separate `keyvault.AccessPolicy` resource, we have to explicitly set it to empty slice (`[]`) to remove it.
        :param pulumi.Input[_builtins.bool] enable_rbac_authorization: Boolean flag to specify whether Azure Key Vault uses Role Based Access Control (RBAC) for authorization of data actions.
               
               > **Note:** Changing the permission model requires unrestricted (no conditions on the role assignment) `Microsoft.Authorization/roleAssignments/write` permission, which is part of the `Owner` and `User Access Administrator` roles. Classic subscription administrator roles like `Service Administrator` and `Co-Administrator`, or restricted `Key Vault Data Access Administrator` cannot be used to change the permission model. For more information, please see the [product documentation](https://learn.microsoft.com/azure/key-vault/general/rbac-guide?tabs=azure-cli#using-azure-rbac-secret-key-and-certificate-permissions-with-key-vault:~:text=Enable%20Azure%20RBAC,change%20permission%20model).
        :param pulumi.Input[_builtins.bool] enabled_for_deployment: Boolean flag to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key vault.
        :param pulumi.Input[_builtins.bool] enabled_for_disk_encryption: Boolean flag to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
        :param pulumi.Input[_builtins.bool] enabled_for_template_deployment: Boolean flag to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Key Vault. Changing this forces a new resource to be created. The name must be globally unique. If the vault is in a recoverable state then the vault will need to be purged before reusing the name.
        :param pulumi.Input[Union['KeyVaultNetworkAclsArgs', 'KeyVaultNetworkAclsArgsDict']] network_acls: A `network_acls` block as defined below.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether public network access is allowed for this Key Vault. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] purge_protection_enabled: Is Purge Protection enabled for this Key Vault? 
               
               !> **Note:** Once Purge Protection has been Enabled it's not possible to Disable it. Support for [disabling purge protection is being tracked in this Azure API issue](https://github.com/Azure/azure-rest-api-specs/issues/8075). Deleting the Key Vault with Purge Protection Enabled will schedule the Key Vault to be deleted (which will happen by Azure in the configured number of days, currently 90 days).
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Key Vault. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: The Name of the SKU used for this Key Vault. Possible values are `standard` and `premium`.
        :param pulumi.Input[_builtins.int] soft_delete_retention_days: The number of days that items should be retained for once soft-deleted. This value can be between `7` and `90` (the default) days.
               
               > **Note:** This field can only be configured one time and cannot be updated.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] tenant_id: The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
        :param pulumi.Input[_builtins.str] vault_uri: The URI of the Key Vault, used for performing operations on keys and secrets.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeyVaultState.__new__(_KeyVaultState)

        __props__.__dict__["access_policies"] = access_policies
        __props__.__dict__["contacts"] = contacts
        __props__.__dict__["enable_rbac_authorization"] = enable_rbac_authorization
        __props__.__dict__["enabled_for_deployment"] = enabled_for_deployment
        __props__.__dict__["enabled_for_disk_encryption"] = enabled_for_disk_encryption
        __props__.__dict__["enabled_for_template_deployment"] = enabled_for_template_deployment
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["network_acls"] = network_acls
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["purge_protection_enabled"] = purge_protection_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["soft_delete_retention_days"] = soft_delete_retention_days
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["vault_uri"] = vault_uri
        return KeyVault(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessPolicies")
    def access_policies(self) -> pulumi.Output[Sequence['outputs.KeyVaultAccessPolicy']]:
        """
        A list of up to 1024 objects describing access policies, as described below.

        > **Note:** Since `access_policy` can be configured both inline and via the separate `keyvault.AccessPolicy` resource, we have to explicitly set it to empty slice (`[]`) to remove it.
        """
        return pulumi.get(self, "access_policies")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""As the `contact` property requires reaching out to the dataplane, to better support private endpoints and keyvaults with public network access disabled, new key vaults with the `contact` field defined in the configuration file will now be required to use the `keyvault.CertificateContacts` resource instead of the exposed `contact` field in the key vault resource itself.""")
    def contacts(self) -> pulumi.Output[Sequence['outputs.KeyVaultContact']]:
        return pulumi.get(self, "contacts")

    @_builtins.property
    @pulumi.getter(name="enableRbacAuthorization")
    def enable_rbac_authorization(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean flag to specify whether Azure Key Vault uses Role Based Access Control (RBAC) for authorization of data actions.

        > **Note:** Changing the permission model requires unrestricted (no conditions on the role assignment) `Microsoft.Authorization/roleAssignments/write` permission, which is part of the `Owner` and `User Access Administrator` roles. Classic subscription administrator roles like `Service Administrator` and `Co-Administrator`, or restricted `Key Vault Data Access Administrator` cannot be used to change the permission model. For more information, please see the [product documentation](https://learn.microsoft.com/azure/key-vault/general/rbac-guide?tabs=azure-cli#using-azure-rbac-secret-key-and-certificate-permissions-with-key-vault:~:text=Enable%20Azure%20RBAC,change%20permission%20model).
        """
        return pulumi.get(self, "enable_rbac_authorization")

    @_builtins.property
    @pulumi.getter(name="enabledForDeployment")
    def enabled_for_deployment(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean flag to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key vault.
        """
        return pulumi.get(self, "enabled_for_deployment")

    @_builtins.property
    @pulumi.getter(name="enabledForDiskEncryption")
    def enabled_for_disk_encryption(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean flag to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
        """
        return pulumi.get(self, "enabled_for_disk_encryption")

    @_builtins.property
    @pulumi.getter(name="enabledForTemplateDeployment")
    def enabled_for_template_deployment(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Boolean flag to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
        """
        return pulumi.get(self, "enabled_for_template_deployment")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Key Vault. Changing this forces a new resource to be created. The name must be globally unique. If the vault is in a recoverable state then the vault will need to be purged before reusing the name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkAcls")
    def network_acls(self) -> pulumi.Output['outputs.KeyVaultNetworkAcls']:
        """
        A `network_acls` block as defined below.
        """
        return pulumi.get(self, "network_acls")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether public network access is allowed for this Key Vault. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="purgeProtectionEnabled")
    def purge_protection_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is Purge Protection enabled for this Key Vault? 

        !> **Note:** Once Purge Protection has been Enabled it's not possible to Disable it. Support for [disabling purge protection is being tracked in this Azure API issue](https://github.com/Azure/azure-rest-api-specs/issues/8075). Deleting the Key Vault with Purge Protection Enabled will schedule the Key Vault to be deleted (which will happen by Azure in the configured number of days, currently 90 days).
        """
        return pulumi.get(self, "purge_protection_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the Key Vault. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Name of the SKU used for this Key Vault. Possible values are `standard` and `premium`.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter(name="softDeleteRetentionDays")
    def soft_delete_retention_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of days that items should be retained for once soft-deleted. This value can be between `7` and `90` (the default) days.

        > **Note:** This field can only be configured one time and cannot be updated.
        """
        return pulumi.get(self, "soft_delete_retention_days")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="vaultUri")
    def vault_uri(self) -> pulumi.Output[_builtins.str]:
        """
        The URI of the Key Vault, used for performing operations on keys and secrets.
        """
        return pulumi.get(self, "vault_uri")

