# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ManagedHardwareSecurityModuleKeyRotationPolicyArgs', 'ManagedHardwareSecurityModuleKeyRotationPolicy']

@pulumi.input_type
class ManagedHardwareSecurityModuleKeyRotationPolicyArgs:
    def __init__(__self__, *,
                 expire_after: pulumi.Input[_builtins.str],
                 managed_hsm_key_id: pulumi.Input[_builtins.str],
                 time_after_creation: Optional[pulumi.Input[_builtins.str]] = None,
                 time_before_expiry: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ManagedHardwareSecurityModuleKeyRotationPolicy resource.
        :param pulumi.Input[_builtins.str] expire_after: Specify the expiration duration on a newly rotated key as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). The minimum duration is `P28D`.
        :param pulumi.Input[_builtins.str] managed_hsm_key_id: The ID of the Managed HSM Key. Changing this forces a new Managed HSM Key rotation policy to be created.
        :param pulumi.Input[_builtins.str] time_after_creation: Rotate automatically at a duration after key creation as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). Exactly one of `time_after_creation` or `time_before_expiry` should be specified.
        :param pulumi.Input[_builtins.str] time_before_expiry: Rotate automatically at a duration before key expiry as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). Exactly one of `time_after_creation` or `time_before_expiry` should be specified.
        """
        pulumi.set(__self__, "expire_after", expire_after)
        pulumi.set(__self__, "managed_hsm_key_id", managed_hsm_key_id)
        if time_after_creation is not None:
            pulumi.set(__self__, "time_after_creation", time_after_creation)
        if time_before_expiry is not None:
            pulumi.set(__self__, "time_before_expiry", time_before_expiry)

    @_builtins.property
    @pulumi.getter(name="expireAfter")
    def expire_after(self) -> pulumi.Input[_builtins.str]:
        """
        Specify the expiration duration on a newly rotated key as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). The minimum duration is `P28D`.
        """
        return pulumi.get(self, "expire_after")

    @expire_after.setter
    def expire_after(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "expire_after", value)

    @_builtins.property
    @pulumi.getter(name="managedHsmKeyId")
    def managed_hsm_key_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Managed HSM Key. Changing this forces a new Managed HSM Key rotation policy to be created.
        """
        return pulumi.get(self, "managed_hsm_key_id")

    @managed_hsm_key_id.setter
    def managed_hsm_key_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "managed_hsm_key_id", value)

    @_builtins.property
    @pulumi.getter(name="timeAfterCreation")
    def time_after_creation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rotate automatically at a duration after key creation as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). Exactly one of `time_after_creation` or `time_before_expiry` should be specified.
        """
        return pulumi.get(self, "time_after_creation")

    @time_after_creation.setter
    def time_after_creation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_after_creation", value)

    @_builtins.property
    @pulumi.getter(name="timeBeforeExpiry")
    def time_before_expiry(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rotate automatically at a duration before key expiry as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). Exactly one of `time_after_creation` or `time_before_expiry` should be specified.
        """
        return pulumi.get(self, "time_before_expiry")

    @time_before_expiry.setter
    def time_before_expiry(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_before_expiry", value)


@pulumi.input_type
class _ManagedHardwareSecurityModuleKeyRotationPolicyState:
    def __init__(__self__, *,
                 expire_after: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_hsm_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_after_creation: Optional[pulumi.Input[_builtins.str]] = None,
                 time_before_expiry: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedHardwareSecurityModuleKeyRotationPolicy resources.
        :param pulumi.Input[_builtins.str] expire_after: Specify the expiration duration on a newly rotated key as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). The minimum duration is `P28D`.
        :param pulumi.Input[_builtins.str] managed_hsm_key_id: The ID of the Managed HSM Key. Changing this forces a new Managed HSM Key rotation policy to be created.
        :param pulumi.Input[_builtins.str] time_after_creation: Rotate automatically at a duration after key creation as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). Exactly one of `time_after_creation` or `time_before_expiry` should be specified.
        :param pulumi.Input[_builtins.str] time_before_expiry: Rotate automatically at a duration before key expiry as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). Exactly one of `time_after_creation` or `time_before_expiry` should be specified.
        """
        if expire_after is not None:
            pulumi.set(__self__, "expire_after", expire_after)
        if managed_hsm_key_id is not None:
            pulumi.set(__self__, "managed_hsm_key_id", managed_hsm_key_id)
        if time_after_creation is not None:
            pulumi.set(__self__, "time_after_creation", time_after_creation)
        if time_before_expiry is not None:
            pulumi.set(__self__, "time_before_expiry", time_before_expiry)

    @_builtins.property
    @pulumi.getter(name="expireAfter")
    def expire_after(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the expiration duration on a newly rotated key as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). The minimum duration is `P28D`.
        """
        return pulumi.get(self, "expire_after")

    @expire_after.setter
    def expire_after(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expire_after", value)

    @_builtins.property
    @pulumi.getter(name="managedHsmKeyId")
    def managed_hsm_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Managed HSM Key. Changing this forces a new Managed HSM Key rotation policy to be created.
        """
        return pulumi.get(self, "managed_hsm_key_id")

    @managed_hsm_key_id.setter
    def managed_hsm_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_hsm_key_id", value)

    @_builtins.property
    @pulumi.getter(name="timeAfterCreation")
    def time_after_creation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rotate automatically at a duration after key creation as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). Exactly one of `time_after_creation` or `time_before_expiry` should be specified.
        """
        return pulumi.get(self, "time_after_creation")

    @time_after_creation.setter
    def time_after_creation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_after_creation", value)

    @_builtins.property
    @pulumi.getter(name="timeBeforeExpiry")
    def time_before_expiry(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Rotate automatically at a duration before key expiry as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). Exactly one of `time_after_creation` or `time_before_expiry` should be specified.
        """
        return pulumi.get(self, "time_before_expiry")

    @time_before_expiry.setter
    def time_before_expiry(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_before_expiry", value)


@pulumi.type_token("azure:keyvault/managedHardwareSecurityModuleKeyRotationPolicy:ManagedHardwareSecurityModuleKeyRotationPolicy")
class ManagedHardwareSecurityModuleKeyRotationPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expire_after: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_hsm_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_after_creation: Optional[pulumi.Input[_builtins.str]] = None,
                 time_before_expiry: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Managed HSM Key rotation policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.keyvault.ManagedHardwareSecurityModuleKey("example",
            name="example-key",
            managed_hsm_id=example_azurerm_key_vault_managed_hardware_security_module["id"],
            key_type="EC-HSM",
            curve="P-521",
            key_opts=["sign"])
        example_managed_hardware_security_module_key_rotation_policy = azure.keyvault.ManagedHardwareSecurityModuleKeyRotationPolicy("example",
            managed_hsm_key_id=example.id,
            expire_after="P60D",
            time_before_expiry="P30D")
        ```

        ## Import

        Managed HSM Key rotation policy can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:keyvault/managedHardwareSecurityModuleKeyRotationPolicy:ManagedHardwareSecurityModuleKeyRotationPolicy example https://example-hsm.managedhsm.azure.net/keys/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] expire_after: Specify the expiration duration on a newly rotated key as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). The minimum duration is `P28D`.
        :param pulumi.Input[_builtins.str] managed_hsm_key_id: The ID of the Managed HSM Key. Changing this forces a new Managed HSM Key rotation policy to be created.
        :param pulumi.Input[_builtins.str] time_after_creation: Rotate automatically at a duration after key creation as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). Exactly one of `time_after_creation` or `time_before_expiry` should be specified.
        :param pulumi.Input[_builtins.str] time_before_expiry: Rotate automatically at a duration before key expiry as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). Exactly one of `time_after_creation` or `time_before_expiry` should be specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedHardwareSecurityModuleKeyRotationPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Managed HSM Key rotation policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.keyvault.ManagedHardwareSecurityModuleKey("example",
            name="example-key",
            managed_hsm_id=example_azurerm_key_vault_managed_hardware_security_module["id"],
            key_type="EC-HSM",
            curve="P-521",
            key_opts=["sign"])
        example_managed_hardware_security_module_key_rotation_policy = azure.keyvault.ManagedHardwareSecurityModuleKeyRotationPolicy("example",
            managed_hsm_key_id=example.id,
            expire_after="P60D",
            time_before_expiry="P30D")
        ```

        ## Import

        Managed HSM Key rotation policy can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:keyvault/managedHardwareSecurityModuleKeyRotationPolicy:ManagedHardwareSecurityModuleKeyRotationPolicy example https://example-hsm.managedhsm.azure.net/keys/example
        ```

        :param str resource_name: The name of the resource.
        :param ManagedHardwareSecurityModuleKeyRotationPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedHardwareSecurityModuleKeyRotationPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expire_after: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_hsm_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_after_creation: Optional[pulumi.Input[_builtins.str]] = None,
                 time_before_expiry: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedHardwareSecurityModuleKeyRotationPolicyArgs.__new__(ManagedHardwareSecurityModuleKeyRotationPolicyArgs)

            if expire_after is None and not opts.urn:
                raise TypeError("Missing required property 'expire_after'")
            __props__.__dict__["expire_after"] = expire_after
            if managed_hsm_key_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_hsm_key_id'")
            __props__.__dict__["managed_hsm_key_id"] = managed_hsm_key_id
            __props__.__dict__["time_after_creation"] = time_after_creation
            __props__.__dict__["time_before_expiry"] = time_before_expiry
        super(ManagedHardwareSecurityModuleKeyRotationPolicy, __self__).__init__(
            'azure:keyvault/managedHardwareSecurityModuleKeyRotationPolicy:ManagedHardwareSecurityModuleKeyRotationPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            expire_after: Optional[pulumi.Input[_builtins.str]] = None,
            managed_hsm_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            time_after_creation: Optional[pulumi.Input[_builtins.str]] = None,
            time_before_expiry: Optional[pulumi.Input[_builtins.str]] = None) -> 'ManagedHardwareSecurityModuleKeyRotationPolicy':
        """
        Get an existing ManagedHardwareSecurityModuleKeyRotationPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] expire_after: Specify the expiration duration on a newly rotated key as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). The minimum duration is `P28D`.
        :param pulumi.Input[_builtins.str] managed_hsm_key_id: The ID of the Managed HSM Key. Changing this forces a new Managed HSM Key rotation policy to be created.
        :param pulumi.Input[_builtins.str] time_after_creation: Rotate automatically at a duration after key creation as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). Exactly one of `time_after_creation` or `time_before_expiry` should be specified.
        :param pulumi.Input[_builtins.str] time_before_expiry: Rotate automatically at a duration before key expiry as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). Exactly one of `time_after_creation` or `time_before_expiry` should be specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedHardwareSecurityModuleKeyRotationPolicyState.__new__(_ManagedHardwareSecurityModuleKeyRotationPolicyState)

        __props__.__dict__["expire_after"] = expire_after
        __props__.__dict__["managed_hsm_key_id"] = managed_hsm_key_id
        __props__.__dict__["time_after_creation"] = time_after_creation
        __props__.__dict__["time_before_expiry"] = time_before_expiry
        return ManagedHardwareSecurityModuleKeyRotationPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="expireAfter")
    def expire_after(self) -> pulumi.Output[_builtins.str]:
        """
        Specify the expiration duration on a newly rotated key as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). The minimum duration is `P28D`.
        """
        return pulumi.get(self, "expire_after")

    @_builtins.property
    @pulumi.getter(name="managedHsmKeyId")
    def managed_hsm_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Managed HSM Key. Changing this forces a new Managed HSM Key rotation policy to be created.
        """
        return pulumi.get(self, "managed_hsm_key_id")

    @_builtins.property
    @pulumi.getter(name="timeAfterCreation")
    def time_after_creation(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rotate automatically at a duration after key creation as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). Exactly one of `time_after_creation` or `time_before_expiry` should be specified.
        """
        return pulumi.get(self, "time_after_creation")

    @_builtins.property
    @pulumi.getter(name="timeBeforeExpiry")
    def time_before_expiry(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Rotate automatically at a duration before key expiry as an [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). Exactly one of `time_after_creation` or `time_before_expiry` should be specified.
        """
        return pulumi.get(self, "time_before_expiry")

