# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku: pulumi.Input['ClusterSkuArgs'],
                 allowed_fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_stop_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 disk_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 double_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['ClusterIdentityArgs']] = None,
                 language_extensions: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLanguageExtensionArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 optimized_auto_scale: Optional[pulumi.Input['ClusterOptimizedAutoScaleArgs']] = None,
                 outbound_network_access_restricted: Optional[pulumi.Input[_builtins.bool]] = None,
                 public_ip_type: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 purge_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 streaming_ingestion_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 trusted_external_tenants: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_configuration: Optional[pulumi.Input['ClusterVirtualNetworkConfigurationArgs']] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the Resource Group where the Kusto Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['ClusterSkuArgs'] sku: A `sku` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_fqdns: List of allowed FQDNs(Fully Qualified Domain Name) for egress from Cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_ip_ranges: The list of ips in the format of CIDR allowed to connect to the cluster.
        :param pulumi.Input[_builtins.bool] auto_stop_enabled: Specifies if the cluster could be automatically stopped (due to lack of data or no activity for many days). Defaults to `true`.
        :param pulumi.Input[_builtins.bool] disk_encryption_enabled: Specifies if the cluster's disks are encrypted.
        :param pulumi.Input[_builtins.bool] double_encryption_enabled: Is the cluster's double encryption enabled? Changing this forces a new resource to be created.
        :param pulumi.Input['ClusterIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterLanguageExtensionArgs']]] language_extensions: An list of `language_extensions` to enable. Valid values are: `PYTHON`, `PYTHON_3.10.8` and `R`. `PYTHON` is used to specify Python 3.6.5 image and `PYTHON_3.10.8` is used to specify Python 3.10.8 image. Note that `PYTHON_3.10.8` is only available in skus which support nested virtualization.
               
               > **Note:** In `v4.0.0` and later version of the AzureRM Provider, `language_extensions` will be changed to a list of `language_extension` block. In each block, `name` and `image` are required. `name` is the name of the language extension, possible values are `PYTHON`, `R`. `image` is the image of the language extension, possible values are `Python3_6_5`, `Python3_10_8` and `R`.
        :param pulumi.Input[_builtins.str] location: The location where the Kusto Cluster should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Kusto Cluster to create. Only lowercase Alphanumeric characters allowed, starting with a letter. Changing this forces a new resource to be created.
        :param pulumi.Input['ClusterOptimizedAutoScaleArgs'] optimized_auto_scale: An `optimized_auto_scale` block as defined below.
        :param pulumi.Input[_builtins.bool] outbound_network_access_restricted: Whether to restrict outbound network access. Value is optional but if passed in, must be `true` or `false`, default is `false`.
        :param pulumi.Input[_builtins.str] public_ip_type: Indicates what public IP type to create - IPv4 (default), or DualStack (both IPv4 and IPv6). Defaults to `IPv4`.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Is the public network access enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] purge_enabled: Specifies if the purge operations are enabled.
        :param pulumi.Input[_builtins.bool] streaming_ingestion_enabled: Specifies if the streaming ingest is enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] trusted_external_tenants: Specifies a list of tenant IDs that are trusted by the cluster. Default setting trusts all other tenants. Use `trusted_external_tenants = ["*"]` to explicitly allow all other tenants, `trusted_external_tenants = ["MyTenantOnly"]` for only your tenant or `trusted_external_tenants = ["<tenantId1>", "<tenantIdx>"]` to allow specific other tenants.
               
               > **Note:** In v3.0 of `azurerm` a new or updated Kusto Cluster will only allow your own tenant by default. Explicit configuration of this setting will change from `trusted_external_tenants = ["MyTenantOnly"]` to `trusted_external_tenants = []`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Kusto Cluster should be located. Changing this forces a new Kusto Cluster to be created.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku", sku)
        if allowed_fqdns is not None:
            pulumi.set(__self__, "allowed_fqdns", allowed_fqdns)
        if allowed_ip_ranges is not None:
            pulumi.set(__self__, "allowed_ip_ranges", allowed_ip_ranges)
        if auto_stop_enabled is not None:
            pulumi.set(__self__, "auto_stop_enabled", auto_stop_enabled)
        if disk_encryption_enabled is not None:
            pulumi.set(__self__, "disk_encryption_enabled", disk_encryption_enabled)
        if double_encryption_enabled is not None:
            pulumi.set(__self__, "double_encryption_enabled", double_encryption_enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if language_extensions is not None:
            pulumi.set(__self__, "language_extensions", language_extensions)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optimized_auto_scale is not None:
            pulumi.set(__self__, "optimized_auto_scale", optimized_auto_scale)
        if outbound_network_access_restricted is not None:
            pulumi.set(__self__, "outbound_network_access_restricted", outbound_network_access_restricted)
        if public_ip_type is not None:
            pulumi.set(__self__, "public_ip_type", public_ip_type)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if purge_enabled is not None:
            pulumi.set(__self__, "purge_enabled", purge_enabled)
        if streaming_ingestion_enabled is not None:
            pulumi.set(__self__, "streaming_ingestion_enabled", streaming_ingestion_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if trusted_external_tenants is not None:
            pulumi.set(__self__, "trusted_external_tenants", trusted_external_tenants)
        if virtual_network_configuration is not None:
            warnings.warn("""The `virtual_network_configuration` block has been deprecated as it is no longer supported by Azure and will be removed in v5.0 of the AzureRM Provider - for more information see https://techcommunity.microsoft.com/blog/azuredataexplorer/deprecation-of-virtual-network-injection-for-azure-data-explorer/4198192""", DeprecationWarning)
            pulumi.log.warn("""virtual_network_configuration is deprecated: The `virtual_network_configuration` block has been deprecated as it is no longer supported by Azure and will be removed in v5.0 of the AzureRM Provider - for more information see https://techcommunity.microsoft.com/blog/azuredataexplorer/deprecation-of-virtual-network-injection-for-azure-data-explorer/4198192""")
        if virtual_network_configuration is not None:
            pulumi.set(__self__, "virtual_network_configuration", virtual_network_configuration)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Resource Group where the Kusto Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Input['ClusterSkuArgs']:
        """
        A `sku` block as defined below.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input['ClusterSkuArgs']):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="allowedFqdns")
    def allowed_fqdns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of allowed FQDNs(Fully Qualified Domain Name) for egress from Cluster.
        """
        return pulumi.get(self, "allowed_fqdns")

    @allowed_fqdns.setter
    def allowed_fqdns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_fqdns", value)

    @_builtins.property
    @pulumi.getter(name="allowedIpRanges")
    def allowed_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of ips in the format of CIDR allowed to connect to the cluster.
        """
        return pulumi.get(self, "allowed_ip_ranges")

    @allowed_ip_ranges.setter
    def allowed_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_ip_ranges", value)

    @_builtins.property
    @pulumi.getter(name="autoStopEnabled")
    def auto_stop_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the cluster could be automatically stopped (due to lack of data or no activity for many days). Defaults to `true`.
        """
        return pulumi.get(self, "auto_stop_enabled")

    @auto_stop_enabled.setter
    def auto_stop_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_stop_enabled", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionEnabled")
    def disk_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the cluster's disks are encrypted.
        """
        return pulumi.get(self, "disk_encryption_enabled")

    @disk_encryption_enabled.setter
    def disk_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disk_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter(name="doubleEncryptionEnabled")
    def double_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the cluster's double encryption enabled? Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "double_encryption_enabled")

    @double_encryption_enabled.setter
    def double_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "double_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ClusterIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ClusterIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="languageExtensions")
    def language_extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLanguageExtensionArgs']]]]:
        """
        An list of `language_extensions` to enable. Valid values are: `PYTHON`, `PYTHON_3.10.8` and `R`. `PYTHON` is used to specify Python 3.6.5 image and `PYTHON_3.10.8` is used to specify Python 3.10.8 image. Note that `PYTHON_3.10.8` is only available in skus which support nested virtualization.

        > **Note:** In `v4.0.0` and later version of the AzureRM Provider, `language_extensions` will be changed to a list of `language_extension` block. In each block, `name` and `image` are required. `name` is the name of the language extension, possible values are `PYTHON`, `R`. `image` is the image of the language extension, possible values are `Python3_6_5`, `Python3_10_8` and `R`.
        """
        return pulumi.get(self, "language_extensions")

    @language_extensions.setter
    def language_extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLanguageExtensionArgs']]]]):
        pulumi.set(self, "language_extensions", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location where the Kusto Cluster should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Kusto Cluster to create. Only lowercase Alphanumeric characters allowed, starting with a letter. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="optimizedAutoScale")
    def optimized_auto_scale(self) -> Optional[pulumi.Input['ClusterOptimizedAutoScaleArgs']]:
        """
        An `optimized_auto_scale` block as defined below.
        """
        return pulumi.get(self, "optimized_auto_scale")

    @optimized_auto_scale.setter
    def optimized_auto_scale(self, value: Optional[pulumi.Input['ClusterOptimizedAutoScaleArgs']]):
        pulumi.set(self, "optimized_auto_scale", value)

    @_builtins.property
    @pulumi.getter(name="outboundNetworkAccessRestricted")
    def outbound_network_access_restricted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to restrict outbound network access. Value is optional but if passed in, must be `true` or `false`, default is `false`.
        """
        return pulumi.get(self, "outbound_network_access_restricted")

    @outbound_network_access_restricted.setter
    def outbound_network_access_restricted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "outbound_network_access_restricted", value)

    @_builtins.property
    @pulumi.getter(name="publicIpType")
    def public_ip_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates what public IP type to create - IPv4 (default), or DualStack (both IPv4 and IPv6). Defaults to `IPv4`.
        """
        return pulumi.get(self, "public_ip_type")

    @public_ip_type.setter
    def public_ip_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip_type", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the public network access enabled? Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="purgeEnabled")
    def purge_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the purge operations are enabled.
        """
        return pulumi.get(self, "purge_enabled")

    @purge_enabled.setter
    def purge_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "purge_enabled", value)

    @_builtins.property
    @pulumi.getter(name="streamingIngestionEnabled")
    def streaming_ingestion_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the streaming ingest is enabled.
        """
        return pulumi.get(self, "streaming_ingestion_enabled")

    @streaming_ingestion_enabled.setter
    def streaming_ingestion_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "streaming_ingestion_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="trustedExternalTenants")
    def trusted_external_tenants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of tenant IDs that are trusted by the cluster. Default setting trusts all other tenants. Use `trusted_external_tenants = ["*"]` to explicitly allow all other tenants, `trusted_external_tenants = ["MyTenantOnly"]` for only your tenant or `trusted_external_tenants = ["<tenantId1>", "<tenantIdx>"]` to allow specific other tenants.

        > **Note:** In v3.0 of `azurerm` a new or updated Kusto Cluster will only allow your own tenant by default. Explicit configuration of this setting will change from `trusted_external_tenants = ["MyTenantOnly"]` to `trusted_external_tenants = []`.
        """
        return pulumi.get(self, "trusted_external_tenants")

    @trusted_external_tenants.setter
    def trusted_external_tenants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "trusted_external_tenants", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkConfiguration")
    @_utilities.deprecated("""The `virtual_network_configuration` block has been deprecated as it is no longer supported by Azure and will be removed in v5.0 of the AzureRM Provider - for more information see https://techcommunity.microsoft.com/blog/azuredataexplorer/deprecation-of-virtual-network-injection-for-azure-data-explorer/4198192""")
    def virtual_network_configuration(self) -> Optional[pulumi.Input['ClusterVirtualNetworkConfigurationArgs']]:
        return pulumi.get(self, "virtual_network_configuration")

    @virtual_network_configuration.setter
    def virtual_network_configuration(self, value: Optional[pulumi.Input['ClusterVirtualNetworkConfigurationArgs']]):
        pulumi.set(self, "virtual_network_configuration", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Availability Zones in which this Kusto Cluster should be located. Changing this forces a new Kusto Cluster to be created.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 allowed_fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_stop_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 data_ingestion_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 double_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['ClusterIdentityArgs']] = None,
                 language_extensions: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLanguageExtensionArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 optimized_auto_scale: Optional[pulumi.Input['ClusterOptimizedAutoScaleArgs']] = None,
                 outbound_network_access_restricted: Optional[pulumi.Input[_builtins.bool]] = None,
                 public_ip_type: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 purge_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input['ClusterSkuArgs']] = None,
                 streaming_ingestion_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 trusted_external_tenants: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 uri: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_configuration: Optional[pulumi.Input['ClusterVirtualNetworkConfigurationArgs']] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_fqdns: List of allowed FQDNs(Fully Qualified Domain Name) for egress from Cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_ip_ranges: The list of ips in the format of CIDR allowed to connect to the cluster.
        :param pulumi.Input[_builtins.bool] auto_stop_enabled: Specifies if the cluster could be automatically stopped (due to lack of data or no activity for many days). Defaults to `true`.
        :param pulumi.Input[_builtins.str] data_ingestion_uri: The Kusto Cluster URI to be used for data ingestion.
        :param pulumi.Input[_builtins.bool] disk_encryption_enabled: Specifies if the cluster's disks are encrypted.
        :param pulumi.Input[_builtins.bool] double_encryption_enabled: Is the cluster's double encryption enabled? Changing this forces a new resource to be created.
        :param pulumi.Input['ClusterIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterLanguageExtensionArgs']]] language_extensions: An list of `language_extensions` to enable. Valid values are: `PYTHON`, `PYTHON_3.10.8` and `R`. `PYTHON` is used to specify Python 3.6.5 image and `PYTHON_3.10.8` is used to specify Python 3.10.8 image. Note that `PYTHON_3.10.8` is only available in skus which support nested virtualization.
               
               > **Note:** In `v4.0.0` and later version of the AzureRM Provider, `language_extensions` will be changed to a list of `language_extension` block. In each block, `name` and `image` are required. `name` is the name of the language extension, possible values are `PYTHON`, `R`. `image` is the image of the language extension, possible values are `Python3_6_5`, `Python3_10_8` and `R`.
        :param pulumi.Input[_builtins.str] location: The location where the Kusto Cluster should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Kusto Cluster to create. Only lowercase Alphanumeric characters allowed, starting with a letter. Changing this forces a new resource to be created.
        :param pulumi.Input['ClusterOptimizedAutoScaleArgs'] optimized_auto_scale: An `optimized_auto_scale` block as defined below.
        :param pulumi.Input[_builtins.bool] outbound_network_access_restricted: Whether to restrict outbound network access. Value is optional but if passed in, must be `true` or `false`, default is `false`.
        :param pulumi.Input[_builtins.str] public_ip_type: Indicates what public IP type to create - IPv4 (default), or DualStack (both IPv4 and IPv6). Defaults to `IPv4`.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Is the public network access enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] purge_enabled: Specifies if the purge operations are enabled.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the Resource Group where the Kusto Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['ClusterSkuArgs'] sku: A `sku` block as defined below.
        :param pulumi.Input[_builtins.bool] streaming_ingestion_enabled: Specifies if the streaming ingest is enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] trusted_external_tenants: Specifies a list of tenant IDs that are trusted by the cluster. Default setting trusts all other tenants. Use `trusted_external_tenants = ["*"]` to explicitly allow all other tenants, `trusted_external_tenants = ["MyTenantOnly"]` for only your tenant or `trusted_external_tenants = ["<tenantId1>", "<tenantIdx>"]` to allow specific other tenants.
               
               > **Note:** In v3.0 of `azurerm` a new or updated Kusto Cluster will only allow your own tenant by default. Explicit configuration of this setting will change from `trusted_external_tenants = ["MyTenantOnly"]` to `trusted_external_tenants = []`.
        :param pulumi.Input[_builtins.str] uri: The FQDN of the Azure Kusto Cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Kusto Cluster should be located. Changing this forces a new Kusto Cluster to be created.
        """
        if allowed_fqdns is not None:
            pulumi.set(__self__, "allowed_fqdns", allowed_fqdns)
        if allowed_ip_ranges is not None:
            pulumi.set(__self__, "allowed_ip_ranges", allowed_ip_ranges)
        if auto_stop_enabled is not None:
            pulumi.set(__self__, "auto_stop_enabled", auto_stop_enabled)
        if data_ingestion_uri is not None:
            pulumi.set(__self__, "data_ingestion_uri", data_ingestion_uri)
        if disk_encryption_enabled is not None:
            pulumi.set(__self__, "disk_encryption_enabled", disk_encryption_enabled)
        if double_encryption_enabled is not None:
            pulumi.set(__self__, "double_encryption_enabled", double_encryption_enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if language_extensions is not None:
            pulumi.set(__self__, "language_extensions", language_extensions)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optimized_auto_scale is not None:
            pulumi.set(__self__, "optimized_auto_scale", optimized_auto_scale)
        if outbound_network_access_restricted is not None:
            pulumi.set(__self__, "outbound_network_access_restricted", outbound_network_access_restricted)
        if public_ip_type is not None:
            pulumi.set(__self__, "public_ip_type", public_ip_type)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if purge_enabled is not None:
            pulumi.set(__self__, "purge_enabled", purge_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if streaming_ingestion_enabled is not None:
            pulumi.set(__self__, "streaming_ingestion_enabled", streaming_ingestion_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if trusted_external_tenants is not None:
            pulumi.set(__self__, "trusted_external_tenants", trusted_external_tenants)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)
        if virtual_network_configuration is not None:
            warnings.warn("""The `virtual_network_configuration` block has been deprecated as it is no longer supported by Azure and will be removed in v5.0 of the AzureRM Provider - for more information see https://techcommunity.microsoft.com/blog/azuredataexplorer/deprecation-of-virtual-network-injection-for-azure-data-explorer/4198192""", DeprecationWarning)
            pulumi.log.warn("""virtual_network_configuration is deprecated: The `virtual_network_configuration` block has been deprecated as it is no longer supported by Azure and will be removed in v5.0 of the AzureRM Provider - for more information see https://techcommunity.microsoft.com/blog/azuredataexplorer/deprecation-of-virtual-network-injection-for-azure-data-explorer/4198192""")
        if virtual_network_configuration is not None:
            pulumi.set(__self__, "virtual_network_configuration", virtual_network_configuration)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="allowedFqdns")
    def allowed_fqdns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of allowed FQDNs(Fully Qualified Domain Name) for egress from Cluster.
        """
        return pulumi.get(self, "allowed_fqdns")

    @allowed_fqdns.setter
    def allowed_fqdns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_fqdns", value)

    @_builtins.property
    @pulumi.getter(name="allowedIpRanges")
    def allowed_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of ips in the format of CIDR allowed to connect to the cluster.
        """
        return pulumi.get(self, "allowed_ip_ranges")

    @allowed_ip_ranges.setter
    def allowed_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "allowed_ip_ranges", value)

    @_builtins.property
    @pulumi.getter(name="autoStopEnabled")
    def auto_stop_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the cluster could be automatically stopped (due to lack of data or no activity for many days). Defaults to `true`.
        """
        return pulumi.get(self, "auto_stop_enabled")

    @auto_stop_enabled.setter
    def auto_stop_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_stop_enabled", value)

    @_builtins.property
    @pulumi.getter(name="dataIngestionUri")
    def data_ingestion_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Kusto Cluster URI to be used for data ingestion.
        """
        return pulumi.get(self, "data_ingestion_uri")

    @data_ingestion_uri.setter
    def data_ingestion_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_ingestion_uri", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionEnabled")
    def disk_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the cluster's disks are encrypted.
        """
        return pulumi.get(self, "disk_encryption_enabled")

    @disk_encryption_enabled.setter
    def disk_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disk_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter(name="doubleEncryptionEnabled")
    def double_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the cluster's double encryption enabled? Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "double_encryption_enabled")

    @double_encryption_enabled.setter
    def double_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "double_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ClusterIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ClusterIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="languageExtensions")
    def language_extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLanguageExtensionArgs']]]]:
        """
        An list of `language_extensions` to enable. Valid values are: `PYTHON`, `PYTHON_3.10.8` and `R`. `PYTHON` is used to specify Python 3.6.5 image and `PYTHON_3.10.8` is used to specify Python 3.10.8 image. Note that `PYTHON_3.10.8` is only available in skus which support nested virtualization.

        > **Note:** In `v4.0.0` and later version of the AzureRM Provider, `language_extensions` will be changed to a list of `language_extension` block. In each block, `name` and `image` are required. `name` is the name of the language extension, possible values are `PYTHON`, `R`. `image` is the image of the language extension, possible values are `Python3_6_5`, `Python3_10_8` and `R`.
        """
        return pulumi.get(self, "language_extensions")

    @language_extensions.setter
    def language_extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterLanguageExtensionArgs']]]]):
        pulumi.set(self, "language_extensions", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location where the Kusto Cluster should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Kusto Cluster to create. Only lowercase Alphanumeric characters allowed, starting with a letter. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="optimizedAutoScale")
    def optimized_auto_scale(self) -> Optional[pulumi.Input['ClusterOptimizedAutoScaleArgs']]:
        """
        An `optimized_auto_scale` block as defined below.
        """
        return pulumi.get(self, "optimized_auto_scale")

    @optimized_auto_scale.setter
    def optimized_auto_scale(self, value: Optional[pulumi.Input['ClusterOptimizedAutoScaleArgs']]):
        pulumi.set(self, "optimized_auto_scale", value)

    @_builtins.property
    @pulumi.getter(name="outboundNetworkAccessRestricted")
    def outbound_network_access_restricted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to restrict outbound network access. Value is optional but if passed in, must be `true` or `false`, default is `false`.
        """
        return pulumi.get(self, "outbound_network_access_restricted")

    @outbound_network_access_restricted.setter
    def outbound_network_access_restricted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "outbound_network_access_restricted", value)

    @_builtins.property
    @pulumi.getter(name="publicIpType")
    def public_ip_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates what public IP type to create - IPv4 (default), or DualStack (both IPv4 and IPv6). Defaults to `IPv4`.
        """
        return pulumi.get(self, "public_ip_type")

    @public_ip_type.setter
    def public_ip_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip_type", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the public network access enabled? Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="purgeEnabled")
    def purge_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the purge operations are enabled.
        """
        return pulumi.get(self, "purge_enabled")

    @purge_enabled.setter
    def purge_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "purge_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Resource Group where the Kusto Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['ClusterSkuArgs']]:
        """
        A `sku` block as defined below.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['ClusterSkuArgs']]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="streamingIngestionEnabled")
    def streaming_ingestion_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the streaming ingest is enabled.
        """
        return pulumi.get(self, "streaming_ingestion_enabled")

    @streaming_ingestion_enabled.setter
    def streaming_ingestion_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "streaming_ingestion_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="trustedExternalTenants")
    def trusted_external_tenants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of tenant IDs that are trusted by the cluster. Default setting trusts all other tenants. Use `trusted_external_tenants = ["*"]` to explicitly allow all other tenants, `trusted_external_tenants = ["MyTenantOnly"]` for only your tenant or `trusted_external_tenants = ["<tenantId1>", "<tenantIdx>"]` to allow specific other tenants.

        > **Note:** In v3.0 of `azurerm` a new or updated Kusto Cluster will only allow your own tenant by default. Explicit configuration of this setting will change from `trusted_external_tenants = ["MyTenantOnly"]` to `trusted_external_tenants = []`.
        """
        return pulumi.get(self, "trusted_external_tenants")

    @trusted_external_tenants.setter
    def trusted_external_tenants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "trusted_external_tenants", value)

    @_builtins.property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The FQDN of the Azure Kusto Cluster.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uri", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkConfiguration")
    @_utilities.deprecated("""The `virtual_network_configuration` block has been deprecated as it is no longer supported by Azure and will be removed in v5.0 of the AzureRM Provider - for more information see https://techcommunity.microsoft.com/blog/azuredataexplorer/deprecation-of-virtual-network-injection-for-azure-data-explorer/4198192""")
    def virtual_network_configuration(self) -> Optional[pulumi.Input['ClusterVirtualNetworkConfigurationArgs']]:
        return pulumi.get(self, "virtual_network_configuration")

    @virtual_network_configuration.setter
    def virtual_network_configuration(self, value: Optional[pulumi.Input['ClusterVirtualNetworkConfigurationArgs']]):
        pulumi.set(self, "virtual_network_configuration", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Availability Zones in which this Kusto Cluster should be located. Changing this forces a new Kusto Cluster to be created.
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.type_token("azure:kusto/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_stop_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 disk_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 double_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['ClusterIdentityArgs', 'ClusterIdentityArgsDict']]] = None,
                 language_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterLanguageExtensionArgs', 'ClusterLanguageExtensionArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 optimized_auto_scale: Optional[pulumi.Input[Union['ClusterOptimizedAutoScaleArgs', 'ClusterOptimizedAutoScaleArgsDict']]] = None,
                 outbound_network_access_restricted: Optional[pulumi.Input[_builtins.bool]] = None,
                 public_ip_type: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 purge_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[Union['ClusterSkuArgs', 'ClusterSkuArgsDict']]] = None,
                 streaming_ingestion_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 trusted_external_tenants: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_configuration: Optional[pulumi.Input[Union['ClusterVirtualNetworkConfigurationArgs', 'ClusterVirtualNetworkConfigurationArgsDict']]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Kusto (also known as Azure Data Explorer) Cluster

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="my-kusto-cluster-rg",
            location="West Europe")
        example_cluster = azure.kusto.Cluster("example",
            name="kustocluster",
            location=example.location,
            resource_group_name=example.name,
            sku={
                "name": "Standard_D13_v2",
                "capacity": 2,
            },
            tags={
                "Environment": "Production",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Kusto` - 2024-04-13

        ## Import

        Kusto Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:kusto/cluster:Cluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Kusto/clusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_fqdns: List of allowed FQDNs(Fully Qualified Domain Name) for egress from Cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_ip_ranges: The list of ips in the format of CIDR allowed to connect to the cluster.
        :param pulumi.Input[_builtins.bool] auto_stop_enabled: Specifies if the cluster could be automatically stopped (due to lack of data or no activity for many days). Defaults to `true`.
        :param pulumi.Input[_builtins.bool] disk_encryption_enabled: Specifies if the cluster's disks are encrypted.
        :param pulumi.Input[_builtins.bool] double_encryption_enabled: Is the cluster's double encryption enabled? Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ClusterIdentityArgs', 'ClusterIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterLanguageExtensionArgs', 'ClusterLanguageExtensionArgsDict']]]] language_extensions: An list of `language_extensions` to enable. Valid values are: `PYTHON`, `PYTHON_3.10.8` and `R`. `PYTHON` is used to specify Python 3.6.5 image and `PYTHON_3.10.8` is used to specify Python 3.10.8 image. Note that `PYTHON_3.10.8` is only available in skus which support nested virtualization.
               
               > **Note:** In `v4.0.0` and later version of the AzureRM Provider, `language_extensions` will be changed to a list of `language_extension` block. In each block, `name` and `image` are required. `name` is the name of the language extension, possible values are `PYTHON`, `R`. `image` is the image of the language extension, possible values are `Python3_6_5`, `Python3_10_8` and `R`.
        :param pulumi.Input[_builtins.str] location: The location where the Kusto Cluster should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Kusto Cluster to create. Only lowercase Alphanumeric characters allowed, starting with a letter. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ClusterOptimizedAutoScaleArgs', 'ClusterOptimizedAutoScaleArgsDict']] optimized_auto_scale: An `optimized_auto_scale` block as defined below.
        :param pulumi.Input[_builtins.bool] outbound_network_access_restricted: Whether to restrict outbound network access. Value is optional but if passed in, must be `true` or `false`, default is `false`.
        :param pulumi.Input[_builtins.str] public_ip_type: Indicates what public IP type to create - IPv4 (default), or DualStack (both IPv4 and IPv6). Defaults to `IPv4`.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Is the public network access enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] purge_enabled: Specifies if the purge operations are enabled.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the Resource Group where the Kusto Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ClusterSkuArgs', 'ClusterSkuArgsDict']] sku: A `sku` block as defined below.
        :param pulumi.Input[_builtins.bool] streaming_ingestion_enabled: Specifies if the streaming ingest is enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] trusted_external_tenants: Specifies a list of tenant IDs that are trusted by the cluster. Default setting trusts all other tenants. Use `trusted_external_tenants = ["*"]` to explicitly allow all other tenants, `trusted_external_tenants = ["MyTenantOnly"]` for only your tenant or `trusted_external_tenants = ["<tenantId1>", "<tenantIdx>"]` to allow specific other tenants.
               
               > **Note:** In v3.0 of `azurerm` a new or updated Kusto Cluster will only allow your own tenant by default. Explicit configuration of this setting will change from `trusted_external_tenants = ["MyTenantOnly"]` to `trusted_external_tenants = []`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Kusto Cluster should be located. Changing this forces a new Kusto Cluster to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Kusto (also known as Azure Data Explorer) Cluster

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="my-kusto-cluster-rg",
            location="West Europe")
        example_cluster = azure.kusto.Cluster("example",
            name="kustocluster",
            location=example.location,
            resource_group_name=example.name,
            sku={
                "name": "Standard_D13_v2",
                "capacity": 2,
            },
            tags={
                "Environment": "Production",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Kusto` - 2024-04-13

        ## Import

        Kusto Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:kusto/cluster:Cluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Kusto/clusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allowed_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 auto_stop_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 disk_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 double_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['ClusterIdentityArgs', 'ClusterIdentityArgsDict']]] = None,
                 language_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterLanguageExtensionArgs', 'ClusterLanguageExtensionArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 optimized_auto_scale: Optional[pulumi.Input[Union['ClusterOptimizedAutoScaleArgs', 'ClusterOptimizedAutoScaleArgsDict']]] = None,
                 outbound_network_access_restricted: Optional[pulumi.Input[_builtins.bool]] = None,
                 public_ip_type: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 purge_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[Union['ClusterSkuArgs', 'ClusterSkuArgsDict']]] = None,
                 streaming_ingestion_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 trusted_external_tenants: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_configuration: Optional[pulumi.Input[Union['ClusterVirtualNetworkConfigurationArgs', 'ClusterVirtualNetworkConfigurationArgsDict']]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["allowed_fqdns"] = allowed_fqdns
            __props__.__dict__["allowed_ip_ranges"] = allowed_ip_ranges
            __props__.__dict__["auto_stop_enabled"] = auto_stop_enabled
            __props__.__dict__["disk_encryption_enabled"] = disk_encryption_enabled
            __props__.__dict__["double_encryption_enabled"] = double_encryption_enabled
            __props__.__dict__["identity"] = identity
            __props__.__dict__["language_extensions"] = language_extensions
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["optimized_auto_scale"] = optimized_auto_scale
            __props__.__dict__["outbound_network_access_restricted"] = outbound_network_access_restricted
            __props__.__dict__["public_ip_type"] = public_ip_type
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            __props__.__dict__["purge_enabled"] = purge_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["streaming_ingestion_enabled"] = streaming_ingestion_enabled
            __props__.__dict__["tags"] = tags
            __props__.__dict__["trusted_external_tenants"] = trusted_external_tenants
            __props__.__dict__["virtual_network_configuration"] = virtual_network_configuration
            __props__.__dict__["zones"] = zones
            __props__.__dict__["data_ingestion_uri"] = None
            __props__.__dict__["uri"] = None
        super(Cluster, __self__).__init__(
            'azure:kusto/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            allowed_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            auto_stop_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            data_ingestion_uri: Optional[pulumi.Input[_builtins.str]] = None,
            disk_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            double_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            identity: Optional[pulumi.Input[Union['ClusterIdentityArgs', 'ClusterIdentityArgsDict']]] = None,
            language_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterLanguageExtensionArgs', 'ClusterLanguageExtensionArgsDict']]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            optimized_auto_scale: Optional[pulumi.Input[Union['ClusterOptimizedAutoScaleArgs', 'ClusterOptimizedAutoScaleArgsDict']]] = None,
            outbound_network_access_restricted: Optional[pulumi.Input[_builtins.bool]] = None,
            public_ip_type: Optional[pulumi.Input[_builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            purge_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku: Optional[pulumi.Input[Union['ClusterSkuArgs', 'ClusterSkuArgsDict']]] = None,
            streaming_ingestion_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            trusted_external_tenants: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            uri: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_network_configuration: Optional[pulumi.Input[Union['ClusterVirtualNetworkConfigurationArgs', 'ClusterVirtualNetworkConfigurationArgsDict']]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_fqdns: List of allowed FQDNs(Fully Qualified Domain Name) for egress from Cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_ip_ranges: The list of ips in the format of CIDR allowed to connect to the cluster.
        :param pulumi.Input[_builtins.bool] auto_stop_enabled: Specifies if the cluster could be automatically stopped (due to lack of data or no activity for many days). Defaults to `true`.
        :param pulumi.Input[_builtins.str] data_ingestion_uri: The Kusto Cluster URI to be used for data ingestion.
        :param pulumi.Input[_builtins.bool] disk_encryption_enabled: Specifies if the cluster's disks are encrypted.
        :param pulumi.Input[_builtins.bool] double_encryption_enabled: Is the cluster's double encryption enabled? Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ClusterIdentityArgs', 'ClusterIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterLanguageExtensionArgs', 'ClusterLanguageExtensionArgsDict']]]] language_extensions: An list of `language_extensions` to enable. Valid values are: `PYTHON`, `PYTHON_3.10.8` and `R`. `PYTHON` is used to specify Python 3.6.5 image and `PYTHON_3.10.8` is used to specify Python 3.10.8 image. Note that `PYTHON_3.10.8` is only available in skus which support nested virtualization.
               
               > **Note:** In `v4.0.0` and later version of the AzureRM Provider, `language_extensions` will be changed to a list of `language_extension` block. In each block, `name` and `image` are required. `name` is the name of the language extension, possible values are `PYTHON`, `R`. `image` is the image of the language extension, possible values are `Python3_6_5`, `Python3_10_8` and `R`.
        :param pulumi.Input[_builtins.str] location: The location where the Kusto Cluster should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Kusto Cluster to create. Only lowercase Alphanumeric characters allowed, starting with a letter. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ClusterOptimizedAutoScaleArgs', 'ClusterOptimizedAutoScaleArgsDict']] optimized_auto_scale: An `optimized_auto_scale` block as defined below.
        :param pulumi.Input[_builtins.bool] outbound_network_access_restricted: Whether to restrict outbound network access. Value is optional but if passed in, must be `true` or `false`, default is `false`.
        :param pulumi.Input[_builtins.str] public_ip_type: Indicates what public IP type to create - IPv4 (default), or DualStack (both IPv4 and IPv6). Defaults to `IPv4`.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Is the public network access enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] purge_enabled: Specifies if the purge operations are enabled.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the Resource Group where the Kusto Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ClusterSkuArgs', 'ClusterSkuArgsDict']] sku: A `sku` block as defined below.
        :param pulumi.Input[_builtins.bool] streaming_ingestion_enabled: Specifies if the streaming ingest is enabled.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] trusted_external_tenants: Specifies a list of tenant IDs that are trusted by the cluster. Default setting trusts all other tenants. Use `trusted_external_tenants = ["*"]` to explicitly allow all other tenants, `trusted_external_tenants = ["MyTenantOnly"]` for only your tenant or `trusted_external_tenants = ["<tenantId1>", "<tenantIdx>"]` to allow specific other tenants.
               
               > **Note:** In v3.0 of `azurerm` a new or updated Kusto Cluster will only allow your own tenant by default. Explicit configuration of this setting will change from `trusted_external_tenants = ["MyTenantOnly"]` to `trusted_external_tenants = []`.
        :param pulumi.Input[_builtins.str] uri: The FQDN of the Azure Kusto Cluster.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Kusto Cluster should be located. Changing this forces a new Kusto Cluster to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["allowed_fqdns"] = allowed_fqdns
        __props__.__dict__["allowed_ip_ranges"] = allowed_ip_ranges
        __props__.__dict__["auto_stop_enabled"] = auto_stop_enabled
        __props__.__dict__["data_ingestion_uri"] = data_ingestion_uri
        __props__.__dict__["disk_encryption_enabled"] = disk_encryption_enabled
        __props__.__dict__["double_encryption_enabled"] = double_encryption_enabled
        __props__.__dict__["identity"] = identity
        __props__.__dict__["language_extensions"] = language_extensions
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["optimized_auto_scale"] = optimized_auto_scale
        __props__.__dict__["outbound_network_access_restricted"] = outbound_network_access_restricted
        __props__.__dict__["public_ip_type"] = public_ip_type
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["purge_enabled"] = purge_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku"] = sku
        __props__.__dict__["streaming_ingestion_enabled"] = streaming_ingestion_enabled
        __props__.__dict__["tags"] = tags
        __props__.__dict__["trusted_external_tenants"] = trusted_external_tenants
        __props__.__dict__["uri"] = uri
        __props__.__dict__["virtual_network_configuration"] = virtual_network_configuration
        __props__.__dict__["zones"] = zones
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowedFqdns")
    def allowed_fqdns(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of allowed FQDNs(Fully Qualified Domain Name) for egress from Cluster.
        """
        return pulumi.get(self, "allowed_fqdns")

    @_builtins.property
    @pulumi.getter(name="allowedIpRanges")
    def allowed_ip_ranges(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of ips in the format of CIDR allowed to connect to the cluster.
        """
        return pulumi.get(self, "allowed_ip_ranges")

    @_builtins.property
    @pulumi.getter(name="autoStopEnabled")
    def auto_stop_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if the cluster could be automatically stopped (due to lack of data or no activity for many days). Defaults to `true`.
        """
        return pulumi.get(self, "auto_stop_enabled")

    @_builtins.property
    @pulumi.getter(name="dataIngestionUri")
    def data_ingestion_uri(self) -> pulumi.Output[_builtins.str]:
        """
        The Kusto Cluster URI to be used for data ingestion.
        """
        return pulumi.get(self, "data_ingestion_uri")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionEnabled")
    def disk_encryption_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if the cluster's disks are encrypted.
        """
        return pulumi.get(self, "disk_encryption_enabled")

    @_builtins.property
    @pulumi.getter(name="doubleEncryptionEnabled")
    def double_encryption_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is the cluster's double encryption enabled? Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "double_encryption_enabled")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.ClusterIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="languageExtensions")
    def language_extensions(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterLanguageExtension']]]:
        """
        An list of `language_extensions` to enable. Valid values are: `PYTHON`, `PYTHON_3.10.8` and `R`. `PYTHON` is used to specify Python 3.6.5 image and `PYTHON_3.10.8` is used to specify Python 3.10.8 image. Note that `PYTHON_3.10.8` is only available in skus which support nested virtualization.

        > **Note:** In `v4.0.0` and later version of the AzureRM Provider, `language_extensions` will be changed to a list of `language_extension` block. In each block, `name` and `image` are required. `name` is the name of the language extension, possible values are `PYTHON`, `R`. `image` is the image of the language extension, possible values are `Python3_6_5`, `Python3_10_8` and `R`.
        """
        return pulumi.get(self, "language_extensions")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location where the Kusto Cluster should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Kusto Cluster to create. Only lowercase Alphanumeric characters allowed, starting with a letter. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="optimizedAutoScale")
    def optimized_auto_scale(self) -> pulumi.Output[Optional['outputs.ClusterOptimizedAutoScale']]:
        """
        An `optimized_auto_scale` block as defined below.
        """
        return pulumi.get(self, "optimized_auto_scale")

    @_builtins.property
    @pulumi.getter(name="outboundNetworkAccessRestricted")
    def outbound_network_access_restricted(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to restrict outbound network access. Value is optional but if passed in, must be `true` or `false`, default is `false`.
        """
        return pulumi.get(self, "outbound_network_access_restricted")

    @_builtins.property
    @pulumi.getter(name="publicIpType")
    def public_ip_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indicates what public IP type to create - IPv4 (default), or DualStack (both IPv4 and IPv6). Defaults to `IPv4`.
        """
        return pulumi.get(self, "public_ip_type")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is the public network access enabled? Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="purgeEnabled")
    def purge_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if the purge operations are enabled.
        """
        return pulumi.get(self, "purge_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Resource Group where the Kusto Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output['outputs.ClusterSku']:
        """
        A `sku` block as defined below.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter(name="streamingIngestionEnabled")
    def streaming_ingestion_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if the streaming ingest is enabled.
        """
        return pulumi.get(self, "streaming_ingestion_enabled")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="trustedExternalTenants")
    def trusted_external_tenants(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies a list of tenant IDs that are trusted by the cluster. Default setting trusts all other tenants. Use `trusted_external_tenants = ["*"]` to explicitly allow all other tenants, `trusted_external_tenants = ["MyTenantOnly"]` for only your tenant or `trusted_external_tenants = ["<tenantId1>", "<tenantIdx>"]` to allow specific other tenants.

        > **Note:** In v3.0 of `azurerm` a new or updated Kusto Cluster will only allow your own tenant by default. Explicit configuration of this setting will change from `trusted_external_tenants = ["MyTenantOnly"]` to `trusted_external_tenants = []`.
        """
        return pulumi.get(self, "trusted_external_tenants")

    @_builtins.property
    @pulumi.getter
    def uri(self) -> pulumi.Output[_builtins.str]:
        """
        The FQDN of the Azure Kusto Cluster.
        """
        return pulumi.get(self, "uri")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkConfiguration")
    @_utilities.deprecated("""The `virtual_network_configuration` block has been deprecated as it is no longer supported by Azure and will be removed in v5.0 of the AzureRM Provider - for more information see https://techcommunity.microsoft.com/blog/azuredataexplorer/deprecation-of-virtual-network-injection-for-azure-data-explorer/4198192""")
    def virtual_network_configuration(self) -> pulumi.Output[Optional['outputs.ClusterVirtualNetworkConfiguration']]:
        return pulumi.get(self, "virtual_network_configuration")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of Availability Zones in which this Kusto Cluster should be located. Changing this forces a new Kusto Cluster to be created.
        """
        return pulumi.get(self, "zones")

