# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ClusterPrincipalAssignmentArgs', 'ClusterPrincipalAssignment']

@pulumi.input_type
class ClusterPrincipalAssignmentArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[_builtins.str],
                 principal_id: pulumi.Input[_builtins.str],
                 principal_type: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 role: pulumi.Input[_builtins.str],
                 tenant_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ClusterPrincipalAssignment resource.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the cluster in which to create the resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] principal_id: The object id of the principal. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] principal_type: The type of the principal. Valid values include `App`, `Group`, `User`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] role: The cluster role assigned to the principal. Valid values include `AllDatabasesAdmin`, `AllDatabasesViewer`, and `AllDatabasesMonitor`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tenant_id: The tenant id in which the principal resides. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Kusto cluster principal assignment. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "principal_type", principal_type)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the cluster in which to create the resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[_builtins.str]:
        """
        The object id of the principal. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the principal. Valid values include `App`, `Group`, `User`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "principal_type")

    @principal_type.setter
    def principal_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "principal_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Input[_builtins.str]:
        """
        The cluster role assigned to the principal. Valid values include `AllDatabasesAdmin`, `AllDatabasesViewer`, and `AllDatabasesMonitor`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[_builtins.str]:
        """
        The tenant id in which the principal resides. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Kusto cluster principal assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ClusterPrincipalAssignmentState:
    def __init__(__self__, *,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_name: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ClusterPrincipalAssignment resources.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the cluster in which to create the resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Kusto cluster principal assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] principal_id: The object id of the principal. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] principal_name: The name of the principal.
        :param pulumi.Input[_builtins.str] principal_type: The type of the principal. Valid values include `App`, `Group`, `User`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] role: The cluster role assigned to the principal. Valid values include `AllDatabasesAdmin`, `AllDatabasesViewer`, and `AllDatabasesMonitor`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tenant_id: The tenant id in which the principal resides. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tenant_name: The name of the tenant.
        """
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if principal_name is not None:
            pulumi.set(__self__, "principal_name", principal_name)
        if principal_type is not None:
            pulumi.set(__self__, "principal_type", principal_type)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if tenant_name is not None:
            pulumi.set(__self__, "tenant_name", tenant_name)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the cluster in which to create the resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Kusto cluster principal assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The object id of the principal. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="principalName")
    def principal_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the principal.
        """
        return pulumi.get(self, "principal_name")

    @principal_name.setter
    def principal_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_name", value)

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the principal. Valid values include `App`, `Group`, `User`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "principal_type")

    @principal_type.setter
    def principal_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster role assigned to the principal. Valid values include `AllDatabasesAdmin`, `AllDatabasesViewer`, and `AllDatabasesMonitor`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tenant id in which the principal resides. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantName")
    def tenant_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the tenant.
        """
        return pulumi.get(self, "tenant_name")

    @tenant_name.setter
    def tenant_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_name", value)


@pulumi.type_token("azure:kusto/clusterPrincipalAssignment:ClusterPrincipalAssignment")
class ClusterPrincipalAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Kusto Cluster Principal Assignment.

        ## Import

        Data Explorer Cluster Principal Assignments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:kusto/clusterPrincipalAssignment:ClusterPrincipalAssignment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Kusto/clusters/cluster1/principalAssignments/assignment1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the cluster in which to create the resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Kusto cluster principal assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] principal_id: The object id of the principal. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] principal_type: The type of the principal. Valid values include `App`, `Group`, `User`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] role: The cluster role assigned to the principal. Valid values include `AllDatabasesAdmin`, `AllDatabasesViewer`, and `AllDatabasesMonitor`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tenant_id: The tenant id in which the principal resides. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterPrincipalAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Kusto Cluster Principal Assignment.

        ## Import

        Data Explorer Cluster Principal Assignments can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:kusto/clusterPrincipalAssignment:ClusterPrincipalAssignment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Kusto/clusters/cluster1/principalAssignments/assignment1
        ```

        :param str resource_name: The name of the resource.
        :param ClusterPrincipalAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterPrincipalAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 principal_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterPrincipalAssignmentArgs.__new__(ClusterPrincipalAssignmentArgs)

            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["name"] = name
            if principal_id is None and not opts.urn:
                raise TypeError("Missing required property 'principal_id'")
            __props__.__dict__["principal_id"] = principal_id
            if principal_type is None and not opts.urn:
                raise TypeError("Missing required property 'principal_type'")
            __props__.__dict__["principal_type"] = principal_type
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["principal_name"] = None
            __props__.__dict__["tenant_name"] = None
        super(ClusterPrincipalAssignment, __self__).__init__(
            'azure:kusto/clusterPrincipalAssignment:ClusterPrincipalAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            principal_id: Optional[pulumi.Input[_builtins.str]] = None,
            principal_name: Optional[pulumi.Input[_builtins.str]] = None,
            principal_type: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'ClusterPrincipalAssignment':
        """
        Get an existing ClusterPrincipalAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the cluster in which to create the resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Kusto cluster principal assignment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] principal_id: The object id of the principal. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] principal_name: The name of the principal.
        :param pulumi.Input[_builtins.str] principal_type: The type of the principal. Valid values include `App`, `Group`, `User`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] role: The cluster role assigned to the principal. Valid values include `AllDatabasesAdmin`, `AllDatabasesViewer`, and `AllDatabasesMonitor`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tenant_id: The tenant id in which the principal resides. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tenant_name: The name of the tenant.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterPrincipalAssignmentState.__new__(_ClusterPrincipalAssignmentState)

        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["name"] = name
        __props__.__dict__["principal_id"] = principal_id
        __props__.__dict__["principal_name"] = principal_name
        __props__.__dict__["principal_type"] = principal_type
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["role"] = role
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["tenant_name"] = tenant_name
        return ClusterPrincipalAssignment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the cluster in which to create the resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Kusto cluster principal assignment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Output[_builtins.str]:
        """
        The object id of the principal. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="principalName")
    def principal_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the principal.
        """
        return pulumi.get(self, "principal_name")

    @_builtins.property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the principal. Valid values include `App`, `Group`, `User`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "principal_type")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[_builtins.str]:
        """
        The cluster role assigned to the principal. Valid values include `AllDatabasesAdmin`, `AllDatabasesViewer`, and `AllDatabasesMonitor`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        The tenant id in which the principal resides. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="tenantName")
    def tenant_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the tenant.
        """
        return pulumi.get(self, "tenant_name")

