# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BackendAddressPoolAddressArgs', 'BackendAddressPoolAddress']

@pulumi.input_type
class BackendAddressPoolAddressArgs:
    def __init__(__self__, *,
                 backend_address_pool_id: pulumi.Input[_builtins.str],
                 backend_address_ip_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BackendAddressPoolAddress resource.
        :param pulumi.Input[_builtins.str] backend_address_pool_id: The ID of the Backend Address Pool. Changing this forces a new Backend Address Pool Address to be created.
        :param pulumi.Input[_builtins.str] backend_address_ip_configuration_id: The ip config ID of the regional load balancer that's added to the global load balancer's backend address pool.
               
               > **Note:** For cross-region load balancer, please append the name of the load balancers, virtual machines, and other resources in each region with a -R1 and -R2.
        :param pulumi.Input[_builtins.str] ip_address: The Static IP Address which should be allocated to this Backend Address Pool.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Backend Address Pool Address. Changing this forces a new Backend Address Pool Address to be created.
        :param pulumi.Input[_builtins.str] virtual_network_id: The ID of the Virtual Network within which the Backend Address Pool should exist.
        """
        pulumi.set(__self__, "backend_address_pool_id", backend_address_pool_id)
        if backend_address_ip_configuration_id is not None:
            pulumi.set(__self__, "backend_address_ip_configuration_id", backend_address_ip_configuration_id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if virtual_network_id is not None:
            pulumi.set(__self__, "virtual_network_id", virtual_network_id)

    @_builtins.property
    @pulumi.getter(name="backendAddressPoolId")
    def backend_address_pool_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Backend Address Pool. Changing this forces a new Backend Address Pool Address to be created.
        """
        return pulumi.get(self, "backend_address_pool_id")

    @backend_address_pool_id.setter
    def backend_address_pool_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend_address_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="backendAddressIpConfigurationId")
    def backend_address_ip_configuration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ip config ID of the regional load balancer that's added to the global load balancer's backend address pool.

        > **Note:** For cross-region load balancer, please append the name of the load balancers, virtual machines, and other resources in each region with a -R1 and -R2.
        """
        return pulumi.get(self, "backend_address_ip_configuration_id")

    @backend_address_ip_configuration_id.setter
    def backend_address_ip_configuration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend_address_ip_configuration_id", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Static IP Address which should be allocated to this Backend Address Pool.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Backend Address Pool Address. Changing this forces a new Backend Address Pool Address to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Virtual Network within which the Backend Address Pool should exist.
        """
        return pulumi.get(self, "virtual_network_id")

    @virtual_network_id.setter
    def virtual_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_id", value)


@pulumi.input_type
class _BackendAddressPoolAddressState:
    def __init__(__self__, *,
                 backend_address_ip_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 backend_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 inbound_nat_rule_port_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['BackendAddressPoolAddressInboundNatRulePortMappingArgs']]]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BackendAddressPoolAddress resources.
        :param pulumi.Input[_builtins.str] backend_address_ip_configuration_id: The ip config ID of the regional load balancer that's added to the global load balancer's backend address pool.
               
               > **Note:** For cross-region load balancer, please append the name of the load balancers, virtual machines, and other resources in each region with a -R1 and -R2.
        :param pulumi.Input[_builtins.str] backend_address_pool_id: The ID of the Backend Address Pool. Changing this forces a new Backend Address Pool Address to be created.
        :param pulumi.Input[Sequence[pulumi.Input['BackendAddressPoolAddressInboundNatRulePortMappingArgs']]] inbound_nat_rule_port_mappings: A list of `inbound_nat_rule_port_mapping` block as defined below.
        :param pulumi.Input[_builtins.str] ip_address: The Static IP Address which should be allocated to this Backend Address Pool.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Backend Address Pool Address. Changing this forces a new Backend Address Pool Address to be created.
        :param pulumi.Input[_builtins.str] virtual_network_id: The ID of the Virtual Network within which the Backend Address Pool should exist.
        """
        if backend_address_ip_configuration_id is not None:
            pulumi.set(__self__, "backend_address_ip_configuration_id", backend_address_ip_configuration_id)
        if backend_address_pool_id is not None:
            pulumi.set(__self__, "backend_address_pool_id", backend_address_pool_id)
        if inbound_nat_rule_port_mappings is not None:
            pulumi.set(__self__, "inbound_nat_rule_port_mappings", inbound_nat_rule_port_mappings)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if virtual_network_id is not None:
            pulumi.set(__self__, "virtual_network_id", virtual_network_id)

    @_builtins.property
    @pulumi.getter(name="backendAddressIpConfigurationId")
    def backend_address_ip_configuration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ip config ID of the regional load balancer that's added to the global load balancer's backend address pool.

        > **Note:** For cross-region load balancer, please append the name of the load balancers, virtual machines, and other resources in each region with a -R1 and -R2.
        """
        return pulumi.get(self, "backend_address_ip_configuration_id")

    @backend_address_ip_configuration_id.setter
    def backend_address_ip_configuration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend_address_ip_configuration_id", value)

    @_builtins.property
    @pulumi.getter(name="backendAddressPoolId")
    def backend_address_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Backend Address Pool. Changing this forces a new Backend Address Pool Address to be created.
        """
        return pulumi.get(self, "backend_address_pool_id")

    @backend_address_pool_id.setter
    def backend_address_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend_address_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="inboundNatRulePortMappings")
    def inbound_nat_rule_port_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackendAddressPoolAddressInboundNatRulePortMappingArgs']]]]:
        """
        A list of `inbound_nat_rule_port_mapping` block as defined below.
        """
        return pulumi.get(self, "inbound_nat_rule_port_mappings")

    @inbound_nat_rule_port_mappings.setter
    def inbound_nat_rule_port_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackendAddressPoolAddressInboundNatRulePortMappingArgs']]]]):
        pulumi.set(self, "inbound_nat_rule_port_mappings", value)

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Static IP Address which should be allocated to this Backend Address Pool.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ip_address", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Backend Address Pool Address. Changing this forces a new Backend Address Pool Address to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Virtual Network within which the Backend Address Pool should exist.
        """
        return pulumi.get(self, "virtual_network_id")

    @virtual_network_id.setter
    def virtual_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_id", value)


@pulumi.type_token("azure:lb/backendAddressPoolAddress:BackendAddressPoolAddress")
class BackendAddressPoolAddress(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_address_ip_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 backend_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Backend Address within a Backend Address Pool.

        > **Note:** Backend Addresses can only be added to a `Standard` SKU Load Balancer.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.network.get_virtual_network(name="example-network",
            resource_group_name="example-resources")
        example_get_lb = azure.lb.get_lb(name="example-lb",
            resource_group_name="example-resources")
        example_get_backend_address_pool = azure.lb.get_backend_address_pool(name="first",
            loadbalancer_id=example_get_lb.id)
        example_backend_address_pool_address = azure.lb.BackendAddressPoolAddress("example",
            name="example",
            backend_address_pool_id=example_get_backend_address_pool.id,
            virtual_network_id=example.id,
            ip_address="10.0.0.1")
        backend_pool_cr = azure.lb.get_backend_address_pool(name="globalLBBackendPool",
            loadbalancer_id=example_get_lb.id)
        example_1 = azure.lb.BackendAddressPoolAddress("example-1",
            name="address1",
            backend_address_pool_id=backend_pool_cr.id,
            backend_address_ip_configuration_id=backend_lb__r1["frontendIpConfiguration"][0]["id"])
        example_2 = azure.lb.BackendAddressPoolAddress("example-2",
            name="address2",
            backend_address_pool_id=backend_pool_cr.id,
            backend_address_ip_configuration_id=backend_lb__r2["frontendIpConfiguration"][0]["id"])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2023-09-01

        ## Import

        Backend Address Pool Addresses can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:lb/backendAddressPoolAddress:BackendAddressPoolAddress example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/loadBalancers/loadBalancer1/backendAddressPools/backendAddressPool1/addresses/address1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend_address_ip_configuration_id: The ip config ID of the regional load balancer that's added to the global load balancer's backend address pool.
               
               > **Note:** For cross-region load balancer, please append the name of the load balancers, virtual machines, and other resources in each region with a -R1 and -R2.
        :param pulumi.Input[_builtins.str] backend_address_pool_id: The ID of the Backend Address Pool. Changing this forces a new Backend Address Pool Address to be created.
        :param pulumi.Input[_builtins.str] ip_address: The Static IP Address which should be allocated to this Backend Address Pool.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Backend Address Pool Address. Changing this forces a new Backend Address Pool Address to be created.
        :param pulumi.Input[_builtins.str] virtual_network_id: The ID of the Virtual Network within which the Backend Address Pool should exist.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackendAddressPoolAddressArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Backend Address within a Backend Address Pool.

        > **Note:** Backend Addresses can only be added to a `Standard` SKU Load Balancer.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.network.get_virtual_network(name="example-network",
            resource_group_name="example-resources")
        example_get_lb = azure.lb.get_lb(name="example-lb",
            resource_group_name="example-resources")
        example_get_backend_address_pool = azure.lb.get_backend_address_pool(name="first",
            loadbalancer_id=example_get_lb.id)
        example_backend_address_pool_address = azure.lb.BackendAddressPoolAddress("example",
            name="example",
            backend_address_pool_id=example_get_backend_address_pool.id,
            virtual_network_id=example.id,
            ip_address="10.0.0.1")
        backend_pool_cr = azure.lb.get_backend_address_pool(name="globalLBBackendPool",
            loadbalancer_id=example_get_lb.id)
        example_1 = azure.lb.BackendAddressPoolAddress("example-1",
            name="address1",
            backend_address_pool_id=backend_pool_cr.id,
            backend_address_ip_configuration_id=backend_lb__r1["frontendIpConfiguration"][0]["id"])
        example_2 = azure.lb.BackendAddressPoolAddress("example-2",
            name="address2",
            backend_address_pool_id=backend_pool_cr.id,
            backend_address_ip_configuration_id=backend_lb__r2["frontendIpConfiguration"][0]["id"])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2023-09-01

        ## Import

        Backend Address Pool Addresses can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:lb/backendAddressPoolAddress:BackendAddressPoolAddress example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/loadBalancers/loadBalancer1/backendAddressPools/backendAddressPool1/addresses/address1
        ```

        :param str resource_name: The name of the resource.
        :param BackendAddressPoolAddressArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackendAddressPoolAddressArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_address_ip_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 backend_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackendAddressPoolAddressArgs.__new__(BackendAddressPoolAddressArgs)

            __props__.__dict__["backend_address_ip_configuration_id"] = backend_address_ip_configuration_id
            if backend_address_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'backend_address_pool_id'")
            __props__.__dict__["backend_address_pool_id"] = backend_address_pool_id
            __props__.__dict__["ip_address"] = ip_address
            __props__.__dict__["name"] = name
            __props__.__dict__["virtual_network_id"] = virtual_network_id
            __props__.__dict__["inbound_nat_rule_port_mappings"] = None
        super(BackendAddressPoolAddress, __self__).__init__(
            'azure:lb/backendAddressPoolAddress:BackendAddressPoolAddress',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend_address_ip_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
            backend_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            inbound_nat_rule_port_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['BackendAddressPoolAddressInboundNatRulePortMappingArgs', 'BackendAddressPoolAddressInboundNatRulePortMappingArgsDict']]]]] = None,
            ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'BackendAddressPoolAddress':
        """
        Get an existing BackendAddressPoolAddress resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend_address_ip_configuration_id: The ip config ID of the regional load balancer that's added to the global load balancer's backend address pool.
               
               > **Note:** For cross-region load balancer, please append the name of the load balancers, virtual machines, and other resources in each region with a -R1 and -R2.
        :param pulumi.Input[_builtins.str] backend_address_pool_id: The ID of the Backend Address Pool. Changing this forces a new Backend Address Pool Address to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['BackendAddressPoolAddressInboundNatRulePortMappingArgs', 'BackendAddressPoolAddressInboundNatRulePortMappingArgsDict']]]] inbound_nat_rule_port_mappings: A list of `inbound_nat_rule_port_mapping` block as defined below.
        :param pulumi.Input[_builtins.str] ip_address: The Static IP Address which should be allocated to this Backend Address Pool.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Backend Address Pool Address. Changing this forces a new Backend Address Pool Address to be created.
        :param pulumi.Input[_builtins.str] virtual_network_id: The ID of the Virtual Network within which the Backend Address Pool should exist.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackendAddressPoolAddressState.__new__(_BackendAddressPoolAddressState)

        __props__.__dict__["backend_address_ip_configuration_id"] = backend_address_ip_configuration_id
        __props__.__dict__["backend_address_pool_id"] = backend_address_pool_id
        __props__.__dict__["inbound_nat_rule_port_mappings"] = inbound_nat_rule_port_mappings
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["name"] = name
        __props__.__dict__["virtual_network_id"] = virtual_network_id
        return BackendAddressPoolAddress(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backendAddressIpConfigurationId")
    def backend_address_ip_configuration_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ip config ID of the regional load balancer that's added to the global load balancer's backend address pool.

        > **Note:** For cross-region load balancer, please append the name of the load balancers, virtual machines, and other resources in each region with a -R1 and -R2.
        """
        return pulumi.get(self, "backend_address_ip_configuration_id")

    @_builtins.property
    @pulumi.getter(name="backendAddressPoolId")
    def backend_address_pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Backend Address Pool. Changing this forces a new Backend Address Pool Address to be created.
        """
        return pulumi.get(self, "backend_address_pool_id")

    @_builtins.property
    @pulumi.getter(name="inboundNatRulePortMappings")
    def inbound_nat_rule_port_mappings(self) -> pulumi.Output[Sequence['outputs.BackendAddressPoolAddressInboundNatRulePortMapping']]:
        """
        A list of `inbound_nat_rule_port_mapping` block as defined below.
        """
        return pulumi.get(self, "inbound_nat_rule_port_mappings")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Static IP Address which should be allocated to this Backend Address Pool.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Backend Address Pool Address. Changing this forces a new Backend Address Pool Address to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkId")
    def virtual_network_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Virtual Network within which the Backend Address Pool should exist.
        """
        return pulumi.get(self, "virtual_network_id")

