# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WorkspaceTableArgs', 'WorkspaceTable']

@pulumi.input_type
class WorkspaceTableArgs:
    def __init__(__self__, *,
                 workspace_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 total_retention_in_days: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a WorkspaceTable resource.
        :param pulumi.Input[_builtins.str] workspace_id: The object ID of the Log Analytics Workspace that contains the table.
        :param pulumi.Input[_builtins.str] name: Specifies the name of a table in a Log Analytics Workspace.
        :param pulumi.Input[_builtins.str] plan: Specify the system how to handle and charge the logs ingested to the table. Possible values are `Analytics` and `Basic`. Defaults to `Analytics`.
               
               > **Note:** The `name` of tables currently supported by the `Basic` plan can be found [here](https://learn.microsoft.com/en-us/azure/azure-monitor/logs/basic-logs-azure-tables).
        :param pulumi.Input[_builtins.int] retention_in_days: The table's retention in days. Possible values are either `8` (Basic Tier only) or range between `4` and `730`.
        :param pulumi.Input[_builtins.int] total_retention_in_days: The table's total retention in days. Possible values range between `4` and `730`; or `1095`, `1460`, `1826`, `2191`, `2556`, `2922`, `3288`, `3653`, `4018`, or `4383`.
               
               > **Note:** `retention_in_days` and `total_retention_in_days` will revert back to the value of operationalinsights.AnalyticsWorkspace retention_in_days when a loganalytics.WorkspaceTable is deleted.
               
               > **Note:** The `retention_in_days` cannot be specified when `plan` is `Basic` because the retention is fixed at eight days.
        """
        pulumi.set(__self__, "workspace_id", workspace_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if total_retention_in_days is not None:
            pulumi.set(__self__, "total_retention_in_days", total_retention_in_days)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The object ID of the Log Analytics Workspace that contains the table.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of a table in a Log Analytics Workspace.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the system how to handle and charge the logs ingested to the table. Possible values are `Analytics` and `Basic`. Defaults to `Analytics`.

        > **Note:** The `name` of tables currently supported by the `Basic` plan can be found [here](https://learn.microsoft.com/en-us/azure/azure-monitor/logs/basic-logs-azure-tables).
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The table's retention in days. Possible values are either `8` (Basic Tier only) or range between `4` and `730`.
        """
        return pulumi.get(self, "retention_in_days")

    @retention_in_days.setter
    def retention_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_in_days", value)

    @_builtins.property
    @pulumi.getter(name="totalRetentionInDays")
    def total_retention_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The table's total retention in days. Possible values range between `4` and `730`; or `1095`, `1460`, `1826`, `2191`, `2556`, `2922`, `3288`, `3653`, `4018`, or `4383`.

        > **Note:** `retention_in_days` and `total_retention_in_days` will revert back to the value of operationalinsights.AnalyticsWorkspace retention_in_days when a loganalytics.WorkspaceTable is deleted.

        > **Note:** The `retention_in_days` cannot be specified when `plan` is `Basic` because the retention is fixed at eight days.
        """
        return pulumi.get(self, "total_retention_in_days")

    @total_retention_in_days.setter
    def total_retention_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_retention_in_days", value)


@pulumi.input_type
class _WorkspaceTableState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 total_retention_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkspaceTable resources.
        :param pulumi.Input[_builtins.str] name: Specifies the name of a table in a Log Analytics Workspace.
        :param pulumi.Input[_builtins.str] plan: Specify the system how to handle and charge the logs ingested to the table. Possible values are `Analytics` and `Basic`. Defaults to `Analytics`.
               
               > **Note:** The `name` of tables currently supported by the `Basic` plan can be found [here](https://learn.microsoft.com/en-us/azure/azure-monitor/logs/basic-logs-azure-tables).
        :param pulumi.Input[_builtins.int] retention_in_days: The table's retention in days. Possible values are either `8` (Basic Tier only) or range between `4` and `730`.
        :param pulumi.Input[_builtins.int] total_retention_in_days: The table's total retention in days. Possible values range between `4` and `730`; or `1095`, `1460`, `1826`, `2191`, `2556`, `2922`, `3288`, `3653`, `4018`, or `4383`.
               
               > **Note:** `retention_in_days` and `total_retention_in_days` will revert back to the value of operationalinsights.AnalyticsWorkspace retention_in_days when a loganalytics.WorkspaceTable is deleted.
               
               > **Note:** The `retention_in_days` cannot be specified when `plan` is `Basic` because the retention is fixed at eight days.
        :param pulumi.Input[_builtins.str] workspace_id: The object ID of the Log Analytics Workspace that contains the table.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if total_retention_in_days is not None:
            pulumi.set(__self__, "total_retention_in_days", total_retention_in_days)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of a table in a Log Analytics Workspace.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the system how to handle and charge the logs ingested to the table. Possible values are `Analytics` and `Basic`. Defaults to `Analytics`.

        > **Note:** The `name` of tables currently supported by the `Basic` plan can be found [here](https://learn.microsoft.com/en-us/azure/azure-monitor/logs/basic-logs-azure-tables).
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The table's retention in days. Possible values are either `8` (Basic Tier only) or range between `4` and `730`.
        """
        return pulumi.get(self, "retention_in_days")

    @retention_in_days.setter
    def retention_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_in_days", value)

    @_builtins.property
    @pulumi.getter(name="totalRetentionInDays")
    def total_retention_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The table's total retention in days. Possible values range between `4` and `730`; or `1095`, `1460`, `1826`, `2191`, `2556`, `2922`, `3288`, `3653`, `4018`, or `4383`.

        > **Note:** `retention_in_days` and `total_retention_in_days` will revert back to the value of operationalinsights.AnalyticsWorkspace retention_in_days when a loganalytics.WorkspaceTable is deleted.

        > **Note:** The `retention_in_days` cannot be specified when `plan` is `Basic` because the retention is fixed at eight days.
        """
        return pulumi.get(self, "total_retention_in_days")

    @total_retention_in_days.setter
    def total_retention_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_retention_in_days", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The object ID of the Log Analytics Workspace that contains the table.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("azure:loganalytics/workspaceTable:WorkspaceTable")
class WorkspaceTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 total_retention_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Table in a Log Analytics (formally Operational Insights) Workspace.

        > **Note:** This resource does not create or destroy tables. This resource is used to update attributes (currently only retention_in_days) of the tables created when a Log Analytics Workspace is created. Deleting an loganalytics.WorkspaceTable resource will not delete the table. Instead, the table's retention_in_days field will be set to the value of operationalinsights.AnalyticsWorkspace retention_in_days

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_workspace_table = azure.loganalytics.WorkspaceTable("example",
            workspace_id=example_analytics_workspace.id,
            name="AppMetrics",
            retention_in_days=60,
            total_retention_in_days=180)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OperationalInsights` - 2022-10-01

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of a table in a Log Analytics Workspace.
        :param pulumi.Input[_builtins.str] plan: Specify the system how to handle and charge the logs ingested to the table. Possible values are `Analytics` and `Basic`. Defaults to `Analytics`.
               
               > **Note:** The `name` of tables currently supported by the `Basic` plan can be found [here](https://learn.microsoft.com/en-us/azure/azure-monitor/logs/basic-logs-azure-tables).
        :param pulumi.Input[_builtins.int] retention_in_days: The table's retention in days. Possible values are either `8` (Basic Tier only) or range between `4` and `730`.
        :param pulumi.Input[_builtins.int] total_retention_in_days: The table's total retention in days. Possible values range between `4` and `730`; or `1095`, `1460`, `1826`, `2191`, `2556`, `2922`, `3288`, `3653`, `4018`, or `4383`.
               
               > **Note:** `retention_in_days` and `total_retention_in_days` will revert back to the value of operationalinsights.AnalyticsWorkspace retention_in_days when a loganalytics.WorkspaceTable is deleted.
               
               > **Note:** The `retention_in_days` cannot be specified when `plan` is `Basic` because the retention is fixed at eight days.
        :param pulumi.Input[_builtins.str] workspace_id: The object ID of the Log Analytics Workspace that contains the table.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Table in a Log Analytics (formally Operational Insights) Workspace.

        > **Note:** This resource does not create or destroy tables. This resource is used to update attributes (currently only retention_in_days) of the tables created when a Log Analytics Workspace is created. Deleting an loganalytics.WorkspaceTable resource will not delete the table. Instead, the table's retention_in_days field will be set to the value of operationalinsights.AnalyticsWorkspace retention_in_days

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_workspace_table = azure.loganalytics.WorkspaceTable("example",
            workspace_id=example_analytics_workspace.id,
            name="AppMetrics",
            retention_in_days=60,
            total_retention_in_days=180)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OperationalInsights` - 2022-10-01

        :param str resource_name: The name of the resource.
        :param WorkspaceTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 plan: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 total_retention_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceTableArgs.__new__(WorkspaceTableArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["plan"] = plan
            __props__.__dict__["retention_in_days"] = retention_in_days
            __props__.__dict__["total_retention_in_days"] = total_retention_in_days
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
        super(WorkspaceTable, __self__).__init__(
            'azure:loganalytics/workspaceTable:WorkspaceTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            plan: Optional[pulumi.Input[_builtins.str]] = None,
            retention_in_days: Optional[pulumi.Input[_builtins.int]] = None,
            total_retention_in_days: Optional[pulumi.Input[_builtins.int]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'WorkspaceTable':
        """
        Get an existing WorkspaceTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of a table in a Log Analytics Workspace.
        :param pulumi.Input[_builtins.str] plan: Specify the system how to handle and charge the logs ingested to the table. Possible values are `Analytics` and `Basic`. Defaults to `Analytics`.
               
               > **Note:** The `name` of tables currently supported by the `Basic` plan can be found [here](https://learn.microsoft.com/en-us/azure/azure-monitor/logs/basic-logs-azure-tables).
        :param pulumi.Input[_builtins.int] retention_in_days: The table's retention in days. Possible values are either `8` (Basic Tier only) or range between `4` and `730`.
        :param pulumi.Input[_builtins.int] total_retention_in_days: The table's total retention in days. Possible values range between `4` and `730`; or `1095`, `1460`, `1826`, `2191`, `2556`, `2922`, `3288`, `3653`, `4018`, or `4383`.
               
               > **Note:** `retention_in_days` and `total_retention_in_days` will revert back to the value of operationalinsights.AnalyticsWorkspace retention_in_days when a loganalytics.WorkspaceTable is deleted.
               
               > **Note:** The `retention_in_days` cannot be specified when `plan` is `Basic` because the retention is fixed at eight days.
        :param pulumi.Input[_builtins.str] workspace_id: The object ID of the Log Analytics Workspace that contains the table.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceTableState.__new__(_WorkspaceTableState)

        __props__.__dict__["name"] = name
        __props__.__dict__["plan"] = plan
        __props__.__dict__["retention_in_days"] = retention_in_days
        __props__.__dict__["total_retention_in_days"] = total_retention_in_days
        __props__.__dict__["workspace_id"] = workspace_id
        return WorkspaceTable(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of a table in a Log Analytics Workspace.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specify the system how to handle and charge the logs ingested to the table. Possible values are `Analytics` and `Basic`. Defaults to `Analytics`.

        > **Note:** The `name` of tables currently supported by the `Basic` plan can be found [here](https://learn.microsoft.com/en-us/azure/azure-monitor/logs/basic-logs-azure-tables).
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The table's retention in days. Possible values are either `8` (Basic Tier only) or range between `4` and `730`.
        """
        return pulumi.get(self, "retention_in_days")

    @_builtins.property
    @pulumi.getter(name="totalRetentionInDays")
    def total_retention_in_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The table's total retention in days. Possible values range between `4` and `730`; or `1095`, `1460`, `1826`, `2191`, `2556`, `2922`, `3288`, `3653`, `4018`, or `4383`.

        > **Note:** `retention_in_days` and `total_retention_in_days` will revert back to the value of operationalinsights.AnalyticsWorkspace retention_in_days when a loganalytics.WorkspaceTable is deleted.

        > **Note:** The `retention_in_days` cannot be specified when `plan` is `Basic` because the retention is fixed at eight days.
        """
        return pulumi.get(self, "total_retention_in_days")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The object ID of the Log Analytics Workspace that contains the table.
        """
        return pulumi.get(self, "workspace_id")

