# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'FlexibleServerCustomerManagedKey',
    'FlexibleServerHighAvailability',
    'FlexibleServerIdentity',
    'FlexibleServerMaintenanceWindow',
    'FlexibleServerStorage',
    'GetFlexibleServerHighAvailabilityResult',
    'GetFlexibleServerMaintenanceWindowResult',
    'GetFlexibleServerStorageResult',
]

@pulumi.output_type
class FlexibleServerCustomerManagedKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "geoBackupKeyVaultKeyId":
            suggest = "geo_backup_key_vault_key_id"
        elif key == "geoBackupUserAssignedIdentityId":
            suggest = "geo_backup_user_assigned_identity_id"
        elif key == "keyVaultKeyId":
            suggest = "key_vault_key_id"
        elif key == "primaryUserAssignedIdentityId":
            suggest = "primary_user_assigned_identity_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleServerCustomerManagedKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleServerCustomerManagedKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleServerCustomerManagedKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 geo_backup_key_vault_key_id: Optional[_builtins.str] = None,
                 geo_backup_user_assigned_identity_id: Optional[_builtins.str] = None,
                 key_vault_key_id: Optional[_builtins.str] = None,
                 primary_user_assigned_identity_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str geo_backup_key_vault_key_id: The ID of the geo backup Key Vault Key. It can't cross region and need Customer Managed Key in same region as geo backup.
        :param _builtins.str geo_backup_user_assigned_identity_id: The geo backup user managed identity id for a Customer Managed Key. Should be added with `identity_ids`. It can't cross region and need identity in same region as geo backup.
               
               > **Note:** `primary_user_assigned_identity_id` or `geo_backup_user_assigned_identity_id` is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param _builtins.str key_vault_key_id: The ID of the Key Vault Key.
        :param _builtins.str primary_user_assigned_identity_id: Specifies the primary user managed identity id for a Customer Managed Key. Should be added with `identity_ids`.
        """
        if geo_backup_key_vault_key_id is not None:
            pulumi.set(__self__, "geo_backup_key_vault_key_id", geo_backup_key_vault_key_id)
        if geo_backup_user_assigned_identity_id is not None:
            pulumi.set(__self__, "geo_backup_user_assigned_identity_id", geo_backup_user_assigned_identity_id)
        if key_vault_key_id is not None:
            pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if primary_user_assigned_identity_id is not None:
            pulumi.set(__self__, "primary_user_assigned_identity_id", primary_user_assigned_identity_id)

    @_builtins.property
    @pulumi.getter(name="geoBackupKeyVaultKeyId")
    def geo_backup_key_vault_key_id(self) -> Optional[_builtins.str]:
        """
        The ID of the geo backup Key Vault Key. It can't cross region and need Customer Managed Key in same region as geo backup.
        """
        return pulumi.get(self, "geo_backup_key_vault_key_id")

    @_builtins.property
    @pulumi.getter(name="geoBackupUserAssignedIdentityId")
    def geo_backup_user_assigned_identity_id(self) -> Optional[_builtins.str]:
        """
        The geo backup user managed identity id for a Customer Managed Key. Should be added with `identity_ids`. It can't cross region and need identity in same region as geo backup.

        > **Note:** `primary_user_assigned_identity_id` or `geo_backup_user_assigned_identity_id` is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "geo_backup_user_assigned_identity_id")

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Key Vault Key.
        """
        return pulumi.get(self, "key_vault_key_id")

    @_builtins.property
    @pulumi.getter(name="primaryUserAssignedIdentityId")
    def primary_user_assigned_identity_id(self) -> Optional[_builtins.str]:
        """
        Specifies the primary user managed identity id for a Customer Managed Key. Should be added with `identity_ids`.
        """
        return pulumi.get(self, "primary_user_assigned_identity_id")


@pulumi.output_type
class FlexibleServerHighAvailability(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "standbyAvailabilityZone":
            suggest = "standby_availability_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleServerHighAvailability. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleServerHighAvailability.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleServerHighAvailability.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: _builtins.str,
                 standby_availability_zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str mode: The high availability mode for the MySQL Flexible Server. Possibles values are `SameZone` and `ZoneRedundant`.
               
               > **Note:** `storage[0].auto_grow_enabled` must be enabled when `high_availability` is enabled. To change the `high_availability` for a MySQL Flexible Server created with `high_availability` disabled during creation, the resource has to be recreated.
        """
        pulumi.set(__self__, "mode", mode)
        if standby_availability_zone is not None:
            pulumi.set(__self__, "standby_availability_zone", standby_availability_zone)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        The high availability mode for the MySQL Flexible Server. Possibles values are `SameZone` and `ZoneRedundant`.

        > **Note:** `storage[0].auto_grow_enabled` must be enabled when `high_availability` is enabled. To change the `high_availability` for a MySQL Flexible Server created with `high_availability` disabled during creation, the resource has to be recreated.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="standbyAvailabilityZone")
    def standby_availability_zone(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "standby_availability_zone")


@pulumi.output_type
class FlexibleServerIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleServerIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleServerIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleServerIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_ids: Sequence[_builtins.str],
                 type: _builtins.str):
        """
        :param Sequence[_builtins.str] identity_ids: A list of User Assigned Managed Identity IDs to be assigned to this MySQL Flexible Server.
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this MySQL Flexible Server. The only possible value is `UserAssigned`.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[_builtins.str]:
        """
        A list of User Assigned Managed Identity IDs to be assigned to this MySQL Flexible Server.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this MySQL Flexible Server. The only possible value is `UserAssigned`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class FlexibleServerMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayOfWeek":
            suggest = "day_of_week"
        elif key == "startHour":
            suggest = "start_hour"
        elif key == "startMinute":
            suggest = "start_minute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleServerMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleServerMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleServerMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_of_week: Optional[_builtins.int] = None,
                 start_hour: Optional[_builtins.int] = None,
                 start_minute: Optional[_builtins.int] = None):
        """
        :param _builtins.int day_of_week: The day of week for maintenance window. Defaults to `0`.
        :param _builtins.int start_hour: The start hour for maintenance window. Defaults to `0`.
        :param _builtins.int start_minute: The start minute for maintenance window. Defaults to `0`.
        """
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if start_hour is not None:
            pulumi.set(__self__, "start_hour", start_hour)
        if start_minute is not None:
            pulumi.set(__self__, "start_minute", start_minute)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[_builtins.int]:
        """
        The day of week for maintenance window. Defaults to `0`.
        """
        return pulumi.get(self, "day_of_week")

    @_builtins.property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> Optional[_builtins.int]:
        """
        The start hour for maintenance window. Defaults to `0`.
        """
        return pulumi.get(self, "start_hour")

    @_builtins.property
    @pulumi.getter(name="startMinute")
    def start_minute(self) -> Optional[_builtins.int]:
        """
        The start minute for maintenance window. Defaults to `0`.
        """
        return pulumi.get(self, "start_minute")


@pulumi.output_type
class FlexibleServerStorage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoGrowEnabled":
            suggest = "auto_grow_enabled"
        elif key == "ioScalingEnabled":
            suggest = "io_scaling_enabled"
        elif key == "logOnDiskEnabled":
            suggest = "log_on_disk_enabled"
        elif key == "sizeGb":
            suggest = "size_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleServerStorage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleServerStorage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleServerStorage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_grow_enabled: Optional[_builtins.bool] = None,
                 io_scaling_enabled: Optional[_builtins.bool] = None,
                 iops: Optional[_builtins.int] = None,
                 log_on_disk_enabled: Optional[_builtins.bool] = None,
                 size_gb: Optional[_builtins.int] = None):
        """
        :param _builtins.bool auto_grow_enabled: Should Storage Auto Grow be enabled? Defaults to `true`.
        :param _builtins.bool io_scaling_enabled: Should IOPS be scaled automatically? If `true`, `iops` can not be set. Defaults to `false`.
        :param _builtins.int iops: The storage IOPS for the MySQL Flexible Server. Possible values are between `360` and `20000`.
        :param _builtins.bool log_on_disk_enabled: Should Storage Log On Disk be enabled? Defaults to `false`.
        :param _builtins.int size_gb: The max storage allowed for the MySQL Flexible Server. Possible values are between `20` and `16384`.
               
               > **Note:** Decreasing `size_gb` forces a new resource to be created.
        """
        if auto_grow_enabled is not None:
            pulumi.set(__self__, "auto_grow_enabled", auto_grow_enabled)
        if io_scaling_enabled is not None:
            pulumi.set(__self__, "io_scaling_enabled", io_scaling_enabled)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if log_on_disk_enabled is not None:
            pulumi.set(__self__, "log_on_disk_enabled", log_on_disk_enabled)
        if size_gb is not None:
            pulumi.set(__self__, "size_gb", size_gb)

    @_builtins.property
    @pulumi.getter(name="autoGrowEnabled")
    def auto_grow_enabled(self) -> Optional[_builtins.bool]:
        """
        Should Storage Auto Grow be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "auto_grow_enabled")

    @_builtins.property
    @pulumi.getter(name="ioScalingEnabled")
    def io_scaling_enabled(self) -> Optional[_builtins.bool]:
        """
        Should IOPS be scaled automatically? If `true`, `iops` can not be set. Defaults to `false`.
        """
        return pulumi.get(self, "io_scaling_enabled")

    @_builtins.property
    @pulumi.getter
    def iops(self) -> Optional[_builtins.int]:
        """
        The storage IOPS for the MySQL Flexible Server. Possible values are between `360` and `20000`.
        """
        return pulumi.get(self, "iops")

    @_builtins.property
    @pulumi.getter(name="logOnDiskEnabled")
    def log_on_disk_enabled(self) -> Optional[_builtins.bool]:
        """
        Should Storage Log On Disk be enabled? Defaults to `false`.
        """
        return pulumi.get(self, "log_on_disk_enabled")

    @_builtins.property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> Optional[_builtins.int]:
        """
        The max storage allowed for the MySQL Flexible Server. Possible values are between `20` and `16384`.

        > **Note:** Decreasing `size_gb` forces a new resource to be created.
        """
        return pulumi.get(self, "size_gb")


@pulumi.output_type
class GetFlexibleServerHighAvailabilityResult(dict):
    def __init__(__self__, *,
                 mode: _builtins.str,
                 standby_availability_zone: _builtins.str):
        """
        :param _builtins.str mode: The high availability mode of the MySQL Flexible Server.
        :param _builtins.str standby_availability_zone: The availability zone of the standby Flexible Server.
        """
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "standby_availability_zone", standby_availability_zone)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        The high availability mode of the MySQL Flexible Server.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="standbyAvailabilityZone")
    def standby_availability_zone(self) -> _builtins.str:
        """
        The availability zone of the standby Flexible Server.
        """
        return pulumi.get(self, "standby_availability_zone")


@pulumi.output_type
class GetFlexibleServerMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 day_of_week: _builtins.int,
                 start_hour: _builtins.int,
                 start_minute: _builtins.int):
        """
        :param _builtins.int day_of_week: The day of week of the maintenance window.
        :param _builtins.int start_hour: The start hour of the maintenance window.
        :param _builtins.int start_minute: The start minute of the maintenance window.
        """
        pulumi.set(__self__, "day_of_week", day_of_week)
        pulumi.set(__self__, "start_hour", start_hour)
        pulumi.set(__self__, "start_minute", start_minute)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> _builtins.int:
        """
        The day of week of the maintenance window.
        """
        return pulumi.get(self, "day_of_week")

    @_builtins.property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> _builtins.int:
        """
        The start hour of the maintenance window.
        """
        return pulumi.get(self, "start_hour")

    @_builtins.property
    @pulumi.getter(name="startMinute")
    def start_minute(self) -> _builtins.int:
        """
        The start minute of the maintenance window.
        """
        return pulumi.get(self, "start_minute")


@pulumi.output_type
class GetFlexibleServerStorageResult(dict):
    def __init__(__self__, *,
                 auto_grow_enabled: _builtins.bool,
                 io_scaling_enabled: _builtins.bool,
                 iops: _builtins.int,
                 size_gb: _builtins.int):
        """
        :param _builtins.bool auto_grow_enabled: Is Storage Auto Grow enabled?
        :param _builtins.bool io_scaling_enabled: Should IOPS be scaled automatically?
        :param _builtins.int iops: The storage IOPS of the MySQL Flexible Server.
        :param _builtins.int size_gb: The max storage allowed for the MySQL Flexible Server.
        """
        pulumi.set(__self__, "auto_grow_enabled", auto_grow_enabled)
        pulumi.set(__self__, "io_scaling_enabled", io_scaling_enabled)
        pulumi.set(__self__, "iops", iops)
        pulumi.set(__self__, "size_gb", size_gb)

    @_builtins.property
    @pulumi.getter(name="autoGrowEnabled")
    def auto_grow_enabled(self) -> _builtins.bool:
        """
        Is Storage Auto Grow enabled?
        """
        return pulumi.get(self, "auto_grow_enabled")

    @_builtins.property
    @pulumi.getter(name="ioScalingEnabled")
    def io_scaling_enabled(self) -> _builtins.bool:
        """
        Should IOPS be scaled automatically?
        """
        return pulumi.get(self, "io_scaling_enabled")

    @_builtins.property
    @pulumi.getter
    def iops(self) -> _builtins.int:
        """
        The storage IOPS of the MySQL Flexible Server.
        """
        return pulumi.get(self, "iops")

    @_builtins.property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> _builtins.int:
        """
        The max storage allowed for the MySQL Flexible Server.
        """
        return pulumi.get(self, "size_gb")


