# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VolumeArgs', 'Volume']

@pulumi.input_type
class VolumeArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[_builtins.str],
                 pool_name: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 service_level: pulumi.Input[_builtins.str],
                 storage_quota_in_gb: pulumi.Input[_builtins.int],
                 subnet_id: pulumi.Input[_builtins.str],
                 volume_path: pulumi.Input[_builtins.str],
                 azure_vmware_data_store_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cool_access: Optional[pulumi.Input['VolumeCoolAccessArgs']] = None,
                 create_from_snapshot_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_protection_backup_policy: Optional[pulumi.Input['VolumeDataProtectionBackupPolicyArgs']] = None,
                 data_protection_replication: Optional[pulumi.Input['VolumeDataProtectionReplicationArgs']] = None,
                 data_protection_snapshot_policy: Optional[pulumi.Input['VolumeDataProtectionSnapshotPolicyArgs']] = None,
                 encryption_key_source: Optional[pulumi.Input[_builtins.str]] = None,
                 export_policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeExportPolicyRuleArgs']]]] = None,
                 kerberos_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_vault_private_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 large_volume_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_features: Optional[pulumi.Input[_builtins.str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_style: Optional[pulumi.Input[_builtins.str]] = None,
                 smb3_protocol_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 smb_access_based_enumeration_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 smb_continuous_availability_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 smb_non_browsable_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 snapshot_directory_visible: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 throughput_in_mibps: Optional[pulumi.Input[_builtins.float]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Volume resource.
        :param pulumi.Input[_builtins.str] account_name: The name of the NetApp account in which the NetApp Pool should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] pool_name: The name of the NetApp pool in which the NetApp Volume should be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group where the NetApp Volume should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] storage_quota_in_gb: The maximum Storage Quota allowed for a file system in Gigabytes.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet the NetApp Volume resides in, which must have the `Microsoft.NetApp/volumes` delegation. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] volume_path: A unique file path for the volume. Used when creating mount targets. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] azure_vmware_data_store_enabled: Is the NetApp Volume enabled for Azure VMware Solution (AVS) datastore purpose. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input['VolumeCoolAccessArgs'] cool_access: A `cool_access` block as defined below.
        :param pulumi.Input[_builtins.str] create_from_snapshot_resource_id: Creates volume from snapshot. Following properties must be the same as the original volume where the snapshot was taken from: `protocols`, `subnet_id`, `location`, `service_level`, `resource_group_name` and `account_name`. Changing this forces a new resource to be created.
        :param pulumi.Input['VolumeDataProtectionBackupPolicyArgs'] data_protection_backup_policy: A `data_protection_backup_policy` block as defined below.
        :param pulumi.Input['VolumeDataProtectionReplicationArgs'] data_protection_replication: A `data_protection_replication` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input['VolumeDataProtectionSnapshotPolicyArgs'] data_protection_snapshot_policy: A `data_protection_snapshot_policy` block as defined below.
        :param pulumi.Input[_builtins.str] encryption_key_source: The encryption key source, it can be `Microsoft.NetApp` for platform managed keys or `Microsoft.KeyVault` for customer-managed keys. This is required with `key_vault_private_endpoint_id`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeExportPolicyRuleArgs']]] export_policy_rules: One or more `export_policy_rule` block defined below.
        :param pulumi.Input[_builtins.bool] kerberos_enabled: Enable to allow Kerberos secured volumes. Requires appropriate export rules as well as the parent `netapp.Account` having a defined AD connection.
        :param pulumi.Input[_builtins.str] key_vault_private_endpoint_id: The Private Endpoint ID for Key Vault, which is required when using customer-managed keys. This is required with `encryption_key_source`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] large_volume_enabled: A boolean specifying if the volume is a large volume. Defaults to `false`.
               
               > **Note:** Large volumes must be at least 50 TiB in size and can be up to 1,024 TiB (1 PiB). For more information, please refer to [Requirements and considerations for large volumes](https://learn.microsoft.com/en-us/azure/azure-netapp-files/large-volumes-requirements-considerations)
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the NetApp Volume. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] network_features: Indicates which network feature to use, accepted values are `Basic` or `Standard`, it defaults to `Basic` if not defined. This is a feature in public preview and for more information about it and how to register, please refer to [Configure network features for an Azure NetApp Files volume](https://docs.microsoft.com/en-us/azure/azure-netapp-files/configure-network-features).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protocols: The target volume protocol expressed as a list. Supported single value include `CIFS`, `NFSv3`, or `NFSv4.1`. If argument is not defined it will default to `NFSv3`. Changing this forces a new resource to be created and data will be lost. Dual protocol scenario is supported for CIFS and NFSv3, for more information, please refer to [Create a dual-protocol volume for Azure NetApp Files](https://docs.microsoft.com/azure/azure-netapp-files/create-volumes-dual-protocol) document.
        :param pulumi.Input[_builtins.str] security_style: Volume security style, accepted values are `unix` or `ntfs`. If not provided, single-protocol volume is created defaulting to `unix` if it is `NFSv3` or `NFSv4.1` volume, if `CIFS`, it will default to `ntfs`. In a dual-protocol volume, if not provided, its value will be `ntfs`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] smb3_protocol_encryption_enabled: Enable SMB encryption. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] smb_access_based_enumeration_enabled: Limits enumeration of files and folders (that is, listing the contents) in SMB only to users with allowed access on the share. For instance, if a user doesn't have access to read a file or folder in a share with access-based enumeration enabled, then the file or folder doesn't show up in directory listings. Defaults to `false`. For more information, please refer to [Understand NAS share permissions in Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/network-attached-storage-permissions#:~:text=security%20for%20administrators.-,Access%2Dbased%20enumeration,in%20an%20Azure%20NetApp%20Files%20SMB%20volume.%20Only%20contosoadmin%20has%20access.,-In%20the%20below)
        :param pulumi.Input[_builtins.bool] smb_continuous_availability_enabled: Enable SMB Continuous Availability. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] smb_non_browsable_enabled: Limits clients from browsing for an SMB share by hiding the share from view in Windows Explorer or when listing shares in "net view." Only end users that know the absolute paths to the share are able to find the share. Defaults to `false`. For more information, please refer to [Understand NAS share permissions in Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/network-attached-storage-permissions#:~:text=Non%2Dbrowsable%20shares,find%20the%20share.)
        :param pulumi.Input[_builtins.bool] snapshot_directory_visible: Specifies whether the .snapshot (NFS clients) or ~snapshot (SMB clients) path of a volume is visible. Defaults to `true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               
               > **Note:** It is highly recommended to use the **lifecycle** property as noted in the example since it will prevent an accidental deletion of the volume if the `protocols` argument changes to a different protocol type.
        :param pulumi.Input[_builtins.float] throughput_in_mibps: Throughput of this volume in Mibps.
        :param pulumi.Input[_builtins.str] zone: Specifies the Availability Zone in which the Volume should be located. Possible values are `1`, `2` and `3`. Changing this forces a new resource to be created. This feature is currently in preview, for more information on how to enable it, please refer to [Manage availability zone volume placement for Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/manage-availability-zone-volume-placement#register-the-feature).
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "pool_name", pool_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "service_level", service_level)
        pulumi.set(__self__, "storage_quota_in_gb", storage_quota_in_gb)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "volume_path", volume_path)
        if azure_vmware_data_store_enabled is not None:
            pulumi.set(__self__, "azure_vmware_data_store_enabled", azure_vmware_data_store_enabled)
        if cool_access is not None:
            pulumi.set(__self__, "cool_access", cool_access)
        if create_from_snapshot_resource_id is not None:
            pulumi.set(__self__, "create_from_snapshot_resource_id", create_from_snapshot_resource_id)
        if data_protection_backup_policy is not None:
            pulumi.set(__self__, "data_protection_backup_policy", data_protection_backup_policy)
        if data_protection_replication is not None:
            pulumi.set(__self__, "data_protection_replication", data_protection_replication)
        if data_protection_snapshot_policy is not None:
            pulumi.set(__self__, "data_protection_snapshot_policy", data_protection_snapshot_policy)
        if encryption_key_source is not None:
            pulumi.set(__self__, "encryption_key_source", encryption_key_source)
        if export_policy_rules is not None:
            pulumi.set(__self__, "export_policy_rules", export_policy_rules)
        if kerberos_enabled is not None:
            pulumi.set(__self__, "kerberos_enabled", kerberos_enabled)
        if key_vault_private_endpoint_id is not None:
            pulumi.set(__self__, "key_vault_private_endpoint_id", key_vault_private_endpoint_id)
        if large_volume_enabled is not None:
            pulumi.set(__self__, "large_volume_enabled", large_volume_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_features is not None:
            pulumi.set(__self__, "network_features", network_features)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if security_style is not None:
            pulumi.set(__self__, "security_style", security_style)
        if smb3_protocol_encryption_enabled is not None:
            pulumi.set(__self__, "smb3_protocol_encryption_enabled", smb3_protocol_encryption_enabled)
        if smb_access_based_enumeration_enabled is not None:
            pulumi.set(__self__, "smb_access_based_enumeration_enabled", smb_access_based_enumeration_enabled)
        if smb_continuous_availability_enabled is not None:
            pulumi.set(__self__, "smb_continuous_availability_enabled", smb_continuous_availability_enabled)
        if smb_non_browsable_enabled is not None:
            pulumi.set(__self__, "smb_non_browsable_enabled", smb_non_browsable_enabled)
        if snapshot_directory_visible is not None:
            pulumi.set(__self__, "snapshot_directory_visible", snapshot_directory_visible)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if throughput_in_mibps is not None:
            pulumi.set(__self__, "throughput_in_mibps", throughput_in_mibps)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the NetApp account in which the NetApp Pool should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="poolName")
    def pool_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the NetApp pool in which the NetApp Volume should be created.
        """
        return pulumi.get(self, "pool_name")

    @pool_name.setter
    def pool_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pool_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group where the NetApp Volume should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="serviceLevel")
    def service_level(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "service_level")

    @service_level.setter
    def service_level(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_level", value)

    @_builtins.property
    @pulumi.getter(name="storageQuotaInGb")
    def storage_quota_in_gb(self) -> pulumi.Input[_builtins.int]:
        """
        The maximum Storage Quota allowed for a file system in Gigabytes.
        """
        return pulumi.get(self, "storage_quota_in_gb")

    @storage_quota_in_gb.setter
    def storage_quota_in_gb(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "storage_quota_in_gb", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Subnet the NetApp Volume resides in, which must have the `Microsoft.NetApp/volumes` delegation. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="volumePath")
    def volume_path(self) -> pulumi.Input[_builtins.str]:
        """
        A unique file path for the volume. Used when creating mount targets. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "volume_path")

    @volume_path.setter
    def volume_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "volume_path", value)

    @_builtins.property
    @pulumi.getter(name="azureVmwareDataStoreEnabled")
    def azure_vmware_data_store_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the NetApp Volume enabled for Azure VMware Solution (AVS) datastore purpose. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "azure_vmware_data_store_enabled")

    @azure_vmware_data_store_enabled.setter
    def azure_vmware_data_store_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "azure_vmware_data_store_enabled", value)

    @_builtins.property
    @pulumi.getter(name="coolAccess")
    def cool_access(self) -> Optional[pulumi.Input['VolumeCoolAccessArgs']]:
        """
        A `cool_access` block as defined below.
        """
        return pulumi.get(self, "cool_access")

    @cool_access.setter
    def cool_access(self, value: Optional[pulumi.Input['VolumeCoolAccessArgs']]):
        pulumi.set(self, "cool_access", value)

    @_builtins.property
    @pulumi.getter(name="createFromSnapshotResourceId")
    def create_from_snapshot_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates volume from snapshot. Following properties must be the same as the original volume where the snapshot was taken from: `protocols`, `subnet_id`, `location`, `service_level`, `resource_group_name` and `account_name`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "create_from_snapshot_resource_id")

    @create_from_snapshot_resource_id.setter
    def create_from_snapshot_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_from_snapshot_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="dataProtectionBackupPolicy")
    def data_protection_backup_policy(self) -> Optional[pulumi.Input['VolumeDataProtectionBackupPolicyArgs']]:
        """
        A `data_protection_backup_policy` block as defined below.
        """
        return pulumi.get(self, "data_protection_backup_policy")

    @data_protection_backup_policy.setter
    def data_protection_backup_policy(self, value: Optional[pulumi.Input['VolumeDataProtectionBackupPolicyArgs']]):
        pulumi.set(self, "data_protection_backup_policy", value)

    @_builtins.property
    @pulumi.getter(name="dataProtectionReplication")
    def data_protection_replication(self) -> Optional[pulumi.Input['VolumeDataProtectionReplicationArgs']]:
        """
        A `data_protection_replication` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_protection_replication")

    @data_protection_replication.setter
    def data_protection_replication(self, value: Optional[pulumi.Input['VolumeDataProtectionReplicationArgs']]):
        pulumi.set(self, "data_protection_replication", value)

    @_builtins.property
    @pulumi.getter(name="dataProtectionSnapshotPolicy")
    def data_protection_snapshot_policy(self) -> Optional[pulumi.Input['VolumeDataProtectionSnapshotPolicyArgs']]:
        """
        A `data_protection_snapshot_policy` block as defined below.
        """
        return pulumi.get(self, "data_protection_snapshot_policy")

    @data_protection_snapshot_policy.setter
    def data_protection_snapshot_policy(self, value: Optional[pulumi.Input['VolumeDataProtectionSnapshotPolicyArgs']]):
        pulumi.set(self, "data_protection_snapshot_policy", value)

    @_builtins.property
    @pulumi.getter(name="encryptionKeySource")
    def encryption_key_source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The encryption key source, it can be `Microsoft.NetApp` for platform managed keys or `Microsoft.KeyVault` for customer-managed keys. This is required with `key_vault_private_endpoint_id`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_key_source")

    @encryption_key_source.setter
    def encryption_key_source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_key_source", value)

    @_builtins.property
    @pulumi.getter(name="exportPolicyRules")
    def export_policy_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeExportPolicyRuleArgs']]]]:
        """
        One or more `export_policy_rule` block defined below.
        """
        return pulumi.get(self, "export_policy_rules")

    @export_policy_rules.setter
    def export_policy_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeExportPolicyRuleArgs']]]]):
        pulumi.set(self, "export_policy_rules", value)

    @_builtins.property
    @pulumi.getter(name="kerberosEnabled")
    def kerberos_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable to allow Kerberos secured volumes. Requires appropriate export rules as well as the parent `netapp.Account` having a defined AD connection.
        """
        return pulumi.get(self, "kerberos_enabled")

    @kerberos_enabled.setter
    def kerberos_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "kerberos_enabled", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultPrivateEndpointId")
    def key_vault_private_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Private Endpoint ID for Key Vault, which is required when using customer-managed keys. This is required with `encryption_key_source`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_private_endpoint_id")

    @key_vault_private_endpoint_id.setter
    def key_vault_private_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_private_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="largeVolumeEnabled")
    def large_volume_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean specifying if the volume is a large volume. Defaults to `false`.

        > **Note:** Large volumes must be at least 50 TiB in size and can be up to 1,024 TiB (1 PiB). For more information, please refer to [Requirements and considerations for large volumes](https://learn.microsoft.com/en-us/azure/azure-netapp-files/large-volumes-requirements-considerations)
        """
        return pulumi.get(self, "large_volume_enabled")

    @large_volume_enabled.setter
    def large_volume_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "large_volume_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the NetApp Volume. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkFeatures")
    def network_features(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates which network feature to use, accepted values are `Basic` or `Standard`, it defaults to `Basic` if not defined. This is a feature in public preview and for more information about it and how to register, please refer to [Configure network features for an Azure NetApp Files volume](https://docs.microsoft.com/en-us/azure/azure-netapp-files/configure-network-features).
        """
        return pulumi.get(self, "network_features")

    @network_features.setter
    def network_features(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_features", value)

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The target volume protocol expressed as a list. Supported single value include `CIFS`, `NFSv3`, or `NFSv4.1`. If argument is not defined it will default to `NFSv3`. Changing this forces a new resource to be created and data will be lost. Dual protocol scenario is supported for CIFS and NFSv3, for more information, please refer to [Create a dual-protocol volume for Azure NetApp Files](https://docs.microsoft.com/azure/azure-netapp-files/create-volumes-dual-protocol) document.
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "protocols", value)

    @_builtins.property
    @pulumi.getter(name="securityStyle")
    def security_style(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Volume security style, accepted values are `unix` or `ntfs`. If not provided, single-protocol volume is created defaulting to `unix` if it is `NFSv3` or `NFSv4.1` volume, if `CIFS`, it will default to `ntfs`. In a dual-protocol volume, if not provided, its value will be `ntfs`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "security_style")

    @security_style.setter
    def security_style(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_style", value)

    @_builtins.property
    @pulumi.getter(name="smb3ProtocolEncryptionEnabled")
    def smb3_protocol_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable SMB encryption. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "smb3_protocol_encryption_enabled")

    @smb3_protocol_encryption_enabled.setter
    def smb3_protocol_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "smb3_protocol_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter(name="smbAccessBasedEnumerationEnabled")
    def smb_access_based_enumeration_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Limits enumeration of files and folders (that is, listing the contents) in SMB only to users with allowed access on the share. For instance, if a user doesn't have access to read a file or folder in a share with access-based enumeration enabled, then the file or folder doesn't show up in directory listings. Defaults to `false`. For more information, please refer to [Understand NAS share permissions in Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/network-attached-storage-permissions#:~:text=security%20for%20administrators.-,Access%2Dbased%20enumeration,in%20an%20Azure%20NetApp%20Files%20SMB%20volume.%20Only%20contosoadmin%20has%20access.,-In%20the%20below)
        """
        return pulumi.get(self, "smb_access_based_enumeration_enabled")

    @smb_access_based_enumeration_enabled.setter
    def smb_access_based_enumeration_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "smb_access_based_enumeration_enabled", value)

    @_builtins.property
    @pulumi.getter(name="smbContinuousAvailabilityEnabled")
    def smb_continuous_availability_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable SMB Continuous Availability. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "smb_continuous_availability_enabled")

    @smb_continuous_availability_enabled.setter
    def smb_continuous_availability_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "smb_continuous_availability_enabled", value)

    @_builtins.property
    @pulumi.getter(name="smbNonBrowsableEnabled")
    def smb_non_browsable_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Limits clients from browsing for an SMB share by hiding the share from view in Windows Explorer or when listing shares in "net view." Only end users that know the absolute paths to the share are able to find the share. Defaults to `false`. For more information, please refer to [Understand NAS share permissions in Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/network-attached-storage-permissions#:~:text=Non%2Dbrowsable%20shares,find%20the%20share.)
        """
        return pulumi.get(self, "smb_non_browsable_enabled")

    @smb_non_browsable_enabled.setter
    def smb_non_browsable_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "smb_non_browsable_enabled", value)

    @_builtins.property
    @pulumi.getter(name="snapshotDirectoryVisible")
    def snapshot_directory_visible(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the .snapshot (NFS clients) or ~snapshot (SMB clients) path of a volume is visible. Defaults to `true`.
        """
        return pulumi.get(self, "snapshot_directory_visible")

    @snapshot_directory_visible.setter
    def snapshot_directory_visible(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "snapshot_directory_visible", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.

        > **Note:** It is highly recommended to use the **lifecycle** property as noted in the example since it will prevent an accidental deletion of the volume if the `protocols` argument changes to a different protocol type.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="throughputInMibps")
    def throughput_in_mibps(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Throughput of this volume in Mibps.
        """
        return pulumi.get(self, "throughput_in_mibps")

    @throughput_in_mibps.setter
    def throughput_in_mibps(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "throughput_in_mibps", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Availability Zone in which the Volume should be located. Possible values are `1`, `2` and `3`. Changing this forces a new resource to be created. This feature is currently in preview, for more information on how to enable it, please refer to [Manage availability zone volume placement for Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/manage-availability-zone-volume-placement#register-the-feature).
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _VolumeState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_vmware_data_store_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cool_access: Optional[pulumi.Input['VolumeCoolAccessArgs']] = None,
                 create_from_snapshot_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_protection_backup_policy: Optional[pulumi.Input['VolumeDataProtectionBackupPolicyArgs']] = None,
                 data_protection_replication: Optional[pulumi.Input['VolumeDataProtectionReplicationArgs']] = None,
                 data_protection_snapshot_policy: Optional[pulumi.Input['VolumeDataProtectionSnapshotPolicyArgs']] = None,
                 encryption_key_source: Optional[pulumi.Input[_builtins.str]] = None,
                 export_policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeExportPolicyRuleArgs']]]] = None,
                 kerberos_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_vault_private_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 large_volume_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 mount_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_features: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_style: Optional[pulumi.Input[_builtins.str]] = None,
                 service_level: Optional[pulumi.Input[_builtins.str]] = None,
                 smb3_protocol_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 smb_access_based_enumeration_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 smb_continuous_availability_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 smb_non_browsable_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 snapshot_directory_visible: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_quota_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 throughput_in_mibps: Optional[pulumi.Input[_builtins.float]] = None,
                 volume_path: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Volume resources.
        :param pulumi.Input[_builtins.str] account_name: The name of the NetApp account in which the NetApp Pool should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] azure_vmware_data_store_enabled: Is the NetApp Volume enabled for Azure VMware Solution (AVS) datastore purpose. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input['VolumeCoolAccessArgs'] cool_access: A `cool_access` block as defined below.
        :param pulumi.Input[_builtins.str] create_from_snapshot_resource_id: Creates volume from snapshot. Following properties must be the same as the original volume where the snapshot was taken from: `protocols`, `subnet_id`, `location`, `service_level`, `resource_group_name` and `account_name`. Changing this forces a new resource to be created.
        :param pulumi.Input['VolumeDataProtectionBackupPolicyArgs'] data_protection_backup_policy: A `data_protection_backup_policy` block as defined below.
        :param pulumi.Input['VolumeDataProtectionReplicationArgs'] data_protection_replication: A `data_protection_replication` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input['VolumeDataProtectionSnapshotPolicyArgs'] data_protection_snapshot_policy: A `data_protection_snapshot_policy` block as defined below.
        :param pulumi.Input[_builtins.str] encryption_key_source: The encryption key source, it can be `Microsoft.NetApp` for platform managed keys or `Microsoft.KeyVault` for customer-managed keys. This is required with `key_vault_private_endpoint_id`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeExportPolicyRuleArgs']]] export_policy_rules: One or more `export_policy_rule` block defined below.
        :param pulumi.Input[_builtins.bool] kerberos_enabled: Enable to allow Kerberos secured volumes. Requires appropriate export rules as well as the parent `netapp.Account` having a defined AD connection.
        :param pulumi.Input[_builtins.str] key_vault_private_endpoint_id: The Private Endpoint ID for Key Vault, which is required when using customer-managed keys. This is required with `encryption_key_source`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] large_volume_enabled: A boolean specifying if the volume is a large volume. Defaults to `false`.
               
               > **Note:** Large volumes must be at least 50 TiB in size and can be up to 1,024 TiB (1 PiB). For more information, please refer to [Requirements and considerations for large volumes](https://learn.microsoft.com/en-us/azure/azure-netapp-files/large-volumes-requirements-considerations)
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] mount_ip_addresses: A list of IPv4 Addresses which should be used to mount the volume.
        :param pulumi.Input[_builtins.str] name: The name of the NetApp Volume. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] network_features: Indicates which network feature to use, accepted values are `Basic` or `Standard`, it defaults to `Basic` if not defined. This is a feature in public preview and for more information about it and how to register, please refer to [Configure network features for an Azure NetApp Files volume](https://docs.microsoft.com/en-us/azure/azure-netapp-files/configure-network-features).
        :param pulumi.Input[_builtins.str] pool_name: The name of the NetApp pool in which the NetApp Volume should be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protocols: The target volume protocol expressed as a list. Supported single value include `CIFS`, `NFSv3`, or `NFSv4.1`. If argument is not defined it will default to `NFSv3`. Changing this forces a new resource to be created and data will be lost. Dual protocol scenario is supported for CIFS and NFSv3, for more information, please refer to [Create a dual-protocol volume for Azure NetApp Files](https://docs.microsoft.com/azure/azure-netapp-files/create-volumes-dual-protocol) document.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group where the NetApp Volume should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] security_style: Volume security style, accepted values are `unix` or `ntfs`. If not provided, single-protocol volume is created defaulting to `unix` if it is `NFSv3` or `NFSv4.1` volume, if `CIFS`, it will default to `ntfs`. In a dual-protocol volume, if not provided, its value will be `ntfs`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] smb3_protocol_encryption_enabled: Enable SMB encryption. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] smb_access_based_enumeration_enabled: Limits enumeration of files and folders (that is, listing the contents) in SMB only to users with allowed access on the share. For instance, if a user doesn't have access to read a file or folder in a share with access-based enumeration enabled, then the file or folder doesn't show up in directory listings. Defaults to `false`. For more information, please refer to [Understand NAS share permissions in Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/network-attached-storage-permissions#:~:text=security%20for%20administrators.-,Access%2Dbased%20enumeration,in%20an%20Azure%20NetApp%20Files%20SMB%20volume.%20Only%20contosoadmin%20has%20access.,-In%20the%20below)
        :param pulumi.Input[_builtins.bool] smb_continuous_availability_enabled: Enable SMB Continuous Availability. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] smb_non_browsable_enabled: Limits clients from browsing for an SMB share by hiding the share from view in Windows Explorer or when listing shares in "net view." Only end users that know the absolute paths to the share are able to find the share. Defaults to `false`. For more information, please refer to [Understand NAS share permissions in Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/network-attached-storage-permissions#:~:text=Non%2Dbrowsable%20shares,find%20the%20share.)
        :param pulumi.Input[_builtins.bool] snapshot_directory_visible: Specifies whether the .snapshot (NFS clients) or ~snapshot (SMB clients) path of a volume is visible. Defaults to `true`.
        :param pulumi.Input[_builtins.int] storage_quota_in_gb: The maximum Storage Quota allowed for a file system in Gigabytes.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet the NetApp Volume resides in, which must have the `Microsoft.NetApp/volumes` delegation. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               
               > **Note:** It is highly recommended to use the **lifecycle** property as noted in the example since it will prevent an accidental deletion of the volume if the `protocols` argument changes to a different protocol type.
        :param pulumi.Input[_builtins.float] throughput_in_mibps: Throughput of this volume in Mibps.
        :param pulumi.Input[_builtins.str] volume_path: A unique file path for the volume. Used when creating mount targets. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] zone: Specifies the Availability Zone in which the Volume should be located. Possible values are `1`, `2` and `3`. Changing this forces a new resource to be created. This feature is currently in preview, for more information on how to enable it, please refer to [Manage availability zone volume placement for Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/manage-availability-zone-volume-placement#register-the-feature).
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if azure_vmware_data_store_enabled is not None:
            pulumi.set(__self__, "azure_vmware_data_store_enabled", azure_vmware_data_store_enabled)
        if cool_access is not None:
            pulumi.set(__self__, "cool_access", cool_access)
        if create_from_snapshot_resource_id is not None:
            pulumi.set(__self__, "create_from_snapshot_resource_id", create_from_snapshot_resource_id)
        if data_protection_backup_policy is not None:
            pulumi.set(__self__, "data_protection_backup_policy", data_protection_backup_policy)
        if data_protection_replication is not None:
            pulumi.set(__self__, "data_protection_replication", data_protection_replication)
        if data_protection_snapshot_policy is not None:
            pulumi.set(__self__, "data_protection_snapshot_policy", data_protection_snapshot_policy)
        if encryption_key_source is not None:
            pulumi.set(__self__, "encryption_key_source", encryption_key_source)
        if export_policy_rules is not None:
            pulumi.set(__self__, "export_policy_rules", export_policy_rules)
        if kerberos_enabled is not None:
            pulumi.set(__self__, "kerberos_enabled", kerberos_enabled)
        if key_vault_private_endpoint_id is not None:
            pulumi.set(__self__, "key_vault_private_endpoint_id", key_vault_private_endpoint_id)
        if large_volume_enabled is not None:
            pulumi.set(__self__, "large_volume_enabled", large_volume_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mount_ip_addresses is not None:
            pulumi.set(__self__, "mount_ip_addresses", mount_ip_addresses)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_features is not None:
            pulumi.set(__self__, "network_features", network_features)
        if pool_name is not None:
            pulumi.set(__self__, "pool_name", pool_name)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if security_style is not None:
            pulumi.set(__self__, "security_style", security_style)
        if service_level is not None:
            pulumi.set(__self__, "service_level", service_level)
        if smb3_protocol_encryption_enabled is not None:
            pulumi.set(__self__, "smb3_protocol_encryption_enabled", smb3_protocol_encryption_enabled)
        if smb_access_based_enumeration_enabled is not None:
            pulumi.set(__self__, "smb_access_based_enumeration_enabled", smb_access_based_enumeration_enabled)
        if smb_continuous_availability_enabled is not None:
            pulumi.set(__self__, "smb_continuous_availability_enabled", smb_continuous_availability_enabled)
        if smb_non_browsable_enabled is not None:
            pulumi.set(__self__, "smb_non_browsable_enabled", smb_non_browsable_enabled)
        if snapshot_directory_visible is not None:
            pulumi.set(__self__, "snapshot_directory_visible", snapshot_directory_visible)
        if storage_quota_in_gb is not None:
            pulumi.set(__self__, "storage_quota_in_gb", storage_quota_in_gb)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if throughput_in_mibps is not None:
            pulumi.set(__self__, "throughput_in_mibps", throughput_in_mibps)
        if volume_path is not None:
            pulumi.set(__self__, "volume_path", volume_path)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the NetApp account in which the NetApp Pool should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="azureVmwareDataStoreEnabled")
    def azure_vmware_data_store_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the NetApp Volume enabled for Azure VMware Solution (AVS) datastore purpose. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "azure_vmware_data_store_enabled")

    @azure_vmware_data_store_enabled.setter
    def azure_vmware_data_store_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "azure_vmware_data_store_enabled", value)

    @_builtins.property
    @pulumi.getter(name="coolAccess")
    def cool_access(self) -> Optional[pulumi.Input['VolumeCoolAccessArgs']]:
        """
        A `cool_access` block as defined below.
        """
        return pulumi.get(self, "cool_access")

    @cool_access.setter
    def cool_access(self, value: Optional[pulumi.Input['VolumeCoolAccessArgs']]):
        pulumi.set(self, "cool_access", value)

    @_builtins.property
    @pulumi.getter(name="createFromSnapshotResourceId")
    def create_from_snapshot_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creates volume from snapshot. Following properties must be the same as the original volume where the snapshot was taken from: `protocols`, `subnet_id`, `location`, `service_level`, `resource_group_name` and `account_name`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "create_from_snapshot_resource_id")

    @create_from_snapshot_resource_id.setter
    def create_from_snapshot_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_from_snapshot_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="dataProtectionBackupPolicy")
    def data_protection_backup_policy(self) -> Optional[pulumi.Input['VolumeDataProtectionBackupPolicyArgs']]:
        """
        A `data_protection_backup_policy` block as defined below.
        """
        return pulumi.get(self, "data_protection_backup_policy")

    @data_protection_backup_policy.setter
    def data_protection_backup_policy(self, value: Optional[pulumi.Input['VolumeDataProtectionBackupPolicyArgs']]):
        pulumi.set(self, "data_protection_backup_policy", value)

    @_builtins.property
    @pulumi.getter(name="dataProtectionReplication")
    def data_protection_replication(self) -> Optional[pulumi.Input['VolumeDataProtectionReplicationArgs']]:
        """
        A `data_protection_replication` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_protection_replication")

    @data_protection_replication.setter
    def data_protection_replication(self, value: Optional[pulumi.Input['VolumeDataProtectionReplicationArgs']]):
        pulumi.set(self, "data_protection_replication", value)

    @_builtins.property
    @pulumi.getter(name="dataProtectionSnapshotPolicy")
    def data_protection_snapshot_policy(self) -> Optional[pulumi.Input['VolumeDataProtectionSnapshotPolicyArgs']]:
        """
        A `data_protection_snapshot_policy` block as defined below.
        """
        return pulumi.get(self, "data_protection_snapshot_policy")

    @data_protection_snapshot_policy.setter
    def data_protection_snapshot_policy(self, value: Optional[pulumi.Input['VolumeDataProtectionSnapshotPolicyArgs']]):
        pulumi.set(self, "data_protection_snapshot_policy", value)

    @_builtins.property
    @pulumi.getter(name="encryptionKeySource")
    def encryption_key_source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The encryption key source, it can be `Microsoft.NetApp` for platform managed keys or `Microsoft.KeyVault` for customer-managed keys. This is required with `key_vault_private_endpoint_id`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_key_source")

    @encryption_key_source.setter
    def encryption_key_source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_key_source", value)

    @_builtins.property
    @pulumi.getter(name="exportPolicyRules")
    def export_policy_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeExportPolicyRuleArgs']]]]:
        """
        One or more `export_policy_rule` block defined below.
        """
        return pulumi.get(self, "export_policy_rules")

    @export_policy_rules.setter
    def export_policy_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeExportPolicyRuleArgs']]]]):
        pulumi.set(self, "export_policy_rules", value)

    @_builtins.property
    @pulumi.getter(name="kerberosEnabled")
    def kerberos_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable to allow Kerberos secured volumes. Requires appropriate export rules as well as the parent `netapp.Account` having a defined AD connection.
        """
        return pulumi.get(self, "kerberos_enabled")

    @kerberos_enabled.setter
    def kerberos_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "kerberos_enabled", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultPrivateEndpointId")
    def key_vault_private_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Private Endpoint ID for Key Vault, which is required when using customer-managed keys. This is required with `encryption_key_source`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_private_endpoint_id")

    @key_vault_private_endpoint_id.setter
    def key_vault_private_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_private_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="largeVolumeEnabled")
    def large_volume_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean specifying if the volume is a large volume. Defaults to `false`.

        > **Note:** Large volumes must be at least 50 TiB in size and can be up to 1,024 TiB (1 PiB). For more information, please refer to [Requirements and considerations for large volumes](https://learn.microsoft.com/en-us/azure/azure-netapp-files/large-volumes-requirements-considerations)
        """
        return pulumi.get(self, "large_volume_enabled")

    @large_volume_enabled.setter
    def large_volume_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "large_volume_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="mountIpAddresses")
    def mount_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IPv4 Addresses which should be used to mount the volume.
        """
        return pulumi.get(self, "mount_ip_addresses")

    @mount_ip_addresses.setter
    def mount_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "mount_ip_addresses", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the NetApp Volume. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkFeatures")
    def network_features(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates which network feature to use, accepted values are `Basic` or `Standard`, it defaults to `Basic` if not defined. This is a feature in public preview and for more information about it and how to register, please refer to [Configure network features for an Azure NetApp Files volume](https://docs.microsoft.com/en-us/azure/azure-netapp-files/configure-network-features).
        """
        return pulumi.get(self, "network_features")

    @network_features.setter
    def network_features(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_features", value)

    @_builtins.property
    @pulumi.getter(name="poolName")
    def pool_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the NetApp pool in which the NetApp Volume should be created.
        """
        return pulumi.get(self, "pool_name")

    @pool_name.setter
    def pool_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pool_name", value)

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The target volume protocol expressed as a list. Supported single value include `CIFS`, `NFSv3`, or `NFSv4.1`. If argument is not defined it will default to `NFSv3`. Changing this forces a new resource to be created and data will be lost. Dual protocol scenario is supported for CIFS and NFSv3, for more information, please refer to [Create a dual-protocol volume for Azure NetApp Files](https://docs.microsoft.com/azure/azure-netapp-files/create-volumes-dual-protocol) document.
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "protocols", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group where the NetApp Volume should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="securityStyle")
    def security_style(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Volume security style, accepted values are `unix` or `ntfs`. If not provided, single-protocol volume is created defaulting to `unix` if it is `NFSv3` or `NFSv4.1` volume, if `CIFS`, it will default to `ntfs`. In a dual-protocol volume, if not provided, its value will be `ntfs`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "security_style")

    @security_style.setter
    def security_style(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_style", value)

    @_builtins.property
    @pulumi.getter(name="serviceLevel")
    def service_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "service_level")

    @service_level.setter
    def service_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_level", value)

    @_builtins.property
    @pulumi.getter(name="smb3ProtocolEncryptionEnabled")
    def smb3_protocol_encryption_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable SMB encryption. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "smb3_protocol_encryption_enabled")

    @smb3_protocol_encryption_enabled.setter
    def smb3_protocol_encryption_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "smb3_protocol_encryption_enabled", value)

    @_builtins.property
    @pulumi.getter(name="smbAccessBasedEnumerationEnabled")
    def smb_access_based_enumeration_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Limits enumeration of files and folders (that is, listing the contents) in SMB only to users with allowed access on the share. For instance, if a user doesn't have access to read a file or folder in a share with access-based enumeration enabled, then the file or folder doesn't show up in directory listings. Defaults to `false`. For more information, please refer to [Understand NAS share permissions in Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/network-attached-storage-permissions#:~:text=security%20for%20administrators.-,Access%2Dbased%20enumeration,in%20an%20Azure%20NetApp%20Files%20SMB%20volume.%20Only%20contosoadmin%20has%20access.,-In%20the%20below)
        """
        return pulumi.get(self, "smb_access_based_enumeration_enabled")

    @smb_access_based_enumeration_enabled.setter
    def smb_access_based_enumeration_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "smb_access_based_enumeration_enabled", value)

    @_builtins.property
    @pulumi.getter(name="smbContinuousAvailabilityEnabled")
    def smb_continuous_availability_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable SMB Continuous Availability. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "smb_continuous_availability_enabled")

    @smb_continuous_availability_enabled.setter
    def smb_continuous_availability_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "smb_continuous_availability_enabled", value)

    @_builtins.property
    @pulumi.getter(name="smbNonBrowsableEnabled")
    def smb_non_browsable_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Limits clients from browsing for an SMB share by hiding the share from view in Windows Explorer or when listing shares in "net view." Only end users that know the absolute paths to the share are able to find the share. Defaults to `false`. For more information, please refer to [Understand NAS share permissions in Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/network-attached-storage-permissions#:~:text=Non%2Dbrowsable%20shares,find%20the%20share.)
        """
        return pulumi.get(self, "smb_non_browsable_enabled")

    @smb_non_browsable_enabled.setter
    def smb_non_browsable_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "smb_non_browsable_enabled", value)

    @_builtins.property
    @pulumi.getter(name="snapshotDirectoryVisible")
    def snapshot_directory_visible(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the .snapshot (NFS clients) or ~snapshot (SMB clients) path of a volume is visible. Defaults to `true`.
        """
        return pulumi.get(self, "snapshot_directory_visible")

    @snapshot_directory_visible.setter
    def snapshot_directory_visible(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "snapshot_directory_visible", value)

    @_builtins.property
    @pulumi.getter(name="storageQuotaInGb")
    def storage_quota_in_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum Storage Quota allowed for a file system in Gigabytes.
        """
        return pulumi.get(self, "storage_quota_in_gb")

    @storage_quota_in_gb.setter
    def storage_quota_in_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_quota_in_gb", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Subnet the NetApp Volume resides in, which must have the `Microsoft.NetApp/volumes` delegation. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.

        > **Note:** It is highly recommended to use the **lifecycle** property as noted in the example since it will prevent an accidental deletion of the volume if the `protocols` argument changes to a different protocol type.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="throughputInMibps")
    def throughput_in_mibps(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        Throughput of this volume in Mibps.
        """
        return pulumi.get(self, "throughput_in_mibps")

    @throughput_in_mibps.setter
    def throughput_in_mibps(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "throughput_in_mibps", value)

    @_builtins.property
    @pulumi.getter(name="volumePath")
    def volume_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique file path for the volume. Used when creating mount targets. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "volume_path")

    @volume_path.setter
    def volume_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_path", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Availability Zone in which the Volume should be located. Possible values are `1`, `2` and `3`. Changing this forces a new resource to be created. This feature is currently in preview, for more information on how to enable it, please refer to [Manage availability zone volume placement for Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/manage-availability-zone-volume-placement#register-the-feature).
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("azure:netapp/volume:Volume")
class Volume(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_vmware_data_store_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cool_access: Optional[pulumi.Input[Union['VolumeCoolAccessArgs', 'VolumeCoolAccessArgsDict']]] = None,
                 create_from_snapshot_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_protection_backup_policy: Optional[pulumi.Input[Union['VolumeDataProtectionBackupPolicyArgs', 'VolumeDataProtectionBackupPolicyArgsDict']]] = None,
                 data_protection_replication: Optional[pulumi.Input[Union['VolumeDataProtectionReplicationArgs', 'VolumeDataProtectionReplicationArgsDict']]] = None,
                 data_protection_snapshot_policy: Optional[pulumi.Input[Union['VolumeDataProtectionSnapshotPolicyArgs', 'VolumeDataProtectionSnapshotPolicyArgsDict']]] = None,
                 encryption_key_source: Optional[pulumi.Input[_builtins.str]] = None,
                 export_policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeExportPolicyRuleArgs', 'VolumeExportPolicyRuleArgsDict']]]]] = None,
                 kerberos_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_vault_private_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 large_volume_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_features: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_style: Optional[pulumi.Input[_builtins.str]] = None,
                 service_level: Optional[pulumi.Input[_builtins.str]] = None,
                 smb3_protocol_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 smb_access_based_enumeration_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 smb_continuous_availability_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 smb_non_browsable_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 snapshot_directory_visible: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_quota_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 throughput_in_mibps: Optional[pulumi.Input[_builtins.float]] = None,
                 volume_path: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a NetApp Volume.

        !> **Note:** This resource uses a feature to prevent deletion called `prevent_volume_destruction`, defaulting to `true`. It is intentionally set to `true` to prevent the possibility of accidental data loss. The example in this page shows all possible protection options you can apply, it is using same values as the defaults.

        ## Import

        NetApp Volumes can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:netapp/volume:Volume example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1/volumes/volume1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_name: The name of the NetApp account in which the NetApp Pool should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] azure_vmware_data_store_enabled: Is the NetApp Volume enabled for Azure VMware Solution (AVS) datastore purpose. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['VolumeCoolAccessArgs', 'VolumeCoolAccessArgsDict']] cool_access: A `cool_access` block as defined below.
        :param pulumi.Input[_builtins.str] create_from_snapshot_resource_id: Creates volume from snapshot. Following properties must be the same as the original volume where the snapshot was taken from: `protocols`, `subnet_id`, `location`, `service_level`, `resource_group_name` and `account_name`. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['VolumeDataProtectionBackupPolicyArgs', 'VolumeDataProtectionBackupPolicyArgsDict']] data_protection_backup_policy: A `data_protection_backup_policy` block as defined below.
        :param pulumi.Input[Union['VolumeDataProtectionReplicationArgs', 'VolumeDataProtectionReplicationArgsDict']] data_protection_replication: A `data_protection_replication` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['VolumeDataProtectionSnapshotPolicyArgs', 'VolumeDataProtectionSnapshotPolicyArgsDict']] data_protection_snapshot_policy: A `data_protection_snapshot_policy` block as defined below.
        :param pulumi.Input[_builtins.str] encryption_key_source: The encryption key source, it can be `Microsoft.NetApp` for platform managed keys or `Microsoft.KeyVault` for customer-managed keys. This is required with `key_vault_private_endpoint_id`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeExportPolicyRuleArgs', 'VolumeExportPolicyRuleArgsDict']]]] export_policy_rules: One or more `export_policy_rule` block defined below.
        :param pulumi.Input[_builtins.bool] kerberos_enabled: Enable to allow Kerberos secured volumes. Requires appropriate export rules as well as the parent `netapp.Account` having a defined AD connection.
        :param pulumi.Input[_builtins.str] key_vault_private_endpoint_id: The Private Endpoint ID for Key Vault, which is required when using customer-managed keys. This is required with `encryption_key_source`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] large_volume_enabled: A boolean specifying if the volume is a large volume. Defaults to `false`.
               
               > **Note:** Large volumes must be at least 50 TiB in size and can be up to 1,024 TiB (1 PiB). For more information, please refer to [Requirements and considerations for large volumes](https://learn.microsoft.com/en-us/azure/azure-netapp-files/large-volumes-requirements-considerations)
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the NetApp Volume. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] network_features: Indicates which network feature to use, accepted values are `Basic` or `Standard`, it defaults to `Basic` if not defined. This is a feature in public preview and for more information about it and how to register, please refer to [Configure network features for an Azure NetApp Files volume](https://docs.microsoft.com/en-us/azure/azure-netapp-files/configure-network-features).
        :param pulumi.Input[_builtins.str] pool_name: The name of the NetApp pool in which the NetApp Volume should be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protocols: The target volume protocol expressed as a list. Supported single value include `CIFS`, `NFSv3`, or `NFSv4.1`. If argument is not defined it will default to `NFSv3`. Changing this forces a new resource to be created and data will be lost. Dual protocol scenario is supported for CIFS and NFSv3, for more information, please refer to [Create a dual-protocol volume for Azure NetApp Files](https://docs.microsoft.com/azure/azure-netapp-files/create-volumes-dual-protocol) document.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group where the NetApp Volume should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] security_style: Volume security style, accepted values are `unix` or `ntfs`. If not provided, single-protocol volume is created defaulting to `unix` if it is `NFSv3` or `NFSv4.1` volume, if `CIFS`, it will default to `ntfs`. In a dual-protocol volume, if not provided, its value will be `ntfs`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] smb3_protocol_encryption_enabled: Enable SMB encryption. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] smb_access_based_enumeration_enabled: Limits enumeration of files and folders (that is, listing the contents) in SMB only to users with allowed access on the share. For instance, if a user doesn't have access to read a file or folder in a share with access-based enumeration enabled, then the file or folder doesn't show up in directory listings. Defaults to `false`. For more information, please refer to [Understand NAS share permissions in Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/network-attached-storage-permissions#:~:text=security%20for%20administrators.-,Access%2Dbased%20enumeration,in%20an%20Azure%20NetApp%20Files%20SMB%20volume.%20Only%20contosoadmin%20has%20access.,-In%20the%20below)
        :param pulumi.Input[_builtins.bool] smb_continuous_availability_enabled: Enable SMB Continuous Availability. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] smb_non_browsable_enabled: Limits clients from browsing for an SMB share by hiding the share from view in Windows Explorer or when listing shares in "net view." Only end users that know the absolute paths to the share are able to find the share. Defaults to `false`. For more information, please refer to [Understand NAS share permissions in Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/network-attached-storage-permissions#:~:text=Non%2Dbrowsable%20shares,find%20the%20share.)
        :param pulumi.Input[_builtins.bool] snapshot_directory_visible: Specifies whether the .snapshot (NFS clients) or ~snapshot (SMB clients) path of a volume is visible. Defaults to `true`.
        :param pulumi.Input[_builtins.int] storage_quota_in_gb: The maximum Storage Quota allowed for a file system in Gigabytes.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet the NetApp Volume resides in, which must have the `Microsoft.NetApp/volumes` delegation. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               
               > **Note:** It is highly recommended to use the **lifecycle** property as noted in the example since it will prevent an accidental deletion of the volume if the `protocols` argument changes to a different protocol type.
        :param pulumi.Input[_builtins.float] throughput_in_mibps: Throughput of this volume in Mibps.
        :param pulumi.Input[_builtins.str] volume_path: A unique file path for the volume. Used when creating mount targets. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] zone: Specifies the Availability Zone in which the Volume should be located. Possible values are `1`, `2` and `3`. Changing this forces a new resource to be created. This feature is currently in preview, for more information on how to enable it, please refer to [Manage availability zone volume placement for Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/manage-availability-zone-volume-placement#register-the-feature).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a NetApp Volume.

        !> **Note:** This resource uses a feature to prevent deletion called `prevent_volume_destruction`, defaulting to `true`. It is intentionally set to `true` to prevent the possibility of accidental data loss. The example in this page shows all possible protection options you can apply, it is using same values as the defaults.

        ## Import

        NetApp Volumes can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:netapp/volume:Volume example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.NetApp/netAppAccounts/account1/capacityPools/pool1/volumes/volume1
        ```

        :param str resource_name: The name of the resource.
        :param VolumeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 azure_vmware_data_store_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cool_access: Optional[pulumi.Input[Union['VolumeCoolAccessArgs', 'VolumeCoolAccessArgsDict']]] = None,
                 create_from_snapshot_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_protection_backup_policy: Optional[pulumi.Input[Union['VolumeDataProtectionBackupPolicyArgs', 'VolumeDataProtectionBackupPolicyArgsDict']]] = None,
                 data_protection_replication: Optional[pulumi.Input[Union['VolumeDataProtectionReplicationArgs', 'VolumeDataProtectionReplicationArgsDict']]] = None,
                 data_protection_snapshot_policy: Optional[pulumi.Input[Union['VolumeDataProtectionSnapshotPolicyArgs', 'VolumeDataProtectionSnapshotPolicyArgsDict']]] = None,
                 encryption_key_source: Optional[pulumi.Input[_builtins.str]] = None,
                 export_policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeExportPolicyRuleArgs', 'VolumeExportPolicyRuleArgsDict']]]]] = None,
                 kerberos_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_vault_private_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 large_volume_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_features: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 security_style: Optional[pulumi.Input[_builtins.str]] = None,
                 service_level: Optional[pulumi.Input[_builtins.str]] = None,
                 smb3_protocol_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 smb_access_based_enumeration_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 smb_continuous_availability_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 smb_non_browsable_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 snapshot_directory_visible: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_quota_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 throughput_in_mibps: Optional[pulumi.Input[_builtins.float]] = None,
                 volume_path: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeArgs.__new__(VolumeArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            __props__.__dict__["azure_vmware_data_store_enabled"] = azure_vmware_data_store_enabled
            __props__.__dict__["cool_access"] = cool_access
            __props__.__dict__["create_from_snapshot_resource_id"] = create_from_snapshot_resource_id
            __props__.__dict__["data_protection_backup_policy"] = data_protection_backup_policy
            __props__.__dict__["data_protection_replication"] = data_protection_replication
            __props__.__dict__["data_protection_snapshot_policy"] = data_protection_snapshot_policy
            __props__.__dict__["encryption_key_source"] = encryption_key_source
            __props__.__dict__["export_policy_rules"] = export_policy_rules
            __props__.__dict__["kerberos_enabled"] = kerberos_enabled
            __props__.__dict__["key_vault_private_endpoint_id"] = key_vault_private_endpoint_id
            __props__.__dict__["large_volume_enabled"] = large_volume_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["network_features"] = network_features
            if pool_name is None and not opts.urn:
                raise TypeError("Missing required property 'pool_name'")
            __props__.__dict__["pool_name"] = pool_name
            __props__.__dict__["protocols"] = protocols
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["security_style"] = security_style
            if service_level is None and not opts.urn:
                raise TypeError("Missing required property 'service_level'")
            __props__.__dict__["service_level"] = service_level
            __props__.__dict__["smb3_protocol_encryption_enabled"] = smb3_protocol_encryption_enabled
            __props__.__dict__["smb_access_based_enumeration_enabled"] = smb_access_based_enumeration_enabled
            __props__.__dict__["smb_continuous_availability_enabled"] = smb_continuous_availability_enabled
            __props__.__dict__["smb_non_browsable_enabled"] = smb_non_browsable_enabled
            __props__.__dict__["snapshot_directory_visible"] = snapshot_directory_visible
            if storage_quota_in_gb is None and not opts.urn:
                raise TypeError("Missing required property 'storage_quota_in_gb'")
            __props__.__dict__["storage_quota_in_gb"] = storage_quota_in_gb
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["throughput_in_mibps"] = throughput_in_mibps
            if volume_path is None and not opts.urn:
                raise TypeError("Missing required property 'volume_path'")
            __props__.__dict__["volume_path"] = volume_path
            __props__.__dict__["zone"] = zone
            __props__.__dict__["mount_ip_addresses"] = None
        super(Volume, __self__).__init__(
            'azure:netapp/volume:Volume',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[_builtins.str]] = None,
            azure_vmware_data_store_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            cool_access: Optional[pulumi.Input[Union['VolumeCoolAccessArgs', 'VolumeCoolAccessArgsDict']]] = None,
            create_from_snapshot_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            data_protection_backup_policy: Optional[pulumi.Input[Union['VolumeDataProtectionBackupPolicyArgs', 'VolumeDataProtectionBackupPolicyArgsDict']]] = None,
            data_protection_replication: Optional[pulumi.Input[Union['VolumeDataProtectionReplicationArgs', 'VolumeDataProtectionReplicationArgsDict']]] = None,
            data_protection_snapshot_policy: Optional[pulumi.Input[Union['VolumeDataProtectionSnapshotPolicyArgs', 'VolumeDataProtectionSnapshotPolicyArgsDict']]] = None,
            encryption_key_source: Optional[pulumi.Input[_builtins.str]] = None,
            export_policy_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeExportPolicyRuleArgs', 'VolumeExportPolicyRuleArgsDict']]]]] = None,
            kerberos_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            key_vault_private_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            large_volume_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            mount_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_features: Optional[pulumi.Input[_builtins.str]] = None,
            pool_name: Optional[pulumi.Input[_builtins.str]] = None,
            protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            security_style: Optional[pulumi.Input[_builtins.str]] = None,
            service_level: Optional[pulumi.Input[_builtins.str]] = None,
            smb3_protocol_encryption_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            smb_access_based_enumeration_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            smb_continuous_availability_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            smb_non_browsable_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            snapshot_directory_visible: Optional[pulumi.Input[_builtins.bool]] = None,
            storage_quota_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            throughput_in_mibps: Optional[pulumi.Input[_builtins.float]] = None,
            volume_path: Optional[pulumi.Input[_builtins.str]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'Volume':
        """
        Get an existing Volume resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_name: The name of the NetApp account in which the NetApp Pool should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] azure_vmware_data_store_enabled: Is the NetApp Volume enabled for Azure VMware Solution (AVS) datastore purpose. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['VolumeCoolAccessArgs', 'VolumeCoolAccessArgsDict']] cool_access: A `cool_access` block as defined below.
        :param pulumi.Input[_builtins.str] create_from_snapshot_resource_id: Creates volume from snapshot. Following properties must be the same as the original volume where the snapshot was taken from: `protocols`, `subnet_id`, `location`, `service_level`, `resource_group_name` and `account_name`. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['VolumeDataProtectionBackupPolicyArgs', 'VolumeDataProtectionBackupPolicyArgsDict']] data_protection_backup_policy: A `data_protection_backup_policy` block as defined below.
        :param pulumi.Input[Union['VolumeDataProtectionReplicationArgs', 'VolumeDataProtectionReplicationArgsDict']] data_protection_replication: A `data_protection_replication` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['VolumeDataProtectionSnapshotPolicyArgs', 'VolumeDataProtectionSnapshotPolicyArgsDict']] data_protection_snapshot_policy: A `data_protection_snapshot_policy` block as defined below.
        :param pulumi.Input[_builtins.str] encryption_key_source: The encryption key source, it can be `Microsoft.NetApp` for platform managed keys or `Microsoft.KeyVault` for customer-managed keys. This is required with `key_vault_private_endpoint_id`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeExportPolicyRuleArgs', 'VolumeExportPolicyRuleArgsDict']]]] export_policy_rules: One or more `export_policy_rule` block defined below.
        :param pulumi.Input[_builtins.bool] kerberos_enabled: Enable to allow Kerberos secured volumes. Requires appropriate export rules as well as the parent `netapp.Account` having a defined AD connection.
        :param pulumi.Input[_builtins.str] key_vault_private_endpoint_id: The Private Endpoint ID for Key Vault, which is required when using customer-managed keys. This is required with `encryption_key_source`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] large_volume_enabled: A boolean specifying if the volume is a large volume. Defaults to `false`.
               
               > **Note:** Large volumes must be at least 50 TiB in size and can be up to 1,024 TiB (1 PiB). For more information, please refer to [Requirements and considerations for large volumes](https://learn.microsoft.com/en-us/azure/azure-netapp-files/large-volumes-requirements-considerations)
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] mount_ip_addresses: A list of IPv4 Addresses which should be used to mount the volume.
        :param pulumi.Input[_builtins.str] name: The name of the NetApp Volume. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] network_features: Indicates which network feature to use, accepted values are `Basic` or `Standard`, it defaults to `Basic` if not defined. This is a feature in public preview and for more information about it and how to register, please refer to [Configure network features for an Azure NetApp Files volume](https://docs.microsoft.com/en-us/azure/azure-netapp-files/configure-network-features).
        :param pulumi.Input[_builtins.str] pool_name: The name of the NetApp pool in which the NetApp Volume should be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protocols: The target volume protocol expressed as a list. Supported single value include `CIFS`, `NFSv3`, or `NFSv4.1`. If argument is not defined it will default to `NFSv3`. Changing this forces a new resource to be created and data will be lost. Dual protocol scenario is supported for CIFS and NFSv3, for more information, please refer to [Create a dual-protocol volume for Azure NetApp Files](https://docs.microsoft.com/azure/azure-netapp-files/create-volumes-dual-protocol) document.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group where the NetApp Volume should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] security_style: Volume security style, accepted values are `unix` or `ntfs`. If not provided, single-protocol volume is created defaulting to `unix` if it is `NFSv3` or `NFSv4.1` volume, if `CIFS`, it will default to `ntfs`. In a dual-protocol volume, if not provided, its value will be `ntfs`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] smb3_protocol_encryption_enabled: Enable SMB encryption. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] smb_access_based_enumeration_enabled: Limits enumeration of files and folders (that is, listing the contents) in SMB only to users with allowed access on the share. For instance, if a user doesn't have access to read a file or folder in a share with access-based enumeration enabled, then the file or folder doesn't show up in directory listings. Defaults to `false`. For more information, please refer to [Understand NAS share permissions in Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/network-attached-storage-permissions#:~:text=security%20for%20administrators.-,Access%2Dbased%20enumeration,in%20an%20Azure%20NetApp%20Files%20SMB%20volume.%20Only%20contosoadmin%20has%20access.,-In%20the%20below)
        :param pulumi.Input[_builtins.bool] smb_continuous_availability_enabled: Enable SMB Continuous Availability. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] smb_non_browsable_enabled: Limits clients from browsing for an SMB share by hiding the share from view in Windows Explorer or when listing shares in "net view." Only end users that know the absolute paths to the share are able to find the share. Defaults to `false`. For more information, please refer to [Understand NAS share permissions in Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/network-attached-storage-permissions#:~:text=Non%2Dbrowsable%20shares,find%20the%20share.)
        :param pulumi.Input[_builtins.bool] snapshot_directory_visible: Specifies whether the .snapshot (NFS clients) or ~snapshot (SMB clients) path of a volume is visible. Defaults to `true`.
        :param pulumi.Input[_builtins.int] storage_quota_in_gb: The maximum Storage Quota allowed for a file system in Gigabytes.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet the NetApp Volume resides in, which must have the `Microsoft.NetApp/volumes` delegation. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
               
               > **Note:** It is highly recommended to use the **lifecycle** property as noted in the example since it will prevent an accidental deletion of the volume if the `protocols` argument changes to a different protocol type.
        :param pulumi.Input[_builtins.float] throughput_in_mibps: Throughput of this volume in Mibps.
        :param pulumi.Input[_builtins.str] volume_path: A unique file path for the volume. Used when creating mount targets. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] zone: Specifies the Availability Zone in which the Volume should be located. Possible values are `1`, `2` and `3`. Changing this forces a new resource to be created. This feature is currently in preview, for more information on how to enable it, please refer to [Manage availability zone volume placement for Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/manage-availability-zone-volume-placement#register-the-feature).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeState.__new__(_VolumeState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["azure_vmware_data_store_enabled"] = azure_vmware_data_store_enabled
        __props__.__dict__["cool_access"] = cool_access
        __props__.__dict__["create_from_snapshot_resource_id"] = create_from_snapshot_resource_id
        __props__.__dict__["data_protection_backup_policy"] = data_protection_backup_policy
        __props__.__dict__["data_protection_replication"] = data_protection_replication
        __props__.__dict__["data_protection_snapshot_policy"] = data_protection_snapshot_policy
        __props__.__dict__["encryption_key_source"] = encryption_key_source
        __props__.__dict__["export_policy_rules"] = export_policy_rules
        __props__.__dict__["kerberos_enabled"] = kerberos_enabled
        __props__.__dict__["key_vault_private_endpoint_id"] = key_vault_private_endpoint_id
        __props__.__dict__["large_volume_enabled"] = large_volume_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["mount_ip_addresses"] = mount_ip_addresses
        __props__.__dict__["name"] = name
        __props__.__dict__["network_features"] = network_features
        __props__.__dict__["pool_name"] = pool_name
        __props__.__dict__["protocols"] = protocols
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["security_style"] = security_style
        __props__.__dict__["service_level"] = service_level
        __props__.__dict__["smb3_protocol_encryption_enabled"] = smb3_protocol_encryption_enabled
        __props__.__dict__["smb_access_based_enumeration_enabled"] = smb_access_based_enumeration_enabled
        __props__.__dict__["smb_continuous_availability_enabled"] = smb_continuous_availability_enabled
        __props__.__dict__["smb_non_browsable_enabled"] = smb_non_browsable_enabled
        __props__.__dict__["snapshot_directory_visible"] = snapshot_directory_visible
        __props__.__dict__["storage_quota_in_gb"] = storage_quota_in_gb
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["throughput_in_mibps"] = throughput_in_mibps
        __props__.__dict__["volume_path"] = volume_path
        __props__.__dict__["zone"] = zone
        return Volume(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the NetApp account in which the NetApp Pool should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="azureVmwareDataStoreEnabled")
    def azure_vmware_data_store_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is the NetApp Volume enabled for Azure VMware Solution (AVS) datastore purpose. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "azure_vmware_data_store_enabled")

    @_builtins.property
    @pulumi.getter(name="coolAccess")
    def cool_access(self) -> pulumi.Output[Optional['outputs.VolumeCoolAccess']]:
        """
        A `cool_access` block as defined below.
        """
        return pulumi.get(self, "cool_access")

    @_builtins.property
    @pulumi.getter(name="createFromSnapshotResourceId")
    def create_from_snapshot_resource_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Creates volume from snapshot. Following properties must be the same as the original volume where the snapshot was taken from: `protocols`, `subnet_id`, `location`, `service_level`, `resource_group_name` and `account_name`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "create_from_snapshot_resource_id")

    @_builtins.property
    @pulumi.getter(name="dataProtectionBackupPolicy")
    def data_protection_backup_policy(self) -> pulumi.Output[Optional['outputs.VolumeDataProtectionBackupPolicy']]:
        """
        A `data_protection_backup_policy` block as defined below.
        """
        return pulumi.get(self, "data_protection_backup_policy")

    @_builtins.property
    @pulumi.getter(name="dataProtectionReplication")
    def data_protection_replication(self) -> pulumi.Output[Optional['outputs.VolumeDataProtectionReplication']]:
        """
        A `data_protection_replication` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_protection_replication")

    @_builtins.property
    @pulumi.getter(name="dataProtectionSnapshotPolicy")
    def data_protection_snapshot_policy(self) -> pulumi.Output[Optional['outputs.VolumeDataProtectionSnapshotPolicy']]:
        """
        A `data_protection_snapshot_policy` block as defined below.
        """
        return pulumi.get(self, "data_protection_snapshot_policy")

    @_builtins.property
    @pulumi.getter(name="encryptionKeySource")
    def encryption_key_source(self) -> pulumi.Output[_builtins.str]:
        """
        The encryption key source, it can be `Microsoft.NetApp` for platform managed keys or `Microsoft.KeyVault` for customer-managed keys. This is required with `key_vault_private_endpoint_id`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_key_source")

    @_builtins.property
    @pulumi.getter(name="exportPolicyRules")
    def export_policy_rules(self) -> pulumi.Output[Optional[Sequence['outputs.VolumeExportPolicyRule']]]:
        """
        One or more `export_policy_rule` block defined below.
        """
        return pulumi.get(self, "export_policy_rules")

    @_builtins.property
    @pulumi.getter(name="kerberosEnabled")
    def kerberos_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable to allow Kerberos secured volumes. Requires appropriate export rules as well as the parent `netapp.Account` having a defined AD connection.
        """
        return pulumi.get(self, "kerberos_enabled")

    @_builtins.property
    @pulumi.getter(name="keyVaultPrivateEndpointId")
    def key_vault_private_endpoint_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Private Endpoint ID for Key Vault, which is required when using customer-managed keys. This is required with `encryption_key_source`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_private_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="largeVolumeEnabled")
    def large_volume_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A boolean specifying if the volume is a large volume. Defaults to `false`.

        > **Note:** Large volumes must be at least 50 TiB in size and can be up to 1,024 TiB (1 PiB). For more information, please refer to [Requirements and considerations for large volumes](https://learn.microsoft.com/en-us/azure/azure-netapp-files/large-volumes-requirements-considerations)
        """
        return pulumi.get(self, "large_volume_enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="mountIpAddresses")
    def mount_ip_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of IPv4 Addresses which should be used to mount the volume.
        """
        return pulumi.get(self, "mount_ip_addresses")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the NetApp Volume. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkFeatures")
    def network_features(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates which network feature to use, accepted values are `Basic` or `Standard`, it defaults to `Basic` if not defined. This is a feature in public preview and for more information about it and how to register, please refer to [Configure network features for an Azure NetApp Files volume](https://docs.microsoft.com/en-us/azure/azure-netapp-files/configure-network-features).
        """
        return pulumi.get(self, "network_features")

    @_builtins.property
    @pulumi.getter(name="poolName")
    def pool_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the NetApp pool in which the NetApp Volume should be created.
        """
        return pulumi.get(self, "pool_name")

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The target volume protocol expressed as a list. Supported single value include `CIFS`, `NFSv3`, or `NFSv4.1`. If argument is not defined it will default to `NFSv3`. Changing this forces a new resource to be created and data will be lost. Dual protocol scenario is supported for CIFS and NFSv3, for more information, please refer to [Create a dual-protocol volume for Azure NetApp Files](https://docs.microsoft.com/azure/azure-netapp-files/create-volumes-dual-protocol) document.
        """
        return pulumi.get(self, "protocols")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group where the NetApp Volume should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="securityStyle")
    def security_style(self) -> pulumi.Output[_builtins.str]:
        """
        Volume security style, accepted values are `unix` or `ntfs`. If not provided, single-protocol volume is created defaulting to `unix` if it is `NFSv3` or `NFSv4.1` volume, if `CIFS`, it will default to `ntfs`. In a dual-protocol volume, if not provided, its value will be `ntfs`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "security_style")

    @_builtins.property
    @pulumi.getter(name="serviceLevel")
    def service_level(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "service_level")

    @_builtins.property
    @pulumi.getter(name="smb3ProtocolEncryptionEnabled")
    def smb3_protocol_encryption_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable SMB encryption. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "smb3_protocol_encryption_enabled")

    @_builtins.property
    @pulumi.getter(name="smbAccessBasedEnumerationEnabled")
    def smb_access_based_enumeration_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Limits enumeration of files and folders (that is, listing the contents) in SMB only to users with allowed access on the share. For instance, if a user doesn't have access to read a file or folder in a share with access-based enumeration enabled, then the file or folder doesn't show up in directory listings. Defaults to `false`. For more information, please refer to [Understand NAS share permissions in Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/network-attached-storage-permissions#:~:text=security%20for%20administrators.-,Access%2Dbased%20enumeration,in%20an%20Azure%20NetApp%20Files%20SMB%20volume.%20Only%20contosoadmin%20has%20access.,-In%20the%20below)
        """
        return pulumi.get(self, "smb_access_based_enumeration_enabled")

    @_builtins.property
    @pulumi.getter(name="smbContinuousAvailabilityEnabled")
    def smb_continuous_availability_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable SMB Continuous Availability. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "smb_continuous_availability_enabled")

    @_builtins.property
    @pulumi.getter(name="smbNonBrowsableEnabled")
    def smb_non_browsable_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Limits clients from browsing for an SMB share by hiding the share from view in Windows Explorer or when listing shares in "net view." Only end users that know the absolute paths to the share are able to find the share. Defaults to `false`. For more information, please refer to [Understand NAS share permissions in Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/network-attached-storage-permissions#:~:text=Non%2Dbrowsable%20shares,find%20the%20share.)
        """
        return pulumi.get(self, "smb_non_browsable_enabled")

    @_builtins.property
    @pulumi.getter(name="snapshotDirectoryVisible")
    def snapshot_directory_visible(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the .snapshot (NFS clients) or ~snapshot (SMB clients) path of a volume is visible. Defaults to `true`.
        """
        return pulumi.get(self, "snapshot_directory_visible")

    @_builtins.property
    @pulumi.getter(name="storageQuotaInGb")
    def storage_quota_in_gb(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum Storage Quota allowed for a file system in Gigabytes.
        """
        return pulumi.get(self, "storage_quota_in_gb")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Subnet the NetApp Volume resides in, which must have the `Microsoft.NetApp/volumes` delegation. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.

        > **Note:** It is highly recommended to use the **lifecycle** property as noted in the example since it will prevent an accidental deletion of the volume if the `protocols` argument changes to a different protocol type.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="throughputInMibps")
    def throughput_in_mibps(self) -> pulumi.Output[_builtins.float]:
        """
        Throughput of this volume in Mibps.
        """
        return pulumi.get(self, "throughput_in_mibps")

    @_builtins.property
    @pulumi.getter(name="volumePath")
    def volume_path(self) -> pulumi.Output[_builtins.str]:
        """
        A unique file path for the volume. Used when creating mount targets. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "volume_path")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Availability Zone in which the Volume should be located. Possible values are `1`, `2` and `3`. Changing this forces a new resource to be created. This feature is currently in preview, for more information on how to enable it, please refer to [Manage availability zone volume placement for Azure NetApp Files](https://learn.microsoft.com/en-us/azure/azure-netapp-files/manage-availability-zone-volume-placement#register-the-feature).
        """
        return pulumi.get(self, "zone")

