# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VolumeGroupOracleArgs', 'VolumeGroupOracle']

@pulumi.input_type
class VolumeGroupOracleArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[_builtins.str],
                 application_identifier: pulumi.Input[_builtins.str],
                 group_description: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 volumes: pulumi.Input[Sequence[pulumi.Input['VolumeGroupOracleVolumeArgs']]],
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a VolumeGroupOracle resource.
        :param pulumi.Input[_builtins.str] account_name: Name of the account where the application volume group belong to. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[_builtins.str] application_identifier: The SAP System ID, maximum 3 characters, e.g. `OR1`. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[_builtins.str] group_description: Volume group description. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeGroupOracleVolumeArgs']]] volumes: One or more `volume` blocks as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Application Volume Group. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "application_identifier", application_identifier)
        pulumi.set(__self__, "group_description", group_description)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "volumes", volumes)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the account where the application volume group belong to. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="applicationIdentifier")
    def application_identifier(self) -> pulumi.Input[_builtins.str]:
        """
        The SAP System ID, maximum 3 characters, e.g. `OR1`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "application_identifier")

    @application_identifier.setter
    def application_identifier(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "application_identifier", value)

    @_builtins.property
    @pulumi.getter(name="groupDescription")
    def group_description(self) -> pulumi.Input[_builtins.str]:
        """
        Volume group description. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "group_description")

    @group_description.setter
    def group_description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_description", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> pulumi.Input[Sequence[pulumi.Input['VolumeGroupOracleVolumeArgs']]]:
        """
        One or more `volume` blocks as defined below.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: pulumi.Input[Sequence[pulumi.Input['VolumeGroupOracleVolumeArgs']]]):
        pulumi.set(self, "volumes", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Application Volume Group. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _VolumeGroupOracleState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 application_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 group_description: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupOracleVolumeArgs']]]] = None):
        """
        Input properties used for looking up and filtering VolumeGroupOracle resources.
        :param pulumi.Input[_builtins.str] account_name: Name of the account where the application volume group belong to. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[_builtins.str] application_identifier: The SAP System ID, maximum 3 characters, e.g. `OR1`. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[_builtins.str] group_description: Volume group description. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Application Volume Group. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[Sequence[pulumi.Input['VolumeGroupOracleVolumeArgs']]] volumes: One or more `volume` blocks as defined below.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if application_identifier is not None:
            pulumi.set(__self__, "application_identifier", application_identifier)
        if group_description is not None:
            pulumi.set(__self__, "group_description", group_description)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the account where the application volume group belong to. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter(name="applicationIdentifier")
    def application_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SAP System ID, maximum 3 characters, e.g. `OR1`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "application_identifier")

    @application_identifier.setter
    def application_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_identifier", value)

    @_builtins.property
    @pulumi.getter(name="groupDescription")
    def group_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Volume group description. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "group_description")

    @group_description.setter
    def group_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_description", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Application Volume Group. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupOracleVolumeArgs']]]]:
        """
        One or more `volume` blocks as defined below.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['VolumeGroupOracleVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


@pulumi.type_token("azure:netapp/volumeGroupOracle:VolumeGroupOracle")
class VolumeGroupOracle(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 application_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 group_description: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupOracleVolumeArgs', 'VolumeGroupOracleVolumeArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name=f"{prefix}-resources",
            location=location,
            tags={
                "SkipNRMSNSG": "true",
            })
        example_virtual_network = azure.network.VirtualNetwork("example",
            name=f"{prefix}-vnet",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.88.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name=f"{prefix}-delegated-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.88.2.0/24"],
            delegations=[{
                "name": "exampledelegation",
                "service_delegation": {
                    "name": "Microsoft.Netapp/volumes",
                    "actions": [
                        "Microsoft.Network/networkinterfaces/*",
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                    ],
                },
            }])
        example_account = azure.netapp.Account("example",
            name=f"{prefix}-netapp-account",
            location=example.location,
            resource_group_name=example.name,
            opts = pulumi.ResourceOptions(depends_on=[example_subnet]))
        example_pool = azure.netapp.Pool("example",
            name=f"{prefix}-netapp-pool",
            location=example.location,
            resource_group_name=example.name,
            account_name=example_account.name,
            service_level="Standard",
            size_in_tb=4,
            qos_type="Manual")
        example_volume_group_oracle = azure.netapp.VolumeGroupOracle("example",
            name=f"{prefix}-NetAppVolumeGroupOracle",
            location=example.location,
            resource_group_name=example.name,
            account_name=example_account.name,
            group_description="Example volume group for Oracle",
            application_identifier="TST",
            volumes=[
                {
                    "name": f"{prefix}-volume-ora1",
                    "volume_path": f"{prefix}-my-unique-file-ora-path-1",
                    "service_level": "Standard",
                    "capacity_pool_id": example_pool.id,
                    "subnet_id": example_subnet.id,
                    "zone": "1",
                    "volume_spec_name": "ora-data1",
                    "storage_quota_in_gb": 1024,
                    "throughput_in_mibps": 24,
                    "protocols": "NFSv4.1",
                    "security_style": "unix",
                    "snapshot_directory_visible": False,
                    "export_policy_rules": [{
                        "rule_index": 1,
                        "allowed_clients": "0.0.0.0/0",
                        "nfsv3_enabled": False,
                        "nfsv41_enabled": True,
                        "unix_read_only": False,
                        "unix_read_write": True,
                        "root_access_enabled": False,
                    }],
                },
                {
                    "name": f"{prefix}-volume-oraLog",
                    "volume_path": f"{prefix}-my-unique-file-oralog-path",
                    "service_level": "Standard",
                    "capacity_pool_id": example_pool.id,
                    "subnet_id": example_subnet.id,
                    "zone": "1",
                    "volume_spec_name": "ora-log",
                    "storage_quota_in_gb": 1024,
                    "throughput_in_mibps": 24,
                    "protocols": "NFSv4.1",
                    "security_style": "unix",
                    "snapshot_directory_visible": False,
                    "export_policy_rules": [{
                        "rule_index": 1,
                        "allowed_clients": "0.0.0.0/0",
                        "nfsv3_enabled": False,
                        "nfsv41_enabled": True,
                        "unix_read_only": False,
                        "unix_read_write": True,
                        "root_access_enabled": False,
                    }],
                },
            ])
        ```

        ### Cross-Region Replication

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name=f"{prefix}-resources",
            location=location,
            tags={
                "SkipNRMSNSG": "true",
            })
        # Primary region networking
        example_primary = azure.network.VirtualNetwork("example_primary",
            name=f"{prefix}-vnet-primary",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.47.0.0/16"])
        example_primary_subnet = azure.network.Subnet("example_primary",
            name=f"{prefix}-delegated-subnet-primary",
            resource_group_name=example.name,
            virtual_network_name=example_primary.name,
            address_prefixes=["10.47.2.0/24"],
            delegations=[{
                "name": "exampledelegation",
                "service_delegation": {
                    "name": "Microsoft.Netapp/volumes",
                    "actions": [
                        "Microsoft.Network/networkinterfaces/*",
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                    ],
                },
            }])
        # Secondary region networking
        example_secondary = azure.network.VirtualNetwork("example_secondary",
            name=f"{prefix}-vnet-secondary",
            location=alt_location,
            resource_group_name=example.name,
            address_spaces=["10.48.0.0/16"])
        example_secondary_subnet = azure.network.Subnet("example_secondary",
            name=f"{prefix}-delegated-subnet-secondary",
            resource_group_name=example.name,
            virtual_network_name=example_secondary.name,
            address_prefixes=["10.48.2.0/24"],
            delegations=[{
                "name": "exampledelegation",
                "service_delegation": {
                    "name": "Microsoft.Netapp/volumes",
                    "actions": [
                        "Microsoft.Network/networkinterfaces/*",
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                    ],
                },
            }])
        # Primary region NetApp infrastructure
        example_primary_account = azure.netapp.Account("example_primary",
            name=f"{prefix}-netapp-account-primary",
            location=example.location,
            resource_group_name=example.name,
            opts = pulumi.ResourceOptions(depends_on=[example_primary_subnet]))
        example_primary_pool = azure.netapp.Pool("example_primary",
            name=f"{prefix}-netapp-pool-primary",
            location=example.location,
            resource_group_name=example.name,
            account_name=example_primary_account.name,
            service_level="Standard",
            size_in_tb=4,
            qos_type="Manual")
        # Secondary region NetApp infrastructure
        example_secondary_account = azure.netapp.Account("example_secondary",
            name=f"{prefix}-netapp-account-secondary",
            location=alt_location,
            resource_group_name=example.name,
            opts = pulumi.ResourceOptions(depends_on=[example_secondary_subnet]))
        example_secondary_pool = azure.netapp.Pool("example_secondary",
            name=f"{prefix}-netapp-pool-secondary",
            location=alt_location,
            resource_group_name=example.name,
            account_name=example_secondary_account.name,
            service_level="Standard",
            size_in_tb=4,
            qos_type="Manual")
        # Primary Oracle volume group
        example_primary_volume_group_oracle = azure.netapp.VolumeGroupOracle("example_primary",
            name=f"{prefix}-NetAppVolumeGroupOracle-primary",
            location=example.location,
            resource_group_name=example.name,
            account_name=example_primary_account.name,
            group_description="Primary Oracle volume group for CRR",
            application_identifier="TST",
            volumes=[{
                "name": f"{prefix}-volume-ora1-primary",
                "volume_path": f"{prefix}-my-unique-file-ora-path-1-primary",
                "service_level": "Standard",
                "capacity_pool_id": example_primary_pool.id,
                "subnet_id": example_primary_subnet.id,
                "volume_spec_name": "ora-data1",
                "storage_quota_in_gb": 1024,
                "throughput_in_mibps": 24,
                "protocols": "NFSv4.1",
                "security_style": "unix",
                "snapshot_directory_visible": False,
                "export_policy_rules": [{
                    "rule_index": 1,
                    "allowed_clients": "0.0.0.0/0",
                    "nfsv3_enabled": False,
                    "nfsv41_enabled": True,
                    "unix_read_only": False,
                    "unix_read_write": True,
                    "root_access_enabled": False,
                }],
            }])
        # Secondary Oracle volume group with CRR
        example_secondary_volume_group_oracle = azure.netapp.VolumeGroupOracle("example_secondary",
            name=f"{prefix}-NetAppVolumeGroupOracle-secondary",
            location=alt_location,
            resource_group_name=example.name,
            account_name=example_secondary_account.name,
            group_description="Secondary Oracle volume group for CRR",
            application_identifier="TST",
            volumes=[{
                "name": f"{prefix}-volume-ora1-secondary",
                "volume_path": f"{prefix}-my-unique-file-ora-path-1-secondary",
                "service_level": "Standard",
                "capacity_pool_id": example_secondary_pool.id,
                "subnet_id": example_secondary_subnet.id,
                "volume_spec_name": "ora-data1",
                "storage_quota_in_gb": 1024,
                "throughput_in_mibps": 24,
                "protocols": "NFSv4.1",
                "security_style": "unix",
                "snapshot_directory_visible": False,
                "export_policy_rules": [{
                    "rule_index": 1,
                    "allowed_clients": "0.0.0.0/0",
                    "nfsv3_enabled": False,
                    "nfsv41_enabled": True,
                    "unix_read_only": False,
                    "unix_read_write": True,
                    "root_access_enabled": False,
                }],
                "data_protection_replication": {
                    "endpoint_type": "dst",
                    "remote_volume_location": example.location,
                    "remote_volume_resource_id": example_primary_volume_group_oracle.volumes[0].id,
                    "replication_frequency": "10minutes",
                },
            }],
            opts = pulumi.ResourceOptions(depends_on=[example_primary_volume_group_oracle]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.NetApp` - 2025-01-01

        ## Import

        Application Volume Groups can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:netapp/volumeGroupOracle:VolumeGroupOracle example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mytest-rg/providers/Microsoft.NetApp/netAppAccounts/netapp-account-test/volumeGroups/netapp-volumegroup-test
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_name: Name of the account where the application volume group belong to. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[_builtins.str] application_identifier: The SAP System ID, maximum 3 characters, e.g. `OR1`. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[_builtins.str] group_description: Volume group description. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Application Volume Group. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupOracleVolumeArgs', 'VolumeGroupOracleVolumeArgsDict']]]] volumes: One or more `volume` blocks as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VolumeGroupOracleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name=f"{prefix}-resources",
            location=location,
            tags={
                "SkipNRMSNSG": "true",
            })
        example_virtual_network = azure.network.VirtualNetwork("example",
            name=f"{prefix}-vnet",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.88.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name=f"{prefix}-delegated-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.88.2.0/24"],
            delegations=[{
                "name": "exampledelegation",
                "service_delegation": {
                    "name": "Microsoft.Netapp/volumes",
                    "actions": [
                        "Microsoft.Network/networkinterfaces/*",
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                    ],
                },
            }])
        example_account = azure.netapp.Account("example",
            name=f"{prefix}-netapp-account",
            location=example.location,
            resource_group_name=example.name,
            opts = pulumi.ResourceOptions(depends_on=[example_subnet]))
        example_pool = azure.netapp.Pool("example",
            name=f"{prefix}-netapp-pool",
            location=example.location,
            resource_group_name=example.name,
            account_name=example_account.name,
            service_level="Standard",
            size_in_tb=4,
            qos_type="Manual")
        example_volume_group_oracle = azure.netapp.VolumeGroupOracle("example",
            name=f"{prefix}-NetAppVolumeGroupOracle",
            location=example.location,
            resource_group_name=example.name,
            account_name=example_account.name,
            group_description="Example volume group for Oracle",
            application_identifier="TST",
            volumes=[
                {
                    "name": f"{prefix}-volume-ora1",
                    "volume_path": f"{prefix}-my-unique-file-ora-path-1",
                    "service_level": "Standard",
                    "capacity_pool_id": example_pool.id,
                    "subnet_id": example_subnet.id,
                    "zone": "1",
                    "volume_spec_name": "ora-data1",
                    "storage_quota_in_gb": 1024,
                    "throughput_in_mibps": 24,
                    "protocols": "NFSv4.1",
                    "security_style": "unix",
                    "snapshot_directory_visible": False,
                    "export_policy_rules": [{
                        "rule_index": 1,
                        "allowed_clients": "0.0.0.0/0",
                        "nfsv3_enabled": False,
                        "nfsv41_enabled": True,
                        "unix_read_only": False,
                        "unix_read_write": True,
                        "root_access_enabled": False,
                    }],
                },
                {
                    "name": f"{prefix}-volume-oraLog",
                    "volume_path": f"{prefix}-my-unique-file-oralog-path",
                    "service_level": "Standard",
                    "capacity_pool_id": example_pool.id,
                    "subnet_id": example_subnet.id,
                    "zone": "1",
                    "volume_spec_name": "ora-log",
                    "storage_quota_in_gb": 1024,
                    "throughput_in_mibps": 24,
                    "protocols": "NFSv4.1",
                    "security_style": "unix",
                    "snapshot_directory_visible": False,
                    "export_policy_rules": [{
                        "rule_index": 1,
                        "allowed_clients": "0.0.0.0/0",
                        "nfsv3_enabled": False,
                        "nfsv41_enabled": True,
                        "unix_read_only": False,
                        "unix_read_write": True,
                        "root_access_enabled": False,
                    }],
                },
            ])
        ```

        ### Cross-Region Replication

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name=f"{prefix}-resources",
            location=location,
            tags={
                "SkipNRMSNSG": "true",
            })
        # Primary region networking
        example_primary = azure.network.VirtualNetwork("example_primary",
            name=f"{prefix}-vnet-primary",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.47.0.0/16"])
        example_primary_subnet = azure.network.Subnet("example_primary",
            name=f"{prefix}-delegated-subnet-primary",
            resource_group_name=example.name,
            virtual_network_name=example_primary.name,
            address_prefixes=["10.47.2.0/24"],
            delegations=[{
                "name": "exampledelegation",
                "service_delegation": {
                    "name": "Microsoft.Netapp/volumes",
                    "actions": [
                        "Microsoft.Network/networkinterfaces/*",
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                    ],
                },
            }])
        # Secondary region networking
        example_secondary = azure.network.VirtualNetwork("example_secondary",
            name=f"{prefix}-vnet-secondary",
            location=alt_location,
            resource_group_name=example.name,
            address_spaces=["10.48.0.0/16"])
        example_secondary_subnet = azure.network.Subnet("example_secondary",
            name=f"{prefix}-delegated-subnet-secondary",
            resource_group_name=example.name,
            virtual_network_name=example_secondary.name,
            address_prefixes=["10.48.2.0/24"],
            delegations=[{
                "name": "exampledelegation",
                "service_delegation": {
                    "name": "Microsoft.Netapp/volumes",
                    "actions": [
                        "Microsoft.Network/networkinterfaces/*",
                        "Microsoft.Network/virtualNetworks/subnets/join/action",
                    ],
                },
            }])
        # Primary region NetApp infrastructure
        example_primary_account = azure.netapp.Account("example_primary",
            name=f"{prefix}-netapp-account-primary",
            location=example.location,
            resource_group_name=example.name,
            opts = pulumi.ResourceOptions(depends_on=[example_primary_subnet]))
        example_primary_pool = azure.netapp.Pool("example_primary",
            name=f"{prefix}-netapp-pool-primary",
            location=example.location,
            resource_group_name=example.name,
            account_name=example_primary_account.name,
            service_level="Standard",
            size_in_tb=4,
            qos_type="Manual")
        # Secondary region NetApp infrastructure
        example_secondary_account = azure.netapp.Account("example_secondary",
            name=f"{prefix}-netapp-account-secondary",
            location=alt_location,
            resource_group_name=example.name,
            opts = pulumi.ResourceOptions(depends_on=[example_secondary_subnet]))
        example_secondary_pool = azure.netapp.Pool("example_secondary",
            name=f"{prefix}-netapp-pool-secondary",
            location=alt_location,
            resource_group_name=example.name,
            account_name=example_secondary_account.name,
            service_level="Standard",
            size_in_tb=4,
            qos_type="Manual")
        # Primary Oracle volume group
        example_primary_volume_group_oracle = azure.netapp.VolumeGroupOracle("example_primary",
            name=f"{prefix}-NetAppVolumeGroupOracle-primary",
            location=example.location,
            resource_group_name=example.name,
            account_name=example_primary_account.name,
            group_description="Primary Oracle volume group for CRR",
            application_identifier="TST",
            volumes=[{
                "name": f"{prefix}-volume-ora1-primary",
                "volume_path": f"{prefix}-my-unique-file-ora-path-1-primary",
                "service_level": "Standard",
                "capacity_pool_id": example_primary_pool.id,
                "subnet_id": example_primary_subnet.id,
                "volume_spec_name": "ora-data1",
                "storage_quota_in_gb": 1024,
                "throughput_in_mibps": 24,
                "protocols": "NFSv4.1",
                "security_style": "unix",
                "snapshot_directory_visible": False,
                "export_policy_rules": [{
                    "rule_index": 1,
                    "allowed_clients": "0.0.0.0/0",
                    "nfsv3_enabled": False,
                    "nfsv41_enabled": True,
                    "unix_read_only": False,
                    "unix_read_write": True,
                    "root_access_enabled": False,
                }],
            }])
        # Secondary Oracle volume group with CRR
        example_secondary_volume_group_oracle = azure.netapp.VolumeGroupOracle("example_secondary",
            name=f"{prefix}-NetAppVolumeGroupOracle-secondary",
            location=alt_location,
            resource_group_name=example.name,
            account_name=example_secondary_account.name,
            group_description="Secondary Oracle volume group for CRR",
            application_identifier="TST",
            volumes=[{
                "name": f"{prefix}-volume-ora1-secondary",
                "volume_path": f"{prefix}-my-unique-file-ora-path-1-secondary",
                "service_level": "Standard",
                "capacity_pool_id": example_secondary_pool.id,
                "subnet_id": example_secondary_subnet.id,
                "volume_spec_name": "ora-data1",
                "storage_quota_in_gb": 1024,
                "throughput_in_mibps": 24,
                "protocols": "NFSv4.1",
                "security_style": "unix",
                "snapshot_directory_visible": False,
                "export_policy_rules": [{
                    "rule_index": 1,
                    "allowed_clients": "0.0.0.0/0",
                    "nfsv3_enabled": False,
                    "nfsv41_enabled": True,
                    "unix_read_only": False,
                    "unix_read_write": True,
                    "root_access_enabled": False,
                }],
                "data_protection_replication": {
                    "endpoint_type": "dst",
                    "remote_volume_location": example.location,
                    "remote_volume_resource_id": example_primary_volume_group_oracle.volumes[0].id,
                    "replication_frequency": "10minutes",
                },
            }],
            opts = pulumi.ResourceOptions(depends_on=[example_primary_volume_group_oracle]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.NetApp` - 2025-01-01

        ## Import

        Application Volume Groups can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:netapp/volumeGroupOracle:VolumeGroupOracle example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mytest-rg/providers/Microsoft.NetApp/netAppAccounts/netapp-account-test/volumeGroups/netapp-volumegroup-test
        ```

        :param str resource_name: The name of the resource.
        :param VolumeGroupOracleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VolumeGroupOracleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 application_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 group_description: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupOracleVolumeArgs', 'VolumeGroupOracleVolumeArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VolumeGroupOracleArgs.__new__(VolumeGroupOracleArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            if application_identifier is None and not opts.urn:
                raise TypeError("Missing required property 'application_identifier'")
            __props__.__dict__["application_identifier"] = application_identifier
            if group_description is None and not opts.urn:
                raise TypeError("Missing required property 'group_description'")
            __props__.__dict__["group_description"] = group_description
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if volumes is None and not opts.urn:
                raise TypeError("Missing required property 'volumes'")
            __props__.__dict__["volumes"] = volumes
        super(VolumeGroupOracle, __self__).__init__(
            'azure:netapp/volumeGroupOracle:VolumeGroupOracle',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[_builtins.str]] = None,
            application_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            group_description: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupOracleVolumeArgs', 'VolumeGroupOracleVolumeArgsDict']]]]] = None) -> 'VolumeGroupOracle':
        """
        Get an existing VolumeGroupOracle resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_name: Name of the account where the application volume group belong to. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[_builtins.str] application_identifier: The SAP System ID, maximum 3 characters, e.g. `OR1`. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[_builtins.str] group_description: Volume group description. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Application Volume Group. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        :param pulumi.Input[Sequence[pulumi.Input[Union['VolumeGroupOracleVolumeArgs', 'VolumeGroupOracleVolumeArgsDict']]]] volumes: One or more `volume` blocks as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VolumeGroupOracleState.__new__(_VolumeGroupOracleState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["application_identifier"] = application_identifier
        __props__.__dict__["group_description"] = group_description
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["volumes"] = volumes
        return VolumeGroupOracle(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the account where the application volume group belong to. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="applicationIdentifier")
    def application_identifier(self) -> pulumi.Output[_builtins.str]:
        """
        The SAP System ID, maximum 3 characters, e.g. `OR1`. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "application_identifier")

    @_builtins.property
    @pulumi.getter(name="groupDescription")
    def group_description(self) -> pulumi.Output[_builtins.str]:
        """
        Volume group description. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "group_description")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Application Volume Group. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Application Volume Group should exist. Changing this forces a new Application Volume Group to be created and data will be lost.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> pulumi.Output[Sequence['outputs.VolumeGroupOracleVolume']]:
        """
        One or more `volume` blocks as defined below.
        """
        return pulumi.get(self, "volumes")

