# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExpressRouteCircuitPeeringArgs', 'ExpressRouteCircuitPeering']

@pulumi.input_type
class ExpressRouteCircuitPeeringArgs:
    def __init__(__self__, *,
                 express_route_circuit_name: pulumi.Input[_builtins.str],
                 peering_type: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 vlan_id: pulumi.Input[_builtins.int],
                 ipv4_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6: Optional[pulumi.Input['ExpressRouteCircuitPeeringIpv6Args']] = None,
                 microsoft_peering_config: Optional[pulumi.Input['ExpressRouteCircuitPeeringMicrosoftPeeringConfigArgs']] = None,
                 peer_asn: Optional[pulumi.Input[_builtins.int]] = None,
                 primary_peer_address_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 route_filter_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_peer_address_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_key: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ExpressRouteCircuitPeering resource.
        :param pulumi.Input[_builtins.str] express_route_circuit_name: The name of the ExpressRoute Circuit in which to create the Peering. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] peering_type: The type of the ExpressRoute Circuit Peering. Acceptable values include `AzurePrivatePeering`, `AzurePublicPeering` and `MicrosoftPeering`. 
               
               > **Note:** only one Peering of each Type can be created. Attempting to create multiple peerings of the same type will overwrite the original peering.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Express Route Circuit Peering. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] vlan_id: A valid VLAN ID to establish this peering on.
        :param pulumi.Input[_builtins.bool] ipv4_enabled: A boolean value indicating whether the IPv4 peering is enabled. Defaults to `true`.
        :param pulumi.Input['ExpressRouteCircuitPeeringIpv6Args'] ipv6: A `ipv6` block as defined below.
        :param pulumi.Input['ExpressRouteCircuitPeeringMicrosoftPeeringConfigArgs'] microsoft_peering_config: A `microsoft_peering_config` block as defined below. Required when `peering_type` is set to `MicrosoftPeering` and config for IPv4.
        :param pulumi.Input[_builtins.int] peer_asn: The Either a 16-bit or a 32-bit ASN. Can either be public or private.
        :param pulumi.Input[_builtins.str] primary_peer_address_prefix: A subnet for the primary link.
        :param pulumi.Input[_builtins.str] route_filter_id: The ID of the Route Filter. Only available when `peering_type` is set to `MicrosoftPeering`.
               
               > **Note:** `ipv6` can be specified when `peering_type` is `MicrosoftPeering` or `AzurePrivatePeering`
        :param pulumi.Input[_builtins.str] secondary_peer_address_prefix: A subnet for the secondary link.
        :param pulumi.Input[_builtins.str] shared_key: The shared key. Can be a maximum of 25 characters.
        """
        pulumi.set(__self__, "express_route_circuit_name", express_route_circuit_name)
        pulumi.set(__self__, "peering_type", peering_type)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "vlan_id", vlan_id)
        if ipv4_enabled is not None:
            pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if microsoft_peering_config is not None:
            pulumi.set(__self__, "microsoft_peering_config", microsoft_peering_config)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)
        if primary_peer_address_prefix is not None:
            pulumi.set(__self__, "primary_peer_address_prefix", primary_peer_address_prefix)
        if route_filter_id is not None:
            pulumi.set(__self__, "route_filter_id", route_filter_id)
        if secondary_peer_address_prefix is not None:
            pulumi.set(__self__, "secondary_peer_address_prefix", secondary_peer_address_prefix)
        if shared_key is not None:
            pulumi.set(__self__, "shared_key", shared_key)

    @_builtins.property
    @pulumi.getter(name="expressRouteCircuitName")
    def express_route_circuit_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the ExpressRoute Circuit in which to create the Peering. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "express_route_circuit_name")

    @express_route_circuit_name.setter
    def express_route_circuit_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "express_route_circuit_name", value)

    @_builtins.property
    @pulumi.getter(name="peeringType")
    def peering_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the ExpressRoute Circuit Peering. Acceptable values include `AzurePrivatePeering`, `AzurePublicPeering` and `MicrosoftPeering`. 

        > **Note:** only one Peering of each Type can be created. Attempting to create multiple peerings of the same type will overwrite the original peering.
        """
        return pulumi.get(self, "peering_type")

    @peering_type.setter
    def peering_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "peering_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the Express Route Circuit Peering. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Input[_builtins.int]:
        """
        A valid VLAN ID to establish this peering on.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "vlan_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean value indicating whether the IPv4 peering is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "ipv4_enabled")

    @ipv4_enabled.setter
    def ipv4_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv4_enabled", value)

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> Optional[pulumi.Input['ExpressRouteCircuitPeeringIpv6Args']]:
        """
        A `ipv6` block as defined below.
        """
        return pulumi.get(self, "ipv6")

    @ipv6.setter
    def ipv6(self, value: Optional[pulumi.Input['ExpressRouteCircuitPeeringIpv6Args']]):
        pulumi.set(self, "ipv6", value)

    @_builtins.property
    @pulumi.getter(name="microsoftPeeringConfig")
    def microsoft_peering_config(self) -> Optional[pulumi.Input['ExpressRouteCircuitPeeringMicrosoftPeeringConfigArgs']]:
        """
        A `microsoft_peering_config` block as defined below. Required when `peering_type` is set to `MicrosoftPeering` and config for IPv4.
        """
        return pulumi.get(self, "microsoft_peering_config")

    @microsoft_peering_config.setter
    def microsoft_peering_config(self, value: Optional[pulumi.Input['ExpressRouteCircuitPeeringMicrosoftPeeringConfigArgs']]):
        pulumi.set(self, "microsoft_peering_config", value)

    @_builtins.property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Either a 16-bit or a 32-bit ASN. Can either be public or private.
        """
        return pulumi.get(self, "peer_asn")

    @peer_asn.setter
    def peer_asn(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "peer_asn", value)

    @_builtins.property
    @pulumi.getter(name="primaryPeerAddressPrefix")
    def primary_peer_address_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A subnet for the primary link.
        """
        return pulumi.get(self, "primary_peer_address_prefix")

    @primary_peer_address_prefix.setter
    def primary_peer_address_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_peer_address_prefix", value)

    @_builtins.property
    @pulumi.getter(name="routeFilterId")
    def route_filter_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Route Filter. Only available when `peering_type` is set to `MicrosoftPeering`.

        > **Note:** `ipv6` can be specified when `peering_type` is `MicrosoftPeering` or `AzurePrivatePeering`
        """
        return pulumi.get(self, "route_filter_id")

    @route_filter_id.setter
    def route_filter_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_filter_id", value)

    @_builtins.property
    @pulumi.getter(name="secondaryPeerAddressPrefix")
    def secondary_peer_address_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A subnet for the secondary link.
        """
        return pulumi.get(self, "secondary_peer_address_prefix")

    @secondary_peer_address_prefix.setter
    def secondary_peer_address_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_peer_address_prefix", value)

    @_builtins.property
    @pulumi.getter(name="sharedKey")
    def shared_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The shared key. Can be a maximum of 25 characters.
        """
        return pulumi.get(self, "shared_key")

    @shared_key.setter
    def shared_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shared_key", value)


@pulumi.input_type
class _ExpressRouteCircuitPeeringState:
    def __init__(__self__, *,
                 azure_asn: Optional[pulumi.Input[_builtins.int]] = None,
                 express_route_circuit_name: Optional[pulumi.Input[_builtins.str]] = None,
                 gateway_manager_etag: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6: Optional[pulumi.Input['ExpressRouteCircuitPeeringIpv6Args']] = None,
                 microsoft_peering_config: Optional[pulumi.Input['ExpressRouteCircuitPeeringMicrosoftPeeringConfigArgs']] = None,
                 peer_asn: Optional[pulumi.Input[_builtins.int]] = None,
                 peering_type: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_azure_port: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_peer_address_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 route_filter_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_azure_port: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_peer_address_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_key: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_id: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering ExpressRouteCircuitPeering resources.
        :param pulumi.Input[_builtins.int] azure_asn: The ASN used by Azure.
        :param pulumi.Input[_builtins.str] express_route_circuit_name: The name of the ExpressRoute Circuit in which to create the Peering. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] ipv4_enabled: A boolean value indicating whether the IPv4 peering is enabled. Defaults to `true`.
        :param pulumi.Input['ExpressRouteCircuitPeeringIpv6Args'] ipv6: A `ipv6` block as defined below.
        :param pulumi.Input['ExpressRouteCircuitPeeringMicrosoftPeeringConfigArgs'] microsoft_peering_config: A `microsoft_peering_config` block as defined below. Required when `peering_type` is set to `MicrosoftPeering` and config for IPv4.
        :param pulumi.Input[_builtins.int] peer_asn: The Either a 16-bit or a 32-bit ASN. Can either be public or private.
        :param pulumi.Input[_builtins.str] peering_type: The type of the ExpressRoute Circuit Peering. Acceptable values include `AzurePrivatePeering`, `AzurePublicPeering` and `MicrosoftPeering`. 
               
               > **Note:** only one Peering of each Type can be created. Attempting to create multiple peerings of the same type will overwrite the original peering.
        :param pulumi.Input[_builtins.str] primary_azure_port: The Primary Port used by Azure for this Peering.
        :param pulumi.Input[_builtins.str] primary_peer_address_prefix: A subnet for the primary link.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Express Route Circuit Peering. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] route_filter_id: The ID of the Route Filter. Only available when `peering_type` is set to `MicrosoftPeering`.
               
               > **Note:** `ipv6` can be specified when `peering_type` is `MicrosoftPeering` or `AzurePrivatePeering`
        :param pulumi.Input[_builtins.str] secondary_azure_port: The Secondary Port used by Azure for this Peering.
        :param pulumi.Input[_builtins.str] secondary_peer_address_prefix: A subnet for the secondary link.
        :param pulumi.Input[_builtins.str] shared_key: The shared key. Can be a maximum of 25 characters.
        :param pulumi.Input[_builtins.int] vlan_id: A valid VLAN ID to establish this peering on.
        """
        if azure_asn is not None:
            pulumi.set(__self__, "azure_asn", azure_asn)
        if express_route_circuit_name is not None:
            pulumi.set(__self__, "express_route_circuit_name", express_route_circuit_name)
        if gateway_manager_etag is not None:
            pulumi.set(__self__, "gateway_manager_etag", gateway_manager_etag)
        if ipv4_enabled is not None:
            pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if microsoft_peering_config is not None:
            pulumi.set(__self__, "microsoft_peering_config", microsoft_peering_config)
        if peer_asn is not None:
            pulumi.set(__self__, "peer_asn", peer_asn)
        if peering_type is not None:
            pulumi.set(__self__, "peering_type", peering_type)
        if primary_azure_port is not None:
            pulumi.set(__self__, "primary_azure_port", primary_azure_port)
        if primary_peer_address_prefix is not None:
            pulumi.set(__self__, "primary_peer_address_prefix", primary_peer_address_prefix)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if route_filter_id is not None:
            pulumi.set(__self__, "route_filter_id", route_filter_id)
        if secondary_azure_port is not None:
            pulumi.set(__self__, "secondary_azure_port", secondary_azure_port)
        if secondary_peer_address_prefix is not None:
            pulumi.set(__self__, "secondary_peer_address_prefix", secondary_peer_address_prefix)
        if shared_key is not None:
            pulumi.set(__self__, "shared_key", shared_key)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @_builtins.property
    @pulumi.getter(name="azureAsn")
    def azure_asn(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The ASN used by Azure.
        """
        return pulumi.get(self, "azure_asn")

    @azure_asn.setter
    def azure_asn(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "azure_asn", value)

    @_builtins.property
    @pulumi.getter(name="expressRouteCircuitName")
    def express_route_circuit_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the ExpressRoute Circuit in which to create the Peering. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "express_route_circuit_name")

    @express_route_circuit_name.setter
    def express_route_circuit_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "express_route_circuit_name", value)

    @_builtins.property
    @pulumi.getter(name="gatewayManagerEtag")
    def gateway_manager_etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "gateway_manager_etag")

    @gateway_manager_etag.setter
    def gateway_manager_etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gateway_manager_etag", value)

    @_builtins.property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean value indicating whether the IPv4 peering is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "ipv4_enabled")

    @ipv4_enabled.setter
    def ipv4_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv4_enabled", value)

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> Optional[pulumi.Input['ExpressRouteCircuitPeeringIpv6Args']]:
        """
        A `ipv6` block as defined below.
        """
        return pulumi.get(self, "ipv6")

    @ipv6.setter
    def ipv6(self, value: Optional[pulumi.Input['ExpressRouteCircuitPeeringIpv6Args']]):
        pulumi.set(self, "ipv6", value)

    @_builtins.property
    @pulumi.getter(name="microsoftPeeringConfig")
    def microsoft_peering_config(self) -> Optional[pulumi.Input['ExpressRouteCircuitPeeringMicrosoftPeeringConfigArgs']]:
        """
        A `microsoft_peering_config` block as defined below. Required when `peering_type` is set to `MicrosoftPeering` and config for IPv4.
        """
        return pulumi.get(self, "microsoft_peering_config")

    @microsoft_peering_config.setter
    def microsoft_peering_config(self, value: Optional[pulumi.Input['ExpressRouteCircuitPeeringMicrosoftPeeringConfigArgs']]):
        pulumi.set(self, "microsoft_peering_config", value)

    @_builtins.property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The Either a 16-bit or a 32-bit ASN. Can either be public or private.
        """
        return pulumi.get(self, "peer_asn")

    @peer_asn.setter
    def peer_asn(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "peer_asn", value)

    @_builtins.property
    @pulumi.getter(name="peeringType")
    def peering_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the ExpressRoute Circuit Peering. Acceptable values include `AzurePrivatePeering`, `AzurePublicPeering` and `MicrosoftPeering`. 

        > **Note:** only one Peering of each Type can be created. Attempting to create multiple peerings of the same type will overwrite the original peering.
        """
        return pulumi.get(self, "peering_type")

    @peering_type.setter
    def peering_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peering_type", value)

    @_builtins.property
    @pulumi.getter(name="primaryAzurePort")
    def primary_azure_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Primary Port used by Azure for this Peering.
        """
        return pulumi.get(self, "primary_azure_port")

    @primary_azure_port.setter
    def primary_azure_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_azure_port", value)

    @_builtins.property
    @pulumi.getter(name="primaryPeerAddressPrefix")
    def primary_peer_address_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A subnet for the primary link.
        """
        return pulumi.get(self, "primary_peer_address_prefix")

    @primary_peer_address_prefix.setter
    def primary_peer_address_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_peer_address_prefix", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the Express Route Circuit Peering. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="routeFilterId")
    def route_filter_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Route Filter. Only available when `peering_type` is set to `MicrosoftPeering`.

        > **Note:** `ipv6` can be specified when `peering_type` is `MicrosoftPeering` or `AzurePrivatePeering`
        """
        return pulumi.get(self, "route_filter_id")

    @route_filter_id.setter
    def route_filter_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "route_filter_id", value)

    @_builtins.property
    @pulumi.getter(name="secondaryAzurePort")
    def secondary_azure_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Secondary Port used by Azure for this Peering.
        """
        return pulumi.get(self, "secondary_azure_port")

    @secondary_azure_port.setter
    def secondary_azure_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_azure_port", value)

    @_builtins.property
    @pulumi.getter(name="secondaryPeerAddressPrefix")
    def secondary_peer_address_prefix(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A subnet for the secondary link.
        """
        return pulumi.get(self, "secondary_peer_address_prefix")

    @secondary_peer_address_prefix.setter
    def secondary_peer_address_prefix(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_peer_address_prefix", value)

    @_builtins.property
    @pulumi.getter(name="sharedKey")
    def shared_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The shared key. Can be a maximum of 25 characters.
        """
        return pulumi.get(self, "shared_key")

    @shared_key.setter
    def shared_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shared_key", value)

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        A valid VLAN ID to establish this peering on.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "vlan_id", value)


@pulumi.type_token("azure:network/expressRouteCircuitPeering:ExpressRouteCircuitPeering")
class ExpressRouteCircuitPeering(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 express_route_circuit_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6: Optional[pulumi.Input[Union['ExpressRouteCircuitPeeringIpv6Args', 'ExpressRouteCircuitPeeringIpv6ArgsDict']]] = None,
                 microsoft_peering_config: Optional[pulumi.Input[Union['ExpressRouteCircuitPeeringMicrosoftPeeringConfigArgs', 'ExpressRouteCircuitPeeringMicrosoftPeeringConfigArgsDict']]] = None,
                 peer_asn: Optional[pulumi.Input[_builtins.int]] = None,
                 peering_type: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_peer_address_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 route_filter_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_peer_address_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_key: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages an ExpressRoute Circuit Peering.

        ## Example Usage

        ### Creating A Microsoft Peering)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="exprtTest",
            location="West Europe")
        example_express_route_circuit = azure.network.ExpressRouteCircuit("example",
            name="expressRoute1",
            resource_group_name=example.name,
            location=example.location,
            service_provider_name="Equinix",
            peering_location="Silicon Valley",
            bandwidth_in_mbps=50,
            sku={
                "tier": "Standard",
                "family": "MeteredData",
            },
            allow_classic_operations=False,
            tags={
                "environment": "Production",
            })
        example_express_route_circuit_peering = azure.network.ExpressRouteCircuitPeering("example",
            peering_type="MicrosoftPeering",
            express_route_circuit_name=example_express_route_circuit.name,
            resource_group_name=example.name,
            peer_asn=100,
            primary_peer_address_prefix="123.0.0.0/30",
            secondary_peer_address_prefix="123.0.0.4/30",
            ipv4_enabled=True,
            vlan_id=300,
            microsoft_peering_config={
                "advertised_public_prefixes": ["123.1.0.0/24"],
            },
            ipv6={
                "primary_peer_address_prefix": "2002:db01::/126",
                "secondary_peer_address_prefix": "2003:db01::/126",
                "enabled": True,
                "microsoft_peering": {
                    "advertised_public_prefixes": ["2002:db01::/126"],
                },
            })
        ```

        ### Creating Azure Private Peering)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="exprtTest",
            location="West Europe")
        example_express_route_circuit = azure.network.ExpressRouteCircuit("example",
            name="expressRoute1",
            resource_group_name=example.name,
            location=example.location,
            service_provider_name="Equinix",
            peering_location="Silicon Valley",
            bandwidth_in_mbps=50,
            sku={
                "tier": "Standard",
                "family": "MeteredData",
            },
            allow_classic_operations=False,
            tags={
                "environment": "Production",
            })
        example_express_route_circuit_peering = azure.network.ExpressRouteCircuitPeering("example",
            peering_type="AzurePrivatePeering",
            express_route_circuit_name=example_express_route_circuit.name,
            resource_group_name=example.name,
            peer_asn=100,
            primary_peer_address_prefix="123.0.0.0/30",
            secondary_peer_address_prefix="123.0.0.4/30",
            ipv4_enabled=True,
            vlan_id=300,
            ipv6={
                "primary_peer_address_prefix": "2002:db01::/126",
                "secondary_peer_address_prefix": "2003:db01::/126",
                "enabled": True,
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2024-05-01

        ## Import

        ExpressRoute Circuit Peerings can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/expressRouteCircuitPeering:ExpressRouteCircuitPeering peering1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/expressRouteCircuits/myExpressRoute/peerings/peering1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] express_route_circuit_name: The name of the ExpressRoute Circuit in which to create the Peering. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] ipv4_enabled: A boolean value indicating whether the IPv4 peering is enabled. Defaults to `true`.
        :param pulumi.Input[Union['ExpressRouteCircuitPeeringIpv6Args', 'ExpressRouteCircuitPeeringIpv6ArgsDict']] ipv6: A `ipv6` block as defined below.
        :param pulumi.Input[Union['ExpressRouteCircuitPeeringMicrosoftPeeringConfigArgs', 'ExpressRouteCircuitPeeringMicrosoftPeeringConfigArgsDict']] microsoft_peering_config: A `microsoft_peering_config` block as defined below. Required when `peering_type` is set to `MicrosoftPeering` and config for IPv4.
        :param pulumi.Input[_builtins.int] peer_asn: The Either a 16-bit or a 32-bit ASN. Can either be public or private.
        :param pulumi.Input[_builtins.str] peering_type: The type of the ExpressRoute Circuit Peering. Acceptable values include `AzurePrivatePeering`, `AzurePublicPeering` and `MicrosoftPeering`. 
               
               > **Note:** only one Peering of each Type can be created. Attempting to create multiple peerings of the same type will overwrite the original peering.
        :param pulumi.Input[_builtins.str] primary_peer_address_prefix: A subnet for the primary link.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Express Route Circuit Peering. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] route_filter_id: The ID of the Route Filter. Only available when `peering_type` is set to `MicrosoftPeering`.
               
               > **Note:** `ipv6` can be specified when `peering_type` is `MicrosoftPeering` or `AzurePrivatePeering`
        :param pulumi.Input[_builtins.str] secondary_peer_address_prefix: A subnet for the secondary link.
        :param pulumi.Input[_builtins.str] shared_key: The shared key. Can be a maximum of 25 characters.
        :param pulumi.Input[_builtins.int] vlan_id: A valid VLAN ID to establish this peering on.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExpressRouteCircuitPeeringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an ExpressRoute Circuit Peering.

        ## Example Usage

        ### Creating A Microsoft Peering)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="exprtTest",
            location="West Europe")
        example_express_route_circuit = azure.network.ExpressRouteCircuit("example",
            name="expressRoute1",
            resource_group_name=example.name,
            location=example.location,
            service_provider_name="Equinix",
            peering_location="Silicon Valley",
            bandwidth_in_mbps=50,
            sku={
                "tier": "Standard",
                "family": "MeteredData",
            },
            allow_classic_operations=False,
            tags={
                "environment": "Production",
            })
        example_express_route_circuit_peering = azure.network.ExpressRouteCircuitPeering("example",
            peering_type="MicrosoftPeering",
            express_route_circuit_name=example_express_route_circuit.name,
            resource_group_name=example.name,
            peer_asn=100,
            primary_peer_address_prefix="123.0.0.0/30",
            secondary_peer_address_prefix="123.0.0.4/30",
            ipv4_enabled=True,
            vlan_id=300,
            microsoft_peering_config={
                "advertised_public_prefixes": ["123.1.0.0/24"],
            },
            ipv6={
                "primary_peer_address_prefix": "2002:db01::/126",
                "secondary_peer_address_prefix": "2003:db01::/126",
                "enabled": True,
                "microsoft_peering": {
                    "advertised_public_prefixes": ["2002:db01::/126"],
                },
            })
        ```

        ### Creating Azure Private Peering)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="exprtTest",
            location="West Europe")
        example_express_route_circuit = azure.network.ExpressRouteCircuit("example",
            name="expressRoute1",
            resource_group_name=example.name,
            location=example.location,
            service_provider_name="Equinix",
            peering_location="Silicon Valley",
            bandwidth_in_mbps=50,
            sku={
                "tier": "Standard",
                "family": "MeteredData",
            },
            allow_classic_operations=False,
            tags={
                "environment": "Production",
            })
        example_express_route_circuit_peering = azure.network.ExpressRouteCircuitPeering("example",
            peering_type="AzurePrivatePeering",
            express_route_circuit_name=example_express_route_circuit.name,
            resource_group_name=example.name,
            peer_asn=100,
            primary_peer_address_prefix="123.0.0.0/30",
            secondary_peer_address_prefix="123.0.0.4/30",
            ipv4_enabled=True,
            vlan_id=300,
            ipv6={
                "primary_peer_address_prefix": "2002:db01::/126",
                "secondary_peer_address_prefix": "2003:db01::/126",
                "enabled": True,
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2024-05-01

        ## Import

        ExpressRoute Circuit Peerings can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/expressRouteCircuitPeering:ExpressRouteCircuitPeering peering1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/expressRouteCircuits/myExpressRoute/peerings/peering1
        ```

        :param str resource_name: The name of the resource.
        :param ExpressRouteCircuitPeeringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExpressRouteCircuitPeeringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 express_route_circuit_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv4_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ipv6: Optional[pulumi.Input[Union['ExpressRouteCircuitPeeringIpv6Args', 'ExpressRouteCircuitPeeringIpv6ArgsDict']]] = None,
                 microsoft_peering_config: Optional[pulumi.Input[Union['ExpressRouteCircuitPeeringMicrosoftPeeringConfigArgs', 'ExpressRouteCircuitPeeringMicrosoftPeeringConfigArgsDict']]] = None,
                 peer_asn: Optional[pulumi.Input[_builtins.int]] = None,
                 peering_type: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_peer_address_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 route_filter_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_peer_address_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                 shared_key: Optional[pulumi.Input[_builtins.str]] = None,
                 vlan_id: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExpressRouteCircuitPeeringArgs.__new__(ExpressRouteCircuitPeeringArgs)

            if express_route_circuit_name is None and not opts.urn:
                raise TypeError("Missing required property 'express_route_circuit_name'")
            __props__.__dict__["express_route_circuit_name"] = express_route_circuit_name
            __props__.__dict__["ipv4_enabled"] = ipv4_enabled
            __props__.__dict__["ipv6"] = ipv6
            __props__.__dict__["microsoft_peering_config"] = microsoft_peering_config
            __props__.__dict__["peer_asn"] = peer_asn
            if peering_type is None and not opts.urn:
                raise TypeError("Missing required property 'peering_type'")
            __props__.__dict__["peering_type"] = peering_type
            __props__.__dict__["primary_peer_address_prefix"] = primary_peer_address_prefix
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["route_filter_id"] = route_filter_id
            __props__.__dict__["secondary_peer_address_prefix"] = secondary_peer_address_prefix
            __props__.__dict__["shared_key"] = None if shared_key is None else pulumi.Output.secret(shared_key)
            if vlan_id is None and not opts.urn:
                raise TypeError("Missing required property 'vlan_id'")
            __props__.__dict__["vlan_id"] = vlan_id
            __props__.__dict__["azure_asn"] = None
            __props__.__dict__["gateway_manager_etag"] = None
            __props__.__dict__["primary_azure_port"] = None
            __props__.__dict__["secondary_azure_port"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["sharedKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ExpressRouteCircuitPeering, __self__).__init__(
            'azure:network/expressRouteCircuitPeering:ExpressRouteCircuitPeering',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            azure_asn: Optional[pulumi.Input[_builtins.int]] = None,
            express_route_circuit_name: Optional[pulumi.Input[_builtins.str]] = None,
            gateway_manager_etag: Optional[pulumi.Input[_builtins.str]] = None,
            ipv4_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            ipv6: Optional[pulumi.Input[Union['ExpressRouteCircuitPeeringIpv6Args', 'ExpressRouteCircuitPeeringIpv6ArgsDict']]] = None,
            microsoft_peering_config: Optional[pulumi.Input[Union['ExpressRouteCircuitPeeringMicrosoftPeeringConfigArgs', 'ExpressRouteCircuitPeeringMicrosoftPeeringConfigArgsDict']]] = None,
            peer_asn: Optional[pulumi.Input[_builtins.int]] = None,
            peering_type: Optional[pulumi.Input[_builtins.str]] = None,
            primary_azure_port: Optional[pulumi.Input[_builtins.str]] = None,
            primary_peer_address_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            route_filter_id: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_azure_port: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_peer_address_prefix: Optional[pulumi.Input[_builtins.str]] = None,
            shared_key: Optional[pulumi.Input[_builtins.str]] = None,
            vlan_id: Optional[pulumi.Input[_builtins.int]] = None) -> 'ExpressRouteCircuitPeering':
        """
        Get an existing ExpressRouteCircuitPeering resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] azure_asn: The ASN used by Azure.
        :param pulumi.Input[_builtins.str] express_route_circuit_name: The name of the ExpressRoute Circuit in which to create the Peering. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] ipv4_enabled: A boolean value indicating whether the IPv4 peering is enabled. Defaults to `true`.
        :param pulumi.Input[Union['ExpressRouteCircuitPeeringIpv6Args', 'ExpressRouteCircuitPeeringIpv6ArgsDict']] ipv6: A `ipv6` block as defined below.
        :param pulumi.Input[Union['ExpressRouteCircuitPeeringMicrosoftPeeringConfigArgs', 'ExpressRouteCircuitPeeringMicrosoftPeeringConfigArgsDict']] microsoft_peering_config: A `microsoft_peering_config` block as defined below. Required when `peering_type` is set to `MicrosoftPeering` and config for IPv4.
        :param pulumi.Input[_builtins.int] peer_asn: The Either a 16-bit or a 32-bit ASN. Can either be public or private.
        :param pulumi.Input[_builtins.str] peering_type: The type of the ExpressRoute Circuit Peering. Acceptable values include `AzurePrivatePeering`, `AzurePublicPeering` and `MicrosoftPeering`. 
               
               > **Note:** only one Peering of each Type can be created. Attempting to create multiple peerings of the same type will overwrite the original peering.
        :param pulumi.Input[_builtins.str] primary_azure_port: The Primary Port used by Azure for this Peering.
        :param pulumi.Input[_builtins.str] primary_peer_address_prefix: A subnet for the primary link.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Express Route Circuit Peering. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] route_filter_id: The ID of the Route Filter. Only available when `peering_type` is set to `MicrosoftPeering`.
               
               > **Note:** `ipv6` can be specified when `peering_type` is `MicrosoftPeering` or `AzurePrivatePeering`
        :param pulumi.Input[_builtins.str] secondary_azure_port: The Secondary Port used by Azure for this Peering.
        :param pulumi.Input[_builtins.str] secondary_peer_address_prefix: A subnet for the secondary link.
        :param pulumi.Input[_builtins.str] shared_key: The shared key. Can be a maximum of 25 characters.
        :param pulumi.Input[_builtins.int] vlan_id: A valid VLAN ID to establish this peering on.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExpressRouteCircuitPeeringState.__new__(_ExpressRouteCircuitPeeringState)

        __props__.__dict__["azure_asn"] = azure_asn
        __props__.__dict__["express_route_circuit_name"] = express_route_circuit_name
        __props__.__dict__["gateway_manager_etag"] = gateway_manager_etag
        __props__.__dict__["ipv4_enabled"] = ipv4_enabled
        __props__.__dict__["ipv6"] = ipv6
        __props__.__dict__["microsoft_peering_config"] = microsoft_peering_config
        __props__.__dict__["peer_asn"] = peer_asn
        __props__.__dict__["peering_type"] = peering_type
        __props__.__dict__["primary_azure_port"] = primary_azure_port
        __props__.__dict__["primary_peer_address_prefix"] = primary_peer_address_prefix
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["route_filter_id"] = route_filter_id
        __props__.__dict__["secondary_azure_port"] = secondary_azure_port
        __props__.__dict__["secondary_peer_address_prefix"] = secondary_peer_address_prefix
        __props__.__dict__["shared_key"] = shared_key
        __props__.__dict__["vlan_id"] = vlan_id
        return ExpressRouteCircuitPeering(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="azureAsn")
    def azure_asn(self) -> pulumi.Output[_builtins.int]:
        """
        The ASN used by Azure.
        """
        return pulumi.get(self, "azure_asn")

    @_builtins.property
    @pulumi.getter(name="expressRouteCircuitName")
    def express_route_circuit_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the ExpressRoute Circuit in which to create the Peering. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "express_route_circuit_name")

    @_builtins.property
    @pulumi.getter(name="gatewayManagerEtag")
    def gateway_manager_etag(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "gateway_manager_etag")

    @_builtins.property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A boolean value indicating whether the IPv4 peering is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "ipv4_enabled")

    @_builtins.property
    @pulumi.getter
    def ipv6(self) -> pulumi.Output[Optional['outputs.ExpressRouteCircuitPeeringIpv6']]:
        """
        A `ipv6` block as defined below.
        """
        return pulumi.get(self, "ipv6")

    @_builtins.property
    @pulumi.getter(name="microsoftPeeringConfig")
    def microsoft_peering_config(self) -> pulumi.Output[Optional['outputs.ExpressRouteCircuitPeeringMicrosoftPeeringConfig']]:
        """
        A `microsoft_peering_config` block as defined below. Required when `peering_type` is set to `MicrosoftPeering` and config for IPv4.
        """
        return pulumi.get(self, "microsoft_peering_config")

    @_builtins.property
    @pulumi.getter(name="peerAsn")
    def peer_asn(self) -> pulumi.Output[_builtins.int]:
        """
        The Either a 16-bit or a 32-bit ASN. Can either be public or private.
        """
        return pulumi.get(self, "peer_asn")

    @_builtins.property
    @pulumi.getter(name="peeringType")
    def peering_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the ExpressRoute Circuit Peering. Acceptable values include `AzurePrivatePeering`, `AzurePublicPeering` and `MicrosoftPeering`. 

        > **Note:** only one Peering of each Type can be created. Attempting to create multiple peerings of the same type will overwrite the original peering.
        """
        return pulumi.get(self, "peering_type")

    @_builtins.property
    @pulumi.getter(name="primaryAzurePort")
    def primary_azure_port(self) -> pulumi.Output[_builtins.str]:
        """
        The Primary Port used by Azure for this Peering.
        """
        return pulumi.get(self, "primary_azure_port")

    @_builtins.property
    @pulumi.getter(name="primaryPeerAddressPrefix")
    def primary_peer_address_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A subnet for the primary link.
        """
        return pulumi.get(self, "primary_peer_address_prefix")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the Express Route Circuit Peering. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="routeFilterId")
    def route_filter_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Route Filter. Only available when `peering_type` is set to `MicrosoftPeering`.

        > **Note:** `ipv6` can be specified when `peering_type` is `MicrosoftPeering` or `AzurePrivatePeering`
        """
        return pulumi.get(self, "route_filter_id")

    @_builtins.property
    @pulumi.getter(name="secondaryAzurePort")
    def secondary_azure_port(self) -> pulumi.Output[_builtins.str]:
        """
        The Secondary Port used by Azure for this Peering.
        """
        return pulumi.get(self, "secondary_azure_port")

    @_builtins.property
    @pulumi.getter(name="secondaryPeerAddressPrefix")
    def secondary_peer_address_prefix(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A subnet for the secondary link.
        """
        return pulumi.get(self, "secondary_peer_address_prefix")

    @_builtins.property
    @pulumi.getter(name="sharedKey")
    def shared_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The shared key. Can be a maximum of 25 characters.
        """
        return pulumi.get(self, "shared_key")

    @_builtins.property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Output[_builtins.int]:
        """
        A valid VLAN ID to establish this peering on.
        """
        return pulumi.get(self, "vlan_id")

