# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExpressRouteConnectionArgs', 'ExpressRouteConnection']

@pulumi.input_type
class ExpressRouteConnectionArgs:
    def __init__(__self__, *,
                 express_route_circuit_peering_id: pulumi.Input[_builtins.str],
                 express_route_gateway_id: pulumi.Input[_builtins.str],
                 authorization_key: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_internet_security: Optional[pulumi.Input[_builtins.bool]] = None,
                 express_route_gateway_bypass_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_fast_path_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 routing: Optional[pulumi.Input['ExpressRouteConnectionRoutingArgs']] = None,
                 routing_weight: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a ExpressRouteConnection resource.
        :param pulumi.Input[_builtins.str] express_route_circuit_peering_id: The ID of the Express Route Circuit Peering that this Express Route Connection connects with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] express_route_gateway_id: The ID of the Express Route Gateway that this Express Route Connection connects with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] authorization_key: The authorization key to establish the Express Route Connection.
        :param pulumi.Input[_builtins.bool] enable_internet_security: Is Internet security enabled for this Express Route Connection?
        :param pulumi.Input[_builtins.bool] express_route_gateway_bypass_enabled: Specified whether Fast Path is enabled for Virtual Wan Firewall Hub. Defaults to `false`.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Express Route Connection. Changing this forces a new resource to be created.
        :param pulumi.Input['ExpressRouteConnectionRoutingArgs'] routing: A `routing` block as defined below.
        :param pulumi.Input[_builtins.int] routing_weight: The routing weight associated to the Express Route Connection. Possible value is between `0` and `32000`. Defaults to `0`.
        """
        pulumi.set(__self__, "express_route_circuit_peering_id", express_route_circuit_peering_id)
        pulumi.set(__self__, "express_route_gateway_id", express_route_gateway_id)
        if authorization_key is not None:
            pulumi.set(__self__, "authorization_key", authorization_key)
        if enable_internet_security is not None:
            pulumi.set(__self__, "enable_internet_security", enable_internet_security)
        if express_route_gateway_bypass_enabled is not None:
            pulumi.set(__self__, "express_route_gateway_bypass_enabled", express_route_gateway_bypass_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_link_fast_path_enabled is not None:
            warnings.warn("""'private_link_fast_path_enabled' has been deprecated as it is no longer supported by the resource and will be removed in v5.0 of the AzureRM Provider""", DeprecationWarning)
            pulumi.log.warn("""private_link_fast_path_enabled is deprecated: 'private_link_fast_path_enabled' has been deprecated as it is no longer supported by the resource and will be removed in v5.0 of the AzureRM Provider""")
        if private_link_fast_path_enabled is not None:
            pulumi.set(__self__, "private_link_fast_path_enabled", private_link_fast_path_enabled)
        if routing is not None:
            pulumi.set(__self__, "routing", routing)
        if routing_weight is not None:
            pulumi.set(__self__, "routing_weight", routing_weight)

    @_builtins.property
    @pulumi.getter(name="expressRouteCircuitPeeringId")
    def express_route_circuit_peering_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Express Route Circuit Peering that this Express Route Connection connects with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "express_route_circuit_peering_id")

    @express_route_circuit_peering_id.setter
    def express_route_circuit_peering_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "express_route_circuit_peering_id", value)

    @_builtins.property
    @pulumi.getter(name="expressRouteGatewayId")
    def express_route_gateway_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Express Route Gateway that this Express Route Connection connects with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "express_route_gateway_id")

    @express_route_gateway_id.setter
    def express_route_gateway_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "express_route_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authorization key to establish the Express Route Connection.
        """
        return pulumi.get(self, "authorization_key")

    @authorization_key.setter
    def authorization_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorization_key", value)

    @_builtins.property
    @pulumi.getter(name="enableInternetSecurity")
    def enable_internet_security(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Internet security enabled for this Express Route Connection?
        """
        return pulumi.get(self, "enable_internet_security")

    @enable_internet_security.setter
    def enable_internet_security(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_internet_security", value)

    @_builtins.property
    @pulumi.getter(name="expressRouteGatewayBypassEnabled")
    def express_route_gateway_bypass_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specified whether Fast Path is enabled for Virtual Wan Firewall Hub. Defaults to `false`.
        """
        return pulumi.get(self, "express_route_gateway_bypass_enabled")

    @express_route_gateway_bypass_enabled.setter
    def express_route_gateway_bypass_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "express_route_gateway_bypass_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Express Route Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkFastPathEnabled")
    @_utilities.deprecated("""'private_link_fast_path_enabled' has been deprecated as it is no longer supported by the resource and will be removed in v5.0 of the AzureRM Provider""")
    def private_link_fast_path_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "private_link_fast_path_enabled")

    @private_link_fast_path_enabled.setter
    def private_link_fast_path_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_link_fast_path_enabled", value)

    @_builtins.property
    @pulumi.getter
    def routing(self) -> Optional[pulumi.Input['ExpressRouteConnectionRoutingArgs']]:
        """
        A `routing` block as defined below.
        """
        return pulumi.get(self, "routing")

    @routing.setter
    def routing(self, value: Optional[pulumi.Input['ExpressRouteConnectionRoutingArgs']]):
        pulumi.set(self, "routing", value)

    @_builtins.property
    @pulumi.getter(name="routingWeight")
    def routing_weight(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The routing weight associated to the Express Route Connection. Possible value is between `0` and `32000`. Defaults to `0`.
        """
        return pulumi.get(self, "routing_weight")

    @routing_weight.setter
    def routing_weight(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "routing_weight", value)


@pulumi.input_type
class _ExpressRouteConnectionState:
    def __init__(__self__, *,
                 authorization_key: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_internet_security: Optional[pulumi.Input[_builtins.bool]] = None,
                 express_route_circuit_peering_id: Optional[pulumi.Input[_builtins.str]] = None,
                 express_route_gateway_bypass_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 express_route_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_fast_path_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 routing: Optional[pulumi.Input['ExpressRouteConnectionRoutingArgs']] = None,
                 routing_weight: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering ExpressRouteConnection resources.
        :param pulumi.Input[_builtins.str] authorization_key: The authorization key to establish the Express Route Connection.
        :param pulumi.Input[_builtins.bool] enable_internet_security: Is Internet security enabled for this Express Route Connection?
        :param pulumi.Input[_builtins.str] express_route_circuit_peering_id: The ID of the Express Route Circuit Peering that this Express Route Connection connects with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] express_route_gateway_bypass_enabled: Specified whether Fast Path is enabled for Virtual Wan Firewall Hub. Defaults to `false`.
        :param pulumi.Input[_builtins.str] express_route_gateway_id: The ID of the Express Route Gateway that this Express Route Connection connects with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Express Route Connection. Changing this forces a new resource to be created.
        :param pulumi.Input['ExpressRouteConnectionRoutingArgs'] routing: A `routing` block as defined below.
        :param pulumi.Input[_builtins.int] routing_weight: The routing weight associated to the Express Route Connection. Possible value is between `0` and `32000`. Defaults to `0`.
        """
        if authorization_key is not None:
            pulumi.set(__self__, "authorization_key", authorization_key)
        if enable_internet_security is not None:
            pulumi.set(__self__, "enable_internet_security", enable_internet_security)
        if express_route_circuit_peering_id is not None:
            pulumi.set(__self__, "express_route_circuit_peering_id", express_route_circuit_peering_id)
        if express_route_gateway_bypass_enabled is not None:
            pulumi.set(__self__, "express_route_gateway_bypass_enabled", express_route_gateway_bypass_enabled)
        if express_route_gateway_id is not None:
            pulumi.set(__self__, "express_route_gateway_id", express_route_gateway_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_link_fast_path_enabled is not None:
            warnings.warn("""'private_link_fast_path_enabled' has been deprecated as it is no longer supported by the resource and will be removed in v5.0 of the AzureRM Provider""", DeprecationWarning)
            pulumi.log.warn("""private_link_fast_path_enabled is deprecated: 'private_link_fast_path_enabled' has been deprecated as it is no longer supported by the resource and will be removed in v5.0 of the AzureRM Provider""")
        if private_link_fast_path_enabled is not None:
            pulumi.set(__self__, "private_link_fast_path_enabled", private_link_fast_path_enabled)
        if routing is not None:
            pulumi.set(__self__, "routing", routing)
        if routing_weight is not None:
            pulumi.set(__self__, "routing_weight", routing_weight)

    @_builtins.property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authorization key to establish the Express Route Connection.
        """
        return pulumi.get(self, "authorization_key")

    @authorization_key.setter
    def authorization_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorization_key", value)

    @_builtins.property
    @pulumi.getter(name="enableInternetSecurity")
    def enable_internet_security(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Internet security enabled for this Express Route Connection?
        """
        return pulumi.get(self, "enable_internet_security")

    @enable_internet_security.setter
    def enable_internet_security(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_internet_security", value)

    @_builtins.property
    @pulumi.getter(name="expressRouteCircuitPeeringId")
    def express_route_circuit_peering_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Express Route Circuit Peering that this Express Route Connection connects with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "express_route_circuit_peering_id")

    @express_route_circuit_peering_id.setter
    def express_route_circuit_peering_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "express_route_circuit_peering_id", value)

    @_builtins.property
    @pulumi.getter(name="expressRouteGatewayBypassEnabled")
    def express_route_gateway_bypass_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specified whether Fast Path is enabled for Virtual Wan Firewall Hub. Defaults to `false`.
        """
        return pulumi.get(self, "express_route_gateway_bypass_enabled")

    @express_route_gateway_bypass_enabled.setter
    def express_route_gateway_bypass_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "express_route_gateway_bypass_enabled", value)

    @_builtins.property
    @pulumi.getter(name="expressRouteGatewayId")
    def express_route_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Express Route Gateway that this Express Route Connection connects with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "express_route_gateway_id")

    @express_route_gateway_id.setter
    def express_route_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "express_route_gateway_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Express Route Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkFastPathEnabled")
    @_utilities.deprecated("""'private_link_fast_path_enabled' has been deprecated as it is no longer supported by the resource and will be removed in v5.0 of the AzureRM Provider""")
    def private_link_fast_path_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "private_link_fast_path_enabled")

    @private_link_fast_path_enabled.setter
    def private_link_fast_path_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_link_fast_path_enabled", value)

    @_builtins.property
    @pulumi.getter
    def routing(self) -> Optional[pulumi.Input['ExpressRouteConnectionRoutingArgs']]:
        """
        A `routing` block as defined below.
        """
        return pulumi.get(self, "routing")

    @routing.setter
    def routing(self, value: Optional[pulumi.Input['ExpressRouteConnectionRoutingArgs']]):
        pulumi.set(self, "routing", value)

    @_builtins.property
    @pulumi.getter(name="routingWeight")
    def routing_weight(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The routing weight associated to the Express Route Connection. Possible value is between `0` and `32000`. Defaults to `0`.
        """
        return pulumi.get(self, "routing_weight")

    @routing_weight.setter
    def routing_weight(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "routing_weight", value)


@pulumi.type_token("azure:network/expressRouteConnection:ExpressRouteConnection")
class ExpressRouteConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_key: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_internet_security: Optional[pulumi.Input[_builtins.bool]] = None,
                 express_route_circuit_peering_id: Optional[pulumi.Input[_builtins.str]] = None,
                 express_route_gateway_bypass_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 express_route_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_fast_path_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 routing: Optional[pulumi.Input[Union['ExpressRouteConnectionRoutingArgs', 'ExpressRouteConnectionRoutingArgsDict']]] = None,
                 routing_weight: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages an Express Route Connection.

        > **Note:** The provider status of the Express Route Circuit must be set as provisioned while creating the Express Route Connection. See more details [here](https://docs.microsoft.com/azure/expressroute/expressroute-howto-circuit-portal-resource-manager#send-the-service-key-to-your-connectivity-provider-for-provisioning).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_wan = azure.network.VirtualWan("example",
            name="example-vwan",
            resource_group_name=example.name,
            location=example.location)
        example_virtual_hub = azure.network.VirtualHub("example",
            name="example-vhub",
            resource_group_name=example.name,
            location=example.location,
            virtual_wan_id=example_virtual_wan.id,
            address_prefix="10.0.1.0/24")
        example_express_route_gateway = azure.network.ExpressRouteGateway("example",
            name="example-expressroutegateway",
            resource_group_name=example.name,
            location=example.location,
            virtual_hub_id=example_virtual_hub.id,
            scale_units=1)
        example_express_route_port = azure.network.ExpressRoutePort("example",
            name="example-erp",
            resource_group_name=example.name,
            location=example.location,
            peering_location="Equinix-Seattle-SE2",
            bandwidth_in_gbps=10,
            encapsulation="Dot1Q")
        example_express_route_circuit = azure.network.ExpressRouteCircuit("example",
            name="example-erc",
            location=example.location,
            resource_group_name=example.name,
            express_route_port_id=example_express_route_port.id,
            bandwidth_in_gbps=5,
            sku={
                "tier": "Standard",
                "family": "MeteredData",
            })
        example_express_route_circuit_peering = azure.network.ExpressRouteCircuitPeering("example",
            peering_type="AzurePrivatePeering",
            express_route_circuit_name=example_express_route_circuit.name,
            resource_group_name=example.name,
            shared_key="ItsASecret",
            peer_asn=100,
            primary_peer_address_prefix="192.168.1.0/30",
            secondary_peer_address_prefix="192.168.2.0/30",
            vlan_id=100)
        example_express_route_connection = azure.network.ExpressRouteConnection("example",
            name="example-expressrouteconn",
            express_route_gateway_id=example_express_route_gateway.id,
            express_route_circuit_peering_id=example_express_route_circuit_peering.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2024-05-01

        ## Import

        Express Route Connections can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/expressRouteConnection:ExpressRouteConnection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/expressRouteGateways/expressRouteGateway1/expressRouteConnections/connection1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authorization_key: The authorization key to establish the Express Route Connection.
        :param pulumi.Input[_builtins.bool] enable_internet_security: Is Internet security enabled for this Express Route Connection?
        :param pulumi.Input[_builtins.str] express_route_circuit_peering_id: The ID of the Express Route Circuit Peering that this Express Route Connection connects with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] express_route_gateway_bypass_enabled: Specified whether Fast Path is enabled for Virtual Wan Firewall Hub. Defaults to `false`.
        :param pulumi.Input[_builtins.str] express_route_gateway_id: The ID of the Express Route Gateway that this Express Route Connection connects with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Express Route Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ExpressRouteConnectionRoutingArgs', 'ExpressRouteConnectionRoutingArgsDict']] routing: A `routing` block as defined below.
        :param pulumi.Input[_builtins.int] routing_weight: The routing weight associated to the Express Route Connection. Possible value is between `0` and `32000`. Defaults to `0`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExpressRouteConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Express Route Connection.

        > **Note:** The provider status of the Express Route Circuit must be set as provisioned while creating the Express Route Connection. See more details [here](https://docs.microsoft.com/azure/expressroute/expressroute-howto-circuit-portal-resource-manager#send-the-service-key-to-your-connectivity-provider-for-provisioning).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_wan = azure.network.VirtualWan("example",
            name="example-vwan",
            resource_group_name=example.name,
            location=example.location)
        example_virtual_hub = azure.network.VirtualHub("example",
            name="example-vhub",
            resource_group_name=example.name,
            location=example.location,
            virtual_wan_id=example_virtual_wan.id,
            address_prefix="10.0.1.0/24")
        example_express_route_gateway = azure.network.ExpressRouteGateway("example",
            name="example-expressroutegateway",
            resource_group_name=example.name,
            location=example.location,
            virtual_hub_id=example_virtual_hub.id,
            scale_units=1)
        example_express_route_port = azure.network.ExpressRoutePort("example",
            name="example-erp",
            resource_group_name=example.name,
            location=example.location,
            peering_location="Equinix-Seattle-SE2",
            bandwidth_in_gbps=10,
            encapsulation="Dot1Q")
        example_express_route_circuit = azure.network.ExpressRouteCircuit("example",
            name="example-erc",
            location=example.location,
            resource_group_name=example.name,
            express_route_port_id=example_express_route_port.id,
            bandwidth_in_gbps=5,
            sku={
                "tier": "Standard",
                "family": "MeteredData",
            })
        example_express_route_circuit_peering = azure.network.ExpressRouteCircuitPeering("example",
            peering_type="AzurePrivatePeering",
            express_route_circuit_name=example_express_route_circuit.name,
            resource_group_name=example.name,
            shared_key="ItsASecret",
            peer_asn=100,
            primary_peer_address_prefix="192.168.1.0/30",
            secondary_peer_address_prefix="192.168.2.0/30",
            vlan_id=100)
        example_express_route_connection = azure.network.ExpressRouteConnection("example",
            name="example-expressrouteconn",
            express_route_gateway_id=example_express_route_gateway.id,
            express_route_circuit_peering_id=example_express_route_circuit_peering.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2024-05-01

        ## Import

        Express Route Connections can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/expressRouteConnection:ExpressRouteConnection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/expressRouteGateways/expressRouteGateway1/expressRouteConnections/connection1
        ```

        :param str resource_name: The name of the resource.
        :param ExpressRouteConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExpressRouteConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_key: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_internet_security: Optional[pulumi.Input[_builtins.bool]] = None,
                 express_route_circuit_peering_id: Optional[pulumi.Input[_builtins.str]] = None,
                 express_route_gateway_bypass_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 express_route_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_fast_path_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 routing: Optional[pulumi.Input[Union['ExpressRouteConnectionRoutingArgs', 'ExpressRouteConnectionRoutingArgsDict']]] = None,
                 routing_weight: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExpressRouteConnectionArgs.__new__(ExpressRouteConnectionArgs)

            __props__.__dict__["authorization_key"] = authorization_key
            __props__.__dict__["enable_internet_security"] = enable_internet_security
            if express_route_circuit_peering_id is None and not opts.urn:
                raise TypeError("Missing required property 'express_route_circuit_peering_id'")
            __props__.__dict__["express_route_circuit_peering_id"] = express_route_circuit_peering_id
            __props__.__dict__["express_route_gateway_bypass_enabled"] = express_route_gateway_bypass_enabled
            if express_route_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'express_route_gateway_id'")
            __props__.__dict__["express_route_gateway_id"] = express_route_gateway_id
            __props__.__dict__["name"] = name
            __props__.__dict__["private_link_fast_path_enabled"] = private_link_fast_path_enabled
            __props__.__dict__["routing"] = routing
            __props__.__dict__["routing_weight"] = routing_weight
        super(ExpressRouteConnection, __self__).__init__(
            'azure:network/expressRouteConnection:ExpressRouteConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorization_key: Optional[pulumi.Input[_builtins.str]] = None,
            enable_internet_security: Optional[pulumi.Input[_builtins.bool]] = None,
            express_route_circuit_peering_id: Optional[pulumi.Input[_builtins.str]] = None,
            express_route_gateway_bypass_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            express_route_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_link_fast_path_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            routing: Optional[pulumi.Input[Union['ExpressRouteConnectionRoutingArgs', 'ExpressRouteConnectionRoutingArgsDict']]] = None,
            routing_weight: Optional[pulumi.Input[_builtins.int]] = None) -> 'ExpressRouteConnection':
        """
        Get an existing ExpressRouteConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authorization_key: The authorization key to establish the Express Route Connection.
        :param pulumi.Input[_builtins.bool] enable_internet_security: Is Internet security enabled for this Express Route Connection?
        :param pulumi.Input[_builtins.str] express_route_circuit_peering_id: The ID of the Express Route Circuit Peering that this Express Route Connection connects with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] express_route_gateway_bypass_enabled: Specified whether Fast Path is enabled for Virtual Wan Firewall Hub. Defaults to `false`.
        :param pulumi.Input[_builtins.str] express_route_gateway_id: The ID of the Express Route Gateway that this Express Route Connection connects with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Express Route Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ExpressRouteConnectionRoutingArgs', 'ExpressRouteConnectionRoutingArgsDict']] routing: A `routing` block as defined below.
        :param pulumi.Input[_builtins.int] routing_weight: The routing weight associated to the Express Route Connection. Possible value is between `0` and `32000`. Defaults to `0`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExpressRouteConnectionState.__new__(_ExpressRouteConnectionState)

        __props__.__dict__["authorization_key"] = authorization_key
        __props__.__dict__["enable_internet_security"] = enable_internet_security
        __props__.__dict__["express_route_circuit_peering_id"] = express_route_circuit_peering_id
        __props__.__dict__["express_route_gateway_bypass_enabled"] = express_route_gateway_bypass_enabled
        __props__.__dict__["express_route_gateway_id"] = express_route_gateway_id
        __props__.__dict__["name"] = name
        __props__.__dict__["private_link_fast_path_enabled"] = private_link_fast_path_enabled
        __props__.__dict__["routing"] = routing
        __props__.__dict__["routing_weight"] = routing_weight
        return ExpressRouteConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The authorization key to establish the Express Route Connection.
        """
        return pulumi.get(self, "authorization_key")

    @_builtins.property
    @pulumi.getter(name="enableInternetSecurity")
    def enable_internet_security(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is Internet security enabled for this Express Route Connection?
        """
        return pulumi.get(self, "enable_internet_security")

    @_builtins.property
    @pulumi.getter(name="expressRouteCircuitPeeringId")
    def express_route_circuit_peering_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Express Route Circuit Peering that this Express Route Connection connects with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "express_route_circuit_peering_id")

    @_builtins.property
    @pulumi.getter(name="expressRouteGatewayBypassEnabled")
    def express_route_gateway_bypass_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specified whether Fast Path is enabled for Virtual Wan Firewall Hub. Defaults to `false`.
        """
        return pulumi.get(self, "express_route_gateway_bypass_enabled")

    @_builtins.property
    @pulumi.getter(name="expressRouteGatewayId")
    def express_route_gateway_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Express Route Gateway that this Express Route Connection connects with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "express_route_gateway_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Express Route Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateLinkFastPathEnabled")
    @_utilities.deprecated("""'private_link_fast_path_enabled' has been deprecated as it is no longer supported by the resource and will be removed in v5.0 of the AzureRM Provider""")
    def private_link_fast_path_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "private_link_fast_path_enabled")

    @_builtins.property
    @pulumi.getter
    def routing(self) -> pulumi.Output['outputs.ExpressRouteConnectionRouting']:
        """
        A `routing` block as defined below.
        """
        return pulumi.get(self, "routing")

    @_builtins.property
    @pulumi.getter(name="routingWeight")
    def routing_weight(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The routing weight associated to the Express Route Connection. Possible value is between `0` and `32000`. Defaults to `0`.
        """
        return pulumi.get(self, "routing_weight")

