# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VirtualNetworkGatewayConnectionArgs', 'VirtualNetworkGatewayConnection']

@pulumi.input_type
class VirtualNetworkGatewayConnectionArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 virtual_network_gateway_id: pulumi.Input[_builtins.str],
                 authorization_key: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_bgp_addresses: Optional[pulumi.Input['VirtualNetworkGatewayConnectionCustomBgpAddressesArgs']] = None,
                 dpd_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 egress_nat_rule_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable_bgp: Optional[pulumi.Input[_builtins.bool]] = None,
                 express_route_circuit_id: Optional[pulumi.Input[_builtins.str]] = None,
                 express_route_gateway_bypass: Optional[pulumi.Input[_builtins.bool]] = None,
                 ingress_nat_rule_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipsec_policy: Optional[pulumi.Input['VirtualNetworkGatewayConnectionIpsecPolicyArgs']] = None,
                 local_azure_ip_address_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 local_network_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_virtual_network_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_fast_path_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 routing_weight: Optional[pulumi.Input[_builtins.int]] = None,
                 shared_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 traffic_selector_policy: Optional[pulumi.Input['VirtualNetworkGatewayConnectionTrafficSelectorPolicyArgs']] = None,
                 use_policy_based_traffic_selectors: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a VirtualNetworkGatewayConnection resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the connection Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type: The type of connection. Valid options are `IPsec` (Site-to-Site), `ExpressRoute` (ExpressRoute), and `Vnet2Vnet` (VNet-to-VNet). Each connection type requires different mandatory arguments (refer to the examples above). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_network_gateway_id: The ID of the Virtual Network Gateway in which the connection will be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] authorization_key: The authorization key associated with the Express Route Circuit. This field is required only if the type is an ExpressRoute connection.
        :param pulumi.Input[_builtins.str] connection_mode: Connection mode to use. Possible values are `Default`, `InitiatorOnly` and `ResponderOnly`. Defaults to `Default`. Changing this value will force a resource to be created.
        :param pulumi.Input[_builtins.str] connection_protocol: The IKE protocol version to use. Possible values are `IKEv1` and `IKEv2`, values are `IKEv1` and `IKEv2`. Defaults to `IKEv2`. Changing this forces a new resource to be created.
               > **Note:** Only valid for `IPSec` connections on virtual network gateways with SKU `VpnGw1`, `VpnGw2`, `VpnGw3`, `VpnGw1AZ`, `VpnGw2AZ` or `VpnGw3AZ`.
        :param pulumi.Input['VirtualNetworkGatewayConnectionCustomBgpAddressesArgs'] custom_bgp_addresses: A `custom_bgp_addresses` block which is documented below.
               The block can only be used on `IPSec` / `activeactive` connections,
               For details about see [the relevant section in the Azure documentation](https://docs.microsoft.com/en-us/azure/vpn-gateway/vpn-gateway-howto-aws-bgp).
        :param pulumi.Input[_builtins.int] dpd_timeout_seconds: The dead peer detection timeout of this connection in seconds. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] egress_nat_rule_ids: A list of the egress NAT Rule Ids.
        :param pulumi.Input[_builtins.bool] enable_bgp: If `true`, BGP (Border Gateway Protocol) is enabled for this connection. Defaults to `false`.
        :param pulumi.Input[_builtins.str] express_route_circuit_id: The ID of the Express Route Circuit when creating an ExpressRoute connection (i.e. when `type` is `ExpressRoute`). The Express Route Circuit can be in the same or in a different subscription. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] express_route_gateway_bypass: If `true`, data packets will bypass ExpressRoute Gateway for data forwarding This is only valid for ExpressRoute connections.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ingress_nat_rule_ids: A list of the ingress NAT Rule Ids.
        :param pulumi.Input['VirtualNetworkGatewayConnectionIpsecPolicyArgs'] ipsec_policy: A `ipsec_policy` block which is documented below.
               Only a single policy can be defined for a connection. For details on
               custom policies refer to [the relevant section in the Azure documentation](https://docs.microsoft.com/azure/vpn-gateway/vpn-gateway-ipsecikepolicy-rm-powershell).
        :param pulumi.Input[_builtins.bool] local_azure_ip_address_enabled: Use private local Azure IP for the connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] local_network_gateway_id: The ID of the local network gateway when creating Site-to-Site connection (i.e. when `type` is `IPsec`).
        :param pulumi.Input[_builtins.str] location: The location/region where the connection is located. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the connection. Changing the name forces a new resource to be created.
        :param pulumi.Input[_builtins.str] peer_virtual_network_gateway_id: The ID of the peer virtual network gateway when creating a VNet-to-VNet connection (i.e. when `type` is `Vnet2Vnet`). The peer Virtual Network Gateway can be in the same or in a different subscription. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] private_link_fast_path_enabled: Bypass the Express Route gateway when accessing private-links. When enabled `express_route_gateway_bypass` must be set to `true`. Defaults to `false`.
        :param pulumi.Input[_builtins.int] routing_weight: The routing weight. Defaults to `10`.
        :param pulumi.Input[_builtins.str] shared_key: The shared IPSec key. A key could be provided if a Site-to-Site, VNet-to-VNet or ExpressRoute connection is created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input['VirtualNetworkGatewayConnectionTrafficSelectorPolicyArgs'] traffic_selector_policy: One or more `traffic_selector_policy` blocks which are documented below.
               A `traffic_selector_policy` allows to specify a traffic selector policy proposal to be used in a virtual network gateway connection.
               For details about traffic selectors refer to [the relevant section in the Azure documentation](https://docs.microsoft.com/azure/vpn-gateway/vpn-gateway-connect-multiple-policybased-rm-ps).
        :param pulumi.Input[_builtins.bool] use_policy_based_traffic_selectors: If `true`, policy-based traffic selectors are enabled for this connection. Enabling policy-based traffic selectors requires an `ipsec_policy` block. Defaults to `false`.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "virtual_network_gateway_id", virtual_network_gateway_id)
        if authorization_key is not None:
            pulumi.set(__self__, "authorization_key", authorization_key)
        if connection_mode is not None:
            pulumi.set(__self__, "connection_mode", connection_mode)
        if connection_protocol is not None:
            pulumi.set(__self__, "connection_protocol", connection_protocol)
        if custom_bgp_addresses is not None:
            pulumi.set(__self__, "custom_bgp_addresses", custom_bgp_addresses)
        if dpd_timeout_seconds is not None:
            pulumi.set(__self__, "dpd_timeout_seconds", dpd_timeout_seconds)
        if egress_nat_rule_ids is not None:
            pulumi.set(__self__, "egress_nat_rule_ids", egress_nat_rule_ids)
        if enable_bgp is not None:
            pulumi.set(__self__, "enable_bgp", enable_bgp)
        if express_route_circuit_id is not None:
            pulumi.set(__self__, "express_route_circuit_id", express_route_circuit_id)
        if express_route_gateway_bypass is not None:
            pulumi.set(__self__, "express_route_gateway_bypass", express_route_gateway_bypass)
        if ingress_nat_rule_ids is not None:
            pulumi.set(__self__, "ingress_nat_rule_ids", ingress_nat_rule_ids)
        if ipsec_policy is not None:
            pulumi.set(__self__, "ipsec_policy", ipsec_policy)
        if local_azure_ip_address_enabled is not None:
            pulumi.set(__self__, "local_azure_ip_address_enabled", local_azure_ip_address_enabled)
        if local_network_gateway_id is not None:
            pulumi.set(__self__, "local_network_gateway_id", local_network_gateway_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_virtual_network_gateway_id is not None:
            pulumi.set(__self__, "peer_virtual_network_gateway_id", peer_virtual_network_gateway_id)
        if private_link_fast_path_enabled is not None:
            pulumi.set(__self__, "private_link_fast_path_enabled", private_link_fast_path_enabled)
        if routing_weight is not None:
            pulumi.set(__self__, "routing_weight", routing_weight)
        if shared_key is not None:
            pulumi.set(__self__, "shared_key", shared_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if traffic_selector_policy is not None:
            pulumi.set(__self__, "traffic_selector_policy", traffic_selector_policy)
        if use_policy_based_traffic_selectors is not None:
            pulumi.set(__self__, "use_policy_based_traffic_selectors", use_policy_based_traffic_selectors)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the connection Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of connection. Valid options are `IPsec` (Site-to-Site), `ExpressRoute` (ExpressRoute), and `Vnet2Vnet` (VNet-to-VNet). Each connection type requires different mandatory arguments (refer to the examples above). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkGatewayId")
    def virtual_network_gateway_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Virtual Network Gateway in which the connection will be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_network_gateway_id")

    @virtual_network_gateway_id.setter
    def virtual_network_gateway_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "virtual_network_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authorization key associated with the Express Route Circuit. This field is required only if the type is an ExpressRoute connection.
        """
        return pulumi.get(self, "authorization_key")

    @authorization_key.setter
    def authorization_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorization_key", value)

    @_builtins.property
    @pulumi.getter(name="connectionMode")
    def connection_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Connection mode to use. Possible values are `Default`, `InitiatorOnly` and `ResponderOnly`. Defaults to `Default`. Changing this value will force a resource to be created.
        """
        return pulumi.get(self, "connection_mode")

    @connection_mode.setter
    def connection_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_mode", value)

    @_builtins.property
    @pulumi.getter(name="connectionProtocol")
    def connection_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IKE protocol version to use. Possible values are `IKEv1` and `IKEv2`, values are `IKEv1` and `IKEv2`. Defaults to `IKEv2`. Changing this forces a new resource to be created.
        > **Note:** Only valid for `IPSec` connections on virtual network gateways with SKU `VpnGw1`, `VpnGw2`, `VpnGw3`, `VpnGw1AZ`, `VpnGw2AZ` or `VpnGw3AZ`.
        """
        return pulumi.get(self, "connection_protocol")

    @connection_protocol.setter
    def connection_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_protocol", value)

    @_builtins.property
    @pulumi.getter(name="customBgpAddresses")
    def custom_bgp_addresses(self) -> Optional[pulumi.Input['VirtualNetworkGatewayConnectionCustomBgpAddressesArgs']]:
        """
        A `custom_bgp_addresses` block which is documented below.
        The block can only be used on `IPSec` / `activeactive` connections,
        For details about see [the relevant section in the Azure documentation](https://docs.microsoft.com/en-us/azure/vpn-gateway/vpn-gateway-howto-aws-bgp).
        """
        return pulumi.get(self, "custom_bgp_addresses")

    @custom_bgp_addresses.setter
    def custom_bgp_addresses(self, value: Optional[pulumi.Input['VirtualNetworkGatewayConnectionCustomBgpAddressesArgs']]):
        pulumi.set(self, "custom_bgp_addresses", value)

    @_builtins.property
    @pulumi.getter(name="dpdTimeoutSeconds")
    def dpd_timeout_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The dead peer detection timeout of this connection in seconds. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dpd_timeout_seconds")

    @dpd_timeout_seconds.setter
    def dpd_timeout_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "dpd_timeout_seconds", value)

    @_builtins.property
    @pulumi.getter(name="egressNatRuleIds")
    def egress_nat_rule_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the egress NAT Rule Ids.
        """
        return pulumi.get(self, "egress_nat_rule_ids")

    @egress_nat_rule_ids.setter
    def egress_nat_rule_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "egress_nat_rule_ids", value)

    @_builtins.property
    @pulumi.getter(name="enableBgp")
    def enable_bgp(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, BGP (Border Gateway Protocol) is enabled for this connection. Defaults to `false`.
        """
        return pulumi.get(self, "enable_bgp")

    @enable_bgp.setter
    def enable_bgp(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_bgp", value)

    @_builtins.property
    @pulumi.getter(name="expressRouteCircuitId")
    def express_route_circuit_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Express Route Circuit when creating an ExpressRoute connection (i.e. when `type` is `ExpressRoute`). The Express Route Circuit can be in the same or in a different subscription. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "express_route_circuit_id")

    @express_route_circuit_id.setter
    def express_route_circuit_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "express_route_circuit_id", value)

    @_builtins.property
    @pulumi.getter(name="expressRouteGatewayBypass")
    def express_route_gateway_bypass(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, data packets will bypass ExpressRoute Gateway for data forwarding This is only valid for ExpressRoute connections.
        """
        return pulumi.get(self, "express_route_gateway_bypass")

    @express_route_gateway_bypass.setter
    def express_route_gateway_bypass(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "express_route_gateway_bypass", value)

    @_builtins.property
    @pulumi.getter(name="ingressNatRuleIds")
    def ingress_nat_rule_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the ingress NAT Rule Ids.
        """
        return pulumi.get(self, "ingress_nat_rule_ids")

    @ingress_nat_rule_ids.setter
    def ingress_nat_rule_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ingress_nat_rule_ids", value)

    @_builtins.property
    @pulumi.getter(name="ipsecPolicy")
    def ipsec_policy(self) -> Optional[pulumi.Input['VirtualNetworkGatewayConnectionIpsecPolicyArgs']]:
        """
        A `ipsec_policy` block which is documented below.
        Only a single policy can be defined for a connection. For details on
        custom policies refer to [the relevant section in the Azure documentation](https://docs.microsoft.com/azure/vpn-gateway/vpn-gateway-ipsecikepolicy-rm-powershell).
        """
        return pulumi.get(self, "ipsec_policy")

    @ipsec_policy.setter
    def ipsec_policy(self, value: Optional[pulumi.Input['VirtualNetworkGatewayConnectionIpsecPolicyArgs']]):
        pulumi.set(self, "ipsec_policy", value)

    @_builtins.property
    @pulumi.getter(name="localAzureIpAddressEnabled")
    def local_azure_ip_address_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use private local Azure IP for the connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "local_azure_ip_address_enabled")

    @local_azure_ip_address_enabled.setter
    def local_azure_ip_address_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_azure_ip_address_enabled", value)

    @_builtins.property
    @pulumi.getter(name="localNetworkGatewayId")
    def local_network_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the local network gateway when creating Site-to-Site connection (i.e. when `type` is `IPsec`).
        """
        return pulumi.get(self, "local_network_gateway_id")

    @local_network_gateway_id.setter
    def local_network_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_network_gateway_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location/region where the connection is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the connection. Changing the name forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="peerVirtualNetworkGatewayId")
    def peer_virtual_network_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the peer virtual network gateway when creating a VNet-to-VNet connection (i.e. when `type` is `Vnet2Vnet`). The peer Virtual Network Gateway can be in the same or in a different subscription. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "peer_virtual_network_gateway_id")

    @peer_virtual_network_gateway_id.setter
    def peer_virtual_network_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_virtual_network_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkFastPathEnabled")
    def private_link_fast_path_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Bypass the Express Route gateway when accessing private-links. When enabled `express_route_gateway_bypass` must be set to `true`. Defaults to `false`.
        """
        return pulumi.get(self, "private_link_fast_path_enabled")

    @private_link_fast_path_enabled.setter
    def private_link_fast_path_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_link_fast_path_enabled", value)

    @_builtins.property
    @pulumi.getter(name="routingWeight")
    def routing_weight(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The routing weight. Defaults to `10`.
        """
        return pulumi.get(self, "routing_weight")

    @routing_weight.setter
    def routing_weight(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "routing_weight", value)

    @_builtins.property
    @pulumi.getter(name="sharedKey")
    def shared_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The shared IPSec key. A key could be provided if a Site-to-Site, VNet-to-VNet or ExpressRoute connection is created.
        """
        return pulumi.get(self, "shared_key")

    @shared_key.setter
    def shared_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shared_key", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="trafficSelectorPolicy")
    def traffic_selector_policy(self) -> Optional[pulumi.Input['VirtualNetworkGatewayConnectionTrafficSelectorPolicyArgs']]:
        """
        One or more `traffic_selector_policy` blocks which are documented below.
        A `traffic_selector_policy` allows to specify a traffic selector policy proposal to be used in a virtual network gateway connection.
        For details about traffic selectors refer to [the relevant section in the Azure documentation](https://docs.microsoft.com/azure/vpn-gateway/vpn-gateway-connect-multiple-policybased-rm-ps).
        """
        return pulumi.get(self, "traffic_selector_policy")

    @traffic_selector_policy.setter
    def traffic_selector_policy(self, value: Optional[pulumi.Input['VirtualNetworkGatewayConnectionTrafficSelectorPolicyArgs']]):
        pulumi.set(self, "traffic_selector_policy", value)

    @_builtins.property
    @pulumi.getter(name="usePolicyBasedTrafficSelectors")
    def use_policy_based_traffic_selectors(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, policy-based traffic selectors are enabled for this connection. Enabling policy-based traffic selectors requires an `ipsec_policy` block. Defaults to `false`.
        """
        return pulumi.get(self, "use_policy_based_traffic_selectors")

    @use_policy_based_traffic_selectors.setter
    def use_policy_based_traffic_selectors(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_policy_based_traffic_selectors", value)


@pulumi.input_type
class _VirtualNetworkGatewayConnectionState:
    def __init__(__self__, *,
                 authorization_key: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_bgp_addresses: Optional[pulumi.Input['VirtualNetworkGatewayConnectionCustomBgpAddressesArgs']] = None,
                 dpd_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 egress_nat_rule_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable_bgp: Optional[pulumi.Input[_builtins.bool]] = None,
                 express_route_circuit_id: Optional[pulumi.Input[_builtins.str]] = None,
                 express_route_gateway_bypass: Optional[pulumi.Input[_builtins.bool]] = None,
                 ingress_nat_rule_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipsec_policy: Optional[pulumi.Input['VirtualNetworkGatewayConnectionIpsecPolicyArgs']] = None,
                 local_azure_ip_address_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 local_network_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_virtual_network_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_fast_path_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_weight: Optional[pulumi.Input[_builtins.int]] = None,
                 shared_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 traffic_selector_policy: Optional[pulumi.Input['VirtualNetworkGatewayConnectionTrafficSelectorPolicyArgs']] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 use_policy_based_traffic_selectors: Optional[pulumi.Input[_builtins.bool]] = None,
                 virtual_network_gateway_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering VirtualNetworkGatewayConnection resources.
        :param pulumi.Input[_builtins.str] authorization_key: The authorization key associated with the Express Route Circuit. This field is required only if the type is an ExpressRoute connection.
        :param pulumi.Input[_builtins.str] connection_mode: Connection mode to use. Possible values are `Default`, `InitiatorOnly` and `ResponderOnly`. Defaults to `Default`. Changing this value will force a resource to be created.
        :param pulumi.Input[_builtins.str] connection_protocol: The IKE protocol version to use. Possible values are `IKEv1` and `IKEv2`, values are `IKEv1` and `IKEv2`. Defaults to `IKEv2`. Changing this forces a new resource to be created.
               > **Note:** Only valid for `IPSec` connections on virtual network gateways with SKU `VpnGw1`, `VpnGw2`, `VpnGw3`, `VpnGw1AZ`, `VpnGw2AZ` or `VpnGw3AZ`.
        :param pulumi.Input['VirtualNetworkGatewayConnectionCustomBgpAddressesArgs'] custom_bgp_addresses: A `custom_bgp_addresses` block which is documented below.
               The block can only be used on `IPSec` / `activeactive` connections,
               For details about see [the relevant section in the Azure documentation](https://docs.microsoft.com/en-us/azure/vpn-gateway/vpn-gateway-howto-aws-bgp).
        :param pulumi.Input[_builtins.int] dpd_timeout_seconds: The dead peer detection timeout of this connection in seconds. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] egress_nat_rule_ids: A list of the egress NAT Rule Ids.
        :param pulumi.Input[_builtins.bool] enable_bgp: If `true`, BGP (Border Gateway Protocol) is enabled for this connection. Defaults to `false`.
        :param pulumi.Input[_builtins.str] express_route_circuit_id: The ID of the Express Route Circuit when creating an ExpressRoute connection (i.e. when `type` is `ExpressRoute`). The Express Route Circuit can be in the same or in a different subscription. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] express_route_gateway_bypass: If `true`, data packets will bypass ExpressRoute Gateway for data forwarding This is only valid for ExpressRoute connections.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ingress_nat_rule_ids: A list of the ingress NAT Rule Ids.
        :param pulumi.Input['VirtualNetworkGatewayConnectionIpsecPolicyArgs'] ipsec_policy: A `ipsec_policy` block which is documented below.
               Only a single policy can be defined for a connection. For details on
               custom policies refer to [the relevant section in the Azure documentation](https://docs.microsoft.com/azure/vpn-gateway/vpn-gateway-ipsecikepolicy-rm-powershell).
        :param pulumi.Input[_builtins.bool] local_azure_ip_address_enabled: Use private local Azure IP for the connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] local_network_gateway_id: The ID of the local network gateway when creating Site-to-Site connection (i.e. when `type` is `IPsec`).
        :param pulumi.Input[_builtins.str] location: The location/region where the connection is located. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the connection. Changing the name forces a new resource to be created.
        :param pulumi.Input[_builtins.str] peer_virtual_network_gateway_id: The ID of the peer virtual network gateway when creating a VNet-to-VNet connection (i.e. when `type` is `Vnet2Vnet`). The peer Virtual Network Gateway can be in the same or in a different subscription. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] private_link_fast_path_enabled: Bypass the Express Route gateway when accessing private-links. When enabled `express_route_gateway_bypass` must be set to `true`. Defaults to `false`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the connection Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] routing_weight: The routing weight. Defaults to `10`.
        :param pulumi.Input[_builtins.str] shared_key: The shared IPSec key. A key could be provided if a Site-to-Site, VNet-to-VNet or ExpressRoute connection is created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input['VirtualNetworkGatewayConnectionTrafficSelectorPolicyArgs'] traffic_selector_policy: One or more `traffic_selector_policy` blocks which are documented below.
               A `traffic_selector_policy` allows to specify a traffic selector policy proposal to be used in a virtual network gateway connection.
               For details about traffic selectors refer to [the relevant section in the Azure documentation](https://docs.microsoft.com/azure/vpn-gateway/vpn-gateway-connect-multiple-policybased-rm-ps).
        :param pulumi.Input[_builtins.str] type: The type of connection. Valid options are `IPsec` (Site-to-Site), `ExpressRoute` (ExpressRoute), and `Vnet2Vnet` (VNet-to-VNet). Each connection type requires different mandatory arguments (refer to the examples above). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] use_policy_based_traffic_selectors: If `true`, policy-based traffic selectors are enabled for this connection. Enabling policy-based traffic selectors requires an `ipsec_policy` block. Defaults to `false`.
        :param pulumi.Input[_builtins.str] virtual_network_gateway_id: The ID of the Virtual Network Gateway in which the connection will be created. Changing this forces a new resource to be created.
        """
        if authorization_key is not None:
            pulumi.set(__self__, "authorization_key", authorization_key)
        if connection_mode is not None:
            pulumi.set(__self__, "connection_mode", connection_mode)
        if connection_protocol is not None:
            pulumi.set(__self__, "connection_protocol", connection_protocol)
        if custom_bgp_addresses is not None:
            pulumi.set(__self__, "custom_bgp_addresses", custom_bgp_addresses)
        if dpd_timeout_seconds is not None:
            pulumi.set(__self__, "dpd_timeout_seconds", dpd_timeout_seconds)
        if egress_nat_rule_ids is not None:
            pulumi.set(__self__, "egress_nat_rule_ids", egress_nat_rule_ids)
        if enable_bgp is not None:
            pulumi.set(__self__, "enable_bgp", enable_bgp)
        if express_route_circuit_id is not None:
            pulumi.set(__self__, "express_route_circuit_id", express_route_circuit_id)
        if express_route_gateway_bypass is not None:
            pulumi.set(__self__, "express_route_gateway_bypass", express_route_gateway_bypass)
        if ingress_nat_rule_ids is not None:
            pulumi.set(__self__, "ingress_nat_rule_ids", ingress_nat_rule_ids)
        if ipsec_policy is not None:
            pulumi.set(__self__, "ipsec_policy", ipsec_policy)
        if local_azure_ip_address_enabled is not None:
            pulumi.set(__self__, "local_azure_ip_address_enabled", local_azure_ip_address_enabled)
        if local_network_gateway_id is not None:
            pulumi.set(__self__, "local_network_gateway_id", local_network_gateway_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_virtual_network_gateway_id is not None:
            pulumi.set(__self__, "peer_virtual_network_gateway_id", peer_virtual_network_gateway_id)
        if private_link_fast_path_enabled is not None:
            pulumi.set(__self__, "private_link_fast_path_enabled", private_link_fast_path_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if routing_weight is not None:
            pulumi.set(__self__, "routing_weight", routing_weight)
        if shared_key is not None:
            pulumi.set(__self__, "shared_key", shared_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if traffic_selector_policy is not None:
            pulumi.set(__self__, "traffic_selector_policy", traffic_selector_policy)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if use_policy_based_traffic_selectors is not None:
            pulumi.set(__self__, "use_policy_based_traffic_selectors", use_policy_based_traffic_selectors)
        if virtual_network_gateway_id is not None:
            pulumi.set(__self__, "virtual_network_gateway_id", virtual_network_gateway_id)

    @_builtins.property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authorization key associated with the Express Route Circuit. This field is required only if the type is an ExpressRoute connection.
        """
        return pulumi.get(self, "authorization_key")

    @authorization_key.setter
    def authorization_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorization_key", value)

    @_builtins.property
    @pulumi.getter(name="connectionMode")
    def connection_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Connection mode to use. Possible values are `Default`, `InitiatorOnly` and `ResponderOnly`. Defaults to `Default`. Changing this value will force a resource to be created.
        """
        return pulumi.get(self, "connection_mode")

    @connection_mode.setter
    def connection_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_mode", value)

    @_builtins.property
    @pulumi.getter(name="connectionProtocol")
    def connection_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IKE protocol version to use. Possible values are `IKEv1` and `IKEv2`, values are `IKEv1` and `IKEv2`. Defaults to `IKEv2`. Changing this forces a new resource to be created.
        > **Note:** Only valid for `IPSec` connections on virtual network gateways with SKU `VpnGw1`, `VpnGw2`, `VpnGw3`, `VpnGw1AZ`, `VpnGw2AZ` or `VpnGw3AZ`.
        """
        return pulumi.get(self, "connection_protocol")

    @connection_protocol.setter
    def connection_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_protocol", value)

    @_builtins.property
    @pulumi.getter(name="customBgpAddresses")
    def custom_bgp_addresses(self) -> Optional[pulumi.Input['VirtualNetworkGatewayConnectionCustomBgpAddressesArgs']]:
        """
        A `custom_bgp_addresses` block which is documented below.
        The block can only be used on `IPSec` / `activeactive` connections,
        For details about see [the relevant section in the Azure documentation](https://docs.microsoft.com/en-us/azure/vpn-gateway/vpn-gateway-howto-aws-bgp).
        """
        return pulumi.get(self, "custom_bgp_addresses")

    @custom_bgp_addresses.setter
    def custom_bgp_addresses(self, value: Optional[pulumi.Input['VirtualNetworkGatewayConnectionCustomBgpAddressesArgs']]):
        pulumi.set(self, "custom_bgp_addresses", value)

    @_builtins.property
    @pulumi.getter(name="dpdTimeoutSeconds")
    def dpd_timeout_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The dead peer detection timeout of this connection in seconds. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dpd_timeout_seconds")

    @dpd_timeout_seconds.setter
    def dpd_timeout_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "dpd_timeout_seconds", value)

    @_builtins.property
    @pulumi.getter(name="egressNatRuleIds")
    def egress_nat_rule_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the egress NAT Rule Ids.
        """
        return pulumi.get(self, "egress_nat_rule_ids")

    @egress_nat_rule_ids.setter
    def egress_nat_rule_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "egress_nat_rule_ids", value)

    @_builtins.property
    @pulumi.getter(name="enableBgp")
    def enable_bgp(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, BGP (Border Gateway Protocol) is enabled for this connection. Defaults to `false`.
        """
        return pulumi.get(self, "enable_bgp")

    @enable_bgp.setter
    def enable_bgp(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_bgp", value)

    @_builtins.property
    @pulumi.getter(name="expressRouteCircuitId")
    def express_route_circuit_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Express Route Circuit when creating an ExpressRoute connection (i.e. when `type` is `ExpressRoute`). The Express Route Circuit can be in the same or in a different subscription. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "express_route_circuit_id")

    @express_route_circuit_id.setter
    def express_route_circuit_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "express_route_circuit_id", value)

    @_builtins.property
    @pulumi.getter(name="expressRouteGatewayBypass")
    def express_route_gateway_bypass(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, data packets will bypass ExpressRoute Gateway for data forwarding This is only valid for ExpressRoute connections.
        """
        return pulumi.get(self, "express_route_gateway_bypass")

    @express_route_gateway_bypass.setter
    def express_route_gateway_bypass(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "express_route_gateway_bypass", value)

    @_builtins.property
    @pulumi.getter(name="ingressNatRuleIds")
    def ingress_nat_rule_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the ingress NAT Rule Ids.
        """
        return pulumi.get(self, "ingress_nat_rule_ids")

    @ingress_nat_rule_ids.setter
    def ingress_nat_rule_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ingress_nat_rule_ids", value)

    @_builtins.property
    @pulumi.getter(name="ipsecPolicy")
    def ipsec_policy(self) -> Optional[pulumi.Input['VirtualNetworkGatewayConnectionIpsecPolicyArgs']]:
        """
        A `ipsec_policy` block which is documented below.
        Only a single policy can be defined for a connection. For details on
        custom policies refer to [the relevant section in the Azure documentation](https://docs.microsoft.com/azure/vpn-gateway/vpn-gateway-ipsecikepolicy-rm-powershell).
        """
        return pulumi.get(self, "ipsec_policy")

    @ipsec_policy.setter
    def ipsec_policy(self, value: Optional[pulumi.Input['VirtualNetworkGatewayConnectionIpsecPolicyArgs']]):
        pulumi.set(self, "ipsec_policy", value)

    @_builtins.property
    @pulumi.getter(name="localAzureIpAddressEnabled")
    def local_azure_ip_address_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Use private local Azure IP for the connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "local_azure_ip_address_enabled")

    @local_azure_ip_address_enabled.setter
    def local_azure_ip_address_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_azure_ip_address_enabled", value)

    @_builtins.property
    @pulumi.getter(name="localNetworkGatewayId")
    def local_network_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the local network gateway when creating Site-to-Site connection (i.e. when `type` is `IPsec`).
        """
        return pulumi.get(self, "local_network_gateway_id")

    @local_network_gateway_id.setter
    def local_network_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_network_gateway_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location/region where the connection is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the connection. Changing the name forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="peerVirtualNetworkGatewayId")
    def peer_virtual_network_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the peer virtual network gateway when creating a VNet-to-VNet connection (i.e. when `type` is `Vnet2Vnet`). The peer Virtual Network Gateway can be in the same or in a different subscription. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "peer_virtual_network_gateway_id")

    @peer_virtual_network_gateway_id.setter
    def peer_virtual_network_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_virtual_network_gateway_id", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkFastPathEnabled")
    def private_link_fast_path_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Bypass the Express Route gateway when accessing private-links. When enabled `express_route_gateway_bypass` must be set to `true`. Defaults to `false`.
        """
        return pulumi.get(self, "private_link_fast_path_enabled")

    @private_link_fast_path_enabled.setter
    def private_link_fast_path_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_link_fast_path_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the connection Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="routingWeight")
    def routing_weight(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The routing weight. Defaults to `10`.
        """
        return pulumi.get(self, "routing_weight")

    @routing_weight.setter
    def routing_weight(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "routing_weight", value)

    @_builtins.property
    @pulumi.getter(name="sharedKey")
    def shared_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The shared IPSec key. A key could be provided if a Site-to-Site, VNet-to-VNet or ExpressRoute connection is created.
        """
        return pulumi.get(self, "shared_key")

    @shared_key.setter
    def shared_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "shared_key", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="trafficSelectorPolicy")
    def traffic_selector_policy(self) -> Optional[pulumi.Input['VirtualNetworkGatewayConnectionTrafficSelectorPolicyArgs']]:
        """
        One or more `traffic_selector_policy` blocks which are documented below.
        A `traffic_selector_policy` allows to specify a traffic selector policy proposal to be used in a virtual network gateway connection.
        For details about traffic selectors refer to [the relevant section in the Azure documentation](https://docs.microsoft.com/azure/vpn-gateway/vpn-gateway-connect-multiple-policybased-rm-ps).
        """
        return pulumi.get(self, "traffic_selector_policy")

    @traffic_selector_policy.setter
    def traffic_selector_policy(self, value: Optional[pulumi.Input['VirtualNetworkGatewayConnectionTrafficSelectorPolicyArgs']]):
        pulumi.set(self, "traffic_selector_policy", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of connection. Valid options are `IPsec` (Site-to-Site), `ExpressRoute` (ExpressRoute), and `Vnet2Vnet` (VNet-to-VNet). Each connection type requires different mandatory arguments (refer to the examples above). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="usePolicyBasedTrafficSelectors")
    def use_policy_based_traffic_selectors(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, policy-based traffic selectors are enabled for this connection. Enabling policy-based traffic selectors requires an `ipsec_policy` block. Defaults to `false`.
        """
        return pulumi.get(self, "use_policy_based_traffic_selectors")

    @use_policy_based_traffic_selectors.setter
    def use_policy_based_traffic_selectors(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_policy_based_traffic_selectors", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkGatewayId")
    def virtual_network_gateway_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Virtual Network Gateway in which the connection will be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_network_gateway_id")

    @virtual_network_gateway_id.setter
    def virtual_network_gateway_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_gateway_id", value)


@pulumi.type_token("azure:network/virtualNetworkGatewayConnection:VirtualNetworkGatewayConnection")
class VirtualNetworkGatewayConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_key: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_bgp_addresses: Optional[pulumi.Input[Union['VirtualNetworkGatewayConnectionCustomBgpAddressesArgs', 'VirtualNetworkGatewayConnectionCustomBgpAddressesArgsDict']]] = None,
                 dpd_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 egress_nat_rule_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable_bgp: Optional[pulumi.Input[_builtins.bool]] = None,
                 express_route_circuit_id: Optional[pulumi.Input[_builtins.str]] = None,
                 express_route_gateway_bypass: Optional[pulumi.Input[_builtins.bool]] = None,
                 ingress_nat_rule_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipsec_policy: Optional[pulumi.Input[Union['VirtualNetworkGatewayConnectionIpsecPolicyArgs', 'VirtualNetworkGatewayConnectionIpsecPolicyArgsDict']]] = None,
                 local_azure_ip_address_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 local_network_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_virtual_network_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_fast_path_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_weight: Optional[pulumi.Input[_builtins.int]] = None,
                 shared_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 traffic_selector_policy: Optional[pulumi.Input[Union['VirtualNetworkGatewayConnectionTrafficSelectorPolicyArgs', 'VirtualNetworkGatewayConnectionTrafficSelectorPolicyArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 use_policy_based_traffic_selectors: Optional[pulumi.Input[_builtins.bool]] = None,
                 virtual_network_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a connection in an existing Virtual Network Gateway.

        ## Example Usage

        ### Site-to-Site connection

        The following example shows a connection between an Azure virtual network
        and an on-premises VPN device and network.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="test",
            location="West US")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="test",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="GatewaySubnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"])
        onpremise = azure.network.LocalNetworkGateway("onpremise",
            name="onpremise",
            location=example.location,
            resource_group_name=example.name,
            gateway_address="168.62.225.23",
            address_spaces=["10.1.1.0/24"])
        example_public_ip = azure.network.PublicIp("example",
            name="test",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Dynamic")
        example_virtual_network_gateway = azure.network.VirtualNetworkGateway("example",
            name="test",
            location=example.location,
            resource_group_name=example.name,
            type="Vpn",
            vpn_type="RouteBased",
            active_active=False,
            enable_bgp=False,
            sku="Basic",
            ip_configurations=[{
                "public_ip_address_id": example_public_ip.id,
                "private_ip_address_allocation": "Dynamic",
                "subnet_id": example_subnet.id,
            }])
        onpremise_virtual_network_gateway_connection = azure.network.VirtualNetworkGatewayConnection("onpremise",
            name="onpremise",
            location=example.location,
            resource_group_name=example.name,
            type="IPsec",
            virtual_network_gateway_id=example_virtual_network_gateway.id,
            local_network_gateway_id=onpremise.id,
            shared_key="4-v3ry-53cr37-1p53c-5h4r3d-k3y")
        ```

        ### VNet-to-VNet connection

        The following example shows a connection between two Azure virtual network
        in different locations/regions.

        ```python
        import pulumi
        import pulumi_azure as azure

        us = azure.core.ResourceGroup("us",
            name="us",
            location="East US")
        us_virtual_network = azure.network.VirtualNetwork("us",
            name="us",
            location=us.location,
            resource_group_name=us.name,
            address_spaces=["10.0.0.0/16"])
        us_gateway = azure.network.Subnet("us_gateway",
            name="GatewaySubnet",
            resource_group_name=us.name,
            virtual_network_name=us_virtual_network.name,
            address_prefixes=["10.0.1.0/24"])
        us_public_ip = azure.network.PublicIp("us",
            name="us",
            location=us.location,
            resource_group_name=us.name,
            allocation_method="Dynamic")
        us_virtual_network_gateway = azure.network.VirtualNetworkGateway("us",
            name="us-gateway",
            location=us.location,
            resource_group_name=us.name,
            type="Vpn",
            vpn_type="RouteBased",
            sku="Basic",
            ip_configurations=[{
                "public_ip_address_id": us_public_ip.id,
                "private_ip_address_allocation": "Dynamic",
                "subnet_id": us_gateway.id,
            }])
        europe = azure.core.ResourceGroup("europe",
            name="europe",
            location="West Europe")
        europe_virtual_network = azure.network.VirtualNetwork("europe",
            name="europe",
            location=europe.location,
            resource_group_name=europe.name,
            address_spaces=["10.1.0.0/16"])
        europe_gateway = azure.network.Subnet("europe_gateway",
            name="GatewaySubnet",
            resource_group_name=europe.name,
            virtual_network_name=europe_virtual_network.name,
            address_prefixes=["10.1.1.0/24"])
        europe_public_ip = azure.network.PublicIp("europe",
            name="europe",
            location=europe.location,
            resource_group_name=europe.name,
            allocation_method="Dynamic")
        europe_virtual_network_gateway = azure.network.VirtualNetworkGateway("europe",
            name="europe-gateway",
            location=europe.location,
            resource_group_name=europe.name,
            type="Vpn",
            vpn_type="RouteBased",
            sku="Basic",
            ip_configurations=[{
                "public_ip_address_id": europe_public_ip.id,
                "private_ip_address_allocation": "Dynamic",
                "subnet_id": europe_gateway.id,
            }])
        us_to_europe = azure.network.VirtualNetworkGatewayConnection("us_to_europe",
            name="us-to-europe",
            location=us.location,
            resource_group_name=us.name,
            type="Vnet2Vnet",
            virtual_network_gateway_id=us_virtual_network_gateway.id,
            peer_virtual_network_gateway_id=europe_virtual_network_gateway.id,
            shared_key="4-v3ry-53cr37-1p53c-5h4r3d-k3y")
        europe_to_us = azure.network.VirtualNetworkGatewayConnection("europe_to_us",
            name="europe-to-us",
            location=europe.location,
            resource_group_name=europe.name,
            type="Vnet2Vnet",
            virtual_network_gateway_id=europe_virtual_network_gateway.id,
            peer_virtual_network_gateway_id=us_virtual_network_gateway.id,
            shared_key="4-v3ry-53cr37-1p53c-5h4r3d-k3y")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2024-05-01

        ## Import

        Virtual Network Gateway Connections can be imported using their `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/virtualNetworkGatewayConnection:VirtualNetworkGatewayConnection exampleConnection /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myGroup1/providers/Microsoft.Network/connections/myConnection1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authorization_key: The authorization key associated with the Express Route Circuit. This field is required only if the type is an ExpressRoute connection.
        :param pulumi.Input[_builtins.str] connection_mode: Connection mode to use. Possible values are `Default`, `InitiatorOnly` and `ResponderOnly`. Defaults to `Default`. Changing this value will force a resource to be created.
        :param pulumi.Input[_builtins.str] connection_protocol: The IKE protocol version to use. Possible values are `IKEv1` and `IKEv2`, values are `IKEv1` and `IKEv2`. Defaults to `IKEv2`. Changing this forces a new resource to be created.
               > **Note:** Only valid for `IPSec` connections on virtual network gateways with SKU `VpnGw1`, `VpnGw2`, `VpnGw3`, `VpnGw1AZ`, `VpnGw2AZ` or `VpnGw3AZ`.
        :param pulumi.Input[Union['VirtualNetworkGatewayConnectionCustomBgpAddressesArgs', 'VirtualNetworkGatewayConnectionCustomBgpAddressesArgsDict']] custom_bgp_addresses: A `custom_bgp_addresses` block which is documented below.
               The block can only be used on `IPSec` / `activeactive` connections,
               For details about see [the relevant section in the Azure documentation](https://docs.microsoft.com/en-us/azure/vpn-gateway/vpn-gateway-howto-aws-bgp).
        :param pulumi.Input[_builtins.int] dpd_timeout_seconds: The dead peer detection timeout of this connection in seconds. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] egress_nat_rule_ids: A list of the egress NAT Rule Ids.
        :param pulumi.Input[_builtins.bool] enable_bgp: If `true`, BGP (Border Gateway Protocol) is enabled for this connection. Defaults to `false`.
        :param pulumi.Input[_builtins.str] express_route_circuit_id: The ID of the Express Route Circuit when creating an ExpressRoute connection (i.e. when `type` is `ExpressRoute`). The Express Route Circuit can be in the same or in a different subscription. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] express_route_gateway_bypass: If `true`, data packets will bypass ExpressRoute Gateway for data forwarding This is only valid for ExpressRoute connections.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ingress_nat_rule_ids: A list of the ingress NAT Rule Ids.
        :param pulumi.Input[Union['VirtualNetworkGatewayConnectionIpsecPolicyArgs', 'VirtualNetworkGatewayConnectionIpsecPolicyArgsDict']] ipsec_policy: A `ipsec_policy` block which is documented below.
               Only a single policy can be defined for a connection. For details on
               custom policies refer to [the relevant section in the Azure documentation](https://docs.microsoft.com/azure/vpn-gateway/vpn-gateway-ipsecikepolicy-rm-powershell).
        :param pulumi.Input[_builtins.bool] local_azure_ip_address_enabled: Use private local Azure IP for the connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] local_network_gateway_id: The ID of the local network gateway when creating Site-to-Site connection (i.e. when `type` is `IPsec`).
        :param pulumi.Input[_builtins.str] location: The location/region where the connection is located. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the connection. Changing the name forces a new resource to be created.
        :param pulumi.Input[_builtins.str] peer_virtual_network_gateway_id: The ID of the peer virtual network gateway when creating a VNet-to-VNet connection (i.e. when `type` is `Vnet2Vnet`). The peer Virtual Network Gateway can be in the same or in a different subscription. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] private_link_fast_path_enabled: Bypass the Express Route gateway when accessing private-links. When enabled `express_route_gateway_bypass` must be set to `true`. Defaults to `false`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the connection Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] routing_weight: The routing weight. Defaults to `10`.
        :param pulumi.Input[_builtins.str] shared_key: The shared IPSec key. A key could be provided if a Site-to-Site, VNet-to-VNet or ExpressRoute connection is created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Union['VirtualNetworkGatewayConnectionTrafficSelectorPolicyArgs', 'VirtualNetworkGatewayConnectionTrafficSelectorPolicyArgsDict']] traffic_selector_policy: One or more `traffic_selector_policy` blocks which are documented below.
               A `traffic_selector_policy` allows to specify a traffic selector policy proposal to be used in a virtual network gateway connection.
               For details about traffic selectors refer to [the relevant section in the Azure documentation](https://docs.microsoft.com/azure/vpn-gateway/vpn-gateway-connect-multiple-policybased-rm-ps).
        :param pulumi.Input[_builtins.str] type: The type of connection. Valid options are `IPsec` (Site-to-Site), `ExpressRoute` (ExpressRoute), and `Vnet2Vnet` (VNet-to-VNet). Each connection type requires different mandatory arguments (refer to the examples above). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] use_policy_based_traffic_selectors: If `true`, policy-based traffic selectors are enabled for this connection. Enabling policy-based traffic selectors requires an `ipsec_policy` block. Defaults to `false`.
        :param pulumi.Input[_builtins.str] virtual_network_gateway_id: The ID of the Virtual Network Gateway in which the connection will be created. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualNetworkGatewayConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a connection in an existing Virtual Network Gateway.

        ## Example Usage

        ### Site-to-Site connection

        The following example shows a connection between an Azure virtual network
        and an on-premises VPN device and network.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="test",
            location="West US")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="test",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="GatewaySubnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"])
        onpremise = azure.network.LocalNetworkGateway("onpremise",
            name="onpremise",
            location=example.location,
            resource_group_name=example.name,
            gateway_address="168.62.225.23",
            address_spaces=["10.1.1.0/24"])
        example_public_ip = azure.network.PublicIp("example",
            name="test",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Dynamic")
        example_virtual_network_gateway = azure.network.VirtualNetworkGateway("example",
            name="test",
            location=example.location,
            resource_group_name=example.name,
            type="Vpn",
            vpn_type="RouteBased",
            active_active=False,
            enable_bgp=False,
            sku="Basic",
            ip_configurations=[{
                "public_ip_address_id": example_public_ip.id,
                "private_ip_address_allocation": "Dynamic",
                "subnet_id": example_subnet.id,
            }])
        onpremise_virtual_network_gateway_connection = azure.network.VirtualNetworkGatewayConnection("onpremise",
            name="onpremise",
            location=example.location,
            resource_group_name=example.name,
            type="IPsec",
            virtual_network_gateway_id=example_virtual_network_gateway.id,
            local_network_gateway_id=onpremise.id,
            shared_key="4-v3ry-53cr37-1p53c-5h4r3d-k3y")
        ```

        ### VNet-to-VNet connection

        The following example shows a connection between two Azure virtual network
        in different locations/regions.

        ```python
        import pulumi
        import pulumi_azure as azure

        us = azure.core.ResourceGroup("us",
            name="us",
            location="East US")
        us_virtual_network = azure.network.VirtualNetwork("us",
            name="us",
            location=us.location,
            resource_group_name=us.name,
            address_spaces=["10.0.0.0/16"])
        us_gateway = azure.network.Subnet("us_gateway",
            name="GatewaySubnet",
            resource_group_name=us.name,
            virtual_network_name=us_virtual_network.name,
            address_prefixes=["10.0.1.0/24"])
        us_public_ip = azure.network.PublicIp("us",
            name="us",
            location=us.location,
            resource_group_name=us.name,
            allocation_method="Dynamic")
        us_virtual_network_gateway = azure.network.VirtualNetworkGateway("us",
            name="us-gateway",
            location=us.location,
            resource_group_name=us.name,
            type="Vpn",
            vpn_type="RouteBased",
            sku="Basic",
            ip_configurations=[{
                "public_ip_address_id": us_public_ip.id,
                "private_ip_address_allocation": "Dynamic",
                "subnet_id": us_gateway.id,
            }])
        europe = azure.core.ResourceGroup("europe",
            name="europe",
            location="West Europe")
        europe_virtual_network = azure.network.VirtualNetwork("europe",
            name="europe",
            location=europe.location,
            resource_group_name=europe.name,
            address_spaces=["10.1.0.0/16"])
        europe_gateway = azure.network.Subnet("europe_gateway",
            name="GatewaySubnet",
            resource_group_name=europe.name,
            virtual_network_name=europe_virtual_network.name,
            address_prefixes=["10.1.1.0/24"])
        europe_public_ip = azure.network.PublicIp("europe",
            name="europe",
            location=europe.location,
            resource_group_name=europe.name,
            allocation_method="Dynamic")
        europe_virtual_network_gateway = azure.network.VirtualNetworkGateway("europe",
            name="europe-gateway",
            location=europe.location,
            resource_group_name=europe.name,
            type="Vpn",
            vpn_type="RouteBased",
            sku="Basic",
            ip_configurations=[{
                "public_ip_address_id": europe_public_ip.id,
                "private_ip_address_allocation": "Dynamic",
                "subnet_id": europe_gateway.id,
            }])
        us_to_europe = azure.network.VirtualNetworkGatewayConnection("us_to_europe",
            name="us-to-europe",
            location=us.location,
            resource_group_name=us.name,
            type="Vnet2Vnet",
            virtual_network_gateway_id=us_virtual_network_gateway.id,
            peer_virtual_network_gateway_id=europe_virtual_network_gateway.id,
            shared_key="4-v3ry-53cr37-1p53c-5h4r3d-k3y")
        europe_to_us = azure.network.VirtualNetworkGatewayConnection("europe_to_us",
            name="europe-to-us",
            location=europe.location,
            resource_group_name=europe.name,
            type="Vnet2Vnet",
            virtual_network_gateway_id=europe_virtual_network_gateway.id,
            peer_virtual_network_gateway_id=us_virtual_network_gateway.id,
            shared_key="4-v3ry-53cr37-1p53c-5h4r3d-k3y")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2024-05-01

        ## Import

        Virtual Network Gateway Connections can be imported using their `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/virtualNetworkGatewayConnection:VirtualNetworkGatewayConnection exampleConnection /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myGroup1/providers/Microsoft.Network/connections/myConnection1
        ```

        :param str resource_name: The name of the resource.
        :param VirtualNetworkGatewayConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualNetworkGatewayConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization_key: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_bgp_addresses: Optional[pulumi.Input[Union['VirtualNetworkGatewayConnectionCustomBgpAddressesArgs', 'VirtualNetworkGatewayConnectionCustomBgpAddressesArgsDict']]] = None,
                 dpd_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 egress_nat_rule_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enable_bgp: Optional[pulumi.Input[_builtins.bool]] = None,
                 express_route_circuit_id: Optional[pulumi.Input[_builtins.str]] = None,
                 express_route_gateway_bypass: Optional[pulumi.Input[_builtins.bool]] = None,
                 ingress_nat_rule_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipsec_policy: Optional[pulumi.Input[Union['VirtualNetworkGatewayConnectionIpsecPolicyArgs', 'VirtualNetworkGatewayConnectionIpsecPolicyArgsDict']]] = None,
                 local_azure_ip_address_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 local_network_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_virtual_network_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_fast_path_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_weight: Optional[pulumi.Input[_builtins.int]] = None,
                 shared_key: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 traffic_selector_policy: Optional[pulumi.Input[Union['VirtualNetworkGatewayConnectionTrafficSelectorPolicyArgs', 'VirtualNetworkGatewayConnectionTrafficSelectorPolicyArgsDict']]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 use_policy_based_traffic_selectors: Optional[pulumi.Input[_builtins.bool]] = None,
                 virtual_network_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualNetworkGatewayConnectionArgs.__new__(VirtualNetworkGatewayConnectionArgs)

            __props__.__dict__["authorization_key"] = None if authorization_key is None else pulumi.Output.secret(authorization_key)
            __props__.__dict__["connection_mode"] = connection_mode
            __props__.__dict__["connection_protocol"] = connection_protocol
            __props__.__dict__["custom_bgp_addresses"] = custom_bgp_addresses
            __props__.__dict__["dpd_timeout_seconds"] = dpd_timeout_seconds
            __props__.__dict__["egress_nat_rule_ids"] = egress_nat_rule_ids
            __props__.__dict__["enable_bgp"] = enable_bgp
            __props__.__dict__["express_route_circuit_id"] = express_route_circuit_id
            __props__.__dict__["express_route_gateway_bypass"] = express_route_gateway_bypass
            __props__.__dict__["ingress_nat_rule_ids"] = ingress_nat_rule_ids
            __props__.__dict__["ipsec_policy"] = ipsec_policy
            __props__.__dict__["local_azure_ip_address_enabled"] = local_azure_ip_address_enabled
            __props__.__dict__["local_network_gateway_id"] = local_network_gateway_id
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["peer_virtual_network_gateway_id"] = peer_virtual_network_gateway_id
            __props__.__dict__["private_link_fast_path_enabled"] = private_link_fast_path_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["routing_weight"] = routing_weight
            __props__.__dict__["shared_key"] = None if shared_key is None else pulumi.Output.secret(shared_key)
            __props__.__dict__["tags"] = tags
            __props__.__dict__["traffic_selector_policy"] = traffic_selector_policy
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["use_policy_based_traffic_selectors"] = use_policy_based_traffic_selectors
            if virtual_network_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_network_gateway_id'")
            __props__.__dict__["virtual_network_gateway_id"] = virtual_network_gateway_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["authorizationKey", "sharedKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(VirtualNetworkGatewayConnection, __self__).__init__(
            'azure:network/virtualNetworkGatewayConnection:VirtualNetworkGatewayConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorization_key: Optional[pulumi.Input[_builtins.str]] = None,
            connection_mode: Optional[pulumi.Input[_builtins.str]] = None,
            connection_protocol: Optional[pulumi.Input[_builtins.str]] = None,
            custom_bgp_addresses: Optional[pulumi.Input[Union['VirtualNetworkGatewayConnectionCustomBgpAddressesArgs', 'VirtualNetworkGatewayConnectionCustomBgpAddressesArgsDict']]] = None,
            dpd_timeout_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            egress_nat_rule_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            enable_bgp: Optional[pulumi.Input[_builtins.bool]] = None,
            express_route_circuit_id: Optional[pulumi.Input[_builtins.str]] = None,
            express_route_gateway_bypass: Optional[pulumi.Input[_builtins.bool]] = None,
            ingress_nat_rule_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ipsec_policy: Optional[pulumi.Input[Union['VirtualNetworkGatewayConnectionIpsecPolicyArgs', 'VirtualNetworkGatewayConnectionIpsecPolicyArgsDict']]] = None,
            local_azure_ip_address_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            local_network_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            peer_virtual_network_gateway_id: Optional[pulumi.Input[_builtins.str]] = None,
            private_link_fast_path_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            routing_weight: Optional[pulumi.Input[_builtins.int]] = None,
            shared_key: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            traffic_selector_policy: Optional[pulumi.Input[Union['VirtualNetworkGatewayConnectionTrafficSelectorPolicyArgs', 'VirtualNetworkGatewayConnectionTrafficSelectorPolicyArgsDict']]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            use_policy_based_traffic_selectors: Optional[pulumi.Input[_builtins.bool]] = None,
            virtual_network_gateway_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'VirtualNetworkGatewayConnection':
        """
        Get an existing VirtualNetworkGatewayConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authorization_key: The authorization key associated with the Express Route Circuit. This field is required only if the type is an ExpressRoute connection.
        :param pulumi.Input[_builtins.str] connection_mode: Connection mode to use. Possible values are `Default`, `InitiatorOnly` and `ResponderOnly`. Defaults to `Default`. Changing this value will force a resource to be created.
        :param pulumi.Input[_builtins.str] connection_protocol: The IKE protocol version to use. Possible values are `IKEv1` and `IKEv2`, values are `IKEv1` and `IKEv2`. Defaults to `IKEv2`. Changing this forces a new resource to be created.
               > **Note:** Only valid for `IPSec` connections on virtual network gateways with SKU `VpnGw1`, `VpnGw2`, `VpnGw3`, `VpnGw1AZ`, `VpnGw2AZ` or `VpnGw3AZ`.
        :param pulumi.Input[Union['VirtualNetworkGatewayConnectionCustomBgpAddressesArgs', 'VirtualNetworkGatewayConnectionCustomBgpAddressesArgsDict']] custom_bgp_addresses: A `custom_bgp_addresses` block which is documented below.
               The block can only be used on `IPSec` / `activeactive` connections,
               For details about see [the relevant section in the Azure documentation](https://docs.microsoft.com/en-us/azure/vpn-gateway/vpn-gateway-howto-aws-bgp).
        :param pulumi.Input[_builtins.int] dpd_timeout_seconds: The dead peer detection timeout of this connection in seconds. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] egress_nat_rule_ids: A list of the egress NAT Rule Ids.
        :param pulumi.Input[_builtins.bool] enable_bgp: If `true`, BGP (Border Gateway Protocol) is enabled for this connection. Defaults to `false`.
        :param pulumi.Input[_builtins.str] express_route_circuit_id: The ID of the Express Route Circuit when creating an ExpressRoute connection (i.e. when `type` is `ExpressRoute`). The Express Route Circuit can be in the same or in a different subscription. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] express_route_gateway_bypass: If `true`, data packets will bypass ExpressRoute Gateway for data forwarding This is only valid for ExpressRoute connections.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ingress_nat_rule_ids: A list of the ingress NAT Rule Ids.
        :param pulumi.Input[Union['VirtualNetworkGatewayConnectionIpsecPolicyArgs', 'VirtualNetworkGatewayConnectionIpsecPolicyArgsDict']] ipsec_policy: A `ipsec_policy` block which is documented below.
               Only a single policy can be defined for a connection. For details on
               custom policies refer to [the relevant section in the Azure documentation](https://docs.microsoft.com/azure/vpn-gateway/vpn-gateway-ipsecikepolicy-rm-powershell).
        :param pulumi.Input[_builtins.bool] local_azure_ip_address_enabled: Use private local Azure IP for the connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] local_network_gateway_id: The ID of the local network gateway when creating Site-to-Site connection (i.e. when `type` is `IPsec`).
        :param pulumi.Input[_builtins.str] location: The location/region where the connection is located. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the connection. Changing the name forces a new resource to be created.
        :param pulumi.Input[_builtins.str] peer_virtual_network_gateway_id: The ID of the peer virtual network gateway when creating a VNet-to-VNet connection (i.e. when `type` is `Vnet2Vnet`). The peer Virtual Network Gateway can be in the same or in a different subscription. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] private_link_fast_path_enabled: Bypass the Express Route gateway when accessing private-links. When enabled `express_route_gateway_bypass` must be set to `true`. Defaults to `false`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the connection Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] routing_weight: The routing weight. Defaults to `10`.
        :param pulumi.Input[_builtins.str] shared_key: The shared IPSec key. A key could be provided if a Site-to-Site, VNet-to-VNet or ExpressRoute connection is created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Union['VirtualNetworkGatewayConnectionTrafficSelectorPolicyArgs', 'VirtualNetworkGatewayConnectionTrafficSelectorPolicyArgsDict']] traffic_selector_policy: One or more `traffic_selector_policy` blocks which are documented below.
               A `traffic_selector_policy` allows to specify a traffic selector policy proposal to be used in a virtual network gateway connection.
               For details about traffic selectors refer to [the relevant section in the Azure documentation](https://docs.microsoft.com/azure/vpn-gateway/vpn-gateway-connect-multiple-policybased-rm-ps).
        :param pulumi.Input[_builtins.str] type: The type of connection. Valid options are `IPsec` (Site-to-Site), `ExpressRoute` (ExpressRoute), and `Vnet2Vnet` (VNet-to-VNet). Each connection type requires different mandatory arguments (refer to the examples above). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] use_policy_based_traffic_selectors: If `true`, policy-based traffic selectors are enabled for this connection. Enabling policy-based traffic selectors requires an `ipsec_policy` block. Defaults to `false`.
        :param pulumi.Input[_builtins.str] virtual_network_gateway_id: The ID of the Virtual Network Gateway in which the connection will be created. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualNetworkGatewayConnectionState.__new__(_VirtualNetworkGatewayConnectionState)

        __props__.__dict__["authorization_key"] = authorization_key
        __props__.__dict__["connection_mode"] = connection_mode
        __props__.__dict__["connection_protocol"] = connection_protocol
        __props__.__dict__["custom_bgp_addresses"] = custom_bgp_addresses
        __props__.__dict__["dpd_timeout_seconds"] = dpd_timeout_seconds
        __props__.__dict__["egress_nat_rule_ids"] = egress_nat_rule_ids
        __props__.__dict__["enable_bgp"] = enable_bgp
        __props__.__dict__["express_route_circuit_id"] = express_route_circuit_id
        __props__.__dict__["express_route_gateway_bypass"] = express_route_gateway_bypass
        __props__.__dict__["ingress_nat_rule_ids"] = ingress_nat_rule_ids
        __props__.__dict__["ipsec_policy"] = ipsec_policy
        __props__.__dict__["local_azure_ip_address_enabled"] = local_azure_ip_address_enabled
        __props__.__dict__["local_network_gateway_id"] = local_network_gateway_id
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["peer_virtual_network_gateway_id"] = peer_virtual_network_gateway_id
        __props__.__dict__["private_link_fast_path_enabled"] = private_link_fast_path_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["routing_weight"] = routing_weight
        __props__.__dict__["shared_key"] = shared_key
        __props__.__dict__["tags"] = tags
        __props__.__dict__["traffic_selector_policy"] = traffic_selector_policy
        __props__.__dict__["type"] = type
        __props__.__dict__["use_policy_based_traffic_selectors"] = use_policy_based_traffic_selectors
        __props__.__dict__["virtual_network_gateway_id"] = virtual_network_gateway_id
        return VirtualNetworkGatewayConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authorizationKey")
    def authorization_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The authorization key associated with the Express Route Circuit. This field is required only if the type is an ExpressRoute connection.
        """
        return pulumi.get(self, "authorization_key")

    @_builtins.property
    @pulumi.getter(name="connectionMode")
    def connection_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Connection mode to use. Possible values are `Default`, `InitiatorOnly` and `ResponderOnly`. Defaults to `Default`. Changing this value will force a resource to be created.
        """
        return pulumi.get(self, "connection_mode")

    @_builtins.property
    @pulumi.getter(name="connectionProtocol")
    def connection_protocol(self) -> pulumi.Output[_builtins.str]:
        """
        The IKE protocol version to use. Possible values are `IKEv1` and `IKEv2`, values are `IKEv1` and `IKEv2`. Defaults to `IKEv2`. Changing this forces a new resource to be created.
        > **Note:** Only valid for `IPSec` connections on virtual network gateways with SKU `VpnGw1`, `VpnGw2`, `VpnGw3`, `VpnGw1AZ`, `VpnGw2AZ` or `VpnGw3AZ`.
        """
        return pulumi.get(self, "connection_protocol")

    @_builtins.property
    @pulumi.getter(name="customBgpAddresses")
    def custom_bgp_addresses(self) -> pulumi.Output[Optional['outputs.VirtualNetworkGatewayConnectionCustomBgpAddresses']]:
        """
        A `custom_bgp_addresses` block which is documented below.
        The block can only be used on `IPSec` / `activeactive` connections,
        For details about see [the relevant section in the Azure documentation](https://docs.microsoft.com/en-us/azure/vpn-gateway/vpn-gateway-howto-aws-bgp).
        """
        return pulumi.get(self, "custom_bgp_addresses")

    @_builtins.property
    @pulumi.getter(name="dpdTimeoutSeconds")
    def dpd_timeout_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The dead peer detection timeout of this connection in seconds. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "dpd_timeout_seconds")

    @_builtins.property
    @pulumi.getter(name="egressNatRuleIds")
    def egress_nat_rule_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of the egress NAT Rule Ids.
        """
        return pulumi.get(self, "egress_nat_rule_ids")

    @_builtins.property
    @pulumi.getter(name="enableBgp")
    def enable_bgp(self) -> pulumi.Output[_builtins.bool]:
        """
        If `true`, BGP (Border Gateway Protocol) is enabled for this connection. Defaults to `false`.
        """
        return pulumi.get(self, "enable_bgp")

    @_builtins.property
    @pulumi.getter(name="expressRouteCircuitId")
    def express_route_circuit_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Express Route Circuit when creating an ExpressRoute connection (i.e. when `type` is `ExpressRoute`). The Express Route Circuit can be in the same or in a different subscription. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "express_route_circuit_id")

    @_builtins.property
    @pulumi.getter(name="expressRouteGatewayBypass")
    def express_route_gateway_bypass(self) -> pulumi.Output[_builtins.bool]:
        """
        If `true`, data packets will bypass ExpressRoute Gateway for data forwarding This is only valid for ExpressRoute connections.
        """
        return pulumi.get(self, "express_route_gateway_bypass")

    @_builtins.property
    @pulumi.getter(name="ingressNatRuleIds")
    def ingress_nat_rule_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of the ingress NAT Rule Ids.
        """
        return pulumi.get(self, "ingress_nat_rule_ids")

    @_builtins.property
    @pulumi.getter(name="ipsecPolicy")
    def ipsec_policy(self) -> pulumi.Output[Optional['outputs.VirtualNetworkGatewayConnectionIpsecPolicy']]:
        """
        A `ipsec_policy` block which is documented below.
        Only a single policy can be defined for a connection. For details on
        custom policies refer to [the relevant section in the Azure documentation](https://docs.microsoft.com/azure/vpn-gateway/vpn-gateway-ipsecikepolicy-rm-powershell).
        """
        return pulumi.get(self, "ipsec_policy")

    @_builtins.property
    @pulumi.getter(name="localAzureIpAddressEnabled")
    def local_azure_ip_address_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Use private local Azure IP for the connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "local_azure_ip_address_enabled")

    @_builtins.property
    @pulumi.getter(name="localNetworkGatewayId")
    def local_network_gateway_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the local network gateway when creating Site-to-Site connection (i.e. when `type` is `IPsec`).
        """
        return pulumi.get(self, "local_network_gateway_id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location/region where the connection is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the connection. Changing the name forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="peerVirtualNetworkGatewayId")
    def peer_virtual_network_gateway_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the peer virtual network gateway when creating a VNet-to-VNet connection (i.e. when `type` is `Vnet2Vnet`). The peer Virtual Network Gateway can be in the same or in a different subscription. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "peer_virtual_network_gateway_id")

    @_builtins.property
    @pulumi.getter(name="privateLinkFastPathEnabled")
    def private_link_fast_path_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Bypass the Express Route gateway when accessing private-links. When enabled `express_route_gateway_bypass` must be set to `true`. Defaults to `false`.
        """
        return pulumi.get(self, "private_link_fast_path_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the connection Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="routingWeight")
    def routing_weight(self) -> pulumi.Output[_builtins.int]:
        """
        The routing weight. Defaults to `10`.
        """
        return pulumi.get(self, "routing_weight")

    @_builtins.property
    @pulumi.getter(name="sharedKey")
    def shared_key(self) -> pulumi.Output[_builtins.str]:
        """
        The shared IPSec key. A key could be provided if a Site-to-Site, VNet-to-VNet or ExpressRoute connection is created.
        """
        return pulumi.get(self, "shared_key")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="trafficSelectorPolicy")
    def traffic_selector_policy(self) -> pulumi.Output[Optional['outputs.VirtualNetworkGatewayConnectionTrafficSelectorPolicy']]:
        """
        One or more `traffic_selector_policy` blocks which are documented below.
        A `traffic_selector_policy` allows to specify a traffic selector policy proposal to be used in a virtual network gateway connection.
        For details about traffic selectors refer to [the relevant section in the Azure documentation](https://docs.microsoft.com/azure/vpn-gateway/vpn-gateway-connect-multiple-policybased-rm-ps).
        """
        return pulumi.get(self, "traffic_selector_policy")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of connection. Valid options are `IPsec` (Site-to-Site), `ExpressRoute` (ExpressRoute), and `Vnet2Vnet` (VNet-to-VNet). Each connection type requires different mandatory arguments (refer to the examples above). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="usePolicyBasedTrafficSelectors")
    def use_policy_based_traffic_selectors(self) -> pulumi.Output[_builtins.bool]:
        """
        If `true`, policy-based traffic selectors are enabled for this connection. Enabling policy-based traffic selectors requires an `ipsec_policy` block. Defaults to `false`.
        """
        return pulumi.get(self, "use_policy_based_traffic_selectors")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkGatewayId")
    def virtual_network_gateway_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Virtual Network Gateway in which the connection will be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_network_gateway_id")

