# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TagRuleArgs', 'TagRule']

@pulumi.input_type
class TagRuleArgs:
    def __init__(__self__, *,
                 monitor_id: pulumi.Input[_builtins.str],
                 activity_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 azure_active_directory_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input['TagRuleLogTagFilterArgs']]]] = None,
                 metric_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 metric_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input['TagRuleMetricTagFilterArgs']]]] = None,
                 subscription_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a TagRule resource.
        :param pulumi.Input[_builtins.str] monitor_id: Specifies the ID of the New Relic Monitor this Tag Rule should be created within. Changing this forces a new Azure Native New Relic Tag Rule to be created.
        :param pulumi.Input[_builtins.bool] activity_log_enabled: Whether activity logs from Azure resources should be sent for the Monitor resource. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] azure_active_directory_log_enabled: Whether Azure Active Directory logs should be sent for the Monitor resource. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['TagRuleLogTagFilterArgs']]] log_tag_filters: A `log_tag_filter` block as defined below.
        :param pulumi.Input[_builtins.bool] metric_enabled: Whether metrics should be sent for the Monitor resource. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['TagRuleMetricTagFilterArgs']]] metric_tag_filters: A `metric_tag_filter` block as defined below.
        :param pulumi.Input[_builtins.bool] subscription_log_enabled: Whether subscription logs should be sent for the Monitor resource. Defaults to `false`.
        """
        pulumi.set(__self__, "monitor_id", monitor_id)
        if activity_log_enabled is not None:
            pulumi.set(__self__, "activity_log_enabled", activity_log_enabled)
        if azure_active_directory_log_enabled is not None:
            pulumi.set(__self__, "azure_active_directory_log_enabled", azure_active_directory_log_enabled)
        if log_tag_filters is not None:
            pulumi.set(__self__, "log_tag_filters", log_tag_filters)
        if metric_enabled is not None:
            pulumi.set(__self__, "metric_enabled", metric_enabled)
        if metric_tag_filters is not None:
            pulumi.set(__self__, "metric_tag_filters", metric_tag_filters)
        if subscription_log_enabled is not None:
            pulumi.set(__self__, "subscription_log_enabled", subscription_log_enabled)

    @_builtins.property
    @pulumi.getter(name="monitorId")
    def monitor_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the New Relic Monitor this Tag Rule should be created within. Changing this forces a new Azure Native New Relic Tag Rule to be created.
        """
        return pulumi.get(self, "monitor_id")

    @monitor_id.setter
    def monitor_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "monitor_id", value)

    @_builtins.property
    @pulumi.getter(name="activityLogEnabled")
    def activity_log_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether activity logs from Azure resources should be sent for the Monitor resource. Defaults to `false`.
        """
        return pulumi.get(self, "activity_log_enabled")

    @activity_log_enabled.setter
    def activity_log_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "activity_log_enabled", value)

    @_builtins.property
    @pulumi.getter(name="azureActiveDirectoryLogEnabled")
    def azure_active_directory_log_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether Azure Active Directory logs should be sent for the Monitor resource. Defaults to `false`.
        """
        return pulumi.get(self, "azure_active_directory_log_enabled")

    @azure_active_directory_log_enabled.setter
    def azure_active_directory_log_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "azure_active_directory_log_enabled", value)

    @_builtins.property
    @pulumi.getter(name="logTagFilters")
    def log_tag_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TagRuleLogTagFilterArgs']]]]:
        """
        A `log_tag_filter` block as defined below.
        """
        return pulumi.get(self, "log_tag_filters")

    @log_tag_filters.setter
    def log_tag_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TagRuleLogTagFilterArgs']]]]):
        pulumi.set(self, "log_tag_filters", value)

    @_builtins.property
    @pulumi.getter(name="metricEnabled")
    def metric_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether metrics should be sent for the Monitor resource. Defaults to `false`.
        """
        return pulumi.get(self, "metric_enabled")

    @metric_enabled.setter
    def metric_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "metric_enabled", value)

    @_builtins.property
    @pulumi.getter(name="metricTagFilters")
    def metric_tag_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TagRuleMetricTagFilterArgs']]]]:
        """
        A `metric_tag_filter` block as defined below.
        """
        return pulumi.get(self, "metric_tag_filters")

    @metric_tag_filters.setter
    def metric_tag_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TagRuleMetricTagFilterArgs']]]]):
        pulumi.set(self, "metric_tag_filters", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionLogEnabled")
    def subscription_log_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether subscription logs should be sent for the Monitor resource. Defaults to `false`.
        """
        return pulumi.get(self, "subscription_log_enabled")

    @subscription_log_enabled.setter
    def subscription_log_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "subscription_log_enabled", value)


@pulumi.input_type
class _TagRuleState:
    def __init__(__self__, *,
                 activity_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 azure_active_directory_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input['TagRuleLogTagFilterArgs']]]] = None,
                 metric_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 metric_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input['TagRuleMetricTagFilterArgs']]]] = None,
                 monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering TagRule resources.
        :param pulumi.Input[_builtins.bool] activity_log_enabled: Whether activity logs from Azure resources should be sent for the Monitor resource. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] azure_active_directory_log_enabled: Whether Azure Active Directory logs should be sent for the Monitor resource. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['TagRuleLogTagFilterArgs']]] log_tag_filters: A `log_tag_filter` block as defined below.
        :param pulumi.Input[_builtins.bool] metric_enabled: Whether metrics should be sent for the Monitor resource. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input['TagRuleMetricTagFilterArgs']]] metric_tag_filters: A `metric_tag_filter` block as defined below.
        :param pulumi.Input[_builtins.str] monitor_id: Specifies the ID of the New Relic Monitor this Tag Rule should be created within. Changing this forces a new Azure Native New Relic Tag Rule to be created.
        :param pulumi.Input[_builtins.bool] subscription_log_enabled: Whether subscription logs should be sent for the Monitor resource. Defaults to `false`.
        """
        if activity_log_enabled is not None:
            pulumi.set(__self__, "activity_log_enabled", activity_log_enabled)
        if azure_active_directory_log_enabled is not None:
            pulumi.set(__self__, "azure_active_directory_log_enabled", azure_active_directory_log_enabled)
        if log_tag_filters is not None:
            pulumi.set(__self__, "log_tag_filters", log_tag_filters)
        if metric_enabled is not None:
            pulumi.set(__self__, "metric_enabled", metric_enabled)
        if metric_tag_filters is not None:
            pulumi.set(__self__, "metric_tag_filters", metric_tag_filters)
        if monitor_id is not None:
            pulumi.set(__self__, "monitor_id", monitor_id)
        if subscription_log_enabled is not None:
            pulumi.set(__self__, "subscription_log_enabled", subscription_log_enabled)

    @_builtins.property
    @pulumi.getter(name="activityLogEnabled")
    def activity_log_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether activity logs from Azure resources should be sent for the Monitor resource. Defaults to `false`.
        """
        return pulumi.get(self, "activity_log_enabled")

    @activity_log_enabled.setter
    def activity_log_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "activity_log_enabled", value)

    @_builtins.property
    @pulumi.getter(name="azureActiveDirectoryLogEnabled")
    def azure_active_directory_log_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether Azure Active Directory logs should be sent for the Monitor resource. Defaults to `false`.
        """
        return pulumi.get(self, "azure_active_directory_log_enabled")

    @azure_active_directory_log_enabled.setter
    def azure_active_directory_log_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "azure_active_directory_log_enabled", value)

    @_builtins.property
    @pulumi.getter(name="logTagFilters")
    def log_tag_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TagRuleLogTagFilterArgs']]]]:
        """
        A `log_tag_filter` block as defined below.
        """
        return pulumi.get(self, "log_tag_filters")

    @log_tag_filters.setter
    def log_tag_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TagRuleLogTagFilterArgs']]]]):
        pulumi.set(self, "log_tag_filters", value)

    @_builtins.property
    @pulumi.getter(name="metricEnabled")
    def metric_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether metrics should be sent for the Monitor resource. Defaults to `false`.
        """
        return pulumi.get(self, "metric_enabled")

    @metric_enabled.setter
    def metric_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "metric_enabled", value)

    @_builtins.property
    @pulumi.getter(name="metricTagFilters")
    def metric_tag_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TagRuleMetricTagFilterArgs']]]]:
        """
        A `metric_tag_filter` block as defined below.
        """
        return pulumi.get(self, "metric_tag_filters")

    @metric_tag_filters.setter
    def metric_tag_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TagRuleMetricTagFilterArgs']]]]):
        pulumi.set(self, "metric_tag_filters", value)

    @_builtins.property
    @pulumi.getter(name="monitorId")
    def monitor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the New Relic Monitor this Tag Rule should be created within. Changing this forces a new Azure Native New Relic Tag Rule to be created.
        """
        return pulumi.get(self, "monitor_id")

    @monitor_id.setter
    def monitor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "monitor_id", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionLogEnabled")
    def subscription_log_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether subscription logs should be sent for the Monitor resource. Defaults to `false`.
        """
        return pulumi.get(self, "subscription_log_enabled")

    @subscription_log_enabled.setter
    def subscription_log_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "subscription_log_enabled", value)


@pulumi.type_token("azure:newrelic/tagRule:TagRule")
class TagRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activity_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 azure_active_directory_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TagRuleLogTagFilterArgs', 'TagRuleLogTagFilterArgsDict']]]]] = None,
                 metric_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 metric_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TagRuleMetricTagFilterArgs', 'TagRuleMetricTagFilterArgsDict']]]]] = None,
                 monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages an Azure Native New Relic Tag Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="East US")
        example_monitor = azure.newrelic.Monitor("example",
            name="example-nrm",
            resource_group_name=example.name,
            location=example.location,
            plan={
                "effective_date": "2023-06-06T00:00:00Z",
            },
            user={
                "email": "user@example.com",
                "first_name": "Example",
                "last_name": "User",
                "phone_number": "+12313803556",
            })
        example_tag_rule = azure.newrelic.TagRule("example",
            monitor_id=example_monitor.id,
            azure_active_directory_log_enabled=True,
            activity_log_enabled=True,
            metric_enabled=True,
            subscription_log_enabled=True,
            log_tag_filters=[{
                "name": "key",
                "action": "Include",
                "value": "value",
            }],
            metric_tag_filters=[{
                "name": "key",
                "action": "Exclude",
                "value": "value",
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `NewRelic.Observability` - 2024-03-01

        ## Import

        Azure Native New Relic Tag Rule can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:newrelic/tagRule:TagRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/NewRelic.Observability/monitors/monitor1/tagRules/ruleSet1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] activity_log_enabled: Whether activity logs from Azure resources should be sent for the Monitor resource. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] azure_active_directory_log_enabled: Whether Azure Active Directory logs should be sent for the Monitor resource. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TagRuleLogTagFilterArgs', 'TagRuleLogTagFilterArgsDict']]]] log_tag_filters: A `log_tag_filter` block as defined below.
        :param pulumi.Input[_builtins.bool] metric_enabled: Whether metrics should be sent for the Monitor resource. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TagRuleMetricTagFilterArgs', 'TagRuleMetricTagFilterArgsDict']]]] metric_tag_filters: A `metric_tag_filter` block as defined below.
        :param pulumi.Input[_builtins.str] monitor_id: Specifies the ID of the New Relic Monitor this Tag Rule should be created within. Changing this forces a new Azure Native New Relic Tag Rule to be created.
        :param pulumi.Input[_builtins.bool] subscription_log_enabled: Whether subscription logs should be sent for the Monitor resource. Defaults to `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TagRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Native New Relic Tag Rule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="East US")
        example_monitor = azure.newrelic.Monitor("example",
            name="example-nrm",
            resource_group_name=example.name,
            location=example.location,
            plan={
                "effective_date": "2023-06-06T00:00:00Z",
            },
            user={
                "email": "user@example.com",
                "first_name": "Example",
                "last_name": "User",
                "phone_number": "+12313803556",
            })
        example_tag_rule = azure.newrelic.TagRule("example",
            monitor_id=example_monitor.id,
            azure_active_directory_log_enabled=True,
            activity_log_enabled=True,
            metric_enabled=True,
            subscription_log_enabled=True,
            log_tag_filters=[{
                "name": "key",
                "action": "Include",
                "value": "value",
            }],
            metric_tag_filters=[{
                "name": "key",
                "action": "Exclude",
                "value": "value",
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `NewRelic.Observability` - 2024-03-01

        ## Import

        Azure Native New Relic Tag Rule can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:newrelic/tagRule:TagRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/NewRelic.Observability/monitors/monitor1/tagRules/ruleSet1
        ```

        :param str resource_name: The name of the resource.
        :param TagRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TagRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activity_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 azure_active_directory_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 log_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TagRuleLogTagFilterArgs', 'TagRuleLogTagFilterArgsDict']]]]] = None,
                 metric_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 metric_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TagRuleMetricTagFilterArgs', 'TagRuleMetricTagFilterArgsDict']]]]] = None,
                 monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TagRuleArgs.__new__(TagRuleArgs)

            __props__.__dict__["activity_log_enabled"] = activity_log_enabled
            __props__.__dict__["azure_active_directory_log_enabled"] = azure_active_directory_log_enabled
            __props__.__dict__["log_tag_filters"] = log_tag_filters
            __props__.__dict__["metric_enabled"] = metric_enabled
            __props__.__dict__["metric_tag_filters"] = metric_tag_filters
            if monitor_id is None and not opts.urn:
                raise TypeError("Missing required property 'monitor_id'")
            __props__.__dict__["monitor_id"] = monitor_id
            __props__.__dict__["subscription_log_enabled"] = subscription_log_enabled
        super(TagRule, __self__).__init__(
            'azure:newrelic/tagRule:TagRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activity_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            azure_active_directory_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            log_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TagRuleLogTagFilterArgs', 'TagRuleLogTagFilterArgsDict']]]]] = None,
            metric_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            metric_tag_filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TagRuleMetricTagFilterArgs', 'TagRuleMetricTagFilterArgsDict']]]]] = None,
            monitor_id: Optional[pulumi.Input[_builtins.str]] = None,
            subscription_log_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'TagRule':
        """
        Get an existing TagRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] activity_log_enabled: Whether activity logs from Azure resources should be sent for the Monitor resource. Defaults to `false`.
        :param pulumi.Input[_builtins.bool] azure_active_directory_log_enabled: Whether Azure Active Directory logs should be sent for the Monitor resource. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TagRuleLogTagFilterArgs', 'TagRuleLogTagFilterArgsDict']]]] log_tag_filters: A `log_tag_filter` block as defined below.
        :param pulumi.Input[_builtins.bool] metric_enabled: Whether metrics should be sent for the Monitor resource. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TagRuleMetricTagFilterArgs', 'TagRuleMetricTagFilterArgsDict']]]] metric_tag_filters: A `metric_tag_filter` block as defined below.
        :param pulumi.Input[_builtins.str] monitor_id: Specifies the ID of the New Relic Monitor this Tag Rule should be created within. Changing this forces a new Azure Native New Relic Tag Rule to be created.
        :param pulumi.Input[_builtins.bool] subscription_log_enabled: Whether subscription logs should be sent for the Monitor resource. Defaults to `false`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TagRuleState.__new__(_TagRuleState)

        __props__.__dict__["activity_log_enabled"] = activity_log_enabled
        __props__.__dict__["azure_active_directory_log_enabled"] = azure_active_directory_log_enabled
        __props__.__dict__["log_tag_filters"] = log_tag_filters
        __props__.__dict__["metric_enabled"] = metric_enabled
        __props__.__dict__["metric_tag_filters"] = metric_tag_filters
        __props__.__dict__["monitor_id"] = monitor_id
        __props__.__dict__["subscription_log_enabled"] = subscription_log_enabled
        return TagRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="activityLogEnabled")
    def activity_log_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether activity logs from Azure resources should be sent for the Monitor resource. Defaults to `false`.
        """
        return pulumi.get(self, "activity_log_enabled")

    @_builtins.property
    @pulumi.getter(name="azureActiveDirectoryLogEnabled")
    def azure_active_directory_log_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether Azure Active Directory logs should be sent for the Monitor resource. Defaults to `false`.
        """
        return pulumi.get(self, "azure_active_directory_log_enabled")

    @_builtins.property
    @pulumi.getter(name="logTagFilters")
    def log_tag_filters(self) -> pulumi.Output[Optional[Sequence['outputs.TagRuleLogTagFilter']]]:
        """
        A `log_tag_filter` block as defined below.
        """
        return pulumi.get(self, "log_tag_filters")

    @_builtins.property
    @pulumi.getter(name="metricEnabled")
    def metric_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether metrics should be sent for the Monitor resource. Defaults to `false`.
        """
        return pulumi.get(self, "metric_enabled")

    @_builtins.property
    @pulumi.getter(name="metricTagFilters")
    def metric_tag_filters(self) -> pulumi.Output[Optional[Sequence['outputs.TagRuleMetricTagFilter']]]:
        """
        A `metric_tag_filter` block as defined below.
        """
        return pulumi.get(self, "metric_tag_filters")

    @_builtins.property
    @pulumi.getter(name="monitorId")
    def monitor_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the New Relic Monitor this Tag Rule should be created within. Changing this forces a new Azure Native New Relic Tag Rule to be created.
        """
        return pulumi.get(self, "monitor_id")

    @_builtins.property
    @pulumi.getter(name="subscriptionLogEnabled")
    def subscription_log_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether subscription logs should be sent for the Monitor resource. Defaults to `false`.
        """
        return pulumi.get(self, "subscription_log_enabled")

