# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConfigurationArgs', 'Configuration']

@pulumi.input_type
class ConfigurationArgs:
    def __init__(__self__, *,
                 nginx_deployment_id: pulumi.Input[_builtins.str],
                 root_file: pulumi.Input[_builtins.str],
                 config_files: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationConfigFileArgs']]]] = None,
                 package_data: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_files: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationProtectedFileArgs']]]] = None):
        """
        The set of arguments for constructing a Configuration resource.
        :param pulumi.Input[_builtins.str] nginx_deployment_id: The ID of the Nginx Deployment. Changing this forces a new Nginx Configuration to be created.
        :param pulumi.Input[_builtins.str] root_file: Specifies the root file path of this Nginx Configuration.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationConfigFileArgs']]] config_files: One or more `config_file` blocks as defined below.
        :param pulumi.Input[_builtins.str] package_data: Specifies the package data for this configuration.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationProtectedFileArgs']]] protected_files: One or more `protected_file` blocks with sensitive information as defined below. If specified `config_file` must also be specified.
        """
        pulumi.set(__self__, "nginx_deployment_id", nginx_deployment_id)
        pulumi.set(__self__, "root_file", root_file)
        if config_files is not None:
            pulumi.set(__self__, "config_files", config_files)
        if package_data is not None:
            pulumi.set(__self__, "package_data", package_data)
        if protected_files is not None:
            pulumi.set(__self__, "protected_files", protected_files)

    @_builtins.property
    @pulumi.getter(name="nginxDeploymentId")
    def nginx_deployment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Nginx Deployment. Changing this forces a new Nginx Configuration to be created.
        """
        return pulumi.get(self, "nginx_deployment_id")

    @nginx_deployment_id.setter
    def nginx_deployment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "nginx_deployment_id", value)

    @_builtins.property
    @pulumi.getter(name="rootFile")
    def root_file(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the root file path of this Nginx Configuration.
        """
        return pulumi.get(self, "root_file")

    @root_file.setter
    def root_file(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "root_file", value)

    @_builtins.property
    @pulumi.getter(name="configFiles")
    def config_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationConfigFileArgs']]]]:
        """
        One or more `config_file` blocks as defined below.
        """
        return pulumi.get(self, "config_files")

    @config_files.setter
    def config_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationConfigFileArgs']]]]):
        pulumi.set(self, "config_files", value)

    @_builtins.property
    @pulumi.getter(name="packageData")
    def package_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the package data for this configuration.
        """
        return pulumi.get(self, "package_data")

    @package_data.setter
    def package_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "package_data", value)

    @_builtins.property
    @pulumi.getter(name="protectedFiles")
    def protected_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationProtectedFileArgs']]]]:
        """
        One or more `protected_file` blocks with sensitive information as defined below. If specified `config_file` must also be specified.
        """
        return pulumi.get(self, "protected_files")

    @protected_files.setter
    def protected_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationProtectedFileArgs']]]]):
        pulumi.set(self, "protected_files", value)


@pulumi.input_type
class _ConfigurationState:
    def __init__(__self__, *,
                 config_files: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationConfigFileArgs']]]] = None,
                 nginx_deployment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 package_data: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_files: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationProtectedFileArgs']]]] = None,
                 root_file: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Configuration resources.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationConfigFileArgs']]] config_files: One or more `config_file` blocks as defined below.
        :param pulumi.Input[_builtins.str] nginx_deployment_id: The ID of the Nginx Deployment. Changing this forces a new Nginx Configuration to be created.
        :param pulumi.Input[_builtins.str] package_data: Specifies the package data for this configuration.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationProtectedFileArgs']]] protected_files: One or more `protected_file` blocks with sensitive information as defined below. If specified `config_file` must also be specified.
        :param pulumi.Input[_builtins.str] root_file: Specifies the root file path of this Nginx Configuration.
        """
        if config_files is not None:
            pulumi.set(__self__, "config_files", config_files)
        if nginx_deployment_id is not None:
            pulumi.set(__self__, "nginx_deployment_id", nginx_deployment_id)
        if package_data is not None:
            pulumi.set(__self__, "package_data", package_data)
        if protected_files is not None:
            pulumi.set(__self__, "protected_files", protected_files)
        if root_file is not None:
            pulumi.set(__self__, "root_file", root_file)

    @_builtins.property
    @pulumi.getter(name="configFiles")
    def config_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationConfigFileArgs']]]]:
        """
        One or more `config_file` blocks as defined below.
        """
        return pulumi.get(self, "config_files")

    @config_files.setter
    def config_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationConfigFileArgs']]]]):
        pulumi.set(self, "config_files", value)

    @_builtins.property
    @pulumi.getter(name="nginxDeploymentId")
    def nginx_deployment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Nginx Deployment. Changing this forces a new Nginx Configuration to be created.
        """
        return pulumi.get(self, "nginx_deployment_id")

    @nginx_deployment_id.setter
    def nginx_deployment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nginx_deployment_id", value)

    @_builtins.property
    @pulumi.getter(name="packageData")
    def package_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the package data for this configuration.
        """
        return pulumi.get(self, "package_data")

    @package_data.setter
    def package_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "package_data", value)

    @_builtins.property
    @pulumi.getter(name="protectedFiles")
    def protected_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationProtectedFileArgs']]]]:
        """
        One or more `protected_file` blocks with sensitive information as defined below. If specified `config_file` must also be specified.
        """
        return pulumi.get(self, "protected_files")

    @protected_files.setter
    def protected_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationProtectedFileArgs']]]]):
        pulumi.set(self, "protected_files", value)

    @_builtins.property
    @pulumi.getter(name="rootFile")
    def root_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the root file path of this Nginx Configuration.
        """
        return pulumi.get(self, "root_file")

    @root_file.setter
    def root_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "root_file", value)


@pulumi.type_token("azure:nginx/configuration:Configuration")
class Configuration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationConfigFileArgs', 'ConfigurationConfigFileArgsDict']]]]] = None,
                 nginx_deployment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 package_data: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationProtectedFileArgs', 'ConfigurationProtectedFileArgsDict']]]]] = None,
                 root_file: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages the configuration for a Nginx Deployment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            allocation_method="Static",
            sku="Standard",
            tags={
                "environment": "Production",
            })
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"],
            delegations=[{
                "name": "delegation",
                "service_delegation": {
                    "name": "NGINX.NGINXPLUS/nginxDeployments",
                    "actions": ["Microsoft.Network/virtualNetworks/subnets/join/action"],
                },
            }])
        example_deployment = azure.nginx.Deployment("example",
            name="example-nginx",
            resource_group_name=example.name,
            sku="publicpreview_Monthly_gmz7xq9ge3py",
            location=example.location,
            diagnose_support_enabled=True,
            frontend_public={
                "ip_addresses": [example_public_ip.id],
            },
            network_interfaces=[{
                "subnet_id": example_subnet.id,
            }])
        example_configuration = azure.nginx.Configuration("example",
            nginx_deployment_id=example_deployment.id,
            root_file="/etc/nginx/nginx.conf",
            config_files=[
                {
                    "content": std.base64encode(input=\"\"\"http {
            server {
                listen 80;
                location / {
                    default_type text/html;
                    return 200 '<!doctype html><html lang="en"><head></head><body>
                        <div>this one will be updated</div>
                        <div>at 10:38 am</div>
                    </body></html>';
                }
                include site/*.conf;
            }
        }
        \"\"\").result,
                    "virtual_path": "/etc/nginx/nginx.conf",
                },
                {
                    "content": std.base64encode(input=\"\"\"location /bbb {
         default_type text/html;
         return 200 '<!doctype html><html lang="en"><head></head><body>
          <div>this one will be updated</div>
          <div>at 10:38 am</div>
         </body></html>';
        }
        \"\"\").result,
                    "virtual_path": "/etc/nginx/site/b.conf",
                },
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Nginx.NginxPlus` - 2024-11-01-preview

        ## Import

        An Nginx Configuration can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:nginx/configuration:Configuration example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Nginx.NginxPlus/nginxDeployments/dep1/configurations/default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationConfigFileArgs', 'ConfigurationConfigFileArgsDict']]]] config_files: One or more `config_file` blocks as defined below.
        :param pulumi.Input[_builtins.str] nginx_deployment_id: The ID of the Nginx Deployment. Changing this forces a new Nginx Configuration to be created.
        :param pulumi.Input[_builtins.str] package_data: Specifies the package data for this configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationProtectedFileArgs', 'ConfigurationProtectedFileArgsDict']]]] protected_files: One or more `protected_file` blocks with sensitive information as defined below. If specified `config_file` must also be specified.
        :param pulumi.Input[_builtins.str] root_file: Specifies the root file path of this Nginx Configuration.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the configuration for a Nginx Deployment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            allocation_method="Static",
            sku="Standard",
            tags={
                "environment": "Production",
            })
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"],
            delegations=[{
                "name": "delegation",
                "service_delegation": {
                    "name": "NGINX.NGINXPLUS/nginxDeployments",
                    "actions": ["Microsoft.Network/virtualNetworks/subnets/join/action"],
                },
            }])
        example_deployment = azure.nginx.Deployment("example",
            name="example-nginx",
            resource_group_name=example.name,
            sku="publicpreview_Monthly_gmz7xq9ge3py",
            location=example.location,
            diagnose_support_enabled=True,
            frontend_public={
                "ip_addresses": [example_public_ip.id],
            },
            network_interfaces=[{
                "subnet_id": example_subnet.id,
            }])
        example_configuration = azure.nginx.Configuration("example",
            nginx_deployment_id=example_deployment.id,
            root_file="/etc/nginx/nginx.conf",
            config_files=[
                {
                    "content": std.base64encode(input=\"\"\"http {
            server {
                listen 80;
                location / {
                    default_type text/html;
                    return 200 '<!doctype html><html lang="en"><head></head><body>
                        <div>this one will be updated</div>
                        <div>at 10:38 am</div>
                    </body></html>';
                }
                include site/*.conf;
            }
        }
        \"\"\").result,
                    "virtual_path": "/etc/nginx/nginx.conf",
                },
                {
                    "content": std.base64encode(input=\"\"\"location /bbb {
         default_type text/html;
         return 200 '<!doctype html><html lang="en"><head></head><body>
          <div>this one will be updated</div>
          <div>at 10:38 am</div>
         </body></html>';
        }
        \"\"\").result,
                    "virtual_path": "/etc/nginx/site/b.conf",
                },
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Nginx.NginxPlus` - 2024-11-01-preview

        ## Import

        An Nginx Configuration can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:nginx/configuration:Configuration example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Nginx.NginxPlus/nginxDeployments/dep1/configurations/default
        ```

        :param str resource_name: The name of the resource.
        :param ConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationConfigFileArgs', 'ConfigurationConfigFileArgsDict']]]]] = None,
                 nginx_deployment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 package_data: Optional[pulumi.Input[_builtins.str]] = None,
                 protected_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationProtectedFileArgs', 'ConfigurationProtectedFileArgsDict']]]]] = None,
                 root_file: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigurationArgs.__new__(ConfigurationArgs)

            __props__.__dict__["config_files"] = config_files
            if nginx_deployment_id is None and not opts.urn:
                raise TypeError("Missing required property 'nginx_deployment_id'")
            __props__.__dict__["nginx_deployment_id"] = nginx_deployment_id
            __props__.__dict__["package_data"] = package_data
            __props__.__dict__["protected_files"] = protected_files
            if root_file is None and not opts.urn:
                raise TypeError("Missing required property 'root_file'")
            __props__.__dict__["root_file"] = root_file
        super(Configuration, __self__).__init__(
            'azure:nginx/configuration:Configuration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationConfigFileArgs', 'ConfigurationConfigFileArgsDict']]]]] = None,
            nginx_deployment_id: Optional[pulumi.Input[_builtins.str]] = None,
            package_data: Optional[pulumi.Input[_builtins.str]] = None,
            protected_files: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationProtectedFileArgs', 'ConfigurationProtectedFileArgsDict']]]]] = None,
            root_file: Optional[pulumi.Input[_builtins.str]] = None) -> 'Configuration':
        """
        Get an existing Configuration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationConfigFileArgs', 'ConfigurationConfigFileArgsDict']]]] config_files: One or more `config_file` blocks as defined below.
        :param pulumi.Input[_builtins.str] nginx_deployment_id: The ID of the Nginx Deployment. Changing this forces a new Nginx Configuration to be created.
        :param pulumi.Input[_builtins.str] package_data: Specifies the package data for this configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationProtectedFileArgs', 'ConfigurationProtectedFileArgsDict']]]] protected_files: One or more `protected_file` blocks with sensitive information as defined below. If specified `config_file` must also be specified.
        :param pulumi.Input[_builtins.str] root_file: Specifies the root file path of this Nginx Configuration.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigurationState.__new__(_ConfigurationState)

        __props__.__dict__["config_files"] = config_files
        __props__.__dict__["nginx_deployment_id"] = nginx_deployment_id
        __props__.__dict__["package_data"] = package_data
        __props__.__dict__["protected_files"] = protected_files
        __props__.__dict__["root_file"] = root_file
        return Configuration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configFiles")
    def config_files(self) -> pulumi.Output[Optional[Sequence['outputs.ConfigurationConfigFile']]]:
        """
        One or more `config_file` blocks as defined below.
        """
        return pulumi.get(self, "config_files")

    @_builtins.property
    @pulumi.getter(name="nginxDeploymentId")
    def nginx_deployment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Nginx Deployment. Changing this forces a new Nginx Configuration to be created.
        """
        return pulumi.get(self, "nginx_deployment_id")

    @_builtins.property
    @pulumi.getter(name="packageData")
    def package_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the package data for this configuration.
        """
        return pulumi.get(self, "package_data")

    @_builtins.property
    @pulumi.getter(name="protectedFiles")
    def protected_files(self) -> pulumi.Output[Optional[Sequence['outputs.ConfigurationProtectedFile']]]:
        """
        One or more `protected_file` blocks with sensitive information as defined below. If specified `config_file` must also be specified.
        """
        return pulumi.get(self, "protected_files")

    @_builtins.property
    @pulumi.getter(name="rootFile")
    def root_file(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the root file path of this Nginx Configuration.
        """
        return pulumi.get(self, "root_file")

